/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Process;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructCapUserData;
import android.system.StructCapUserHeader;
import android.util.Slog;
import android.util.TimingsTraceLog;
import com.android.internal.os.RuntimeInit;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteInit;
import dalvik.system.VMRuntime;
import java.io.DataOutputStream;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WrapperInit
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "AndroidRuntime";

    private void $$robo$$com_android_internal_os_WrapperInit$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_os_WrapperInit$main(String[] args) {
        int fdNum = Integer.parseInt(args[0], 10);
        int targetSdkVersion = Integer.parseInt(args[1], 10);
        if (fdNum != 0) {
            try {
                FileDescriptor fd = new FileDescriptor();
                InvokeDynamicSupport.bootstrapIntrinsic("setInt$", "java.io.FileDescriptor", (FileDescriptor)fd, (int)fdNum);
                DataOutputStream os = new DataOutputStream(new FileOutputStream(fd));
                os.writeInt(Process.myPid());
                os.close();
                IoUtils.closeQuietly(fd);
            }
            catch (IOException ex) {
                Slog.d("AndroidRuntime", "Could not write pid of wrapped process to Zygote pipe.", ex);
            }
        }
        ZygoteInit.preload(new TimingsTraceLog("WrapperInitTiming", 16384L));
        String[] runtimeArgs = new String[args.length - 2];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)args, (int)2, (Object)runtimeArgs, (int)0, (int)runtimeArgs.length);
        Runnable r = WrapperInit.wrapperInit(targetSdkVersion, runtimeArgs);
        r.run();
    }

    private static final void $$robo$$com_android_internal_os_WrapperInit$execApplication(String invokeWith, String niceName, int targetSdkVersion, String instructionSet, FileDescriptor pipeFd, String[] args) {
        StringBuilder command = new StringBuilder(invokeWith);
        String appProcess = VMRuntime.is64BitInstructionSet(instructionSet) ? "/system/bin/app_process64" : "/system/bin/app_process32";
        command.append(' ');
        command.append(appProcess);
        command.append(" /system/bin --application");
        if (niceName != null) {
            command.append(" '--nice-name=").append(niceName).append("'");
        }
        command.append(" com.android.internal.os.WrapperInit ");
        command.append((int)(pipeFd != null ? InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)pipeFd) : false));
        command.append(' ');
        command.append(targetSdkVersion);
        Zygote.appendQuotedShellArgs(command, args);
        WrapperInit.preserveCapabilities();
        Zygote.execShell(command.toString());
    }

    private static final Runnable $$robo$$com_android_internal_os_WrapperInit$wrapperInit(int targetSdkVersion, String[] argv) {
        ClassLoader classLoader = null;
        if (argv != null && argv.length > 2 && argv[0].equals("-cp")) {
            classLoader = ZygoteInit.createPathClassLoader(argv[1], targetSdkVersion);
            Thread.currentThread().setContextClassLoader(classLoader);
            String[] removedArgs = new String[argv.length - 2];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)argv, (int)2, (Object)removedArgs, (int)0, (int)(argv.length - 2));
            argv = removedArgs;
        }
        Zygote.nativePreApplicationInit();
        return RuntimeInit.applicationInit(targetSdkVersion, argv, classLoader);
    }

    private static final void $$robo$$com_android_internal_os_WrapperInit$preserveCapabilities() {
        StructCapUserData[] data;
        StructCapUserHeader header = new StructCapUserHeader(OsConstants._LINUX_CAPABILITY_VERSION_3, 0);
        try {
            data = Os.capget(header);
        }
        catch (ErrnoException e) {
            Slog.e("AndroidRuntime", "RuntimeInit: Failed capget", e);
            return;
        }
        if (data[0].permitted != data[0].inheritable || data[1].permitted != data[1].inheritable) {
            data[0] = new StructCapUserData(data[0].effective, data[0].permitted, data[0].permitted);
            data[1] = new StructCapUserData(data[1].effective, data[1].permitted, data[1].permitted);
            try {
                Os.capset(header, data);
            }
            catch (ErrnoException e) {
                Slog.e("AndroidRuntime", "RuntimeInit: Failed capset", e);
                return;
            }
        }
        for (int i = 0; i < 64; ++i) {
            int dataIndex = OsConstants.CAP_TO_INDEX(i);
            int capMask = OsConstants.CAP_TO_MASK(i);
            if ((data[dataIndex].inheritable & capMask) == 0) continue;
            try {
                Os.prctl(OsConstants.PR_CAP_AMBIENT, OsConstants.PR_CAP_AMBIENT_RAISE, i, 0L, 0L);
                continue;
            }
            catch (ErrnoException ex) {
                Slog.e("AndroidRuntime", "RuntimeInit: Failed to raise ambient capability " + i, ex);
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_os_WrapperInit$__constructor__();
    }

    private WrapperInit() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_WrapperInit$__constructor__(), 0, this);
    }

    public static void main(String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("main", $$robo$$com_android_internal_os_WrapperInit$main(java.lang.String[] ), 0, (String[])stringArray);
    }

    public static void execApplication(String string2, String string3, int n, String string4, FileDescriptor fileDescriptor, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("execApplication", $$robo$$com_android_internal_os_WrapperInit$execApplication(java.lang.String java.lang.String int java.lang.String java.io.FileDescriptor java.lang.String[] ), 0, (String)string2, (String)string3, (int)n, (String)string4, (FileDescriptor)fileDescriptor, (String[])stringArray);
    }

    private static Runnable wrapperInit(int n, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("wrapperInit", $$robo$$com_android_internal_os_WrapperInit$wrapperInit(int java.lang.String[] ), 0, (int)n, (String[])stringArray);
    }

    private static void preserveCapabilities() {
        InvokeDynamicSupport.bootstrapStatic("preserveCapabilities", $$robo$$com_android_internal_os_WrapperInit$preserveCapabilities(), 0);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WrapperInit)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

