/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.provider.Telephony;
import android.telephony.SmsMessage;
import android.util.ArrayMap;
import android.util.Base64;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.security.SecureRandom;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AppSmsManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "AppSmsManager";
    private SecureRandom mRandom;
    private Context mContext;
    private Object mLock;
    @GuardedBy(value="mLock")
    private Map<String, AppRequestInfo> mTokenMap;
    @GuardedBy(value="mLock")
    private Map<String, AppRequestInfo> mPackageMap;

    private void $$robo$$com_android_internal_telephony_AppSmsManager$__constructor__(Context context) {
        this.mLock = new Object();
        this.mRandom = new SecureRandom();
        this.mTokenMap = new ArrayMap<String, AppRequestInfo>();
        this.mPackageMap = new ArrayMap<String, AppRequestInfo>();
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_AppSmsManager$createAppSpecificSmsToken(String callingPkg, PendingIntent intent) {
        AppOpsManager appOps = (AppOpsManager)this.mContext.getSystemService("appops");
        appOps.checkPackage(Binder.getCallingUid(), callingPkg);
        String token = this.generateNonce();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPackageMap.containsKey(callingPkg)) {
                this.removeRequestLocked(this.mPackageMap.get(callingPkg));
            }
            AppRequestInfo info = new AppRequestInfo(this, callingPkg, intent, token);
            this.addRequestLocked(info);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_AppSmsManager$handleSmsReceivedIntent(Intent intent) {
        if (intent.getAction() != "android.provider.Telephony.SMS_DELIVER") {
            Log.wtf("AppSmsManager", "Got intent with incorrect action: " + intent.getAction());
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            AppRequestInfo info = this.findAppRequestInfoSmsIntentLocked(intent);
            if (info == null) {
                return false;
            }
            try {
                Intent fillIn = new Intent();
                fillIn.putExtras(intent.getExtras());
                info.pendingIntent.send(this.mContext, 0, fillIn);
            }
            catch (PendingIntent.CanceledException e) {
                this.removeRequestLocked(info);
                return false;
            }
            this.removeRequestLocked(info);
            return true;
        }
    }

    private final AppRequestInfo $$robo$$com_android_internal_telephony_AppSmsManager$findAppRequestInfoSmsIntentLocked(Intent intent) {
        SmsMessage[] messages = Telephony.Sms.Intents.getMessagesFromIntent(intent);
        if (messages == null) {
            return null;
        }
        StringBuilder fullMessageBuilder = new StringBuilder();
        for (SmsMessage message : messages) {
            if (message == null || message.getMessageBody() == null) continue;
            fullMessageBuilder.append(message.getMessageBody());
        }
        String fullMessage = fullMessageBuilder.toString();
        for (String token : this.mTokenMap.keySet()) {
            if (!fullMessage.contains(token)) continue;
            return this.mTokenMap.get(token);
        }
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_AppSmsManager$generateNonce() {
        byte[] bytes = new byte[8];
        this.mRandom.nextBytes(bytes);
        return Base64.encodeToString(bytes, 11);
    }

    private final void $$robo$$com_android_internal_telephony_AppSmsManager$removeRequestLocked(AppRequestInfo info) {
        this.mTokenMap.remove(info.token);
        this.mPackageMap.remove(info.packageName);
    }

    private final void $$robo$$com_android_internal_telephony_AppSmsManager$addRequestLocked(AppRequestInfo info) {
        this.mTokenMap.put(info.token, info);
        this.mPackageMap.put(info.packageName, info);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_telephony_AppSmsManager$__constructor__(context);
    }

    public AppSmsManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_AppSmsManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public String createAppSpecificSmsToken(String string2, PendingIntent pendingIntent) {
        return InvokeDynamicSupport.bootstrap("createAppSpecificSmsToken", $$robo$$com_android_internal_telephony_AppSmsManager$createAppSpecificSmsToken(java.lang.String android.app.PendingIntent ), 0, this, string2, pendingIntent);
    }

    public boolean handleSmsReceivedIntent(Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleSmsReceivedIntent", $$robo$$com_android_internal_telephony_AppSmsManager$handleSmsReceivedIntent(android.content.Intent ), 0, this, intent);
    }

    private AppRequestInfo findAppRequestInfoSmsIntentLocked(Intent intent) {
        return InvokeDynamicSupport.bootstrap("findAppRequestInfoSmsIntentLocked", $$robo$$com_android_internal_telephony_AppSmsManager$findAppRequestInfoSmsIntentLocked(android.content.Intent ), 0, this, intent);
    }

    private String generateNonce() {
        return InvokeDynamicSupport.bootstrap("generateNonce", $$robo$$com_android_internal_telephony_AppSmsManager$generateNonce(), 0, this);
    }

    private void removeRequestLocked(AppRequestInfo appRequestInfo) {
        InvokeDynamicSupport.bootstrap("removeRequestLocked", $$robo$$com_android_internal_telephony_AppSmsManager$removeRequestLocked(com.android.internal.telephony.AppSmsManager$AppRequestInfo ), 0, this, appRequestInfo);
    }

    private void addRequestLocked(AppRequestInfo appRequestInfo) {
        InvokeDynamicSupport.bootstrap("addRequestLocked", $$robo$$com_android_internal_telephony_AppSmsManager$addRequestLocked(com.android.internal.telephony.AppSmsManager$AppRequestInfo ), 0, this, appRequestInfo);
    }

    public /* synthetic */ AppSmsManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppSmsManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private final class AppRequestInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String packageName;
        public PendingIntent pendingIntent;
        public String token;
        /* synthetic */ AppSmsManager this$0;

        private void $$robo$$com_android_internal_telephony_AppSmsManager_AppRequestInfo$__constructor__(AppSmsManager appSmsManager, String packageName, PendingIntent pendingIntent, String token) {
            this.packageName = packageName;
            this.pendingIntent = pendingIntent;
            this.token = token;
        }

        private void __constructor__(AppSmsManager appSmsManager, String string2, PendingIntent pendingIntent, String string3) {
            this.$$robo$$com_android_internal_telephony_AppSmsManager_AppRequestInfo$__constructor__(appSmsManager, string2, pendingIntent, string3);
        }

        AppRequestInfo(AppSmsManager appSmsManager, String string2, PendingIntent pendingIntent, String string3) {
            this.this$0 = appSmsManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_AppSmsManager_AppRequestInfo$__constructor__(com.android.internal.telephony.AppSmsManager java.lang.String android.app.PendingIntent java.lang.String ), 0, this, appSmsManager, string2, pendingIntent, string3);
        }

        public /* synthetic */ AppRequestInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppRequestInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

