/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteConstraintException;
import android.provider.Telephony;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CarrierInfoManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "CarrierInfoManager";

    private void $$robo$$com_android_internal_telephony_CarrierInfoManager$__constructor__() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ImsiEncryptionInfo $$robo$$com_android_internal_telephony_CarrierInfoManager$getCarrierInfoForImsiEncryption(int keyType, Context mContext) {
        String mcc = "";
        String mnc = "";
        TelephonyManager telephonyManager = (TelephonyManager)mContext.getSystemService("phone");
        String networkOperator = telephonyManager.getNetworkOperator();
        if (TextUtils.isEmpty(networkOperator)) {
            Log.e("CarrierInfoManager", "Invalid networkOperator: " + networkOperator);
            return null;
        }
        mcc = networkOperator.substring(0, 3);
        mnc = networkOperator.substring(3);
        Log.i("CarrierInfoManager", "using values for mnc, mcc: " + mnc + "," + mcc);
        try (Cursor findCursor = null;){
            ContentResolver mContentResolver = mContext.getContentResolver();
            String[] columns = new String[]{"public_key", "expiration_time", "key_identifier"};
            findCursor = mContentResolver.query(Telephony.CarrierColumns.CONTENT_URI, columns, "mcc=? and mnc=? and key_type=?", new String[]{mcc, mnc, String.valueOf(keyType)}, null);
            if (findCursor == null || !findCursor.moveToFirst()) {
                Log.d("CarrierInfoManager", "No rows found for keyType: " + keyType);
                ImsiEncryptionInfo imsiEncryptionInfo = null;
                return imsiEncryptionInfo;
            }
            if (findCursor.getCount() > 1) {
                Log.e("CarrierInfoManager", "More than 1 row found for the keyType: " + keyType);
            }
            byte[] carrier_key = findCursor.getBlob(0);
            Date expirationTime = new Date(findCursor.getLong(1));
            String keyIdentifier = findCursor.getString(2);
            ImsiEncryptionInfo imsiEncryptionInfo = new ImsiEncryptionInfo(mcc, mnc, keyType, keyIdentifier, carrier_key, expirationTime);
            return imsiEncryptionInfo;
        }
        return null;
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierInfoManager$updateOrInsertCarrierKey(ImsiEncryptionInfo imsiEncryptionInfo, Context mContext) {
        byte[] keyBytes = imsiEncryptionInfo.getPublicKey().getEncoded();
        ContentResolver mContentResolver = mContext.getContentResolver();
        ContentValues contentValues = new ContentValues();
        contentValues.put("mcc", imsiEncryptionInfo.getMcc());
        contentValues.put("mnc", imsiEncryptionInfo.getMnc());
        contentValues.put("key_type", imsiEncryptionInfo.getKeyType());
        contentValues.put("key_identifier", imsiEncryptionInfo.getKeyIdentifier());
        contentValues.put("public_key", keyBytes);
        contentValues.put("expiration_time", imsiEncryptionInfo.getExpirationTime().getTime());
        try {
            Log.i("CarrierInfoManager", "Inserting imsiEncryptionInfo into db");
            mContentResolver.insert(Telephony.CarrierColumns.CONTENT_URI, contentValues);
        }
        catch (SQLiteConstraintException e) {
            Log.i("CarrierInfoManager", "Insert failed, updating imsiEncryptionInfo into db");
            ContentValues updatedValues = new ContentValues();
            updatedValues.put("public_key", keyBytes);
            updatedValues.put("expiration_time", imsiEncryptionInfo.getExpirationTime().getTime());
            updatedValues.put("key_identifier", imsiEncryptionInfo.getKeyIdentifier());
            try {
                int nRows = mContentResolver.update(Telephony.CarrierColumns.CONTENT_URI, updatedValues, "mcc=? and mnc=? and key_type=?", new String[]{imsiEncryptionInfo.getMcc(), imsiEncryptionInfo.getMnc(), String.valueOf(imsiEncryptionInfo.getKeyType())});
                if (nRows == 0) {
                    Log.d("CarrierInfoManager", "Error updating values:" + imsiEncryptionInfo);
                }
            }
            catch (Exception ex) {
                Log.d("CarrierInfoManager", "Error updating values:" + imsiEncryptionInfo + ex);
            }
        }
        catch (Exception e) {
            Log.d("CarrierInfoManager", "Error inserting/updating values:" + imsiEncryptionInfo + e);
        }
    }

    private static final void $$robo$$com_android_internal_telephony_CarrierInfoManager$setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo, Context mContext) {
        Log.i("CarrierInfoManager", "inserting carrier key: " + imsiEncryptionInfo);
        CarrierInfoManager.updateOrInsertCarrierKey(imsiEncryptionInfo, mContext);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_CarrierInfoManager$__constructor__();
    }

    public CarrierInfoManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_CarrierInfoManager$__constructor__(), 0, this);
    }

    public static ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int n, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_CarrierInfoManager$getCarrierInfoForImsiEncryption(int android.content.Context ), 0, (int)n, (Context)context);
    }

    public static void updateOrInsertCarrierKey(ImsiEncryptionInfo imsiEncryptionInfo, Context context) {
        InvokeDynamicSupport.bootstrapStatic("updateOrInsertCarrierKey", $$robo$$com_android_internal_telephony_CarrierInfoManager$updateOrInsertCarrierKey(android.telephony.ImsiEncryptionInfo android.content.Context ), 0, (ImsiEncryptionInfo)imsiEncryptionInfo, (Context)context);
    }

    public static void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo, Context context) {
        InvokeDynamicSupport.bootstrapStatic("setCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_CarrierInfoManager$setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo android.content.Context ), 0, (ImsiEncryptionInfo)imsiEncryptionInfo, (Context)context);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CarrierInfoManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

