/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.telephony.CarrierConfigManager;
import android.telephony.CellLocation;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.EventLog;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DriverCall;
import com.android.internal.telephony.GsmCdmaCall;
import com.android.internal.telephony.GsmCdmaConnection;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.LastCallFailCause;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaCallWaitingNotification;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GsmCdmaCallTracker
extends CallTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "GsmCdmaCallTracker";
    private static boolean REPEAT_POLLING = false;
    private static boolean DBG_POLL = false;
    private static boolean VDBG = false;
    public static int MAX_CONNECTIONS_GSM = 19;
    private static int MAX_CONNECTIONS_PER_CALL_GSM = 5;
    private static int MAX_CONNECTIONS_CDMA = 8;
    private static int MAX_CONNECTIONS_PER_CALL_CDMA = 1;
    public GsmCdmaConnection[] mConnections;
    private RegistrantList mVoiceCallEndedRegistrants;
    private RegistrantList mVoiceCallStartedRegistrants;
    private ArrayList<GsmCdmaConnection> mDroppedDuringPoll;
    public GsmCdmaCall mRingingCall;
    public GsmCdmaCall mForegroundCall;
    public GsmCdmaCall mBackgroundCall;
    private GsmCdmaConnection mPendingMO;
    private boolean mHangupPendingMO;
    private GsmCdmaPhone mPhone;
    private boolean mDesiredMute;
    public PhoneConstants.State mState;
    private TelephonyMetrics mMetrics;
    private RegistrantList mCallWaitingRegistrants;
    private boolean mPendingCallInEcm;
    private boolean mIsInEmergencyCall;
    private int mPendingCallClirMode;
    private boolean mIsEcmTimerCanceled;
    private int m3WayCallFlashDelay;
    private BroadcastReceiver mEcmExitReceiver;

    private void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$__constructor__(GsmCdmaPhone phone) {
        this.mVoiceCallEndedRegistrants = new RegistrantList();
        this.mVoiceCallStartedRegistrants = new RegistrantList();
        this.mDroppedDuringPoll = new ArrayList(19);
        this.mRingingCall = new GsmCdmaCall(this);
        this.mForegroundCall = new GsmCdmaCall(this);
        this.mBackgroundCall = new GsmCdmaCall(this);
        this.mDesiredMute = false;
        this.mState = PhoneConstants.State.IDLE;
        this.mMetrics = TelephonyMetrics.getInstance();
        this.mCallWaitingRegistrants = new RegistrantList();
        this.mEcmExitReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GsmCdmaCallTracker this$0;

            private void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_1$__constructor__(GsmCdmaCallTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_1$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED")) {
                    boolean isInEcm = intent.getBooleanExtra("phoneinECMState", false);
                    this.this$0.log("Received ACTION_EMERGENCY_CALLBACK_MODE_CHANGED isInEcm = " + isInEcm);
                    if (!isInEcm) {
                        ArrayList<Connection> toNotify = new ArrayList<Connection>();
                        toNotify.addAll(this.this$0.mRingingCall.getConnections());
                        toNotify.addAll(this.this$0.mForegroundCall.getConnections());
                        toNotify.addAll(this.this$0.mBackgroundCall.getConnections());
                        if (this.this$0.mPendingMO != null) {
                            toNotify.add(this.this$0.mPendingMO);
                        }
                        for (Connection connection : toNotify) {
                            if (connection == null) continue;
                            connection.onExitedEcmMode();
                        }
                    }
                }
            }

            private void __constructor__(GsmCdmaCallTracker gsmCdmaCallTracker) {
                this.$$robo$$com_android_internal_telephony_GsmCdmaCallTracker_1$__constructor__(gsmCdmaCallTracker);
            }
            {
                this.this$0 = gsmCdmaCallTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_1$__constructor__(com.android.internal.telephony.GsmCdmaCallTracker ), 0, this, gsmCdmaCallTracker);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPhone = phone;
        this.mCi = phone.mCi;
        this.mCi.registerForCallStateChanged(this, 2, null);
        this.mCi.registerForOn(this, 9, null);
        this.mCi.registerForNotAvailable(this, 10, null);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        this.mPhone.getContext().registerReceiver(this.mEcmExitReceiver, filter);
        this.updatePhoneType(true);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updatePhoneType() {
        this.updatePhoneType(false);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updatePhoneType(boolean duringInit) {
        if (!duringInit) {
            this.reset();
            this.pollCallsWhenSafe();
        }
        if (this.mPhone.isPhoneTypeGsm()) {
            this.mConnections = new GsmCdmaConnection[19];
            this.mCi.unregisterForCallWaitingInfo(this);
            if (this.mIsInEmergencyCall) {
                this.mPhone.mDcTracker.setInternalDataEnabled(true);
            }
        } else {
            this.mConnections = new GsmCdmaConnection[8];
            this.mPendingCallInEcm = false;
            this.mIsInEmergencyCall = false;
            this.mPendingCallClirMode = 0;
            this.mIsEcmTimerCanceled = false;
            this.m3WayCallFlashDelay = 0;
            this.mCi.registerForCallWaitingInfo(this, 15, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$reset() {
        Rlog.d("GsmCdmaCallTracker", "reset");
        for (GsmCdmaConnection gsmCdmaConnection : this.mConnections) {
            if (gsmCdmaConnection == null) continue;
            gsmCdmaConnection.onDisconnect(36);
            gsmCdmaConnection.dispose();
        }
        if (this.mPendingMO != null) {
            this.mPendingMO.dispose();
        }
        this.mConnections = null;
        this.mPendingMO = null;
        this.clearDisconnected();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$finalize() {
        Rlog.d("GsmCdmaCallTracker", "GsmCdmaCallTracker finalized");
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$registerForVoiceCallStarted(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallStartedRegistrants.add(r);
        if (this.mState != PhoneConstants.State.IDLE) {
            r.notifyRegistrant(new AsyncResult(null, null, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$unregisterForVoiceCallStarted(Handler h) {
        this.mVoiceCallStartedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$registerForVoiceCallEnded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mVoiceCallEndedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$unregisterForVoiceCallEnded(Handler h) {
        this.mVoiceCallEndedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$registerForCallWaiting(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mCallWaitingRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$unregisterForCallWaiting(Handler h) {
        this.mCallWaitingRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$fakeHoldForegroundBeforeDial() {
        List connCopy = (List)this.mForegroundCall.mConnections.clone();
        int s = connCopy.size();
        for (int i = 0; i < s; ++i) {
            GsmCdmaConnection conn = (GsmCdmaConnection)connCopy.get(i);
            conn.fakeHoldBeforeDial();
        }
    }

    private final synchronized Connection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(String dialString, int clirMode, UUSInfo uusInfo, Bundle intentExtras) throws CallStateException {
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        String origNumber = dialString;
        dialString = this.convertNumberIfNecessary(this.mPhone, dialString);
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            this.switchWaitingOrHoldingAndActive();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fakeHoldForegroundBeforeDial();
        }
        if (this.mForegroundCall.getState() != Call.State.IDLE) {
            throw new CallStateException("cannot dial in current state");
        }
        boolean isEmergencyCall = PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString);
        this.mPendingMO = new GsmCdmaConnection(this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyCall);
        this.mHangupPendingMO = false;
        this.mMetrics.writeRilDial(this.mPhone.getPhoneId(), this.mPendingMO, clirMode, uusInfo);
        if (this.mPendingMO.getAddress() == null || this.mPendingMO.getAddress().length() == 0 || this.mPendingMO.getAddress().indexOf(78) >= 0) {
            this.mPendingMO.mCause = 7;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.mCi.dial(this.mPendingMO.getAddress(), clirMode, uusInfo, this.obtainCompleteMessage());
        }
        if (this.mNumberConverted) {
            this.mPendingMO.setConverted(origNumber);
            this.mNumberConverted = false;
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleEcmTimer(int action) {
        this.mPhone.handleTimerInEmergencyCallbackMode(action);
        switch (action) {
            case 1: {
                this.mIsEcmTimerCanceled = true;
                break;
            }
            case 0: {
                this.mIsEcmTimerCanceled = false;
                break;
            }
            default: {
                Rlog.e("GsmCdmaCallTracker", "handleEcmTimer, unsupported action " + action);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$disableDataCallInEmergencyCall(String dialString) {
        if (PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString)) {
            this.log("disableDataCallInEmergencyCall");
            this.setIsInEmergencyCall();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$setIsInEmergencyCall() {
        this.mIsInEmergencyCall = true;
        this.mPhone.mDcTracker.setInternalDataEnabled(false);
        this.mPhone.notifyEmergencyCallRegistrants(true);
        this.mPhone.sendEmergencyCallStateChange(true);
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(String dialString, int clirMode) throws CallStateException {
        boolean internationalRoaming;
        this.clearDisconnected();
        if (!this.canDial()) {
            throw new CallStateException("cannot dial in current state");
        }
        TelephonyManager tm = (TelephonyManager)this.mPhone.getContext().getSystemService("phone");
        String origNumber = dialString;
        String operatorIsoContry = tm.getNetworkCountryIsoForPhone(this.mPhone.getPhoneId());
        String simIsoContry = tm.getSimCountryIsoForPhone(this.mPhone.getPhoneId());
        boolean bl = internationalRoaming = !TextUtils.isEmpty(operatorIsoContry) && !TextUtils.isEmpty(simIsoContry) && !simIsoContry.equals(operatorIsoContry);
        if (internationalRoaming) {
            if ("us".equals(simIsoContry)) {
                internationalRoaming = internationalRoaming && !"vi".equals(operatorIsoContry);
            } else if ("vi".equals(simIsoContry)) {
                boolean bl2 = internationalRoaming = internationalRoaming && !"us".equals(operatorIsoContry);
            }
        }
        if (internationalRoaming) {
            dialString = this.convertNumberIfNecessary(this.mPhone, dialString);
        }
        boolean isPhoneInEcmMode = this.mPhone.isInEcm();
        boolean isEmergencyCall = PhoneNumberUtils.isLocalEmergencyNumber(this.mPhone.getContext(), dialString);
        if (isPhoneInEcmMode && isEmergencyCall) {
            this.handleEcmTimer(1);
        }
        if (this.mForegroundCall.getState() == Call.State.ACTIVE) {
            return this.dialThreeWay(dialString);
        }
        this.mPendingMO = new GsmCdmaConnection(this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, isEmergencyCall);
        this.mHangupPendingMO = false;
        if (this.mPendingMO.getAddress() == null || this.mPendingMO.getAddress().length() == 0 || this.mPendingMO.getAddress().indexOf(78) >= 0) {
            this.mPendingMO.mCause = 7;
            this.pollCallsWhenSafe();
        } else {
            this.setMute(false);
            this.disableDataCallInEmergencyCall(dialString);
            if (!isPhoneInEcmMode || isPhoneInEcmMode && isEmergencyCall) {
                this.mCi.dial(this.mPendingMO.getAddress(), clirMode, this.obtainCompleteMessage());
            } else {
                this.mPhone.exitEmergencyCallbackMode();
                this.mPhone.setOnEcbModeExitResponse(this, 14, null);
                this.mPendingCallClirMode = clirMode;
                this.mPendingCallInEcm = true;
            }
        }
        if (this.mNumberConverted) {
            this.mPendingMO.setConverted(origNumber);
            this.mNumberConverted = false;
        }
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
        return this.mPendingMO;
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dialThreeWay(String dialString) {
        if (!this.mForegroundCall.isIdle()) {
            this.disableDataCallInEmergencyCall(dialString);
            this.mPendingMO = new GsmCdmaConnection(this.mPhone, this.checkForTestEmergencyNumber(dialString), this, this.mForegroundCall, this.mIsInEmergencyCall);
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            PersistableBundle bundle = configManager.getConfig();
            this.m3WayCallFlashDelay = bundle != null ? bundle.getInt("cdma_3waycall_flash_delay_int") : 0;
            if (this.m3WayCallFlashDelay > 0) {
                this.mCi.sendCDMAFeatureCode("", this.obtainMessage(20));
            } else {
                this.mCi.sendCDMAFeatureCode(this.mPendingMO.getAddress(), this.obtainMessage(16));
            }
            return this.mPendingMO;
        }
        return null;
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(String dialString) throws CallStateException {
        if (this.isPhoneTypeGsm()) {
            return this.dial(dialString, 0, null);
        }
        return this.dial(dialString, 0);
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(String dialString, UUSInfo uusInfo, Bundle intentExtras) throws CallStateException {
        return this.dial(dialString, 0, uusInfo, intentExtras);
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(String dialString, int clirMode, Bundle intentExtras) throws CallStateException {
        return this.dial(dialString, clirMode, null, intentExtras);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$acceptCall() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            Rlog.i("phone", "acceptCall: incoming...");
            this.setMute(false);
            this.mCi.acceptCall(this.obtainCompleteMessage());
        } else if (this.mRingingCall.getState() == Call.State.WAITING) {
            if (this.isPhoneTypeGsm()) {
                this.setMute(false);
            } else {
                GsmCdmaConnection cwConn = (GsmCdmaConnection)this.mRingingCall.getLatestConnection();
                cwConn.updateParent(this.mRingingCall, this.mForegroundCall);
                cwConn.onConnectedInOrOut();
                this.updatePhoneState();
            }
            this.switchWaitingOrHoldingAndActive();
        } else {
            throw new CallStateException("phone not ringing");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$rejectCall() throws CallStateException {
        if (!this.mRingingCall.getState().isRinging()) {
            throw new CallStateException("phone not ringing");
        }
        this.mCi.rejectCall(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$flashAndSetGenericTrue() {
        this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$switchWaitingOrHoldingAndActive() throws CallStateException {
        if (this.mRingingCall.getState() == Call.State.INCOMING) {
            throw new CallStateException("cannot be in the incoming state");
        }
        if (this.isPhoneTypeGsm()) {
            this.mCi.switchWaitingOrHoldingAndActive(this.obtainCompleteMessage(8));
        } else if (this.mForegroundCall.getConnections().size() > 1) {
            this.flashAndSetGenericTrue();
        } else {
            this.mCi.sendCDMAFeatureCode("", this.obtainMessage(8));
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$conference() {
        if (this.isPhoneTypeGsm()) {
            this.mCi.conference(this.obtainCompleteMessage(11));
        } else {
            this.flashAndSetGenericTrue();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$explicitCallTransfer() {
        this.mCi.explicitCallTransfer(this.obtainCompleteMessage(13));
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$clearDisconnected() {
        this.internalClearDisconnected();
        this.updatePhoneState();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$canConference() {
        return this.mForegroundCall.getState() == Call.State.ACTIVE && this.mBackgroundCall.getState() == Call.State.HOLDING && !this.mBackgroundCall.isFull() && !this.mForegroundCall.isFull();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$canDial() {
        boolean ret;
        int serviceState = this.mPhone.getServiceState().getState();
        String disableCall = SystemProperties.get("ro.telephony.disable-call", "false");
        boolean bl = ret = serviceState != 3 && this.mPendingMO == null && !this.mRingingCall.isRinging() && !disableCall.equals("true") && (!this.mForegroundCall.getState().isAlive() || !this.mBackgroundCall.getState().isAlive() || !this.isPhoneTypeGsm() && this.mForegroundCall.getState() == Call.State.ACTIVE);
        if (!ret) {
            this.log(String.format("canDial is false\n((serviceState=%d) != ServiceState.STATE_POWER_OFF)::=%s\n&& pendingMO == null::=%s\n&& !ringingCall.isRinging()::=%s\n&& !disableCall.equals(\"true\")::=%s\n&& (!foregroundCall.getState().isAlive()::=%s\n   || foregroundCall.getState() == GsmCdmaCall.State.ACTIVE::=%s\n   ||!backgroundCall.getState().isAlive())::=%s)", serviceState, serviceState != 3, this.mPendingMO == null, !this.mRingingCall.isRinging(), !disableCall.equals("true"), !this.mForegroundCall.getState().isAlive(), this.mForegroundCall.getState() == Call.State.ACTIVE, !this.mBackgroundCall.getState().isAlive()));
        }
        return ret;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$canTransfer() {
        if (this.isPhoneTypeGsm()) {
            return (this.mForegroundCall.getState() == Call.State.ACTIVE || this.mForegroundCall.getState() == Call.State.ALERTING || this.mForegroundCall.getState() == Call.State.DIALING) && this.mBackgroundCall.getState() == Call.State.HOLDING;
        }
        Rlog.e("GsmCdmaCallTracker", "canTransfer: not possible in CDMA");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$internalClearDisconnected() {
        this.mRingingCall.clearDisconnected();
        this.mForegroundCall.clearDisconnected();
        this.mBackgroundCall.clearDisconnected();
    }

    private final Message $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$obtainCompleteMessage() {
        return this.obtainCompleteMessage(4);
    }

    private final Message $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$obtainCompleteMessage(int what) {
        ++this.mPendingOperations;
        this.mLastRelevantPoll = null;
        this.mNeedsPoll = true;
        return this.obtainMessage(what);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$operationComplete() {
        --this.mPendingOperations;
        if (this.mPendingOperations == 0 && this.mNeedsPoll) {
            this.mLastRelevantPoll = this.obtainMessage(1);
            this.mCi.getCurrentCalls(this.mLastRelevantPoll);
        } else if (this.mPendingOperations < 0) {
            Rlog.e("GsmCdmaCallTracker", "GsmCdmaCallTracker.pendingOperations < 0");
            this.mPendingOperations = 0;
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updatePhoneState() {
        PhoneConstants.State oldState = this.mState;
        if (this.mRingingCall.isRinging()) {
            this.mState = PhoneConstants.State.RINGING;
        } else if (this.mPendingMO != null || !this.mForegroundCall.isIdle() || !this.mBackgroundCall.isIdle()) {
            this.mState = PhoneConstants.State.OFFHOOK;
        } else {
            Phone imsPhone = this.mPhone.getImsPhone();
            if (this.mState == PhoneConstants.State.OFFHOOK && imsPhone != null) {
                imsPhone.callEndCleanupHandOverCallIfAny();
            }
            this.mState = PhoneConstants.State.IDLE;
        }
        if (this.mState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallEndedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        } else if (oldState == PhoneConstants.State.IDLE && oldState != this.mState) {
            this.mVoiceCallStartedRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
        this.log("update phone state, old=" + (Object)((Object)oldState) + " new=" + (Object)((Object)this.mState));
        if (this.mState != oldState) {
            this.mPhone.notifyPhoneStateChanged();
            this.mMetrics.writePhoneState(this.mPhone.getPhoneId(), this.mState);
        }
    }

    private final synchronized void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handlePollCalls(AsyncResult ar) {
        Phone imsPhone;
        ArrayList polledCalls;
        if (ar.exception == null) {
            polledCalls = (ArrayList)ar.result;
        } else if (this.isCommandExceptionRadioNotAvailable(ar.exception)) {
            polledCalls = new ArrayList();
        } else {
            this.pollCallsAfterDelay();
            return;
        }
        Connection newRinging = null;
        ArrayList<GsmCdmaConnection> newUnknownConnectionsGsm = new ArrayList<GsmCdmaConnection>();
        GsmCdmaConnection newUnknownConnectionCdma = null;
        boolean hasNonHangupStateChanged = false;
        boolean hasAnyCallDisconnected = false;
        boolean needsPollDelay = false;
        boolean unknownConnectionAppeared = false;
        int handoverConnectionsSize = this.mHandoverConnections.size();
        boolean noConnectionExists = true;
        int curDC = 0;
        int n = polledCalls.size();
        for (int i = 0; i < this.mConnections.length; ++i) {
            GsmCdmaConnection conn = this.mConnections[i];
            DriverCall dc = null;
            if (curDC < n) {
                dc = (DriverCall)polledCalls.get(curDC);
                if (dc.index == i + 1) {
                    ++curDC;
                } else {
                    dc = null;
                }
            }
            if (conn != null || dc != null) {
                noConnectionExists = false;
            }
            if (conn == null && dc != null) {
                if (this.mPendingMO != null && this.mPendingMO.compareTo(dc)) {
                    this.mConnections[i] = this.mPendingMO;
                    this.mPendingMO.mIndex = i;
                    this.mPendingMO.update(dc);
                    this.mPendingMO = null;
                    if (this.mHangupPendingMO) {
                        this.mHangupPendingMO = false;
                        if (!this.isPhoneTypeGsm() && this.mIsEcmTimerCanceled) {
                            this.handleEcmTimer(0);
                        }
                        try {
                            this.log("poll: hangupPendingMO, hangup conn " + i);
                            this.hangup(this.mConnections[i]);
                        }
                        catch (CallStateException ex) {
                            Rlog.e("GsmCdmaCallTracker", "unexpected error on hangup");
                        }
                        return;
                    }
                } else {
                    this.log("pendingMo=" + this.mPendingMO + ", dc=" + dc);
                    this.mConnections[i] = new GsmCdmaConnection(this.mPhone, dc, this, i);
                    Connection hoConnection = this.getHoConnection(dc);
                    if (hoConnection != null) {
                        this.mConnections[i].migrateFrom(hoConnection);
                        if (hoConnection.mPreHandoverState != Call.State.ACTIVE && hoConnection.mPreHandoverState != Call.State.HOLDING && dc.state == DriverCall.State.ACTIVE) {
                            this.mConnections[i].onConnectedInOrOut();
                        }
                        this.mHandoverConnections.remove(hoConnection);
                        if (this.isPhoneTypeGsm()) {
                            Iterator it = this.mHandoverConnections.iterator();
                            while (it.hasNext()) {
                                Connection c = (Connection)it.next();
                                Rlog.i("GsmCdmaCallTracker", "HO Conn state is " + (Object)((Object)c.mPreHandoverState));
                                if (c.mPreHandoverState != this.mConnections[i].getState()) continue;
                                Rlog.i("GsmCdmaCallTracker", "Removing HO conn " + hoConnection + (Object)((Object)c.mPreHandoverState));
                                it.remove();
                            }
                        }
                        this.mPhone.notifyHandoverStateChanged(this.mConnections[i]);
                    } else {
                        newRinging = this.checkMtFindNewRinging(dc, i);
                        if (newRinging == null) {
                            unknownConnectionAppeared = true;
                            if (this.isPhoneTypeGsm()) {
                                newUnknownConnectionsGsm.add(this.mConnections[i]);
                            } else {
                                newUnknownConnectionCdma = this.mConnections[i];
                            }
                        }
                    }
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn != null && dc == null) {
                if (this.isPhoneTypeGsm()) {
                    this.mDroppedDuringPoll.add(conn);
                } else {
                    GsmCdmaConnection cn;
                    int n2;
                    int count = this.mForegroundCall.mConnections.size();
                    for (n2 = 0; n2 < count; ++n2) {
                        this.log("adding fgCall cn " + n2 + " to droppedDuringPoll");
                        cn = (GsmCdmaConnection)this.mForegroundCall.mConnections.get(n2);
                        this.mDroppedDuringPoll.add(cn);
                    }
                    count = this.mRingingCall.mConnections.size();
                    for (n2 = 0; n2 < count; ++n2) {
                        this.log("adding rgCall cn " + n2 + " to droppedDuringPoll");
                        cn = (GsmCdmaConnection)this.mRingingCall.mConnections.get(n2);
                        this.mDroppedDuringPoll.add(cn);
                    }
                    if (this.mIsEcmTimerCanceled) {
                        this.handleEcmTimer(0);
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                }
                this.mConnections[i] = null;
                continue;
            }
            if (conn != null && dc != null && !conn.compareTo(dc) && this.isPhoneTypeGsm()) {
                this.mDroppedDuringPoll.add(conn);
                this.mConnections[i] = new GsmCdmaConnection(this.mPhone, dc, this, i);
                if (this.mConnections[i].getCall() == this.mRingingCall) {
                    newRinging = this.mConnections[i];
                }
                hasNonHangupStateChanged = true;
                continue;
            }
            if (conn == null || dc == null) continue;
            if (!this.isPhoneTypeGsm() && conn.isIncoming() != dc.isMT) {
                if (dc.isMT) {
                    this.mDroppedDuringPoll.add(conn);
                    newRinging = this.checkMtFindNewRinging(dc, i);
                    if (newRinging == null) {
                        unknownConnectionAppeared = true;
                        newUnknownConnectionCdma = conn;
                    }
                    this.checkAndEnableDataCallAfterEmergencyCallDropped();
                    continue;
                }
                Rlog.e("GsmCdmaCallTracker", "Error in RIL, Phantom call appeared " + dc);
                continue;
            }
            boolean changed = conn.update(dc);
            hasNonHangupStateChanged = hasNonHangupStateChanged || changed;
        }
        if (!this.isPhoneTypeGsm() && noConnectionExists) {
            this.checkAndEnableDataCallAfterEmergencyCallDropped();
        }
        if (this.mPendingMO != null) {
            Rlog.d("GsmCdmaCallTracker", "Pending MO dropped before poll fg state:" + (Object)((Object)this.mForegroundCall.getState()));
            this.mDroppedDuringPoll.add(this.mPendingMO);
            this.mPendingMO = null;
            this.mHangupPendingMO = false;
            if (!this.isPhoneTypeGsm()) {
                if (this.mPendingCallInEcm) {
                    this.mPendingCallInEcm = false;
                }
                this.checkAndEnableDataCallAfterEmergencyCallDropped();
            }
        }
        if (newRinging != null) {
            this.mPhone.notifyNewRingingConnection(newRinging);
        }
        ArrayList<GsmCdmaConnection> locallyDisconnectedConnections = new ArrayList<GsmCdmaConnection>();
        for (int i = this.mDroppedDuringPoll.size() - 1; i >= 0; --i) {
            GsmCdmaConnection gsmCdmaConnection = this.mDroppedDuringPoll.get(i);
            boolean wasDisconnected = false;
            if (gsmCdmaConnection.isIncoming() && gsmCdmaConnection.getConnectTime() == 0L) {
                int cause = gsmCdmaConnection.mCause == 3 ? 16 : 1;
                this.log("missed/rejected call, conn.cause=" + gsmCdmaConnection.mCause);
                this.log("setting cause to " + cause);
                this.mDroppedDuringPoll.remove(i);
                hasAnyCallDisconnected |= gsmCdmaConnection.onDisconnect(cause);
                wasDisconnected = true;
                locallyDisconnectedConnections.add(gsmCdmaConnection);
            } else if (gsmCdmaConnection.mCause == 3 || gsmCdmaConnection.mCause == 7) {
                this.mDroppedDuringPoll.remove(i);
                hasAnyCallDisconnected |= gsmCdmaConnection.onDisconnect(gsmCdmaConnection.mCause);
                wasDisconnected = true;
                locallyDisconnectedConnections.add(gsmCdmaConnection);
            }
            if (this.isPhoneTypeGsm() || !wasDisconnected || !unknownConnectionAppeared || gsmCdmaConnection != newUnknownConnectionCdma) continue;
            unknownConnectionAppeared = false;
            newUnknownConnectionCdma = null;
        }
        if (locallyDisconnectedConnections.size() > 0) {
            this.mMetrics.writeRilCallList(this.mPhone.getPhoneId(), locallyDisconnectedConnections);
        }
        Iterator it = this.mHandoverConnections.iterator();
        while (it.hasNext()) {
            Connection connection = (Connection)it.next();
            this.log("handlePollCalls - disconnect hoConn= " + connection + " hoConn.State= " + (Object)((Object)connection.getState()));
            if (connection.getState().isRinging()) {
                connection.onDisconnect(1);
            } else {
                connection.onDisconnect(-1);
            }
            it.remove();
        }
        if (this.mDroppedDuringPoll.size() > 0) {
            this.mCi.getLastCallFailCause(this.obtainNoPollCompleteMessage(5));
        }
        if (needsPollDelay) {
            this.pollCallsAfterDelay();
        }
        if (newRinging != null || hasNonHangupStateChanged || hasAnyCallDisconnected) {
            this.internalClearDisconnected();
        }
        this.updatePhoneState();
        if (unknownConnectionAppeared) {
            if (this.isPhoneTypeGsm()) {
                for (Connection connection : newUnknownConnectionsGsm) {
                    this.log("Notify unknown for " + connection);
                    this.mPhone.notifyUnknownConnection(connection);
                }
            } else {
                this.mPhone.notifyUnknownConnection(newUnknownConnectionCdma);
            }
        }
        if (hasNonHangupStateChanged || newRinging != null || hasAnyCallDisconnected) {
            this.mPhone.notifyPreciseCallStateChanged();
            this.updateMetrics(this.mConnections);
        }
        if (handoverConnectionsSize > 0 && this.mHandoverConnections.size() == 0 && (imsPhone = this.mPhone.getImsPhone()) != null) {
            imsPhone.callEndCleanupHandOverCallIfAny();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updateMetrics(GsmCdmaConnection[] connections) {
        ArrayList<GsmCdmaConnection> activeConnections = new ArrayList<GsmCdmaConnection>();
        for (GsmCdmaConnection conn : connections) {
            if (conn == null) continue;
            activeConnections.add(conn);
        }
        this.mMetrics.writeRilCallList(this.mPhone.getPhoneId(), activeConnections);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleRadioNotAvailable() {
        this.pollCallsWhenSafe();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dumpState() {
        int i;
        Rlog.i("GsmCdmaCallTracker", "Phone State:" + (Object)((Object)this.mState));
        Rlog.i("GsmCdmaCallTracker", "Ringing call: " + this.mRingingCall.toString());
        List<Connection> l = this.mRingingCall.getConnections();
        int s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i("GsmCdmaCallTracker", ((Object)l.get(i)).toString());
        }
        Rlog.i("GsmCdmaCallTracker", "Foreground call: " + this.mForegroundCall.toString());
        l = this.mForegroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i("GsmCdmaCallTracker", ((Object)l.get(i)).toString());
        }
        Rlog.i("GsmCdmaCallTracker", "Background call: " + this.mBackgroundCall.toString());
        l = this.mBackgroundCall.getConnections();
        s = l.size();
        for (i = 0; i < s; ++i) {
            Rlog.i("GsmCdmaCallTracker", ((Object)l.get(i)).toString());
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangup(GsmCdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("GsmCdmaConnection " + conn + "does not belong to GsmCdmaCallTracker " + this);
        }
        if (conn == this.mPendingMO) {
            this.log("hangup: set hangupPendingMO to true");
            this.mHangupPendingMO = true;
        } else {
            if (!this.isPhoneTypeGsm() && conn.getCall() == this.mRingingCall && this.mRingingCall.getState() == Call.State.WAITING) {
                conn.onLocalDisconnect();
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                return;
            }
            try {
                this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), conn, conn.getGsmCdmaIndex());
                this.mCi.hangupConnection(conn.getGsmCdmaIndex(), this.obtainCompleteMessage());
            }
            catch (CallStateException ex) {
                Rlog.w("GsmCdmaCallTracker", "GsmCdmaCallTracker WARN: hangup() on absent connection " + conn);
            }
        }
        conn.onHangupLocal();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$separate(GsmCdmaConnection conn) throws CallStateException {
        if (conn.mOwner != this) {
            throw new CallStateException("GsmCdmaConnection " + conn + "does not belong to GsmCdmaCallTracker " + this);
        }
        try {
            this.mCi.separateConnection(conn.getGsmCdmaIndex(), this.obtainCompleteMessage(12));
        }
        catch (CallStateException ex) {
            Rlog.w("GsmCdmaCallTracker", "GsmCdmaCallTracker WARN: separate() on absent connection " + conn);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$setMute(boolean mute) {
        this.mDesiredMute = mute;
        this.mCi.setMute(this.mDesiredMute, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getMute() {
        return this.mDesiredMute;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangup(GsmCdmaCall call) throws CallStateException {
        if (call.getConnections().size() == 0) {
            throw new CallStateException("no connections in call");
        }
        if (call == this.mRingingCall) {
            this.log("(ringing) hangup waiting or background");
            this.logHangupEvent(call);
            this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
        } else if (call == this.mForegroundCall) {
            if (call.isDialingOrAlerting()) {
                this.log("(foregnd) hangup dialing or alerting...");
                this.hangup((GsmCdmaConnection)call.getConnections().get(0));
            } else if (this.isPhoneTypeGsm() && this.mRingingCall.isRinging()) {
                this.log("hangup all conns in active/background call, without affecting ringing call");
                this.hangupAllConnections(call);
            } else {
                this.logHangupEvent(call);
                this.hangupForegroundResumeBackground();
            }
        } else if (call == this.mBackgroundCall) {
            if (this.mRingingCall.isRinging()) {
                this.log("hangup all conns in background call");
                this.hangupAllConnections(call);
            } else {
                this.hangupWaitingOrBackground();
            }
        } else {
            throw new RuntimeException("GsmCdmaCall " + call + "does not belong to GsmCdmaCallTracker " + this);
        }
        call.onHangupLocal();
        this.mPhone.notifyPreciseCallStateChanged();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$logHangupEvent(GsmCdmaCall call) {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            int call_index;
            GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
            try {
                call_index = cn.getGsmCdmaIndex();
            }
            catch (CallStateException ex) {
                call_index = -1;
            }
            this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), cn, call_index);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupWaitingOrBackground() {
        this.log("hangupWaitingOrBackground");
        this.logHangupEvent(this.mBackgroundCall);
        this.mCi.hangupWaitingOrBackground(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupForegroundResumeBackground() {
        this.log("hangupForegroundResumeBackground");
        this.mCi.hangupForegroundResumeBackground(this.obtainCompleteMessage());
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupConnectionByIndex(GsmCdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
            if (cn.mDisconnected || cn.getGsmCdmaIndex() != index) continue;
            this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), cn, cn.getGsmCdmaIndex());
            this.mCi.hangupConnection(index, this.obtainCompleteMessage());
            return;
        }
        throw new CallStateException("no GsmCdma index found");
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupAllConnections(GsmCdmaCall call) {
        try {
            int count = call.mConnections.size();
            for (int i = 0; i < count; ++i) {
                GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
                if (cn.mDisconnected) continue;
                this.mMetrics.writeRilHangup(this.mPhone.getPhoneId(), cn, cn.getGsmCdmaIndex());
                this.mCi.hangupConnection(cn.getGsmCdmaIndex(), this.obtainCompleteMessage());
            }
        }
        catch (CallStateException ex) {
            Rlog.e("GsmCdmaCallTracker", "hangupConnectionByIndex caught " + ex);
        }
    }

    private final GsmCdmaConnection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getConnectionByIndex(GsmCdmaCall call, int index) throws CallStateException {
        int count = call.mConnections.size();
        for (int i = 0; i < count; ++i) {
            GsmCdmaConnection cn = (GsmCdmaConnection)call.mConnections.get(i);
            if (cn.mDisconnected || cn.getGsmCdmaIndex() != index) continue;
            return cn;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$notifyCallWaitingInfo(CdmaCallWaitingNotification obj) {
        if (this.mCallWaitingRegistrants != null) {
            this.mCallWaitingRegistrants.notifyRegistrants(new AsyncResult(null, obj, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleCallWaitingInfo(CdmaCallWaitingNotification cw) {
        new GsmCdmaConnection(this.mPhone.getContext(), cw, this, this.mRingingCall);
        this.updatePhoneState();
        this.notifyCallWaitingInfo(cw);
    }

    private final PhoneInternalInterface.SuppService $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getFailedService(int what) {
        switch (what) {
            case 8: {
                return PhoneInternalInterface.SuppService.SWITCH;
            }
            case 11: {
                return PhoneInternalInterface.SuppService.CONFERENCE;
            }
            case 12: {
                return PhoneInternalInterface.SuppService.SEPARATE;
            }
            case 13: {
                return PhoneInternalInterface.SuppService.TRANSFER;
            }
        }
        return PhoneInternalInterface.SuppService.UNKNOWN;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                Rlog.d("GsmCdmaCallTracker", "Event EVENT_POLL_CALLS_RESULT Received");
                if (msg != this.mLastRelevantPoll) break;
                this.mNeedsPoll = false;
                this.mLastRelevantPoll = null;
                this.handlePollCalls((AsyncResult)msg.obj);
                break;
            }
            case 4: {
                this.operationComplete();
                break;
            }
            case 11: {
                Connection connection;
                if (this.isPhoneTypeGsm() && (connection = this.mForegroundCall.getLatestConnection()) != null) {
                    connection.onConferenceMergeFailed();
                }
            }
            case 8: 
            case 12: 
            case 13: {
                if (this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        this.mPhone.notifySuppServiceFailed(this.getFailedService(msg.what));
                    }
                    this.operationComplete();
                    break;
                }
                if (msg.what == 8) break;
                throw new RuntimeException("unexpected event " + msg.what + " not handled by " + "phone type " + this.mPhone.getPhoneType());
            }
            case 5: {
                int causeCode;
                String vendorCause = null;
                AsyncResult ar = (AsyncResult)msg.obj;
                this.operationComplete();
                if (ar.exception != null) {
                    causeCode = 16;
                    Rlog.i("GsmCdmaCallTracker", "Exception during getLastCallFailCause, assuming normal disconnect");
                } else {
                    LastCallFailCause failCause = (LastCallFailCause)ar.result;
                    causeCode = failCause.causeCode;
                    vendorCause = failCause.vendorCause;
                }
                if (causeCode == 34 || causeCode == 41 || causeCode == 42 || causeCode == 44 || causeCode == 49 || causeCode == 58 || causeCode == 65535) {
                    CellLocation loc = this.mPhone.getCellLocation();
                    int cid = -1;
                    if (loc != null) {
                        cid = this.isPhoneTypeGsm() ? ((GsmCellLocation)loc).getCid() : ((CdmaCellLocation)loc).getBaseStationId();
                    }
                    EventLog.writeEvent(50106, causeCode, cid, TelephonyManager.getDefault().getNetworkType());
                }
                int s = this.mDroppedDuringPoll.size();
                for (int i = 0; i < s; ++i) {
                    GsmCdmaConnection conn = this.mDroppedDuringPoll.get(i);
                    conn.onRemoteDisconnect(causeCode, vendorCause);
                }
                this.updatePhoneState();
                this.mPhone.notifyPreciseCallStateChanged();
                this.mMetrics.writeRilCallList(this.mPhone.getPhoneId(), this.mDroppedDuringPoll);
                this.mDroppedDuringPoll.clear();
                break;
            }
            case 2: 
            case 3: {
                this.pollCallsWhenSafe();
                break;
            }
            case 9: {
                this.handleRadioAvailable();
                break;
            }
            case 10: {
                this.handleRadioNotAvailable();
                break;
            }
            case 14: {
                if (!this.isPhoneTypeGsm()) {
                    if (this.mPendingCallInEcm) {
                        this.mCi.dial(this.mPendingMO.getAddress(), this.mPendingCallClirMode, this.obtainCompleteMessage());
                        this.mPendingCallInEcm = false;
                    }
                    this.mPhone.unsetOnEcbModeExitResponse(this);
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by " + "phone type " + this.mPhone.getPhoneType());
            }
            case 15: {
                if (!this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) break;
                    this.handleCallWaitingInfo((CdmaCallWaitingNotification)ar.result);
                    Rlog.d("GsmCdmaCallTracker", "Event EVENT_CALL_WAITING_INFO_CDMA Received");
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by " + "phone type " + this.mPhone.getPhoneType());
            }
            case 16: {
                if (!this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) break;
                    this.mPendingMO.onConnectedInOrOut();
                    this.mPendingMO = null;
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by " + "phone type " + this.mPhone.getPhoneType());
            }
            case 20: {
                if (!this.isPhoneTypeGsm()) {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception == null) {
                        this.postDelayed(new Runnable(this){
                            public transient /* synthetic */ Object __robo_data__;
                            /* synthetic */ GsmCdmaCallTracker this$0;

                            private void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_2$__constructor__(GsmCdmaCallTracker this$0) {
                            }

                            private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_2$run() {
                                if (this.this$0.mPendingMO != null) {
                                    this.this$0.mCi.sendCDMAFeatureCode(this.this$0.mPendingMO.getAddress(), this.this$0.obtainMessage(16));
                                }
                            }

                            private void __constructor__(GsmCdmaCallTracker gsmCdmaCallTracker) {
                                this.$$robo$$com_android_internal_telephony_GsmCdmaCallTracker_2$__constructor__(gsmCdmaCallTracker);
                            }
                            {
                                this.this$0 = gsmCdmaCallTracker;
                                this.$$robo$init();
                                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_2$__constructor__(com.android.internal.telephony.GsmCdmaCallTracker ), 0, this, gsmCdmaCallTracker);
                            }

                            @Override
                            public void run() {
                                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker_2$run(), 0, this);
                            }
                            {
                                this.$$robo$init();
                            }

                            protected /* synthetic */ void $$robo$init() {
                                if (this.__robo_data__ == null) {
                                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                                }
                            }

                            public /* synthetic */ Object $$robo$getData() {
                                return this.__robo_data__;
                            }
                        }, this.m3WayCallFlashDelay);
                        break;
                    }
                    this.mPendingMO = null;
                    Rlog.w("GsmCdmaCallTracker", "exception happened on Blank Flash for 3-way call");
                    break;
                }
                throw new RuntimeException("unexpected event " + msg.what + " not handled by " + "phone type " + this.mPhone.getPhoneType());
            }
            default: {
                throw new RuntimeException("unexpected event " + msg.what + " not handled by " + "phone type " + this.mPhone.getPhoneType());
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$checkAndEnableDataCallAfterEmergencyCallDropped() {
        if (this.mIsInEmergencyCall) {
            this.mIsInEmergencyCall = false;
            boolean inEcm = this.mPhone.isInEcm();
            this.log("checkAndEnableDataCallAfterEmergencyCallDropped,inEcm=" + inEcm);
            if (!inEcm) {
                this.mPhone.mDcTracker.setInternalDataEnabled(true);
                this.mPhone.notifyEmergencyCallRegistrants(false);
            }
            this.mPhone.sendEmergencyCallStateChange(false);
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$checkMtFindNewRinging(DriverCall dc, int i) {
        GsmCdmaConnection newRinging = null;
        if (this.mConnections[i].getCall() == this.mRingingCall) {
            newRinging = this.mConnections[i];
            this.log("Notify new ring " + dc);
        } else {
            Rlog.e("GsmCdmaCallTracker", "Phantom call appeared " + dc);
            if (dc.state != DriverCall.State.ALERTING && dc.state != DriverCall.State.DIALING) {
                this.mConnections[i].onConnectedInOrOut();
                if (dc.state == DriverCall.State.HOLDING) {
                    this.mConnections[i].onStartedHolding();
                }
            }
        }
        return newRinging;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$isInEmergencyCall() {
        return this.mIsInEmergencyCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$isPhoneTypeGsm() {
        return this.mPhone.getPhoneType() == 1;
    }

    private final GsmCdmaPhone $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getPhone() {
        return this.mPhone;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$log(String msg) {
        Rlog.d("GsmCdmaCallTracker", "[GsmCdmaCallTracker] " + msg);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("GsmCdmaCallTracker extends:");
        super.dump(fd, pw, args);
        pw.println("mConnections: length=" + this.mConnections.length);
        for (i = 0; i < this.mConnections.length; ++i) {
            pw.printf("  mConnections[%d]=%s\n", i, this.mConnections[i]);
        }
        pw.println(" mVoiceCallEndedRegistrants=" + this.mVoiceCallEndedRegistrants);
        pw.println(" mVoiceCallStartedRegistrants=" + this.mVoiceCallStartedRegistrants);
        if (!this.isPhoneTypeGsm()) {
            pw.println(" mCallWaitingRegistrants=" + this.mCallWaitingRegistrants);
        }
        pw.println(" mDroppedDuringPoll: size=" + this.mDroppedDuringPoll.size());
        for (i = 0; i < this.mDroppedDuringPoll.size(); ++i) {
            pw.printf("  mDroppedDuringPoll[%d]=%s\n", i, this.mDroppedDuringPoll.get(i));
        }
        pw.println(" mRingingCall=" + this.mRingingCall);
        pw.println(" mForegroundCall=" + this.mForegroundCall);
        pw.println(" mBackgroundCall=" + this.mBackgroundCall);
        pw.println(" mPendingMO=" + this.mPendingMO);
        pw.println(" mHangupPendingMO=" + this.mHangupPendingMO);
        pw.println(" mPhone=" + this.mPhone);
        pw.println(" mDesiredMute=" + this.mDesiredMute);
        pw.println(" mState=" + (Object)((Object)this.mState));
        if (!this.isPhoneTypeGsm()) {
            pw.println(" mPendingCallInEcm=" + this.mPendingCallInEcm);
            pw.println(" mIsInEmergencyCall=" + this.mIsInEmergencyCall);
            pw.println(" mPendingCallClirMode=" + this.mPendingCallClirMode);
            pw.println(" mIsEcmTimerCanceled=" + this.mIsEcmTimerCanceled);
        }
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getState() {
        return this.mState;
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getMaxConnectionsPerCall() {
        return this.mPhone.isPhoneTypeGsm() ? 5 : 1;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$cleanupCalls() {
        this.pollCallsWhenSafe();
    }

    private void __constructor__(GsmCdmaPhone gsmCdmaPhone) {
        this.$$robo$$com_android_internal_telephony_GsmCdmaCallTracker$__constructor__(gsmCdmaPhone);
    }

    public GsmCdmaCallTracker(GsmCdmaPhone gsmCdmaPhone) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$__constructor__(com.android.internal.telephony.GsmCdmaPhone ), 0, this, gsmCdmaPhone);
    }

    public void updatePhoneType() {
        InvokeDynamicSupport.bootstrap("updatePhoneType", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updatePhoneType(), 0, this);
    }

    private void updatePhoneType(boolean bl) {
        InvokeDynamicSupport.bootstrap("updatePhoneType", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updatePhoneType(boolean ), 0, this, bl);
    }

    private void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$reset(), 0, this);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$finalize(), 0, this);
    }

    @Override
    public void registerForVoiceCallStarted(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallStarted", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$registerForVoiceCallStarted(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallStarted(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallStarted", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$unregisterForVoiceCallStarted(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForVoiceCallEnded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVoiceCallEnded", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$registerForVoiceCallEnded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForVoiceCallEnded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVoiceCallEnded", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$unregisterForVoiceCallEnded(android.os.Handler ), 0, this, handler);
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    private void fakeHoldForegroundBeforeDial() {
        InvokeDynamicSupport.bootstrap("fakeHoldForegroundBeforeDial", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$fakeHoldForegroundBeforeDial(), 0, this);
    }

    public synchronized Connection dial(String string2, int n, UUSInfo uUSInfo, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(java.lang.String int com.android.internal.telephony.UUSInfo android.os.Bundle ), 0, this, string2, n, uUSInfo, bundle);
    }

    private void handleEcmTimer(int n) {
        InvokeDynamicSupport.bootstrap("handleEcmTimer", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleEcmTimer(int ), 0, this, n);
    }

    private void disableDataCallInEmergencyCall(String string2) {
        InvokeDynamicSupport.bootstrap("disableDataCallInEmergencyCall", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$disableDataCallInEmergencyCall(java.lang.String ), 0, this, string2);
    }

    public void setIsInEmergencyCall() {
        InvokeDynamicSupport.bootstrap("setIsInEmergencyCall", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$setIsInEmergencyCall(), 0, this);
    }

    private Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(java.lang.String int ), 0, this, string2, n);
    }

    private Connection dialThreeWay(String string2) {
        return InvokeDynamicSupport.bootstrap("dialThreeWay", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dialThreeWay(java.lang.String ), 0, this, string2);
    }

    public Connection dial(String string2) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(java.lang.String ), 0, this, string2);
    }

    public Connection dial(String string2, UUSInfo uUSInfo, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(java.lang.String com.android.internal.telephony.UUSInfo android.os.Bundle ), 0, this, string2, uUSInfo, bundle);
    }

    private Connection dial(String string2, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dial(java.lang.String int android.os.Bundle ), 0, this, string2, n, bundle);
    }

    public void acceptCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$acceptCall(), 0, this);
    }

    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$rejectCall(), 0, this);
    }

    private void flashAndSetGenericTrue() {
        InvokeDynamicSupport.bootstrap("flashAndSetGenericTrue", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$flashAndSetGenericTrue(), 0, this);
    }

    public void switchWaitingOrHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$switchWaitingOrHoldingAndActive(), 0, this);
    }

    public void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$conference(), 0, this);
    }

    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$explicitCallTransfer(), 0, this);
    }

    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$clearDisconnected(), 0, this);
    }

    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$canConference(), 0, this);
    }

    private boolean canDial() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDial", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$canDial(), 0, this);
    }

    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$canTransfer(), 0, this);
    }

    private void internalClearDisconnected() {
        InvokeDynamicSupport.bootstrap("internalClearDisconnected", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$internalClearDisconnected(), 0, this);
    }

    private Message obtainCompleteMessage() {
        return InvokeDynamicSupport.bootstrap("obtainCompleteMessage", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$obtainCompleteMessage(), 0, this);
    }

    private Message obtainCompleteMessage(int n) {
        return InvokeDynamicSupport.bootstrap("obtainCompleteMessage", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$obtainCompleteMessage(int ), 0, this, n);
    }

    private void operationComplete() {
        InvokeDynamicSupport.bootstrap("operationComplete", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$operationComplete(), 0, this);
    }

    private void updatePhoneState() {
        InvokeDynamicSupport.bootstrap("updatePhoneState", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updatePhoneState(), 0, this);
    }

    @Override
    protected synchronized void handlePollCalls(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handlePollCalls", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handlePollCalls(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private void updateMetrics(GsmCdmaConnection[] gsmCdmaConnectionArray) {
        InvokeDynamicSupport.bootstrap("updateMetrics", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$updateMetrics(com.android.internal.telephony.GsmCdmaConnection[] ), 0, this, gsmCdmaConnectionArray);
    }

    private void handleRadioNotAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioNotAvailable", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleRadioNotAvailable(), 0, this);
    }

    private void dumpState() {
        InvokeDynamicSupport.bootstrap("dumpState", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dumpState(), 0, this);
    }

    public void hangup(GsmCdmaConnection gsmCdmaConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangup(com.android.internal.telephony.GsmCdmaConnection ), 0, this, gsmCdmaConnection);
    }

    public void separate(GsmCdmaConnection gsmCdmaConnection) throws CallStateException {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$separate(com.android.internal.telephony.GsmCdmaConnection ), 0, this, gsmCdmaConnection);
    }

    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$setMute(boolean ), 0, this, bl);
    }

    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getMute(), 0, this);
    }

    public void hangup(GsmCdmaCall gsmCdmaCall) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangup", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangup(com.android.internal.telephony.GsmCdmaCall ), 0, this, gsmCdmaCall);
    }

    private void logHangupEvent(GsmCdmaCall gsmCdmaCall) {
        InvokeDynamicSupport.bootstrap("logHangupEvent", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$logHangupEvent(com.android.internal.telephony.GsmCdmaCall ), 0, this, gsmCdmaCall);
    }

    public void hangupWaitingOrBackground() {
        InvokeDynamicSupport.bootstrap("hangupWaitingOrBackground", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupWaitingOrBackground(), 0, this);
    }

    public void hangupForegroundResumeBackground() {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackground", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupForegroundResumeBackground(), 0, this);
    }

    public void hangupConnectionByIndex(GsmCdmaCall gsmCdmaCall, int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("hangupConnectionByIndex", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupConnectionByIndex(com.android.internal.telephony.GsmCdmaCall int ), 0, this, gsmCdmaCall, n);
    }

    public void hangupAllConnections(GsmCdmaCall gsmCdmaCall) {
        InvokeDynamicSupport.bootstrap("hangupAllConnections", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$hangupAllConnections(com.android.internal.telephony.GsmCdmaCall ), 0, this, gsmCdmaCall);
    }

    public GsmCdmaConnection getConnectionByIndex(GsmCdmaCall gsmCdmaCall, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("getConnectionByIndex", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getConnectionByIndex(com.android.internal.telephony.GsmCdmaCall int ), 0, this, gsmCdmaCall, n);
    }

    private void notifyCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        InvokeDynamicSupport.bootstrap("notifyCallWaitingInfo", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$notifyCallWaitingInfo(com.android.internal.telephony.cdma.CdmaCallWaitingNotification ), 0, this, cdmaCallWaitingNotification);
    }

    private void handleCallWaitingInfo(CdmaCallWaitingNotification cdmaCallWaitingNotification) {
        InvokeDynamicSupport.bootstrap("handleCallWaitingInfo", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleCallWaitingInfo(com.android.internal.telephony.cdma.CdmaCallWaitingNotification ), 0, this, cdmaCallWaitingNotification);
    }

    private PhoneInternalInterface.SuppService getFailedService(int n) {
        return InvokeDynamicSupport.bootstrap("getFailedService", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getFailedService(int ), 0, this, n);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$handleMessage(android.os.Message ), 0, this, message);
    }

    private void checkAndEnableDataCallAfterEmergencyCallDropped() {
        InvokeDynamicSupport.bootstrap("checkAndEnableDataCallAfterEmergencyCallDropped", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$checkAndEnableDataCallAfterEmergencyCallDropped(), 0, this);
    }

    private Connection checkMtFindNewRinging(DriverCall driverCall, int n) {
        return InvokeDynamicSupport.bootstrap("checkMtFindNewRinging", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$checkMtFindNewRinging(com.android.internal.telephony.DriverCall int ), 0, this, driverCall, n);
    }

    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$isInEmergencyCall(), 0, this);
    }

    private boolean isPhoneTypeGsm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneTypeGsm", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$isPhoneTypeGsm(), 0, this);
    }

    public GsmCdmaPhone getPhone() {
        return InvokeDynamicSupport.bootstrap("getPhone", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getPhone(), 0, this);
    }

    @Override
    protected void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getState(), 0, this);
    }

    public int getMaxConnectionsPerCall() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxConnectionsPerCall", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$getMaxConnectionsPerCall(), 0, this);
    }

    @Override
    public void cleanupCalls() {
        InvokeDynamicSupport.bootstrap("cleanupCalls", $$robo$$com_android_internal_telephony_GsmCdmaCallTracker$cleanupCalls(), 0, this);
    }

    public /* synthetic */ GsmCdmaCallTracker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmCdmaCallTracker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

