/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.database.SQLException;
import android.net.Uri;
import android.os.AsyncResult;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.PowerManager;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.ResultReceiver;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.provider.Telephony;
import android.telecom.VideoProfile;
import android.telephony.CarrierConfigManager;
import android.telephony.CellLocation;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.NetworkScanRequest;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.telephony.UssdResponse;
import android.telephony.cdma.CdmaCellLocation;
import android.text.TextUtils;
import android.util.Log;
import com.android.ims.ImsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallForwardInfo;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CarrierInfoManager;
import com.android.internal.telephony.CarrierKeyDownloadManager;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.DeviceStateMonitor;
import com.android.internal.telephony.GsmCdmaCall;
import com.android.internal.telephony.GsmCdmaCallTracker;
import com.android.internal.telephony.GsmCdmaConnection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccPhoneBookInterfaceManager;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.MmiCode;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaMmiCode;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.cdma.EriManager;
import com.android.internal.telephony.gsm.GsmMmiCode;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardProxy;
import com.android.internal.telephony.uicc.IccException;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IccVmNotSupportedException;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.IsimUiccRecords;
import com.android.internal.telephony.uicc.RuimRecords;
import com.android.internal.telephony.uicc.SIMRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class GsmCdmaPhone
extends Phone
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String LOG_TAG = "GsmCdmaPhone";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    private static String VM_NUMBER = "vm_number_key";
    private static String VM_SIM_IMSI = "vm_sim_imsi_key";
    private RegistrantList mSsnRegistrants;
    private static int DEFAULT_ECM_EXIT_TIMER_VALUE = 300000;
    private static String VM_NUMBER_CDMA = "vm_number_key_cdma";
    public static int RESTART_ECM_TIMER = 0;
    public static int CANCEL_ECM_TIMER = 1;
    private CdmaSubscriptionSourceManager mCdmaSSM;
    public int mCdmaSubscriptionSource;
    public EriManager mEriManager;
    private PowerManager.WakeLock mWakeLock;
    private RegistrantList mEriFileLoadedRegistrants;
    private Registrant mEcmExitRespRegistrant;
    private String mEsn;
    private String mMeid;
    private String mCarrierOtaSpNumSchema;
    private Runnable mExitEcmRunnable;
    public static String PROPERTY_CDMA_HOME_OPERATOR_NUMERIC = "ro.cdma.home.operator.numeric";
    private SIMRecords mSimRecords;
    private IsimUiccRecords mIsimUiccRecords;
    public GsmCdmaCallTracker mCT;
    public ServiceStateTracker mSST;
    private ArrayList<MmiCode> mPendingMMIs;
    private IccPhoneBookInterfaceManager mIccPhoneBookIntManager;
    private DeviceStateMonitor mDeviceStateMonitor;
    private int mPrecisePhoneType;
    private RegistrantList mEcmTimerResetRegistrants;
    private String mImei;
    private String mImeiSv;
    private String mVmNumber;
    private IccSmsInterfaceManager mIccSmsInterfaceManager;
    private IccCardProxy mIccCardProxy;
    private boolean mResetModemOnRadioTechnologyChange;
    private int mRilVersion;
    private boolean mBroadcastEmergencyCallStateChanges;
    private CarrierKeyDownloadManager mCDM;
    private BroadcastReceiver mBroadcastReceiver;
    private static String IS683A_FEATURE_CODE = "*228";
    private static int IS683A_FEATURE_CODE_NUM_DIGITS = 4;
    private static int IS683A_SYS_SEL_CODE_NUM_DIGITS = 2;
    private static int IS683A_SYS_SEL_CODE_OFFSET = 4;
    private static int IS683_CONST_800MHZ_A_BAND = 0;
    private static int IS683_CONST_800MHZ_B_BAND = 1;
    private static int IS683_CONST_1900MHZ_A_BLOCK = 2;
    private static int IS683_CONST_1900MHZ_B_BLOCK = 3;
    private static int IS683_CONST_1900MHZ_C_BLOCK = 4;
    private static int IS683_CONST_1900MHZ_D_BLOCK = 5;
    private static int IS683_CONST_1900MHZ_E_BLOCK = 6;
    private static int IS683_CONST_1900MHZ_F_BLOCK = 7;
    private static int INVALID_SYSTEM_SELECTION_CODE = -1;
    private static Pattern pOtaSpNumSchema;

    private void $$robo$$com_android_internal_telephony_GsmCdmaPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, int phoneId, int precisePhoneType, TelephonyComponentFactory telephonyComponentFactory) {
    }

    private void $$robo$$com_android_internal_telephony_GsmCdmaPhone$__constructor__(Context context, CommandsInterface ci, PhoneNotifier notifier, boolean unitTestMode, int phoneId, int precisePhoneType, TelephonyComponentFactory telephonyComponentFactory) {
        this.mSsnRegistrants = new RegistrantList();
        this.mCdmaSubscriptionSource = -1;
        this.mEriFileLoadedRegistrants = new RegistrantList();
        this.mExitEcmRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GsmCdmaPhone this$0;

            private void $$robo$$com_android_internal_telephony_GsmCdmaPhone_1$__constructor__(GsmCdmaPhone this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone_1$run() {
                this.this$0.exitEmergencyCallbackMode();
            }

            private void __constructor__(GsmCdmaPhone gsmCdmaPhone) {
                this.$$robo$$com_android_internal_telephony_GsmCdmaPhone_1$__constructor__(gsmCdmaPhone);
            }
            {
                this.this$0 = gsmCdmaPhone;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaPhone_1$__constructor__(com.android.internal.telephony.GsmCdmaPhone ), 0, this, gsmCdmaPhone);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_GsmCdmaPhone_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPendingMMIs = new ArrayList();
        this.mEcmTimerResetRegistrants = new RegistrantList();
        this.mResetModemOnRadioTechnologyChange = false;
        this.mBroadcastEmergencyCallStateChanges = false;
        this.mBroadcastReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ GsmCdmaPhone this$0;

            private void $$robo$$com_android_internal_telephony_GsmCdmaPhone_2$__constructor__(GsmCdmaPhone this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone_2$onReceive(Context context, Intent intent) {
                Rlog.d("GsmCdmaPhone", "mBroadcastReceiver: action " + intent.getAction());
                if (intent.getAction().equals("android.telephony.action.CARRIER_CONFIG_CHANGED")) {
                    this.this$0.sendMessage(this.this$0.obtainMessage(43));
                }
            }

            private void __constructor__(GsmCdmaPhone gsmCdmaPhone) {
                this.$$robo$$com_android_internal_telephony_GsmCdmaPhone_2$__constructor__(gsmCdmaPhone);
            }
            {
                this.this$0 = gsmCdmaPhone;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaPhone_2$__constructor__(com.android.internal.telephony.GsmCdmaPhone ), 0, this, gsmCdmaPhone);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_GsmCdmaPhone_2$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mPrecisePhoneType = precisePhoneType;
        this.initOnce(ci);
        this.initRatSpecific(precisePhoneType);
        this.mCarrierActionAgent = this.mTelephonyComponentFactory.makeCarrierActionAgent(this);
        this.mCarrierSignalAgent = this.mTelephonyComponentFactory.makeCarrierSignalAgent(this);
        this.mSST = this.mTelephonyComponentFactory.makeServiceStateTracker(this, this.mCi);
        this.mDcTracker = this.mTelephonyComponentFactory.makeDcTracker(this);
        this.mSST.registerForNetworkAttached(this, 19, null);
        this.mDeviceStateMonitor = this.mTelephonyComponentFactory.makeDeviceStateMonitor(this);
        this.logd("GsmCdmaPhone: constructor: sub = " + this.mPhoneId);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$initOnce(CommandsInterface ci) {
        if (ci instanceof SimulatedRadioControl) {
            this.mSimulatedRadioControl = (SimulatedRadioControl)((Object)ci);
        }
        this.mCT = this.mTelephonyComponentFactory.makeGsmCdmaCallTracker(this);
        this.mIccPhoneBookIntManager = this.mTelephonyComponentFactory.makeIccPhoneBookInterfaceManager(this);
        PowerManager pm = (PowerManager)this.mContext.getSystemService("power");
        this.mWakeLock = pm.newWakeLock(1, "GsmCdmaPhone");
        this.mIccSmsInterfaceManager = this.mTelephonyComponentFactory.makeIccSmsInterfaceManager(this);
        this.mIccCardProxy = this.mTelephonyComponentFactory.makeIccCardProxy(this.mContext, this.mCi, this.mPhoneId);
        this.mCi.registerForAvailable(this, 1, null);
        this.mCi.registerForOffOrNotAvailable(this, 8, null);
        this.mCi.registerForOn(this, 5, null);
        this.mCi.setOnSuppServiceNotification(this, 2, null);
        this.mCi.setOnUSSD(this, 7, null);
        this.mCi.setOnSs(this, 36, null);
        this.mCdmaSSM = this.mTelephonyComponentFactory.getCdmaSubscriptionSourceManagerInstance(this.mContext, this.mCi, this, 27, null);
        this.mEriManager = this.mTelephonyComponentFactory.makeEriManager(this, this.mContext, 0);
        this.mCi.setEmergencyCallbackMode(this, 25, null);
        this.mCi.registerForExitEmergencyCallbackMode(this, 26, null);
        this.mCi.registerForModemReset(this, 45, null);
        this.mCarrierOtaSpNumSchema = TelephonyManager.from(this.mContext).getOtaSpNumberSchemaForPhone(this.getPhoneId(), "");
        this.mResetModemOnRadioTechnologyChange = SystemProperties.getBoolean("persist.radio.reset_on_switch", false);
        this.mCi.registerForRilConnected(this, 41, null);
        this.mCi.registerForVoiceRadioTechChanged(this, 39, null);
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
        this.mCDM = new CarrierKeyDownloadManager(this);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$initRatSpecific(int precisePhoneType) {
        this.mPendingMMIs.clear();
        this.mIccPhoneBookIntManager.updateIccRecords(null);
        this.mEsn = null;
        this.mMeid = null;
        this.mPrecisePhoneType = precisePhoneType;
        TelephonyManager tm = TelephonyManager.from(this.mContext);
        if (this.isPhoneTypeGsm()) {
            this.mCi.setPhoneType(1);
            tm.setPhoneType(this.getPhoneId(), 1);
            this.mIccCardProxy.setVoiceRadioTech(3);
        } else {
            this.mCdmaSubscriptionSource = -1;
            this.mIsPhoneInEcmState = GsmCdmaPhone.getInEcmMode();
            if (this.mIsPhoneInEcmState) {
                this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
            }
            this.mCi.setPhoneType(2);
            tm.setPhoneType(this.getPhoneId(), 2);
            this.mIccCardProxy.setVoiceRadioTech(6);
            String operatorAlpha = SystemProperties.get("ro.cdma.home.operator.alpha");
            String operatorNumeric = SystemProperties.get("ro.cdma.home.operator.numeric");
            this.logd("init: operatorAlpha='" + operatorAlpha + "' operatorNumeric='" + operatorNumeric + "'");
            if (this.mUiccController.getUiccCardApplication(this.mPhoneId, 1) == null || this.isPhoneTypeCdmaLte()) {
                if (!TextUtils.isEmpty(operatorAlpha)) {
                    this.logd("init: set 'gsm.sim.operator.alpha' to operator='" + operatorAlpha + "'");
                    tm.setSimOperatorNameForPhone(this.mPhoneId, operatorAlpha);
                }
                if (!TextUtils.isEmpty(operatorNumeric)) {
                    this.logd("init: set 'gsm.sim.operator.numeric' to operator='" + operatorNumeric + "'");
                    this.logd("update icc_operator_numeric=" + operatorNumeric);
                    tm.setSimOperatorNumericForPhone(this.mPhoneId, operatorNumeric);
                    SubscriptionController.getInstance().setMccMnc(operatorNumeric, this.getSubId());
                    this.setIsoCountryProperty(operatorNumeric);
                    this.logd("update mccmnc=" + operatorNumeric);
                    MccTable.updateMccMncConfiguration(this.mContext, operatorNumeric, false);
                }
            }
            this.updateCurrentCarrierInProvider(operatorNumeric);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setIsoCountryProperty(String operatorNumeric) {
        TelephonyManager tm = TelephonyManager.from(this.mContext);
        if (TextUtils.isEmpty(operatorNumeric)) {
            this.logd("setIsoCountryProperty: clear 'gsm.sim.operator.iso-country'");
            tm.setSimCountryIsoForPhone(this.mPhoneId, "");
        } else {
            String iso = "";
            try {
                iso = MccTable.countryCodeForMcc(Integer.parseInt(operatorNumeric.substring(0, 3)));
            }
            catch (NumberFormatException ex) {
                Rlog.e("GsmCdmaPhone", "setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            catch (StringIndexOutOfBoundsException ex) {
                Rlog.e("GsmCdmaPhone", "setIsoCountryProperty: countryCodeForMcc error", ex);
            }
            this.logd("setIsoCountryProperty: set 'gsm.sim.operator.iso-country' to iso=" + iso);
            tm.setSimCountryIsoForPhone(this.mPhoneId, iso);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isPhoneTypeGsm() {
        return this.mPrecisePhoneType == 1;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isPhoneTypeCdma() {
        return this.mPrecisePhoneType == 2;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isPhoneTypeCdmaLte() {
        return this.mPrecisePhoneType == 6;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$switchPhoneType(int precisePhoneType) {
        this.removeCallbacks(this.mExitEcmRunnable);
        this.initRatSpecific(precisePhoneType);
        this.mSST.updatePhoneType();
        this.setPhoneName(precisePhoneType == 1 ? "GSM" : "CDMA");
        this.onUpdateIccAvailability();
        this.mCT.updatePhoneType();
        CommandsInterface.RadioState radioState = this.mCi.getRadioState();
        if (radioState.isAvailable()) {
            this.handleRadioAvailable();
            if (radioState.isOn()) {
                this.handleRadioOn();
            }
        }
        if (!radioState.isAvailable() || !radioState.isOn()) {
            this.handleRadioOffOrNotAvailable();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$finalize() {
        this.logd("GsmCdmaPhone finalized");
        if (this.mWakeLock != null && this.mWakeLock.isHeld()) {
            Rlog.e("GsmCdmaPhone", "UNEXPECTED; mWakeLock is held when finalizing.");
            this.mWakeLock.release();
        }
    }

    private final ServiceState $$robo$$com_android_internal_telephony_GsmCdmaPhone$getServiceState() {
        if ((this.mSST == null || this.mSST.mSS.getState() != 0) && this.mImsPhone != null) {
            return ServiceState.mergeServiceStates(this.mSST == null ? new ServiceState() : this.mSST.mSS, this.mImsPhone.getServiceState());
        }
        if (this.mSST != null) {
            return this.mSST.mSS;
        }
        return new ServiceState();
    }

    private final CellLocation $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCellLocation(WorkSource workSource) {
        if (this.isPhoneTypeGsm()) {
            return this.mSST.getCellLocation(workSource);
        }
        CdmaCellLocation loc = (CdmaCellLocation)this.mSST.mCellLoc;
        int mode = Settings.Secure.getInt(this.getContext().getContentResolver(), "location_mode", 0);
        if (mode == 0) {
            CdmaCellLocation privateLoc = new CdmaCellLocation();
            privateLoc.setCellLocationData(loc.getBaseStationId(), Integer.MAX_VALUE, Integer.MAX_VALUE, loc.getSystemId(), loc.getNetworkId());
            loc = privateLoc;
        }
        return loc;
    }

    private final PhoneConstants.State $$robo$$com_android_internal_telephony_GsmCdmaPhone$getState() {
        PhoneConstants.State imsState;
        if (this.mImsPhone != null && (imsState = this.mImsPhone.getState()) != PhoneConstants.State.IDLE) {
            return imsState;
        }
        return this.mCT.mState;
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaPhone$getPhoneType() {
        if (this.mPrecisePhoneType == 1) {
            return 1;
        }
        return 2;
    }

    private final ServiceStateTracker $$robo$$com_android_internal_telephony_GsmCdmaPhone$getServiceStateTracker() {
        return this.mSST;
    }

    private final CallTracker $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCallTracker() {
        return this.mCT;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateVoiceMail() {
        if (this.isPhoneTypeGsm()) {
            int countVoiceMessages = 0;
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                countVoiceMessages = r.getVoiceMessageCount();
            }
            if (countVoiceMessages == -2) {
                countVoiceMessages = this.getStoredVoiceMessageCount();
            }
            this.logd("updateVoiceMail countVoiceMessages = " + countVoiceMessages + " subId " + this.getSubId());
            this.setVoiceMessageCount(countVoiceMessages);
        } else {
            this.setVoiceMessageCount(this.getStoredVoiceMessageCount());
        }
    }

    private final List<? extends MmiCode> $$robo$$com_android_internal_telephony_GsmCdmaPhone$getPendingMmiCodes() {
        return this.mPendingMMIs;
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataConnectionState(String apnType) {
        PhoneConstants.DataState ret = PhoneConstants.DataState.DISCONNECTED;
        if (this.mSST == null) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else if (this.mSST.getCurrentDataConnectionState() != 0 && (this.isPhoneTypeCdma() || this.isPhoneTypeGsm() && !apnType.equals("emergency"))) {
            ret = PhoneConstants.DataState.DISCONNECTED;
        } else {
            switch (3.$SwitchMap$com$android$internal$telephony$DctConstants$State[this.mDcTracker.getState(apnType).ordinal()]) {
                case 1: 
                case 2: 
                case 3: {
                    ret = PhoneConstants.DataState.DISCONNECTED;
                    break;
                }
                case 4: 
                case 5: {
                    if (this.mCT.mState != PhoneConstants.State.IDLE && !this.mSST.isConcurrentVoiceAndDataAllowed()) {
                        ret = PhoneConstants.DataState.SUSPENDED;
                        break;
                    }
                    ret = PhoneConstants.DataState.CONNECTED;
                    break;
                }
                case 6: 
                case 7: {
                    ret = PhoneConstants.DataState.CONNECTING;
                }
            }
        }
        this.logd("getDataConnectionState apnType=" + apnType + " ret=" + (Object)((Object)ret));
        return ret;
    }

    private final PhoneInternalInterface.DataActivityState $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataActivityState() {
        PhoneInternalInterface.DataActivityState ret = PhoneInternalInterface.DataActivityState.NONE;
        if (this.mSST.getCurrentDataConnectionState() == 0) {
            switch (3.$SwitchMap$com$android$internal$telephony$DctConstants$Activity[this.mDcTracker.getActivity().ordinal()]) {
                case 1: {
                    ret = PhoneInternalInterface.DataActivityState.DATAIN;
                    break;
                }
                case 2: {
                    ret = PhoneInternalInterface.DataActivityState.DATAOUT;
                    break;
                }
                case 3: {
                    ret = PhoneInternalInterface.DataActivityState.DATAINANDOUT;
                    break;
                }
                case 4: {
                    ret = PhoneInternalInterface.DataActivityState.DORMANT;
                    break;
                }
                default: {
                    ret = PhoneInternalInterface.DataActivityState.NONE;
                }
            }
        }
        return ret;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyPhoneStateChanged() {
        this.mNotifier.notifyPhoneState(this);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyPreciseCallStateChanged() {
        super.notifyPreciseCallStateChangedP();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyNewRingingConnection(Connection c) {
        super.notifyNewRingingConnectionP(c);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyDisconnect(Connection cn) {
        this.mDisconnectRegistrants.notifyResult(cn);
        this.mNotifier.notifyDisconnectCause(cn.getDisconnectCause(), cn.getPreciseDisconnectCause());
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyUnknownConnection(Connection cn) {
        super.notifyUnknownConnectionP(cn);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isInEmergencyCall() {
        if (this.isPhoneTypeGsm()) {
            return false;
        }
        return this.mCT.isInEmergencyCall();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setIsInEmergencyCall() {
        if (!this.isPhoneTypeGsm()) {
            this.mCT.setIsInEmergencyCall();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendEmergencyCallbackModeChange() {
        Intent intent = new Intent("android.intent.action.EMERGENCY_CALLBACK_MODE_CHANGED");
        intent.putExtra("phoneinECMState", this.isInEcm());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
        ActivityManager.broadcastStickyIntent(intent, -1);
        this.logd("sendEmergencyCallbackModeChange");
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendEmergencyCallStateChange(boolean callActive) {
        if (this.mBroadcastEmergencyCallStateChanges) {
            Intent intent = new Intent("android.intent.action.EMERGENCY_CALL_STATE_CHANGED");
            intent.putExtra("phoneInEmergencyCall", callActive);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.getPhoneId());
            ActivityManager.broadcastStickyIntent(intent, -1);
            Rlog.d("GsmCdmaPhone", "sendEmergencyCallStateChange: callActive " + callActive);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setBroadcastEmergencyCallStateChanges(boolean broadcast) {
        this.mBroadcastEmergencyCallStateChanges = broadcast;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifySuppServiceFailed(PhoneInternalInterface.SuppService code) {
        this.mSuppServiceFailedRegistrants.notifyResult((Object)code);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyServiceStateChanged(ServiceState ss) {
        super.notifyServiceStateChangedP(ss);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyLocationChanged() {
        this.mNotifier.notifyCellLocation(this);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyCallForwardingIndicator() {
        this.mNotifier.notifyCallForwardingChanged(this);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            TelephonyManager.setTelephonyProperty(this.mPhoneId, property, value);
        } else {
            super.setSystemProperty(property, value);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForSuppServiceNotification(Handler h, int what, Object obj) {
        this.mSsnRegistrants.addUnique(h, what, obj);
        if (this.mSsnRegistrants.size() == 1) {
            this.mCi.setSuppServiceNotifications(true, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForSuppServiceNotification(Handler h) {
        this.mSsnRegistrants.remove(h);
        if (this.mSsnRegistrants.size() == 0) {
            this.mCi.setSuppServiceNotifications(false, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForSimRecordsLoaded(Handler h, int what, Object obj) {
        this.mSimRecordsLoadedRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForSimRecordsLoaded(Handler h) {
        this.mSimRecordsLoadedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$acceptCall(int videoState) throws CallStateException {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            imsPhone.acceptCall(videoState);
        } else {
            this.mCT.acceptCall();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$rejectCall() throws CallStateException {
        this.mCT.rejectCall();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$switchHoldingAndActive() throws CallStateException {
        this.mCT.switchWaitingOrHoldingAndActive();
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccSerialNumber() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (!this.isPhoneTypeGsm() && r == null) {
            r = this.mUiccController.getIccRecords(this.mPhoneId, 1);
        }
        return r != null ? r.getIccId() : null;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getFullIccSerialNumber() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (!this.isPhoneTypeGsm() && r == null) {
            r = this.mUiccController.getIccRecords(this.mPhoneId, 1);
        }
        return r != null ? r.getFullIccId() : null;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$canConference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            return true;
        }
        if (this.isPhoneTypeGsm()) {
            return this.mCT.canConference();
        }
        this.loge("canConference: not possible in CDMA");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$conference() {
        if (this.mImsPhone != null && this.mImsPhone.canConference()) {
            this.logd("conference() - delegated to IMS phone");
            try {
                this.mImsPhone.conference();
            }
            catch (CallStateException e) {
                this.loge(e.toString());
            }
            return;
        }
        if (this.isPhoneTypeGsm()) {
            this.mCT.conference();
        } else {
            this.loge("conference: not possible in CDMA");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            this.loge("enableEnhancedVoicePrivacy: not expected on GSM");
        } else {
            this.mCi.setPreferredVoicePrivacy(enable, onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getEnhancedVoicePrivacy(Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            this.loge("getEnhancedVoicePrivacy: not expected on GSM");
        } else {
            this.mCi.getPreferredVoicePrivacy(onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$clearDisconnected() {
        this.mCT.clearDisconnected();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$canTransfer() {
        if (this.isPhoneTypeGsm()) {
            return this.mCT.canTransfer();
        }
        this.loge("canTransfer: not possible in CDMA");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$explicitCallTransfer() {
        if (this.isPhoneTypeGsm()) {
            this.mCT.explicitCallTransfer();
        } else {
            this.loge("explicitCallTransfer: not possible in CDMA");
        }
    }

    private final GsmCdmaCall $$robo$$com_android_internal_telephony_GsmCdmaPhone$getForegroundCall() {
        return this.mCT.mForegroundCall;
    }

    private final GsmCdmaCall $$robo$$com_android_internal_telephony_GsmCdmaPhone$getBackgroundCall() {
        return this.mCT.mBackgroundCall;
    }

    private final Call $$robo$$com_android_internal_telephony_GsmCdmaPhone$getRingingCall() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getRingingCall().isRinging()) {
            return imsPhone.getRingingCall();
        }
        return this.mCT.mRingingCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCallDeflectionIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        if (this.getRingingCall().getState() != Call.State.IDLE) {
            this.logd("MmiCode 0: rejectCall");
            try {
                this.mCT.rejectCall();
            }
            catch (CallStateException e) {
                Rlog.d("GsmCdmaPhone", "reject failed", e);
                this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.REJECT);
            }
        } else if (this.getBackgroundCall().getState() != Call.State.IDLE) {
            this.logd("MmiCode 0: hangupWaitingOrBackground");
            this.mCT.hangupWaitingOrBackground();
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCallWaitingIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len > 2) {
            return false;
        }
        Call call = this.getForegroundCall();
        try {
            if (len > 1) {
                char ch = dialString.charAt(1);
                int callIndex = ch - 48;
                if (callIndex >= 1 && callIndex <= 19) {
                    this.logd("MmiCode 1: hangupConnectionByIndex " + callIndex);
                    this.mCT.hangupConnectionByIndex((GsmCdmaCall)call, callIndex);
                }
            } else if (call.getState() != Call.State.IDLE) {
                this.logd("MmiCode 1: hangup foreground");
                this.mCT.hangup((GsmCdmaCall)call);
            } else {
                this.logd("MmiCode 1: switchWaitingOrHoldingAndActive");
                this.mCT.switchWaitingOrHoldingAndActive();
            }
        }
        catch (CallStateException e) {
            Rlog.d("GsmCdmaPhone", "hangup failed", e);
            this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.HANGUP);
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCallHoldIncallSupplementaryService(String dialString) {
        block10: {
            int len = dialString.length();
            if (len > 2) {
                return false;
            }
            Call call = this.getForegroundCall();
            if (len > 1) {
                try {
                    char ch = dialString.charAt(1);
                    int callIndex = ch - 48;
                    GsmCdmaConnection conn = this.mCT.getConnectionByIndex((GsmCdmaCall)call, callIndex);
                    if (conn != null && callIndex >= 1 && callIndex <= 19) {
                        this.logd("MmiCode 2: separate call " + callIndex);
                        this.mCT.separate(conn);
                        break block10;
                    }
                    this.logd("separate: invalid call index " + callIndex);
                    this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SEPARATE);
                }
                catch (CallStateException e) {
                    Rlog.d("GsmCdmaPhone", "separate failed", e);
                    this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SEPARATE);
                }
            } else {
                try {
                    if (this.getRingingCall().getState() != Call.State.IDLE) {
                        this.logd("MmiCode 2: accept ringing call");
                        this.mCT.acceptCall();
                    } else {
                        this.logd("MmiCode 2: switchWaitingOrHoldingAndActive");
                        this.mCT.switchWaitingOrHoldingAndActive();
                    }
                }
                catch (CallStateException e) {
                    Rlog.d("GsmCdmaPhone", "switch failed", e);
                    this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.SWITCH);
                }
            }
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleMultipartyIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        this.logd("MmiCode 3: merge calls");
        this.conference();
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleEctIncallSupplementaryService(String dialString) {
        int len = dialString.length();
        if (len != 1) {
            return false;
        }
        this.logd("MmiCode 4: explicit call transfer");
        this.explicitCallTransfer();
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCcbsIncallSupplementaryService(String dialString) {
        if (dialString.length() > 1) {
            return false;
        }
        Rlog.i("GsmCdmaPhone", "MmiCode 5: CCBS not supported!");
        this.notifySuppServiceFailed(PhoneInternalInterface.SuppService.UNKNOWN);
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleInCallMmiCommands(String dialString) throws CallStateException {
        if (!this.isPhoneTypeGsm()) {
            this.loge("method handleInCallMmiCommands is NOT supported in CDMA!");
            return false;
        }
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return imsPhone.handleInCallMmiCommands(dialString);
        }
        if (!this.isInCall()) {
            return false;
        }
        if (TextUtils.isEmpty(dialString)) {
            return false;
        }
        boolean result = false;
        char ch = dialString.charAt(0);
        switch (ch) {
            case '0': {
                result = this.handleCallDeflectionIncallSupplementaryService(dialString);
                break;
            }
            case '1': {
                result = this.handleCallWaitingIncallSupplementaryService(dialString);
                break;
            }
            case '2': {
                result = this.handleCallHoldIncallSupplementaryService(dialString);
                break;
            }
            case '3': {
                result = this.handleMultipartyIncallSupplementaryService(dialString);
                break;
            }
            case '4': {
                result = this.handleEctIncallSupplementaryService(dialString);
                break;
            }
            case '5': {
                result = this.handleCcbsIncallSupplementaryService(dialString);
                break;
            }
        }
        return result;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isInCall() {
        Call.State foregroundCallState = this.getForegroundCall().getState();
        Call.State backgroundCallState = this.getBackgroundCall().getState();
        Call.State ringingCallState = this.getRingingCall().getState();
        return foregroundCallState.isAlive() || backgroundCallState.isAlive() || ringingCallState.isAlive();
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaPhone$dial(String dialString, int videoState) throws CallStateException {
        return this.dial(dialString, null, videoState, null);
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaPhone$dial(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        if (!this.isPhoneTypeGsm() && uusInfo != null) {
            throw new CallStateException("Sending UUS information NOT supported in CDMA!");
        }
        boolean isEmergency = PhoneNumberUtils.isEmergencyNumber(this.getSubId(), dialString);
        Phone imsPhone = this.mImsPhone;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        boolean alwaysTryImsForEmergencyCarrierConfig = configManager.getConfigForSubId(this.getSubId()).getBoolean("carrier_use_ims_first_for_emergency_bool");
        boolean imsUseEnabled = this.isImsUseEnabled() && imsPhone != null && (imsPhone.isVolteEnabled() || imsPhone.isWifiCallingEnabled() || imsPhone.isVideoEnabled() && VideoProfile.isVideo(videoState)) && imsPhone.getServiceState().getState() == 0;
        boolean useImsForEmergency = imsPhone != null && isEmergency && alwaysTryImsForEmergencyCarrierConfig && ImsManager.isNonTtyOrTtyOnVolteEnabled(this.mContext) && imsPhone.isImsAvailable();
        String dialPart = PhoneNumberUtils.extractNetworkPortionAlt(PhoneNumberUtils.stripSeparators(dialString));
        boolean isUt = (dialPart.startsWith("*") || dialPart.startsWith("#")) && dialPart.endsWith("#");
        boolean useImsForUt = imsPhone != null && imsPhone.isUtEnabled();
        this.logd("imsUseEnabled=" + imsUseEnabled + ", useImsForEmergency=" + useImsForEmergency + ", useImsForUt=" + useImsForUt + ", isUt=" + isUt + ", imsPhone=" + imsPhone + ", imsPhone.isVolteEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVolteEnabled()) : "N/A") + ", imsPhone.isVowifiEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isWifiCallingEnabled()) : "N/A") + ", imsPhone.isVideoEnabled()=" + (imsPhone != null ? Boolean.valueOf(imsPhone.isVideoEnabled()) : "N/A") + ", imsPhone.getServiceState().getState()=" + (imsPhone != null ? Integer.valueOf(imsPhone.getServiceState().getState()) : "N/A"));
        Phone.checkWfcWifiOnlyModeBeforeDial(this.mImsPhone, this.mContext);
        if (imsUseEnabled && (!isUt || useImsForUt) || useImsForEmergency) {
            try {
                this.logd("Trying IMS PS call");
                return imsPhone.dial(dialString, uusInfo, videoState, intentExtras);
            }
            catch (CallStateException e) {
                this.logd("IMS PS call exception " + e + "imsUseEnabled =" + imsUseEnabled + ", imsPhone =" + imsPhone);
                if ("cs_fallback".equals(e.getMessage()) || isEmergency) {
                    this.logi("IMS call failed with Exception: " + e.getMessage() + ". Falling back " + "to CS.");
                }
                CallStateException ce = new CallStateException(e.getMessage());
                ce.setStackTrace(e.getStackTrace());
                throw ce;
            }
        }
        if (this.mSST != null && this.mSST.mSS.getState() == 1 && this.mSST.mSS.getDataRegState() != 0 && !isEmergency) {
            throw new CallStateException("cannot dial in current state");
        }
        if (this.mSST != null && this.mSST.mSS.getState() == 3 && !VideoProfile.isVideo(videoState) && !isEmergency) {
            throw new CallStateException(2, "cannot dial voice call in airplane mode");
        }
        if (!(this.mSST == null || this.mSST.mSS.getState() != 1 || this.mSST.mSS.getDataRegState() == 0 && ServiceState.isLte(this.mSST.mSS.getRilDataRadioTechnology()) || VideoProfile.isVideo(videoState) || isEmergency)) {
            throw new CallStateException(1, "cannot dial voice call in out of service");
        }
        this.logd("Trying (non-IMS) CS call");
        if (this.isPhoneTypeGsm()) {
            return this.dialInternal(dialString, null, 0, intentExtras);
        }
        return this.dialInternal(dialString, null, videoState, intentExtras);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isNotificationOfWfcCallRequired(String dialString) {
        boolean shouldNotifyInternationalCallOnWfc;
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        PersistableBundle config = configManager.getConfigForSubId(this.getSubId());
        boolean bl = shouldNotifyInternationalCallOnWfc = config != null && config.getBoolean("notify_international_call_on_wfc_bool");
        if (!shouldNotifyInternationalCallOnWfc) {
            return false;
        }
        Phone imsPhone = this.mImsPhone;
        boolean isEmergency = PhoneNumberUtils.isEmergencyNumber(this.getSubId(), dialString);
        boolean shouldConfirmCall = this.isImsUseEnabled() && imsPhone != null && !imsPhone.isVolteEnabled() && imsPhone.isWifiCallingEnabled() && !isEmergency && PhoneNumberUtils.isInternationalNumber(dialString, this.getCountryIso());
        return shouldConfirmCall;
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaPhone$dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        return this.dialInternal(dialString, uusInfo, videoState, intentExtras, null);
    }

    private final Connection $$robo$$com_android_internal_telephony_GsmCdmaPhone$dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras, ResultReceiver wrappedCallback) throws CallStateException {
        String newDialString = PhoneNumberUtils.stripSeparators(dialString);
        if (this.isPhoneTypeGsm()) {
            if (this.handleInCallMmiCommands(newDialString)) {
                return null;
            }
            String networkPortion = PhoneNumberUtils.extractNetworkPortionAlt(newDialString);
            GsmMmiCode mmi = GsmMmiCode.newFromDialString(networkPortion, this, (UiccCardApplication)this.mUiccApplication.get(), wrappedCallback);
            this.logd("dialInternal: dialing w/ mmi '" + mmi + "'...");
            if (mmi == null) {
                return this.mCT.dial(newDialString, uusInfo, intentExtras);
            }
            if (mmi.isTemporaryModeCLIR()) {
                return this.mCT.dial(mmi.mDialingNumber, mmi.getCLIRMode(), uusInfo, intentExtras);
            }
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.processCode();
            return null;
        }
        return this.mCT.dial(newDialString);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handlePinMmi(String dialString) {
        Handler mmi = this.isPhoneTypeGsm() ? GsmMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get()) : CdmaMmiCode.newFromDialString(dialString, this, (UiccCardApplication)this.mUiccApplication.get());
        if (mmi != null && mmi.isPinPukCommand()) {
            this.mPendingMMIs.add((MmiCode)((Object)mmi));
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            try {
                mmi.processCode();
            }
            catch (CallStateException callStateException) {
                // empty catch block
            }
            return true;
        }
        this.loge("Mmi is null or unrecognized!");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendUssdResponse(String ussdRequest, CharSequence message, int returnCode, ResultReceiver wrappedCallback) {
        UssdResponse response = new UssdResponse(ussdRequest, message);
        Bundle returnData = new Bundle();
        returnData.putParcelable("USSD_RESPONSE", response);
        wrappedCallback.send(returnCode, returnData);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleUssdRequest(String ussdRequest, ResultReceiver wrappedCallback) {
        if (!this.isPhoneTypeGsm() || this.mPendingMMIs.size() > 0) {
            this.sendUssdResponse(ussdRequest, null, -1, wrappedCallback);
            return true;
        }
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
            try {
                this.logd("handleUssdRequest: attempting over IMS");
                return imsPhone.handleUssdRequest(ussdRequest, wrappedCallback);
            }
            catch (CallStateException cse) {
                if (!"cs_fallback".equals(cse.getMessage())) {
                    return false;
                }
                this.logd("handleUssdRequest: fallback to CS required");
            }
        }
        try {
            this.dialInternal(ussdRequest, null, 0, null, wrappedCallback);
        }
        catch (Exception e) {
            this.logd("handleUssdRequest: exception" + e);
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendUssdResponse(String ussdMessge) {
        if (this.isPhoneTypeGsm()) {
            GsmMmiCode mmi = GsmMmiCode.newFromUssdUserInput(ussdMessge, this, (UiccCardApplication)this.mUiccApplication.get());
            this.mPendingMMIs.add(mmi);
            this.mMmiRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            mmi.sendUssd(ussdMessge);
        } else {
            this.loge("sendUssdResponse: not possible in CDMA");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("sendDtmf called with invalid character '" + c + "'");
        } else if (this.mCT.mState == PhoneConstants.State.OFFHOOK) {
            this.mCi.sendDtmf(c, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$startDtmf(char c) {
        if (!PhoneNumberUtils.is12Key(c)) {
            this.loge("startDtmf called with invalid character '" + c + "'");
        } else {
            this.mCi.startDtmf(c, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$stopDtmf() {
        this.mCi.stopDtmf(null);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            this.loge("[GsmCdmaPhone] sendBurstDtmf() is a CDMA method");
        } else {
            boolean check = true;
            for (int itr = 0; itr < dtmfString.length(); ++itr) {
                if (PhoneNumberUtils.is12Key(dtmfString.charAt(itr))) continue;
                Rlog.e("GsmCdmaPhone", "sendDtmf called with invalid character '" + dtmfString.charAt(itr) + "'");
                check = false;
                break;
            }
            if (this.mCT.mState == PhoneConstants.State.OFFHOOK && check) {
                this.mCi.sendBurstDtmf(dtmfString, on, off, onComplete);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setRadioPower(boolean power) {
        this.mSST.setRadioPower(power);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$storeVoiceMailNumber(String number) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        if (this.isPhoneTypeGsm()) {
            editor.putString("vm_number_key" + this.getPhoneId(), number);
            editor.apply();
            this.setVmSimImsi(this.getSubscriberId());
        } else {
            editor.putString("vm_number_key_cdma" + this.getPhoneId(), number);
            editor.apply();
        }
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getVoiceMailNumber() {
        String defaultVmNumber;
        CarrierConfigManager configManager;
        PersistableBundle b;
        String number = null;
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            String string2 = number = r != null ? r.getVoiceMailNumber() : "";
            if (TextUtils.isEmpty(number)) {
                SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
                number = sp.getString("vm_number_key" + this.getPhoneId(), null);
            }
        } else {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            number = sp.getString("vm_number_key_cdma" + this.getPhoneId(), null);
        }
        if (TextUtils.isEmpty(number) && (b = (configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config")).getConfig()) != null && !TextUtils.isEmpty(defaultVmNumber = b.getString("default_vm_number_string"))) {
            number = defaultVmNumber;
        }
        if (!this.isPhoneTypeGsm() && TextUtils.isEmpty(number)) {
            number = this.getContext().getResources().getBoolean(17957037) ? this.getLine1Number() : "*86";
        }
        return number;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getVmSimImsi() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        return sp.getString("vm_sim_imsi_key" + this.getPhoneId(), null);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setVmSimImsi(String imsi) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putString("vm_sim_imsi_key" + this.getPhoneId(), imsi);
        editor.apply();
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getVoiceMailAlphaTag() {
        String ret = "";
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            String string2 = ret = r != null ? r.getVoiceMailAlphaTag() : "";
        }
        if (ret == null || ret.length() == 0) {
            return this.mContext.getText(0x1040004).toString();
        }
        return ret;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDeviceId() {
        if (this.isPhoneTypeGsm()) {
            return this.mImei;
        }
        CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
        boolean force_imei = configManager.getConfigForSubId(this.getSubId()).getBoolean("force_imei_bool");
        if (force_imei) {
            return this.mImei;
        }
        String id2 = this.getMeid();
        if (id2 == null || id2.matches("^0*$")) {
            this.loge("getDeviceId(): MEID is not initialized use ESN");
            id2 = this.getEsn();
        }
        return id2;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDeviceSvn() {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            return this.mImeiSv;
        }
        this.loge("getDeviceSvn(): return 0");
        return "0";
    }

    private final IsimRecords $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIsimRecords() {
        return this.mIsimUiccRecords;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getImei() {
        return this.mImei;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getEsn() {
        if (this.isPhoneTypeGsm()) {
            this.loge("[GsmCdmaPhone] getEsn() is a CDMA method");
            return "0";
        }
        return this.mEsn;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getMeid() {
        return this.mMeid;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getNai() {
        IccRecords r = this.mUiccController.getIccRecords(this.mPhoneId, 2);
        if (Log.isLoggable("GsmCdmaPhone", 2)) {
            Rlog.v("GsmCdmaPhone", "IccRecords is " + r);
        }
        return r != null ? r.getNAI() : null;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getSubscriberId() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getIMSI() : null;
        }
        if (this.isPhoneTypeCdma()) {
            return this.mSST.getImsi();
        }
        return this.mSimRecords != null ? this.mSimRecords.getIMSI() : "";
    }

    private final ImsiEncryptionInfo $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCarrierInfoForImsiEncryption(int keyType) {
        return CarrierInfoManager.getCarrierInfoForImsiEncryption(keyType, this.mContext);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
        CarrierInfoManager.setCarrierInfoForImsiEncryption(imsiEncryptionInfo, this.mContext);
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getGroupIdLevel1() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getGid1() : null;
        }
        if (this.isPhoneTypeCdma()) {
            this.loge("GID1 is not available in CDMA");
            return null;
        }
        return this.mSimRecords != null ? this.mSimRecords.getGid1() : "";
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getGroupIdLevel2() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getGid2() : null;
        }
        if (this.isPhoneTypeCdma()) {
            this.loge("GID2 is not available in CDMA");
            return null;
        }
        return this.mSimRecords != null ? this.mSimRecords.getGid2() : "";
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getLine1Number() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getMsisdnNumber() : null;
        }
        return this.mSST.getMdnNumber();
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaPrlVersion() {
        return this.mSST.getPrlVersion();
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaMin() {
        return this.mSST.getCdmaMin();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isMinInfoReady() {
        return this.mSST.isMinInfoReady();
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getMsisdn() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getMsisdnNumber() : null;
        }
        if (this.isPhoneTypeCdmaLte()) {
            return this.mSimRecords != null ? this.mSimRecords.getMsisdnNumber() : null;
        }
        this.loge("getMsisdn: not expected on CDMA");
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getLine1AlphaTag() {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            return r != null ? r.getMsisdnAlphaTag() : null;
        }
        this.loge("getLine1AlphaTag: not possible in CDMA");
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$setLine1Number(String alphaTag, String number, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                r.setMsisdnNumber(alphaTag, number, onComplete);
                return true;
            }
            return false;
        }
        this.loge("setLine1Number: not possible in CDMA");
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setVoiceMailNumber(String alphaTag, String voiceMailNumber, Message onComplete) {
        this.mVmNumber = voiceMailNumber;
        Message resp = this.obtainMessage(20, 0, 0, onComplete);
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            r.setVoiceMailNumber(alphaTag, this.mVmNumber, resp);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isValidCommandInterfaceCFReason(int commandInterfaceCFReason) {
        switch (commandInterfaceCFReason) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getSystemProperty(String property, String defValue) {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            if (this.getUnitTestMode()) {
                return null;
            }
            return TelephonyManager.getTelephonyProperty(this.mPhoneId, property, defValue);
        }
        return super.getSystemProperty(property, defValue);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isValidCommandInterfaceCFAction(int commandInterfaceCFAction) {
        switch (commandInterfaceCFAction) {
            case 0: 
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isCfEnable(int action) {
        return action == 1 || action == 3;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCallForwardingOption(int commandInterfaceCFReason, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.getCallForwardingOption(commandInterfaceCFReason, onComplete);
                return;
            }
            if (this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
                this.logd("requesting call forwarding query.");
                Message resp = commandInterfaceCFReason == 0 ? this.obtainMessage(13, onComplete) : onComplete;
                this.mCi.queryCallForwardStatus(commandInterfaceCFReason, 0, null, resp);
            }
        } else {
            this.loge("getCallForwardingOption: not possible in CDMA");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCallForwardingOption(int commandInterfaceCFAction, int commandInterfaceCFReason, String dialingNumber, int timerSeconds, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.setCallForwardingOption(commandInterfaceCFAction, commandInterfaceCFReason, dialingNumber, timerSeconds, onComplete);
                return;
            }
            if (this.isValidCommandInterfaceCFAction(commandInterfaceCFAction) && this.isValidCommandInterfaceCFReason(commandInterfaceCFReason)) {
                Message resp;
                if (commandInterfaceCFReason == 0) {
                    Cfu cfu = new Cfu(dialingNumber, onComplete);
                    resp = this.obtainMessage(12, this.isCfEnable(commandInterfaceCFAction) ? 1 : 0, 0, cfu);
                } else {
                    resp = onComplete;
                }
                this.mCi.setCallForward(commandInterfaceCFAction, commandInterfaceCFReason, 1, dialingNumber, timerSeconds, resp);
            }
        } else {
            this.loge("setCallForwardingOption: not possible in CDMA");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getOutgoingCallerIdDisplay(Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
                imsPhone.getOutgoingCallerIdDisplay(onComplete);
                return;
            }
            this.mCi.getCLIR(onComplete);
        } else {
            this.loge("getOutgoingCallerIdDisplay: not possible in CDMA");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setOutgoingCallerIdDisplay(int commandInterfaceCLIRMode, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
                imsPhone.setOutgoingCallerIdDisplay(commandInterfaceCLIRMode, onComplete);
                return;
            }
            this.mCi.setCLIR(commandInterfaceCLIRMode, this.obtainMessage(18, commandInterfaceCLIRMode, 0, onComplete));
        } else {
            this.loge("setOutgoingCallerIdDisplay: not possible in CDMA");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCallWaiting(Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.getCallWaiting(onComplete);
                return;
            }
            this.mCi.queryCallWaiting(0, onComplete);
        } else {
            this.mCi.queryCallWaiting(1, onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCallWaiting(boolean enable, Message onComplete) {
        if (this.isPhoneTypeGsm()) {
            Phone imsPhone = this.mImsPhone;
            if (imsPhone != null && (imsPhone.getServiceState().getState() == 0 || imsPhone.isUtEnabled())) {
                imsPhone.setCallWaiting(enable, onComplete);
                return;
            }
            this.mCi.setCallWaiting(enable, 1, onComplete);
        } else {
            this.loge("method setCallWaiting is NOT supported in CDMA!");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getAvailableNetworks(Message response) {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            this.mCi.getAvailableNetworks(response);
        } else {
            this.loge("getAvailableNetworks: not possible in CDMA");
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$startNetworkScan(NetworkScanRequest nsr, Message response) {
        this.mCi.startNetworkScan(nsr, response);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$stopNetworkScan(Message response) {
        this.mCi.stopNetworkScan(response);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getNeighboringCids(Message response, WorkSource workSource) {
        if (this.isPhoneTypeGsm()) {
            this.mCi.getNeighboringCids(response, workSource);
        } else if (response != null) {
            CommandException ce = new CommandException(CommandException.Error.REQUEST_NOT_SUPPORTED);
            AsyncResult.forMessage((Message)response).exception = ce;
            response.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setTTYMode(int ttyMode, Message onComplete) {
        super.setTTYMode(ttyMode, onComplete);
        if (this.mImsPhone != null) {
            this.mImsPhone.setTTYMode(ttyMode, onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setUiTTYMode(int uiTtyMode, Message onComplete) {
        if (this.mImsPhone != null) {
            this.mImsPhone.setUiTTYMode(uiTtyMode, onComplete);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setMute(boolean muted) {
        this.mCT.setMute(muted);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$getMute() {
        return this.mCT.getMute();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataCallList(Message response) {
        this.mCi.getDataCallList(response);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateServiceLocation() {
        this.mSST.enableSingleLocationUpdate();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$enableLocationUpdates() {
        this.mSST.enableLocationUpdates();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$disableLocationUpdates() {
        this.mSST.disableLocationUpdates();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataRoamingEnabled() {
        return this.mDcTracker.getDataRoamingEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setDataRoamingEnabled(boolean enable) {
        this.mDcTracker.setDataRoamingEnabledByUser(enable);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
        this.mCi.registerForCdmaOtaProvision(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForCdmaOtaStatusChange(Handler h) {
        this.mCi.unregisterForCdmaOtaProvision(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
        this.mSST.registerForSubscriptionInfoReady(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForSubscriptionInfoReady(Handler h) {
        this.mSST.unregisterForSubscriptionInfoReady(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setOnEcbModeExitResponse(Handler h, int what, Object obj) {
        this.mEcmExitRespRegistrant = new Registrant(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unsetOnEcbModeExitResponse(Handler h) {
        this.mEcmExitRespRegistrant.clear();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForCallWaiting(Handler h, int what, Object obj) {
        this.mCT.registerForCallWaiting(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForCallWaiting(Handler h) {
        this.mCT.unregisterForCallWaiting(h);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataEnabled() {
        return this.mDcTracker.getDataEnabled();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setDataEnabled(boolean enable) {
        this.mDcTracker.setDataEnabled(enable);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$onMMIDone(MmiCode mmi) {
        if (this.mPendingMMIs.remove(mmi) || this.isPhoneTypeGsm() && (mmi.isUssdRequest() || ((GsmMmiCode)mmi).isSsInfo())) {
            ResultReceiver receiverCallback = mmi.getUssdCallbackReceiver();
            if (receiverCallback != null) {
                Rlog.i("GsmCdmaPhone", "onMMIDone: invoking callback: " + mmi);
                int returnCode = mmi.getState() == MmiCode.State.COMPLETE ? 100 : -1;
                this.sendUssdResponse(mmi.getDialString(), mmi.getMessage(), returnCode, receiverCallback);
            } else {
                Rlog.i("GsmCdmaPhone", "onMMIDone: notifying registrants: " + mmi);
                this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
            }
        } else {
            Rlog.i("GsmCdmaPhone", "onMMIDone: invalid response or already handled; ignoring: " + mmi);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$supports3gppCallForwardingWhileRoaming() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
        PersistableBundle b = configManager.getConfig();
        if (b != null) {
            return b.getBoolean("support_3gpp_call_forwarding_while_roaming_bool", true);
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$onNetworkInitiatedUssd(MmiCode mmi) {
        Rlog.v("GsmCdmaPhone", "onNetworkInitiatedUssd: mmi=" + mmi);
        this.mMmiCompleteRegistrants.notifyRegistrants(new AsyncResult(null, mmi, null));
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$onIncomingUSSD(int ussdMode, String ussdMessage) {
        if (!this.isPhoneTypeGsm()) {
            this.loge("onIncomingUSSD: not expected on GSM");
        }
        boolean isUssdRequest = ussdMode == 1;
        boolean isUssdError = ussdMode != 0 && ussdMode != 1;
        boolean isUssdRelease = ussdMode == 2;
        GsmMmiCode found = null;
        int s = this.mPendingMMIs.size();
        for (int i = 0; i < s; ++i) {
            if (!((GsmMmiCode)this.mPendingMMIs.get(i)).isPendingUSSD()) continue;
            found = (GsmMmiCode)this.mPendingMMIs.get(i);
            break;
        }
        if (found != null) {
            if (isUssdRelease) {
                found.onUssdRelease();
            } else if (isUssdError) {
                found.onUssdFinishedError();
            } else {
                found.onUssdFinished(ussdMessage, isUssdRequest);
            }
        } else if (!isUssdError && ussdMessage != null) {
            GsmMmiCode mmi = GsmMmiCode.newNetworkInitiatedUssd(ussdMessage, isUssdRequest, this, (UiccCardApplication)this.mUiccApplication.get());
            this.onNetworkInitiatedUssd(mmi);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$syncClirSetting() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        int clirSetting = sp.getInt("clir_key" + this.getPhoneId(), -1);
        Rlog.i("GsmCdmaPhone", "syncClirSetting: clir_key" + this.getPhoneId() + "=" + clirSetting);
        if (clirSetting >= 0) {
            this.mCi.setCLIR(clirSetting, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleRadioAvailable() {
        this.mCi.getBasebandVersion(this.obtainMessage(6));
        this.mCi.getDeviceIdentity(this.obtainMessage(21));
        this.mCi.getRadioCapability(this.obtainMessage(35));
        this.startLceAfterRadioIsAvailable();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleRadioOn() {
        this.mCi.getVoiceRadioTechnology(this.obtainMessage(40));
        if (!this.isPhoneTypeGsm()) {
            this.mCdmaSubscriptionSource = this.mCdmaSSM.getCdmaSubscriptionSource();
        }
        this.setPreferredNetworkTypeIfSimLoaded();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleRadioOffOrNotAvailable() {
        if (this.isPhoneTypeGsm()) {
            for (int i = this.mPendingMMIs.size() - 1; i >= 0; --i) {
                if (!((GsmMmiCode)this.mPendingMMIs.get(i)).isPendingUSSD()) continue;
                ((GsmMmiCode)this.mPendingMMIs.get(i)).onUssdFinishedError();
            }
        }
        this.mRadioOffOrNotAvailableRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleRadioAvailable();
                break;
            }
            case 21: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                String[] respId = (String[])ar.result;
                this.mImei = respId[0];
                this.mImeiSv = respId[1];
                this.mEsn = respId[2];
                this.mMeid = respId[3];
                break;
            }
            case 25: {
                this.handleEnterEmergencyCallbackMode(msg);
                break;
            }
            case 26: {
                this.handleExitEmergencyCallbackMode(msg);
                break;
            }
            case 45: {
                this.logd("Event EVENT_MODEM_RESET Received isInEcm = " + this.isInEcm() + " isPhoneTypeGsm = " + this.isPhoneTypeGsm() + " mImsPhone = " + this.mImsPhone);
                if (!this.isInEcm()) break;
                if (this.isPhoneTypeGsm()) {
                    if (this.mImsPhone == null) break;
                    this.mImsPhone.handleExitEmergencyCallbackMode();
                    break;
                }
                this.handleExitEmergencyCallbackMode(msg);
                break;
            }
            case 22: {
                this.logd("Event EVENT_RUIM_RECORDS_LOADED Received");
                this.updateCurrentCarrierInProvider();
                break;
            }
            case 5: {
                this.logd("Event EVENT_RADIO_ON Received");
                this.handleRadioOn();
                break;
            }
            case 41: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null && ar.result != null) {
                    this.mRilVersion = (Integer)ar.result;
                    break;
                }
                this.logd("Unexpected exception on EVENT_RIL_CONNECTED");
                this.mRilVersion = -1;
                break;
            }
            case 39: 
            case 40: {
                String what = msg.what == 39 ? "EVENT_VOICE_RADIO_TECH_CHANGED" : "EVENT_REQUEST_VOICE_RADIO_TECH_DONE";
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    if (ar.result != null && ((int[])ar.result).length != 0) {
                        int newVoiceTech = ((int[])ar.result)[0];
                        this.logd(what + ": newVoiceTech=" + newVoiceTech);
                        this.phoneObjectUpdater(newVoiceTech);
                        break;
                    }
                    this.loge(what + ": has no tech!");
                    break;
                }
                this.loge(what + ": exception=" + ar.exception);
                break;
            }
            case 42: {
                this.phoneObjectUpdater(msg.arg1);
                break;
            }
            case 43: {
                if (!this.mContext.getResources().getBoolean(17957035)) {
                    this.mCi.getVoiceRadioTechnology(this.obtainMessage(40));
                }
                ImsManager.updateImsServiceConfig(this.mContext, this.mPhoneId, true);
                CarrierConfigManager configMgr = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
                PersistableBundle b = configMgr.getConfigForSubId(this.getSubId());
                if (b != null) {
                    boolean broadcastEmergencyCallStateChanges = b.getBoolean("broadcast_emergency_call_state_changes_bool");
                    this.logd("broadcastEmergencyCallStateChanges = " + broadcastEmergencyCallStateChanges);
                    this.setBroadcastEmergencyCallStateChanges(broadcastEmergencyCallStateChanges);
                } else {
                    this.loge("didn't get broadcastEmergencyCallStateChanges from carrier config");
                }
                if (b != null) {
                    int config_cdma_roaming_mode = b.getInt("cdma_roaming_mode_int");
                    int current_cdma_roaming_mode = Settings.Global.getInt(this.getContext().getContentResolver(), "roaming_settings", -1);
                    switch (config_cdma_roaming_mode) {
                        case 0: 
                        case 1: 
                        case 2: {
                            this.logd("cdma_roaming_mode is going to changed to " + config_cdma_roaming_mode);
                            this.setCdmaRoamingPreference(config_cdma_roaming_mode, this.obtainMessage(44));
                            break;
                        }
                        case -1: {
                            if (current_cdma_roaming_mode != config_cdma_roaming_mode) {
                                this.logd("cdma_roaming_mode is going to changed to " + current_cdma_roaming_mode);
                                this.setCdmaRoamingPreference(current_cdma_roaming_mode, this.obtainMessage(44));
                            }
                        }
                        default: {
                            this.loge("Invalid cdma_roaming_mode settings: " + config_cdma_roaming_mode);
                            break;
                        }
                    }
                } else {
                    this.loge("didn't get the cdma_roaming_mode changes from the carrier config.");
                }
                this.prepareEri();
                if (this.isPhoneTypeGsm()) break;
                this.mSST.pollState();
                break;
            }
            case 44: {
                this.logd("cdma_roaming_mode change is done");
                break;
            }
            case 27: {
                this.logd("EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED");
                this.mCdmaSubscriptionSource = this.mCdmaSSM.getCdmaSubscriptionSource();
                break;
            }
            case 19: {
                this.logd("Event EVENT_REGISTERED_TO_NETWORK Received");
                if (!this.isPhoneTypeGsm()) break;
                this.syncClirSetting();
                break;
            }
            case 3: {
                this.updateCurrentCarrierInProvider();
                String imsi = this.getVmSimImsi();
                String imsiFromSIM = this.getSubscriberId();
                if (!(this.isPhoneTypeGsm() && imsi == null || imsiFromSIM == null || imsiFromSIM.equals(imsi))) {
                    this.storeVoiceMailNumber(null);
                    this.setVmSimImsi(null);
                }
                this.mSimRecordsLoadedRegistrants.notifyRegistrants();
                break;
            }
            case 6: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.logd("Baseband version: " + ar.result);
                TelephonyManager.from(this.mContext).setBasebandVersionForPhone(this.getPhoneId(), (String)ar.result);
                break;
            }
            case 9: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImei = (String)ar.result;
                break;
            }
            case 10: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                this.mImeiSv = (String)ar.result;
                break;
            }
            case 7: {
                AsyncResult ar = (AsyncResult)msg.obj;
                String[] ussdResult = (String[])ar.result;
                if (ussdResult.length <= 1) break;
                try {
                    this.onIncomingUSSD(Integer.parseInt(ussdResult[0]), ussdResult[1]);
                }
                catch (NumberFormatException e) {
                    Rlog.w("GsmCdmaPhone", "error parsing USSD");
                }
                break;
            }
            case 8: {
                this.logd("Event EVENT_RADIO_OFF_OR_NOT_AVAILABLE Received");
                this.handleRadioOffOrNotAvailable();
                break;
            }
            case 2: {
                this.logd("Event EVENT_SSN Received");
                if (!this.isPhoneTypeGsm()) break;
                AsyncResult ar = (AsyncResult)msg.obj;
                SuppServiceNotification not = (SuppServiceNotification)ar.result;
                this.mSsnRegistrants.notifyRegistrants(ar);
                break;
            }
            case 12: {
                AsyncResult ar = (AsyncResult)msg.obj;
                IccRecords r = (IccRecords)this.mIccRecords.get();
                Cfu cfu = (Cfu)ar.userObj;
                if (ar.exception == null && r != null) {
                    this.setVoiceCallForwardingFlag(1, msg.arg1 == 1, cfu.mSetCfNumber);
                }
                if (cfu.mOnComplete == null) break;
                AsyncResult.forMessage(cfu.mOnComplete, ar.result, ar.exception);
                cfu.mOnComplete.sendToTarget();
                break;
            }
            case 20: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.isPhoneTypeGsm() && IccVmNotSupportedException.class.isInstance(ar.exception) || !this.isPhoneTypeGsm() && IccException.class.isInstance(ar.exception)) {
                    this.storeVoiceMailNumber(this.mVmNumber);
                    ar.exception = null;
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 13: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleCfuQueryResult((CallForwardInfo[])ar.result);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 28: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (this.mSST.mSS.getIsManualSelection()) {
                    this.setNetworkSelectionModeAutomatic((Message)ar.result);
                    this.logd("SET_NETWORK_SELECTION_AUTOMATIC: set to automatic");
                    break;
                }
                this.logd("SET_NETWORK_SELECTION_AUTOMATIC: already automatic, ignore");
                break;
            }
            case 29: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.processIccRecordEvents((Integer)ar.result);
                break;
            }
            case 18: {
                Message onComplete;
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.saveClirSetting(msg.arg1);
                }
                if ((onComplete = (Message)ar.userObj) == null) break;
                AsyncResult.forMessage(onComplete, ar.result, ar.exception);
                onComplete.sendToTarget();
                break;
            }
            case 36: {
                AsyncResult ar = (AsyncResult)msg.obj;
                this.logd("Event EVENT_SS received");
                if (!this.isPhoneTypeGsm()) break;
                GsmMmiCode mmi = new GsmMmiCode(this, (UiccCardApplication)this.mUiccApplication.get());
                mmi.processSsData(ar);
                break;
            }
            case 35: {
                AsyncResult ar = (AsyncResult)msg.obj;
                RadioCapability rc = (RadioCapability)ar.result;
                if (ar.exception != null) {
                    Rlog.d("GsmCdmaPhone", "get phone radio capability fail, no need to change mRadioCapability");
                } else {
                    this.radioCapabilityUpdated(rc);
                }
                Rlog.d("GsmCdmaPhone", "EVENT_GET_RADIO_CAPABILITY: phone rc: " + rc);
                break;
            }
            default: {
                super.handleMessage(msg);
            }
        }
    }

    private final UiccCardApplication $$robo$$com_android_internal_telephony_GsmCdmaPhone$getUiccCardApplication() {
        if (this.isPhoneTypeGsm()) {
            return this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
        }
        return this.mUiccController.getUiccCardApplication(this.mPhoneId, 2);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$onUpdateIccAvailability() {
        UiccCardApplication app;
        if (this.mUiccController == null) {
            return;
        }
        UiccCardApplication newUiccApplication = null;
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 3);
            IsimUiccRecords newIsimUiccRecords = null;
            if (newUiccApplication != null) {
                newIsimUiccRecords = (IsimUiccRecords)newUiccApplication.getIccRecords();
                this.logd("New ISIM application found");
            }
            this.mIsimUiccRecords = newIsimUiccRecords;
        }
        if (this.mSimRecords != null) {
            this.mSimRecords.unregisterForRecordsLoaded(this);
        }
        if (this.isPhoneTypeCdmaLte()) {
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
            SIMRecords newSimRecords = null;
            if (newUiccApplication != null) {
                newSimRecords = (SIMRecords)newUiccApplication.getIccRecords();
            }
            this.mSimRecords = newSimRecords;
            if (this.mSimRecords != null) {
                this.mSimRecords.registerForRecordsLoaded(this, 3, null);
            }
        } else {
            this.mSimRecords = null;
        }
        newUiccApplication = this.getUiccCardApplication();
        if (!this.isPhoneTypeGsm() && newUiccApplication == null) {
            this.logd("can't find 3GPP2 application; trying APP_FAM_3GPP");
            newUiccApplication = this.mUiccController.getUiccCardApplication(this.mPhoneId, 1);
        }
        if ((app = (UiccCardApplication)this.mUiccApplication.get()) != newUiccApplication) {
            if (app != null) {
                this.logd("Removing stale icc objects.");
                if (this.mIccRecords.get() != null) {
                    this.unregisterForIccRecordEvents();
                    this.mIccPhoneBookIntManager.updateIccRecords(null);
                }
                this.mIccRecords.set(null);
                this.mUiccApplication.set(null);
            }
            if (newUiccApplication != null) {
                this.logd("New Uicc application found. type = " + (Object)((Object)newUiccApplication.getType()));
                this.mUiccApplication.set(newUiccApplication);
                this.mIccRecords.set(newUiccApplication.getIccRecords());
                this.registerForIccRecordEvents();
                this.mIccPhoneBookIntManager.updateIccRecords((IccRecords)this.mIccRecords.get());
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$processIccRecordEvents(int eventCode) {
        switch (eventCode) {
            case 1: {
                this.logi("processIccRecordEvents: EVENT_CFI");
                this.notifyCallForwardingIndicator();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateCurrentCarrierInProvider() {
        if (this.isPhoneTypeGsm() || this.isPhoneTypeCdmaLte()) {
            long currentDds = SubscriptionManager.getDefaultDataSubscriptionId();
            String operatorNumeric = this.getOperatorNumeric();
            this.logd("updateCurrentCarrierInProvider: mSubId = " + this.getSubId() + " currentDds = " + currentDds + " operatorNumeric = " + operatorNumeric);
            if (!TextUtils.isEmpty(operatorNumeric) && (long)this.getSubId() == currentDds) {
                try {
                    Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                    ContentValues map = new ContentValues();
                    map.put("numeric", operatorNumeric);
                    this.mContext.getContentResolver().insert(uri, map);
                    return true;
                }
                catch (SQLException e) {
                    Rlog.e("GsmCdmaPhone", "Can't store current operator", e);
                }
            }
            return false;
        }
        return true;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateCurrentCarrierInProvider(String operatorNumeric) {
        if (this.isPhoneTypeCdma() || this.isPhoneTypeCdmaLte() && this.mUiccController.getUiccCardApplication(this.mPhoneId, 1) == null) {
            this.logd("CDMAPhone: updateCurrentCarrierInProvider called");
            if (!TextUtils.isEmpty(operatorNumeric)) {
                try {
                    Uri uri = Uri.withAppendedPath(Telephony.Carriers.CONTENT_URI, "current");
                    ContentValues map = new ContentValues();
                    map.put("numeric", operatorNumeric);
                    this.logd("updateCurrentCarrierInProvider from system: numeric=" + operatorNumeric);
                    this.getContext().getContentResolver().insert(uri, map);
                    this.logd("update mccmnc=" + operatorNumeric);
                    MccTable.updateMccMncConfiguration(this.mContext, operatorNumeric, false);
                    return true;
                }
                catch (SQLException e) {
                    Rlog.e("GsmCdmaPhone", "Can't store current operator", e);
                }
            }
            return false;
        }
        this.logd("updateCurrentCarrierInProvider not updated X retVal=true");
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCfuQueryResult(CallForwardInfo[] infos) {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r != null) {
            if (infos == null || infos.length == 0) {
                this.setVoiceCallForwardingFlag(1, false, null);
            } else {
                int s = infos.length;
                for (int i = 0; i < s; ++i) {
                    if ((infos[i].serviceClass & 1) == 0) continue;
                    this.setVoiceCallForwardingFlag(1, infos[i].status == 1, infos[i].number);
                    break;
                }
            }
        }
    }

    private final IccPhoneBookInterfaceManager $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccPhoneBookInterfaceManager() {
        return this.mIccPhoneBookIntManager;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForEriFileLoaded(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mEriFileLoadedRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForEriFileLoaded(Handler h) {
        this.mEriFileLoadedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$prepareEri() {
        if (this.mEriManager == null) {
            Rlog.e("GsmCdmaPhone", "PrepareEri: Trying to access stale objects");
            return;
        }
        this.mEriManager.loadEriFile();
        if (this.mEriManager.isEriFileLoaded()) {
            this.logd("ERI read, notify registrants");
            this.mEriFileLoadedRegistrants.notifyRegistrants();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isEriFileLoaded() {
        return this.mEriManager.isEriFileLoaded();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$activateCellBroadcastSms(int activate, Message response) {
        this.loge("[GsmCdmaPhone] activateCellBroadcastSms() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCellBroadcastSmsConfig(Message response) {
        this.loge("[GsmCdmaPhone] getCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCellBroadcastSmsConfig(int[] configValuesArray, Message response) {
        this.loge("[GsmCdmaPhone] setCellBroadcastSmsConfig() is obsolete; use SmsManager");
        response.sendToTarget();
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$needsOtaServiceProvisioning() {
        if (this.isPhoneTypeGsm()) {
            return false;
        }
        return this.mSST.getOtasp() != 3;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isCspPlmnEnabled() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        return r != null ? r.isCspPlmnEnabled() : false;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$shouldForceAutoNetworkSelect() {
        int nwMode = Phone.PREFERRED_NT_MODE;
        int subId = this.getSubId();
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return false;
        }
        nwMode = Settings.Global.getInt(this.mContext.getContentResolver(), "preferred_network_mode" + subId, nwMode);
        this.logd("shouldForceAutoNetworkSelect in mode = " + nwMode);
        if (this.isManualSelProhibitedInGlobalMode() && (nwMode == 10 || nwMode == 7)) {
            this.logd("Should force auto network select mode = " + nwMode);
            return true;
        }
        this.logd("Should not force auto network select mode = " + nwMode);
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isManualSelProhibitedInGlobalMode() {
        String[] configArray;
        boolean isProhibited = false;
        String configString = this.getContext().getResources().getString(17040643);
        if (!TextUtils.isEmpty(configString) && (configArray = configString.split(";")) != null && (configArray.length == 1 && configArray[0].equalsIgnoreCase("true") || configArray.length == 2 && !TextUtils.isEmpty(configArray[1]) && configArray[0].equalsIgnoreCase("true") && this.isMatchGid(configArray[1]))) {
            isProhibited = true;
        }
        this.logd("isManualNetSelAllowedInGlobal in current carrier is " + isProhibited);
        return isProhibited;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForIccRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        if (this.isPhoneTypeGsm()) {
            r.registerForNetworkSelectionModeAutomatic(this, 28, null);
            r.registerForRecordsEvents(this, 29, null);
            r.registerForRecordsLoaded(this, 3, null);
        } else {
            r.registerForRecordsLoaded(this, 22, null);
            if (this.isPhoneTypeCdmaLte()) {
                r.registerForRecordsLoaded(this, 3, null);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForIccRecordEvents() {
        IccRecords r = (IccRecords)this.mIccRecords.get();
        if (r == null) {
            return;
        }
        r.unregisterForNetworkSelectionModeAutomatic(this);
        r.unregisterForRecordsEvents(this);
        r.unregisterForRecordsLoaded(this);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$exitEmergencyCallbackMode() {
        Rlog.d("GsmCdmaPhone", "exitEmergencyCallbackMode: mImsPhone=" + this.mImsPhone + " isPhoneTypeGsm=" + this.isPhoneTypeGsm());
        if (this.isPhoneTypeGsm()) {
            if (this.mImsPhone != null) {
                this.mImsPhone.exitEmergencyCallbackMode();
            }
        } else {
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
            this.mCi.exitEmergencyCallbackMode(this.obtainMessage(26));
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleEnterEmergencyCallbackMode(Message msg) {
        Rlog.d("GsmCdmaPhone", "handleEnterEmergencyCallbackMode, isInEcm()=" + this.isInEcm());
        if (!this.isInEcm()) {
            this.setIsInEcm(true);
            this.sendEmergencyCallbackModeChange();
            long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
            this.postDelayed(this.mExitEcmRunnable, delayInMillis);
            this.mWakeLock.acquire();
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleExitEmergencyCallbackMode(Message msg) {
        AsyncResult ar = (AsyncResult)msg.obj;
        Rlog.d("GsmCdmaPhone", "handleExitEmergencyCallbackMode,ar.exception , isInEcm=" + ar.exception + this.isInEcm());
        this.removeCallbacks(this.mExitEcmRunnable);
        if (this.mEcmExitRespRegistrant != null) {
            this.mEcmExitRespRegistrant.notifyRegistrant(ar);
        }
        if (ar.exception == null) {
            if (this.isInEcm()) {
                this.setIsInEcm(false);
            }
            if (this.mWakeLock.isHeld()) {
                this.mWakeLock.release();
            }
            this.sendEmergencyCallbackModeChange();
            this.mDcTracker.setInternalDataEnabled(true);
            this.notifyEmergencyCallRegistrants(false);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyEmergencyCallRegistrants(boolean started) {
        this.mEmergencyCallToggledRegistrants.notifyResult(started ? 1 : 0);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleTimerInEmergencyCallbackMode(int action) {
        switch (action) {
            case 1: {
                this.removeCallbacks(this.mExitEcmRunnable);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.TRUE);
                break;
            }
            case 0: {
                long delayInMillis = SystemProperties.getLong("ro.cdma.ecmexittimer", 300000L);
                this.postDelayed(this.mExitEcmRunnable, delayInMillis);
                this.mEcmTimerResetRegistrants.notifyResult(Boolean.FALSE);
                break;
            }
            default: {
                Rlog.e("GsmCdmaPhone", "handleTimerInEmergencyCallbackMode, unsupported action " + action);
            }
        }
    }

    private static final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isIs683OtaSpDialStr(String dialStr) {
        boolean isOtaspDialString = false;
        int dialStrLen = dialStr.length();
        if (dialStrLen == 4) {
            if (dialStr.equals("*228")) {
                isOtaspDialString = true;
            }
        } else {
            int sysSelCodeInt = GsmCdmaPhone.extractSelCodeFromOtaSpNum(dialStr);
            switch (sysSelCodeInt) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    isOtaspDialString = true;
                    break;
                }
            }
        }
        return isOtaspDialString;
    }

    private static final int $$robo$$com_android_internal_telephony_GsmCdmaPhone$extractSelCodeFromOtaSpNum(String dialStr) {
        int dialStrLen = dialStr.length();
        int sysSelCodeInt = -1;
        if (dialStr.regionMatches(0, "*228", 0, 4) && dialStrLen >= 6) {
            sysSelCodeInt = Integer.parseInt(dialStr.substring(4, 6));
        }
        Rlog.d("GsmCdmaPhone", "extractSelCodeFromOtaSpNum " + sysSelCodeInt);
        return sysSelCodeInt;
    }

    private static final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$checkOtaSpNumBasedOnSysSelCode(int sysSelCodeInt, String[] sch) {
        boolean isOtaSpNum = false;
        try {
            int selRc = Integer.parseInt(sch[1]);
            for (int i = 0; i < selRc; ++i) {
                if (TextUtils.isEmpty(sch[i + 2]) || TextUtils.isEmpty(sch[i + 3])) continue;
                int selMin = Integer.parseInt(sch[i + 2]);
                int selMax = Integer.parseInt(sch[i + 3]);
                if (sysSelCodeInt < selMin || sysSelCodeInt > selMax) continue;
                isOtaSpNum = true;
                break;
            }
        }
        catch (NumberFormatException ex) {
            Rlog.e("GsmCdmaPhone", "checkOtaSpNumBasedOnSysSelCode, error", ex);
        }
        return isOtaSpNum;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isCarrierOtaSpNum(String dialStr) {
        boolean isOtaSpNum = false;
        int sysSelCodeInt = GsmCdmaPhone.extractSelCodeFromOtaSpNum(dialStr);
        if (sysSelCodeInt == -1) {
            return isOtaSpNum;
        }
        if (!TextUtils.isEmpty(this.mCarrierOtaSpNumSchema)) {
            Matcher m = pOtaSpNumSchema.matcher(this.mCarrierOtaSpNumSchema);
            Rlog.d("GsmCdmaPhone", "isCarrierOtaSpNum,schema" + this.mCarrierOtaSpNumSchema);
            if (m.find()) {
                String[] sch = pOtaSpNumSchema.split(this.mCarrierOtaSpNumSchema);
                if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("SELC")) {
                    if (sysSelCodeInt != -1) {
                        isOtaSpNum = GsmCdmaPhone.checkOtaSpNumBasedOnSysSelCode(sysSelCodeInt, sch);
                    } else {
                        Rlog.d("GsmCdmaPhone", "isCarrierOtaSpNum,sysSelCodeInt is invalid");
                    }
                } else if (!TextUtils.isEmpty(sch[0]) && sch[0].equals("FC")) {
                    String fc = sch[2];
                    int fcLen = Integer.parseInt(sch[1]);
                    if (dialStr.regionMatches(0, fc, 0, fcLen)) {
                        isOtaSpNum = true;
                    } else {
                        Rlog.d("GsmCdmaPhone", "isCarrierOtaSpNum,not otasp number");
                    }
                } else {
                    Rlog.d("GsmCdmaPhone", "isCarrierOtaSpNum,ota schema not supported" + sch[0]);
                }
            } else {
                Rlog.d("GsmCdmaPhone", "isCarrierOtaSpNum,ota schema pattern not right" + this.mCarrierOtaSpNumSchema);
            }
        } else {
            Rlog.d("GsmCdmaPhone", "isCarrierOtaSpNum,ota schema pattern empty");
        }
        return isOtaSpNum;
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isOtaSpNumber(String dialStr) {
        if (this.isPhoneTypeGsm()) {
            return super.isOtaSpNumber(dialStr);
        }
        boolean isOtaSpNum = false;
        String dialableStr = PhoneNumberUtils.extractNetworkPortionAlt(dialStr);
        if (dialableStr != null && !(isOtaSpNum = GsmCdmaPhone.isIs683OtaSpDialStr(dialableStr))) {
            isOtaSpNum = this.isCarrierOtaSpNum(dialableStr);
        }
        Rlog.d("GsmCdmaPhone", "isOtaSpNumber " + isOtaSpNum);
        return isOtaSpNum;
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaEriIconIndex() {
        if (this.isPhoneTypeGsm()) {
            return super.getCdmaEriIconIndex();
        }
        return this.getServiceState().getCdmaEriIconIndex();
    }

    private final int $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaEriIconMode() {
        if (this.isPhoneTypeGsm()) {
            return super.getCdmaEriIconMode();
        }
        return this.getServiceState().getCdmaEriIconMode();
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaEriText() {
        if (this.isPhoneTypeGsm()) {
            return super.getCdmaEriText();
        }
        int roamInd = this.getServiceState().getCdmaRoamingIndicator();
        int defRoamInd = this.getServiceState().getCdmaDefaultRoamingIndicator();
        return this.mEriManager.getCdmaEriText(roamInd, defRoamInd);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$phoneObjectUpdater(int newVoiceRadioTech) {
        this.logd("phoneObjectUpdater: newVoiceRadioTech=" + newVoiceRadioTech);
        if (ServiceState.isLte(newVoiceRadioTech) || newVoiceRadioTech == 0) {
            CarrierConfigManager configMgr = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
            PersistableBundle b = configMgr.getConfigForSubId(this.getSubId());
            if (b != null) {
                int volteReplacementRat = b.getInt("volte_replacement_rat_int");
                this.logd("phoneObjectUpdater: volteReplacementRat=" + volteReplacementRat);
                if (volteReplacementRat != 0) {
                    newVoiceRadioTech = volteReplacementRat;
                }
            } else {
                this.loge("phoneObjectUpdater: didn't get volteReplacementRat from carrier config");
            }
        }
        if (this.mRilVersion == 6 && this.getLteOnCdmaMode() == 1) {
            if (this.getPhoneType() == 2) {
                this.logd("phoneObjectUpdater: LTE ON CDMA property is set. Use CDMA Phone newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.getPhoneName());
                return;
            }
            this.logd("phoneObjectUpdater: LTE ON CDMA property is set. Switch to CDMALTEPhone newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.getPhoneName());
            newVoiceRadioTech = 6;
        } else {
            if (this.isShuttingDown()) {
                this.logd("Device is shutting down. No need to switch phone now.");
                return;
            }
            boolean matchCdma = ServiceState.isCdma(newVoiceRadioTech);
            boolean matchGsm = ServiceState.isGsm(newVoiceRadioTech);
            if (matchCdma && this.getPhoneType() == 2 || matchGsm && this.getPhoneType() == 1) {
                this.logd("phoneObjectUpdater: No change ignore, newVoiceRadioTech=" + newVoiceRadioTech + " mActivePhone=" + this.getPhoneName());
                return;
            }
            if (!matchCdma && !matchGsm) {
                this.loge("phoneObjectUpdater: newVoiceRadioTech=" + newVoiceRadioTech + " doesn't match either CDMA or GSM - error! No phone change");
                return;
            }
        }
        if (newVoiceRadioTech == 0) {
            this.logd("phoneObjectUpdater: Unknown rat ignore,  newVoiceRadioTech=Unknown. mActivePhone=" + this.getPhoneName());
            return;
        }
        boolean oldPowerState = false;
        if (this.mResetModemOnRadioTechnologyChange && this.mCi.getRadioState().isOn()) {
            oldPowerState = true;
            this.logd("phoneObjectUpdater: Setting Radio Power to Off");
            this.mCi.setRadioPower(false, null);
        }
        this.switchVoiceRadioTech(newVoiceRadioTech);
        if (this.mResetModemOnRadioTechnologyChange && oldPowerState) {
            this.logd("phoneObjectUpdater: Resetting Radio");
            this.mCi.setRadioPower(oldPowerState, null);
        }
        this.mIccCardProxy.setVoiceRadioTech(newVoiceRadioTech);
        Intent intent = new Intent("android.intent.action.RADIO_TECHNOLOGY");
        intent.putExtra("phoneName", this.getPhoneName());
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhoneId);
        ActivityManager.broadcastStickyIntent(intent, -1);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$switchVoiceRadioTech(int newVoiceRadioTech) {
        String outgoingPhoneName = this.getPhoneName();
        this.logd("Switching Voice Phone : " + outgoingPhoneName + " >>> " + (ServiceState.isGsm(newVoiceRadioTech) ? "GSM" : "CDMA"));
        if (ServiceState.isCdma(newVoiceRadioTech)) {
            this.switchPhoneType(6);
        } else if (ServiceState.isGsm(newVoiceRadioTech)) {
            this.switchPhoneType(1);
        } else {
            this.loge("deleteAndCreatePhone: newVoiceRadioTech=" + newVoiceRadioTech + " is not CDMA or GSM (error) - aborting!");
            return;
        }
    }

    private final IccSmsInterfaceManager $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccSmsInterfaceManager() {
        return this.mIccSmsInterfaceManager;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$updatePhoneObject(int voiceRadioTech) {
        this.logd("updatePhoneObject: radioTechnology=" + voiceRadioTech);
        this.sendMessage(this.obtainMessage(42, voiceRadioTech, 0, null));
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setImsRegistrationState(boolean registered) {
        this.mSST.setImsRegistrationState(registered);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccRecordsLoaded() {
        return this.mIccCardProxy.getIccRecordsLoaded();
    }

    private final IccCard $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccCard() {
        return this.mIccCardProxy;
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("GsmCdmaPhone extends:");
        super.dump(fd, pw, args);
        pw.println(" mPrecisePhoneType=" + this.mPrecisePhoneType);
        pw.println(" mCT=" + this.mCT);
        pw.println(" mSST=" + this.mSST);
        pw.println(" mPendingMMIs=" + this.mPendingMMIs);
        pw.println(" mIccPhoneBookIntManager=" + this.mIccPhoneBookIntManager);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mCdmaSubscriptionSource=" + this.mCdmaSubscriptionSource);
        pw.println(" mEriManager=" + this.mEriManager);
        pw.println(" mWakeLock=" + this.mWakeLock);
        pw.println(" isInEcm()=" + this.isInEcm());
        pw.println(" mCarrierOtaSpNumSchema=" + this.mCarrierOtaSpNumSchema);
        if (!this.isPhoneTypeGsm()) {
            pw.println(" getCdmaEriIconIndex()=" + this.getCdmaEriIconIndex());
            pw.println(" getCdmaEriIconMode()=" + this.getCdmaEriIconMode());
            pw.println(" getCdmaEriText()=" + this.getCdmaEriText());
            pw.println(" isMinInfoReady()=" + this.isMinInfoReady());
        }
        pw.println(" isCspPlmnEnabled()=" + this.isCspPlmnEnabled());
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        try {
            this.mIccCardProxy.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("DeviceStateMonitor:");
        this.mDeviceStateMonitor.dump(fd, pw, args);
        pw.println("++++++++++++++++++++++++++++++++");
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$setOperatorBrandOverride(String brand) {
        if (this.mUiccController == null) {
            return false;
        }
        UiccCard card = this.mUiccController.getUiccCard(this.getPhoneId());
        if (card == null) {
            return false;
        }
        boolean status = card.setOperatorBrandOverride(brand);
        if (status) {
            IccRecords iccRecords = (IccRecords)this.mIccRecords.get();
            if (iccRecords != null) {
                TelephonyManager.from(this.mContext).setSimOperatorNameForPhone(this.getPhoneId(), iccRecords.getServiceProviderName());
            }
            if (this.mSST != null) {
                this.mSST.pollState();
            }
        }
        return status;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getOperatorNumeric() {
        String operatorNumeric = null;
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                operatorNumeric = r.getOperatorNumeric();
            }
        } else {
            IccRecords curIccRecords = null;
            if (this.mCdmaSubscriptionSource == 1) {
                operatorNumeric = SystemProperties.get("ro.cdma.home.operator.numeric");
            } else if (this.mCdmaSubscriptionSource == 0) {
                curIccRecords = this.mSimRecords;
                if (curIccRecords != null) {
                    operatorNumeric = curIccRecords.getOperatorNumeric();
                } else {
                    curIccRecords = (IccRecords)this.mIccRecords.get();
                    if (curIccRecords != null && curIccRecords instanceof RuimRecords) {
                        RuimRecords csim = (RuimRecords)curIccRecords;
                        operatorNumeric = csim.getRUIMOperatorNumeric();
                    }
                }
            }
            if (operatorNumeric == null) {
                this.loge("getOperatorNumeric: Cannot retrieve operatorNumeric: mCdmaSubscriptionSource = " + this.mCdmaSubscriptionSource + " mIccRecords = " + (curIccRecords != null ? Boolean.valueOf(curIccRecords.getRecordsLoaded()) : null));
            }
            this.logd("getOperatorNumeric: mCdmaSubscriptionSource = " + this.mCdmaSubscriptionSource + " operatorNumeric = " + operatorNumeric);
        }
        return operatorNumeric;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCountryIso() {
        int subId = this.getSubId();
        SubscriptionInfo subInfo = SubscriptionManager.from(this.getContext()).getActiveSubscriptionInfo(subId);
        if (subInfo == null) {
            return null;
        }
        return subInfo.getCountryIso().toUpperCase();
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyEcbmTimerReset(Boolean flag) {
        this.mEcmTimerResetRegistrants.notifyResult(flag);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForEcmTimerReset(Handler h, int what, Object obj) {
        this.mEcmTimerResetRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForEcmTimerReset(Handler h) {
        this.mEcmTimerResetRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$setVoiceMessageWaiting(int line, int countWaiting) {
        if (this.isPhoneTypeGsm()) {
            IccRecords r = (IccRecords)this.mIccRecords.get();
            if (r != null) {
                r.setVoiceMessageWaiting(line, countWaiting);
            } else {
                this.logd("SIM Records not found, MWI not updated");
            }
        } else {
            this.setVoiceMessageCount(countWaiting);
        }
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$logd(String s) {
        Rlog.d("GsmCdmaPhone", "[GsmCdmaPhone] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$logi(String s) {
        Rlog.i("GsmCdmaPhone", "[GsmCdmaPhone] " + s);
    }

    private final void $$robo$$com_android_internal_telephony_GsmCdmaPhone$loge(String s) {
        Rlog.e("GsmCdmaPhone", "[GsmCdmaPhone] " + s);
    }

    private final boolean $$robo$$com_android_internal_telephony_GsmCdmaPhone$isUtEnabled() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null) {
            return imsPhone.isUtEnabled();
        }
        this.logd("isUtEnabled: called for GsmCdma");
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDtmfToneDelayKey() {
        return this.isPhoneTypeGsm() ? "gsm_dtmf_tone_delay_int" : "cdma_dtmf_tone_delay_int";
    }

    private final PowerManager.WakeLock $$robo$$com_android_internal_telephony_GsmCdmaPhone$getWakeLock() {
        return this.mWakeLock;
    }

    static void __staticInitializer__() {
        pOtaSpNumSchema = Pattern.compile("[,\\s]+");
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n, int n2, TelephonyComponentFactory telephonyComponentFactory) {
        this.$$robo$$com_android_internal_telephony_GsmCdmaPhone$__constructor__(context, commandsInterface, phoneNotifier, n, n2, telephonyComponentFactory);
    }

    public GsmCdmaPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, int n, int n2, TelephonyComponentFactory telephonyComponentFactory) {
        this(context, commandsInterface, phoneNotifier, false, n, n2, telephonyComponentFactory);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier int int com.android.internal.telephony.TelephonyComponentFactory ), 0, this, context, commandsInterface, phoneNotifier, n, n2, telephonyComponentFactory);
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl, int n, int n2, TelephonyComponentFactory telephonyComponentFactory) {
        this.$$robo$$com_android_internal_telephony_GsmCdmaPhone$__constructor__(context, commandsInterface, phoneNotifier, bl, n, n2, telephonyComponentFactory);
    }

    public GsmCdmaPhone(Context context, CommandsInterface commandsInterface, PhoneNotifier phoneNotifier, boolean bl, int n, int n2, TelephonyComponentFactory telephonyComponentFactory) {
        super(n2 == 1 ? "GSM" : "CDMA", phoneNotifier, context, commandsInterface, bl, n, telephonyComponentFactory);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaPhone$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface com.android.internal.telephony.PhoneNotifier boolean int int com.android.internal.telephony.TelephonyComponentFactory ), 0, this, context, commandsInterface, phoneNotifier, bl, n, n2, telephonyComponentFactory);
    }

    private void initOnce(CommandsInterface commandsInterface) {
        InvokeDynamicSupport.bootstrap("initOnce", $$robo$$com_android_internal_telephony_GsmCdmaPhone$initOnce(com.android.internal.telephony.CommandsInterface ), 0, this, commandsInterface);
    }

    private void initRatSpecific(int n) {
        InvokeDynamicSupport.bootstrap("initRatSpecific", $$robo$$com_android_internal_telephony_GsmCdmaPhone$initRatSpecific(int ), 0, this, n);
    }

    private void setIsoCountryProperty(String string2) {
        InvokeDynamicSupport.bootstrap("setIsoCountryProperty", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setIsoCountryProperty(java.lang.String ), 0, this, string2);
    }

    public boolean isPhoneTypeGsm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneTypeGsm", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isPhoneTypeGsm(), 0, this);
    }

    public boolean isPhoneTypeCdma() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneTypeCdma", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isPhoneTypeCdma(), 0, this);
    }

    public boolean isPhoneTypeCdmaLte() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneTypeCdmaLte", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isPhoneTypeCdmaLte(), 0, this);
    }

    private void switchPhoneType(int n) {
        InvokeDynamicSupport.bootstrap("switchPhoneType", $$robo$$com_android_internal_telephony_GsmCdmaPhone$switchPhoneType(int ), 0, this, n);
    }

    protected void finalize() {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_telephony_GsmCdmaPhone$finalize(), 0, this);
    }

    @Override
    public ServiceState getServiceState() {
        return InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getServiceState(), 0, this);
    }

    @Override
    public CellLocation getCellLocation(WorkSource workSource) {
        return InvokeDynamicSupport.bootstrap("getCellLocation", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCellLocation(android.os.WorkSource ), 0, this, workSource);
    }

    @Override
    public PhoneConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getState(), 0, this);
    }

    @Override
    public int getPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneType", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getPhoneType(), 0, this);
    }

    @Override
    public ServiceStateTracker getServiceStateTracker() {
        return InvokeDynamicSupport.bootstrap("getServiceStateTracker", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getServiceStateTracker(), 0, this);
    }

    @Override
    public CallTracker getCallTracker() {
        return InvokeDynamicSupport.bootstrap("getCallTracker", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCallTracker(), 0, this);
    }

    @Override
    public void updateVoiceMail() {
        InvokeDynamicSupport.bootstrap("updateVoiceMail", $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateVoiceMail(), 0, this);
    }

    @Override
    public List<? extends MmiCode> getPendingMmiCodes() {
        return InvokeDynamicSupport.bootstrap("getPendingMmiCodes", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getPendingMmiCodes(), 0, this);
    }

    @Override
    public PhoneConstants.DataState getDataConnectionState(String string2) {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataConnectionState(java.lang.String ), 0, this, string2);
    }

    @Override
    public PhoneInternalInterface.DataActivityState getDataActivityState() {
        return InvokeDynamicSupport.bootstrap("getDataActivityState", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataActivityState(), 0, this);
    }

    public void notifyPhoneStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyPhoneStateChanged", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyPhoneStateChanged(), 0, this);
    }

    public void notifyPreciseCallStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyPreciseCallStateChanged", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyPreciseCallStateChanged(), 0, this);
    }

    public void notifyNewRingingConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyNewRingingConnection", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyNewRingingConnection(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    public void notifyDisconnect(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyDisconnect", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyDisconnect(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    public void notifyUnknownConnection(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyUnknownConnection", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyUnknownConnection(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    @Override
    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isInEmergencyCall(), 0, this);
    }

    @Override
    protected void setIsInEmergencyCall() {
        InvokeDynamicSupport.bootstrap("setIsInEmergencyCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setIsInEmergencyCall(), 0, this);
    }

    private void sendEmergencyCallbackModeChange() {
        InvokeDynamicSupport.bootstrap("sendEmergencyCallbackModeChange", $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendEmergencyCallbackModeChange(), 0, this);
    }

    @Override
    public void sendEmergencyCallStateChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("sendEmergencyCallStateChange", $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendEmergencyCallStateChange(boolean ), 0, this, bl);
    }

    @Override
    public void setBroadcastEmergencyCallStateChanges(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBroadcastEmergencyCallStateChanges", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setBroadcastEmergencyCallStateChanges(boolean ), 0, this, bl);
    }

    public void notifySuppServiceFailed(PhoneInternalInterface.SuppService suppService) {
        InvokeDynamicSupport.bootstrap("notifySuppServiceFailed", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifySuppServiceFailed(com.android.internal.telephony.PhoneInternalInterface$SuppService ), 0, this, suppService);
    }

    public void notifyServiceStateChanged(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("notifyServiceStateChanged", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyServiceStateChanged(android.telephony.ServiceState ), 0, this, serviceState);
    }

    public void notifyLocationChanged() {
        InvokeDynamicSupport.bootstrap("notifyLocationChanged", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyLocationChanged(), 0, this);
    }

    @Override
    public void notifyCallForwardingIndicator() {
        InvokeDynamicSupport.bootstrap("notifyCallForwardingIndicator", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyCallForwardingIndicator(), 0, this);
    }

    @Override
    public void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void registerForSuppServiceNotification(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceNotification", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForSuppServiceNotification(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSuppServiceNotification(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceNotification", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForSuppServiceNotification(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSimRecordsLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSimRecordsLoaded", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForSimRecordsLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSimRecordsLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSimRecordsLoaded", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForSimRecordsLoaded(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void acceptCall(int n) throws CallStateException {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$acceptCall(int ), 0, this, n);
    }

    @Override
    public void rejectCall() throws CallStateException {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$rejectCall(), 0, this);
    }

    @Override
    public void switchHoldingAndActive() throws CallStateException {
        InvokeDynamicSupport.bootstrap("switchHoldingAndActive", $$robo$$com_android_internal_telephony_GsmCdmaPhone$switchHoldingAndActive(), 0, this);
    }

    @Override
    public String getIccSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getIccSerialNumber", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccSerialNumber(), 0, this);
    }

    @Override
    public String getFullIccSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getFullIccSerialNumber", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getFullIccSerialNumber(), 0, this);
    }

    @Override
    public boolean canConference() {
        return (boolean)InvokeDynamicSupport.bootstrap("canConference", $$robo$$com_android_internal_telephony_GsmCdmaPhone$canConference(), 0, this);
    }

    @Override
    public void conference() {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_GsmCdmaPhone$conference(), 0, this);
    }

    @Override
    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("enableEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_GsmCdmaPhone$enableEnhancedVoicePrivacy(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getEnhancedVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getEnhancedVoicePrivacy(android.os.Message ), 0, this, message);
    }

    @Override
    public void clearDisconnected() {
        InvokeDynamicSupport.bootstrap("clearDisconnected", $$robo$$com_android_internal_telephony_GsmCdmaPhone$clearDisconnected(), 0, this);
    }

    @Override
    public boolean canTransfer() {
        return (boolean)InvokeDynamicSupport.bootstrap("canTransfer", $$robo$$com_android_internal_telephony_GsmCdmaPhone$canTransfer(), 0, this);
    }

    @Override
    public void explicitCallTransfer() {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_GsmCdmaPhone$explicitCallTransfer(), 0, this);
    }

    @Override
    public GsmCdmaCall getForegroundCall() {
        return InvokeDynamicSupport.bootstrap("getForegroundCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getForegroundCall(), 0, this);
    }

    @Override
    public GsmCdmaCall getBackgroundCall() {
        return InvokeDynamicSupport.bootstrap("getBackgroundCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getBackgroundCall(), 0, this);
    }

    @Override
    public Call getRingingCall() {
        return InvokeDynamicSupport.bootstrap("getRingingCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getRingingCall(), 0, this);
    }

    private boolean handleCallDeflectionIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallDeflectionIncallSupplementaryService", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCallDeflectionIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleCallWaitingIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallWaitingIncallSupplementaryService", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCallWaitingIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleCallHoldIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCallHoldIncallSupplementaryService", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCallHoldIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleMultipartyIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMultipartyIncallSupplementaryService", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleMultipartyIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleEctIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleEctIncallSupplementaryService", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleEctIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    private boolean handleCcbsIncallSupplementaryService(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleCcbsIncallSupplementaryService", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCcbsIncallSupplementaryService(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean handleInCallMmiCommands(String string2) throws CallStateException {
        return (boolean)InvokeDynamicSupport.bootstrap("handleInCallMmiCommands", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleInCallMmiCommands(java.lang.String ), 0, this, string2);
    }

    public boolean isInCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInCall", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isInCall(), 0, this);
    }

    @Override
    public Connection dial(String string2, int n) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_GsmCdmaPhone$dial(java.lang.String int ), 0, this, string2, n);
    }

    @Override
    public Connection dial(String string2, UUSInfo uUSInfo, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_GsmCdmaPhone$dial(java.lang.String com.android.internal.telephony.UUSInfo int android.os.Bundle ), 0, this, string2, uUSInfo, n, bundle);
    }

    public boolean isNotificationOfWfcCallRequired(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNotificationOfWfcCallRequired", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isNotificationOfWfcCallRequired(java.lang.String ), 0, this, string2);
    }

    @Override
    protected Connection dialInternal(String string2, UUSInfo uUSInfo, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_GsmCdmaPhone$dialInternal(java.lang.String com.android.internal.telephony.UUSInfo int android.os.Bundle ), 0, this, string2, uUSInfo, n, bundle);
    }

    protected Connection dialInternal(String string2, UUSInfo uUSInfo, int n, Bundle bundle, ResultReceiver resultReceiver) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_GsmCdmaPhone$dialInternal(java.lang.String com.android.internal.telephony.UUSInfo int android.os.Bundle android.os.ResultReceiver ), 0, this, string2, uUSInfo, n, bundle, resultReceiver);
    }

    @Override
    public boolean handlePinMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePinMmi", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handlePinMmi(java.lang.String ), 0, this, string2);
    }

    private void sendUssdResponse(String string2, CharSequence charSequence, int n, ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendUssdResponse(java.lang.String java.lang.CharSequence int android.os.ResultReceiver ), 0, this, string2, charSequence, n, resultReceiver);
    }

    @Override
    public boolean handleUssdRequest(String string2, ResultReceiver resultReceiver) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleUssdRequest", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleUssdRequest(java.lang.String android.os.ResultReceiver ), 0, this, string2, resultReceiver);
    }

    @Override
    public void sendUssdResponse(String string2) {
        InvokeDynamicSupport.bootstrap("sendUssdResponse", $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendUssdResponse(java.lang.String ), 0, this, string2);
    }

    @Override
    public void sendDtmf(char c) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendDtmf(char ), 0, this, c);
    }

    @Override
    public void startDtmf(char c) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_GsmCdmaPhone$startDtmf(char ), 0, this, c);
    }

    @Override
    public void stopDtmf() {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_GsmCdmaPhone$stopDtmf(), 0, this);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_GsmCdmaPhone$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    @Override
    public void setRadioPower(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setRadioPower(boolean ), 0, this, bl);
    }

    private void storeVoiceMailNumber(String string2) {
        InvokeDynamicSupport.bootstrap("storeVoiceMailNumber", $$robo$$com_android_internal_telephony_GsmCdmaPhone$storeVoiceMailNumber(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getVoiceMailNumber(), 0, this);
    }

    private String getVmSimImsi() {
        return InvokeDynamicSupport.bootstrap("getVmSimImsi", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getVmSimImsi(), 0, this);
    }

    private void setVmSimImsi(String string2) {
        InvokeDynamicSupport.bootstrap("setVmSimImsi", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setVmSimImsi(java.lang.String ), 0, this, string2);
    }

    @Override
    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getVoiceMailAlphaTag(), 0, this);
    }

    @Override
    public String getDeviceId() {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDeviceId(), 0, this);
    }

    @Override
    public String getDeviceSvn() {
        return InvokeDynamicSupport.bootstrap("getDeviceSvn", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDeviceSvn(), 0, this);
    }

    @Override
    public IsimRecords getIsimRecords() {
        return InvokeDynamicSupport.bootstrap("getIsimRecords", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIsimRecords(), 0, this);
    }

    @Override
    public String getImei() {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getImei(), 0, this);
    }

    @Override
    public String getEsn() {
        return InvokeDynamicSupport.bootstrap("getEsn", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getEsn(), 0, this);
    }

    @Override
    public String getMeid() {
        return InvokeDynamicSupport.bootstrap("getMeid", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getMeid(), 0, this);
    }

    @Override
    public String getNai() {
        return InvokeDynamicSupport.bootstrap("getNai", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getNai(), 0, this);
    }

    @Override
    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getSubscriberId(), 0, this);
    }

    @Override
    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int n) {
        return InvokeDynamicSupport.bootstrap("getCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCarrierInfoForImsiEncryption(int ), 0, this, n);
    }

    @Override
    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
        InvokeDynamicSupport.bootstrap("setCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo ), 0, this, imsiEncryptionInfo);
    }

    @Override
    public String getGroupIdLevel1() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getGroupIdLevel1(), 0, this);
    }

    @Override
    public String getGroupIdLevel2() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel2", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getGroupIdLevel2(), 0, this);
    }

    @Override
    public String getLine1Number() {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getLine1Number(), 0, this);
    }

    @Override
    public String getCdmaPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getCdmaPrlVersion", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaPrlVersion(), 0, this);
    }

    @Override
    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaMin(), 0, this);
    }

    @Override
    public boolean isMinInfoReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMinInfoReady", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isMinInfoReady(), 0, this);
    }

    @Override
    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getMsisdn(), 0, this);
    }

    @Override
    public String getLine1AlphaTag() {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getLine1AlphaTag(), 0, this);
    }

    @Override
    public boolean setLine1Number(String string2, String string3, Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("setLine1Number", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setLine1Number(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void setVoiceMailNumber(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setVoiceMailNumber(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    private boolean isValidCommandInterfaceCFReason(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidCommandInterfaceCFReason", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isValidCommandInterfaceCFReason(int ), 0, this, n);
    }

    @Override
    public String getSystemProperty(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSystemProperty", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private boolean isValidCommandInterfaceCFAction(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidCommandInterfaceCFAction", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isValidCommandInterfaceCFAction(int ), 0, this, n);
    }

    private boolean isCfEnable(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCfEnable", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isCfEnable(int ), 0, this, n);
    }

    @Override
    public void getCallForwardingOption(int n, Message message) {
        InvokeDynamicSupport.bootstrap("getCallForwardingOption", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCallForwardingOption(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCallForwardingOption(int n, int n2, String string2, int n3, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForwardingOption", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCallForwardingOption(int int java.lang.String int android.os.Message ), 0, this, n, n2, string2, n3, message);
    }

    @Override
    public void getOutgoingCallerIdDisplay(Message message) {
        InvokeDynamicSupport.bootstrap("getOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getOutgoingCallerIdDisplay(android.os.Message ), 0, this, message);
    }

    @Override
    public void setOutgoingCallerIdDisplay(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setOutgoingCallerIdDisplay", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setOutgoingCallerIdDisplay(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCallWaiting(Message message) {
        InvokeDynamicSupport.bootstrap("getCallWaiting", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCallWaiting(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCallWaiting(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCallWaiting(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getAvailableNetworks(android.os.Message ), 0, this, message);
    }

    @Override
    public void startNetworkScan(NetworkScanRequest networkScanRequest, Message message) {
        InvokeDynamicSupport.bootstrap("startNetworkScan", $$robo$$com_android_internal_telephony_GsmCdmaPhone$startNetworkScan(android.telephony.NetworkScanRequest android.os.Message ), 0, this, networkScanRequest, message);
    }

    @Override
    public void stopNetworkScan(Message message) {
        InvokeDynamicSupport.bootstrap("stopNetworkScan", $$robo$$com_android_internal_telephony_GsmCdmaPhone$stopNetworkScan(android.os.Message ), 0, this, message);
    }

    @Override
    public void getNeighboringCids(Message message, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("getNeighboringCids", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getNeighboringCids(android.os.Message android.os.WorkSource ), 0, this, message, workSource);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setTTYMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setTTYMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setUiTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUiTTYMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setUiTTYMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setMute(boolean bl) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setMute(boolean ), 0, this, bl);
    }

    @Override
    public boolean getMute() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getMute(), 0, this);
    }

    @Override
    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataCallList(android.os.Message ), 0, this, message);
    }

    @Override
    public void updateServiceLocation() {
        InvokeDynamicSupport.bootstrap("updateServiceLocation", $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateServiceLocation(), 0, this);
    }

    @Override
    public void enableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$com_android_internal_telephony_GsmCdmaPhone$enableLocationUpdates(), 0, this);
    }

    @Override
    public void disableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$com_android_internal_telephony_GsmCdmaPhone$disableLocationUpdates(), 0, this);
    }

    @Override
    public boolean getDataRoamingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataRoamingEnabled", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataRoamingEnabled(), 0, this);
    }

    @Override
    public void setDataRoamingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataRoamingEnabled", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setDataRoamingEnabled(boolean ), 0, this, bl);
    }

    @Override
    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForCdmaOtaStatusChange(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForCdmaOtaStatusChange(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForSubscriptionInfoReady(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForSubscriptionInfoReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForSubscriptionInfoReady(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setOnEcbModeExitResponse(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unsetOnEcbModeExitResponse(Handler handler) {
        InvokeDynamicSupport.bootstrap("unsetOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unsetOnEcbModeExitResponse(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    @Override
    public boolean getDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataEnabled", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDataEnabled(), 0, this);
    }

    @Override
    public void setDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataEnabled", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setDataEnabled(boolean ), 0, this, bl);
    }

    public void onMMIDone(MmiCode mmiCode) {
        InvokeDynamicSupport.bootstrap("onMMIDone", $$robo$$com_android_internal_telephony_GsmCdmaPhone$onMMIDone(com.android.internal.telephony.MmiCode ), 0, this, mmiCode);
    }

    public boolean supports3gppCallForwardingWhileRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("supports3gppCallForwardingWhileRoaming", $$robo$$com_android_internal_telephony_GsmCdmaPhone$supports3gppCallForwardingWhileRoaming(), 0, this);
    }

    private void onNetworkInitiatedUssd(MmiCode mmiCode) {
        InvokeDynamicSupport.bootstrap("onNetworkInitiatedUssd", $$robo$$com_android_internal_telephony_GsmCdmaPhone$onNetworkInitiatedUssd(com.android.internal.telephony.MmiCode ), 0, this, mmiCode);
    }

    private void onIncomingUSSD(int n, String string2) {
        InvokeDynamicSupport.bootstrap("onIncomingUSSD", $$robo$$com_android_internal_telephony_GsmCdmaPhone$onIncomingUSSD(int java.lang.String ), 0, this, n, string2);
    }

    private void syncClirSetting() {
        InvokeDynamicSupport.bootstrap("syncClirSetting", $$robo$$com_android_internal_telephony_GsmCdmaPhone$syncClirSetting(), 0, this);
    }

    private void handleRadioAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioAvailable", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleRadioAvailable(), 0, this);
    }

    private void handleRadioOn() {
        InvokeDynamicSupport.bootstrap("handleRadioOn", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleRadioOn(), 0, this);
    }

    private void handleRadioOffOrNotAvailable() {
        InvokeDynamicSupport.bootstrap("handleRadioOffOrNotAvailable", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleRadioOffOrNotAvailable(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleMessage(android.os.Message ), 0, this, message);
    }

    public UiccCardApplication getUiccCardApplication() {
        return InvokeDynamicSupport.bootstrap("getUiccCardApplication", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getUiccCardApplication(), 0, this);
    }

    @Override
    protected void onUpdateIccAvailability() {
        InvokeDynamicSupport.bootstrap("onUpdateIccAvailability", $$robo$$com_android_internal_telephony_GsmCdmaPhone$onUpdateIccAvailability(), 0, this);
    }

    private void processIccRecordEvents(int n) {
        InvokeDynamicSupport.bootstrap("processIccRecordEvents", $$robo$$com_android_internal_telephony_GsmCdmaPhone$processIccRecordEvents(int ), 0, this, n);
    }

    @Override
    public boolean updateCurrentCarrierInProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateCurrentCarrierInProvider(), 0, this);
    }

    private boolean updateCurrentCarrierInProvider(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_GsmCdmaPhone$updateCurrentCarrierInProvider(java.lang.String ), 0, this, string2);
    }

    private void handleCfuQueryResult(CallForwardInfo[] callForwardInfoArray) {
        InvokeDynamicSupport.bootstrap("handleCfuQueryResult", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleCfuQueryResult(com.android.internal.telephony.CallForwardInfo[] ), 0, this, callForwardInfoArray);
    }

    @Override
    public IccPhoneBookInterfaceManager getIccPhoneBookInterfaceManager() {
        return InvokeDynamicSupport.bootstrap("getIccPhoneBookInterfaceManager", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccPhoneBookInterfaceManager(), 0, this);
    }

    public void registerForEriFileLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEriFileLoaded", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForEriFileLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForEriFileLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEriFileLoaded", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForEriFileLoaded(android.os.Handler ), 0, this, handler);
    }

    public void prepareEri() {
        InvokeDynamicSupport.bootstrap("prepareEri", $$robo$$com_android_internal_telephony_GsmCdmaPhone$prepareEri(), 0, this);
    }

    public boolean isEriFileLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEriFileLoaded", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isEriFileLoaded(), 0, this);
    }

    @Override
    public void activateCellBroadcastSms(int n, Message message) {
        InvokeDynamicSupport.bootstrap("activateCellBroadcastSms", $$robo$$com_android_internal_telephony_GsmCdmaPhone$activateCellBroadcastSms(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getCellBroadcastSmsConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCellBroadcastSmsConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCellBroadcastSmsConfig(int[] nArray, Message message) {
        InvokeDynamicSupport.bootstrap("setCellBroadcastSmsConfig", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setCellBroadcastSmsConfig(int[] android.os.Message ), 0, this, nArray, message);
    }

    @Override
    public boolean needsOtaServiceProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsOtaServiceProvisioning", $$robo$$com_android_internal_telephony_GsmCdmaPhone$needsOtaServiceProvisioning(), 0, this);
    }

    @Override
    public boolean isCspPlmnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCspPlmnEnabled", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isCspPlmnEnabled(), 0, this);
    }

    public boolean shouldForceAutoNetworkSelect() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldForceAutoNetworkSelect", $$robo$$com_android_internal_telephony_GsmCdmaPhone$shouldForceAutoNetworkSelect(), 0, this);
    }

    private boolean isManualSelProhibitedInGlobalMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isManualSelProhibitedInGlobalMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isManualSelProhibitedInGlobalMode(), 0, this);
    }

    private void registerForIccRecordEvents() {
        InvokeDynamicSupport.bootstrap("registerForIccRecordEvents", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForIccRecordEvents(), 0, this);
    }

    private void unregisterForIccRecordEvents() {
        InvokeDynamicSupport.bootstrap("unregisterForIccRecordEvents", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForIccRecordEvents(), 0, this);
    }

    @Override
    public void exitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$exitEmergencyCallbackMode(), 0, this);
    }

    private void handleEnterEmergencyCallbackMode(Message message) {
        InvokeDynamicSupport.bootstrap("handleEnterEmergencyCallbackMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleEnterEmergencyCallbackMode(android.os.Message ), 0, this, message);
    }

    private void handleExitEmergencyCallbackMode(Message message) {
        InvokeDynamicSupport.bootstrap("handleExitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleExitEmergencyCallbackMode(android.os.Message ), 0, this, message);
    }

    public void notifyEmergencyCallRegistrants(boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyEmergencyCallRegistrants", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyEmergencyCallRegistrants(boolean ), 0, this, bl);
    }

    public void handleTimerInEmergencyCallbackMode(int n) {
        InvokeDynamicSupport.bootstrap("handleTimerInEmergencyCallbackMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$handleTimerInEmergencyCallbackMode(int ), 0, this, n);
    }

    private static boolean isIs683OtaSpDialStr(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isIs683OtaSpDialStr", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isIs683OtaSpDialStr(java.lang.String ), 0, (String)string2);
    }

    private static int extractSelCodeFromOtaSpNum(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("extractSelCodeFromOtaSpNum", $$robo$$com_android_internal_telephony_GsmCdmaPhone$extractSelCodeFromOtaSpNum(java.lang.String ), 0, (String)string2);
    }

    private static boolean checkOtaSpNumBasedOnSysSelCode(int n, String[] stringArray) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkOtaSpNumBasedOnSysSelCode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$checkOtaSpNumBasedOnSysSelCode(int java.lang.String[] ), 0, (int)n, (String[])stringArray);
    }

    private boolean isCarrierOtaSpNum(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCarrierOtaSpNum", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isCarrierOtaSpNum(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isOtaSpNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOtaSpNumber", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isOtaSpNumber(java.lang.String ), 0, this, string2);
    }

    @Override
    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaEriIconIndex(), 0, this);
    }

    @Override
    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaEriIconMode(), 0, this);
    }

    @Override
    public String getCdmaEriText() {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCdmaEriText(), 0, this);
    }

    private void phoneObjectUpdater(int n) {
        InvokeDynamicSupport.bootstrap("phoneObjectUpdater", $$robo$$com_android_internal_telephony_GsmCdmaPhone$phoneObjectUpdater(int ), 0, this, n);
    }

    private void switchVoiceRadioTech(int n) {
        InvokeDynamicSupport.bootstrap("switchVoiceRadioTech", $$robo$$com_android_internal_telephony_GsmCdmaPhone$switchVoiceRadioTech(int ), 0, this, n);
    }

    @Override
    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return InvokeDynamicSupport.bootstrap("getIccSmsInterfaceManager", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccSmsInterfaceManager(), 0, this);
    }

    @Override
    public void updatePhoneObject(int n) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_GsmCdmaPhone$updatePhoneObject(int ), 0, this, n);
    }

    @Override
    public void setImsRegistrationState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setImsRegistrationState(boolean ), 0, this, bl);
    }

    @Override
    public boolean getIccRecordsLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccRecordsLoaded", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccRecordsLoaded(), 0, this);
    }

    @Override
    public IccCard getIccCard() {
        return InvokeDynamicSupport.bootstrap("getIccCard", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getIccCard(), 0, this);
    }

    @Override
    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_GsmCdmaPhone$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    @Override
    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    private String getOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getOperatorNumeric", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getOperatorNumeric(), 0, this);
    }

    public String getCountryIso() {
        return InvokeDynamicSupport.bootstrap("getCountryIso", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getCountryIso(), 0, this);
    }

    public void notifyEcbmTimerReset(Boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyEcbmTimerReset", $$robo$$com_android_internal_telephony_GsmCdmaPhone$notifyEcbmTimerReset(java.lang.Boolean ), 0, this, bl);
    }

    @Override
    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEcmTimerReset", $$robo$$com_android_internal_telephony_GsmCdmaPhone$registerForEcmTimerReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForEcmTimerReset(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEcmTimerReset", $$robo$$com_android_internal_telephony_GsmCdmaPhone$unregisterForEcmTimerReset(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_GsmCdmaPhone$setVoiceMessageWaiting(int int ), 0, this, n, n2);
    }

    private void logd(String string2) {
        InvokeDynamicSupport.bootstrap("logd", $$robo$$com_android_internal_telephony_GsmCdmaPhone$logd(java.lang.String ), 0, this, string2);
    }

    private void logi(String string2) {
        InvokeDynamicSupport.bootstrap("logi", $$robo$$com_android_internal_telephony_GsmCdmaPhone$logi(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_GsmCdmaPhone$loge(java.lang.String ), 0, this, string2);
    }

    @Override
    public boolean isUtEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUtEnabled", $$robo$$com_android_internal_telephony_GsmCdmaPhone$isUtEnabled(), 0, this);
    }

    public String getDtmfToneDelayKey() {
        return InvokeDynamicSupport.bootstrap("getDtmfToneDelayKey", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getDtmfToneDelayKey(), 0, this);
    }

    public PowerManager.WakeLock getWakeLock() {
        return InvokeDynamicSupport.bootstrap("getWakeLock", $$robo$$com_android_internal_telephony_GsmCdmaPhone$getWakeLock(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(GsmCdmaPhone.class);
    }

    public /* synthetic */ GsmCdmaPhone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GsmCdmaPhone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Cfu
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        String mSetCfNumber;
        Message mOnComplete;

        private void $$robo$$com_android_internal_telephony_GsmCdmaPhone_Cfu$__constructor__(String cfNumber, Message onComplete) {
            this.mSetCfNumber = cfNumber;
            this.mOnComplete = onComplete;
        }

        private void __constructor__(String string2, Message message) {
            this.$$robo$$com_android_internal_telephony_GsmCdmaPhone_Cfu$__constructor__(string2, message);
        }

        Cfu(String string2, Message message) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_GsmCdmaPhone_Cfu$__constructor__(java.lang.String android.os.Message ), 0, this, string2, message);
        }

        public /* synthetic */ Cfu() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Cfu)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

