/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.AsyncResult;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcelable;
import android.os.RemoteException;
import android.telephony.CellInfo;
import android.telephony.NetworkScanRequest;
import android.telephony.RadioAccessSpecifier;
import android.util.Log;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.NetworkScanResult;
import com.android.internal.telephony.Phone;
import com.google.errorprone.annotations.DoNotMock;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class NetworkScanRequestTracker
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "ScanRequestTracker";
    private static int CMD_START_NETWORK_SCAN = 1;
    private static int EVENT_START_NETWORK_SCAN_DONE = 2;
    private static int EVENT_RECEIVE_NETWORK_SCAN_RESULT = 3;
    private static int CMD_STOP_NETWORK_SCAN = 4;
    private static int EVENT_STOP_NETWORK_SCAN_DONE = 5;
    private static int CMD_INTERRUPT_NETWORK_SCAN = 6;
    private static int EVENT_INTERRUPT_NETWORK_SCAN_DONE = 7;
    private Handler mHandler;
    private AtomicInteger mNextNetworkScanRequestId;
    private NetworkScanRequestScheduler mScheduler;

    private void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$__constructor__() {
        this.mHandler = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ NetworkScanRequestTracker this$0;

            private void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_1$__constructor__(NetworkScanRequestTracker this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.this$0.mScheduler.doStartScan((NetworkScanRequestInfo)msg.obj);
                        break;
                    }
                    case 2: {
                        this.this$0.mScheduler.startScanDone((AsyncResult)msg.obj);
                        break;
                    }
                    case 3: {
                        this.this$0.mScheduler.receiveResult((AsyncResult)msg.obj);
                        break;
                    }
                    case 4: {
                        this.this$0.mScheduler.doStopScan(msg.arg1);
                        break;
                    }
                    case 5: {
                        this.this$0.mScheduler.stopScanDone((AsyncResult)msg.obj);
                        break;
                    }
                    case 6: {
                        this.this$0.mScheduler.doInterruptScan(msg.arg1);
                        break;
                    }
                    case 7: {
                        this.this$0.mScheduler.interruptScanDone((AsyncResult)msg.obj);
                    }
                }
            }

            private void __constructor__(NetworkScanRequestTracker networkScanRequestTracker) {
                this.$$robo$$com_android_internal_telephony_NetworkScanRequestTracker_1$__constructor__(networkScanRequestTracker);
            }
            {
                this.this$0 = networkScanRequestTracker;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_1$__constructor__(com.android.internal.telephony.NetworkScanRequestTracker ), 0, this, networkScanRequestTracker);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_1$handleMessage(android.os.Message ), 0, this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mNextNetworkScanRequestId = new AtomicInteger(1);
        this.mScheduler = new NetworkScanRequestScheduler(this);
    }

    private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$logEmptyResultOrException(AsyncResult ar) {
        if (ar.result == null) {
            Log.e("ScanRequestTracker", "NetworkScanResult: Empty result");
        } else {
            Log.e("ScanRequestTracker", "NetworkScanResult: Exception: " + ar.exception);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$isValidScan(NetworkScanRequestInfo nsri) {
        if (((NetworkScanRequestInfo)nsri).mRequest.specifiers == null) {
            return false;
        }
        if (((NetworkScanRequestInfo)nsri).mRequest.specifiers.length > 8) {
            return false;
        }
        for (RadioAccessSpecifier ras : ((NetworkScanRequestInfo)nsri).mRequest.specifiers) {
            if (ras.radioAccessNetwork != 1 && ras.radioAccessNetwork != 2 && ras.radioAccessNetwork != 3) {
                return false;
            }
            if (ras.bands != null && ras.bands.length > 8) {
                return false;
            }
            if (ras.channels == null || ras.channels.length <= 32) continue;
            return false;
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$notifyMessenger(NetworkScanRequestInfo nsri, int what, int err, List<CellInfo> result) {
        Messenger messenger = nsri.mMessenger;
        Message message = Message.obtain();
        message.what = what;
        message.arg1 = err;
        message.arg2 = nsri.mScanId;
        if (result != null) {
            Parcelable[] ci = result.toArray(new CellInfo[result.size()]);
            Bundle b = new Bundle();
            b.putParcelableArray("scanResult", ci);
            message.setData(b);
        } else {
            message.obj = null;
        }
        try {
            messenger.send(message);
        }
        catch (RemoteException e) {
            Log.e("ScanRequestTracker", "Exception in notifyMessenger: " + e);
        }
    }

    private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$interruptNetworkScan(int scanId) {
        this.mHandler.obtainMessage(6, scanId, 0).sendToTarget();
    }

    private final int $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$startNetworkScan(NetworkScanRequest request, Messenger messenger, IBinder binder, Phone phone) {
        int scanId = this.mNextNetworkScanRequestId.getAndIncrement();
        NetworkScanRequestInfo nsri = new NetworkScanRequestInfo(this, request, messenger, binder, scanId, phone);
        this.mHandler.obtainMessage(1, nsri).sendToTarget();
        return scanId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$stopNetworkScan(int scanId) {
        NetworkScanRequestScheduler networkScanRequestScheduler = this.mScheduler;
        synchronized (networkScanRequestScheduler) {
            if (!(this.mScheduler.mLiveRequestInfo != null && scanId == this.mScheduler.mLiveRequestInfo.mScanId && Binder.getCallingUid() == this.mScheduler.mLiveRequestInfo.mUid || this.mScheduler.mPendingRequestInfo != null && scanId == this.mScheduler.mPendingRequestInfo.mScanId && Binder.getCallingUid() == this.mScheduler.mPendingRequestInfo.mUid)) {
                throw new IllegalArgumentException("Scan with id: " + scanId + " does not exist!");
            }
            this.mHandler.obtainMessage(4, scanId, 0).sendToTarget();
        }
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_NetworkScanRequestTracker$__constructor__();
    }

    public NetworkScanRequestTracker() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$__constructor__(), 0, this);
    }

    private void logEmptyResultOrException(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("logEmptyResultOrException", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$logEmptyResultOrException(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private boolean isValidScan(NetworkScanRequestInfo networkScanRequestInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("isValidScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$isValidScan(com.android.internal.telephony.NetworkScanRequestTracker$NetworkScanRequestInfo ), 0, this, networkScanRequestInfo);
    }

    private void notifyMessenger(NetworkScanRequestInfo networkScanRequestInfo, int n, int n2, List<CellInfo> list) {
        InvokeDynamicSupport.bootstrap("notifyMessenger", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$notifyMessenger(com.android.internal.telephony.NetworkScanRequestTracker$NetworkScanRequestInfo int int java.util.List<android.telephony.CellInfo> ), 0, this, networkScanRequestInfo, n, n2, list);
    }

    private void interruptNetworkScan(int n) {
        InvokeDynamicSupport.bootstrap("interruptNetworkScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$interruptNetworkScan(int ), 0, this, n);
    }

    public int startNetworkScan(NetworkScanRequest networkScanRequest, Messenger messenger, IBinder iBinder, Phone phone) {
        return (int)InvokeDynamicSupport.bootstrap("startNetworkScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$startNetworkScan(android.telephony.NetworkScanRequest android.os.Messenger android.os.IBinder com.android.internal.telephony.Phone ), 0, this, networkScanRequest, messenger, iBinder, phone);
    }

    public void stopNetworkScan(int n) {
        InvokeDynamicSupport.bootstrap("stopNetworkScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker$stopNetworkScan(int ), 0, this, n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkScanRequestTracker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class NetworkScanRequestScheduler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NetworkScanRequestInfo mLiveRequestInfo;
        private NetworkScanRequestInfo mPendingRequestInfo;
        /* synthetic */ NetworkScanRequestTracker this$0;

        private void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$__constructor__(NetworkScanRequestTracker networkScanRequestTracker) {
        }

        private final int $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$rilErrorToScanError(int rilError) {
            switch (rilError) {
                case 0: {
                    return 0;
                }
                case 1: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: RADIO_NOT_AVAILABLE");
                    return 1;
                }
                case 6: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: REQUEST_NOT_SUPPORTED");
                    return 4;
                }
                case 37: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: NO_MEMORY");
                    return 1;
                }
                case 38: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: INTERNAL_ERR");
                    return 1;
                }
                case 40: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: MODEM_ERR");
                    return 1;
                }
                case 54: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: OPERATION_NOT_ALLOWED");
                    return 1;
                }
                case 44: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: INVALID_ARGUMENTS");
                    return 2;
                }
                case 64: {
                    Log.e("ScanRequestTracker", "rilErrorToScanError: DEVICE_IN_USE");
                    return 3;
                }
            }
            Log.e("ScanRequestTracker", "rilErrorToScanError: Unexpected RadioError " + rilError);
            return 10000;
        }

        private final int $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$commandExceptionErrorToScanError(CommandException.Error error) {
            switch (2.$SwitchMap$com$android$internal$telephony$CommandException$Error[error.ordinal()]) {
                case 1: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: RADIO_NOT_AVAILABLE");
                    return 1;
                }
                case 2: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: REQUEST_NOT_SUPPORTED");
                    return 4;
                }
                case 3: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: NO_MEMORY");
                    return 1;
                }
                case 4: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: INTERNAL_ERR");
                    return 1;
                }
                case 5: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: MODEM_ERR");
                    return 1;
                }
                case 6: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: OPERATION_NOT_ALLOWED");
                    return 1;
                }
                case 7: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: INVALID_ARGUMENTS");
                    return 2;
                }
                case 8: {
                    Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: DEVICE_IN_USE");
                    return 3;
                }
            }
            Log.e("ScanRequestTracker", "commandExceptionErrorToScanError: Unexpected CommandExceptionError " + (Object)((Object)error));
            return 10000;
        }

        private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$doStartScan(NetworkScanRequestInfo nsri) {
            if (nsri == null) {
                Log.e("ScanRequestTracker", "CMD_START_NETWORK_SCAN: nsri is null");
                return;
            }
            if (!this.this$0.isValidScan(nsri)) {
                this.this$0.notifyMessenger(nsri, 2, 2, null);
                return;
            }
            if (nsri.getIsBinderDead()) {
                Log.e("ScanRequestTracker", "CMD_START_NETWORK_SCAN: Binder has died");
                return;
            }
            if (!(this.startNewScan(nsri) || this.interruptLiveScan(nsri) || this.cacheScan(nsri))) {
                this.this$0.notifyMessenger(nsri, 2, 3, null);
            }
        }

        private final synchronized void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$startScanDone(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e("ScanRequestTracker", "EVENT_START_NETWORK_SCAN_DONE: nsri is null");
                return;
            }
            if (this.mLiveRequestInfo == null || nsri.mScanId != this.mLiveRequestInfo.mScanId) {
                Log.e("ScanRequestTracker", "EVENT_START_NETWORK_SCAN_DONE: nsri does not match mLiveRequestInfo");
                return;
            }
            if (ar.exception == null && ar.result != null) {
                ((NetworkScanRequestInfo)nsri).mPhone.mCi.registerForNetworkScanResult(this.this$0.mHandler, 3, nsri);
            } else {
                this.this$0.logEmptyResultOrException(ar);
                if (ar.exception != null) {
                    CommandException.Error error = ((CommandException)ar.exception).getCommandError();
                    this.deleteScanAndMayNotify(nsri, this.commandExceptionErrorToScanError(error), true);
                } else {
                    Log.wtf("ScanRequestTracker", "EVENT_START_NETWORK_SCAN_DONE: ar.exception can not be null!");
                }
            }
        }

        private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$receiveResult(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e("ScanRequestTracker", "EVENT_RECEIVE_NETWORK_SCAN_RESULT: nsri is null");
                return;
            }
            if (ar.exception == null && ar.result != null) {
                NetworkScanResult nsr = (NetworkScanResult)ar.result;
                if (nsr.scanError == 0) {
                    this.this$0.notifyMessenger(nsri, 1, this.rilErrorToScanError(nsr.scanError), nsr.networkInfos);
                    if (nsr.scanStatus == 2) {
                        this.deleteScanAndMayNotify(nsri, 0, true);
                        ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(this.this$0.mHandler);
                    }
                } else {
                    if (nsr.networkInfos != null) {
                        this.this$0.notifyMessenger(nsri, 1, 0, nsr.networkInfos);
                    }
                    this.deleteScanAndMayNotify(nsri, this.rilErrorToScanError(nsr.scanError), true);
                    ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(this.this$0.mHandler);
                }
            } else {
                this.this$0.logEmptyResultOrException(ar);
                this.deleteScanAndMayNotify(nsri, 10000, true);
                ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(this.this$0.mHandler);
            }
        }

        private final synchronized void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$doStopScan(int scanId) {
            if (this.mLiveRequestInfo != null && scanId == this.mLiveRequestInfo.mScanId) {
                this.mLiveRequestInfo.mPhone.stopNetworkScan(this.this$0.mHandler.obtainMessage(5, this.mLiveRequestInfo));
            } else if (this.mPendingRequestInfo != null && scanId == this.mPendingRequestInfo.mScanId) {
                this.this$0.notifyMessenger(this.mPendingRequestInfo, 3, 0, null);
                this.mPendingRequestInfo = null;
            } else {
                Log.e("ScanRequestTracker", "stopScan: scan " + scanId + " does not exist!");
            }
        }

        private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$stopScanDone(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e("ScanRequestTracker", "EVENT_STOP_NETWORK_SCAN_DONE: nsri is null");
                return;
            }
            if (ar.exception == null && ar.result != null) {
                this.deleteScanAndMayNotify(nsri, 0, true);
            } else {
                this.this$0.logEmptyResultOrException(ar);
                if (ar.exception != null) {
                    CommandException.Error error = ((CommandException)ar.exception).getCommandError();
                    this.deleteScanAndMayNotify(nsri, this.commandExceptionErrorToScanError(error), true);
                } else {
                    Log.wtf("ScanRequestTracker", "EVENT_STOP_NETWORK_SCAN_DONE: ar.exception can not be null!");
                }
            }
            ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(this.this$0.mHandler);
        }

        private final synchronized void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$doInterruptScan(int scanId) {
            if (this.mLiveRequestInfo != null && scanId == this.mLiveRequestInfo.mScanId) {
                this.mLiveRequestInfo.mPhone.stopNetworkScan(this.this$0.mHandler.obtainMessage(7, this.mLiveRequestInfo));
            } else {
                Log.e("ScanRequestTracker", "doInterruptScan: scan " + scanId + " does not exist!");
            }
        }

        private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$interruptScanDone(AsyncResult ar) {
            NetworkScanRequestInfo nsri = (NetworkScanRequestInfo)ar.userObj;
            if (nsri == null) {
                Log.e("ScanRequestTracker", "EVENT_INTERRUPT_NETWORK_SCAN_DONE: nsri is null");
                return;
            }
            ((NetworkScanRequestInfo)nsri).mPhone.mCi.unregisterForNetworkScanResult(this.this$0.mHandler);
            this.deleteScanAndMayNotify(nsri, 0, false);
        }

        private final synchronized boolean $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$interruptLiveScan(NetworkScanRequestInfo nsri) {
            if (this.mLiveRequestInfo != null && this.mPendingRequestInfo == null && nsri.mUid == 1000 && this.mLiveRequestInfo.mUid != 1000) {
                this.doInterruptScan(this.mLiveRequestInfo.mScanId);
                this.mPendingRequestInfo = nsri;
                this.this$0.notifyMessenger(this.mLiveRequestInfo, 2, 10002, null);
                return true;
            }
            return false;
        }

        private final boolean $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$cacheScan(NetworkScanRequestInfo nsri) {
            return false;
        }

        private final synchronized boolean $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$startNewScan(NetworkScanRequestInfo nsri) {
            if (this.mLiveRequestInfo == null) {
                this.mLiveRequestInfo = nsri;
                nsri.mPhone.startNetworkScan(nsri.getRequest(), this.this$0.mHandler.obtainMessage(2, nsri));
                return true;
            }
            return false;
        }

        private final synchronized void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$deleteScanAndMayNotify(NetworkScanRequestInfo nsri, int error, boolean notify) {
            if (this.mLiveRequestInfo != null && nsri.mScanId == this.mLiveRequestInfo.mScanId) {
                if (notify) {
                    if (error == 0) {
                        this.this$0.notifyMessenger(nsri, 3, error, null);
                    } else {
                        this.this$0.notifyMessenger(nsri, 2, error, null);
                    }
                }
                this.mLiveRequestInfo = null;
                if (this.mPendingRequestInfo != null) {
                    this.startNewScan(this.mPendingRequestInfo);
                    this.mPendingRequestInfo = null;
                }
            }
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$__constructor__(NetworkScanRequestTracker x0, 1 x1) {
        }

        private void __constructor__(NetworkScanRequestTracker networkScanRequestTracker) {
            this.$$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$__constructor__(networkScanRequestTracker);
        }

        private NetworkScanRequestScheduler(NetworkScanRequestTracker networkScanRequestTracker) {
            this.this$0 = networkScanRequestTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$__constructor__(com.android.internal.telephony.NetworkScanRequestTracker ), 0, this, networkScanRequestTracker);
        }

        private int rilErrorToScanError(int n) {
            return (int)InvokeDynamicSupport.bootstrap("rilErrorToScanError", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$rilErrorToScanError(int ), 0, this, n);
        }

        private int commandExceptionErrorToScanError(CommandException.Error error) {
            return (int)InvokeDynamicSupport.bootstrap("commandExceptionErrorToScanError", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$commandExceptionErrorToScanError(com.android.internal.telephony.CommandException$Error ), 0, this, error);
        }

        private void doStartScan(NetworkScanRequestInfo networkScanRequestInfo) {
            InvokeDynamicSupport.bootstrap("doStartScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$doStartScan(com.android.internal.telephony.NetworkScanRequestTracker$NetworkScanRequestInfo ), 0, this, networkScanRequestInfo);
        }

        private synchronized void startScanDone(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("startScanDone", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$startScanDone(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private void receiveResult(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("receiveResult", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$receiveResult(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private synchronized void doStopScan(int n) {
            InvokeDynamicSupport.bootstrap("doStopScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$doStopScan(int ), 0, this, n);
        }

        private void stopScanDone(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("stopScanDone", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$stopScanDone(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private synchronized void doInterruptScan(int n) {
            InvokeDynamicSupport.bootstrap("doInterruptScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$doInterruptScan(int ), 0, this, n);
        }

        private void interruptScanDone(AsyncResult asyncResult) {
            InvokeDynamicSupport.bootstrap("interruptScanDone", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$interruptScanDone(android.os.AsyncResult ), 0, this, asyncResult);
        }

        private synchronized boolean interruptLiveScan(NetworkScanRequestInfo networkScanRequestInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("interruptLiveScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$interruptLiveScan(com.android.internal.telephony.NetworkScanRequestTracker$NetworkScanRequestInfo ), 0, this, networkScanRequestInfo);
        }

        private boolean cacheScan(NetworkScanRequestInfo networkScanRequestInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("cacheScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$cacheScan(com.android.internal.telephony.NetworkScanRequestTracker$NetworkScanRequestInfo ), 0, this, networkScanRequestInfo);
        }

        private synchronized boolean startNewScan(NetworkScanRequestInfo networkScanRequestInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("startNewScan", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$startNewScan(com.android.internal.telephony.NetworkScanRequestTracker$NetworkScanRequestInfo ), 0, this, networkScanRequestInfo);
        }

        private synchronized void deleteScanAndMayNotify(NetworkScanRequestInfo networkScanRequestInfo, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("deleteScanAndMayNotify", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$deleteScanAndMayNotify(com.android.internal.telephony.NetworkScanRequestTracker$NetworkScanRequestInfo int boolean ), 0, this, networkScanRequestInfo, n, bl);
        }

        private /* synthetic */ void __constructor__(NetworkScanRequestTracker networkScanRequestTracker, 1 var2_2) {
            this.$$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestScheduler$__constructor__(networkScanRequestTracker, var2_2);
        }

        public /* synthetic */ NetworkScanRequestScheduler() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkScanRequestScheduler)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class NetworkScanRequestInfo
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private NetworkScanRequest mRequest;
        private Messenger mMessenger;
        private IBinder mBinder;
        private Phone mPhone;
        private int mScanId;
        private int mUid;
        private int mPid;
        private boolean mIsBinderDead;
        /* synthetic */ NetworkScanRequestTracker this$0;

        private void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$__constructor__(NetworkScanRequestTracker this$0, NetworkScanRequest r, Messenger m, IBinder b, int id2, Phone phone) {
            this.mRequest = r;
            this.mMessenger = m;
            this.mBinder = b;
            this.mScanId = id2;
            this.mPhone = phone;
            this.mUid = Binder.getCallingUid();
            this.mPid = Binder.getCallingPid();
            this.mIsBinderDead = false;
            try {
                this.mBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                this.binderDied();
            }
        }

        private final synchronized void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$setIsBinderDead(boolean val) {
            this.mIsBinderDead = val;
        }

        private final synchronized boolean $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$getIsBinderDead() {
            return this.mIsBinderDead;
        }

        private final NetworkScanRequest $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$getRequest() {
            return this.mRequest;
        }

        private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$unlinkDeathRecipient() {
            if (this.mBinder != null) {
                this.mBinder.unlinkToDeath(this, 0);
            }
        }

        private final void $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$binderDied() {
            Log.e("ScanRequestTracker", "PhoneInterfaceManager NetworkScanRequestInfo binderDied(" + this.mRequest + ", " + this.mBinder + ")");
            this.setIsBinderDead(true);
            this.this$0.interruptNetworkScan(this.mScanId);
        }

        private void __constructor__(NetworkScanRequestTracker networkScanRequestTracker, NetworkScanRequest networkScanRequest, Messenger messenger, IBinder iBinder, int n, Phone phone) {
            this.$$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$__constructor__(networkScanRequestTracker, networkScanRequest, messenger, iBinder, n, phone);
        }

        NetworkScanRequestInfo(NetworkScanRequestTracker networkScanRequestTracker, NetworkScanRequest networkScanRequest, Messenger messenger, IBinder iBinder, int n, Phone phone) {
            this.this$0 = networkScanRequestTracker;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$__constructor__(com.android.internal.telephony.NetworkScanRequestTracker android.telephony.NetworkScanRequest android.os.Messenger android.os.IBinder int com.android.internal.telephony.Phone ), 0, this, networkScanRequestTracker, networkScanRequest, messenger, iBinder, n, phone);
        }

        synchronized void setIsBinderDead(boolean bl) {
            InvokeDynamicSupport.bootstrap("setIsBinderDead", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$setIsBinderDead(boolean ), 0, this, bl);
        }

        synchronized boolean getIsBinderDead() {
            return (boolean)InvokeDynamicSupport.bootstrap("getIsBinderDead", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$getIsBinderDead(), 0, this);
        }

        NetworkScanRequest getRequest() {
            return InvokeDynamicSupport.bootstrap("getRequest", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$getRequest(), 0, this);
        }

        void unlinkDeathRecipient() {
            InvokeDynamicSupport.bootstrap("unlinkDeathRecipient", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$unlinkDeathRecipient(), 0, this);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$com_android_internal_telephony_NetworkScanRequestTracker_NetworkScanRequestInfo$binderDied(), 0, this);
        }

        public /* synthetic */ NetworkScanRequestInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkScanRequestInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

