/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.net.LinkProperties;
import android.net.NetworkCapabilities;
import android.net.NetworkStats;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.AsyncResult;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.SystemProperties;
import android.os.WorkSource;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.service.carrier.CarrierIdentifier;
import android.telephony.CarrierConfigManager;
import android.telephony.CellIdentityCdma;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellLocation;
import android.telephony.ClientRequestStats;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SignalStrength;
import android.telephony.SubscriptionManager;
import android.telephony.VoLteServiceState;
import android.text.TextUtils;
import com.android.ims.ImsCall;
import com.android.ims.ImsManager;
import com.android.internal.telephony.AppSmsManager;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.CallTracker;
import com.android.internal.telephony.CarrierActionAgent;
import com.android.internal.telephony.CarrierSignalAgent;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccSmsInterfaceManager;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.PhoneInternalInterface;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.ServiceStateTracker;
import com.android.internal.telephony.SimActivationTracker;
import com.android.internal.telephony.SmsStorageMonitor;
import com.android.internal.telephony.SmsUsageMonitor;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.TelephonyTester;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.dataconnection.DataConnectionReasons;
import com.android.internal.telephony.dataconnection.DcTracker;
import com.android.internal.telephony.imsphone.ImsPhoneCall;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.IsimRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.uicc.UsimServiceTable;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Phone
extends Handler
implements PhoneInternalInterface,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "Phone";
    protected static Object lockForRadioTechnologyChange;
    protected int USSD_MAX_QUEUE = 10;
    private BroadcastReceiver mImsIntentReceiver;
    public static String NETWORK_SELECTION_KEY = "network_selection_key";
    public static String NETWORK_SELECTION_NAME_KEY = "network_selection_name_key";
    public static String NETWORK_SELECTION_SHORT_KEY = "network_selection_short_key";
    public static String DATA_DISABLED_ON_BOOT_KEY = "disabled_on_boot_key";
    public static String DATA_ROAMING_IS_USER_SETTING_KEY = "data_roaming_is_user_setting_key";
    protected static int EVENT_RADIO_AVAILABLE = 1;
    protected static int EVENT_SSN = 2;
    protected static int EVENT_SIM_RECORDS_LOADED = 3;
    private static int EVENT_MMI_DONE = 4;
    protected static int EVENT_RADIO_ON = 5;
    protected static int EVENT_GET_BASEBAND_VERSION_DONE = 6;
    protected static int EVENT_USSD = 7;
    protected static int EVENT_RADIO_OFF_OR_NOT_AVAILABLE = 8;
    protected static int EVENT_GET_IMEI_DONE = 9;
    protected static int EVENT_GET_IMEISV_DONE = 10;
    private static int EVENT_GET_SIM_STATUS_DONE = 11;
    protected static int EVENT_SET_CALL_FORWARD_DONE = 12;
    protected static int EVENT_GET_CALL_FORWARD_DONE = 13;
    protected static int EVENT_CALL_RING = 14;
    private static int EVENT_CALL_RING_CONTINUE = 15;
    private static int EVENT_SET_NETWORK_MANUAL_COMPLETE = 16;
    private static int EVENT_SET_NETWORK_AUTOMATIC_COMPLETE = 17;
    protected static int EVENT_SET_CLIR_COMPLETE = 18;
    protected static int EVENT_REGISTERED_TO_NETWORK = 19;
    protected static int EVENT_SET_VM_NUMBER_DONE = 20;
    protected static int EVENT_GET_DEVICE_IDENTITY_DONE = 21;
    protected static int EVENT_RUIM_RECORDS_LOADED = 22;
    protected static int EVENT_NV_READY = 23;
    private static int EVENT_SET_ENHANCED_VP = 24;
    protected static int EVENT_EMERGENCY_CALLBACK_MODE_ENTER = 25;
    protected static int EVENT_EXIT_EMERGENCY_CALLBACK_RESPONSE = 26;
    protected static int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 27;
    protected static int EVENT_SET_NETWORK_AUTOMATIC = 28;
    protected static int EVENT_ICC_RECORD_EVENTS = 29;
    private static int EVENT_ICC_CHANGED = 30;
    private static int EVENT_SRVCC_STATE_CHANGED = 31;
    private static int EVENT_INITIATE_SILENT_REDIAL = 32;
    private static int EVENT_RADIO_NOT_AVAILABLE = 33;
    private static int EVENT_UNSOL_OEM_HOOK_RAW = 34;
    protected static int EVENT_GET_RADIO_CAPABILITY = 35;
    protected static int EVENT_SS = 36;
    private static int EVENT_CONFIG_LCE = 37;
    private static int EVENT_CHECK_FOR_NETWORK_AUTOMATIC = 38;
    protected static int EVENT_VOICE_RADIO_TECH_CHANGED = 39;
    protected static int EVENT_REQUEST_VOICE_RADIO_TECH_DONE = 40;
    protected static int EVENT_RIL_CONNECTED = 41;
    protected static int EVENT_UPDATE_PHONE_OBJECT = 42;
    protected static int EVENT_CARRIER_CONFIG_CHANGED = 43;
    protected static int EVENT_SET_ROAMING_PREFERENCE_DONE = 44;
    protected static int EVENT_MODEM_RESET = 45;
    protected static int EVENT_LAST = 45;
    private static String GSM_ROAMING_LIST_OVERRIDE_PREFIX = "gsm_roaming_list_";
    private static String GSM_NON_ROAMING_LIST_OVERRIDE_PREFIX = "gsm_non_roaming_list_";
    private static String CDMA_ROAMING_LIST_OVERRIDE_PREFIX = "cdma_roaming_list_";
    private static String CDMA_NON_ROAMING_LIST_OVERRIDE_PREFIX = "cdma_non_roaming_list_";
    public static String CLIR_KEY = "clir_key";
    private static String VM_COUNT = "vm_count_key";
    private static String VM_ID = "vm_id_key";
    public static String CF_STATUS = "cf_status_key";
    public static String CF_ID = "cf_id_key";
    private static String DNS_SERVER_CHECK_DISABLED_KEY = "dns_server_check_disabled_key";
    public CommandsInterface mCi;
    protected int mVmCount;
    private boolean mDnsCheckDisabled;
    public DcTracker mDcTracker;
    protected CarrierSignalAgent mCarrierSignalAgent;
    protected CarrierActionAgent mCarrierActionAgent;
    private boolean mDoesRilSendMultipleCallRing;
    private int mCallRingContinueToken;
    private int mCallRingDelay;
    private boolean mIsVoiceCapable;
    private AppSmsManager mAppSmsManager;
    private SimActivationTracker mSimActivationTracker;
    protected boolean mIsPhoneInEcmState;
    protected boolean mIsVideoCapable;
    protected UiccController mUiccController;
    protected AtomicReference<IccRecords> mIccRecords;
    public SmsStorageMonitor mSmsStorageMonitor;
    public SmsUsageMonitor mSmsUsageMonitor;
    protected AtomicReference<UiccCardApplication> mUiccApplication;
    private TelephonyTester mTelephonyTester;
    private String mName;
    private String mActionDetached;
    private String mActionAttached;
    protected int mPhoneId;
    private boolean mImsServiceReady;
    protected Phone mImsPhone;
    private AtomicReference<RadioCapability> mRadioCapability;
    private static int DEFAULT_REPORT_INTERVAL_MS = 200;
    private static boolean LCE_PULL_MODE = true;
    private int mLceStatus;
    protected TelephonyComponentFactory mTelephonyComponentFactory;
    public static String CS_FALLBACK = "cs_fallback";
    public static String EXTRA_KEY_ALERT_TITLE = "alertTitle";
    public static String EXTRA_KEY_ALERT_MESSAGE = "alertMessage";
    public static String EXTRA_KEY_ALERT_SHOW = "alertShow";
    public static String EXTRA_KEY_NOTIFICATION_MESSAGE = "notificationMessage";
    private RegistrantList mPreciseCallStateRegistrants;
    private RegistrantList mHandoverRegistrants;
    private RegistrantList mNewRingingConnectionRegistrants;
    private RegistrantList mIncomingRingRegistrants;
    protected RegistrantList mDisconnectRegistrants;
    private RegistrantList mServiceStateRegistrants;
    protected RegistrantList mMmiCompleteRegistrants;
    protected RegistrantList mMmiRegistrants;
    protected RegistrantList mUnknownConnectionRegistrants;
    protected RegistrantList mSuppServiceFailedRegistrants;
    protected RegistrantList mRadioOffOrNotAvailableRegistrants;
    protected RegistrantList mSimRecordsLoadedRegistrants;
    private RegistrantList mVideoCapabilityChangedRegistrants;
    protected RegistrantList mEmergencyCallToggledRegistrants;
    protected Registrant mPostDialHandler;
    private Looper mLooper;
    protected Context mContext;
    protected PhoneNotifier mNotifier;
    protected SimulatedRadioControl mSimulatedRadioControl;
    private boolean mUnitTestMode;

    private final void $$robo$$com_android_internal_telephony_Phone$handleExitEmergencyCallbackMode() {
    }

    private final IccRecords $$robo$$com_android_internal_telephony_Phone$getIccRecords() {
        return this.mIccRecords.get();
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getPhoneName() {
        return this.mName;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setPhoneName(String name) {
        this.mName = name;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getNai() {
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getActionDetached() {
        return this.mActionDetached;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getActionAttached() {
        return this.mActionAttached;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setSystemProperty(String property, String value) {
        if (this.getUnitTestMode()) {
            return;
        }
        SystemProperties.set(property, value);
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getSystemProperty(String property, String defValue) {
        if (this.getUnitTestMode()) {
            return null;
        }
        return SystemProperties.get(property, defValue);
    }

    private void $$robo$$com_android_internal_telephony_Phone$__constructor__(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode) {
    }

    private void $$robo$$com_android_internal_telephony_Phone$__constructor__(String name, PhoneNotifier notifier, Context context, CommandsInterface ci, boolean unitTestMode, int phoneId, TelephonyComponentFactory telephonyComponentFactory) {
        this.USSD_MAX_QUEUE = 10;
        this.mImsIntentReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Phone this$0;

            private void $$robo$$com_android_internal_telephony_Phone_1$__constructor__(Phone this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_Phone_1$onReceive(Context context, Intent intent) {
                Rlog.d("Phone", "mImsIntentReceiver: action " + intent.getAction());
                if (intent.hasExtra("android:phone_id")) {
                    int extraPhoneId = intent.getIntExtra("android:phone_id", -1);
                    Rlog.d("Phone", "mImsIntentReceiver: extraPhoneId = " + extraPhoneId);
                    if (extraPhoneId == -1 || extraPhoneId != this.this$0.getPhoneId()) {
                        return;
                    }
                }
                Object object = lockForRadioTechnologyChange;
                synchronized (object) {
                    if (intent.getAction().equals("com.android.ims.IMS_SERVICE_UP")) {
                        this.this$0.mImsServiceReady = true;
                        this.this$0.updateImsPhone();
                        ImsManager.updateImsServiceConfig(this.this$0.mContext, this.this$0.mPhoneId, false);
                    } else if (intent.getAction().equals("com.android.ims.IMS_SERVICE_DOWN")) {
                        this.this$0.mImsServiceReady = false;
                        this.this$0.updateImsPhone();
                    } else if (intent.getAction().equals("com.android.intent.action.IMS_CONFIG_CHANGED")) {
                        int item = intent.getIntExtra("item", -1);
                        String value = intent.getStringExtra("value");
                        ImsManager.onProvisionedValueChanged(context, item, value);
                    }
                }
            }

            private void __constructor__(Phone phone) {
                this.$$robo$$com_android_internal_telephony_Phone_1$__constructor__(phone);
            }
            {
                this.this$0 = phone;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Phone_1$__constructor__(com.android.internal.telephony.Phone ), 0, this, phone);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_Phone_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mVmCount = 0;
        this.mIsVoiceCapable = true;
        this.mIsPhoneInEcmState = false;
        this.mIsVideoCapable = false;
        this.mUiccController = null;
        this.mIccRecords = new AtomicReference();
        this.mUiccApplication = new AtomicReference();
        this.mImsServiceReady = false;
        this.mImsPhone = null;
        this.mRadioCapability = new AtomicReference();
        this.mLceStatus = -1;
        this.mPreciseCallStateRegistrants = new RegistrantList();
        this.mHandoverRegistrants = new RegistrantList();
        this.mNewRingingConnectionRegistrants = new RegistrantList();
        this.mIncomingRingRegistrants = new RegistrantList();
        this.mDisconnectRegistrants = new RegistrantList();
        this.mServiceStateRegistrants = new RegistrantList();
        this.mMmiCompleteRegistrants = new RegistrantList();
        this.mMmiRegistrants = new RegistrantList();
        this.mUnknownConnectionRegistrants = new RegistrantList();
        this.mSuppServiceFailedRegistrants = new RegistrantList();
        this.mRadioOffOrNotAvailableRegistrants = new RegistrantList();
        this.mSimRecordsLoadedRegistrants = new RegistrantList();
        this.mVideoCapabilityChangedRegistrants = new RegistrantList();
        this.mEmergencyCallToggledRegistrants = new RegistrantList();
        this.mPhoneId = phoneId;
        this.mName = name;
        this.mNotifier = notifier;
        this.mContext = context;
        this.mLooper = Looper.myLooper();
        this.mCi = ci;
        this.mActionDetached = this.getClass().getPackage().getName() + ".action_detached";
        this.mActionAttached = this.getClass().getPackage().getName() + ".action_attached";
        this.mAppSmsManager = telephonyComponentFactory.makeAppSmsManager(context);
        if (Build.IS_DEBUGGABLE) {
            this.mTelephonyTester = new TelephonyTester(this);
        }
        this.setUnitTestMode(unitTestMode);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(context);
        this.mDnsCheckDisabled = sp.getBoolean("dns_server_check_disabled_key", false);
        this.mCi.setOnCallRing(this, 14, null);
        this.mIsVoiceCapable = this.mContext.getResources().getBoolean(17957054);
        this.mDoesRilSendMultipleCallRing = SystemProperties.getBoolean("ro.telephony.call_ring.multiple", true);
        Rlog.d("Phone", "mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        this.mCallRingDelay = SystemProperties.getInt("ro.telephony.call_ring.delay", 3000);
        Rlog.d("Phone", "mCallRingDelay=" + this.mCallRingDelay);
        if (this.getPhoneType() == 5) {
            return;
        }
        Locale carrierLocale = Phone.getLocaleFromCarrierProperties(this.mContext);
        if (carrierLocale != null && !TextUtils.isEmpty(carrierLocale.getCountry())) {
            String country = carrierLocale.getCountry();
            try {
                Settings.Global.getInt(this.mContext.getContentResolver(), "wifi_country_code");
            }
            catch (Settings.SettingNotFoundException e) {
                WifiManager wM = (WifiManager)this.mContext.getSystemService("wifi");
                wM.setCountryCode(country, false);
            }
        }
        this.mTelephonyComponentFactory = telephonyComponentFactory;
        this.mSmsStorageMonitor = this.mTelephonyComponentFactory.makeSmsStorageMonitor(this);
        this.mSmsUsageMonitor = this.mTelephonyComponentFactory.makeSmsUsageMonitor(context);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 30, null);
        this.mSimActivationTracker = this.mTelephonyComponentFactory.makeSimActivationTracker(this);
        if (this.getPhoneType() != 3) {
            this.mCi.registerForSrvccStateChanged(this, 31, null);
        }
        this.mCi.setOnUnsolOemHookRaw(this, 34, null);
        this.mCi.startLceService(200, true, this.obtainMessage(37));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_Phone$startMonitoringImsService() {
        if (this.getPhoneType() == 3) {
            return;
        }
        Object object = lockForRadioTechnologyChange;
        synchronized (object) {
            IntentFilter filter = new IntentFilter();
            ImsManager imsManager = ImsManager.getInstance(this.mContext, this.getPhoneId());
            if (imsManager != null && !imsManager.isDynamicBinding()) {
                filter.addAction("com.android.ims.IMS_SERVICE_UP");
                filter.addAction("com.android.ims.IMS_SERVICE_DOWN");
            }
            filter.addAction("com.android.intent.action.IMS_CONFIG_CHANGED");
            this.mContext.registerReceiver(this.mImsIntentReceiver, filter);
            if (imsManager != null && (imsManager.isDynamicBinding() || imsManager.isServiceAvailable())) {
                this.mImsServiceReady = true;
                this.updateImsPhone();
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$supportsConversionOfCdmaCallerIdMmiCodesWhileRoaming() {
        CarrierConfigManager configManager = (CarrierConfigManager)this.getContext().getSystemService("carrier_config");
        PersistableBundle b = configManager.getConfig();
        if (b != null) {
            return b.getBoolean("convert_cdma_caller_id_mmi_codes_while_roaming_on_3gpp_bool", false);
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$handleMessage(Message msg) {
        switch (msg.what) {
            case 16: 
            case 17: {
                this.handleSetSelectNetwork((AsyncResult)msg.obj);
                return;
            }
        }
        switch (msg.what) {
            case 14: {
                Rlog.d("Phone", "Event EVENT_CALL_RING Received state=" + (Object)((Object)this.getState()));
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) break;
                PhoneConstants.State state = this.getState();
                if (!(this.mDoesRilSendMultipleCallRing || state != PhoneConstants.State.RINGING && state != PhoneConstants.State.IDLE)) {
                    ++this.mCallRingContinueToken;
                    this.sendIncomingCallRingNotification(this.mCallRingContinueToken);
                    break;
                }
                this.notifyIncomingRing();
                break;
            }
            case 15: {
                Rlog.d("Phone", "Event EVENT_CALL_RING_CONTINUE Received state=" + (Object)((Object)this.getState()));
                if (this.getState() != PhoneConstants.State.RINGING) break;
                this.sendIncomingCallRingNotification(msg.arg1);
                break;
            }
            case 30: {
                this.onUpdateIccAvailability();
                break;
            }
            case 32: {
                Rlog.d("Phone", "Event EVENT_INITIATE_SILENT_REDIAL Received");
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null || ar.result == null) break;
                String dialString = (String)ar.result;
                if (TextUtils.isEmpty(dialString)) {
                    return;
                }
                try {
                    this.dialInternal(dialString, null, 0, null);
                }
                catch (CallStateException e) {
                    Rlog.e("Phone", "silent redial failed: " + e);
                }
                break;
            }
            case 31: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    this.handleSrvccStateChanged((int[])ar.result);
                    break;
                }
                Rlog.e("Phone", "Srvcc exception: " + ar.exception);
                break;
            }
            case 34: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception == null) {
                    byte[] data = (byte[])ar.result;
                    this.mNotifier.notifyOemHookRawEventForSubscriber(this.getSubId(), data);
                    break;
                }
                Rlog.e("Phone", "OEM hook raw exception: " + ar.exception);
                break;
            }
            case 37: {
                AsyncResult ar = (AsyncResult)msg.obj;
                if (ar.exception != null) {
                    Rlog.d("Phone", "config LCE service failed: " + ar.exception);
                    break;
                }
                ArrayList statusInfo = (ArrayList)ar.result;
                this.mLceStatus = (Integer)statusInfo.get(0);
                break;
            }
            case 38: {
                this.onCheckForNetworkSelectionModeAutomatic(msg);
                break;
            }
            default: {
                throw new RuntimeException("unexpected event not handled");
            }
        }
    }

    private final ArrayList<Connection> $$robo$$com_android_internal_telephony_Phone$getHandoverConnection() {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifySrvccState(Call.SrvccState state) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForSilentRedial(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForSilentRedial(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$handleSrvccStateChanged(int[] ret) {
        Rlog.d("Phone", "handleSrvccStateChanged");
        ArrayList<Connection> conn = null;
        Phone imsPhone = this.mImsPhone;
        Call.SrvccState srvccState = Call.SrvccState.NONE;
        if (ret != null && ret.length != 0) {
            int state = ret[0];
            switch (state) {
                case 0: {
                    srvccState = Call.SrvccState.STARTED;
                    if (imsPhone != null) {
                        conn = imsPhone.getHandoverConnection();
                        this.migrateFrom(imsPhone);
                        break;
                    }
                    Rlog.d("Phone", "HANDOVER_STARTED: mImsPhone null");
                    break;
                }
                case 1: {
                    srvccState = Call.SrvccState.COMPLETED;
                    if (imsPhone != null) {
                        imsPhone.notifySrvccState(srvccState);
                        break;
                    }
                    Rlog.d("Phone", "HANDOVER_COMPLETED: mImsPhone null");
                    break;
                }
                case 2: 
                case 3: {
                    srvccState = Call.SrvccState.FAILED;
                    break;
                }
                default: {
                    return;
                }
            }
            this.getCallTracker().notifySrvccState(srvccState, conn);
            VoLteServiceState lteState = new VoLteServiceState(state);
            this.notifyVoLteServiceStateChanged(lteState);
        }
    }

    private final Context $$robo$$com_android_internal_telephony_Phone$getContext() {
        return this.mContext;
    }

    protected abstract void onUpdateIccAvailability();

    private final void $$robo$$com_android_internal_telephony_Phone$disableDnsCheck(boolean b) {
        this.mDnsCheckDisabled = b;
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putBoolean("dns_server_check_disabled_key", b);
        editor.apply();
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isDnsCheckDisabled() {
        return this.mDnsCheckDisabled;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForPreciseCallStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mPreciseCallStateRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForPreciseCallStateChanged(Handler h) {
        this.mPreciseCallStateRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyPreciseCallStateChangedP() {
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mPreciseCallStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyPreciseCallState(this);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForHandoverStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mHandoverRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForHandoverStateChanged(Handler h) {
        this.mHandoverRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyHandoverStateChanged(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mHandoverRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setIsInEmergencyCall() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$migrateFrom(Phone from) {
        this.migrate(this.mHandoverRegistrants, from.mHandoverRegistrants);
        this.migrate(this.mPreciseCallStateRegistrants, from.mPreciseCallStateRegistrants);
        this.migrate(this.mNewRingingConnectionRegistrants, from.mNewRingingConnectionRegistrants);
        this.migrate(this.mIncomingRingRegistrants, from.mIncomingRingRegistrants);
        this.migrate(this.mDisconnectRegistrants, from.mDisconnectRegistrants);
        this.migrate(this.mServiceStateRegistrants, from.mServiceStateRegistrants);
        this.migrate(this.mMmiCompleteRegistrants, from.mMmiCompleteRegistrants);
        this.migrate(this.mMmiRegistrants, from.mMmiRegistrants);
        this.migrate(this.mUnknownConnectionRegistrants, from.mUnknownConnectionRegistrants);
        this.migrate(this.mSuppServiceFailedRegistrants, from.mSuppServiceFailedRegistrants);
        if (from.isInEmergencyCall()) {
            this.setIsInEmergencyCall();
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$migrate(RegistrantList to, RegistrantList from) {
        from.removeCleared();
        int n = from.size();
        for (int i = 0; i < n; ++i) {
            Registrant r = (Registrant)from.get(i);
            Message msg = r.messageForRegistrant();
            if (msg != null) {
                if (msg.obj == CallManager.getInstance().getRegistrantIdentifier()) continue;
                to.add((Registrant)from.get(i));
                continue;
            }
            Rlog.d("Phone", "msg is null");
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForUnknownConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mUnknownConnectionRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForUnknownConnection(Handler h) {
        this.mUnknownConnectionRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForNewRingingConnection(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mNewRingingConnectionRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForNewRingingConnection(Handler h) {
        this.mNewRingingConnectionRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForVideoCapabilityChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mVideoCapabilityChangedRegistrants.addUnique(h, what, obj);
        this.notifyForVideoCapabilityChanged(this.mIsVideoCapable);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForVideoCapabilityChanged(Handler h) {
        this.mVideoCapabilityChangedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForInCallVoicePrivacyOn(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOn(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForInCallVoicePrivacyOn(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOn(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForInCallVoicePrivacyOff(Handler h, int what, Object obj) {
        this.mCi.registerForInCallVoicePrivacyOff(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForInCallVoicePrivacyOff(Handler h) {
        this.mCi.unregisterForInCallVoicePrivacyOff(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForIncomingRing(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mIncomingRingRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForIncomingRing(Handler h) {
        this.mIncomingRingRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForDisconnect(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mDisconnectRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForDisconnect(Handler h) {
        this.mDisconnectRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForSuppServiceFailed(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mSuppServiceFailedRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForSuppServiceFailed(Handler h) {
        this.mSuppServiceFailedRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForMmiInitiate(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForMmiInitiate(Handler h) {
        this.mMmiRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForMmiComplete(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForMmiComplete(Handler h) {
        this.checkCorrectThread(h);
        this.mMmiCompleteRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForSimRecordsLoaded(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForSimRecordsLoaded(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForTtyModeReceived(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForTtyModeReceived(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setNetworkSelectionModeAutomatic(Message response) {
        Rlog.d("Phone", "setNetworkSelectionModeAutomatic, querying current mode");
        Message msg = this.obtainMessage(38);
        msg.obj = response;
        this.mCi.getNetworkSelectionMode(msg);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$onCheckForNetworkSelectionModeAutomatic(Message fromRil) {
        AsyncResult ar = (AsyncResult)fromRil.obj;
        Message response = (Message)ar.userObj;
        boolean doAutomatic = true;
        if (ar.exception == null && ar.result != null) {
            try {
                int[] modes = (int[])ar.result;
                if (modes[0] == 0) {
                    doAutomatic = false;
                }
            }
            catch (Exception modes) {
                // empty catch block
            }
        }
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = "";
        nsm.operatorAlphaLong = "";
        nsm.operatorAlphaShort = "";
        if (doAutomatic) {
            Message msg = this.obtainMessage(17, nsm);
            this.mCi.setNetworkSelectionModeAutomatic(msg);
        } else {
            Rlog.d("Phone", "setNetworkSelectionModeAutomatic - already auto, ignoring");
            ar.userObj = nsm;
            this.handleSetSelectNetwork(ar);
        }
        this.updateSavedNetworkOperator(nsm);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$getNetworkSelectionMode(Message message) {
        this.mCi.getNetworkSelectionMode(message);
    }

    private final List<ClientRequestStats> $$robo$$com_android_internal_telephony_Phone$getClientRequestStats() {
        return this.mCi.getClientRequestStats();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$selectNetworkManually(OperatorInfo network, boolean persistSelection, Message response) {
        NetworkSelectMessage nsm = new NetworkSelectMessage();
        nsm.message = response;
        nsm.operatorNumeric = network.getOperatorNumeric();
        nsm.operatorAlphaLong = network.getOperatorAlphaLong();
        nsm.operatorAlphaShort = network.getOperatorAlphaShort();
        Message msg = this.obtainMessage(16, nsm);
        this.mCi.setNetworkSelectionModeManual(network.getOperatorNumeric(), msg);
        if (persistSelection) {
            this.updateSavedNetworkOperator(nsm);
        } else {
            this.clearSavedNetworkSelection();
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForEmergencyCallToggle(Handler h, int what, Object obj) {
        Registrant r = new Registrant(h, what, obj);
        this.mEmergencyCallToggledRegistrants.add(r);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForEmergencyCallToggle(Handler h) {
        this.mEmergencyCallToggledRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$updateSavedNetworkOperator(NetworkSelectMessage nsm) {
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
            SharedPreferences.Editor editor = sp.edit();
            editor.putString("network_selection_key" + subId, nsm.operatorNumeric);
            editor.putString("network_selection_name_key" + subId, nsm.operatorAlphaLong);
            editor.putString("network_selection_short_key" + subId, nsm.operatorAlphaShort);
            if (!editor.commit()) {
                Rlog.e("Phone", "failed to commit network selection preference");
            }
        } else {
            Rlog.e("Phone", "Cannot update network selection preference due to invalid subId " + subId);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$handleSetSelectNetwork(AsyncResult ar) {
        if (!(ar.userObj instanceof NetworkSelectMessage)) {
            Rlog.e("Phone", "unexpected result from user object.");
            return;
        }
        NetworkSelectMessage nsm = (NetworkSelectMessage)ar.userObj;
        if (nsm.message != null) {
            AsyncResult.forMessage(nsm.message, ar.result, ar.exception);
            nsm.message.sendToTarget();
        }
    }

    private final OperatorInfo $$robo$$com_android_internal_telephony_Phone$getSavedNetworkSelection() {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        String numeric = sp.getString("network_selection_key" + this.getSubId(), "");
        String name = sp.getString("network_selection_name_key" + this.getSubId(), "");
        String shrt = sp.getString("network_selection_short_key" + this.getSubId(), "");
        return new OperatorInfo(name, shrt, numeric);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$clearSavedNetworkSelection() {
        PreferenceManager.getDefaultSharedPreferences(this.getContext()).edit().remove("network_selection_key" + this.getSubId()).remove("network_selection_name_key" + this.getSubId()).remove("network_selection_short_key" + this.getSubId()).commit();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$restoreSavedNetworkSelection(Message response) {
        OperatorInfo networkSelection = this.getSavedNetworkSelection();
        if (networkSelection == null || TextUtils.isEmpty(networkSelection.getOperatorNumeric())) {
            this.setNetworkSelectionModeAutomatic(response);
        } else {
            this.selectNetworkManually(networkSelection, true, response);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$saveClirSetting(int commandInterfaceCLIRMode) {
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.getContext());
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("clir_key" + this.getPhoneId(), commandInterfaceCLIRMode);
        Rlog.i("Phone", "saveClirSetting: clir_key" + this.getPhoneId() + "=" + commandInterfaceCLIRMode);
        if (!editor.commit()) {
            Rlog.e("Phone", "Failed to commit CLIR preference");
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setUnitTestMode(boolean f) {
        this.mUnitTestMode = f;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$getUnitTestMode() {
        return this.mUnitTestMode;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyDisconnectP(Connection cn) {
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mDisconnectRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForServiceStateChanged(Handler h, int what, Object obj) {
        this.checkCorrectThread(h);
        this.mServiceStateRegistrants.add(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForServiceStateChanged(Handler h) {
        this.mServiceStateRegistrants.remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForRingbackTone(Handler h, int what, Object obj) {
        this.mCi.registerForRingbackTone(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForRingbackTone(Handler h) {
        this.mCi.unregisterForRingbackTone(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForOnHoldTone(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForOnHoldTone(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForResendIncallMute(Handler h, int what, Object obj) {
        this.mCi.registerForResendIncallMute(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForResendIncallMute(Handler h) {
        this.mCi.unregisterForResendIncallMute(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setEchoSuppressionEnabled() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyServiceStateChangedP(ServiceState ss) {
        AsyncResult ar = new AsyncResult(null, ss, null);
        this.mServiceStateRegistrants.notifyRegistrants(ar);
        this.mNotifier.notifyServiceState(this);
    }

    private final SimulatedRadioControl $$robo$$com_android_internal_telephony_Phone$getSimulatedRadioControl() {
        return this.mSimulatedRadioControl;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$checkCorrectThread(Handler h) {
        if (h.getLooper() != this.mLooper) {
            throw new RuntimeException("com.android.internal.telephony.Phone must be used from within one thread");
        }
    }

    private static final Locale $$robo$$com_android_internal_telephony_Phone$getLocaleFromCarrierProperties(Context ctx) {
        String carrier = SystemProperties.get("ro.carrier");
        if (null == carrier || 0 == carrier.length() || "unknown".equals(carrier)) {
            return null;
        }
        CharSequence[] carrierLocales = ctx.getResources().getTextArray(17235974);
        for (int i = 0; i < carrierLocales.length; i += 3) {
            String c = carrierLocales[i].toString();
            if (!carrier.equals(c)) continue;
            return Locale.forLanguageTag(carrierLocales[i + 1].toString().replace('_', '-'));
        }
        return null;
    }

    public abstract PhoneConstants.State getState();

    private final IccFileHandler $$robo$$com_android_internal_telephony_Phone$getIccFileHandler() {
        IccFileHandler fh;
        UiccCardApplication uiccApplication = this.mUiccApplication.get();
        if (uiccApplication == null) {
            Rlog.d("Phone", "getIccFileHandler: uiccApplication == null, return null");
            fh = null;
        } else {
            fh = uiccApplication.getIccFileHandler();
        }
        Rlog.d("Phone", "getIccFileHandler: fh=" + fh);
        return fh;
    }

    private final Handler $$robo$$com_android_internal_telephony_Phone$getHandler() {
        return this;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$updatePhoneObject(int voiceRadioTech) {
    }

    private final ServiceStateTracker $$robo$$com_android_internal_telephony_Phone$getServiceStateTracker() {
        return null;
    }

    private final CallTracker $$robo$$com_android_internal_telephony_Phone$getCallTracker() {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setVoiceActivationState(int state) {
        this.mSimActivationTracker.setVoiceActivationState(state);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setDataActivationState(int state) {
        this.mSimActivationTracker.setDataActivationState(state);
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getVoiceActivationState() {
        return this.mSimActivationTracker.getVoiceActivationState();
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getDataActivationState() {
        return this.mSimActivationTracker.getDataActivationState();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$updateVoiceMail() {
        Rlog.e("Phone", "updateVoiceMail() should be overridden");
    }

    private final IccCardApplicationStatus.AppType $$robo$$com_android_internal_telephony_Phone$getCurrentUiccAppType() {
        UiccCardApplication currentApp = this.mUiccApplication.get();
        if (currentApp != null) {
            return currentApp.getType();
        }
        return IccCardApplicationStatus.AppType.APPTYPE_UNKNOWN;
    }

    private final IccCard $$robo$$com_android_internal_telephony_Phone$getIccCard() {
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getIccSerialNumber() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getIccId() : null;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getFullIccSerialNumber() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getFullIccId() : null;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$getIccRecordsLoaded() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getRecordsLoaded() : false;
    }

    private final List<CellInfo> $$robo$$com_android_internal_telephony_Phone$getAllCellInfo(WorkSource workSource) {
        List<CellInfo> cellInfoList = this.getServiceStateTracker().getAllCellInfo(workSource);
        return this.privatizeCellInfoList(cellInfoList);
    }

    private final CellLocation $$robo$$com_android_internal_telephony_Phone$getCellLocation() {
        return this.getCellLocation(null);
    }

    private final List<CellInfo> $$robo$$com_android_internal_telephony_Phone$privatizeCellInfoList(List<CellInfo> cellInfoList) {
        if (cellInfoList == null) {
            return null;
        }
        int mode = Settings.Secure.getInt(this.getContext().getContentResolver(), "location_mode", 0);
        if (mode == 0) {
            ArrayList<CellInfo> privateCellInfoList = new ArrayList<CellInfo>(cellInfoList.size());
            for (CellInfo c : cellInfoList) {
                if (c instanceof CellInfoCdma) {
                    CellInfoCdma cellInfoCdma = (CellInfoCdma)c;
                    CellIdentityCdma cellIdentity = cellInfoCdma.getCellIdentity();
                    CellIdentityCdma maskedCellIdentity = new CellIdentityCdma(cellIdentity.getNetworkId(), cellIdentity.getSystemId(), cellIdentity.getBasestationId(), Integer.MAX_VALUE, Integer.MAX_VALUE);
                    CellInfoCdma privateCellInfoCdma = new CellInfoCdma(cellInfoCdma);
                    privateCellInfoCdma.setCellIdentity(maskedCellIdentity);
                    privateCellInfoList.add(privateCellInfoCdma);
                    continue;
                }
                privateCellInfoList.add(c);
            }
            cellInfoList = privateCellInfoList;
        }
        return cellInfoList;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setCellInfoListRate(int rateInMillis, WorkSource workSource) {
        this.mCi.setCellInfoListRate(rateInMillis, null, workSource);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$getMessageWaitingIndicator() {
        return this.mVmCount != 0;
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getCallForwardingIndicatorFromSharedPref() {
        int status = 0;
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            String subscriberId;
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
            status = sp.getInt("cf_status_key" + subId, -1);
            Rlog.d("Phone", "getCallForwardingIndicatorFromSharedPref: for subId " + subId + "= " + status);
            if (status == -1 && (subscriberId = sp.getString("cf_id_key", null)) != null) {
                String currentSubscriberId = this.getSubscriberId();
                if (subscriberId.equals(currentSubscriberId)) {
                    status = sp.getInt("cf_status_key", 0);
                    this.setCallForwardingIndicatorInSharedPref(status == 1);
                    Rlog.d("Phone", "getCallForwardingIndicatorFromSharedPref: " + status);
                } else {
                    Rlog.d("Phone", "getCallForwardingIndicatorFromSharedPref: returning DISABLED as status for matching subscriberId not found");
                }
                SharedPreferences.Editor editor = sp.edit();
                editor.remove("cf_id_key");
                editor.remove("cf_status_key");
                editor.apply();
            }
        } else {
            Rlog.e("Phone", "getCallForwardingIndicatorFromSharedPref: invalid subId " + subId);
        }
        return status;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setCallForwardingIndicatorInSharedPref(boolean enable) {
        int status = enable ? 1 : 0;
        int subId = this.getSubId();
        Rlog.i("Phone", "setCallForwardingIndicatorInSharedPref: Storing status = " + status + " in pref " + "cf_status_key" + subId);
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        SharedPreferences.Editor editor = sp.edit();
        editor.putInt("cf_status_key" + subId, status);
        editor.apply();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setVoiceCallForwardingFlag(int line, boolean enable, String number) {
        this.setCallForwardingIndicatorInSharedPref(enable);
        IccRecords r = this.mIccRecords.get();
        if (r != null) {
            r.setVoiceCallForwardingFlag(line, enable, number);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setVoiceCallForwardingFlag(IccRecords r, int line, boolean enable, String number) {
        this.setCallForwardingIndicatorInSharedPref(enable);
        r.setVoiceCallForwardingFlag(line, enable, number);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$getCallForwardingIndicator() {
        if (this.getPhoneType() == 2) {
            Rlog.e("Phone", "getCallForwardingIndicator: not possible in CDMA");
            return false;
        }
        IccRecords r = this.mIccRecords.get();
        int callForwardingIndicator = -1;
        if (r != null) {
            callForwardingIndicator = r.getVoiceCallForwardingFlag();
        }
        if (callForwardingIndicator == -1) {
            callForwardingIndicator = this.getCallForwardingIndicatorFromSharedPref();
        }
        Rlog.v("Phone", "getCallForwardingIndicator: iccForwardingFlag=" + (r != null ? Integer.valueOf(r.getVoiceCallForwardingFlag()) : "null") + ", sharedPrefFlag=" + this.getCallForwardingIndicatorFromSharedPref());
        return callForwardingIndicator == 1;
    }

    private final CarrierSignalAgent $$robo$$com_android_internal_telephony_Phone$getCarrierSignalAgent() {
        return this.mCarrierSignalAgent;
    }

    private final CarrierActionAgent $$robo$$com_android_internal_telephony_Phone$getCarrierActionAgent() {
        return this.mCarrierActionAgent;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$queryCdmaRoamingPreference(Message response) {
        this.mCi.queryCdmaRoamingPreference(response);
    }

    private final SignalStrength $$robo$$com_android_internal_telephony_Phone$getSignalStrength() {
        ServiceStateTracker sst = this.getServiceStateTracker();
        if (sst == null) {
            return new SignalStrength();
        }
        return sst.getSignalStrength();
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isConcurrentVoiceAndDataAllowed() {
        ServiceStateTracker sst = this.getServiceStateTracker();
        return sst == null ? false : sst.isConcurrentVoiceAndDataAllowed();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.mCi.setCdmaRoamingPreference(cdmaRoamingType, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setCdmaSubscription(int cdmaSubscriptionType, Message response) {
        this.mCi.setCdmaSubscriptionSource(cdmaSubscriptionType, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setPreferredNetworkType(int networkType, Message response) {
        int modemRaf = this.getRadioAccessFamily();
        int rafFromType = RadioAccessFamily.getRafFromNetworkType(networkType);
        if (modemRaf == 1 || rafFromType == 1) {
            Rlog.d("Phone", "setPreferredNetworkType: Abort, unknown RAF: " + modemRaf + " " + rafFromType);
            if (response != null) {
                CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
                AsyncResult.forMessage(response, null, ex);
                response.sendToTarget();
            }
            return;
        }
        int filteredRaf = rafFromType & modemRaf;
        int filteredType = RadioAccessFamily.getNetworkTypeFromRaf(filteredRaf);
        Rlog.d("Phone", "setPreferredNetworkType: networkType = " + networkType + " modemRaf = " + modemRaf + " rafFromType = " + rafFromType + " filteredType = " + filteredType);
        this.mCi.setPreferredNetworkType(filteredType, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$getPreferredNetworkType(Message response) {
        this.mCi.getPreferredNetworkType(response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$getSmscAddress(Message result) {
        this.mCi.getSmscAddress(result);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setSmscAddress(String address, Message result) {
        this.mCi.setSmscAddress(address, result);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setTTYMode(int ttyMode, Message onComplete) {
        this.mCi.setTTYMode(ttyMode, onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setUiTTYMode(int uiTtyMode, Message onComplete) {
        Rlog.d("Phone", "unexpected setUiTTYMode method call");
    }

    private final void $$robo$$com_android_internal_telephony_Phone$queryTTYMode(Message onComplete) {
        this.mCi.queryTTYMode(onComplete);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$enableEnhancedVoicePrivacy(boolean enable, Message onComplete) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$getEnhancedVoicePrivacy(Message onComplete) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setBandMode(int bandMode, Message response) {
        this.mCi.setBandMode(bandMode, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$queryAvailableBandMode(Message response) {
        this.mCi.queryAvailableBandMode(response);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_Phone$invokeOemRilRequestRaw(byte[] data, Message response) {
        this.mCi.invokeOemRilRequestRaw(data, response);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_Phone$invokeOemRilRequestStrings(String[] strings, Message response) {
        this.mCi.invokeOemRilRequestStrings(strings, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$nvReadItem(int itemID, Message response) {
        this.mCi.nvReadItem(itemID, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$nvWriteItem(int itemID, String itemValue, Message response) {
        this.mCi.nvWriteItem(itemID, itemValue, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        this.mCi.nvWriteCdmaPrl(preferredRoamingList, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$nvResetConfig(int resetType, Message response) {
        this.mCi.nvResetConfig(resetType, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyDataActivity() {
        this.mNotifier.notifyDataActivity(this);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyMessageWaitingIndicator() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        this.mNotifier.notifyMessageWaitingChanged(this);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyDataConnection(String reason, String apnType, PhoneConstants.DataState state) {
        this.mNotifier.notifyDataConnection(this, reason, apnType, state);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyDataConnection(String reason, String apnType) {
        this.mNotifier.notifyDataConnection(this, reason, apnType, this.getDataConnectionState(apnType));
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyDataConnection(String reason) {
        String[] types;
        for (String apnType : types = this.getActiveApnTypes()) {
            this.mNotifier.notifyDataConnection(this, reason, apnType, this.getDataConnectionState(apnType));
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyOtaspChanged(int otaspMode) {
        this.mNotifier.notifyOtaspChanged(this, otaspMode);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyVoiceActivationStateChanged(int state) {
        this.mNotifier.notifyVoiceActivationStateChanged(this, state);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyDataActivationStateChanged(int state) {
        this.mNotifier.notifyDataActivationStateChanged(this, state);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifySignalStrength() {
        this.mNotifier.notifySignalStrength(this);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyCellInfo(List<CellInfo> cellInfo) {
        this.mNotifier.notifyCellInfo(this, this.privatizeCellInfoList(cellInfo));
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyVoLteServiceStateChanged(VoLteServiceState lteState) {
        this.mNotifier.notifyVoLteServiceStateChanged(this, lteState);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isInEmergencyCall() {
        return false;
    }

    private static final boolean $$robo$$com_android_internal_telephony_Phone$getInEcmMode() {
        return SystemProperties.getBoolean("ril.cdma.inecmmode", false);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isInEcm() {
        return this.mIsPhoneInEcmState;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setIsInEcm(boolean isInEcm) {
        this.setSystemProperty("ril.cdma.inecmmode", String.valueOf(isInEcm));
        this.mIsPhoneInEcmState = isInEcm;
    }

    private static final int $$robo$$com_android_internal_telephony_Phone$getVideoState(Call call) {
        int videoState = 0;
        Connection conn = call.getEarliestConnection();
        if (conn != null) {
            videoState = conn.getVideoState();
        }
        return videoState;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isVideoCallOrConference(Call call) {
        if (call.isMultiparty()) {
            return true;
        }
        boolean isDowngradedVideoCall = false;
        if (call instanceof ImsPhoneCall) {
            ImsPhoneCall imsPhoneCall = (ImsPhoneCall)call;
            ImsCall imsCall = imsPhoneCall.getImsCall();
            return imsCall != null && (imsCall.isVideoCall() || imsCall.wasVideoCall());
        }
        return isDowngradedVideoCall;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isImsVideoCallOrConferencePresent() {
        boolean isPresent = false;
        if (this.mImsPhone != null) {
            isPresent = this.isVideoCallOrConference(this.mImsPhone.getForegroundCall()) || this.isVideoCallOrConference(this.mImsPhone.getBackgroundCall()) || this.isVideoCallOrConference(this.mImsPhone.getRingingCall());
        }
        Rlog.d("Phone", "isImsVideoCallOrConferencePresent: " + isPresent);
        return isPresent;
    }

    public abstract int getPhoneType();

    private final int $$robo$$com_android_internal_telephony_Phone$getVoiceMessageCount() {
        return this.mVmCount;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setVoiceMessageCount(int countWaiting) {
        this.mVmCount = countWaiting;
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            Rlog.d("Phone", "setVoiceMessageCount: Storing Voice Mail Count = " + countWaiting + " for mVmCountKey = " + "vm_count_key" + subId + " in preferences.");
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
            SharedPreferences.Editor editor = sp.edit();
            editor.putInt("vm_count_key" + subId, countWaiting);
            editor.apply();
        } else {
            Rlog.e("Phone", "setVoiceMessageCount in sharedPreference: invalid subId " + subId);
        }
        this.notifyMessageWaitingIndicator();
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getStoredVoiceMessageCount() {
        int countVoiceMessages = 0;
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int invalidCount = -2;
            SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
            int countFromSP = sp.getInt("vm_count_key" + subId, invalidCount);
            if (countFromSP != invalidCount) {
                countVoiceMessages = countFromSP;
                Rlog.d("Phone", "getStoredVoiceMessageCount: from preference for subId " + subId + "= " + countVoiceMessages);
            } else {
                String subscriberId = sp.getString("vm_id_key", null);
                if (subscriberId != null) {
                    String currentSubscriberId = this.getSubscriberId();
                    if (currentSubscriberId != null && currentSubscriberId.equals(subscriberId)) {
                        countVoiceMessages = sp.getInt("vm_count_key", 0);
                        this.setVoiceMessageCount(countVoiceMessages);
                        Rlog.d("Phone", "getStoredVoiceMessageCount: from preference = " + countVoiceMessages);
                    } else {
                        Rlog.d("Phone", "getStoredVoiceMessageCount: returning 0 as count for matching subscriberId not found");
                    }
                    SharedPreferences.Editor editor = sp.edit();
                    editor.remove("vm_id_key");
                    editor.remove("vm_count_key");
                    editor.apply();
                }
            }
        } else {
            Rlog.e("Phone", "getStoredVoiceMessageCount: invalid subId " + subId);
        }
        return countVoiceMessages;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$sendDialerSpecialCode(String code) {
        if (!TextUtils.isEmpty(code)) {
            Intent intent = new Intent("android.provider.Telephony.SECRET_CODE", Uri.parse("android_secret_code://" + code));
            intent.addFlags(0x1000000);
            this.mContext.sendBroadcast(intent);
        }
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getCdmaEriIconIndex() {
        return -1;
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getCdmaEriIconMode() {
        return -1;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getCdmaEriText() {
        return "GSM nw, no ERI";
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getCdmaMin() {
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isMinInfoReady() {
        return false;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getCdmaPrlVersion() {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$sendBurstDtmf(String dtmfString, int on, int off, Message onComplete) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setOnPostDialCharacter(Handler h, int what, Object obj) {
        this.mPostDialHandler = new Registrant(h, what, obj);
    }

    private final Registrant $$robo$$com_android_internal_telephony_Phone$getPostDialHandler() {
        return this.mPostDialHandler;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$exitEmergencyCallbackMode() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForCdmaOtaStatusChange(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForCdmaOtaStatusChange(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForSubscriptionInfoReady(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForSubscriptionInfoReady(Handler h) {
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$needsOtaServiceProvisioning() {
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isOtaSpNumber(String dialStr) {
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForCallWaiting(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForCallWaiting(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForEcmTimerReset(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForEcmTimerReset(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForSignalInfo(Handler h, int what, Object obj) {
        this.mCi.registerForSignalInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForSignalInfo(Handler h) {
        this.mCi.unregisterForSignalInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForDisplayInfo(Handler h, int what, Object obj) {
        this.mCi.registerForDisplayInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForDisplayInfo(Handler h) {
        this.mCi.unregisterForDisplayInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForNumberInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForNumberInfo(Handler h) {
        this.mCi.unregisterForNumberInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForRedirectedNumberInfo(Handler h, int what, Object obj) {
        this.mCi.registerForRedirectedNumberInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForRedirectedNumberInfo(Handler h) {
        this.mCi.unregisterForRedirectedNumberInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForLineControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForLineControlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForLineControlInfo(Handler h) {
        this.mCi.unregisterForLineControlInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerFoT53ClirlInfo(Handler h, int what, Object obj) {
        this.mCi.registerFoT53ClirlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForT53ClirInfo(Handler h) {
        this.mCi.unregisterForT53ClirInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForT53AudioControlInfo(Handler h, int what, Object obj) {
        this.mCi.registerForT53AudioControlInfo(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForT53AudioControlInfo(Handler h) {
        this.mCi.unregisterForT53AudioControlInfo(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setOnEcbModeExitResponse(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unsetOnEcbModeExitResponse(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForRadioOffOrNotAvailable(Handler h, int what, Object obj) {
        this.mRadioOffOrNotAvailableRegistrants.addUnique(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForRadioOffOrNotAvailable(Handler h) {
        this.mRadioOffOrNotAvailableRegistrants.remove(h);
    }

    private final String[] $$robo$$com_android_internal_telephony_Phone$getActiveApnTypes() {
        if (this.mDcTracker == null) {
            return null;
        }
        return this.mDcTracker.getActiveApnTypes();
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$hasMatchedTetherApnSetting() {
        return this.mDcTracker.hasMatchedTetherApnSetting();
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getActiveApnHost(String apnType) {
        return this.mDcTracker.getActiveApnString(apnType);
    }

    private final LinkProperties $$robo$$com_android_internal_telephony_Phone$getLinkProperties(String apnType) {
        return this.mDcTracker.getLinkProperties(apnType);
    }

    private final NetworkCapabilities $$robo$$com_android_internal_telephony_Phone$getNetworkCapabilities(String apnType) {
        return this.mDcTracker.getNetworkCapabilities(apnType);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isDataAllowed() {
        return this.mDcTracker != null && this.mDcTracker.isDataAllowed(null);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isDataAllowed(DataConnectionReasons reasons) {
        return this.mDcTracker != null && this.mDcTracker.isDataAllowed(reasons);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$carrierActionSetMeteredApnsEnabled(boolean enabled) {
        this.mCarrierActionAgent.carrierActionSetMeteredApnsEnabled(enabled);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$carrierActionSetRadioEnabled(boolean enabled) {
        this.mCarrierActionAgent.carrierActionSetRadioEnabled(enabled);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$carrierActionReportDefaultNetworkStatus(boolean report) {
        this.mCarrierActionAgent.carrierActionReportDefaultNetworkStatus(report);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyNewRingingConnectionP(Connection cn) {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, cn, null);
        this.mNewRingingConnectionRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyUnknownConnectionP(Connection cn) {
        this.mUnknownConnectionRegistrants.notifyResult(cn);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyForVideoCapabilityChanged(boolean isVideoCallCapable) {
        this.mIsVideoCapable = isVideoCallCapable;
        AsyncResult ar = new AsyncResult(null, isVideoCallCapable, null);
        this.mVideoCapabilityChangedRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyIncomingRing() {
        if (!this.mIsVoiceCapable) {
            return;
        }
        AsyncResult ar = new AsyncResult(null, this, null);
        this.mIncomingRingRegistrants.notifyRegistrants(ar);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$sendIncomingCallRingNotification(int token) {
        if (this.mIsVoiceCapable && !this.mDoesRilSendMultipleCallRing && token == this.mCallRingContinueToken) {
            Rlog.d("Phone", "Sending notifyIncomingRing");
            this.notifyIncomingRing();
            this.sendMessageDelayed(this.obtainMessage(15, token, 0), this.mCallRingDelay);
        } else {
            Rlog.d("Phone", "Ignoring ring notification request, mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing + " token=" + token + " mCallRingContinueToken=" + this.mCallRingContinueToken + " mIsVoiceCapable=" + this.mIsVoiceCapable);
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isCspPlmnEnabled() {
        return false;
    }

    private final IsimRecords $$robo$$com_android_internal_telephony_Phone$getIsimRecords() {
        Rlog.e("Phone", "getIsimRecords() is only supported on LTE devices");
        return null;
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getMsisdn() {
        return null;
    }

    private final PhoneConstants.DataState $$robo$$com_android_internal_telephony_Phone$getDataConnectionState() {
        return this.getDataConnectionState("default");
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyCallForwardingIndicator() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyDataConnectionFailed(String reason, String apnType) {
        this.mNotifier.notifyDataConnectionFailed(this, reason, apnType);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$notifyPreciseDataConnectionFailed(String reason, String apnType, String apn, String failCause) {
        this.mNotifier.notifyPreciseDataConnectionFailed(this, reason, apnType, apn, failCause);
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getLteOnCdmaMode() {
        return this.mCi.getLteOnCdmaMode();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setVoiceMessageWaiting(int line, int countWaiting) {
        Rlog.e("Phone", "Error! This function should never be executed, inactive Phone.");
    }

    private final UsimServiceTable $$robo$$com_android_internal_telephony_Phone$getUsimServiceTable() {
        IccRecords r = this.mIccRecords.get();
        return r != null ? r.getUsimServiceTable() : null;
    }

    private final UiccCard $$robo$$com_android_internal_telephony_Phone$getUiccCard() {
        return this.mUiccController.getUiccCard(this.mPhoneId);
    }

    private final String[] $$robo$$com_android_internal_telephony_Phone$getPcscfAddress(String apnType) {
        return this.mDcTracker.getPcscfAddress(apnType);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setImsRegistrationState(boolean registered) {
    }

    private final Phone $$robo$$com_android_internal_telephony_Phone$getImsPhone() {
        return this.mImsPhone;
    }

    private final ImsiEncryptionInfo $$robo$$com_android_internal_telephony_Phone$getCarrierInfoForImsiEncryption(int keyType) {
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isUtEnabled() {
        if (this.mImsPhone != null) {
            return this.mImsPhone.isUtEnabled();
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$dispose() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$updateImsPhone() {
        Rlog.d("Phone", "updateImsPhone mImsServiceReady=" + this.mImsServiceReady);
        if (this.mImsServiceReady && this.mImsPhone == null) {
            this.mImsPhone = PhoneFactory.makeImsPhone(this.mNotifier, this);
            CallManager.getInstance().registerPhone(this.mImsPhone);
            this.mImsPhone.registerForSilentRedial(this, 32, null);
        } else if (!this.mImsServiceReady && this.mImsPhone != null) {
            CallManager.getInstance().unregisterPhone(this.mImsPhone);
            this.mImsPhone.unregisterForSilentRedial(this);
            this.mImsPhone.dispose();
            this.mImsPhone = null;
        }
    }

    private final Connection $$robo$$com_android_internal_telephony_Phone$dialInternal(String dialString, UUSInfo uusInfo, int videoState, Bundle intentExtras) throws CallStateException {
        return null;
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getSubId() {
        return SubscriptionController.getInstance().getSubIdUsingPhoneId(this.mPhoneId);
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getPhoneId() {
        return this.mPhoneId;
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getVoicePhoneServiceState() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null && imsPhone.getServiceState().getState() == 0) {
            return 0;
        }
        return this.getServiceState().getState();
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$setOperatorBrandOverride(String brand) {
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$setRoamingOverride(List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        String iccId = this.getIccSerialNumber();
        if (TextUtils.isEmpty(iccId)) {
            return false;
        }
        this.setRoamingOverrideHelper(gsmRoamingList, "gsm_roaming_list_", iccId);
        this.setRoamingOverrideHelper(gsmNonRoamingList, "gsm_non_roaming_list_", iccId);
        this.setRoamingOverrideHelper(cdmaRoamingList, "cdma_roaming_list_", iccId);
        this.setRoamingOverrideHelper(cdmaNonRoamingList, "cdma_non_roaming_list_", iccId);
        ServiceStateTracker tracker = this.getServiceStateTracker();
        if (tracker != null) {
            tracker.pollState();
        }
        return true;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setRoamingOverrideHelper(List<String> list, String prefix, String iccId) {
        SharedPreferences.Editor spEditor = PreferenceManager.getDefaultSharedPreferences(this.mContext).edit();
        String key = prefix + iccId;
        if (list == null || list.isEmpty()) {
            spEditor.remove(key).commit();
        } else {
            spEditor.putStringSet(key, new HashSet<String>(list)).commit();
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isMccMncMarkedAsRoaming(String mccMnc) {
        return this.getRoamingOverrideHelper("gsm_roaming_list_", mccMnc);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isMccMncMarkedAsNonRoaming(String mccMnc) {
        return this.getRoamingOverrideHelper("gsm_non_roaming_list_", mccMnc);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isSidMarkedAsRoaming(int SID) {
        return this.getRoamingOverrideHelper("cdma_roaming_list_", Integer.toString(SID));
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isSidMarkedAsNonRoaming(int SID) {
        return this.getRoamingOverrideHelper("cdma_non_roaming_list_", Integer.toString(SID));
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isImsRegistered() {
        Phone imsPhone = this.mImsPhone;
        boolean isImsRegistered = false;
        if (imsPhone != null) {
            isImsRegistered = imsPhone.isImsRegistered();
        } else {
            ServiceStateTracker sst = this.getServiceStateTracker();
            if (sst != null) {
                isImsRegistered = sst.isImsRegistered();
            }
        }
        Rlog.d("Phone", "isImsRegistered =" + isImsRegistered);
        return isImsRegistered;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isWifiCallingEnabled() {
        Phone imsPhone = this.mImsPhone;
        boolean isWifiCallingEnabled = false;
        if (imsPhone != null) {
            isWifiCallingEnabled = imsPhone.isWifiCallingEnabled();
        }
        Rlog.d("Phone", "isWifiCallingEnabled =" + isWifiCallingEnabled);
        return isWifiCallingEnabled;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isVolteEnabled() {
        Phone imsPhone = this.mImsPhone;
        boolean isVolteEnabled = false;
        if (imsPhone != null) {
            isVolteEnabled = imsPhone.isVolteEnabled();
        }
        Rlog.d("Phone", "isImsRegistered =" + isVolteEnabled);
        return isVolteEnabled;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$getRoamingOverrideHelper(String prefix, String key) {
        String iccId = this.getIccSerialNumber();
        if (TextUtils.isEmpty(iccId) || TextUtils.isEmpty(key)) {
            return false;
        }
        SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(this.mContext);
        Set<String> value = sp.getStringSet(prefix + iccId, null);
        if (value == null) {
            return false;
        }
        return value.contains(key);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isRadioAvailable() {
        return this.mCi.getRadioState().isAvailable();
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isRadioOn() {
        return this.mCi.getRadioState().isOn();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$shutdownRadio() {
        this.getServiceStateTracker().requestShutdown();
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isShuttingDown() {
        return this.getServiceStateTracker().isDeviceShuttingDown();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setRadioCapability(RadioCapability rc, Message response) {
        this.mCi.setRadioCapability(rc, response);
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getRadioAccessFamily() {
        RadioCapability rc = this.getRadioCapability();
        return rc == null ? 1 : rc.getRadioAccessFamily();
    }

    private final String $$robo$$com_android_internal_telephony_Phone$getModemUuId() {
        RadioCapability rc = this.getRadioCapability();
        return rc == null ? "" : rc.getLogicalModemUuid();
    }

    private final RadioCapability $$robo$$com_android_internal_telephony_Phone$getRadioCapability() {
        return this.mRadioCapability.get();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$radioCapabilityUpdated(RadioCapability rc) {
        this.mRadioCapability.set(rc);
        if (SubscriptionManager.isValidSubscriptionId(this.getSubId())) {
            this.sendSubscriptionSettings(true);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$sendSubscriptionSettings(boolean restoreNetworkSelection) {
        int type = PhoneFactory.calculatePreferredNetworkType(this.mContext, this.getSubId());
        this.setPreferredNetworkType(type, null);
        if (restoreNetworkSelection) {
            this.restoreSavedNetworkSelection(null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setPreferredNetworkTypeIfSimLoaded() {
        int subId = this.getSubId();
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int type = PhoneFactory.calculatePreferredNetworkType(this.mContext, this.getSubId());
            this.setPreferredNetworkType(type, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForRadioCapabilityChanged(Handler h, int what, Object obj) {
        this.mCi.registerForRadioCapabilityChanged(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForRadioCapabilityChanged(Handler h) {
        this.mCi.unregisterForRadioCapabilityChanged(this);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isImsUseEnabled() {
        boolean imsUseEnabled = ImsManager.isVolteEnabledByPlatform(this.mContext) && ImsManager.isEnhanced4gLteModeSettingEnabledByUser(this.mContext) || ImsManager.isWfcEnabledByPlatform(this.mContext) && ImsManager.isWfcEnabledByUser(this.mContext) && ImsManager.isNonTtyOrTtyOnVolteEnabled(this.mContext);
        return imsUseEnabled;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isImsAvailable() {
        if (this.mImsPhone == null) {
            return false;
        }
        return this.mImsPhone.isImsAvailable();
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isVideoEnabled() {
        Phone imsPhone = this.mImsPhone;
        if (imsPhone != null) {
            return imsPhone.isVideoEnabled();
        }
        return false;
    }

    private final int $$robo$$com_android_internal_telephony_Phone$getLceStatus() {
        return this.mLceStatus;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$getModemActivityInfo(Message response) {
        this.mCi.getModemActivityInfo(response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$startLceAfterRadioIsAvailable() {
        this.mCi.startLceService(200, true, this.obtainMessage(37));
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setAllowedCarriers(List<CarrierIdentifier> carriers, Message response) {
        this.mCi.setAllowedCarriers(carriers, response);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$getAllowedCarriers(Message response) {
        this.mCi.getAllowedCarriers(response);
    }

    private final Locale $$robo$$com_android_internal_telephony_Phone$getLocaleFromSimAndCarrierPrefs() {
        IccRecords records = this.mIccRecords.get();
        if (records != null && records.getSimLanguage() != null) {
            return new Locale(records.getSimLanguage());
        }
        return Phone.getLocaleFromCarrierProperties(this.mContext);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$updateDataConnectionTracker() {
        this.mDcTracker.update();
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setInternalDataEnabled(boolean enable, Message onCompleteMsg) {
        this.mDcTracker.setInternalDataEnabled(enable, onCompleteMsg);
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$updateCurrentCarrierInProvider() {
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForAllDataDisconnected(Handler h, int what, Object obj) {
        this.mDcTracker.registerForAllDataDisconnected(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForAllDataDisconnected(Handler h) {
        this.mDcTracker.unregisterForAllDataDisconnected(h);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$registerForDataEnabledChanged(Handler h, int what, Object obj) {
        this.mDcTracker.registerForDataEnabledChanged(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$unregisterForDataEnabledChanged(Handler h) {
        this.mDcTracker.unregisterForDataEnabledChanged(h);
    }

    private final IccSmsInterfaceManager $$robo$$com_android_internal_telephony_Phone$getIccSmsInterfaceManager() {
        return null;
    }

    private final boolean $$robo$$com_android_internal_telephony_Phone$isMatchGid(String gid) {
        String gid1 = this.getGroupIdLevel1();
        int gidLength = gid.length();
        return !TextUtils.isEmpty(gid1) && gid1.length() >= gidLength && gid1.substring(0, gidLength).equalsIgnoreCase(gid);
    }

    private static final void $$robo$$com_android_internal_telephony_Phone$checkWfcWifiOnlyModeBeforeDial(Phone imsPhone, Context context) throws CallStateException {
        if (imsPhone == null || !imsPhone.isWifiCallingEnabled()) {
            boolean wfcWiFiOnly;
            boolean bl = wfcWiFiOnly = ImsManager.isWfcEnabledByPlatform(context) && ImsManager.isWfcEnabledByUser(context) && ImsManager.getWfcMode(context) == 0;
            if (wfcWiFiOnly) {
                throw new CallStateException(1, "WFC Wi-Fi Only Mode: IMS not registered");
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_Phone$startRingbackTone() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$stopRingbackTone() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$callEndCleanupHandOverCallIfAny() {
    }

    private final void $$robo$$com_android_internal_telephony_Phone$cancelUSSD() {
    }

    public abstract void setBroadcastEmergencyCallStateChanges(boolean var1);

    public abstract void sendEmergencyCallStateChange(boolean var1);

    private final Phone $$robo$$com_android_internal_telephony_Phone$getDefaultPhone() {
        return this;
    }

    private final NetworkStats $$robo$$com_android_internal_telephony_Phone$getVtDataUsage(boolean perUidStats) {
        if (this.mImsPhone == null) {
            return null;
        }
        return this.mImsPhone.getVtDataUsage(perUidStats);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setPolicyDataEnabled(boolean enabled) {
        this.mDcTracker.setPolicyDataEnabled(enabled);
    }

    private final Uri[] $$robo$$com_android_internal_telephony_Phone$getCurrentSubscriberUris() {
        return null;
    }

    private final AppSmsManager $$robo$$com_android_internal_telephony_Phone$getAppSmsManager() {
        return this.mAppSmsManager;
    }

    private final void $$robo$$com_android_internal_telephony_Phone$setSimPowerState(int state) {
        this.mCi.setSimCardPower(state, null);
    }

    private final void $$robo$$com_android_internal_telephony_Phone$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("Phone: subId=" + this.getSubId());
        pw.println(" mPhoneId=" + this.mPhoneId);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mDnsCheckDisabled=" + this.mDnsCheckDisabled);
        pw.println(" mDcTracker=" + this.mDcTracker);
        pw.println(" mDoesRilSendMultipleCallRing=" + this.mDoesRilSendMultipleCallRing);
        pw.println(" mCallRingContinueToken=" + this.mCallRingContinueToken);
        pw.println(" mCallRingDelay=" + this.mCallRingDelay);
        pw.println(" mIsVoiceCapable=" + this.mIsVoiceCapable);
        pw.println(" mIccRecords=" + this.mIccRecords.get());
        pw.println(" mUiccApplication=" + this.mUiccApplication.get());
        pw.println(" mSmsStorageMonitor=" + this.mSmsStorageMonitor);
        pw.println(" mSmsUsageMonitor=" + this.mSmsUsageMonitor);
        pw.flush();
        pw.println(" mLooper=" + this.mLooper);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mNotifier=" + this.mNotifier);
        pw.println(" mSimulatedRadioControl=" + this.mSimulatedRadioControl);
        pw.println(" mUnitTestMode=" + this.mUnitTestMode);
        pw.println(" isDnsCheckDisabled()=" + this.isDnsCheckDisabled());
        pw.println(" getUnitTestMode()=" + this.getUnitTestMode());
        pw.println(" getState()=" + (Object)((Object)this.getState()));
        pw.println(" getIccSerialNumber()=" + this.getIccSerialNumber());
        pw.println(" getIccRecordsLoaded()=" + this.getIccRecordsLoaded());
        pw.println(" getMessageWaitingIndicator()=" + this.getMessageWaitingIndicator());
        pw.println(" getCallForwardingIndicator()=" + this.getCallForwardingIndicator());
        pw.println(" isInEmergencyCall()=" + this.isInEmergencyCall());
        pw.flush();
        pw.println(" isInEcm()=" + this.isInEcm());
        pw.println(" getPhoneName()=" + this.getPhoneName());
        pw.println(" getPhoneType()=" + this.getPhoneType());
        pw.println(" getVoiceMessageCount()=" + this.getVoiceMessageCount());
        pw.println(" getActiveApnTypes()=" + this.getActiveApnTypes());
        pw.println(" needsOtaServiceProvisioning=" + this.needsOtaServiceProvisioning());
        pw.flush();
        pw.println("++++++++++++++++++++++++++++++++");
        if (this.mImsPhone != null) {
            try {
                this.mImsPhone.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mDcTracker != null) {
            try {
                this.mDcTracker.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.getServiceStateTracker() != null) {
            try {
                this.getServiceStateTracker().dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mCarrierActionAgent != null) {
            try {
                this.mCarrierActionAgent.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mCarrierSignalAgent != null) {
            try {
                this.mCarrierSignalAgent.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.getCallTracker() != null) {
            try {
                this.getCallTracker().dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mSimActivationTracker != null) {
            try {
                this.mSimActivationTracker.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        if (this.mCi != null && this.mCi instanceof RIL) {
            try {
                ((RIL)this.mCi).dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
        }
    }

    static void __staticInitializer__() {
        lockForRadioTechnologyChange = new Object();
    }

    protected void handleExitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("handleExitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_Phone$handleExitEmergencyCallbackMode(), 0, this);
    }

    public IccRecords getIccRecords() {
        return InvokeDynamicSupport.bootstrap("getIccRecords", $$robo$$com_android_internal_telephony_Phone$getIccRecords(), 0, this);
    }

    public String getPhoneName() {
        return InvokeDynamicSupport.bootstrap("getPhoneName", $$robo$$com_android_internal_telephony_Phone$getPhoneName(), 0, this);
    }

    protected void setPhoneName(String string2) {
        InvokeDynamicSupport.bootstrap("setPhoneName", $$robo$$com_android_internal_telephony_Phone$setPhoneName(java.lang.String ), 0, this, string2);
    }

    public String getNai() {
        return InvokeDynamicSupport.bootstrap("getNai", $$robo$$com_android_internal_telephony_Phone$getNai(), 0, this);
    }

    public String getActionDetached() {
        return InvokeDynamicSupport.bootstrap("getActionDetached", $$robo$$com_android_internal_telephony_Phone$getActionDetached(), 0, this);
    }

    public String getActionAttached() {
        return InvokeDynamicSupport.bootstrap("getActionAttached", $$robo$$com_android_internal_telephony_Phone$getActionAttached(), 0, this);
    }

    public void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_Phone$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public String getSystemProperty(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getSystemProperty", $$robo$$com_android_internal_telephony_Phone$getSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void __constructor__(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl) {
        this.$$robo$$com_android_internal_telephony_Phone$__constructor__(string2, phoneNotifier, context, commandsInterface, bl);
    }

    protected Phone(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl) {
        this(string2, phoneNotifier, context, commandsInterface, bl, Integer.MAX_VALUE, TelephonyComponentFactory.getInstance());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Phone$__constructor__(java.lang.String com.android.internal.telephony.PhoneNotifier android.content.Context com.android.internal.telephony.CommandsInterface boolean ), 0, this, string2, phoneNotifier, context, commandsInterface, bl);
    }

    private void __constructor__(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl, int n, TelephonyComponentFactory telephonyComponentFactory) {
        this.$$robo$$com_android_internal_telephony_Phone$__constructor__(string2, phoneNotifier, context, commandsInterface, bl, n, telephonyComponentFactory);
    }

    protected Phone(String string2, PhoneNotifier phoneNotifier, Context context, CommandsInterface commandsInterface, boolean bl, int n, TelephonyComponentFactory telephonyComponentFactory) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Phone$__constructor__(java.lang.String com.android.internal.telephony.PhoneNotifier android.content.Context com.android.internal.telephony.CommandsInterface boolean int com.android.internal.telephony.TelephonyComponentFactory ), 0, this, string2, phoneNotifier, context, commandsInterface, bl, n, telephonyComponentFactory);
    }

    public void startMonitoringImsService() {
        InvokeDynamicSupport.bootstrap("startMonitoringImsService", $$robo$$com_android_internal_telephony_Phone$startMonitoringImsService(), 0, this);
    }

    public boolean supportsConversionOfCdmaCallerIdMmiCodesWhileRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("supportsConversionOfCdmaCallerIdMmiCodesWhileRoaming", $$robo$$com_android_internal_telephony_Phone$supportsConversionOfCdmaCallerIdMmiCodesWhileRoaming(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_Phone$handleMessage(android.os.Message ), 0, this, message);
    }

    public ArrayList<Connection> getHandoverConnection() {
        return InvokeDynamicSupport.bootstrap("getHandoverConnection", $$robo$$com_android_internal_telephony_Phone$getHandoverConnection(), 0, this);
    }

    public void notifySrvccState(Call.SrvccState srvccState) {
        InvokeDynamicSupport.bootstrap("notifySrvccState", $$robo$$com_android_internal_telephony_Phone$notifySrvccState(com.android.internal.telephony.Call$SrvccState ), 0, this, srvccState);
    }

    public void registerForSilentRedial(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSilentRedial", $$robo$$com_android_internal_telephony_Phone$registerForSilentRedial(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSilentRedial(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSilentRedial", $$robo$$com_android_internal_telephony_Phone$unregisterForSilentRedial(android.os.Handler ), 0, this, handler);
    }

    private void handleSrvccStateChanged(int[] nArray) {
        InvokeDynamicSupport.bootstrap("handleSrvccStateChanged", $$robo$$com_android_internal_telephony_Phone$handleSrvccStateChanged(int[] ), 0, this, nArray);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$com_android_internal_telephony_Phone$getContext(), 0, this);
    }

    public void disableDnsCheck(boolean bl) {
        InvokeDynamicSupport.bootstrap("disableDnsCheck", $$robo$$com_android_internal_telephony_Phone$disableDnsCheck(boolean ), 0, this, bl);
    }

    public boolean isDnsCheckDisabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDnsCheckDisabled", $$robo$$com_android_internal_telephony_Phone$isDnsCheckDisabled(), 0, this);
    }

    public void registerForPreciseCallStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_Phone$registerForPreciseCallStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForPreciseCallStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPreciseCallStateChanged", $$robo$$com_android_internal_telephony_Phone$unregisterForPreciseCallStateChanged(android.os.Handler ), 0, this, handler);
    }

    protected void notifyPreciseCallStateChangedP() {
        InvokeDynamicSupport.bootstrap("notifyPreciseCallStateChangedP", $$robo$$com_android_internal_telephony_Phone$notifyPreciseCallStateChangedP(), 0, this);
    }

    public void registerForHandoverStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForHandoverStateChanged", $$robo$$com_android_internal_telephony_Phone$registerForHandoverStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForHandoverStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForHandoverStateChanged", $$robo$$com_android_internal_telephony_Phone$unregisterForHandoverStateChanged(android.os.Handler ), 0, this, handler);
    }

    public void notifyHandoverStateChanged(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyHandoverStateChanged", $$robo$$com_android_internal_telephony_Phone$notifyHandoverStateChanged(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    protected void setIsInEmergencyCall() {
        InvokeDynamicSupport.bootstrap("setIsInEmergencyCall", $$robo$$com_android_internal_telephony_Phone$setIsInEmergencyCall(), 0, this);
    }

    protected void migrateFrom(Phone phone) {
        InvokeDynamicSupport.bootstrap("migrateFrom", $$robo$$com_android_internal_telephony_Phone$migrateFrom(com.android.internal.telephony.Phone ), 0, this, phone);
    }

    protected void migrate(RegistrantList registrantList, RegistrantList registrantList2) {
        InvokeDynamicSupport.bootstrap("migrate", $$robo$$com_android_internal_telephony_Phone$migrate(android.os.RegistrantList android.os.RegistrantList ), 0, this, registrantList, registrantList2);
    }

    public void registerForUnknownConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForUnknownConnection", $$robo$$com_android_internal_telephony_Phone$registerForUnknownConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForUnknownConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForUnknownConnection", $$robo$$com_android_internal_telephony_Phone$unregisterForUnknownConnection(android.os.Handler ), 0, this, handler);
    }

    public void registerForNewRingingConnection(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNewRingingConnection", $$robo$$com_android_internal_telephony_Phone$registerForNewRingingConnection(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForNewRingingConnection(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNewRingingConnection", $$robo$$com_android_internal_telephony_Phone$unregisterForNewRingingConnection(android.os.Handler ), 0, this, handler);
    }

    public void registerForVideoCapabilityChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForVideoCapabilityChanged", $$robo$$com_android_internal_telephony_Phone$registerForVideoCapabilityChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForVideoCapabilityChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForVideoCapabilityChanged", $$robo$$com_android_internal_telephony_Phone$unregisterForVideoCapabilityChanged(android.os.Handler ), 0, this, handler);
    }

    public void registerForInCallVoicePrivacyOn(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_Phone$registerForInCallVoicePrivacyOn(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForInCallVoicePrivacyOn(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOn", $$robo$$com_android_internal_telephony_Phone$unregisterForInCallVoicePrivacyOn(android.os.Handler ), 0, this, handler);
    }

    public void registerForInCallVoicePrivacyOff(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_Phone$registerForInCallVoicePrivacyOff(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForInCallVoicePrivacyOff(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForInCallVoicePrivacyOff", $$robo$$com_android_internal_telephony_Phone$unregisterForInCallVoicePrivacyOff(android.os.Handler ), 0, this, handler);
    }

    public void registerForIncomingRing(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForIncomingRing", $$robo$$com_android_internal_telephony_Phone$registerForIncomingRing(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForIncomingRing(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForIncomingRing", $$robo$$com_android_internal_telephony_Phone$unregisterForIncomingRing(android.os.Handler ), 0, this, handler);
    }

    public void registerForDisconnect(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisconnect", $$robo$$com_android_internal_telephony_Phone$registerForDisconnect(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDisconnect(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisconnect", $$robo$$com_android_internal_telephony_Phone$unregisterForDisconnect(android.os.Handler ), 0, this, handler);
    }

    public void registerForSuppServiceFailed(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSuppServiceFailed", $$robo$$com_android_internal_telephony_Phone$registerForSuppServiceFailed(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSuppServiceFailed(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSuppServiceFailed", $$robo$$com_android_internal_telephony_Phone$unregisterForSuppServiceFailed(android.os.Handler ), 0, this, handler);
    }

    public void registerForMmiInitiate(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiInitiate", $$robo$$com_android_internal_telephony_Phone$registerForMmiInitiate(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForMmiInitiate(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiInitiate", $$robo$$com_android_internal_telephony_Phone$unregisterForMmiInitiate(android.os.Handler ), 0, this, handler);
    }

    public void registerForMmiComplete(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForMmiComplete", $$robo$$com_android_internal_telephony_Phone$registerForMmiComplete(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForMmiComplete(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForMmiComplete", $$robo$$com_android_internal_telephony_Phone$unregisterForMmiComplete(android.os.Handler ), 0, this, handler);
    }

    public void registerForSimRecordsLoaded(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSimRecordsLoaded", $$robo$$com_android_internal_telephony_Phone$registerForSimRecordsLoaded(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSimRecordsLoaded(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSimRecordsLoaded", $$robo$$com_android_internal_telephony_Phone$unregisterForSimRecordsLoaded(android.os.Handler ), 0, this, handler);
    }

    public void registerForTtyModeReceived(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForTtyModeReceived", $$robo$$com_android_internal_telephony_Phone$registerForTtyModeReceived(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForTtyModeReceived(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForTtyModeReceived", $$robo$$com_android_internal_telephony_Phone$unregisterForTtyModeReceived(android.os.Handler ), 0, this, handler);
    }

    public void setNetworkSelectionModeAutomatic(Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomatic", $$robo$$com_android_internal_telephony_Phone$setNetworkSelectionModeAutomatic(android.os.Message ), 0, this, message);
    }

    private void onCheckForNetworkSelectionModeAutomatic(Message message) {
        InvokeDynamicSupport.bootstrap("onCheckForNetworkSelectionModeAutomatic", $$robo$$com_android_internal_telephony_Phone$onCheckForNetworkSelectionModeAutomatic(android.os.Message ), 0, this, message);
    }

    public void getNetworkSelectionMode(Message message) {
        InvokeDynamicSupport.bootstrap("getNetworkSelectionMode", $$robo$$com_android_internal_telephony_Phone$getNetworkSelectionMode(android.os.Message ), 0, this, message);
    }

    public List<ClientRequestStats> getClientRequestStats() {
        return InvokeDynamicSupport.bootstrap("getClientRequestStats", $$robo$$com_android_internal_telephony_Phone$getClientRequestStats(), 0, this);
    }

    public void selectNetworkManually(OperatorInfo operatorInfo, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("selectNetworkManually", $$robo$$com_android_internal_telephony_Phone$selectNetworkManually(com.android.internal.telephony.OperatorInfo boolean android.os.Message ), 0, this, operatorInfo, bl, message);
    }

    public void registerForEmergencyCallToggle(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEmergencyCallToggle", $$robo$$com_android_internal_telephony_Phone$registerForEmergencyCallToggle(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForEmergencyCallToggle(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEmergencyCallToggle", $$robo$$com_android_internal_telephony_Phone$unregisterForEmergencyCallToggle(android.os.Handler ), 0, this, handler);
    }

    private void updateSavedNetworkOperator(NetworkSelectMessage networkSelectMessage) {
        InvokeDynamicSupport.bootstrap("updateSavedNetworkOperator", $$robo$$com_android_internal_telephony_Phone$updateSavedNetworkOperator(com.android.internal.telephony.Phone$NetworkSelectMessage ), 0, this, networkSelectMessage);
    }

    private void handleSetSelectNetwork(AsyncResult asyncResult) {
        InvokeDynamicSupport.bootstrap("handleSetSelectNetwork", $$robo$$com_android_internal_telephony_Phone$handleSetSelectNetwork(android.os.AsyncResult ), 0, this, asyncResult);
    }

    private OperatorInfo getSavedNetworkSelection() {
        return InvokeDynamicSupport.bootstrap("getSavedNetworkSelection", $$robo$$com_android_internal_telephony_Phone$getSavedNetworkSelection(), 0, this);
    }

    private void clearSavedNetworkSelection() {
        InvokeDynamicSupport.bootstrap("clearSavedNetworkSelection", $$robo$$com_android_internal_telephony_Phone$clearSavedNetworkSelection(), 0, this);
    }

    private void restoreSavedNetworkSelection(Message message) {
        InvokeDynamicSupport.bootstrap("restoreSavedNetworkSelection", $$robo$$com_android_internal_telephony_Phone$restoreSavedNetworkSelection(android.os.Message ), 0, this, message);
    }

    public void saveClirSetting(int n) {
        InvokeDynamicSupport.bootstrap("saveClirSetting", $$robo$$com_android_internal_telephony_Phone$saveClirSetting(int ), 0, this, n);
    }

    private void setUnitTestMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setUnitTestMode", $$robo$$com_android_internal_telephony_Phone$setUnitTestMode(boolean ), 0, this, bl);
    }

    public boolean getUnitTestMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("getUnitTestMode", $$robo$$com_android_internal_telephony_Phone$getUnitTestMode(), 0, this);
    }

    protected void notifyDisconnectP(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyDisconnectP", $$robo$$com_android_internal_telephony_Phone$notifyDisconnectP(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    public void registerForServiceStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForServiceStateChanged", $$robo$$com_android_internal_telephony_Phone$registerForServiceStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForServiceStateChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForServiceStateChanged", $$robo$$com_android_internal_telephony_Phone$unregisterForServiceStateChanged(android.os.Handler ), 0, this, handler);
    }

    public void registerForRingbackTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRingbackTone", $$robo$$com_android_internal_telephony_Phone$registerForRingbackTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForRingbackTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRingbackTone", $$robo$$com_android_internal_telephony_Phone$unregisterForRingbackTone(android.os.Handler ), 0, this, handler);
    }

    public void registerForOnHoldTone(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForOnHoldTone", $$robo$$com_android_internal_telephony_Phone$registerForOnHoldTone(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForOnHoldTone(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForOnHoldTone", $$robo$$com_android_internal_telephony_Phone$unregisterForOnHoldTone(android.os.Handler ), 0, this, handler);
    }

    public void registerForResendIncallMute(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForResendIncallMute", $$robo$$com_android_internal_telephony_Phone$registerForResendIncallMute(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForResendIncallMute(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForResendIncallMute", $$robo$$com_android_internal_telephony_Phone$unregisterForResendIncallMute(android.os.Handler ), 0, this, handler);
    }

    public void setEchoSuppressionEnabled() {
        InvokeDynamicSupport.bootstrap("setEchoSuppressionEnabled", $$robo$$com_android_internal_telephony_Phone$setEchoSuppressionEnabled(), 0, this);
    }

    protected void notifyServiceStateChangedP(ServiceState serviceState) {
        InvokeDynamicSupport.bootstrap("notifyServiceStateChangedP", $$robo$$com_android_internal_telephony_Phone$notifyServiceStateChangedP(android.telephony.ServiceState ), 0, this, serviceState);
    }

    public SimulatedRadioControl getSimulatedRadioControl() {
        return InvokeDynamicSupport.bootstrap("getSimulatedRadioControl", $$robo$$com_android_internal_telephony_Phone$getSimulatedRadioControl(), 0, this);
    }

    private void checkCorrectThread(Handler handler) {
        InvokeDynamicSupport.bootstrap("checkCorrectThread", $$robo$$com_android_internal_telephony_Phone$checkCorrectThread(android.os.Handler ), 0, this, handler);
    }

    private static Locale getLocaleFromCarrierProperties(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getLocaleFromCarrierProperties", $$robo$$com_android_internal_telephony_Phone$getLocaleFromCarrierProperties(android.content.Context ), 0, (Context)context);
    }

    public IccFileHandler getIccFileHandler() {
        return InvokeDynamicSupport.bootstrap("getIccFileHandler", $$robo$$com_android_internal_telephony_Phone$getIccFileHandler(), 0, this);
    }

    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$com_android_internal_telephony_Phone$getHandler(), 0, this);
    }

    public void updatePhoneObject(int n) {
        InvokeDynamicSupport.bootstrap("updatePhoneObject", $$robo$$com_android_internal_telephony_Phone$updatePhoneObject(int ), 0, this, n);
    }

    public ServiceStateTracker getServiceStateTracker() {
        return InvokeDynamicSupport.bootstrap("getServiceStateTracker", $$robo$$com_android_internal_telephony_Phone$getServiceStateTracker(), 0, this);
    }

    public CallTracker getCallTracker() {
        return InvokeDynamicSupport.bootstrap("getCallTracker", $$robo$$com_android_internal_telephony_Phone$getCallTracker(), 0, this);
    }

    public void setVoiceActivationState(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceActivationState", $$robo$$com_android_internal_telephony_Phone$setVoiceActivationState(int ), 0, this, n);
    }

    public void setDataActivationState(int n) {
        InvokeDynamicSupport.bootstrap("setDataActivationState", $$robo$$com_android_internal_telephony_Phone$setDataActivationState(int ), 0, this, n);
    }

    public int getVoiceActivationState() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceActivationState", $$robo$$com_android_internal_telephony_Phone$getVoiceActivationState(), 0, this);
    }

    public int getDataActivationState() {
        return (int)InvokeDynamicSupport.bootstrap("getDataActivationState", $$robo$$com_android_internal_telephony_Phone$getDataActivationState(), 0, this);
    }

    public void updateVoiceMail() {
        InvokeDynamicSupport.bootstrap("updateVoiceMail", $$robo$$com_android_internal_telephony_Phone$updateVoiceMail(), 0, this);
    }

    public IccCardApplicationStatus.AppType getCurrentUiccAppType() {
        return InvokeDynamicSupport.bootstrap("getCurrentUiccAppType", $$robo$$com_android_internal_telephony_Phone$getCurrentUiccAppType(), 0, this);
    }

    public IccCard getIccCard() {
        return InvokeDynamicSupport.bootstrap("getIccCard", $$robo$$com_android_internal_telephony_Phone$getIccCard(), 0, this);
    }

    public String getIccSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getIccSerialNumber", $$robo$$com_android_internal_telephony_Phone$getIccSerialNumber(), 0, this);
    }

    public String getFullIccSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getFullIccSerialNumber", $$robo$$com_android_internal_telephony_Phone$getFullIccSerialNumber(), 0, this);
    }

    public boolean getIccRecordsLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccRecordsLoaded", $$robo$$com_android_internal_telephony_Phone$getIccRecordsLoaded(), 0, this);
    }

    public List<CellInfo> getAllCellInfo(WorkSource workSource) {
        return InvokeDynamicSupport.bootstrap("getAllCellInfo", $$robo$$com_android_internal_telephony_Phone$getAllCellInfo(android.os.WorkSource ), 0, this, workSource);
    }

    public CellLocation getCellLocation() {
        return InvokeDynamicSupport.bootstrap("getCellLocation", $$robo$$com_android_internal_telephony_Phone$getCellLocation(), 0, this);
    }

    private List<CellInfo> privatizeCellInfoList(List<CellInfo> list) {
        return InvokeDynamicSupport.bootstrap("privatizeCellInfoList", $$robo$$com_android_internal_telephony_Phone$privatizeCellInfoList(java.util.List<android.telephony.CellInfo> ), 0, this, list);
    }

    public void setCellInfoListRate(int n, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$com_android_internal_telephony_Phone$setCellInfoListRate(int android.os.WorkSource ), 0, this, n, workSource);
    }

    public boolean getMessageWaitingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getMessageWaitingIndicator", $$robo$$com_android_internal_telephony_Phone$getMessageWaitingIndicator(), 0, this);
    }

    private int getCallForwardingIndicatorFromSharedPref() {
        return (int)InvokeDynamicSupport.bootstrap("getCallForwardingIndicatorFromSharedPref", $$robo$$com_android_internal_telephony_Phone$getCallForwardingIndicatorFromSharedPref(), 0, this);
    }

    private void setCallForwardingIndicatorInSharedPref(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCallForwardingIndicatorInSharedPref", $$robo$$com_android_internal_telephony_Phone$setCallForwardingIndicatorInSharedPref(boolean ), 0, this, bl);
    }

    public void setVoiceCallForwardingFlag(int n, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setVoiceCallForwardingFlag", $$robo$$com_android_internal_telephony_Phone$setVoiceCallForwardingFlag(int boolean java.lang.String ), 0, this, n, bl, string2);
    }

    protected void setVoiceCallForwardingFlag(IccRecords iccRecords, int n, boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("setVoiceCallForwardingFlag", $$robo$$com_android_internal_telephony_Phone$setVoiceCallForwardingFlag(com.android.internal.telephony.uicc.IccRecords int boolean java.lang.String ), 0, this, iccRecords, n, bl, string2);
    }

    public boolean getCallForwardingIndicator() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCallForwardingIndicator", $$robo$$com_android_internal_telephony_Phone$getCallForwardingIndicator(), 0, this);
    }

    public CarrierSignalAgent getCarrierSignalAgent() {
        return InvokeDynamicSupport.bootstrap("getCarrierSignalAgent", $$robo$$com_android_internal_telephony_Phone$getCarrierSignalAgent(), 0, this);
    }

    public CarrierActionAgent getCarrierActionAgent() {
        return InvokeDynamicSupport.bootstrap("getCarrierActionAgent", $$robo$$com_android_internal_telephony_Phone$getCarrierActionAgent(), 0, this);
    }

    public void queryCdmaRoamingPreference(Message message) {
        InvokeDynamicSupport.bootstrap("queryCdmaRoamingPreference", $$robo$$com_android_internal_telephony_Phone$queryCdmaRoamingPreference(android.os.Message ), 0, this, message);
    }

    public SignalStrength getSignalStrength() {
        return InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$com_android_internal_telephony_Phone$getSignalStrength(), 0, this);
    }

    public boolean isConcurrentVoiceAndDataAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConcurrentVoiceAndDataAllowed", $$robo$$com_android_internal_telephony_Phone$isConcurrentVoiceAndDataAllowed(), 0, this);
    }

    public void setCdmaRoamingPreference(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingPreference", $$robo$$com_android_internal_telephony_Phone$setCdmaRoamingPreference(int android.os.Message ), 0, this, n, message);
    }

    public void setCdmaSubscription(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaSubscription", $$robo$$com_android_internal_telephony_Phone$setCdmaSubscription(int android.os.Message ), 0, this, n, message);
    }

    public void setPreferredNetworkType(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$com_android_internal_telephony_Phone$setPreferredNetworkType(int android.os.Message ), 0, this, n, message);
    }

    public void getPreferredNetworkType(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$com_android_internal_telephony_Phone$getPreferredNetworkType(android.os.Message ), 0, this, message);
    }

    public void getSmscAddress(Message message) {
        InvokeDynamicSupport.bootstrap("getSmscAddress", $$robo$$com_android_internal_telephony_Phone$getSmscAddress(android.os.Message ), 0, this, message);
    }

    public void setSmscAddress(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setSmscAddress", $$robo$$com_android_internal_telephony_Phone$setSmscAddress(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public void setTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setTTYMode", $$robo$$com_android_internal_telephony_Phone$setTTYMode(int android.os.Message ), 0, this, n, message);
    }

    public void setUiTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUiTTYMode", $$robo$$com_android_internal_telephony_Phone$setUiTTYMode(int android.os.Message ), 0, this, n, message);
    }

    public void queryTTYMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryTTYMode", $$robo$$com_android_internal_telephony_Phone$queryTTYMode(android.os.Message ), 0, this, message);
    }

    public void enableEnhancedVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("enableEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_Phone$enableEnhancedVoicePrivacy(boolean android.os.Message ), 0, this, bl, message);
    }

    public void getEnhancedVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getEnhancedVoicePrivacy", $$robo$$com_android_internal_telephony_Phone$getEnhancedVoicePrivacy(android.os.Message ), 0, this, message);
    }

    public void setBandMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setBandMode", $$robo$$com_android_internal_telephony_Phone$setBandMode(int android.os.Message ), 0, this, n, message);
    }

    public void queryAvailableBandMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryAvailableBandMode", $$robo$$com_android_internal_telephony_Phone$queryAvailableBandMode(android.os.Message ), 0, this, message);
    }

    @Deprecated
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$com_android_internal_telephony_Phone$invokeOemRilRequestRaw(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Deprecated
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestStrings", $$robo$$com_android_internal_telephony_Phone$invokeOemRilRequestStrings(java.lang.String[] android.os.Message ), 0, this, stringArray, message);
    }

    public void nvReadItem(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$com_android_internal_telephony_Phone$nvReadItem(int android.os.Message ), 0, this, n, message);
    }

    public void nvWriteItem(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$com_android_internal_telephony_Phone$nvWriteItem(int java.lang.String android.os.Message ), 0, this, n, string2, message);
    }

    public void nvWriteCdmaPrl(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$com_android_internal_telephony_Phone$nvWriteCdmaPrl(byte[] android.os.Message ), 0, this, byArray, message);
    }

    public void nvResetConfig(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$com_android_internal_telephony_Phone$nvResetConfig(int android.os.Message ), 0, this, n, message);
    }

    public void notifyDataActivity() {
        InvokeDynamicSupport.bootstrap("notifyDataActivity", $$robo$$com_android_internal_telephony_Phone$notifyDataActivity(), 0, this);
    }

    private void notifyMessageWaitingIndicator() {
        InvokeDynamicSupport.bootstrap("notifyMessageWaitingIndicator", $$robo$$com_android_internal_telephony_Phone$notifyMessageWaitingIndicator(), 0, this);
    }

    public void notifyDataConnection(String string2, String string3, PhoneConstants.DataState dataState) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_Phone$notifyDataConnection(java.lang.String java.lang.String com.android.internal.telephony.PhoneConstants$DataState ), 0, this, string2, string3, dataState);
    }

    public void notifyDataConnection(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_Phone$notifyDataConnection(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void notifyDataConnection(String string2) {
        InvokeDynamicSupport.bootstrap("notifyDataConnection", $$robo$$com_android_internal_telephony_Phone$notifyDataConnection(java.lang.String ), 0, this, string2);
    }

    public void notifyOtaspChanged(int n) {
        InvokeDynamicSupport.bootstrap("notifyOtaspChanged", $$robo$$com_android_internal_telephony_Phone$notifyOtaspChanged(int ), 0, this, n);
    }

    public void notifyVoiceActivationStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("notifyVoiceActivationStateChanged", $$robo$$com_android_internal_telephony_Phone$notifyVoiceActivationStateChanged(int ), 0, this, n);
    }

    public void notifyDataActivationStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("notifyDataActivationStateChanged", $$robo$$com_android_internal_telephony_Phone$notifyDataActivationStateChanged(int ), 0, this, n);
    }

    public void notifySignalStrength() {
        InvokeDynamicSupport.bootstrap("notifySignalStrength", $$robo$$com_android_internal_telephony_Phone$notifySignalStrength(), 0, this);
    }

    public void notifyCellInfo(List<CellInfo> list) {
        InvokeDynamicSupport.bootstrap("notifyCellInfo", $$robo$$com_android_internal_telephony_Phone$notifyCellInfo(java.util.List<android.telephony.CellInfo> ), 0, this, list);
    }

    public void notifyVoLteServiceStateChanged(VoLteServiceState voLteServiceState) {
        InvokeDynamicSupport.bootstrap("notifyVoLteServiceStateChanged", $$robo$$com_android_internal_telephony_Phone$notifyVoLteServiceStateChanged(android.telephony.VoLteServiceState ), 0, this, voLteServiceState);
    }

    public boolean isInEmergencyCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEmergencyCall", $$robo$$com_android_internal_telephony_Phone$isInEmergencyCall(), 0, this);
    }

    protected static boolean getInEcmMode() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getInEcmMode", $$robo$$com_android_internal_telephony_Phone$getInEcmMode(), 0);
    }

    public boolean isInEcm() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInEcm", $$robo$$com_android_internal_telephony_Phone$isInEcm(), 0, this);
    }

    public void setIsInEcm(boolean bl) {
        InvokeDynamicSupport.bootstrap("setIsInEcm", $$robo$$com_android_internal_telephony_Phone$setIsInEcm(boolean ), 0, this, bl);
    }

    private static int getVideoState(Call call) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getVideoState", $$robo$$com_android_internal_telephony_Phone$getVideoState(com.android.internal.telephony.Call ), 0, (Call)call);
    }

    private boolean isVideoCallOrConference(Call call) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoCallOrConference", $$robo$$com_android_internal_telephony_Phone$isVideoCallOrConference(com.android.internal.telephony.Call ), 0, this, call);
    }

    public boolean isImsVideoCallOrConferencePresent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsVideoCallOrConferencePresent", $$robo$$com_android_internal_telephony_Phone$isImsVideoCallOrConferencePresent(), 0, this);
    }

    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$com_android_internal_telephony_Phone$getVoiceMessageCount(), 0, this);
    }

    public void setVoiceMessageCount(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageCount", $$robo$$com_android_internal_telephony_Phone$setVoiceMessageCount(int ), 0, this, n);
    }

    protected int getStoredVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getStoredVoiceMessageCount", $$robo$$com_android_internal_telephony_Phone$getStoredVoiceMessageCount(), 0, this);
    }

    public void sendDialerSpecialCode(String string2) {
        InvokeDynamicSupport.bootstrap("sendDialerSpecialCode", $$robo$$com_android_internal_telephony_Phone$sendDialerSpecialCode(java.lang.String ), 0, this, string2);
    }

    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$com_android_internal_telephony_Phone$getCdmaEriIconIndex(), 0, this);
    }

    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$com_android_internal_telephony_Phone$getCdmaEriIconMode(), 0, this);
    }

    public String getCdmaEriText() {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$com_android_internal_telephony_Phone$getCdmaEriText(), 0, this);
    }

    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$com_android_internal_telephony_Phone$getCdmaMin(), 0, this);
    }

    public boolean isMinInfoReady() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMinInfoReady", $$robo$$com_android_internal_telephony_Phone$isMinInfoReady(), 0, this);
    }

    public String getCdmaPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getCdmaPrlVersion", $$robo$$com_android_internal_telephony_Phone$getCdmaPrlVersion(), 0, this);
    }

    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_Phone$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    public void setOnPostDialCharacter(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnPostDialCharacter", $$robo$$com_android_internal_telephony_Phone$setOnPostDialCharacter(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public Registrant getPostDialHandler() {
        return InvokeDynamicSupport.bootstrap("getPostDialHandler", $$robo$$com_android_internal_telephony_Phone$getPostDialHandler(), 0, this);
    }

    public void exitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_Phone$exitEmergencyCallbackMode(), 0, this);
    }

    public void registerForCdmaOtaStatusChange(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_Phone$registerForCdmaOtaStatusChange(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCdmaOtaStatusChange(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCdmaOtaStatusChange", $$robo$$com_android_internal_telephony_Phone$unregisterForCdmaOtaStatusChange(android.os.Handler ), 0, this, handler);
    }

    public void registerForSubscriptionInfoReady(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_Phone$registerForSubscriptionInfoReady(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSubscriptionInfoReady(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSubscriptionInfoReady", $$robo$$com_android_internal_telephony_Phone$unregisterForSubscriptionInfoReady(android.os.Handler ), 0, this, handler);
    }

    public boolean needsOtaServiceProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsOtaServiceProvisioning", $$robo$$com_android_internal_telephony_Phone$needsOtaServiceProvisioning(), 0, this);
    }

    public boolean isOtaSpNumber(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOtaSpNumber", $$robo$$com_android_internal_telephony_Phone$isOtaSpNumber(java.lang.String ), 0, this, string2);
    }

    public void registerForCallWaiting(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForCallWaiting", $$robo$$com_android_internal_telephony_Phone$registerForCallWaiting(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForCallWaiting(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForCallWaiting", $$robo$$com_android_internal_telephony_Phone$unregisterForCallWaiting(android.os.Handler ), 0, this, handler);
    }

    public void registerForEcmTimerReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForEcmTimerReset", $$robo$$com_android_internal_telephony_Phone$registerForEcmTimerReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForEcmTimerReset(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForEcmTimerReset", $$robo$$com_android_internal_telephony_Phone$unregisterForEcmTimerReset(android.os.Handler ), 0, this, handler);
    }

    public void registerForSignalInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForSignalInfo", $$robo$$com_android_internal_telephony_Phone$registerForSignalInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForSignalInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForSignalInfo", $$robo$$com_android_internal_telephony_Phone$unregisterForSignalInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerForDisplayInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDisplayInfo", $$robo$$com_android_internal_telephony_Phone$registerForDisplayInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDisplayInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDisplayInfo", $$robo$$com_android_internal_telephony_Phone$unregisterForDisplayInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerForNumberInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNumberInfo", $$robo$$com_android_internal_telephony_Phone$registerForNumberInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForNumberInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNumberInfo", $$robo$$com_android_internal_telephony_Phone$unregisterForNumberInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerForRedirectedNumberInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRedirectedNumberInfo", $$robo$$com_android_internal_telephony_Phone$registerForRedirectedNumberInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForRedirectedNumberInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRedirectedNumberInfo", $$robo$$com_android_internal_telephony_Phone$unregisterForRedirectedNumberInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerForLineControlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForLineControlInfo", $$robo$$com_android_internal_telephony_Phone$registerForLineControlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForLineControlInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForLineControlInfo", $$robo$$com_android_internal_telephony_Phone$unregisterForLineControlInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerFoT53ClirlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerFoT53ClirlInfo", $$robo$$com_android_internal_telephony_Phone$registerFoT53ClirlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForT53ClirInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForT53ClirInfo", $$robo$$com_android_internal_telephony_Phone$unregisterForT53ClirInfo(android.os.Handler ), 0, this, handler);
    }

    public void registerForT53AudioControlInfo(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForT53AudioControlInfo", $$robo$$com_android_internal_telephony_Phone$registerForT53AudioControlInfo(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForT53AudioControlInfo(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForT53AudioControlInfo", $$robo$$com_android_internal_telephony_Phone$unregisterForT53AudioControlInfo(android.os.Handler ), 0, this, handler);
    }

    public void setOnEcbModeExitResponse(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_Phone$setOnEcbModeExitResponse(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unsetOnEcbModeExitResponse(Handler handler) {
        InvokeDynamicSupport.bootstrap("unsetOnEcbModeExitResponse", $$robo$$com_android_internal_telephony_Phone$unsetOnEcbModeExitResponse(android.os.Handler ), 0, this, handler);
    }

    public void registerForRadioOffOrNotAvailable(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRadioOffOrNotAvailable", $$robo$$com_android_internal_telephony_Phone$registerForRadioOffOrNotAvailable(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForRadioOffOrNotAvailable(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRadioOffOrNotAvailable", $$robo$$com_android_internal_telephony_Phone$unregisterForRadioOffOrNotAvailable(android.os.Handler ), 0, this, handler);
    }

    public String[] getActiveApnTypes() {
        return InvokeDynamicSupport.bootstrap("getActiveApnTypes", $$robo$$com_android_internal_telephony_Phone$getActiveApnTypes(), 0, this);
    }

    public boolean hasMatchedTetherApnSetting() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMatchedTetherApnSetting", $$robo$$com_android_internal_telephony_Phone$hasMatchedTetherApnSetting(), 0, this);
    }

    public String getActiveApnHost(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveApnHost", $$robo$$com_android_internal_telephony_Phone$getActiveApnHost(java.lang.String ), 0, this, string2);
    }

    public LinkProperties getLinkProperties(String string2) {
        return InvokeDynamicSupport.bootstrap("getLinkProperties", $$robo$$com_android_internal_telephony_Phone$getLinkProperties(java.lang.String ), 0, this, string2);
    }

    public NetworkCapabilities getNetworkCapabilities(String string2) {
        return InvokeDynamicSupport.bootstrap("getNetworkCapabilities", $$robo$$com_android_internal_telephony_Phone$getNetworkCapabilities(java.lang.String ), 0, this, string2);
    }

    public boolean isDataAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataAllowed", $$robo$$com_android_internal_telephony_Phone$isDataAllowed(), 0, this);
    }

    public boolean isDataAllowed(DataConnectionReasons dataConnectionReasons) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataAllowed", $$robo$$com_android_internal_telephony_Phone$isDataAllowed(com.android.internal.telephony.dataconnection.DataConnectionReasons ), 0, this, dataConnectionReasons);
    }

    public void carrierActionSetMeteredApnsEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("carrierActionSetMeteredApnsEnabled", $$robo$$com_android_internal_telephony_Phone$carrierActionSetMeteredApnsEnabled(boolean ), 0, this, bl);
    }

    public void carrierActionSetRadioEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("carrierActionSetRadioEnabled", $$robo$$com_android_internal_telephony_Phone$carrierActionSetRadioEnabled(boolean ), 0, this, bl);
    }

    public void carrierActionReportDefaultNetworkStatus(boolean bl) {
        InvokeDynamicSupport.bootstrap("carrierActionReportDefaultNetworkStatus", $$robo$$com_android_internal_telephony_Phone$carrierActionReportDefaultNetworkStatus(boolean ), 0, this, bl);
    }

    public void notifyNewRingingConnectionP(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyNewRingingConnectionP", $$robo$$com_android_internal_telephony_Phone$notifyNewRingingConnectionP(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    public void notifyUnknownConnectionP(Connection connection) {
        InvokeDynamicSupport.bootstrap("notifyUnknownConnectionP", $$robo$$com_android_internal_telephony_Phone$notifyUnknownConnectionP(com.android.internal.telephony.Connection ), 0, this, connection);
    }

    public void notifyForVideoCapabilityChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyForVideoCapabilityChanged", $$robo$$com_android_internal_telephony_Phone$notifyForVideoCapabilityChanged(boolean ), 0, this, bl);
    }

    private void notifyIncomingRing() {
        InvokeDynamicSupport.bootstrap("notifyIncomingRing", $$robo$$com_android_internal_telephony_Phone$notifyIncomingRing(), 0, this);
    }

    private void sendIncomingCallRingNotification(int n) {
        InvokeDynamicSupport.bootstrap("sendIncomingCallRingNotification", $$robo$$com_android_internal_telephony_Phone$sendIncomingCallRingNotification(int ), 0, this, n);
    }

    public boolean isCspPlmnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCspPlmnEnabled", $$robo$$com_android_internal_telephony_Phone$isCspPlmnEnabled(), 0, this);
    }

    public IsimRecords getIsimRecords() {
        return InvokeDynamicSupport.bootstrap("getIsimRecords", $$robo$$com_android_internal_telephony_Phone$getIsimRecords(), 0, this);
    }

    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$com_android_internal_telephony_Phone$getMsisdn(), 0, this);
    }

    public PhoneConstants.DataState getDataConnectionState() {
        return InvokeDynamicSupport.bootstrap("getDataConnectionState", $$robo$$com_android_internal_telephony_Phone$getDataConnectionState(), 0, this);
    }

    public void notifyCallForwardingIndicator() {
        InvokeDynamicSupport.bootstrap("notifyCallForwardingIndicator", $$robo$$com_android_internal_telephony_Phone$notifyCallForwardingIndicator(), 0, this);
    }

    public void notifyDataConnectionFailed(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("notifyDataConnectionFailed", $$robo$$com_android_internal_telephony_Phone$notifyDataConnectionFailed(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void notifyPreciseDataConnectionFailed(String string2, String string3, String string4, String string5) {
        InvokeDynamicSupport.bootstrap("notifyPreciseDataConnectionFailed", $$robo$$com_android_internal_telephony_Phone$notifyPreciseDataConnectionFailed(java.lang.String java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4, string5);
    }

    public int getLteOnCdmaMode() {
        return (int)InvokeDynamicSupport.bootstrap("getLteOnCdmaMode", $$robo$$com_android_internal_telephony_Phone$getLteOnCdmaMode(), 0, this);
    }

    public void setVoiceMessageWaiting(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceMessageWaiting", $$robo$$com_android_internal_telephony_Phone$setVoiceMessageWaiting(int int ), 0, this, n, n2);
    }

    public UsimServiceTable getUsimServiceTable() {
        return InvokeDynamicSupport.bootstrap("getUsimServiceTable", $$robo$$com_android_internal_telephony_Phone$getUsimServiceTable(), 0, this);
    }

    public UiccCard getUiccCard() {
        return InvokeDynamicSupport.bootstrap("getUiccCard", $$robo$$com_android_internal_telephony_Phone$getUiccCard(), 0, this);
    }

    public String[] getPcscfAddress(String string2) {
        return InvokeDynamicSupport.bootstrap("getPcscfAddress", $$robo$$com_android_internal_telephony_Phone$getPcscfAddress(java.lang.String ), 0, this, string2);
    }

    public void setImsRegistrationState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$com_android_internal_telephony_Phone$setImsRegistrationState(boolean ), 0, this, bl);
    }

    public Phone getImsPhone() {
        return InvokeDynamicSupport.bootstrap("getImsPhone", $$robo$$com_android_internal_telephony_Phone$getImsPhone(), 0, this);
    }

    @Override
    public ImsiEncryptionInfo getCarrierInfoForImsiEncryption(int n) {
        return InvokeDynamicSupport.bootstrap("getCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_Phone$getCarrierInfoForImsiEncryption(int ), 0, this, n);
    }

    @Override
    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo) {
        InvokeDynamicSupport.bootstrap("setCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_Phone$setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo ), 0, this, imsiEncryptionInfo);
    }

    public boolean isUtEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUtEnabled", $$robo$$com_android_internal_telephony_Phone$isUtEnabled(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_Phone$dispose(), 0, this);
    }

    private void updateImsPhone() {
        InvokeDynamicSupport.bootstrap("updateImsPhone", $$robo$$com_android_internal_telephony_Phone$updateImsPhone(), 0, this);
    }

    protected Connection dialInternal(String string2, UUSInfo uUSInfo, int n, Bundle bundle) throws CallStateException {
        return InvokeDynamicSupport.bootstrap("dialInternal", $$robo$$com_android_internal_telephony_Phone$dialInternal(java.lang.String com.android.internal.telephony.UUSInfo int android.os.Bundle ), 0, this, string2, uUSInfo, n, bundle);
    }

    public int getSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$com_android_internal_telephony_Phone$getSubId(), 0, this);
    }

    public int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$com_android_internal_telephony_Phone$getPhoneId(), 0, this);
    }

    public int getVoicePhoneServiceState() {
        return (int)InvokeDynamicSupport.bootstrap("getVoicePhoneServiceState", $$robo$$com_android_internal_telephony_Phone$getVoicePhoneServiceState(), 0, this);
    }

    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$com_android_internal_telephony_Phone$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    public boolean setRoamingOverride(List<String> list, List<String> list2, List<String> list3, List<String> list4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRoamingOverride", $$robo$$com_android_internal_telephony_Phone$setRoamingOverride(java.util.List<java.lang.String> java.util.List<java.lang.String> java.util.List<java.lang.String> java.util.List<java.lang.String> ), 0, this, list, list2, list3, list4);
    }

    private void setRoamingOverrideHelper(List<String> list, String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setRoamingOverrideHelper", $$robo$$com_android_internal_telephony_Phone$setRoamingOverrideHelper(java.util.List<java.lang.String> java.lang.String java.lang.String ), 0, this, list, string2, string3);
    }

    public boolean isMccMncMarkedAsRoaming(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMccMncMarkedAsRoaming", $$robo$$com_android_internal_telephony_Phone$isMccMncMarkedAsRoaming(java.lang.String ), 0, this, string2);
    }

    public boolean isMccMncMarkedAsNonRoaming(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMccMncMarkedAsNonRoaming", $$robo$$com_android_internal_telephony_Phone$isMccMncMarkedAsNonRoaming(java.lang.String ), 0, this, string2);
    }

    public boolean isSidMarkedAsRoaming(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSidMarkedAsRoaming", $$robo$$com_android_internal_telephony_Phone$isSidMarkedAsRoaming(int ), 0, this, n);
    }

    public boolean isSidMarkedAsNonRoaming(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSidMarkedAsNonRoaming", $$robo$$com_android_internal_telephony_Phone$isSidMarkedAsNonRoaming(int ), 0, this, n);
    }

    public boolean isImsRegistered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsRegistered", $$robo$$com_android_internal_telephony_Phone$isImsRegistered(), 0, this);
    }

    public boolean isWifiCallingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiCallingEnabled", $$robo$$com_android_internal_telephony_Phone$isWifiCallingEnabled(), 0, this);
    }

    public boolean isVolteEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolteEnabled", $$robo$$com_android_internal_telephony_Phone$isVolteEnabled(), 0, this);
    }

    private boolean getRoamingOverrideHelper(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("getRoamingOverrideHelper", $$robo$$com_android_internal_telephony_Phone$getRoamingOverrideHelper(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean isRadioAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRadioAvailable", $$robo$$com_android_internal_telephony_Phone$isRadioAvailable(), 0, this);
    }

    public boolean isRadioOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRadioOn", $$robo$$com_android_internal_telephony_Phone$isRadioOn(), 0, this);
    }

    public void shutdownRadio() {
        InvokeDynamicSupport.bootstrap("shutdownRadio", $$robo$$com_android_internal_telephony_Phone$shutdownRadio(), 0, this);
    }

    public boolean isShuttingDown() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShuttingDown", $$robo$$com_android_internal_telephony_Phone$isShuttingDown(), 0, this);
    }

    public void setRadioCapability(RadioCapability radioCapability, Message message) {
        InvokeDynamicSupport.bootstrap("setRadioCapability", $$robo$$com_android_internal_telephony_Phone$setRadioCapability(com.android.internal.telephony.RadioCapability android.os.Message ), 0, this, radioCapability, message);
    }

    public int getRadioAccessFamily() {
        return (int)InvokeDynamicSupport.bootstrap("getRadioAccessFamily", $$robo$$com_android_internal_telephony_Phone$getRadioAccessFamily(), 0, this);
    }

    public String getModemUuId() {
        return InvokeDynamicSupport.bootstrap("getModemUuId", $$robo$$com_android_internal_telephony_Phone$getModemUuId(), 0, this);
    }

    public RadioCapability getRadioCapability() {
        return InvokeDynamicSupport.bootstrap("getRadioCapability", $$robo$$com_android_internal_telephony_Phone$getRadioCapability(), 0, this);
    }

    public void radioCapabilityUpdated(RadioCapability radioCapability) {
        InvokeDynamicSupport.bootstrap("radioCapabilityUpdated", $$robo$$com_android_internal_telephony_Phone$radioCapabilityUpdated(com.android.internal.telephony.RadioCapability ), 0, this, radioCapability);
    }

    public void sendSubscriptionSettings(boolean bl) {
        InvokeDynamicSupport.bootstrap("sendSubscriptionSettings", $$robo$$com_android_internal_telephony_Phone$sendSubscriptionSettings(boolean ), 0, this, bl);
    }

    protected void setPreferredNetworkTypeIfSimLoaded() {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkTypeIfSimLoaded", $$robo$$com_android_internal_telephony_Phone$setPreferredNetworkTypeIfSimLoaded(), 0, this);
    }

    public void registerForRadioCapabilityChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForRadioCapabilityChanged", $$robo$$com_android_internal_telephony_Phone$registerForRadioCapabilityChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForRadioCapabilityChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForRadioCapabilityChanged", $$robo$$com_android_internal_telephony_Phone$unregisterForRadioCapabilityChanged(android.os.Handler ), 0, this, handler);
    }

    public boolean isImsUseEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsUseEnabled", $$robo$$com_android_internal_telephony_Phone$isImsUseEnabled(), 0, this);
    }

    public boolean isImsAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsAvailable", $$robo$$com_android_internal_telephony_Phone$isImsAvailable(), 0, this);
    }

    public boolean isVideoEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoEnabled", $$robo$$com_android_internal_telephony_Phone$isVideoEnabled(), 0, this);
    }

    public int getLceStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getLceStatus", $$robo$$com_android_internal_telephony_Phone$getLceStatus(), 0, this);
    }

    public void getModemActivityInfo(Message message) {
        InvokeDynamicSupport.bootstrap("getModemActivityInfo", $$robo$$com_android_internal_telephony_Phone$getModemActivityInfo(android.os.Message ), 0, this, message);
    }

    public void startLceAfterRadioIsAvailable() {
        InvokeDynamicSupport.bootstrap("startLceAfterRadioIsAvailable", $$robo$$com_android_internal_telephony_Phone$startLceAfterRadioIsAvailable(), 0, this);
    }

    public void setAllowedCarriers(List<CarrierIdentifier> list, Message message) {
        InvokeDynamicSupport.bootstrap("setAllowedCarriers", $$robo$$com_android_internal_telephony_Phone$setAllowedCarriers(java.util.List<android.service.carrier.CarrierIdentifier> android.os.Message ), 0, this, list, message);
    }

    public void getAllowedCarriers(Message message) {
        InvokeDynamicSupport.bootstrap("getAllowedCarriers", $$robo$$com_android_internal_telephony_Phone$getAllowedCarriers(android.os.Message ), 0, this, message);
    }

    public Locale getLocaleFromSimAndCarrierPrefs() {
        return InvokeDynamicSupport.bootstrap("getLocaleFromSimAndCarrierPrefs", $$robo$$com_android_internal_telephony_Phone$getLocaleFromSimAndCarrierPrefs(), 0, this);
    }

    public void updateDataConnectionTracker() {
        InvokeDynamicSupport.bootstrap("updateDataConnectionTracker", $$robo$$com_android_internal_telephony_Phone$updateDataConnectionTracker(), 0, this);
    }

    public void setInternalDataEnabled(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setInternalDataEnabled", $$robo$$com_android_internal_telephony_Phone$setInternalDataEnabled(boolean android.os.Message ), 0, this, bl, message);
    }

    public boolean updateCurrentCarrierInProvider() {
        return (boolean)InvokeDynamicSupport.bootstrap("updateCurrentCarrierInProvider", $$robo$$com_android_internal_telephony_Phone$updateCurrentCarrierInProvider(), 0, this);
    }

    public void registerForAllDataDisconnected(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForAllDataDisconnected", $$robo$$com_android_internal_telephony_Phone$registerForAllDataDisconnected(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForAllDataDisconnected(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForAllDataDisconnected", $$robo$$com_android_internal_telephony_Phone$unregisterForAllDataDisconnected(android.os.Handler ), 0, this, handler);
    }

    public void registerForDataEnabledChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForDataEnabledChanged", $$robo$$com_android_internal_telephony_Phone$registerForDataEnabledChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void unregisterForDataEnabledChanged(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForDataEnabledChanged", $$robo$$com_android_internal_telephony_Phone$unregisterForDataEnabledChanged(android.os.Handler ), 0, this, handler);
    }

    public IccSmsInterfaceManager getIccSmsInterfaceManager() {
        return InvokeDynamicSupport.bootstrap("getIccSmsInterfaceManager", $$robo$$com_android_internal_telephony_Phone$getIccSmsInterfaceManager(), 0, this);
    }

    protected boolean isMatchGid(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isMatchGid", $$robo$$com_android_internal_telephony_Phone$isMatchGid(java.lang.String ), 0, this, string2);
    }

    public static void checkWfcWifiOnlyModeBeforeDial(Phone phone, Context context) throws CallStateException {
        InvokeDynamicSupport.bootstrapStatic("checkWfcWifiOnlyModeBeforeDial", $$robo$$com_android_internal_telephony_Phone$checkWfcWifiOnlyModeBeforeDial(com.android.internal.telephony.Phone android.content.Context ), 0, (Phone)phone, (Context)context);
    }

    public void startRingbackTone() {
        InvokeDynamicSupport.bootstrap("startRingbackTone", $$robo$$com_android_internal_telephony_Phone$startRingbackTone(), 0, this);
    }

    public void stopRingbackTone() {
        InvokeDynamicSupport.bootstrap("stopRingbackTone", $$robo$$com_android_internal_telephony_Phone$stopRingbackTone(), 0, this);
    }

    public void callEndCleanupHandOverCallIfAny() {
        InvokeDynamicSupport.bootstrap("callEndCleanupHandOverCallIfAny", $$robo$$com_android_internal_telephony_Phone$callEndCleanupHandOverCallIfAny(), 0, this);
    }

    public void cancelUSSD() {
        InvokeDynamicSupport.bootstrap("cancelUSSD", $$robo$$com_android_internal_telephony_Phone$cancelUSSD(), 0, this);
    }

    public Phone getDefaultPhone() {
        return InvokeDynamicSupport.bootstrap("getDefaultPhone", $$robo$$com_android_internal_telephony_Phone$getDefaultPhone(), 0, this);
    }

    public NetworkStats getVtDataUsage(boolean bl) {
        return InvokeDynamicSupport.bootstrap("getVtDataUsage", $$robo$$com_android_internal_telephony_Phone$getVtDataUsage(boolean ), 0, this, bl);
    }

    public void setPolicyDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setPolicyDataEnabled", $$robo$$com_android_internal_telephony_Phone$setPolicyDataEnabled(boolean ), 0, this, bl);
    }

    public Uri[] getCurrentSubscriberUris() {
        return InvokeDynamicSupport.bootstrap("getCurrentSubscriberUris", $$robo$$com_android_internal_telephony_Phone$getCurrentSubscriberUris(), 0, this);
    }

    public AppSmsManager getAppSmsManager() {
        return InvokeDynamicSupport.bootstrap("getAppSmsManager", $$robo$$com_android_internal_telephony_Phone$getAppSmsManager(), 0, this);
    }

    public void setSimPowerState(int n) {
        InvokeDynamicSupport.bootstrap("setSimPowerState", $$robo$$com_android_internal_telephony_Phone$setSimPowerState(int ), 0, this, n);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_Phone$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(Phone.class);
    }

    public /* synthetic */ Phone() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Phone)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NetworkSelectMessage
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public Message message;
        public String operatorNumeric;
        public String operatorAlphaLong;
        public String operatorAlphaShort;

        private void $$robo$$com_android_internal_telephony_Phone_NetworkSelectMessage$__constructor__() {
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_Phone_NetworkSelectMessage$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_Phone_NetworkSelectMessage$__constructor__();
        }

        private NetworkSelectMessage() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_Phone_NetworkSelectMessage$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_telephony_Phone_NetworkSelectMessage$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkSelectMessage)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

