/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.LocalServerSocket;
import android.os.Looper;
import android.os.ServiceManager;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import com.android.internal.os.BackgroundThread;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.IntentBroadcaster;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.SubscriptionInfoUpdater;
import com.android.internal.telephony.SubscriptionMonitor;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.dataconnection.TelephonyNetworkFactory;
import com.android.internal.telephony.euicc.EuiccController;
import com.android.internal.telephony.ims.ImsResolver;
import com.android.internal.telephony.imsphone.ImsPhoneFactory;
import com.android.internal.telephony.sip.SipPhone;
import com.android.internal.telephony.sip.SipPhoneFactory;
import com.android.internal.telephony.uicc.IccCardProxy;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.telephony.util.NotificationChannelController;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "PhoneFactory";
    static int SOCKET_OPEN_RETRY_MILLIS = 2000;
    static int SOCKET_OPEN_MAX_RETRY = 3;
    static boolean DBG = false;
    static Object sLockProxyPhones;
    private static Phone[] sPhones;
    private static Phone sPhone;
    private static CommandsInterface[] sCommandsInterfaces;
    private static ProxyController sProxyController;
    private static UiccController sUiccController;
    private static IntentBroadcaster sIntentBroadcaster;
    private static EuiccController sEuiccController;
    private static CommandsInterface sCommandsInterface;
    private static SubscriptionInfoUpdater sSubInfoRecordUpdater;
    private static boolean sMadeDefaults;
    private static PhoneNotifier sPhoneNotifier;
    private static Context sContext;
    private static PhoneSwitcher sPhoneSwitcher;
    private static SubscriptionMonitor sSubscriptionMonitor;
    private static TelephonyNetworkFactory[] sTelephonyNetworkFactories;
    private static ImsResolver sImsResolver;
    private static NotificationChannelController sNotificationChannelController;
    private static HashMap<String, LocalLog> sLocalLogs;
    public static int MAX_ACTIVE_PHONES = 1;

    private void $$robo$$com_android_internal_telephony_PhoneFactory$__constructor__() {
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhones(Context context) {
        PhoneFactory.makeDefaultPhone(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhone(Context context) {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                int i;
                sContext = context;
                TelephonyDevController.create();
                int retryCount = 0;
                while (true) {
                    boolean hasException = false;
                    ++retryCount;
                    try {
                        new LocalServerSocket("com.android.internal.telephony");
                    }
                    catch (IOException ex) {
                        hasException = true;
                    }
                    if (!hasException) break;
                    if (retryCount > 3) {
                        throw new RuntimeException("PhoneFactory probably already running");
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {}
                }
                sPhoneNotifier = new DefaultPhoneNotifier();
                int cdmaSubscription = CdmaSubscriptionSourceManager.getDefault(context);
                Rlog.i("PhoneFactory", "Cdma Subscription set to " + cdmaSubscription);
                if (context.getPackageManager().hasSystemFeature("android.hardware.telephony.euicc")) {
                    sEuiccController = EuiccController.init(context);
                }
                int numPhones = TelephonyManager.getDefault().getPhoneCount();
                String defaultImsPackage = sContext.getResources().getString(17039671);
                Rlog.i("PhoneFactory", "ImsResolver: defaultImsPackage: " + defaultImsPackage);
                sImsResolver = new ImsResolver(sContext, defaultImsPackage, numPhones);
                sImsResolver.populateCacheAndStartBind();
                int[] networkModes = new int[numPhones];
                sPhones = new Phone[numPhones];
                sCommandsInterfaces = new RIL[numPhones];
                sTelephonyNetworkFactories = new TelephonyNetworkFactory[numPhones];
                for (i = 0; i < numPhones; ++i) {
                    networkModes[i] = RILConstants.PREFERRED_NETWORK_MODE;
                    Rlog.i("PhoneFactory", "Network Mode set to " + Integer.toString(networkModes[i]));
                    PhoneFactory.sCommandsInterfaces[i] = new RIL(context, networkModes[i], cdmaSubscription, i);
                }
                Rlog.i("PhoneFactory", "Creating SubscriptionController");
                SubscriptionController.init(context, sCommandsInterfaces);
                sUiccController = UiccController.make(context, sCommandsInterfaces);
                for (i = 0; i < numPhones; ++i) {
                    GsmCdmaPhone phone = null;
                    int phoneType = TelephonyManager.getPhoneType(networkModes[i]);
                    if (phoneType == 1) {
                        phone = new GsmCdmaPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i, 1, TelephonyComponentFactory.getInstance());
                    } else if (phoneType == 2) {
                        phone = new GsmCdmaPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i, 6, TelephonyComponentFactory.getInstance());
                    }
                    Rlog.i("PhoneFactory", "Creating Phone with type = " + phoneType + " sub = " + i);
                    PhoneFactory.sPhones[i] = phone;
                }
                sPhone = sPhones[0];
                sCommandsInterface = sCommandsInterfaces[0];
                ComponentName componentName = SmsApplication.getDefaultSmsApplication(context, true);
                String packageName = "NONE";
                if (componentName != null) {
                    packageName = componentName.getPackageName();
                }
                Rlog.i("PhoneFactory", "defaultSmsApplication: " + packageName);
                SmsApplication.initSmsPackageMonitor(context);
                sMadeDefaults = true;
                Rlog.i("PhoneFactory", "Creating SubInfoRecordUpdater ");
                sSubInfoRecordUpdater = new SubscriptionInfoUpdater(BackgroundThread.get().getLooper(), context, sPhones, sCommandsInterfaces);
                SubscriptionController.getInstance().updatePhonesAvailability(sPhones);
                for (int i2 = 0; i2 < numPhones; ++i2) {
                    sPhones[i2].startMonitoringImsService();
                }
                ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
                SubscriptionController sc = SubscriptionController.getInstance();
                sSubscriptionMonitor = new SubscriptionMonitor(tr, sContext, sc, numPhones);
                sPhoneSwitcher = new PhoneSwitcher(1, numPhones, sContext, sc, Looper.myLooper(), tr, sCommandsInterfaces, sPhones);
                sProxyController = ProxyController.getInstance(context, sPhones, sUiccController, sCommandsInterfaces, sPhoneSwitcher);
                sIntentBroadcaster = IntentBroadcaster.getInstance(context);
                sNotificationChannelController = new NotificationChannelController(context);
                sTelephonyNetworkFactories = new TelephonyNetworkFactory[numPhones];
                for (int i3 = 0; i3 < numPhones; ++i3) {
                    PhoneFactory.sTelephonyNetworkFactories[i3] = new TelephonyNetworkFactory(sPhoneSwitcher, sc, sSubscriptionMonitor, Looper.myLooper(), sContext, i3, PhoneFactory.sPhones[i3].mDcTracker);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultPhone() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sPhone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$getPhone(int phoneId) {
        String dbgInfo = "";
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            Phone phone = phoneId == Integer.MAX_VALUE ? sPhone : (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount() ? sPhones[phoneId] : null);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Phone[] $$robo$$com_android_internal_telephony_PhoneFactory$getPhones() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sPhones;
        }
    }

    private static final ImsResolver $$robo$$com_android_internal_telephony_PhoneFactory$getImsResolver() {
        return sImsResolver;
    }

    private static final SipPhone $$robo$$com_android_internal_telephony_PhoneFactory$makeSipPhone(String sipUri) {
        return SipPhoneFactory.makePhone(sipUri, sContext, sPhoneNotifier);
    }

    private static final int $$robo$$com_android_internal_telephony_PhoneFactory$calculatePreferredNetworkType(Context context, int phoneSubId) {
        int networkType = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + phoneSubId, RILConstants.PREFERRED_NETWORK_MODE);
        Rlog.d("PhoneFactory", "calculatePreferredNetworkType: phoneSubId = " + phoneSubId + " networkType = " + networkType);
        return networkType;
    }

    private static final int $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultSubscription() {
        return SubscriptionController.getInstance().getDefaultSubId();
    }

    private static final boolean $$robo$$com_android_internal_telephony_PhoneFactory$isSMSPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e("PhoneFactory", "Settings Exception Reading Dual Sim SMS Prompt Values");
        }
        prompt = value != 0;
        Rlog.d("PhoneFactory", "SMS Prompt option:" + prompt);
        return prompt;
    }

    private static final Phone $$robo$$com_android_internal_telephony_PhoneFactory$makeImsPhone(PhoneNotifier phoneNotifier, Phone defaultPhone) {
        return ImsPhoneFactory.makePhone(sContext, phoneNotifier, defaultPhone);
    }

    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$requestEmbeddedSubscriptionInfoListRefresh(Runnable callback) {
        sSubInfoRecordUpdater.requestEmbeddedSubscriptionInfoListRefresh(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$addLocalLog(String key, int size) {
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            if (sLocalLogs.containsKey(key)) {
                throw new IllegalArgumentException("key " + key + " already present");
            }
            sLocalLogs.put(key, new LocalLog(size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$localLog(String key, String log) {
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            if (!sLocalLogs.containsKey(key)) {
                throw new IllegalArgumentException("key " + key + " not found");
            }
            sLocalLogs.get(key).log(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$com_android_internal_telephony_PhoneFactory$dump(FileDescriptor fd, PrintWriter printwriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printwriter, "  ");
        pw.println("PhoneFactory:");
        pw.println(" sMadeDefaults=" + sMadeDefaults);
        sPhoneSwitcher.dump(fd, pw, args);
        pw.println();
        Phone[] phones = PhoneFactory.getPhones();
        for (int i = 0; i < phones.length; ++i) {
            pw.increaseIndent();
            Phone phone = phones[i];
            try {
                phone.dump(fd, pw, args);
            }
            catch (Exception e) {
                pw.println("Telephony DebugService: Could not get Phone[" + i + "] e=" + e);
                continue;
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            sTelephonyNetworkFactories[i].dump(fd, pw, args);
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            try {
                ((IccCardProxy)phone.getIccCard()).dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.decreaseIndent();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        pw.println("SubscriptionMonitor:");
        pw.increaseIndent();
        try {
            sSubscriptionMonitor.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("UiccController:");
        pw.increaseIndent();
        try {
            sUiccController.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        if (sEuiccController != null) {
            pw.println("EuiccController:");
            pw.increaseIndent();
            try {
                sEuiccController.dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.decreaseIndent();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        pw.println("SubscriptionController:");
        pw.increaseIndent();
        try {
            SubscriptionController.getInstance().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("SubInfoRecordUpdater:");
        pw.increaseIndent();
        try {
            sSubInfoRecordUpdater.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("LocalLogs:");
        pw.increaseIndent();
        HashMap<String, LocalLog> e = sLocalLogs;
        synchronized (e) {
            for (String key : sLocalLogs.keySet()) {
                pw.println(key);
                pw.increaseIndent();
                sLocalLogs.get(key).dump(fd, pw, args);
                pw.decreaseIndent();
            }
            pw.flush();
        }
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("SharedPreferences:");
        pw.increaseIndent();
        try {
            if (sContext != null) {
                SharedPreferences sp = PreferenceManager.getDefaultSharedPreferences(sContext);
                Map<String, ?> spValues = sp.getAll();
                for (String key : spValues.keySet()) {
                    pw.println(key + " : " + spValues.get(key));
                }
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        pw.flush();
        pw.decreaseIndent();
    }

    static void __staticInitializer__() {
        sLockProxyPhones = new Object();
        sPhones = null;
        sPhone = null;
        sCommandsInterfaces = null;
        sCommandsInterface = null;
        sSubInfoRecordUpdater = null;
        sMadeDefaults = false;
        sLocalLogs = new HashMap();
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_PhoneFactory$__constructor__();
    }

    public PhoneFactory() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneFactory$__constructor__(), 0, this);
    }

    public static void makeDefaultPhones(Context context) {
        InvokeDynamicSupport.bootstrapStatic("makeDefaultPhones", $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhones(android.content.Context ), 0, (Context)context);
    }

    public static void makeDefaultPhone(Context context) {
        InvokeDynamicSupport.bootstrapStatic("makeDefaultPhone", $$robo$$com_android_internal_telephony_PhoneFactory$makeDefaultPhone(android.content.Context ), 0, (Context)context);
    }

    public static Phone getDefaultPhone() {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultPhone(), 0);
    }

    public static Phone getPhone(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPhone", $$robo$$com_android_internal_telephony_PhoneFactory$getPhone(int ), 0, (int)n);
    }

    public static Phone[] getPhones() {
        return InvokeDynamicSupport.bootstrapStatic("getPhones", $$robo$$com_android_internal_telephony_PhoneFactory$getPhones(), 0);
    }

    public static ImsResolver getImsResolver() {
        return InvokeDynamicSupport.bootstrapStatic("getImsResolver", $$robo$$com_android_internal_telephony_PhoneFactory$getImsResolver(), 0);
    }

    public static SipPhone makeSipPhone(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeSipPhone", $$robo$$com_android_internal_telephony_PhoneFactory$makeSipPhone(java.lang.String ), 0, (String)string2);
    }

    public static int calculatePreferredNetworkType(Context context, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("calculatePreferredNetworkType", $$robo$$com_android_internal_telephony_PhoneFactory$calculatePreferredNetworkType(android.content.Context int ), 0, (Context)context, (int)n);
    }

    public static int getDefaultSubscription() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultSubscription", $$robo$$com_android_internal_telephony_PhoneFactory$getDefaultSubscription(), 0);
    }

    public static boolean isSMSPromptEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isSMSPromptEnabled", $$robo$$com_android_internal_telephony_PhoneFactory$isSMSPromptEnabled(), 0);
    }

    public static Phone makeImsPhone(PhoneNotifier phoneNotifier, Phone phone) {
        return InvokeDynamicSupport.bootstrapStatic("makeImsPhone", $$robo$$com_android_internal_telephony_PhoneFactory$makeImsPhone(com.android.internal.telephony.PhoneNotifier com.android.internal.telephony.Phone ), 0, (PhoneNotifier)phoneNotifier, (Phone)phone);
    }

    public static void requestEmbeddedSubscriptionInfoListRefresh(Runnable runnable) {
        InvokeDynamicSupport.bootstrapStatic("requestEmbeddedSubscriptionInfoListRefresh", $$robo$$com_android_internal_telephony_PhoneFactory$requestEmbeddedSubscriptionInfoListRefresh(java.lang.Runnable ), 0, (Runnable)runnable);
    }

    public static void addLocalLog(String string2, int n) {
        InvokeDynamicSupport.bootstrapStatic("addLocalLog", $$robo$$com_android_internal_telephony_PhoneFactory$addLocalLog(java.lang.String int ), 0, (String)string2, (int)n);
    }

    public static void localLog(String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("localLog", $$robo$$com_android_internal_telephony_PhoneFactory$localLog(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrapStatic("dump", $$robo$$com_android_internal_telephony_PhoneFactory$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, (FileDescriptor)fileDescriptor, (PrintWriter)printWriter, (String[])stringArray);
    }

    static {
        RobolectricInternals.classInitializing(PhoneFactory.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

