/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.MatchAllNetworkSpecifier;
import android.net.NetworkCapabilities;
import android.net.NetworkFactory;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.StringNetworkSpecifier;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.os.RemoteException;
import android.telephony.Rlog;
import android.util.LocalLog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.dataconnection.DcRequest;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PhoneSwitcher
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PhoneSwitcher";
    private static boolean VDBG = false;
    private int mMaxActivePhones;
    private List<DcRequest> mPrioritizedDcRequests;
    private RegistrantList[] mActivePhoneRegistrants;
    private SubscriptionController mSubscriptionController;
    private int[] mPhoneSubscriptions;
    private CommandsInterface[] mCommandsInterfaces;
    private Context mContext;
    private PhoneState[] mPhoneStates;
    private int mNumPhones;
    private Phone[] mPhones;
    private LocalLog mLocalLog;
    private int mDefaultDataSubscription;
    private static int EVENT_DEFAULT_SUBSCRIPTION_CHANGED = 101;
    private static int EVENT_SUBSCRIPTION_CHANGED = 102;
    private static int EVENT_REQUEST_NETWORK = 103;
    private static int EVENT_RELEASE_NETWORK = 104;
    private static int EVENT_EMERGENCY_TOGGLE = 105;
    private static int EVENT_RESEND_DATA_ALLOWED = 106;
    private static int MAX_LOCAL_LOG_LINES = 30;
    private BroadcastReceiver mDefaultDataChangedReceiver;
    private IOnSubscriptionsChangedListener mSubscriptionsChangedListener;
    private static boolean REQUESTS_CHANGED = true;
    private static boolean REQUESTS_UNCHANGED = false;

    private void $$robo$$com_android_internal_telephony_PhoneSwitcher$__constructor__(Looper looper) {
        this.mPrioritizedDcRequests = new ArrayList<DcRequest>();
        this.mDefaultDataChangedReceiver = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PhoneSwitcher this$0;

            private void $$robo$$com_android_internal_telephony_PhoneSwitcher_1$__constructor__(PhoneSwitcher this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_PhoneSwitcher_1$onReceive(Context context, Intent intent) {
                Message msg = this.this$0.obtainMessage(101);
                msg.sendToTarget();
            }

            private void __constructor__(PhoneSwitcher phoneSwitcher) {
                this.$$robo$$com_android_internal_telephony_PhoneSwitcher_1$__constructor__(phoneSwitcher);
            }
            {
                this.this$0 = phoneSwitcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneSwitcher_1$__constructor__(com.android.internal.telephony.PhoneSwitcher ), 0, this, phoneSwitcher);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$com_android_internal_telephony_PhoneSwitcher_1$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSubscriptionsChangedListener = new ShadowedObject(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ PhoneSwitcher this$0;

            private void $$robo$$com_android_internal_telephony_PhoneSwitcher_2$__constructor__(PhoneSwitcher this$0) {
            }

            private final void $$robo$$com_android_internal_telephony_PhoneSwitcher_2$onSubscriptionsChanged() {
                Message msg = this.this$0.obtainMessage(102);
                msg.sendToTarget();
            }

            private void __constructor__(PhoneSwitcher phoneSwitcher) {
                this.$$robo$$com_android_internal_telephony_PhoneSwitcher_2$__constructor__(phoneSwitcher);
            }
            {
                this.this$0 = phoneSwitcher;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneSwitcher_2$__constructor__(com.android.internal.telephony.PhoneSwitcher ), 0, this, phoneSwitcher);
            }

            @Override
            public void onSubscriptionsChanged() {
                InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$com_android_internal_telephony_PhoneSwitcher_2$onSubscriptionsChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mMaxActivePhones = 0;
        this.mSubscriptionController = null;
        this.mPhoneSubscriptions = null;
        this.mCommandsInterfaces = null;
        this.mContext = null;
        this.mPhoneStates = null;
        this.mPhones = null;
        this.mLocalLog = null;
        this.mActivePhoneRegistrants = null;
        this.mNumPhones = 0;
    }

    private void $$robo$$com_android_internal_telephony_PhoneSwitcher$__constructor__(int maxActivePhones, int numPhones, Context context, SubscriptionController subscriptionController, Looper looper, ITelephonyRegistry tr, CommandsInterface[] cis, Phone[] phones) {
        this.mPrioritizedDcRequests = new ArrayList<DcRequest>();
        this.mDefaultDataChangedReceiver = new /* invalid duplicate definition of identical inner class */;
        this.mSubscriptionsChangedListener = new /* invalid duplicate definition of identical inner class */;
        this.mContext = context;
        this.mNumPhones = numPhones;
        this.mPhones = phones;
        this.mPhoneSubscriptions = new int[numPhones];
        this.mMaxActivePhones = maxActivePhones;
        this.mLocalLog = new LocalLog(30);
        this.mSubscriptionController = subscriptionController;
        this.mActivePhoneRegistrants = new RegistrantList[numPhones];
        this.mPhoneStates = new PhoneState[numPhones];
        for (int i = 0; i < numPhones; ++i) {
            this.mActivePhoneRegistrants[i] = new RegistrantList();
            this.mPhoneStates[i] = new PhoneState();
            if (this.mPhones[i] == null) continue;
            this.mPhones[i].registerForEmergencyCallToggle(this, 105, null);
        }
        this.mCommandsInterfaces = cis;
        try {
            tr.addOnSubscriptionsChangedListener("PhoneSwitcher", this.mSubscriptionsChangedListener);
        }
        catch (RemoteException i) {
            // empty catch block
        }
        this.mContext.registerReceiver(this.mDefaultDataChangedReceiver, new IntentFilter("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED"));
        NetworkCapabilities netCap = new NetworkCapabilities();
        netCap.addTransportType(0);
        netCap.addCapability(0);
        netCap.addCapability(1);
        netCap.addCapability(2);
        netCap.addCapability(3);
        netCap.addCapability(4);
        netCap.addCapability(5);
        netCap.addCapability(7);
        netCap.addCapability(8);
        netCap.addCapability(9);
        netCap.addCapability(10);
        netCap.addCapability(13);
        netCap.addCapability(12);
        netCap.setNetworkSpecifier(new MatchAllNetworkSpecifier());
        PhoneSwitcherNetworkRequestListener networkFactory = new PhoneSwitcherNetworkRequestListener(looper, context, netCap, this);
        networkFactory.setScoreFilter(101);
        networkFactory.register();
        this.log("PhoneSwitcher started");
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$handleMessage(Message msg) {
        switch (msg.what) {
            case 102: {
                this.onEvaluate(false, "subChanged");
                break;
            }
            case 101: {
                this.onEvaluate(false, "defaultChanged");
                break;
            }
            case 103: {
                this.onRequestNetwork((NetworkRequest)msg.obj);
                break;
            }
            case 104: {
                this.onReleaseNetwork((NetworkRequest)msg.obj);
                break;
            }
            case 105: {
                this.onEvaluate(true, "emergencyToggle");
                break;
            }
            case 106: {
                this.onResendDataAllowed(msg);
            }
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneSwitcher$isEmergency() {
        for (Phone p : this.mPhones) {
            if (p == null || !p.isInEcm() && !p.isInEmergencyCall()) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$onRequestNetwork(NetworkRequest networkRequest) {
        DcRequest dcRequest = new DcRequest(networkRequest, this.mContext);
        if (!this.mPrioritizedDcRequests.contains(dcRequest)) {
            this.mPrioritizedDcRequests.add(dcRequest);
            Collections.sort(this.mPrioritizedDcRequests);
            this.onEvaluate(true, "netRequest");
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$onReleaseNetwork(NetworkRequest networkRequest) {
        DcRequest dcRequest = new DcRequest(networkRequest, this.mContext);
        if (this.mPrioritizedDcRequests.remove(dcRequest)) {
            this.onEvaluate(true, "netReleased");
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$onEvaluate(boolean requestsChanged, String reason) {
        StringBuilder sb = new StringBuilder(reason);
        if (this.isEmergency()) {
            this.log("onEvalute aborted due to Emergency");
            return;
        }
        boolean diffDetected = requestsChanged;
        int dataSub = this.mSubscriptionController.getDefaultDataSubId();
        if (dataSub != this.mDefaultDataSubscription) {
            sb.append(" default ").append(this.mDefaultDataSubscription).append("->").append(dataSub);
            this.mDefaultDataSubscription = dataSub;
            diffDetected = true;
        }
        for (int i = 0; i < this.mNumPhones; ++i) {
            int sub = this.mSubscriptionController.getSubIdUsingPhoneId(i);
            if (sub == this.mPhoneSubscriptions[i]) continue;
            sb.append(" phone[").append(i).append("] ").append(this.mPhoneSubscriptions[i]);
            sb.append("->").append(sub);
            this.mPhoneSubscriptions[i] = sub;
            diffDetected = true;
        }
        if (diffDetected) {
            this.log("evaluating due to " + sb.toString());
            ArrayList<Integer> newActivePhones = new ArrayList<Integer>();
            for (DcRequest dcRequest : this.mPrioritizedDcRequests) {
                int phoneIdForRequest = this.phoneIdForRequest(dcRequest.networkRequest);
                if (phoneIdForRequest == -1 || newActivePhones.contains(phoneIdForRequest)) continue;
                newActivePhones.add(phoneIdForRequest);
                if (newActivePhones.size() < this.mMaxActivePhones) continue;
                break;
            }
            for (int phoneId = 0; phoneId < this.mNumPhones; ++phoneId) {
                if (newActivePhones.contains(phoneId)) continue;
                this.deactivate(phoneId);
            }
            Iterator iterator = newActivePhones.iterator();
            while (iterator.hasNext()) {
                int phoneId = (Integer)iterator.next();
                this.activate(phoneId);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$deactivate(int phoneId) {
        PhoneState state = this.mPhoneStates[phoneId];
        if (!state.active) {
            return;
        }
        state.active = false;
        this.log("deactivate " + phoneId);
        state.lastRequested = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.mNumPhones > 1) {
            this.mCommandsInterfaces[phoneId].setDataAllowed(false, null);
        }
        this.mActivePhoneRegistrants[phoneId].notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$activate(int phoneId) {
        PhoneState state = this.mPhoneStates[phoneId];
        if (state.active) {
            return;
        }
        state.active = true;
        this.log("activate " + phoneId);
        state.lastRequested = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        if (this.mNumPhones > 1) {
            this.mCommandsInterfaces[phoneId].setDataAllowed(true, null);
        }
        this.mActivePhoneRegistrants[phoneId].notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$resendDataAllowed(int phoneId) {
        this.validatePhoneId(phoneId);
        Message msg = this.obtainMessage(106);
        msg.arg1 = phoneId;
        msg.sendToTarget();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$onResendDataAllowed(Message msg) {
        int phoneId = msg.arg1;
        if (this.mNumPhones > 1) {
            this.mCommandsInterfaces[phoneId].setDataAllowed(this.mPhoneStates[phoneId].active, null);
        }
    }

    private final int $$robo$$com_android_internal_telephony_PhoneSwitcher$phoneIdForRequest(NetworkRequest netRequest) {
        int subId;
        NetworkSpecifier specifier = netRequest.networkCapabilities.getNetworkSpecifier();
        if (specifier == null) {
            subId = this.mDefaultDataSubscription;
        } else if (specifier instanceof StringNetworkSpecifier) {
            try {
                subId = Integer.parseInt(((StringNetworkSpecifier)specifier).specifier);
            }
            catch (NumberFormatException e) {
                Rlog.e("PhoneSwitcher", "NumberFormatException on " + ((StringNetworkSpecifier)specifier).specifier);
                subId = -1;
            }
        } else {
            subId = -1;
        }
        int phoneId = -1;
        if (subId == -1) {
            return phoneId;
        }
        for (int i = 0; i < this.mNumPhones; ++i) {
            if (this.mPhoneSubscriptions[i] != subId) continue;
            phoneId = i;
            break;
        }
        return phoneId;
    }

    private final boolean $$robo$$com_android_internal_telephony_PhoneSwitcher$isPhoneActive(int phoneId) {
        this.validatePhoneId(phoneId);
        return this.mPhoneStates[phoneId].active;
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$registerForActivePhoneSwitch(int phoneId, Handler h, int what, Object o) {
        this.validatePhoneId(phoneId);
        Registrant r = new Registrant(h, what, o);
        this.mActivePhoneRegistrants[phoneId].add(r);
        r.notifyRegistrant();
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$unregisterForActivePhoneSwitch(int phoneId, Handler h) {
        this.validatePhoneId(phoneId);
        this.mActivePhoneRegistrants[phoneId].remove(h);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$validatePhoneId(int phoneId) {
        if (phoneId < 0 || phoneId >= this.mNumPhones) {
            throw new IllegalArgumentException("Invalid PhoneId");
        }
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$log(String l) {
        Rlog.d("PhoneSwitcher", l);
        this.mLocalLog.log(l);
    }

    private final void $$robo$$com_android_internal_telephony_PhoneSwitcher$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)writer, "  ");
        pw.println("PhoneSwitcher:");
        Calendar c = Calendar.getInstance();
        for (int i = 0; i < this.mNumPhones; ++i) {
            PhoneState ps = this.mPhoneStates[i];
            c.setTimeInMillis(ps.lastRequested);
            pw.println("PhoneId(" + i + ") active=" + ps.active + ", lastRequest=" + (ps.lastRequested == 0L ? "never" : String.format("%tm-%td %tH:%tM:%tS.%tL", c, c, c, c, c, c)));
        }
        pw.increaseIndent();
        this.mLocalLog.dump(fd, pw, args);
        pw.decreaseIndent();
    }

    private void __constructor__(Looper looper) {
        this.$$robo$$com_android_internal_telephony_PhoneSwitcher$__constructor__(looper);
    }

    public PhoneSwitcher(Looper looper) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneSwitcher$__constructor__(android.os.Looper ), 0, this, looper);
    }

    private void __constructor__(int n, int n2, Context context, SubscriptionController subscriptionController, Looper looper, ITelephonyRegistry iTelephonyRegistry, CommandsInterface[] commandsInterfaceArray, Phone[] phoneArray) {
        this.$$robo$$com_android_internal_telephony_PhoneSwitcher$__constructor__(n, n2, context, subscriptionController, looper, iTelephonyRegistry, commandsInterfaceArray, phoneArray);
    }

    public PhoneSwitcher(int n, int n2, Context context, SubscriptionController subscriptionController, Looper looper, ITelephonyRegistry iTelephonyRegistry, CommandsInterface[] commandsInterfaceArray, Phone[] phoneArray) {
        super(looper);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneSwitcher$__constructor__(int int android.content.Context com.android.internal.telephony.SubscriptionController android.os.Looper com.android.internal.telephony.ITelephonyRegistry com.android.internal.telephony.CommandsInterface[] com.android.internal.telephony.Phone[] ), 0, this, n, n2, context, subscriptionController, looper, iTelephonyRegistry, commandsInterfaceArray, phoneArray);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_PhoneSwitcher$handleMessage(android.os.Message ), 0, this, message);
    }

    private boolean isEmergency() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmergency", $$robo$$com_android_internal_telephony_PhoneSwitcher$isEmergency(), 0, this);
    }

    private void onRequestNetwork(NetworkRequest networkRequest) {
        InvokeDynamicSupport.bootstrap("onRequestNetwork", $$robo$$com_android_internal_telephony_PhoneSwitcher$onRequestNetwork(android.net.NetworkRequest ), 0, this, networkRequest);
    }

    private void onReleaseNetwork(NetworkRequest networkRequest) {
        InvokeDynamicSupport.bootstrap("onReleaseNetwork", $$robo$$com_android_internal_telephony_PhoneSwitcher$onReleaseNetwork(android.net.NetworkRequest ), 0, this, networkRequest);
    }

    private void onEvaluate(boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("onEvaluate", $$robo$$com_android_internal_telephony_PhoneSwitcher$onEvaluate(boolean java.lang.String ), 0, this, bl, string2);
    }

    private void deactivate(int n) {
        InvokeDynamicSupport.bootstrap("deactivate", $$robo$$com_android_internal_telephony_PhoneSwitcher$deactivate(int ), 0, this, n);
    }

    private void activate(int n) {
        InvokeDynamicSupport.bootstrap("activate", $$robo$$com_android_internal_telephony_PhoneSwitcher$activate(int ), 0, this, n);
    }

    public void resendDataAllowed(int n) {
        InvokeDynamicSupport.bootstrap("resendDataAllowed", $$robo$$com_android_internal_telephony_PhoneSwitcher$resendDataAllowed(int ), 0, this, n);
    }

    private void onResendDataAllowed(Message message) {
        InvokeDynamicSupport.bootstrap("onResendDataAllowed", $$robo$$com_android_internal_telephony_PhoneSwitcher$onResendDataAllowed(android.os.Message ), 0, this, message);
    }

    private int phoneIdForRequest(NetworkRequest networkRequest) {
        return (int)InvokeDynamicSupport.bootstrap("phoneIdForRequest", $$robo$$com_android_internal_telephony_PhoneSwitcher$phoneIdForRequest(android.net.NetworkRequest ), 0, this, networkRequest);
    }

    public boolean isPhoneActive(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPhoneActive", $$robo$$com_android_internal_telephony_PhoneSwitcher$isPhoneActive(int ), 0, this, n);
    }

    public void registerForActivePhoneSwitch(int n, Handler handler, int n2, Object object) {
        InvokeDynamicSupport.bootstrap("registerForActivePhoneSwitch", $$robo$$com_android_internal_telephony_PhoneSwitcher$registerForActivePhoneSwitch(int android.os.Handler int java.lang.Object ), 0, this, n, handler, n2, object);
    }

    public void unregisterForActivePhoneSwitch(int n, Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForActivePhoneSwitch", $$robo$$com_android_internal_telephony_PhoneSwitcher$unregisterForActivePhoneSwitch(int android.os.Handler ), 0, this, n, handler);
    }

    private void validatePhoneId(int n) {
        InvokeDynamicSupport.bootstrap("validatePhoneId", $$robo$$com_android_internal_telephony_PhoneSwitcher$validatePhoneId(int ), 0, this, n);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_PhoneSwitcher$log(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_PhoneSwitcher$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ PhoneSwitcher() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneSwitcher)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PhoneState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public volatile boolean active;
        public long lastRequested;

        private void $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneState$__constructor__() {
            this.active = false;
            this.lastRequested = 0L;
        }

        private /* synthetic */ void $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneState$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneState$__constructor__();
        }

        private PhoneState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneState$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneState$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class PhoneSwitcherNetworkRequestListener
    extends NetworkFactory
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PhoneSwitcher mPhoneSwitcher;

        private void $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneSwitcherNetworkRequestListener$__constructor__(Looper l, Context c, NetworkCapabilities nc, PhoneSwitcher ps) {
            this.mPhoneSwitcher = ps;
        }

        private final void $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneSwitcherNetworkRequestListener$needNetworkFor(NetworkRequest networkRequest, int score) {
            Message msg = this.mPhoneSwitcher.obtainMessage(103);
            msg.obj = networkRequest;
            msg.sendToTarget();
        }

        private final void $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneSwitcherNetworkRequestListener$releaseNetworkFor(NetworkRequest networkRequest) {
            Message msg = this.mPhoneSwitcher.obtainMessage(104);
            msg.obj = networkRequest;
            msg.sendToTarget();
        }

        private void __constructor__(Looper looper, Context context, NetworkCapabilities networkCapabilities, PhoneSwitcher phoneSwitcher) {
            this.$$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneSwitcherNetworkRequestListener$__constructor__(looper, context, networkCapabilities, phoneSwitcher);
        }

        public PhoneSwitcherNetworkRequestListener(Looper looper, Context context, NetworkCapabilities networkCapabilities, PhoneSwitcher phoneSwitcher) {
            super(looper, context, "PhoneSwitcherNetworkRequstListener", networkCapabilities);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneSwitcherNetworkRequestListener$__constructor__(android.os.Looper android.content.Context android.net.NetworkCapabilities com.android.internal.telephony.PhoneSwitcher ), 0, this, looper, context, networkCapabilities, phoneSwitcher);
        }

        @Override
        protected void needNetworkFor(NetworkRequest networkRequest, int n) {
            InvokeDynamicSupport.bootstrap("needNetworkFor", $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneSwitcherNetworkRequestListener$needNetworkFor(android.net.NetworkRequest int ), 0, this, networkRequest, n);
        }

        @Override
        protected void releaseNetworkFor(NetworkRequest networkRequest) {
            InvokeDynamicSupport.bootstrap("releaseNetworkFor", $$robo$$com_android_internal_telephony_PhoneSwitcher_PhoneSwitcherNetworkRequestListener$releaseNetworkFor(android.net.NetworkRequest ), 0, this, networkRequest);
        }

        public /* synthetic */ PhoneSwitcherNetworkRequestListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PhoneSwitcherNetworkRequestListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

