/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.util.Xml;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.cdma.EriInfo;
import com.android.internal.util.XmlUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class EriManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "EriManager";
    private static boolean DBG = true;
    private static boolean VDBG = false;
    public static int ERI_FROM_XML = 0;
    static int ERI_FROM_FILE_SYSTEM = 1;
    static int ERI_FROM_MODEM = 2;
    private Context mContext;
    private int mEriFileSource;
    private boolean mIsEriFileLoaded;
    private EriFile mEriFile;
    private Phone mPhone;

    private void $$robo$$com_android_internal_telephony_cdma_EriManager$__constructor__(Phone phone, Context context, int eriFileSource) {
        this.mEriFileSource = 0;
        this.mPhone = phone;
        this.mContext = context;
        this.mEriFileSource = eriFileSource;
        this.mEriFile = new EriFile(this);
    }

    private final void $$robo$$com_android_internal_telephony_cdma_EriManager$dispose() {
        this.mEriFile = new EriFile(this);
        this.mIsEriFileLoaded = false;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFile() {
        switch (this.mEriFileSource) {
            case 2: {
                this.loadEriFileFromModem();
                break;
            }
            case 1: {
                this.loadEriFileFromFileSystem();
                break;
            }
            default: {
                this.loadEriFileFromXml();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFileFromModem() {
    }

    private final void $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFileFromFileSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFileFromXml() {
        XmlPullParser parser = null;
        FileInputStream stream = null;
        Resources r = this.mContext.getResources();
        try {
            Rlog.d("EriManager", "loadEriFileFromXml: check for alternate file");
            stream = new FileInputStream(r.getString(17039464));
            parser = Xml.newPullParser();
            parser.setInput(stream, null);
            Rlog.d("EriManager", "loadEriFileFromXml: opened alternate file");
        }
        catch (FileNotFoundException e) {
            Rlog.d("EriManager", "loadEriFileFromXml: no alternate file");
            parser = null;
        }
        catch (XmlPullParserException e) {
            Rlog.d("EriManager", "loadEriFileFromXml: no parser for alternate file");
            parser = null;
        }
        if (parser == null) {
            PersistableBundle b;
            String eriFile = null;
            CarrierConfigManager configManager = (CarrierConfigManager)this.mContext.getSystemService("carrier_config");
            if (configManager != null && (b = configManager.getConfigForSubId(this.mPhone.getSubId())) != null) {
                eriFile = b.getString("carrier_eri_file_name_string");
            }
            Rlog.d("EriManager", "eriFile = " + eriFile);
            if (eriFile == null) {
                Rlog.e("EriManager", "loadEriFileFromXml: Can't find ERI file to load");
                return;
            }
            try {
                parser = Xml.newPullParser();
                parser.setInput(this.mContext.getAssets().open(eriFile), null);
            }
            catch (IOException | XmlPullParserException e) {
                Rlog.e("EriManager", "loadEriFileFromXml: no parser for " + eriFile + ". Exception = " + e.toString());
            }
        }
        try {
            XmlUtils.beginDocument(parser, "EriFile");
            this.mEriFile.mVersionNumber = Integer.parseInt(parser.getAttributeValue(null, "VersionNumber"));
            this.mEriFile.mNumberOfEriEntries = Integer.parseInt(parser.getAttributeValue(null, "NumberOfEriEntries"));
            this.mEriFile.mEriFileType = Integer.parseInt(parser.getAttributeValue(null, "EriFileType"));
            int parsedEriEntries = 0;
            while (true) {
                XmlUtils.nextElement(parser);
                String name = parser.getName();
                if (name == null) {
                    if (parsedEriEntries == this.mEriFile.mNumberOfEriEntries) break;
                    Rlog.e("EriManager", "Error Parsing ERI file: " + this.mEriFile.mNumberOfEriEntries + " defined, " + parsedEriEntries + " parsed!");
                    break;
                }
                if (name.equals("CallPromptId")) {
                    int id2 = Integer.parseInt(parser.getAttributeValue(null, "Id"));
                    String text = parser.getAttributeValue(null, "CallPromptText");
                    if (id2 >= 0 && id2 <= 2) {
                        this.mEriFile.mCallPromptId[id2] = text;
                        continue;
                    }
                    Rlog.e("EriManager", "Error Parsing ERI file: found" + id2 + " CallPromptId");
                    continue;
                }
                if (!name.equals("EriInfo")) continue;
                int roamingIndicator = Integer.parseInt(parser.getAttributeValue(null, "RoamingIndicator"));
                int iconIndex = Integer.parseInt(parser.getAttributeValue(null, "IconIndex"));
                int iconMode = Integer.parseInt(parser.getAttributeValue(null, "IconMode"));
                String eriText = parser.getAttributeValue(null, "EriText");
                int callPromptId = Integer.parseInt(parser.getAttributeValue(null, "CallPromptId"));
                int alertId = Integer.parseInt(parser.getAttributeValue(null, "AlertId"));
                ++parsedEriEntries;
                this.mEriFile.mRoamIndTable.put(roamingIndicator, new EriInfo(roamingIndicator, iconIndex, iconMode, eriText, callPromptId, alertId));
            }
            Rlog.d("EriManager", "loadEriFileFromXml: eri parsing successful, file loaded. ver = " + this.mEriFile.mVersionNumber + ", # of entries = " + this.mEriFile.mNumberOfEriEntries);
            this.mIsEriFileLoaded = true;
        }
        catch (Exception e) {
            Rlog.e("EriManager", "Got exception while loading ERI file.", e);
        }
        finally {
            if (parser instanceof XmlResourceParser) {
                ((XmlResourceParser)parser).close();
            }
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private final int $$robo$$com_android_internal_telephony_cdma_EriManager$getEriFileVersion() {
        return this.mEriFile.mVersionNumber;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_EriManager$getEriNumberOfEntries() {
        return this.mEriFile.mNumberOfEriEntries;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_EriManager$getEriFileType() {
        return this.mEriFile.mEriFileType;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_EriManager$isEriFileLoaded() {
        return this.mIsEriFileLoaded;
    }

    private final EriInfo $$robo$$com_android_internal_telephony_cdma_EriManager$getEriInfo(int roamingIndicator) {
        if (this.mEriFile.mRoamIndTable.containsKey(roamingIndicator)) {
            return this.mEriFile.mRoamIndTable.get(roamingIndicator);
        }
        return null;
    }

    private final EriDisplayInformation $$robo$$com_android_internal_telephony_cdma_EriManager$getEriDisplayInformation(int roamInd, int defRoamInd) {
        EriDisplayInformation ret;
        EriInfo eriInfo;
        if (this.mIsEriFileLoaded && (eriInfo = this.getEriInfo(roamInd)) != null) {
            EriDisplayInformation ret2 = new EriDisplayInformation(this, eriInfo.iconIndex, eriInfo.iconMode, eriInfo.eriText);
            return ret2;
        }
        block0 : switch (roamInd) {
            case 0: {
                ret = new EriDisplayInformation(this, 0, 0, this.mContext.getText(17040696).toString());
                break;
            }
            case 1: {
                ret = new EriDisplayInformation(this, 1, 0, this.mContext.getText(17040697).toString());
                break;
            }
            case 2: {
                ret = new EriDisplayInformation(this, 2, 1, this.mContext.getText(17040701).toString());
                break;
            }
            case 3: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040702).toString());
                break;
            }
            case 4: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040703).toString());
                break;
            }
            case 5: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040704).toString());
                break;
            }
            case 6: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040705).toString());
                break;
            }
            case 7: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040706).toString());
                break;
            }
            case 8: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040707).toString());
                break;
            }
            case 9: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040708).toString());
                break;
            }
            case 10: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040698).toString());
                break;
            }
            case 11: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040699).toString());
                break;
            }
            case 12: {
                ret = new EriDisplayInformation(this, roamInd, 0, this.mContext.getText(17040700).toString());
                break;
            }
            default: {
                if (!this.mIsEriFileLoaded) {
                    Rlog.d("EriManager", "ERI File not loaded");
                    if (defRoamInd > 2) {
                        ret = new EriDisplayInformation(this, 2, 1, this.mContext.getText(17040701).toString());
                        break;
                    }
                    switch (defRoamInd) {
                        case 0: {
                            ret = new EriDisplayInformation(this, 0, 0, this.mContext.getText(17040696).toString());
                            break block0;
                        }
                        case 1: {
                            ret = new EriDisplayInformation(this, 1, 0, this.mContext.getText(17040697).toString());
                            break block0;
                        }
                        case 2: {
                            ret = new EriDisplayInformation(this, 2, 1, this.mContext.getText(17040701).toString());
                            break block0;
                        }
                    }
                    ret = new EriDisplayInformation(this, -1, -1, "ERI text");
                    break;
                }
                eriInfo = this.getEriInfo(roamInd);
                EriInfo defEriInfo = this.getEriInfo(defRoamInd);
                if (eriInfo == null) {
                    if (defEriInfo == null) {
                        Rlog.e("EriManager", "ERI defRoamInd " + defRoamInd + " not found in ERI file ...on");
                        ret = new EriDisplayInformation(this, 0, 0, this.mContext.getText(17040696).toString());
                        break;
                    }
                    ret = new EriDisplayInformation(this, defEriInfo.iconIndex, defEriInfo.iconMode, defEriInfo.eriText);
                    break;
                }
                ret = new EriDisplayInformation(this, eriInfo.iconIndex, eriInfo.iconMode, eriInfo.eriText);
            }
        }
        return ret;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_EriManager$getCdmaEriIconIndex(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconIndex;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_EriManager$getCdmaEriIconMode(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconMode;
    }

    private final String $$robo$$com_android_internal_telephony_cdma_EriManager$getCdmaEriText(int roamInd, int defRoamInd) {
        return this.getEriDisplayInformation((int)roamInd, (int)defRoamInd).mEriIconText;
    }

    private void __constructor__(Phone phone, Context context, int n) {
        this.$$robo$$com_android_internal_telephony_cdma_EriManager$__constructor__(phone, context, n);
    }

    public EriManager(Phone phone, Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_EriManager$__constructor__(com.android.internal.telephony.Phone android.content.Context int ), 0, this, phone, context, n);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_cdma_EriManager$dispose(), 0, this);
    }

    public void loadEriFile() {
        InvokeDynamicSupport.bootstrap("loadEriFile", $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFile(), 0, this);
    }

    private void loadEriFileFromModem() {
        InvokeDynamicSupport.bootstrap("loadEriFileFromModem", $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFileFromModem(), 0, this);
    }

    private void loadEriFileFromFileSystem() {
        InvokeDynamicSupport.bootstrap("loadEriFileFromFileSystem", $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFileFromFileSystem(), 0, this);
    }

    private void loadEriFileFromXml() {
        InvokeDynamicSupport.bootstrap("loadEriFileFromXml", $$robo$$com_android_internal_telephony_cdma_EriManager$loadEriFileFromXml(), 0, this);
    }

    public int getEriFileVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getEriFileVersion", $$robo$$com_android_internal_telephony_cdma_EriManager$getEriFileVersion(), 0, this);
    }

    public int getEriNumberOfEntries() {
        return (int)InvokeDynamicSupport.bootstrap("getEriNumberOfEntries", $$robo$$com_android_internal_telephony_cdma_EriManager$getEriNumberOfEntries(), 0, this);
    }

    public int getEriFileType() {
        return (int)InvokeDynamicSupport.bootstrap("getEriFileType", $$robo$$com_android_internal_telephony_cdma_EriManager$getEriFileType(), 0, this);
    }

    public boolean isEriFileLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEriFileLoaded", $$robo$$com_android_internal_telephony_cdma_EriManager$isEriFileLoaded(), 0, this);
    }

    private EriInfo getEriInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getEriInfo", $$robo$$com_android_internal_telephony_cdma_EriManager$getEriInfo(int ), 0, this, n);
    }

    private EriDisplayInformation getEriDisplayInformation(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getEriDisplayInformation", $$robo$$com_android_internal_telephony_cdma_EriManager$getEriDisplayInformation(int int ), 0, this, n, n2);
    }

    public int getCdmaEriIconIndex(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$com_android_internal_telephony_cdma_EriManager$getCdmaEriIconIndex(int int ), 0, this, n, n2);
    }

    public int getCdmaEriIconMode(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$com_android_internal_telephony_cdma_EriManager$getCdmaEriIconMode(int int ), 0, this, n, n2);
    }

    public String getCdmaEriText(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$com_android_internal_telephony_cdma_EriManager$getCdmaEriText(int int ), 0, this, n, n2);
    }

    public /* synthetic */ EriManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EriManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class EriDisplayInformation
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mEriIconIndex;
        int mEriIconMode;
        String mEriIconText;
        /* synthetic */ EriManager this$0;

        private void $$robo$$com_android_internal_telephony_cdma_EriManager_EriDisplayInformation$__constructor__(EriManager this$0, int eriIconIndex, int eriIconMode, String eriIconText) {
            this.mEriIconIndex = eriIconIndex;
            this.mEriIconMode = eriIconMode;
            this.mEriIconText = eriIconText;
        }

        private final String $$robo$$com_android_internal_telephony_cdma_EriManager_EriDisplayInformation$toString() {
            return "EriDisplayInformation: { IconIndex: " + this.mEriIconIndex + " EriIconMode: " + this.mEriIconMode + " EriIconText: " + this.mEriIconText + " }";
        }

        private void __constructor__(EriManager eriManager, int n, int n2, String string2) {
            this.$$robo$$com_android_internal_telephony_cdma_EriManager_EriDisplayInformation$__constructor__(eriManager, n, n2, string2);
        }

        EriDisplayInformation(EriManager eriManager, int n, int n2, String string2) {
            this.this$0 = eriManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_EriManager_EriDisplayInformation$__constructor__(com.android.internal.telephony.cdma.EriManager int int java.lang.String ), 0, this, eriManager, n, n2, string2);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_telephony_cdma_EriManager_EriDisplayInformation$toString(), 0, this);
        }

        public /* synthetic */ EriDisplayInformation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EriDisplayInformation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class EriFile
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mVersionNumber;
        int mNumberOfEriEntries;
        int mEriFileType;
        String[] mCallPromptId;
        HashMap<Integer, EriInfo> mRoamIndTable;
        /* synthetic */ EriManager this$0;

        private void $$robo$$com_android_internal_telephony_cdma_EriManager_EriFile$__constructor__(EriManager this$0) {
            this.mVersionNumber = -1;
            this.mNumberOfEriEntries = 0;
            this.mEriFileType = -1;
            this.mCallPromptId = new String[]{"", "", ""};
            this.mRoamIndTable = new HashMap();
        }

        private void __constructor__(EriManager eriManager) {
            this.$$robo$$com_android_internal_telephony_cdma_EriManager_EriFile$__constructor__(eriManager);
        }

        EriFile(EriManager eriManager) {
            this.this$0 = eriManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_EriManager_EriFile$__constructor__(com.android.internal.telephony.cdma.EriManager ), 0, this, eriManager);
        }

        public /* synthetic */ EriFile() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EriFile)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

