/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.cdma;

import android.content.res.Resources;
import android.os.SystemProperties;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SmsCbLocation;
import android.telephony.SmsCbMessage;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaSmsCbProgramData;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Sms7BitEncodingTranslator;
import com.android.internal.telephony.SmsAddress;
import com.android.internal.telephony.SmsConstants;
import com.android.internal.telephony.SmsHeader;
import com.android.internal.telephony.SmsMessageBase;
import com.android.internal.telephony.cdma.sms.BearerData;
import com.android.internal.telephony.cdma.sms.CdmaSmsAddress;
import com.android.internal.telephony.cdma.sms.CdmaSmsSubaddress;
import com.android.internal.telephony.cdma.sms.SmsEnvelope;
import com.android.internal.telephony.cdma.sms.UserData;
import com.android.internal.util.BitwiseInputStream;
import com.android.internal.util.HexDump;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SmsMessage
extends SmsMessageBase
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "SmsMessage";
    private static String LOGGABLE_TAG = "CDMA:SMS";
    private static boolean VDBG = false;
    private static byte TELESERVICE_IDENTIFIER = 0;
    private static byte SERVICE_CATEGORY = 1;
    private static byte ORIGINATING_ADDRESS = 2;
    private static byte ORIGINATING_SUB_ADDRESS = 3;
    private static byte DESTINATION_ADDRESS = 4;
    private static byte DESTINATION_SUB_ADDRESS = 5;
    private static byte BEARER_REPLY_OPTION = 6;
    private static byte CAUSE_CODES = 7;
    private static byte BEARER_DATA = 8;
    private int status;
    private static int RETURN_NO_ACK = 0;
    private static int RETURN_ACK = 1;
    private SmsEnvelope mEnvelope;
    private BearerData mBearerData;

    private void $$robo$$com_android_internal_telephony_cdma_SmsMessage$__constructor__(SmsAddress addr, SmsEnvelope env) {
        this.mOriginatingAddress = addr;
        this.mEnvelope = env;
        this.createPdu();
    }

    private void $$robo$$com_android_internal_telephony_cdma_SmsMessage$__constructor__() {
    }

    private static final SmsMessage $$robo$$com_android_internal_telephony_cdma_SmsMessage$createFromPdu(byte[] pdu) {
        SmsMessage msg = new SmsMessage();
        try {
            msg.parsePdu(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e("SmsMessage", "SMS PDU parsing failed: ", ex);
            return null;
        }
        catch (OutOfMemoryError e) {
            Log.e("SmsMessage", "SMS PDU parsing failed with out of memory: ", e);
            return null;
        }
    }

    private static final SmsMessage $$robo$$com_android_internal_telephony_cdma_SmsMessage$createFromEfRecord(int index, byte[] data) {
        try {
            SmsMessage msg = new SmsMessage();
            msg.mIndexOnIcc = index;
            if ((data[0] & 1) == 0) {
                Rlog.w("SmsMessage", "SMS parsing failed: Trying to parse a free record");
                return null;
            }
            msg.mStatusOnIcc = data[0] & 7;
            byte size = data[1];
            byte[] pdu = new byte[size];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)2, (byte[])pdu, (int)0, (int)size);
            msg.parsePduFromEfRecord(pdu);
            return msg;
        }
        catch (RuntimeException ex) {
            Rlog.e("SmsMessage", "SMS PDU parsing failed: ", ex);
            return null;
        }
    }

    private static final int $$robo$$com_android_internal_telephony_cdma_SmsMessage$getTPLayerLengthForPDU(String pdu) {
        Rlog.w("SmsMessage", "getTPLayerLengthForPDU: is not supported in CDMA mode.");
        return 0;
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSubmitPdu(String scAddr, String destAddr, String message, boolean statusReportRequested, SmsHeader smsHeader) {
        if (message == null || destAddr == null) {
            return null;
        }
        UserData uData = new UserData();
        uData.payloadStr = message;
        uData.userDataHeader = smsHeader;
        return SmsMessage.privateGetSubmitPdu(destAddr, statusReportRequested, uData);
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSubmitPdu(String scAddr, String destAddr, int destPort, byte[] data, boolean statusReportRequested) {
        SmsHeader.PortAddrs portAddrs = new SmsHeader.PortAddrs();
        portAddrs.destPort = destPort;
        portAddrs.origPort = 0;
        portAddrs.areEightBits = false;
        SmsHeader smsHeader = new SmsHeader();
        smsHeader.portAddrs = portAddrs;
        UserData uData = new UserData();
        uData.userDataHeader = smsHeader;
        uData.msgEncoding = 0;
        uData.msgEncodingSet = true;
        uData.payload = data;
        return SmsMessage.privateGetSubmitPdu(destAddr, statusReportRequested, uData);
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSubmitPdu(String destAddr, UserData userData, boolean statusReportRequested) {
        return SmsMessage.privateGetSubmitPdu(destAddr, statusReportRequested, userData);
    }

    private final int $$robo$$com_android_internal_telephony_cdma_SmsMessage$getProtocolIdentifier() {
        Rlog.w("SmsMessage", "getProtocolIdentifier: is not supported in CDMA mode.");
        return 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_SmsMessage$isReplace() {
        Rlog.w("SmsMessage", "isReplace: is not supported in CDMA mode.");
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_SmsMessage$isCphsMwiMessage() {
        Rlog.w("SmsMessage", "isCphsMwiMessage: is not supported in CDMA mode.");
        return false;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_SmsMessage$isMWIClearMessage() {
        return this.mBearerData != null && this.mBearerData.numberOfMessages == 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_SmsMessage$isMWISetMessage() {
        return this.mBearerData != null && this.mBearerData.numberOfMessages > 0;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_SmsMessage$isMwiDontStore() {
        return this.mBearerData != null && this.mBearerData.numberOfMessages > 0 && this.mBearerData.userData == null;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_SmsMessage$getStatus() {
        return this.status << 16;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_SmsMessage$isStatusReportMessage() {
        return this.mBearerData.messageType == 4;
    }

    private final boolean $$robo$$com_android_internal_telephony_cdma_SmsMessage$isReplyPathPresent() {
        Rlog.w("SmsMessage", "isReplyPathPresent: is not supported in CDMA mode.");
        return false;
    }

    private static final GsmAlphabet.TextEncodingDetails $$robo$$com_android_internal_telephony_cdma_SmsMessage$calculateLength(CharSequence messageBody, boolean use7bitOnly, boolean isEntireMsg) {
        CharSequence newMsgBody = null;
        Resources r = Resources.getSystem();
        if (r.getBoolean(17957016)) {
            newMsgBody = Sms7BitEncodingTranslator.translate(messageBody);
        }
        if (TextUtils.isEmpty(newMsgBody)) {
            newMsgBody = messageBody;
        }
        return BearerData.calcTextEncodingDetails(newMsgBody, use7bitOnly, isEntireMsg);
    }

    private final int $$robo$$com_android_internal_telephony_cdma_SmsMessage$getTeleService() {
        return this.mEnvelope.teleService;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_SmsMessage$getMessageType() {
        if (this.mEnvelope.serviceCategory != 0) {
            return 1;
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_telephony_cdma_SmsMessage$parsePdu(byte[] pdu) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pdu);
        DataInputStream dis = new DataInputStream(bais);
        SmsEnvelope env = new SmsEnvelope();
        CdmaSmsAddress addr = new CdmaSmsAddress();
        try {
            int length;
            env.messageType = dis.readInt();
            env.teleService = dis.readInt();
            env.serviceCategory = dis.readInt();
            addr.digitMode = dis.readByte();
            addr.numberMode = dis.readByte();
            addr.ton = dis.readByte();
            addr.numberPlan = dis.readByte();
            addr.numberOfDigits = length = dis.readUnsignedByte();
            if (length > pdu.length) {
                throw new RuntimeException("createFromPdu: Invalid pdu, addr.numberOfDigits " + length + " > pdu len " + pdu.length);
            }
            addr.origBytes = new byte[length];
            dis.read(addr.origBytes, 0, length);
            env.bearerReply = dis.readInt();
            env.replySeqNo = dis.readByte();
            env.errorClass = dis.readByte();
            env.causeCode = dis.readByte();
            int bearerDataLength = dis.readInt();
            if (bearerDataLength > pdu.length) {
                throw new RuntimeException("createFromPdu: Invalid pdu, bearerDataLength " + bearerDataLength + " > pdu len " + pdu.length);
            }
            env.bearerData = new byte[bearerDataLength];
            dis.read(env.bearerData, 0, bearerDataLength);
            dis.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("createFromPdu: conversion from byte array to object failed: " + ex, ex);
        }
        catch (Exception ex) {
            Rlog.e("SmsMessage", "createFromPdu: conversion from byte array to object failed: " + ex);
        }
        this.mOriginatingAddress = addr;
        env.origAddress = addr;
        this.mEnvelope = env;
        this.mPdu = pdu;
        this.parseSms();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_SmsMessage$parsePduFromEfRecord(byte[] pdu) {
        ByteArrayInputStream bais = new ByteArrayInputStream(pdu);
        DataInputStream dis = new DataInputStream(bais);
        SmsEnvelope env = new SmsEnvelope();
        CdmaSmsAddress addr = new CdmaSmsAddress();
        CdmaSmsSubaddress subAddr = new CdmaSmsSubaddress();
        try {
            env.messageType = dis.readByte();
            block11: while (dis.available() > 0) {
                byte parameterId = dis.readByte();
                int parameterLen = dis.readUnsignedByte();
                byte[] parameterData = new byte[parameterLen];
                switch (parameterId) {
                    case 0: {
                        env.teleService = dis.readUnsignedShort();
                        Rlog.i("SmsMessage", "teleservice = " + env.teleService);
                        continue block11;
                    }
                    case 1: {
                        env.serviceCategory = dis.readUnsignedShort();
                        continue block11;
                    }
                    case 2: 
                    case 4: {
                        dis.read(parameterData, 0, parameterLen);
                        BitwiseInputStream addrBis = new BitwiseInputStream(parameterData);
                        addr.digitMode = addrBis.read(1);
                        addr.numberMode = addrBis.read(1);
                        int numberType = 0;
                        if (addr.digitMode == 1) {
                            addr.ton = numberType = addrBis.read(3);
                            if (addr.numberMode == 0) {
                                addr.numberPlan = addrBis.read(4);
                            }
                        }
                        addr.numberOfDigits = addrBis.read(8);
                        byte[] data = new byte[addr.numberOfDigits];
                        byte b = 0;
                        if (addr.digitMode == 0) {
                            for (int index = 0; index < addr.numberOfDigits; ++index) {
                                b = (byte)(0xF & addrBis.read(4));
                                data[index] = SmsMessage.convertDtmfToAscii(b);
                            }
                        } else if (addr.digitMode == 1) {
                            if (addr.numberMode == 0) {
                                for (int index = 0; index < addr.numberOfDigits; ++index) {
                                    data[index] = b = (byte)(0xFF & addrBis.read(8));
                                }
                            } else if (addr.numberMode == 1) {
                                if (numberType == 2) {
                                    Rlog.e("SmsMessage", "TODO: Originating Addr is email id");
                                } else {
                                    Rlog.e("SmsMessage", "TODO: Originating Addr is data network address");
                                }
                            } else {
                                Rlog.e("SmsMessage", "Originating Addr is of incorrect type");
                            }
                        } else {
                            Rlog.e("SmsMessage", "Incorrect Digit mode");
                        }
                        addr.origBytes = data;
                        Rlog.i("SmsMessage", "Originating Addr=" + addr.toString());
                        continue block11;
                    }
                    case 3: 
                    case 5: {
                        byte b;
                        dis.read(parameterData, 0, parameterLen);
                        BitwiseInputStream subAddrBis = new BitwiseInputStream(parameterData);
                        subAddr.type = subAddrBis.read(3);
                        subAddr.odd = subAddrBis.readByteArray(1)[0];
                        int subAddrLen = subAddrBis.read(8);
                        byte[] subdata = new byte[subAddrLen];
                        for (int index = 0; index < subAddrLen; ++index) {
                            b = (byte)(0xFF & subAddrBis.read(4));
                            subdata[index] = SmsMessage.convertDtmfToAscii(b);
                        }
                        subAddr.origBytes = subdata;
                        continue block11;
                    }
                    case 6: {
                        dis.read(parameterData, 0, parameterLen);
                        BitwiseInputStream replyOptBis = new BitwiseInputStream(parameterData);
                        env.bearerReply = replyOptBis.read(6);
                        continue block11;
                    }
                    case 7: {
                        dis.read(parameterData, 0, parameterLen);
                        BitwiseInputStream ccBis = new BitwiseInputStream(parameterData);
                        env.replySeqNo = ccBis.readByteArray(6)[0];
                        env.errorClass = ccBis.readByteArray(2)[0];
                        if (env.errorClass == 0) continue block11;
                        env.causeCode = ccBis.readByteArray(8)[0];
                        continue block11;
                    }
                    case 8: {
                        dis.read(parameterData, 0, parameterLen);
                        env.bearerData = parameterData;
                        continue block11;
                    }
                }
                throw new Exception("unsupported parameterId (" + parameterId + ")");
            }
            bais.close();
            dis.close();
        }
        catch (Exception ex) {
            Rlog.e("SmsMessage", "parsePduFromEfRecord: conversion from pdu to SmsMessage failed" + ex);
        }
        this.mOriginatingAddress = addr;
        env.origAddress = addr;
        env.origSubaddress = subAddr;
        this.mEnvelope = env;
        this.mPdu = pdu;
        this.parseSms();
    }

    private final void $$robo$$com_android_internal_telephony_cdma_SmsMessage$parseSms() {
        if (this.mEnvelope.teleService == 262144) {
            this.mBearerData = new BearerData();
            if (this.mEnvelope.bearerData != null) {
                this.mBearerData.numberOfMessages = 0xFF & this.mEnvelope.bearerData[0];
            }
            return;
        }
        this.mBearerData = BearerData.decode(this.mEnvelope.bearerData);
        if (Rlog.isLoggable("CDMA:SMS", 2)) {
            Rlog.d("SmsMessage", "MT raw BearerData = '" + HexDump.toHexString(this.mEnvelope.bearerData) + "'");
            Rlog.d("SmsMessage", "MT (decoded) BearerData = " + this.mBearerData);
        }
        this.mMessageRef = this.mBearerData.messageId;
        if (this.mBearerData.userData != null) {
            this.mUserData = this.mBearerData.userData.payload;
            this.mUserDataHeader = this.mBearerData.userData.userDataHeader;
            this.mMessageBody = this.mBearerData.userData.payloadStr;
        }
        if (this.mOriginatingAddress != null) {
            this.mOriginatingAddress.address = new String(this.mOriginatingAddress.origBytes);
            if (this.mOriginatingAddress.ton == 1 && this.mOriginatingAddress.address.charAt(0) != '+') {
                this.mOriginatingAddress.address = "+" + this.mOriginatingAddress.address;
            }
        }
        if (this.mBearerData.msgCenterTimeStamp != null) {
            this.mScTimeMillis = this.mBearerData.msgCenterTimeStamp.toMillis(true);
        }
        if (this.mBearerData.messageType == 4) {
            if (!this.mBearerData.messageStatusSet) {
                Rlog.d("SmsMessage", "DELIVERY_ACK message without msgStatus (" + (this.mUserData == null ? "also missing" : "does have") + " userData).");
                this.status = 0;
            } else {
                this.status = this.mBearerData.errorClass << 8;
                this.status |= this.mBearerData.messageStatus;
            }
        } else if (this.mBearerData.messageType != 1) {
            throw new RuntimeException("Unsupported message type: " + this.mBearerData.messageType);
        }
        if (this.mMessageBody != null) {
            this.parseMessageBody();
        } else if (this.mUserData != null) {
            // empty if block
        }
    }

    private final SmsCbMessage $$robo$$com_android_internal_telephony_cdma_SmsMessage$parseBroadcastSms() {
        BearerData bData = BearerData.decode(this.mEnvelope.bearerData, this.mEnvelope.serviceCategory);
        if (bData == null) {
            Rlog.w("SmsMessage", "BearerData.decode() returned null");
            return null;
        }
        if (Rlog.isLoggable("CDMA:SMS", 2)) {
            Rlog.d("SmsMessage", "MT raw BearerData = " + HexDump.toHexString(this.mEnvelope.bearerData));
        }
        String plmn = TelephonyManager.getDefault().getNetworkOperator();
        SmsCbLocation location = new SmsCbLocation(plmn);
        return new SmsCbMessage(2, 1, bData.messageId, location, this.mEnvelope.serviceCategory, bData.getLanguage(), bData.userData.payloadStr, bData.priority, null, bData.cmasWarningInfo);
    }

    private final SmsConstants.MessageClass $$robo$$com_android_internal_telephony_cdma_SmsMessage$getMessageClass() {
        if (0 == this.mBearerData.displayMode) {
            return SmsConstants.MessageClass.CLASS_0;
        }
        return SmsConstants.MessageClass.UNKNOWN;
    }

    private static final synchronized int $$robo$$com_android_internal_telephony_cdma_SmsMessage$getNextMessageId() {
        int msgId = SystemProperties.getInt("persist.radio.cdma.msgid", 1);
        String nextMsgId = Integer.toString(msgId % 65535 + 1);
        try {
            SystemProperties.set("persist.radio.cdma.msgid", nextMsgId);
            if (Rlog.isLoggable("CDMA:SMS", 2)) {
                Rlog.d("SmsMessage", "next persist.radio.cdma.msgid = " + nextMsgId);
                Rlog.d("SmsMessage", "readback gets " + SystemProperties.get("persist.radio.cdma.msgid"));
            }
        }
        catch (RuntimeException ex) {
            Rlog.e("SmsMessage", "set nextMessage ID failed: " + ex);
        }
        return msgId;
    }

    private static final SubmitPdu $$robo$$com_android_internal_telephony_cdma_SmsMessage$privateGetSubmitPdu(String destAddrStr, boolean statusReportRequested, UserData userData) {
        CdmaSmsAddress destAddr = CdmaSmsAddress.parse(PhoneNumberUtils.cdmaCheckAndProcessPlusCodeForSms(destAddrStr));
        if (destAddr == null) {
            return null;
        }
        BearerData bearerData = new BearerData();
        bearerData.messageType = 2;
        bearerData.messageId = SmsMessage.getNextMessageId();
        bearerData.deliveryAckReq = statusReportRequested;
        bearerData.userAckReq = false;
        bearerData.readAckReq = false;
        bearerData.reportReq = false;
        bearerData.userData = userData;
        byte[] encodedBearerData = BearerData.encode(bearerData);
        if (Rlog.isLoggable("CDMA:SMS", 2)) {
            Rlog.d("SmsMessage", "MO (encoded) BearerData = " + bearerData);
            Rlog.d("SmsMessage", "MO raw BearerData = '" + HexDump.toHexString(encodedBearerData) + "'");
        }
        if (encodedBearerData == null) {
            return null;
        }
        int teleservice = bearerData.hasUserDataHeader ? 4101 : 4098;
        SmsEnvelope envelope = new SmsEnvelope();
        envelope.messageType = 0;
        envelope.teleService = teleservice;
        envelope.destAddress = destAddr;
        envelope.bearerReply = 1;
        envelope.bearerData = encodedBearerData;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(envelope.teleService);
            dos.writeInt(0);
            dos.writeInt(0);
            dos.write(destAddr.digitMode);
            dos.write(destAddr.numberMode);
            dos.write(destAddr.ton);
            dos.write(destAddr.numberPlan);
            dos.write(destAddr.numberOfDigits);
            dos.write(destAddr.origBytes, 0, destAddr.origBytes.length);
            dos.write(0);
            dos.write(0);
            dos.write(0);
            dos.write(encodedBearerData.length);
            dos.write(encodedBearerData, 0, encodedBearerData.length);
            dos.close();
            SubmitPdu pdu = new SubmitPdu();
            pdu.encodedMessage = baos.toByteArray();
            pdu.encodedScAddress = null;
            return pdu;
        }
        catch (IOException ex) {
            Rlog.e("SmsMessage", "creating SubmitPdu failed: " + ex);
            return null;
        }
    }

    private final void $$robo$$com_android_internal_telephony_cdma_SmsMessage$createPdu() {
        SmsEnvelope env = this.mEnvelope;
        CdmaSmsAddress addr = env.origAddress;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(100);
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(baos));
        try {
            dos.writeInt(env.messageType);
            dos.writeInt(env.teleService);
            dos.writeInt(env.serviceCategory);
            dos.writeByte(addr.digitMode);
            dos.writeByte(addr.numberMode);
            dos.writeByte(addr.ton);
            dos.writeByte(addr.numberPlan);
            dos.writeByte(addr.numberOfDigits);
            dos.write(addr.origBytes, 0, addr.origBytes.length);
            dos.writeInt(env.bearerReply);
            dos.writeByte(env.replySeqNo);
            dos.writeByte(env.errorClass);
            dos.writeByte(env.causeCode);
            dos.writeInt(env.bearerData.length);
            dos.write(env.bearerData, 0, env.bearerData.length);
            dos.close();
            this.mPdu = baos.toByteArray();
        }
        catch (IOException ex) {
            Rlog.e("SmsMessage", "createPdu: conversion from object to byte array failed: " + ex);
        }
    }

    private static final byte $$robo$$com_android_internal_telephony_cdma_SmsMessage$convertDtmfToAscii(byte dtmfDigit) {
        byte asciiDigit;
        switch (dtmfDigit) {
            case 0: {
                asciiDigit = 68;
                break;
            }
            case 1: {
                asciiDigit = 49;
                break;
            }
            case 2: {
                asciiDigit = 50;
                break;
            }
            case 3: {
                asciiDigit = 51;
                break;
            }
            case 4: {
                asciiDigit = 52;
                break;
            }
            case 5: {
                asciiDigit = 53;
                break;
            }
            case 6: {
                asciiDigit = 54;
                break;
            }
            case 7: {
                asciiDigit = 55;
                break;
            }
            case 8: {
                asciiDigit = 56;
                break;
            }
            case 9: {
                asciiDigit = 57;
                break;
            }
            case 10: {
                asciiDigit = 48;
                break;
            }
            case 11: {
                asciiDigit = 42;
                break;
            }
            case 12: {
                asciiDigit = 35;
                break;
            }
            case 13: {
                asciiDigit = 65;
                break;
            }
            case 14: {
                asciiDigit = 66;
                break;
            }
            case 15: {
                asciiDigit = 67;
                break;
            }
            default: {
                asciiDigit = 32;
            }
        }
        return asciiDigit;
    }

    private final int $$robo$$com_android_internal_telephony_cdma_SmsMessage$getNumOfVoicemails() {
        return this.mBearerData.numberOfMessages;
    }

    private final byte[] $$robo$$com_android_internal_telephony_cdma_SmsMessage$getIncomingSmsFingerprint() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        output.write(this.mEnvelope.serviceCategory);
        output.write(this.mEnvelope.teleService);
        output.write(this.mEnvelope.origAddress.origBytes, 0, this.mEnvelope.origAddress.origBytes.length);
        output.write(this.mEnvelope.bearerData, 0, this.mEnvelope.bearerData.length);
        output.write(this.mEnvelope.origSubaddress.origBytes, 0, this.mEnvelope.origSubaddress.origBytes.length);
        return output.toByteArray();
    }

    private final ArrayList<CdmaSmsCbProgramData> $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSmsCbProgramData() {
        return this.mBearerData.serviceCategoryProgramData;
    }

    private void __constructor__(SmsAddress smsAddress, SmsEnvelope smsEnvelope) {
        this.$$robo$$com_android_internal_telephony_cdma_SmsMessage$__constructor__(smsAddress, smsEnvelope);
    }

    public SmsMessage(SmsAddress smsAddress, SmsEnvelope smsEnvelope) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_SmsMessage$__constructor__(com.android.internal.telephony.SmsAddress com.android.internal.telephony.cdma.sms.SmsEnvelope ), 0, this, smsAddress, smsEnvelope);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_cdma_SmsMessage$__constructor__();
    }

    public SmsMessage() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_SmsMessage$__constructor__(), 0, this);
    }

    public static SmsMessage createFromPdu(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromPdu", $$robo$$com_android_internal_telephony_cdma_SmsMessage$createFromPdu(byte[] ), 0, (byte[])byArray);
    }

    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromEfRecord", $$robo$$com_android_internal_telephony_cdma_SmsMessage$createFromEfRecord(int byte[] ), 0, (int)n, (byte[])byArray);
    }

    public static int getTPLayerLengthForPDU(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTPLayerLengthForPDU", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getTPLayerLengthForPDU(java.lang.String ), 0, (String)string2);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl, SmsHeader smsHeader) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSubmitPdu(java.lang.String java.lang.String java.lang.String boolean com.android.internal.telephony.SmsHeader ), 0, (String)string2, (String)string3, (String)string4, (boolean)bl, (SmsHeader)smsHeader);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, int n, byte[] byArray, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSubmitPdu(java.lang.String java.lang.String int byte[] boolean ), 0, (String)string2, (String)string3, (int)n, (byte[])byArray, (boolean)bl);
    }

    public static SubmitPdu getSubmitPdu(String string2, UserData userData, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSubmitPdu(java.lang.String com.android.internal.telephony.cdma.sms.UserData boolean ), 0, (String)string2, (UserData)userData, (boolean)bl);
    }

    @Override
    public int getProtocolIdentifier() {
        return (int)InvokeDynamicSupport.bootstrap("getProtocolIdentifier", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getProtocolIdentifier(), 0, this);
    }

    @Override
    public boolean isReplace() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplace", $$robo$$com_android_internal_telephony_cdma_SmsMessage$isReplace(), 0, this);
    }

    @Override
    public boolean isCphsMwiMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCphsMwiMessage", $$robo$$com_android_internal_telephony_cdma_SmsMessage$isCphsMwiMessage(), 0, this);
    }

    @Override
    public boolean isMWIClearMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMWIClearMessage", $$robo$$com_android_internal_telephony_cdma_SmsMessage$isMWIClearMessage(), 0, this);
    }

    @Override
    public boolean isMWISetMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMWISetMessage", $$robo$$com_android_internal_telephony_cdma_SmsMessage$isMWISetMessage(), 0, this);
    }

    @Override
    public boolean isMwiDontStore() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMwiDontStore", $$robo$$com_android_internal_telephony_cdma_SmsMessage$isMwiDontStore(), 0, this);
    }

    @Override
    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getStatus(), 0, this);
    }

    @Override
    public boolean isStatusReportMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStatusReportMessage", $$robo$$com_android_internal_telephony_cdma_SmsMessage$isStatusReportMessage(), 0, this);
    }

    @Override
    public boolean isReplyPathPresent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplyPathPresent", $$robo$$com_android_internal_telephony_cdma_SmsMessage$isReplyPathPresent(), 0, this);
    }

    public static GsmAlphabet.TextEncodingDetails calculateLength(CharSequence charSequence, boolean bl, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("calculateLength", $$robo$$com_android_internal_telephony_cdma_SmsMessage$calculateLength(java.lang.CharSequence boolean boolean ), 0, (CharSequence)charSequence, (boolean)bl, (boolean)bl2);
    }

    public int getTeleService() {
        return (int)InvokeDynamicSupport.bootstrap("getTeleService", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getTeleService(), 0, this);
    }

    public int getMessageType() {
        return (int)InvokeDynamicSupport.bootstrap("getMessageType", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getMessageType(), 0, this);
    }

    private void parsePdu(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parsePdu", $$robo$$com_android_internal_telephony_cdma_SmsMessage$parsePdu(byte[] ), 0, this, byArray);
    }

    private void parsePduFromEfRecord(byte[] byArray) {
        InvokeDynamicSupport.bootstrap("parsePduFromEfRecord", $$robo$$com_android_internal_telephony_cdma_SmsMessage$parsePduFromEfRecord(byte[] ), 0, this, byArray);
    }

    public void parseSms() {
        InvokeDynamicSupport.bootstrap("parseSms", $$robo$$com_android_internal_telephony_cdma_SmsMessage$parseSms(), 0, this);
    }

    public SmsCbMessage parseBroadcastSms() {
        return InvokeDynamicSupport.bootstrap("parseBroadcastSms", $$robo$$com_android_internal_telephony_cdma_SmsMessage$parseBroadcastSms(), 0, this);
    }

    @Override
    public SmsConstants.MessageClass getMessageClass() {
        return InvokeDynamicSupport.bootstrap("getMessageClass", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getMessageClass(), 0, this);
    }

    public static synchronized int getNextMessageId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNextMessageId", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getNextMessageId(), 0);
    }

    private static SubmitPdu privateGetSubmitPdu(String string2, boolean bl, UserData userData) {
        return InvokeDynamicSupport.bootstrapStatic("privateGetSubmitPdu", $$robo$$com_android_internal_telephony_cdma_SmsMessage$privateGetSubmitPdu(java.lang.String boolean com.android.internal.telephony.cdma.sms.UserData ), 0, (String)string2, (boolean)bl, (UserData)userData);
    }

    public void createPdu() {
        InvokeDynamicSupport.bootstrap("createPdu", $$robo$$com_android_internal_telephony_cdma_SmsMessage$createPdu(), 0, this);
    }

    public static byte convertDtmfToAscii(byte by) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("convertDtmfToAscii", $$robo$$com_android_internal_telephony_cdma_SmsMessage$convertDtmfToAscii(byte ), 0, (byte)by);
    }

    public int getNumOfVoicemails() {
        return (int)InvokeDynamicSupport.bootstrap("getNumOfVoicemails", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getNumOfVoicemails(), 0, this);
    }

    public byte[] getIncomingSmsFingerprint() {
        return InvokeDynamicSupport.bootstrap("getIncomingSmsFingerprint", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getIncomingSmsFingerprint(), 0, this);
    }

    public ArrayList<CdmaSmsCbProgramData> getSmsCbProgramData() {
        return InvokeDynamicSupport.bootstrap("getSmsCbProgramData", $$robo$$com_android_internal_telephony_cdma_SmsMessage$getSmsCbProgramData(), 0, this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsMessage)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SubmitPdu
    extends SmsMessageBase.SubmitPduBase
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_telephony_cdma_SmsMessage_SubmitPdu$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_telephony_cdma_SmsMessage_SubmitPdu$__constructor__();
        }

        public SubmitPdu() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_cdma_SmsMessage_SubmitPdu$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubmitPdu)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

