/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.ims;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.IPackageManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import android.util.Pair;
import com.android.ims.internal.IImsFeatureStatusCallback;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsServiceFeatureListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ImsServiceController
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ImsServiceController";
    private static int REBIND_RETRY_TIME = 5000;
    private Context mContext;
    private ComponentName mComponentName;
    private Object mLock;
    private HandlerThread mHandlerThread;
    private IPackageManager mPackageManager;
    private ImsServiceControllerCallbacks mCallbacks;
    private Handler mHandler;
    private boolean mIsBound;
    private boolean mIsBinding;
    private HashSet<Pair<Integer, Integer>> mImsFeatures;
    private IImsServiceController mIImsServiceController;
    private IBinder mImsServiceControllerBinder;
    private ImsServiceConnection mImsServiceConnection;
    private ImsDeathRecipient mImsDeathRecipient;
    private Set<IImsServiceFeatureListener> mImsStatusCallbacks;
    private Set<ImsFeatureStatusCallback> mFeatureStatusCallbacks;
    private Runnable mRestartImsServiceRunnable;
    private RebindRetry mRebindRetry;

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$setRebindRetryTime(RebindRetry retry) {
        this.mRebindRetry = retry;
    }

    private final Handler $$robo$$com_android_internal_telephony_ims_ImsServiceController$getHandler() {
        return this.mHandler;
    }

    private void $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks) {
        this.mLock = new Object();
        this.mHandlerThread = new HandlerThread("ImsServiceControllerHandler");
        this.mIsBound = false;
        this.mIsBinding = false;
        this.mImsStatusCallbacks = new HashSet<IImsServiceFeatureListener>();
        this.mFeatureStatusCallbacks = new HashSet<ImsFeatureStatusCallback>();
        this.mRestartImsServiceRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ImsServiceController this$0;

            private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$__constructor__(ImsServiceController this$0) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$run() {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    if (this.this$0.mIsBound) {
                        return;
                    }
                    this.this$0.bind(this.this$0.mImsFeatures);
                }
            }

            private void __constructor__(ImsServiceController imsServiceController) {
                this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_1$__constructor__(imsServiceController);
            }
            {
                this.this$0 = imsServiceController;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$__constructor__(com.android.internal.telephony.ims.ImsServiceController ), 0, this, imsServiceController);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_telephony_ims_ImsServiceController_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRebindRetry = () -> 5000L;
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mPackageManager = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
    }

    private void $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks callbacks, Handler testHandler) {
        this.mLock = new Object();
        this.mHandlerThread = new HandlerThread("ImsServiceControllerHandler");
        this.mIsBound = false;
        this.mIsBinding = false;
        this.mImsStatusCallbacks = new HashSet<IImsServiceFeatureListener>();
        this.mFeatureStatusCallbacks = new HashSet<ImsFeatureStatusCallback>();
        this.mRestartImsServiceRunnable = new /* invalid duplicate definition of identical inner class */;
        this.mRebindRetry = () -> 5000L;
        this.mContext = context;
        this.mComponentName = componentName;
        this.mCallbacks = callbacks;
        this.mHandler = testHandler;
        this.mPackageManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_ims_ImsServiceController$bind(HashSet<Pair<Integer, Integer>> imsFeatureSet) {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeCallbacks(this.mRestartImsServiceRunnable);
            if (!this.mIsBound && !this.mIsBinding) {
                this.mIsBinding = true;
                this.mImsFeatures = imsFeatureSet;
                Intent imsServiceIntent = new Intent("android.telephony.ims.ImsService").setComponent(this.mComponentName);
                this.mImsServiceConnection = new ImsServiceConnection(this);
                int serviceFlags = 0x4000041;
                Log.i("ImsServiceController", "Binding ImsService:" + this.mComponentName);
                try {
                    return this.mContext.bindService(imsServiceIntent, this.mImsServiceConnection, serviceFlags);
                }
                catch (Exception e) {
                    Log.e("ImsServiceController", "Error binding (" + this.mComponentName + ") with exception: " + e.getMessage());
                    return false;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$unbind() throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.mHandler.removeCallbacks(this.mRestartImsServiceRunnable);
            if (this.mImsServiceConnection == null || this.mImsDeathRecipient == null) {
                return;
            }
            this.changeImsServiceFeatures(new HashSet<Pair<Integer, Integer>>());
            this.removeImsServiceFeatureListener();
            this.mImsServiceControllerBinder.unlinkToDeath(this.mImsDeathRecipient, 0);
            Log.i("ImsServiceController", "Unbinding ImsService: " + this.mComponentName);
            this.mContext.unbindService(this.mImsServiceConnection);
            this.cleanUpService();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$changeImsServiceFeatures(HashSet<Pair<Integer, Integer>> newImsFeatures) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIsBound) {
                HashSet<Pair<Integer, Integer>> newFeatures = new HashSet<Pair<Integer, Integer>>(newImsFeatures);
                newFeatures.removeAll(this.mImsFeatures);
                for (Pair<Integer, Integer> i : newFeatures) {
                    this.addImsServiceFeature(i);
                }
                HashSet<Pair<Integer, Integer>> oldFeatures = new HashSet<Pair<Integer, Integer>>(this.mImsFeatures);
                oldFeatures.removeAll(newImsFeatures);
                for (Pair<Integer, Integer> i : oldFeatures) {
                    this.removeImsServiceFeature(i);
                }
            }
            Log.i("ImsServiceController", "Features changed (" + this.mImsFeatures + "->" + newImsFeatures + ") for " + "ImsService: " + this.mComponentName);
            this.mImsFeatures = newImsFeatures;
        }
    }

    private final IImsServiceController $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceController() {
        return this.mIImsServiceController;
    }

    private final IBinder $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceControllerBinder() {
        return this.mImsServiceControllerBinder;
    }

    private final ComponentName $$robo$$com_android_internal_telephony_ims_ImsServiceController$getComponentName() {
        return this.mComponentName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeatureListener(IImsServiceFeatureListener callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsStatusCallbacks.add(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeatureListener() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsStatusCallbacks.clear();
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$startDelayedRebindToService() {
        if (!this.mHandler.hasCallbacks(this.mRestartImsServiceRunnable)) {
            this.mHandler.postDelayed(this.mRestartImsServiceRunnable, this.mRebindRetry.getRetryTimeout());
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$grantPermissionsToService() {
        Log.i("ImsServiceController", "Granting Runtime permissions to:" + this.getComponentName());
        String[] pkgToGrant = new String[]{this.mComponentName.getPackageName()};
        try {
            if (this.mPackageManager != null) {
                this.mPackageManager.grantDefaultPermissionsToEnabledImsServices(pkgToGrant, this.mContext.getUserId());
            }
        }
        catch (RemoteException e) {
            Log.w("ImsServiceController", "Unable to grant permissions, binder died.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureCreatedCallback(int slot, int feature) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureListener> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureListener callbacks = i.next();
                try {
                    callbacks.imsFeatureCreated(slot, feature);
                }
                catch (RemoteException e) {
                    Log.w("ImsServiceController", "sendImsFeatureCreatedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureRemovedCallback(int slot, int feature) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureListener> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureListener callbacks = i.next();
                try {
                    callbacks.imsFeatureRemoved(slot, feature);
                }
                catch (RemoteException e) {
                    Log.w("ImsServiceController", "sendImsFeatureRemovedCallback: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureStatusChanged(int slot, int feature, int status) {
        Object object = this.mLock;
        synchronized (object) {
            Iterator<IImsServiceFeatureListener> i = this.mImsStatusCallbacks.iterator();
            while (i.hasNext()) {
                IImsServiceFeatureListener callbacks = i.next();
                try {
                    callbacks.imsStatusChanged(slot, feature, status);
                }
                catch (RemoteException e) {
                    Log.w("ImsServiceController", "sendImsFeatureStatusChanged: Binder died, removing callback. Exception:" + e.getMessage());
                    i.remove();
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeature(Pair<Integer, Integer> featurePair) throws RemoteException {
        if (this.mIImsServiceController == null || this.mCallbacks == null) {
            Log.w("ImsServiceController", "addImsServiceFeature called with null values.");
            return;
        }
        ImsFeatureStatusCallback c = new ImsFeatureStatusCallback(this, (Integer)featurePair.first, (Integer)featurePair.second);
        this.mFeatureStatusCallbacks.add(c);
        this.mIImsServiceController.createImsFeature((Integer)featurePair.first, (Integer)featurePair.second, c.getCallback());
        this.mCallbacks.imsServiceFeatureCreated((Integer)featurePair.first, (Integer)featurePair.second, this);
        this.sendImsFeatureCreatedCallback((Integer)featurePair.first, (Integer)featurePair.second);
    }

    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeature(Pair<Integer, Integer> featurePair) throws RemoteException {
        if (this.mIImsServiceController == null || this.mCallbacks == null) {
            Log.w("ImsServiceController", "removeImsServiceFeature called with null values.");
            return;
        }
        ImsFeatureStatusCallback callbackToRemove = this.mFeatureStatusCallbacks.stream().filter(c -> ((ImsFeatureStatusCallback)c).mSlotId == (Integer)pair.first && ((ImsFeatureStatusCallback)c).mFeatureType == (Integer)pair.second).findFirst().orElse(null);
        if (callbackToRemove != null) {
            this.mFeatureStatusCallbacks.remove(callbackToRemove);
        }
        this.mIImsServiceController.removeImsFeature((Integer)featurePair.first, (Integer)featurePair.second, callbackToRemove != null ? callbackToRemove.getCallback() : null);
        this.mCallbacks.imsServiceFeatureRemoved((Integer)featurePair.first, (Integer)featurePair.second, this);
        this.sendImsFeatureRemovedCallback((Integer)featurePair.first, (Integer)featurePair.second);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$notifyAllFeaturesRemoved() {
        if (this.mCallbacks == null) {
            Log.w("ImsServiceController", "notifyAllFeaturesRemoved called with invalid callbacks.");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            for (Pair<Integer, Integer> feature : this.mImsFeatures) {
                this.mCallbacks.imsServiceFeatureRemoved((Integer)feature.first, (Integer)feature.second, this);
                this.sendImsFeatureRemovedCallback((Integer)feature.first, (Integer)feature.second);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController$cleanUpService() {
        Object object = this.mLock;
        synchronized (object) {
            this.mImsDeathRecipient = null;
            this.mImsServiceConnection = null;
            this.mImsServiceControllerBinder = null;
            this.mIImsServiceController = null;
            this.mIsBound = false;
        }
    }

    public void setRebindRetryTime(RebindRetry rebindRetry) {
        InvokeDynamicSupport.bootstrap("setRebindRetryTime", $$robo$$com_android_internal_telephony_ims_ImsServiceController$setRebindRetryTime(com.android.internal.telephony.ims.ImsServiceController$RebindRetry ), 0, this, rebindRetry);
    }

    public Handler getHandler() {
        return InvokeDynamicSupport.bootstrap("getHandler", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getHandler(), 0, this);
    }

    private void __constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
        this.$$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(context, componentName, imsServiceControllerCallbacks);
    }

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks ), 0, this, context, componentName, imsServiceControllerCallbacks);
    }

    private void __constructor__(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks, Handler handler) {
        this.$$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(context, componentName, imsServiceControllerCallbacks, handler);
    }

    public ImsServiceController(Context context, ComponentName componentName, ImsServiceControllerCallbacks imsServiceControllerCallbacks, Handler handler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController$__constructor__(android.content.Context android.content.ComponentName com.android.internal.telephony.ims.ImsServiceController$ImsServiceControllerCallbacks android.os.Handler ), 0, this, context, componentName, imsServiceControllerCallbacks, handler);
    }

    public boolean bind(HashSet<Pair<Integer, Integer>> hashSet) {
        return (boolean)InvokeDynamicSupport.bootstrap("bind", $$robo$$com_android_internal_telephony_ims_ImsServiceController$bind(java.util.HashSet<android.util.Pair<java.lang.Integer, java.lang.Integer>> ), 0, this, hashSet);
    }

    public void unbind() throws RemoteException {
        InvokeDynamicSupport.bootstrap("unbind", $$robo$$com_android_internal_telephony_ims_ImsServiceController$unbind(), 0, this);
    }

    public void changeImsServiceFeatures(HashSet<Pair<Integer, Integer>> hashSet) throws RemoteException {
        InvokeDynamicSupport.bootstrap("changeImsServiceFeatures", $$robo$$com_android_internal_telephony_ims_ImsServiceController$changeImsServiceFeatures(java.util.HashSet<android.util.Pair<java.lang.Integer, java.lang.Integer>> ), 0, this, hashSet);
    }

    public IImsServiceController getImsServiceController() {
        return InvokeDynamicSupport.bootstrap("getImsServiceController", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceController(), 0, this);
    }

    public IBinder getImsServiceControllerBinder() {
        return InvokeDynamicSupport.bootstrap("getImsServiceControllerBinder", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getImsServiceControllerBinder(), 0, this);
    }

    public ComponentName getComponentName() {
        return InvokeDynamicSupport.bootstrap("getComponentName", $$robo$$com_android_internal_telephony_ims_ImsServiceController$getComponentName(), 0, this);
    }

    public void addImsServiceFeatureListener(IImsServiceFeatureListener iImsServiceFeatureListener) {
        InvokeDynamicSupport.bootstrap("addImsServiceFeatureListener", $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeatureListener(com.android.ims.internal.IImsServiceFeatureListener ), 0, this, iImsServiceFeatureListener);
    }

    private void removeImsServiceFeatureListener() {
        InvokeDynamicSupport.bootstrap("removeImsServiceFeatureListener", $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeatureListener(), 0, this);
    }

    private void startDelayedRebindToService() {
        InvokeDynamicSupport.bootstrap("startDelayedRebindToService", $$robo$$com_android_internal_telephony_ims_ImsServiceController$startDelayedRebindToService(), 0, this);
    }

    private void grantPermissionsToService() {
        InvokeDynamicSupport.bootstrap("grantPermissionsToService", $$robo$$com_android_internal_telephony_ims_ImsServiceController$grantPermissionsToService(), 0, this);
    }

    private void sendImsFeatureCreatedCallback(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendImsFeatureCreatedCallback", $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureCreatedCallback(int int ), 0, this, n, n2);
    }

    private void sendImsFeatureRemovedCallback(int n, int n2) {
        InvokeDynamicSupport.bootstrap("sendImsFeatureRemovedCallback", $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureRemovedCallback(int int ), 0, this, n, n2);
    }

    private void sendImsFeatureStatusChanged(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("sendImsFeatureStatusChanged", $$robo$$com_android_internal_telephony_ims_ImsServiceController$sendImsFeatureStatusChanged(int int int ), 0, this, n, n2, n3);
    }

    private void addImsServiceFeature(Pair<Integer, Integer> pair) throws RemoteException {
        InvokeDynamicSupport.bootstrap("addImsServiceFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$addImsServiceFeature(android.util.Pair<java.lang.Integer, java.lang.Integer> ), 0, this, pair);
    }

    private void removeImsServiceFeature(Pair<Integer, Integer> pair) throws RemoteException {
        InvokeDynamicSupport.bootstrap("removeImsServiceFeature", $$robo$$com_android_internal_telephony_ims_ImsServiceController$removeImsServiceFeature(android.util.Pair<java.lang.Integer, java.lang.Integer> ), 0, this, pair);
    }

    private void notifyAllFeaturesRemoved() {
        InvokeDynamicSupport.bootstrap("notifyAllFeaturesRemoved", $$robo$$com_android_internal_telephony_ims_ImsServiceController$notifyAllFeaturesRemoved(), 0, this);
    }

    private void cleanUpService() {
        InvokeDynamicSupport.bootstrap("cleanUpService", $$robo$$com_android_internal_telephony_ims_ImsServiceController$cleanUpService(), 0, this);
    }

    public /* synthetic */ ImsServiceController() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceController)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class ImsFeatureStatusCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSlotId;
        private int mFeatureType;
        private IImsFeatureStatusCallback mCallback;
        /* synthetic */ ImsServiceController this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$__constructor__(ImsServiceController imsServiceController, int slotId, int featureType) {
            this.mCallback = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ImsFeatureStatusCallback this$1;

                private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$__constructor__(ImsFeatureStatusCallback this$1) {
                }

                private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$notifyImsFeatureStatus(int featureStatus) throws RemoteException {
                    Log.i("ImsServiceController", "notifyImsFeatureStatus: slot=" + this.this$1.mSlotId + ", feature=" + this.this$1.mFeatureType + ", status=" + featureStatus);
                    this.this$1.this$0.sendImsFeatureStatusChanged(this.this$1.mSlotId, this.this$1.mFeatureType, featureStatus);
                }

                private void __constructor__(ImsFeatureStatusCallback imsFeatureStatusCallback) {
                    this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$__constructor__(imsFeatureStatusCallback);
                }
                {
                    this.this$1 = imsFeatureStatusCallback;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$__constructor__(com.android.internal.telephony.ims.ImsServiceController$ImsFeatureStatusCallback ), 0, this, imsFeatureStatusCallback);
                }

                @Override
                public void notifyImsFeatureStatus(int n) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("notifyImsFeatureStatus", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback_1$notifyImsFeatureStatus(int ), 0, this, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mSlotId = slotId;
            this.mFeatureType = featureType;
        }

        private final IImsFeatureStatusCallback $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$getCallback() {
            return this.mCallback;
        }

        private void __constructor__(ImsServiceController imsServiceController, int n, int n2) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$__constructor__(imsServiceController, n, n2);
        }

        ImsFeatureStatusCallback(ImsServiceController imsServiceController, int n, int n2) {
            this.this$0 = imsServiceController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$__constructor__(com.android.internal.telephony.ims.ImsServiceController int int ), 0, this, imsServiceController, n, n2);
        }

        public IImsFeatureStatusCallback getCallback() {
            return InvokeDynamicSupport.bootstrap("getCallback", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsFeatureStatusCallback$getCallback(), 0, this);
        }

        public /* synthetic */ ImsFeatureStatusCallback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsFeatureStatusCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface RebindRetry
    extends InstrumentedInterface {
        public long getRetryTimeout();
    }

    public static interface ImsServiceControllerCallbacks
    extends InstrumentedInterface {
        public void imsServiceFeatureCreated(int var1, int var2, ImsServiceController var3);

        public void imsServiceFeatureRemoved(int var1, int var2, ImsServiceController var3);
    }

    public class ImsServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ImsServiceController this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$__constructor__(ImsServiceController this$0) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mIsBound = true;
                this.this$0.mIsBinding = false;
                this.this$0.grantPermissionsToService();
                Log.d("ImsServiceController", "ImsService(" + name + "): onServiceConnected with binder: " + service);
                if (service != null) {
                    this.this$0.mImsDeathRecipient = new ImsDeathRecipient(this.this$0, name);
                    try {
                        service.linkToDeath(this.this$0.mImsDeathRecipient, 0);
                        this.this$0.mImsServiceControllerBinder = service;
                        this.this$0.mIImsServiceController = IImsServiceController.Stub.asInterface(service);
                        for (Pair i : this.this$0.mImsFeatures) {
                            this.this$0.addImsServiceFeature(i);
                        }
                    }
                    catch (RemoteException e) {
                        this.this$0.mIsBound = false;
                        this.this$0.mIsBinding = false;
                        if (this.this$0.mImsDeathRecipient != null) {
                            this.this$0.mImsDeathRecipient.binderDied();
                        }
                        Log.e("ImsServiceController", "ImsService(" + name + ") RemoteException:" + e.getMessage());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceDisconnected(ComponentName name) {
            Object object = this.this$0.mLock;
            synchronized (object) {
                this.this$0.mIsBinding = false;
            }
            if (this.this$0.mIImsServiceController != null) {
                this.this$0.mImsServiceControllerBinder.unlinkToDeath(this.this$0.mImsDeathRecipient, 0);
            }
            this.this$0.notifyAllFeaturesRemoved();
            this.this$0.cleanUpService();
            Log.w("ImsServiceController", "ImsService(" + name + "): onServiceDisconnected. Rebinding...");
            this.this$0.startDelayedRebindToService();
        }

        private void __constructor__(ImsServiceController imsServiceController) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$__constructor__(imsServiceController);
        }

        ImsServiceConnection(ImsServiceController imsServiceController) {
            this.this$0 = imsServiceController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$__constructor__(com.android.internal.telephony.ims.ImsServiceController ), 0, this, imsServiceController);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsServiceConnection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        public /* synthetic */ ImsServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ImsDeathRecipient
    implements IBinder.DeathRecipient,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ComponentName mComponentName;
        /* synthetic */ ImsServiceController this$0;

        private void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$__constructor__(ImsServiceController this$0, ComponentName name) {
            this.mComponentName = name;
        }

        private final void $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$binderDied() {
            Log.e("ImsServiceController", "ImsService(" + this.mComponentName + ") died. Restarting...");
            this.this$0.notifyAllFeaturesRemoved();
            this.this$0.cleanUpService();
            this.this$0.startDelayedRebindToService();
        }

        private void __constructor__(ImsServiceController imsServiceController, ComponentName componentName) {
            this.$$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$__constructor__(imsServiceController, componentName);
        }

        ImsDeathRecipient(ImsServiceController imsServiceController, ComponentName componentName) {
            this.this$0 = imsServiceController;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$__constructor__(com.android.internal.telephony.ims.ImsServiceController android.content.ComponentName ), 0, this, imsServiceController, componentName);
        }

        @Override
        public void binderDied() {
            InvokeDynamicSupport.bootstrap("binderDied", $$robo$$com_android_internal_telephony_ims_ImsServiceController_ImsDeathRecipient$binderDied(), 0, this);
        }

        public /* synthetic */ ImsDeathRecipient() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ImsDeathRecipient)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

