/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.test;

import android.hardware.radio.V1_0.DataRegStateResult;
import android.hardware.radio.V1_0.VoiceRegStateResult;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.SystemClock;
import android.os.WorkSource;
import android.service.carrier.CarrierIdentifier;
import android.telephony.CellInfo;
import android.telephony.CellInfoGsm;
import android.telephony.ImsiEncryptionInfo;
import android.telephony.NetworkScanRequest;
import android.telephony.Rlog;
import android.telephony.SignalStrength;
import com.android.internal.telephony.BaseCommands;
import com.android.internal.telephony.CommandException;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.LastCallFailCause;
import com.android.internal.telephony.RadioCapability;
import com.android.internal.telephony.SmsResponse;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo;
import com.android.internal.telephony.dataconnection.DataCallResponse;
import com.android.internal.telephony.dataconnection.DataProfile;
import com.android.internal.telephony.gsm.SmsBroadcastConfigInfo;
import com.android.internal.telephony.gsm.SuppServiceNotification;
import com.android.internal.telephony.test.SimulatedCommandsVerifier;
import com.android.internal.telephony.test.SimulatedGsmCallState;
import com.android.internal.telephony.test.SimulatedRadioControl;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccIoResult;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SimulatedCommands
extends BaseCommands
implements CommandsInterface,
SimulatedRadioControl,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SimulatedCommands";
    private static SimLockState INITIAL_LOCK_STATE;
    public static String DEFAULT_SIM_PIN_CODE = "1234";
    private static String SIM_PUK_CODE = "12345678";
    private static SimFdnState INITIAL_FDN_STATE;
    public static String DEFAULT_SIM_PIN2_CODE = "5678";
    private static String SIM_PUK2_CODE = "87654321";
    public static String FAKE_LONG_NAME = "Fake long name";
    public static String FAKE_SHORT_NAME = "Fake short name";
    public static String FAKE_MCC_MNC = "310260";
    public static String FAKE_IMEI = "012345678901234";
    public static String FAKE_IMEISV = "99";
    public static String FAKE_ESN = "1234";
    public static String FAKE_MEID = "1234";
    public static int DEFAULT_PIN1_ATTEMPT = 5;
    public static int DEFAULT_PIN2_ATTEMPT = 5;
    private String mImei;
    private String mImeiSv;
    SimulatedGsmCallState simulatedCallState;
    HandlerThread mHandlerThread;
    SimLockState mSimLockedState;
    boolean mSimLockEnabled;
    int mPinUnlockAttempts;
    int mPukUnlockAttempts;
    String mPinCode;
    int mPin1attemptsRemaining;
    SimFdnState mSimFdnEnabledState;
    boolean mSimFdnEnabled;
    int mPin2UnlockAttempts;
    int mPuk2UnlockAttempts;
    int mNetworkType;
    String mPin2Code;
    boolean mSsnNotifyOn;
    private int mVoiceRegState;
    private int mVoiceRadioTech;
    private int mDataRegState;
    private int mDataRadioTech;
    private SignalStrength mSignalStrength;
    private List<CellInfo> mCellInfoList;
    private int[] mImsRegState;
    private IccCardStatus mIccCardStatus;
    private IccIoResult mIccIoResultForApduLogicalChannel;
    private int mChannelId;
    int mPausedResponseCount;
    ArrayList<Message> mPausedResponses;
    int mNextCallFailCause;
    private boolean mDcSuccess;
    private DataCallResponse mDcResponse;
    private AtomicInteger mGetVoiceRegistrationStateCallCount;
    private AtomicInteger mGetDataRegistrationStateCallCount;
    private AtomicInteger mGetOperatorCallCount;
    private AtomicInteger getNetworkSelectionModeCallCount;
    private AtomicBoolean mAllowed;

    private void $$robo$$com_android_internal_telephony_test_SimulatedCommands$__constructor__() {
        this.mPin1attemptsRemaining = 5;
        this.mSsnNotifyOn = false;
        this.mVoiceRegState = 1;
        this.mVoiceRadioTech = 3;
        this.mDataRegState = 1;
        this.mDataRadioTech = 3;
        this.mChannelId = -1;
        this.mPausedResponses = new ArrayList();
        this.mNextCallFailCause = 16;
        this.mDcSuccess = true;
        this.mGetVoiceRegistrationStateCallCount = new AtomicInteger(0);
        this.mGetDataRegistrationStateCallCount = new AtomicInteger(0);
        this.mGetOperatorCallCount = new AtomicInteger(0);
        this.getNetworkSelectionModeCallCount = new AtomicInteger(0);
        this.mAllowed = new AtomicBoolean(false);
        this.mHandlerThread = new HandlerThread("SimulatedCommands");
        this.mHandlerThread.start();
        Looper looper = this.mHandlerThread.getLooper();
        this.simulatedCallState = new SimulatedGsmCallState(looper);
        this.setRadioState(CommandsInterface.RadioState.RADIO_ON);
        this.mSimLockedState = INITIAL_LOCK_STATE;
        this.mSimLockEnabled = this.mSimLockedState != SimLockState.NONE;
        this.mPinCode = "1234";
        this.mSimFdnEnabledState = INITIAL_FDN_STATE;
        this.mSimFdnEnabled = this.mSimFdnEnabledState != SimFdnState.NONE;
        this.mPin2Code = "5678";
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$dispose() {
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$log(String str) {
        Rlog.d("SimulatedCommands", str);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIccCardStatus(Message result) {
        if (this.mIccCardStatus != null) {
            this.resultSuccess(result, this.mIccCardStatus);
        } else {
            this.resultFail(result, null, new RuntimeException("IccCardStatus not set"));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPin(String pin, Message result) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PIN) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (pin != null && pin.equals(this.mPinCode)) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin: success!");
            this.mPinUnlockAttempts = 0;
            this.mSimLockedState = SimLockState.NONE;
            this.mIccStatusChangedRegistrants.notifyRegistrants();
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPinUnlockAttempts;
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin: failed! attempt=" + this.mPinUnlockAttempts);
            if (this.mPinUnlockAttempts >= 5) {
                Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin: set state to REQUIRE_PUK");
                this.mSimLockedState = SimLockState.REQUIRE_PUK;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPuk(String puk, String newPin, Message result) {
        if (this.mSimLockedState != SimLockState.REQUIRE_PUK) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (puk != null && puk.equals("12345678")) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk: success!");
            this.mSimLockedState = SimLockState.NONE;
            this.mPukUnlockAttempts = 0;
            this.mIccStatusChangedRegistrants.notifyRegistrants();
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPukUnlockAttempts;
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk: failed! attempt=" + this.mPukUnlockAttempts);
            if (this.mPukUnlockAttempts >= 10) {
                Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk: set state to SIM_PERM_LOCKED");
                this.mSimLockedState = SimLockState.SIM_PERM_LOCKED;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPin2(String pin2, Message result) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PIN2) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin2: wrong state, state=" + (Object)((Object)this.mSimFdnEnabledState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (pin2 != null && pin2.equals(this.mPin2Code)) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin2: success!");
            this.mPin2UnlockAttempts = 0;
            this.mSimFdnEnabledState = SimFdnState.NONE;
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPin2UnlockAttempts;
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin2: failed! attempt=" + this.mPin2UnlockAttempts);
            if (this.mPin2UnlockAttempts >= 5) {
                Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPin2: set state to REQUIRE_PUK2");
                this.mSimFdnEnabledState = SimFdnState.REQUIRE_PUK2;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPuk2(String puk2, String newPin2, Message result) {
        if (this.mSimFdnEnabledState != SimFdnState.REQUIRE_PUK2) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk2: wrong state, state=" + (Object)((Object)this.mSimLockedState));
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
            return;
        }
        if (puk2 != null && puk2.equals("87654321")) {
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk2: success!");
            this.mSimFdnEnabledState = SimFdnState.NONE;
            this.mPuk2UnlockAttempts = 0;
            this.resultSuccess(result, null);
            return;
        }
        if (result != null) {
            ++this.mPuk2UnlockAttempts;
            Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk2: failed! attempt=" + this.mPuk2UnlockAttempts);
            if (this.mPuk2UnlockAttempts >= 10) {
                Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPuk2: set state to SIM_PERM_LOCKED");
                this.mSimFdnEnabledState = SimFdnState.SIM_PERM_LOCKED;
            }
            CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
            this.resultFail(result, null, ex);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPin(String oldPin, String newPin, Message result) {
        if (oldPin != null && oldPin.equals(this.mPinCode)) {
            this.mPinCode = newPin;
            this.resultSuccess(result, null);
            return;
        }
        Rlog.i("SimulatedCommands", "[SimCmd] changeIccPin: pin failed!");
        CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
        this.resultFail(result, null, ex);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPin2(String oldPin2, String newPin2, Message result) {
        if (oldPin2 != null && oldPin2.equals(this.mPin2Code)) {
            this.mPin2Code = newPin2;
            this.resultSuccess(result, null);
            return;
        }
        Rlog.i("SimulatedCommands", "[SimCmd] changeIccPin2: pin2 failed!");
        CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
        this.resultFail(result, null, ex);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeBarringPassword(String facility, String oldPwd, String newPwd, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSuppServiceNotifications(boolean enable, Message result) {
        this.resultSuccess(result, null);
        if (enable && this.mSsnNotifyOn) {
            Rlog.w("SimulatedCommands", "Supp Service Notifications already enabled!");
        }
        this.mSsnNotifyOn = enable;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryFacilityLock(String facility, String pin, int serviceClass, Message result) {
        this.queryFacilityLockForApp(facility, pin, serviceClass, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryFacilityLockForApp(String facility, String pin, int serviceClass, String appId, Message result) {
        if (facility != null && facility.equals("SC")) {
            if (result != null) {
                int[] r = new int[]{this.mSimLockEnabled ? 1 : 0};
                Rlog.i("SimulatedCommands", "[SimCmd] queryFacilityLock: SIM is " + (r[0] == 0 ? "unlocked" : "locked"));
                this.resultSuccess(result, r);
            }
            return;
        }
        if (facility != null && facility.equals("FD")) {
            if (result != null) {
                int[] r = new int[]{this.mSimFdnEnabled ? 1 : 0};
                Rlog.i("SimulatedCommands", "[SimCmd] queryFacilityLock: FDN is " + (r[0] == 0 ? "disabled" : "enabled"));
                this.resultSuccess(result, r);
            }
            return;
        }
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setFacilityLock(String facility, boolean lockEnabled, String pin, int serviceClass, Message result) {
        this.setFacilityLockForApp(facility, lockEnabled, pin, serviceClass, null, result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setFacilityLockForApp(String facility, boolean lockEnabled, String pin, int serviceClass, String appId, Message result) {
        if (facility != null && facility.equals("SC")) {
            if (pin != null && pin.equals(this.mPinCode)) {
                Rlog.i("SimulatedCommands", "[SimCmd] setFacilityLock: pin is valid");
                this.mSimLockEnabled = lockEnabled;
                this.resultSuccess(result, null);
                return;
            }
            Rlog.i("SimulatedCommands", "[SimCmd] setFacilityLock: pin failed!");
            CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
            this.resultFail(result, null, ex);
            return;
        }
        if (facility != null && facility.equals("FD")) {
            if (pin != null && pin.equals(this.mPin2Code)) {
                Rlog.i("SimulatedCommands", "[SimCmd] setFacilityLock: pin2 is valid");
                this.mSimFdnEnabled = lockEnabled;
                this.resultSuccess(result, null);
                return;
            }
            Rlog.i("SimulatedCommands", "[SimCmd] setFacilityLock: pin2 failed!");
            CommandException ex = new CommandException(CommandException.Error.GENERIC_FAILURE);
            this.resultFail(result, null, ex);
            return;
        }
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyNetworkDepersonalization(String netpin, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCurrentCalls(Message result) {
        SimulatedCommandsVerifier.getInstance().getCurrentCalls(result);
        if (this.mState == CommandsInterface.RadioState.RADIO_ON && !this.isSimLocked()) {
            this.resultSuccess(result, this.simulatedCallState.getDriverCalls());
        } else {
            this.resultFail(result, null, new CommandException(CommandException.Error.RADIO_NOT_AVAILABLE));
        }
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getPDPContextList(Message result) {
        this.getDataCallList(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getDataCallList(Message result) {
        this.resultSuccess(result, new ArrayList(0));
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$dial(String address, int clirMode, Message result) {
        SimulatedCommandsVerifier.getInstance().dial(address, clirMode, result);
        this.simulatedCallState.onDial(address);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$dial(String address, int clirMode, UUSInfo uusInfo, Message result) {
        SimulatedCommandsVerifier.getInstance().dial(address, clirMode, uusInfo, result);
        this.simulatedCallState.onDial(address);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMSI(Message result) {
        this.getIMSIForApp(null, result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMSIForApp(String aid, Message result) {
        this.resultSuccess(result, "012345678901234");
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIMEI(String imei) {
        this.mImei = imei;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMEI(Message result) {
        SimulatedCommandsVerifier.getInstance().getIMEI(result);
        this.resultSuccess(result, this.mImei != null ? this.mImei : FAKE_IMEI);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIMEISV(String imeisv) {
        this.mImeiSv = imeisv;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMEISV(Message result) {
        SimulatedCommandsVerifier.getInstance().getIMEISV(result);
        this.resultSuccess(result, this.mImeiSv != null ? this.mImeiSv : FAKE_IMEISV);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$hangupConnection(int gsmIndex, Message result) {
        boolean success = this.simulatedCallState.onChld('1', (char)(48 + gsmIndex));
        if (!success) {
            Rlog.i("GSM", "[SimCmd] hangupConnection: resultFail");
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            Rlog.i("GSM", "[SimCmd] hangupConnection: resultSuccess");
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$hangupWaitingOrBackground(Message result) {
        boolean success = this.simulatedCallState.onChld('0', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$hangupForegroundResumeBackground(Message result) {
        boolean success = this.simulatedCallState.onChld('1', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$switchWaitingOrHoldingAndActive(Message result) {
        boolean success = this.simulatedCallState.onChld('2', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$conference(Message result) {
        boolean success = this.simulatedCallState.onChld('3', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$explicitCallTransfer(Message result) {
        boolean success = this.simulatedCallState.onChld('4', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$separateConnection(int gsmIndex, Message result) {
        char ch = (char)(gsmIndex + 48);
        boolean success = this.simulatedCallState.onChld('2', ch);
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$acceptCall(Message result) {
        SimulatedCommandsVerifier.getInstance().acceptCall(result);
        boolean success = this.simulatedCallState.onAnswer();
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$rejectCall(Message result) {
        boolean success = this.simulatedCallState.onChld('0', '\u0000');
        if (!success) {
            this.resultFail(result, null, new RuntimeException("Hangup Error"));
        } else {
            this.resultSuccess(result, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getLastCallFailCause(Message result) {
        LastCallFailCause mFailCause = new LastCallFailCause();
        mFailCause.causeCode = this.mNextCallFailCause;
        this.resultSuccess(result, mFailCause);
    }

    @Deprecated
    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getLastPdpFailCause(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getLastDataCallFailCause(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setMute(boolean enableMute, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getMute(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSignalStrength(SignalStrength signalStrength) {
        this.mSignalStrength = signalStrength;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getSignalStrength(Message result) {
        if (this.mSignalStrength == null) {
            this.mSignalStrength = new SignalStrength(20, 0, -1, -1, -1, -1, -1, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }
        this.resultSuccess(result, this.mSignalStrength);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setBandMode(int bandMode, Message result) {
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryAvailableBandMode(Message result) {
        int[] ret = new int[]{4, 2, 3, 4};
        this.resultSuccess(result, ret);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendTerminalResponse(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendEnvelope(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendEnvelopeWithStatus(String contents, Message response) {
        this.resultSuccess(response, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$handleCallSetupRequestFromSim(boolean accept, Message response) {
        this.resultSuccess(response, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setVoiceRadioTech(int voiceRadioTech) {
        this.mVoiceRadioTech = voiceRadioTech;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setVoiceRegState(int voiceRegState) {
        this.mVoiceRegState = voiceRegState;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getVoiceRegistrationState(Message result) {
        this.mGetVoiceRegistrationStateCallCount.incrementAndGet();
        VoiceRegStateResult ret = new VoiceRegStateResult();
        ret.regState = this.mVoiceRegState;
        ret.rat = this.mVoiceRadioTech;
        this.resultSuccess(result, ret);
    }

    private final int $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetVoiceRegistrationStateCallCount() {
        return this.mGetVoiceRegistrationStateCallCount.get();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataRadioTech(int radioTech) {
        this.mDataRadioTech = radioTech;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataRegState(int dataRegState) {
        this.mDataRegState = dataRegState;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getDataRegistrationState(Message result) {
        this.mGetDataRegistrationStateCallCount.incrementAndGet();
        DataRegStateResult ret = new DataRegStateResult();
        ret.regState = this.mDataRegState;
        ret.rat = this.mDataRadioTech;
        this.resultSuccess(result, ret);
    }

    private final int $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetDataRegistrationStateCallCount() {
        return this.mGetDataRegistrationStateCallCount.get();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getOperator(Message result) {
        this.mGetOperatorCallCount.incrementAndGet();
        String[] ret = new String[]{"Fake long name", "Fake short name", "310260"};
        this.resultSuccess(result, ret);
    }

    private final int $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetOperatorCallCount() {
        int count = this.mGetOperatorCallCount.get();
        return this.mGetOperatorCallCount.get();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendDtmf(char c, Message result) {
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$startDtmf(char c, Message result) {
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$stopDtmf(Message result) {
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendBurstDtmf(String dtmfString, int on, int off, Message result) {
        SimulatedCommandsVerifier.getInstance().sendBurstDtmf(dtmfString, on, off, result);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendSMS(String smscPDU, String pdu, Message result) {
        SimulatedCommandsVerifier.getInstance().sendSMS(smscPDU, pdu, result);
        this.resultSuccess(result, new SmsResponse(0, null, 0));
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendSMSExpectMore(String smscPDU, String pdu, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$deleteSmsOnSim(int index, Message response) {
        Rlog.d("SimulatedCommands", "Delete message at index " + index);
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$deleteSmsOnRuim(int index, Message response) {
        Rlog.d("SimulatedCommands", "Delete RUIM message at index " + index);
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$writeSmsToSim(int status, String smsc, String pdu, Message response) {
        Rlog.d("SimulatedCommands", "Write SMS to SIM with status " + status);
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$writeSmsToRuim(int status, String pdu, Message response) {
        Rlog.d("SimulatedCommands", "Write SMS to RUIM with status " + status);
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataCallResponse(boolean success, DataCallResponse dcResponse) {
        this.mDcResponse = dcResponse;
        this.mDcSuccess = success;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerNITZupdate(String NITZStr) {
        if (NITZStr != null) {
            this.mNITZTimeRegistrant.notifyRegistrant(new AsyncResult(null, new Object[]{NITZStr, SystemClock.elapsedRealtime()}, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setupDataCall(int radioTechnology, DataProfile dataProfile, boolean isRoaming, boolean allowRoaming, Message result) {
        SimulatedCommandsVerifier.getInstance().setupDataCall(radioTechnology, dataProfile, isRoaming, allowRoaming, result);
        if (this.mDcResponse == null) {
            this.mDcResponse = new DataCallResponse(0, -1, 1, 2, "IP", "rmnet_data7", "12.34.56.78", "98.76.54.32", "11.22.33.44", "", 1440);
        }
        if (this.mDcSuccess) {
            this.resultSuccess(result, this.mDcResponse);
        } else {
            this.resultFail(result, this.mDcResponse, new RuntimeException("Setup data call failed!"));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$deactivateDataCall(int cid, int reason, Message result) {
        SimulatedCommandsVerifier.getInstance().deactivateDataCall(cid, reason, result);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPreferredNetworkType(int networkType, Message result) {
        SimulatedCommandsVerifier.getInstance().setPreferredNetworkType(networkType, result);
        this.mNetworkType = networkType;
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getPreferredNetworkType(Message result) {
        SimulatedCommandsVerifier.getInstance().getPreferredNetworkType(result);
        int[] ret = new int[]{this.mNetworkType};
        this.resultSuccess(result, ret);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getNeighboringCids(Message result, WorkSource workSource) {
        int[] ret = new int[7];
        ret[0] = 6;
        for (int i = 1; i < 7; ++i) {
            ret[i] = i;
        }
        this.resultSuccess(result, ret);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setLocationUpdates(boolean enable, Message response) {
        SimulatedCommandsVerifier.getInstance().setLocationUpdates(enable, response);
        this.resultSuccess(response, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getSmscAddress(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSmscAddress(String address, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$reportSmsMemoryStatus(boolean available, Message result) {
        this.resultSuccess(result, null);
        SimulatedCommandsVerifier.getInstance().reportSmsMemoryStatus(available, result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$reportStkServiceIsRunning(Message result) {
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCdmaSubscriptionSource(Message result) {
        this.unimplemented(result);
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedCommands$isSimLocked() {
        return this.mSimLockedState != SimLockState.NONE;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setRadioPower(boolean on, Message result) {
        if (on) {
            this.setRadioState(CommandsInterface.RadioState.RADIO_ON);
        } else {
            this.setRadioState(CommandsInterface.RadioState.RADIO_OFF);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$acknowledgeLastIncomingGsmSms(boolean success, int cause, Message result) {
        this.unimplemented(result);
        SimulatedCommandsVerifier.getInstance().acknowledgeLastIncomingGsmSms(success, cause, result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$acknowledgeLastIncomingCdmaSms(boolean success, int cause, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$acknowledgeIncomingGsmSmsWithPdu(boolean success, String ackPdu, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccIO(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, Message response) {
        this.iccIOForApp(command, fileid, path, p1, p2, p3, data, pin2, null, response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccIOForApp(int command, int fileid, String path, int p1, int p2, int p3, String data, String pin2, String aid, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCLIP(Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCLIR(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCLIR(int clirMode, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCallWaiting(int serviceClass, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCallWaiting(boolean enable, int serviceClass, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCallForward(int action, int cfReason, int serviceClass, String number, int timeSeconds, Message result) {
        SimulatedCommandsVerifier.getInstance().setCallForward(action, cfReason, serviceClass, number, timeSeconds, result);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCallForwardStatus(int cfReason, int serviceClass, String number, Message result) {
        SimulatedCommandsVerifier.getInstance().queryCallForwardStatus(cfReason, serviceClass, number, result);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNetworkSelectionModeAutomatic(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$exitEmergencyCallbackMode(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNetworkSelectionModeManual(String operatorNumeric, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getNetworkSelectionMode(Message result) {
        SimulatedCommandsVerifier.getInstance().getNetworkSelectionMode(result);
        this.getNetworkSelectionModeCallCount.incrementAndGet();
        int[] ret = new int[]{0};
        this.resultSuccess(result, ret);
    }

    private final int $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetNetworkSelectionModeCallCount() {
        return this.getNetworkSelectionModeCallCount.get();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getAvailableNetworks(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$startNetworkScan(NetworkScanRequest nsr, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$stopNetworkScan(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getBasebandVersion(Message result) {
        SimulatedCommandsVerifier.getInstance().getBasebandVersion(result);
        this.resultSuccess(result, "SimulatedCommands");
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerIncomingStkCcAlpha(String alphaString) {
        if (this.mCatCcAlphaRegistrant != null) {
            this.mCatCcAlphaRegistrant.notifyResult(alphaString);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendStkCcAplha(String alphaString) {
        this.triggerIncomingStkCcAlpha(alphaString);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerIncomingUssd(String statusCode, String message) {
        if (this.mUSSDRegistrant != null) {
            String[] result = new String[]{statusCode, message};
            this.mUSSDRegistrant.notifyResult(result);
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendUSSD(String ussdString, Message result) {
        if (ussdString.equals("#646#")) {
            this.resultSuccess(result, null);
            this.triggerIncomingUssd("0", "You have NNN minutes remaining.");
        } else {
            this.resultSuccess(result, null);
            this.triggerIncomingUssd("0", "All Done");
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$cancelPendingUssd(Message response) {
        this.resultSuccess(response, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$resetRadio(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$invokeOemRilRequestRaw(byte[] data, Message response) {
        if (response != null) {
            AsyncResult.forMessage((Message)response).result = data;
            response.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo, Message response) {
        if (response != null) {
            AsyncResult.forMessage((Message)response).result = imsiEncryptionInfo;
            response.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$invokeOemRilRequestStrings(String[] strings, Message response) {
        if (response != null) {
            AsyncResult.forMessage((Message)response).result = strings;
            response.sendToTarget();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerRing(String number) {
        this.simulatedCallState.triggerRing(number);
        this.mCallStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$progressConnectingCallState() {
        this.simulatedCallState.progressConnectingCallState();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$progressConnectingToActive() {
        this.simulatedCallState.progressConnectingToActive();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setAutoProgressConnectingCall(boolean b) {
        this.simulatedCallState.setAutoProgressConnectingCall(b);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNextDialFailImmediately(boolean b) {
        this.simulatedCallState.setNextDialFailImmediately(b);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNextCallFailCause(int gsmCause) {
        this.mNextCallFailCause = gsmCause;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerHangupForeground() {
        this.simulatedCallState.triggerHangupForeground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerHangupBackground() {
        this.simulatedCallState.triggerHangupBackground();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerSsn(int type, int code) {
        SuppServiceNotification not = new SuppServiceNotification();
        not.notificationType = type;
        not.code = code;
        this.mSsnRegistrant.notifyRegistrant(new AsyncResult(null, not, null));
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$shutdown() {
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
        Looper looper = this.mHandlerThread.getLooper();
        if (looper != null) {
            looper.quit();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerHangupAll() {
        this.simulatedCallState.triggerHangupAll();
        this.mCallStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerIncomingSMS(String message) {
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$pauseResponses() {
        ++this.mPausedResponseCount;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$resumeResponses() {
        --this.mPausedResponseCount;
        if (this.mPausedResponseCount == 0) {
            int s = this.mPausedResponses.size();
            for (int i = 0; i < s; ++i) {
                this.mPausedResponses.get(i).sendToTarget();
            }
            this.mPausedResponses.clear();
        } else {
            Rlog.e("GSM", "SimulatedCommands.resumeResponses < 0");
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$unimplemented(Message result) {
        if (result != null) {
            AsyncResult.forMessage((Message)result).exception = new RuntimeException("Unimplemented");
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$resultSuccess(Message result, Object ret) {
        if (result != null) {
            AsyncResult.forMessage((Message)result).result = ret;
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$resultFail(Message result, Object ret, Throwable tr) {
        if (result != null) {
            AsyncResult.forMessage(result, ret, tr);
            if (this.mPausedResponseCount > 0) {
                this.mPausedResponses.add(result);
            } else {
                result.sendToTarget();
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getDeviceIdentity(Message response) {
        SimulatedCommandsVerifier.getInstance().getDeviceIdentity(response);
        this.resultSuccess(response, new String[]{"012345678901234", "99", "1234", "1234"});
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCDMASubscription(Message result) {
        String[] ret = new String[]{"123", "456", "789", "234", "345"};
        this.resultSuccess(result, ret);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaSubscriptionSource(int cdmaSubscriptionType, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCdmaRoamingPreference(Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaRoamingPreference(int cdmaRoamingType, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPhoneType(int phoneType) {
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getPreferredVoicePrivacy(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPreferredVoicePrivacy(boolean enable, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setTTYMode(int ttyMode, Message response) {
        Rlog.w("SimulatedCommands", "Not implemented in SimulatedCommands");
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryTTYMode(Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendCDMAFeatureCode(String FeatureCode, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendCdmaSms(byte[] pdu, Message response) {
        SimulatedCommandsVerifier.getInstance().sendCdmaSms(pdu, response);
        this.resultSuccess(response, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaBroadcastActivation(boolean activate, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCdmaBroadcastConfig(Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] configs, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$forceDataDormancy(Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setGsmBroadcastActivation(boolean activate, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setGsmBroadcastConfig(SmsBroadcastConfigInfo[] config, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGsmBroadcastConfig(Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPinForApp(String pin, String aid, Message response) {
        SimulatedCommandsVerifier.getInstance().supplyIccPinForApp(pin, aid, response);
        if (this.mPinCode != null && this.mPinCode.equals(pin)) {
            this.resultSuccess(response, null);
            return;
        }
        Rlog.i("SimulatedCommands", "[SimCmd] supplyIccPinForApp: pin failed!");
        CommandException ex = new CommandException(CommandException.Error.PASSWORD_INCORRECT);
        this.resultFail(response, new int[]{--this.mPin1attemptsRemaining < 0 ? 0 : this.mPin1attemptsRemaining}, ex);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPukForApp(String puk, String newPin, String aid, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPin2ForApp(String pin2, String aid, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPuk2ForApp(String puk2, String newPin2, String aid, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPinForApp(String oldPin, String newPin, String aidPtr, Message response) {
        SimulatedCommandsVerifier.getInstance().changeIccPinForApp(oldPin, newPin, aidPtr, response);
        this.changeIccPin(oldPin, newPin, response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPin2ForApp(String oldPin2, String newPin2, String aidPtr, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$requestIsimAuthentication(String nonce, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$requestIccSimAuthentication(int authContext, String data, String aid, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getVoiceRadioTechnology(Message response) {
        SimulatedCommandsVerifier.getInstance().getVoiceRadioTechnology(response);
        int[] ret = new int[]{this.mVoiceRadioTech};
        this.resultSuccess(response, ret);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCellInfoList(List<CellInfo> list) {
        this.mCellInfoList = list;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCellInfoList(Message response, WorkSource WorkSource2) {
        if (this.mCellInfoList == null) {
            Parcel p = Parcel.obtain();
            p.writeInt(1);
            p.writeInt(1);
            p.writeInt(2);
            p.writeLong(1453510289108L);
            p.writeInt(310);
            p.writeInt(260);
            p.writeInt(123);
            p.writeInt(456);
            p.writeInt(99);
            p.writeInt(3);
            p.setDataPosition(0);
            CellInfoGsm cellInfo = CellInfoGsm.CREATOR.createFromParcel(p);
            ArrayList<CellInfoGsm> mCellInfoList = new ArrayList<CellInfoGsm>();
            mCellInfoList.add(cellInfo);
        }
        this.resultSuccess(response, this.mCellInfoList);
    }

    private final int $$robo$$com_android_internal_telephony_test_SimulatedCommands$getRilVersion() {
        return 11;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCellInfoListRate(int rateInMillis, Message response, WorkSource workSource) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setInitialAttachApn(DataProfile dataProfile, boolean isRoaming, Message result) {
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataProfile(DataProfile[] dps, boolean isRoaming, Message result) {
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setImsRegistrationState(int[] regState) {
        this.mImsRegState = regState;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getImsRegistrationState(Message response) {
        if (this.mImsRegState == null) {
            this.mImsRegState = new int[]{1, 0};
        }
        this.resultSuccess(response, this.mImsRegState);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendImsCdmaSms(byte[] pdu, int retry, int messageRef, Message response) {
        SimulatedCommandsVerifier.getInstance().sendImsCdmaSms(pdu, retry, messageRef, response);
        this.resultSuccess(response, new SmsResponse(0, null, 0));
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendImsGsmSms(String smscPDU, String pdu, int retry, int messageRef, Message response) {
        SimulatedCommandsVerifier.getInstance().sendImsGsmSms(smscPDU, pdu, retry, messageRef, response);
        this.resultSuccess(response, new SmsResponse(0, null, 0));
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccOpenLogicalChannel(String AID, int p2, Message response) {
        SimulatedCommandsVerifier.getInstance().iccOpenLogicalChannel(AID, p2, response);
        int[] result = new int[]{this.mChannelId};
        this.resultSuccess(response, result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccCloseLogicalChannel(int channel, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        SimulatedCommandsVerifier.getInstance().iccTransmitApduLogicalChannel(channel, cla, instruction, p1, p2, p3, data, response);
        if (this.mIccIoResultForApduLogicalChannel != null) {
            this.resultSuccess(response, this.mIccIoResultForApduLogicalChannel);
        } else {
            this.resultFail(response, null, new RuntimeException("IccIoResult not set"));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvReadItem(int itemID, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvWriteItem(int itemID, String itemValue, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvWriteCdmaPrl(byte[] preferredRoamingList, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvResetConfig(int resetType, Message response) {
        this.unimplemented(response);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getHardwareConfig(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$requestShutdown(Message result) {
        this.setRadioState(CommandsInterface.RadioState.RADIO_UNAVAILABLE);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$startLceService(int report_interval_ms, boolean pullMode, Message result) {
        SimulatedCommandsVerifier.getInstance().startLceService(report_interval_ms, pullMode, result);
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$stopLceService(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$pullLceData(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getModemActivityInfo(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setAllowedCarriers(List<CarrierIdentifier> carriers, Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getAllowedCarriers(Message result) {
        this.unimplemented(result);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$getRadioCapability(Message result) {
        SimulatedCommandsVerifier.getInstance().getRadioCapability(result);
        this.resultSuccess(result, new RadioCapability(0, 0, 0, 65535, null, 0));
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifySmsStatus(Object result) {
        if (this.mSmsStatusRegistrant != null) {
            this.mSmsStatusRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyGsmBroadcastSms(Object result) {
        if (this.mGsmBroadcastSmsRegistrant != null) {
            this.mGsmBroadcastSmsRegistrant.notifyRegistrant(new AsyncResult(null, result, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyIccSmsFull() {
        if (this.mIccSmsFullRegistrant != null) {
            this.mIccSmsFullRegistrant.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyEmergencyCallbackMode() {
        if (this.mEmergencyCallbackModeRegistrant != null) {
            this.mEmergencyCallbackModeRegistrant.notifyRegistrant();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setEmergencyCallbackMode(Handler h, int what, Object obj) {
        SimulatedCommandsVerifier.getInstance().setEmergencyCallbackMode(h, what, obj);
        super.setEmergencyCallbackMode(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyExitEmergencyCallbackMode() {
        if (this.mExitEmergencyCallbackModeRegistrants != null) {
            this.mExitEmergencyCallbackModeRegistrants.notifyRegistrants(new AsyncResult(null, null, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyImsNetworkStateChanged() {
        if (this.mImsNetworkStateChangedRegistrants != null) {
            this.mImsNetworkStateChangedRegistrants.notifyRegistrants();
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyModemReset() {
        if (this.mModemResetRegistrants != null) {
            this.mModemResetRegistrants.notifyRegistrants(new AsyncResult(null, "Test", null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$registerForExitEmergencyCallbackMode(Handler h, int what, Object obj) {
        SimulatedCommandsVerifier.getInstance().registerForExitEmergencyCallbackMode(h, what, obj);
        super.registerForExitEmergencyCallbackMode(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyRadioOn() {
        this.mOnRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyNetworkStateChanged() {
        this.mNetworkStateRegistrants.notifyRegistrants();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyOtaProvisionStatusChanged() {
        if (this.mOtaProvisionRegistrants != null) {
            int[] ret = new int[]{8};
            this.mOtaProvisionRegistrants.notifyRegistrants(new AsyncResult(null, ret, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifySignalStrength() {
        if (this.mSignalStrength == null) {
            this.mSignalStrength = new SignalStrength(20, 0, -1, -1, -1, -1, -1, 99, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, true);
        }
        if (this.mSignalStrengthRegistrant != null) {
            this.mSignalStrengthRegistrant.notifyRegistrant(new AsyncResult(null, this.mSignalStrength, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIccCardStatus(IccCardStatus iccCardStatus) {
        this.mIccCardStatus = iccCardStatus;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIccIoResultForApduLogicalChannel(IccIoResult iccIoResult) {
        this.mIccIoResultForApduLogicalChannel = iccIoResult;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setOpenChannelId(int channelId) {
        this.mChannelId = channelId;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPin1RemainingAttempt(int pin1attemptsRemaining) {
        this.mPin1attemptsRemaining = pin1attemptsRemaining;
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataAllowed(boolean allowed, Message result) {
        this.log("setDataAllowed = " + allowed);
        this.mAllowed.set(allowed);
        this.resultSuccess(result, null);
    }

    private final boolean $$robo$$com_android_internal_telephony_test_SimulatedCommands$isDataAllowed() {
        return this.mAllowed.get();
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$registerForPcoData(Handler h, int what, Object obj) {
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$unregisterForPcoData(Handler h) {
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$registerForModemReset(Handler h, int what, Object obj) {
        SimulatedCommandsVerifier.getInstance().registerForModemReset(h, what, obj);
        super.registerForModemReset(h, what, obj);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendDeviceState(int stateType, boolean state, Message result) {
        SimulatedCommandsVerifier.getInstance().sendDeviceState(stateType, state, result);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setUnsolResponseFilter(int filter, Message result) {
        SimulatedCommandsVerifier.getInstance().setUnsolResponseFilter(filter, result);
        this.resultSuccess(result, null);
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSimCardPower(int state, Message result) {
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerRestrictedStateChanged(int restrictedState) {
        if (this.mRestrictedStateRegistrant != null) {
            this.mRestrictedStateRegistrant.notifyRegistrant(new AsyncResult(null, restrictedState, null));
        }
    }

    private final void $$robo$$com_android_internal_telephony_test_SimulatedCommands$setOnRestrictedStateChanged(Handler h, int what, Object obj) {
        super.setOnRestrictedStateChanged(h, what, obj);
        SimulatedCommandsVerifier.getInstance().setOnRestrictedStateChanged(h, what, obj);
    }

    static void __staticInitializer__() {
        INITIAL_LOCK_STATE = SimLockState.NONE;
        INITIAL_FDN_STATE = SimFdnState.NONE;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_telephony_test_SimulatedCommands$__constructor__();
    }

    public SimulatedCommands() {
        super(null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_test_SimulatedCommands$__constructor__(), 0, this);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_test_SimulatedCommands$dispose(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_test_SimulatedCommands$log(java.lang.String ), 0, this, string2);
    }

    @Override
    public void getIccCardStatus(Message message) {
        InvokeDynamicSupport.bootstrap("getIccCardStatus", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIccCardStatus(android.os.Message ), 0, this, message);
    }

    @Override
    public void supplyIccPin(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPin(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyIccPuk(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPuk(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyIccPin2(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin2", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPin2(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyIccPuk2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk2", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPuk2(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void changeIccPin(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin", $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPin(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void changeIccPin2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin2", $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPin2(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void changeBarringPassword(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeBarringPassword", $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeBarringPassword(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void setSuppServiceNotifications(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setSuppServiceNotifications", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSuppServiceNotifications(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void queryFacilityLock(String string2, String string3, int n, Message message) {
        InvokeDynamicSupport.bootstrap("queryFacilityLock", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryFacilityLock(java.lang.String java.lang.String int android.os.Message ), 0, this, string2, string3, n, message);
    }

    @Override
    public void queryFacilityLockForApp(String string2, String string3, int n, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("queryFacilityLockForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryFacilityLockForApp(java.lang.String java.lang.String int java.lang.String android.os.Message ), 0, this, string2, string3, n, string4, message);
    }

    @Override
    public void setFacilityLock(String string2, boolean bl, String string3, int n, Message message) {
        InvokeDynamicSupport.bootstrap("setFacilityLock", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setFacilityLock(java.lang.String boolean java.lang.String int android.os.Message ), 0, this, string2, bl, string3, n, message);
    }

    @Override
    public void setFacilityLockForApp(String string2, boolean bl, String string3, int n, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("setFacilityLockForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setFacilityLockForApp(java.lang.String boolean java.lang.String int java.lang.String android.os.Message ), 0, this, string2, bl, string3, n, string4, message);
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyNetworkDepersonalization", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyNetworkDepersonalization(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void getCurrentCalls(Message message) {
        InvokeDynamicSupport.bootstrap("getCurrentCalls", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCurrentCalls(android.os.Message ), 0, this, message);
    }

    @Override
    @Deprecated
    public void getPDPContextList(Message message) {
        InvokeDynamicSupport.bootstrap("getPDPContextList", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getPDPContextList(android.os.Message ), 0, this, message);
    }

    @Override
    public void getDataCallList(Message message) {
        InvokeDynamicSupport.bootstrap("getDataCallList", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getDataCallList(android.os.Message ), 0, this, message);
    }

    @Override
    public void dial(String string2, int n, Message message) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_test_SimulatedCommands$dial(java.lang.String int android.os.Message ), 0, this, string2, n, message);
    }

    @Override
    public void dial(String string2, int n, UUSInfo uUSInfo, Message message) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$com_android_internal_telephony_test_SimulatedCommands$dial(java.lang.String int com.android.internal.telephony.UUSInfo android.os.Message ), 0, this, string2, n, uUSInfo, message);
    }

    @Override
    public void getIMSI(Message message) {
        InvokeDynamicSupport.bootstrap("getIMSI", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMSI(android.os.Message ), 0, this, message);
    }

    @Override
    public void getIMSIForApp(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("getIMSIForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMSIForApp(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    public void setIMEI(String string2) {
        InvokeDynamicSupport.bootstrap("setIMEI", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIMEI(java.lang.String ), 0, this, string2);
    }

    @Override
    public void getIMEI(Message message) {
        InvokeDynamicSupport.bootstrap("getIMEI", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMEI(android.os.Message ), 0, this, message);
    }

    public void setIMEISV(String string2) {
        InvokeDynamicSupport.bootstrap("setIMEISV", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIMEISV(java.lang.String ), 0, this, string2);
    }

    @Override
    public void getIMEISV(Message message) {
        InvokeDynamicSupport.bootstrap("getIMEISV", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getIMEISV(android.os.Message ), 0, this, message);
    }

    @Override
    public void hangupConnection(int n, Message message) {
        InvokeDynamicSupport.bootstrap("hangupConnection", $$robo$$com_android_internal_telephony_test_SimulatedCommands$hangupConnection(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void hangupWaitingOrBackground(Message message) {
        InvokeDynamicSupport.bootstrap("hangupWaitingOrBackground", $$robo$$com_android_internal_telephony_test_SimulatedCommands$hangupWaitingOrBackground(android.os.Message ), 0, this, message);
    }

    @Override
    public void hangupForegroundResumeBackground(Message message) {
        InvokeDynamicSupport.bootstrap("hangupForegroundResumeBackground", $$robo$$com_android_internal_telephony_test_SimulatedCommands$hangupForegroundResumeBackground(android.os.Message ), 0, this, message);
    }

    @Override
    public void switchWaitingOrHoldingAndActive(Message message) {
        InvokeDynamicSupport.bootstrap("switchWaitingOrHoldingAndActive", $$robo$$com_android_internal_telephony_test_SimulatedCommands$switchWaitingOrHoldingAndActive(android.os.Message ), 0, this, message);
    }

    @Override
    public void conference(Message message) {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$com_android_internal_telephony_test_SimulatedCommands$conference(android.os.Message ), 0, this, message);
    }

    @Override
    public void explicitCallTransfer(Message message) {
        InvokeDynamicSupport.bootstrap("explicitCallTransfer", $$robo$$com_android_internal_telephony_test_SimulatedCommands$explicitCallTransfer(android.os.Message ), 0, this, message);
    }

    @Override
    public void separateConnection(int n, Message message) {
        InvokeDynamicSupport.bootstrap("separateConnection", $$robo$$com_android_internal_telephony_test_SimulatedCommands$separateConnection(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void acceptCall(Message message) {
        InvokeDynamicSupport.bootstrap("acceptCall", $$robo$$com_android_internal_telephony_test_SimulatedCommands$acceptCall(android.os.Message ), 0, this, message);
    }

    @Override
    public void rejectCall(Message message) {
        InvokeDynamicSupport.bootstrap("rejectCall", $$robo$$com_android_internal_telephony_test_SimulatedCommands$rejectCall(android.os.Message ), 0, this, message);
    }

    @Override
    public void getLastCallFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastCallFailCause", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getLastCallFailCause(android.os.Message ), 0, this, message);
    }

    @Override
    @Deprecated
    public void getLastPdpFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastPdpFailCause", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getLastPdpFailCause(android.os.Message ), 0, this, message);
    }

    @Override
    public void getLastDataCallFailCause(Message message) {
        InvokeDynamicSupport.bootstrap("getLastDataCallFailCause", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getLastDataCallFailCause(android.os.Message ), 0, this, message);
    }

    @Override
    public void setMute(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setMute", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setMute(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getMute(Message message) {
        InvokeDynamicSupport.bootstrap("getMute", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getMute(android.os.Message ), 0, this, message);
    }

    public void setSignalStrength(SignalStrength signalStrength) {
        InvokeDynamicSupport.bootstrap("setSignalStrength", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSignalStrength(android.telephony.SignalStrength ), 0, this, signalStrength);
    }

    @Override
    public void getSignalStrength(Message message) {
        InvokeDynamicSupport.bootstrap("getSignalStrength", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getSignalStrength(android.os.Message ), 0, this, message);
    }

    @Override
    public void setBandMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setBandMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setBandMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryAvailableBandMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryAvailableBandMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryAvailableBandMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void sendTerminalResponse(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendTerminalResponse", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendTerminalResponse(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void sendEnvelope(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelope", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendEnvelope(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void sendEnvelopeWithStatus(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendEnvelopeWithStatus(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void handleCallSetupRequestFromSim(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("handleCallSetupRequestFromSim", $$robo$$com_android_internal_telephony_test_SimulatedCommands$handleCallSetupRequestFromSim(boolean android.os.Message ), 0, this, bl, message);
    }

    public void setVoiceRadioTech(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceRadioTech", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setVoiceRadioTech(int ), 0, this, n);
    }

    public void setVoiceRegState(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceRegState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setVoiceRegState(int ), 0, this, n);
    }

    @Override
    public void getVoiceRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getVoiceRegistrationState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getVoiceRegistrationState(android.os.Message ), 0, this, message);
    }

    public int getGetVoiceRegistrationStateCallCount() {
        return (int)InvokeDynamicSupport.bootstrap("getGetVoiceRegistrationStateCallCount", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetVoiceRegistrationStateCallCount(), 0, this);
    }

    public void setDataRadioTech(int n) {
        InvokeDynamicSupport.bootstrap("setDataRadioTech", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataRadioTech(int ), 0, this, n);
    }

    public void setDataRegState(int n) {
        InvokeDynamicSupport.bootstrap("setDataRegState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataRegState(int ), 0, this, n);
    }

    @Override
    public void getDataRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getDataRegistrationState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getDataRegistrationState(android.os.Message ), 0, this, message);
    }

    public int getGetDataRegistrationStateCallCount() {
        return (int)InvokeDynamicSupport.bootstrap("getGetDataRegistrationStateCallCount", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetDataRegistrationStateCallCount(), 0, this);
    }

    @Override
    public void getOperator(Message message) {
        InvokeDynamicSupport.bootstrap("getOperator", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getOperator(android.os.Message ), 0, this, message);
    }

    public int getGetOperatorCallCount() {
        return (int)InvokeDynamicSupport.bootstrap("getGetOperatorCallCount", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetOperatorCallCount(), 0, this);
    }

    @Override
    public void sendDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("sendDtmf", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendDtmf(char android.os.Message ), 0, this, c, message);
    }

    @Override
    public void startDtmf(char c, Message message) {
        InvokeDynamicSupport.bootstrap("startDtmf", $$robo$$com_android_internal_telephony_test_SimulatedCommands$startDtmf(char android.os.Message ), 0, this, c, message);
    }

    @Override
    public void stopDtmf(Message message) {
        InvokeDynamicSupport.bootstrap("stopDtmf", $$robo$$com_android_internal_telephony_test_SimulatedCommands$stopDtmf(android.os.Message ), 0, this, message);
    }

    @Override
    public void sendBurstDtmf(String string2, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendBurstDtmf", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendBurstDtmf(java.lang.String int int android.os.Message ), 0, this, string2, n, n2, message);
    }

    @Override
    public void sendSMS(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("sendSMS", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendSMS(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void sendSMSExpectMore(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("sendSMSExpectMore", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendSMSExpectMore(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void deleteSmsOnSim(int n, Message message) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnSim", $$robo$$com_android_internal_telephony_test_SimulatedCommands$deleteSmsOnSim(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void deleteSmsOnRuim(int n, Message message) {
        InvokeDynamicSupport.bootstrap("deleteSmsOnRuim", $$robo$$com_android_internal_telephony_test_SimulatedCommands$deleteSmsOnRuim(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void writeSmsToSim(int n, String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("writeSmsToSim", $$robo$$com_android_internal_telephony_test_SimulatedCommands$writeSmsToSim(int java.lang.String java.lang.String android.os.Message ), 0, this, n, string2, string3, message);
    }

    @Override
    public void writeSmsToRuim(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("writeSmsToRuim", $$robo$$com_android_internal_telephony_test_SimulatedCommands$writeSmsToRuim(int java.lang.String android.os.Message ), 0, this, n, string2, message);
    }

    public void setDataCallResponse(boolean bl, DataCallResponse dataCallResponse) {
        InvokeDynamicSupport.bootstrap("setDataCallResponse", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataCallResponse(boolean com.android.internal.telephony.dataconnection.DataCallResponse ), 0, this, bl, dataCallResponse);
    }

    public void triggerNITZupdate(String string2) {
        InvokeDynamicSupport.bootstrap("triggerNITZupdate", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerNITZupdate(java.lang.String ), 0, this, string2);
    }

    @Override
    public void setupDataCall(int n, DataProfile dataProfile, boolean bl, boolean bl2, Message message) {
        InvokeDynamicSupport.bootstrap("setupDataCall", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setupDataCall(int com.android.internal.telephony.dataconnection.DataProfile boolean boolean android.os.Message ), 0, this, n, dataProfile, bl, bl2, message);
    }

    @Override
    public void deactivateDataCall(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("deactivateDataCall", $$robo$$com_android_internal_telephony_test_SimulatedCommands$deactivateDataCall(int int android.os.Message ), 0, this, n, n2, message);
    }

    @Override
    public void setPreferredNetworkType(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPreferredNetworkType(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getPreferredNetworkType(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getPreferredNetworkType(android.os.Message ), 0, this, message);
    }

    @Override
    public void getNeighboringCids(Message message, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("getNeighboringCids", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getNeighboringCids(android.os.Message android.os.WorkSource ), 0, this, message, workSource);
    }

    @Override
    public void setLocationUpdates(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setLocationUpdates", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setLocationUpdates(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getSmscAddress(Message message) {
        InvokeDynamicSupport.bootstrap("getSmscAddress", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getSmscAddress(android.os.Message ), 0, this, message);
    }

    @Override
    public void setSmscAddress(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setSmscAddress", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSmscAddress(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void reportSmsMemoryStatus(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("reportSmsMemoryStatus", $$robo$$com_android_internal_telephony_test_SimulatedCommands$reportSmsMemoryStatus(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void reportStkServiceIsRunning(Message message) {
        InvokeDynamicSupport.bootstrap("reportStkServiceIsRunning", $$robo$$com_android_internal_telephony_test_SimulatedCommands$reportStkServiceIsRunning(android.os.Message ), 0, this, message);
    }

    @Override
    public void getCdmaSubscriptionSource(Message message) {
        InvokeDynamicSupport.bootstrap("getCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCdmaSubscriptionSource(android.os.Message ), 0, this, message);
    }

    private boolean isSimLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSimLocked", $$robo$$com_android_internal_telephony_test_SimulatedCommands$isSimLocked(), 0, this);
    }

    @Override
    public void setRadioPower(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setRadioPower(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void acknowledgeLastIncomingGsmSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingGsmSms", $$robo$$com_android_internal_telephony_test_SimulatedCommands$acknowledgeLastIncomingGsmSms(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    public void acknowledgeLastIncomingCdmaSms(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeLastIncomingCdmaSms", $$robo$$com_android_internal_telephony_test_SimulatedCommands$acknowledgeLastIncomingCdmaSms(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    public void acknowledgeIncomingGsmSmsWithPdu(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("acknowledgeIncomingGsmSmsWithPdu", $$robo$$com_android_internal_telephony_test_SimulatedCommands$acknowledgeIncomingGsmSmsWithPdu(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    @Override
    public void iccIO(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("iccIO", $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccIO(int int java.lang.String int int int java.lang.String java.lang.String android.os.Message ), 0, this, n, n2, string2, n3, n4, n5, string3, string4, message);
    }

    @Override
    public void iccIOForApp(int n, int n2, String string2, int n3, int n4, int n5, String string3, String string4, String string5, Message message) {
        InvokeDynamicSupport.bootstrap("iccIOForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccIOForApp(int int java.lang.String int int int java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, n, n2, string2, n3, n4, n5, string3, string4, string5, message);
    }

    @Override
    public void queryCLIP(Message message) {
        InvokeDynamicSupport.bootstrap("queryCLIP", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCLIP(android.os.Message ), 0, this, message);
    }

    @Override
    public void getCLIR(Message message) {
        InvokeDynamicSupport.bootstrap("getCLIR", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCLIR(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCLIR(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCLIR", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCLIR(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryCallWaiting(int n, Message message) {
        InvokeDynamicSupport.bootstrap("queryCallWaiting", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCallWaiting(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setCallWaiting(boolean bl, int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCallWaiting", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCallWaiting(boolean int android.os.Message ), 0, this, bl, n, message);
    }

    @Override
    public void setCallForward(int n, int n2, int n3, String string2, int n4, Message message) {
        InvokeDynamicSupport.bootstrap("setCallForward", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCallForward(int int int java.lang.String int android.os.Message ), 0, this, n, n2, n3, string2, n4, message);
    }

    @Override
    public void queryCallForwardStatus(int n, int n2, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("queryCallForwardStatus", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCallForwardStatus(int int java.lang.String android.os.Message ), 0, this, n, n2, string2, message);
    }

    @Override
    public void setNetworkSelectionModeAutomatic(Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomatic", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNetworkSelectionModeAutomatic(android.os.Message ), 0, this, message);
    }

    @Override
    public void exitEmergencyCallbackMode(Message message) {
        InvokeDynamicSupport.bootstrap("exitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$exitEmergencyCallbackMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void setNetworkSelectionModeManual(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeManual", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNetworkSelectionModeManual(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void getNetworkSelectionMode(Message message) {
        InvokeDynamicSupport.bootstrap("getNetworkSelectionMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getNetworkSelectionMode(android.os.Message ), 0, this, message);
    }

    public int getGetNetworkSelectionModeCallCount() {
        return (int)InvokeDynamicSupport.bootstrap("getGetNetworkSelectionModeCallCount", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGetNetworkSelectionModeCallCount(), 0, this);
    }

    @Override
    public void getAvailableNetworks(Message message) {
        InvokeDynamicSupport.bootstrap("getAvailableNetworks", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getAvailableNetworks(android.os.Message ), 0, this, message);
    }

    @Override
    public void startNetworkScan(NetworkScanRequest networkScanRequest, Message message) {
        InvokeDynamicSupport.bootstrap("startNetworkScan", $$robo$$com_android_internal_telephony_test_SimulatedCommands$startNetworkScan(android.telephony.NetworkScanRequest android.os.Message ), 0, this, networkScanRequest, message);
    }

    @Override
    public void stopNetworkScan(Message message) {
        InvokeDynamicSupport.bootstrap("stopNetworkScan", $$robo$$com_android_internal_telephony_test_SimulatedCommands$stopNetworkScan(android.os.Message ), 0, this, message);
    }

    @Override
    public void getBasebandVersion(Message message) {
        InvokeDynamicSupport.bootstrap("getBasebandVersion", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getBasebandVersion(android.os.Message ), 0, this, message);
    }

    public void triggerIncomingStkCcAlpha(String string2) {
        InvokeDynamicSupport.bootstrap("triggerIncomingStkCcAlpha", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerIncomingStkCcAlpha(java.lang.String ), 0, this, string2);
    }

    public void sendStkCcAplha(String string2) {
        InvokeDynamicSupport.bootstrap("sendStkCcAplha", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendStkCcAplha(java.lang.String ), 0, this, string2);
    }

    @Override
    public void triggerIncomingUssd(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("triggerIncomingUssd", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerIncomingUssd(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    @Override
    public void sendUSSD(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendUSSD", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendUSSD(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void cancelPendingUssd(Message message) {
        InvokeDynamicSupport.bootstrap("cancelPendingUssd", $$robo$$com_android_internal_telephony_test_SimulatedCommands$cancelPendingUssd(android.os.Message ), 0, this, message);
    }

    @Override
    public void resetRadio(Message message) {
        InvokeDynamicSupport.bootstrap("resetRadio", $$robo$$com_android_internal_telephony_test_SimulatedCommands$resetRadio(android.os.Message ), 0, this, message);
    }

    @Override
    public void invokeOemRilRequestRaw(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$com_android_internal_telephony_test_SimulatedCommands$invokeOemRilRequestRaw(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void setCarrierInfoForImsiEncryption(ImsiEncryptionInfo imsiEncryptionInfo, Message message) {
        InvokeDynamicSupport.bootstrap("setCarrierInfoForImsiEncryption", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCarrierInfoForImsiEncryption(android.telephony.ImsiEncryptionInfo android.os.Message ), 0, this, imsiEncryptionInfo, message);
    }

    @Override
    public void invokeOemRilRequestStrings(String[] stringArray, Message message) {
        InvokeDynamicSupport.bootstrap("invokeOemRilRequestStrings", $$robo$$com_android_internal_telephony_test_SimulatedCommands$invokeOemRilRequestStrings(java.lang.String[] android.os.Message ), 0, this, stringArray, message);
    }

    @Override
    public void triggerRing(String string2) {
        InvokeDynamicSupport.bootstrap("triggerRing", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerRing(java.lang.String ), 0, this, string2);
    }

    @Override
    public void progressConnectingCallState() {
        InvokeDynamicSupport.bootstrap("progressConnectingCallState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$progressConnectingCallState(), 0, this);
    }

    @Override
    public void progressConnectingToActive() {
        InvokeDynamicSupport.bootstrap("progressConnectingToActive", $$robo$$com_android_internal_telephony_test_SimulatedCommands$progressConnectingToActive(), 0, this);
    }

    @Override
    public void setAutoProgressConnectingCall(boolean bl) {
        InvokeDynamicSupport.bootstrap("setAutoProgressConnectingCall", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setAutoProgressConnectingCall(boolean ), 0, this, bl);
    }

    @Override
    public void setNextDialFailImmediately(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNextDialFailImmediately", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNextDialFailImmediately(boolean ), 0, this, bl);
    }

    @Override
    public void setNextCallFailCause(int n) {
        InvokeDynamicSupport.bootstrap("setNextCallFailCause", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setNextCallFailCause(int ), 0, this, n);
    }

    @Override
    public void triggerHangupForeground() {
        InvokeDynamicSupport.bootstrap("triggerHangupForeground", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerHangupForeground(), 0, this);
    }

    @Override
    public void triggerHangupBackground() {
        InvokeDynamicSupport.bootstrap("triggerHangupBackground", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerHangupBackground(), 0, this);
    }

    @Override
    public void triggerSsn(int n, int n2) {
        InvokeDynamicSupport.bootstrap("triggerSsn", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerSsn(int int ), 0, this, n, n2);
    }

    @Override
    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$com_android_internal_telephony_test_SimulatedCommands$shutdown(), 0, this);
    }

    @Override
    public void triggerHangupAll() {
        InvokeDynamicSupport.bootstrap("triggerHangupAll", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerHangupAll(), 0, this);
    }

    @Override
    public void triggerIncomingSMS(String string2) {
        InvokeDynamicSupport.bootstrap("triggerIncomingSMS", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerIncomingSMS(java.lang.String ), 0, this, string2);
    }

    @Override
    public void pauseResponses() {
        InvokeDynamicSupport.bootstrap("pauseResponses", $$robo$$com_android_internal_telephony_test_SimulatedCommands$pauseResponses(), 0, this);
    }

    @Override
    public void resumeResponses() {
        InvokeDynamicSupport.bootstrap("resumeResponses", $$robo$$com_android_internal_telephony_test_SimulatedCommands$resumeResponses(), 0, this);
    }

    private void unimplemented(Message message) {
        InvokeDynamicSupport.bootstrap("unimplemented", $$robo$$com_android_internal_telephony_test_SimulatedCommands$unimplemented(android.os.Message ), 0, this, message);
    }

    private void resultSuccess(Message message, Object object) {
        InvokeDynamicSupport.bootstrap("resultSuccess", $$robo$$com_android_internal_telephony_test_SimulatedCommands$resultSuccess(android.os.Message java.lang.Object ), 0, this, message, object);
    }

    private void resultFail(Message message, Object object, Throwable throwable) {
        InvokeDynamicSupport.bootstrap("resultFail", $$robo$$com_android_internal_telephony_test_SimulatedCommands$resultFail(android.os.Message java.lang.Object java.lang.Throwable ), 0, this, message, object, throwable);
    }

    @Override
    public void getDeviceIdentity(Message message) {
        InvokeDynamicSupport.bootstrap("getDeviceIdentity", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getDeviceIdentity(android.os.Message ), 0, this, message);
    }

    @Override
    public void getCDMASubscription(Message message) {
        InvokeDynamicSupport.bootstrap("getCDMASubscription", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCDMASubscription(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCdmaSubscriptionSource(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaSubscriptionSource", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaSubscriptionSource(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryCdmaRoamingPreference(Message message) {
        InvokeDynamicSupport.bootstrap("queryCdmaRoamingPreference", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryCdmaRoamingPreference(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCdmaRoamingPreference(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaRoamingPreference", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaRoamingPreference(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setPhoneType(int n) {
        InvokeDynamicSupport.bootstrap("setPhoneType", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPhoneType(int ), 0, this, n);
    }

    @Override
    public void getPreferredVoicePrivacy(Message message) {
        InvokeDynamicSupport.bootstrap("getPreferredVoicePrivacy", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getPreferredVoicePrivacy(android.os.Message ), 0, this, message);
    }

    @Override
    public void setPreferredVoicePrivacy(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setPreferredVoicePrivacy", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPreferredVoicePrivacy(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void setTTYMode(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setTTYMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setTTYMode(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void queryTTYMode(Message message) {
        InvokeDynamicSupport.bootstrap("queryTTYMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$queryTTYMode(android.os.Message ), 0, this, message);
    }

    @Override
    public void sendCDMAFeatureCode(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("sendCDMAFeatureCode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendCDMAFeatureCode(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void sendCdmaSms(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("sendCdmaSms", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendCdmaSms(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void setCdmaBroadcastActivation(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastActivation", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaBroadcastActivation(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void getCdmaBroadcastConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCdmaBroadcastConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void setCdmaBroadcastConfig(CdmaSmsBroadcastConfigInfo[] cdmaSmsBroadcastConfigInfoArray, Message message) {
        InvokeDynamicSupport.bootstrap("setCdmaBroadcastConfig", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCdmaBroadcastConfig(com.android.internal.telephony.cdma.CdmaSmsBroadcastConfigInfo[] android.os.Message ), 0, this, cdmaSmsBroadcastConfigInfoArray, message);
    }

    public void forceDataDormancy(Message message) {
        InvokeDynamicSupport.bootstrap("forceDataDormancy", $$robo$$com_android_internal_telephony_test_SimulatedCommands$forceDataDormancy(android.os.Message ), 0, this, message);
    }

    @Override
    public void setGsmBroadcastActivation(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastActivation", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setGsmBroadcastActivation(boolean android.os.Message ), 0, this, bl, message);
    }

    @Override
    public void setGsmBroadcastConfig(SmsBroadcastConfigInfo[] smsBroadcastConfigInfoArray, Message message) {
        InvokeDynamicSupport.bootstrap("setGsmBroadcastConfig", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setGsmBroadcastConfig(com.android.internal.telephony.gsm.SmsBroadcastConfigInfo[] android.os.Message ), 0, this, smsBroadcastConfigInfoArray, message);
    }

    @Override
    public void getGsmBroadcastConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getGsmBroadcastConfig", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getGsmBroadcastConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void supplyIccPinForApp(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPinForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPinForApp(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyIccPukForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPukForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPukForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void supplyIccPin2ForApp(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPin2ForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPin2ForApp(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyIccPuk2ForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("supplyIccPuk2ForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$supplyIccPuk2ForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void changeIccPinForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPinForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPinForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void changeIccPin2ForApp(String string2, String string3, String string4, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccPin2ForApp", $$robo$$com_android_internal_telephony_test_SimulatedCommands$changeIccPin2ForApp(java.lang.String java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, string4, message);
    }

    @Override
    public void requestIsimAuthentication(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("requestIsimAuthentication", $$robo$$com_android_internal_telephony_test_SimulatedCommands$requestIsimAuthentication(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void requestIccSimAuthentication(int n, String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("requestIccSimAuthentication", $$robo$$com_android_internal_telephony_test_SimulatedCommands$requestIccSimAuthentication(int java.lang.String java.lang.String android.os.Message ), 0, this, n, string2, string3, message);
    }

    @Override
    public void getVoiceRadioTechnology(Message message) {
        InvokeDynamicSupport.bootstrap("getVoiceRadioTechnology", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getVoiceRadioTechnology(android.os.Message ), 0, this, message);
    }

    public void setCellInfoList(List<CellInfo> list) {
        InvokeDynamicSupport.bootstrap("setCellInfoList", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCellInfoList(java.util.List<android.telephony.CellInfo> ), 0, this, list);
    }

    @Override
    public void getCellInfoList(Message message, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("getCellInfoList", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getCellInfoList(android.os.Message android.os.WorkSource ), 0, this, message, workSource);
    }

    @Override
    public int getRilVersion() {
        return (int)InvokeDynamicSupport.bootstrap("getRilVersion", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getRilVersion(), 0, this);
    }

    @Override
    public void setCellInfoListRate(int n, Message message, WorkSource workSource) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setCellInfoListRate(int android.os.Message android.os.WorkSource ), 0, this, n, message, workSource);
    }

    @Override
    public void setInitialAttachApn(DataProfile dataProfile, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setInitialAttachApn", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setInitialAttachApn(com.android.internal.telephony.dataconnection.DataProfile boolean android.os.Message ), 0, this, dataProfile, bl, message);
    }

    @Override
    public void setDataProfile(DataProfile[] dataProfileArray, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setDataProfile", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataProfile(com.android.internal.telephony.dataconnection.DataProfile[] boolean android.os.Message ), 0, this, dataProfileArray, bl, message);
    }

    public void setImsRegistrationState(int[] nArray) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setImsRegistrationState(int[] ), 0, this, nArray);
    }

    @Override
    public void getImsRegistrationState(Message message) {
        InvokeDynamicSupport.bootstrap("getImsRegistrationState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getImsRegistrationState(android.os.Message ), 0, this, message);
    }

    @Override
    public void sendImsCdmaSms(byte[] byArray, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendImsCdmaSms", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendImsCdmaSms(byte[] int int android.os.Message ), 0, this, byArray, n, n2, message);
    }

    @Override
    public void sendImsGsmSms(String string2, String string3, int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("sendImsGsmSms", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendImsGsmSms(java.lang.String java.lang.String int int android.os.Message ), 0, this, string2, string3, n, n2, message);
    }

    @Override
    public void iccOpenLogicalChannel(String string2, int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccOpenLogicalChannel(java.lang.String int android.os.Message ), 0, this, string2, n, message);
    }

    @Override
    public void iccCloseLogicalChannel(int n, Message message) {
        InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccCloseLogicalChannel(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccTransmitApduLogicalChannel(int int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, n6, string2, message);
    }

    @Override
    public void iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$com_android_internal_telephony_test_SimulatedCommands$iccTransmitApduBasicChannel(int int int int int java.lang.String android.os.Message ), 0, this, n, n2, n3, n4, n5, string2, message);
    }

    @Override
    public void nvReadItem(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvReadItem(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void nvWriteItem(int n, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvWriteItem(int java.lang.String android.os.Message ), 0, this, n, string2, message);
    }

    @Override
    public void nvWriteCdmaPrl(byte[] byArray, Message message) {
        InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvWriteCdmaPrl(byte[] android.os.Message ), 0, this, byArray, message);
    }

    @Override
    public void nvResetConfig(int n, Message message) {
        InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$com_android_internal_telephony_test_SimulatedCommands$nvResetConfig(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void getHardwareConfig(Message message) {
        InvokeDynamicSupport.bootstrap("getHardwareConfig", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getHardwareConfig(android.os.Message ), 0, this, message);
    }

    @Override
    public void requestShutdown(Message message) {
        InvokeDynamicSupport.bootstrap("requestShutdown", $$robo$$com_android_internal_telephony_test_SimulatedCommands$requestShutdown(android.os.Message ), 0, this, message);
    }

    @Override
    public void startLceService(int n, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("startLceService", $$robo$$com_android_internal_telephony_test_SimulatedCommands$startLceService(int boolean android.os.Message ), 0, this, n, bl, message);
    }

    @Override
    public void stopLceService(Message message) {
        InvokeDynamicSupport.bootstrap("stopLceService", $$robo$$com_android_internal_telephony_test_SimulatedCommands$stopLceService(android.os.Message ), 0, this, message);
    }

    @Override
    public void pullLceData(Message message) {
        InvokeDynamicSupport.bootstrap("pullLceData", $$robo$$com_android_internal_telephony_test_SimulatedCommands$pullLceData(android.os.Message ), 0, this, message);
    }

    @Override
    public void getModemActivityInfo(Message message) {
        InvokeDynamicSupport.bootstrap("getModemActivityInfo", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getModemActivityInfo(android.os.Message ), 0, this, message);
    }

    @Override
    public void setAllowedCarriers(List<CarrierIdentifier> list, Message message) {
        InvokeDynamicSupport.bootstrap("setAllowedCarriers", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setAllowedCarriers(java.util.List<android.service.carrier.CarrierIdentifier> android.os.Message ), 0, this, list, message);
    }

    @Override
    public void getAllowedCarriers(Message message) {
        InvokeDynamicSupport.bootstrap("getAllowedCarriers", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getAllowedCarriers(android.os.Message ), 0, this, message);
    }

    @Override
    public void getRadioCapability(Message message) {
        InvokeDynamicSupport.bootstrap("getRadioCapability", $$robo$$com_android_internal_telephony_test_SimulatedCommands$getRadioCapability(android.os.Message ), 0, this, message);
    }

    public void notifySmsStatus(Object object) {
        InvokeDynamicSupport.bootstrap("notifySmsStatus", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifySmsStatus(java.lang.Object ), 0, this, object);
    }

    public void notifyGsmBroadcastSms(Object object) {
        InvokeDynamicSupport.bootstrap("notifyGsmBroadcastSms", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyGsmBroadcastSms(java.lang.Object ), 0, this, object);
    }

    public void notifyIccSmsFull() {
        InvokeDynamicSupport.bootstrap("notifyIccSmsFull", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyIccSmsFull(), 0, this);
    }

    public void notifyEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("notifyEmergencyCallbackMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyEmergencyCallbackMode(), 0, this);
    }

    @Override
    public void setEmergencyCallbackMode(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setEmergencyCallbackMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setEmergencyCallbackMode(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void notifyExitEmergencyCallbackMode() {
        InvokeDynamicSupport.bootstrap("notifyExitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyExitEmergencyCallbackMode(), 0, this);
    }

    public void notifyImsNetworkStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyImsNetworkStateChanged", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyImsNetworkStateChanged(), 0, this);
    }

    public void notifyModemReset() {
        InvokeDynamicSupport.bootstrap("notifyModemReset", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyModemReset(), 0, this);
    }

    @Override
    public void registerForExitEmergencyCallbackMode(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForExitEmergencyCallbackMode", $$robo$$com_android_internal_telephony_test_SimulatedCommands$registerForExitEmergencyCallbackMode(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    public void notifyRadioOn() {
        InvokeDynamicSupport.bootstrap("notifyRadioOn", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyRadioOn(), 0, this);
    }

    public void notifyNetworkStateChanged() {
        InvokeDynamicSupport.bootstrap("notifyNetworkStateChanged", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyNetworkStateChanged(), 0, this);
    }

    public void notifyOtaProvisionStatusChanged() {
        InvokeDynamicSupport.bootstrap("notifyOtaProvisionStatusChanged", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifyOtaProvisionStatusChanged(), 0, this);
    }

    public void notifySignalStrength() {
        InvokeDynamicSupport.bootstrap("notifySignalStrength", $$robo$$com_android_internal_telephony_test_SimulatedCommands$notifySignalStrength(), 0, this);
    }

    public void setIccCardStatus(IccCardStatus iccCardStatus) {
        InvokeDynamicSupport.bootstrap("setIccCardStatus", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIccCardStatus(com.android.internal.telephony.uicc.IccCardStatus ), 0, this, iccCardStatus);
    }

    public void setIccIoResultForApduLogicalChannel(IccIoResult iccIoResult) {
        InvokeDynamicSupport.bootstrap("setIccIoResultForApduLogicalChannel", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setIccIoResultForApduLogicalChannel(com.android.internal.telephony.uicc.IccIoResult ), 0, this, iccIoResult);
    }

    public void setOpenChannelId(int n) {
        InvokeDynamicSupport.bootstrap("setOpenChannelId", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setOpenChannelId(int ), 0, this, n);
    }

    public void setPin1RemainingAttempt(int n) {
        InvokeDynamicSupport.bootstrap("setPin1RemainingAttempt", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setPin1RemainingAttempt(int ), 0, this, n);
    }

    @Override
    public void setDataAllowed(boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("setDataAllowed", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setDataAllowed(boolean android.os.Message ), 0, this, bl, message);
    }

    public boolean isDataAllowed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataAllowed", $$robo$$com_android_internal_telephony_test_SimulatedCommands$isDataAllowed(), 0, this);
    }

    @Override
    public void registerForPcoData(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForPcoData", $$robo$$com_android_internal_telephony_test_SimulatedCommands$registerForPcoData(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForPcoData(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForPcoData", $$robo$$com_android_internal_telephony_test_SimulatedCommands$unregisterForPcoData(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForModemReset(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForModemReset", $$robo$$com_android_internal_telephony_test_SimulatedCommands$registerForModemReset(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void sendDeviceState(int n, boolean bl, Message message) {
        InvokeDynamicSupport.bootstrap("sendDeviceState", $$robo$$com_android_internal_telephony_test_SimulatedCommands$sendDeviceState(int boolean android.os.Message ), 0, this, n, bl, message);
    }

    @Override
    public void setUnsolResponseFilter(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setUnsolResponseFilter", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setUnsolResponseFilter(int android.os.Message ), 0, this, n, message);
    }

    @Override
    public void setSimCardPower(int n, Message message) {
        InvokeDynamicSupport.bootstrap("setSimCardPower", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setSimCardPower(int android.os.Message ), 0, this, n, message);
    }

    public void triggerRestrictedStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("triggerRestrictedStateChanged", $$robo$$com_android_internal_telephony_test_SimulatedCommands$triggerRestrictedStateChanged(int ), 0, this, n);
    }

    @Override
    public void setOnRestrictedStateChanged(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("setOnRestrictedStateChanged", $$robo$$com_android_internal_telephony_test_SimulatedCommands$setOnRestrictedStateChanged(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    static {
        RobolectricInternals.classInitializing(SimulatedCommands.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimulatedCommands)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SimFdnState
    extends Enum<SimFdnState> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ SimFdnState NONE;
        public static /* enum */ SimFdnState REQUIRE_PIN2;
        public static /* enum */ SimFdnState REQUIRE_PUK2;
        public static /* enum */ SimFdnState SIM_PERM_LOCKED;
        private static /* synthetic */ SimFdnState[] $VALUES;

        private static final SimFdnState[] $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimFdnState$values() {
            return (SimFdnState[])$VALUES.clone();
        }

        private static final SimFdnState $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimFdnState$valueOf(String name) {
            return Enum.valueOf(SimFdnState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimFdnState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NONE = new SimFdnState();
            REQUIRE_PIN2 = new SimFdnState();
            REQUIRE_PUK2 = new SimFdnState();
            SIM_PERM_LOCKED = new SimFdnState();
            $VALUES = new SimFdnState[]{NONE, REQUIRE_PIN2, REQUIRE_PUK2, SIM_PERM_LOCKED};
        }

        public static SimFdnState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimFdnState$values(), 0);
        }

        public static SimFdnState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimFdnState$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_test_SimulatedCommands_SimFdnState$__constructor__(string2, n);
        }

        private SimFdnState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimFdnState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(SimFdnState.class);
        }

        public /* synthetic */ SimFdnState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimFdnState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
    private static final class SimLockState
    extends Enum<SimLockState> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ SimLockState NONE;
        public static /* enum */ SimLockState REQUIRE_PIN;
        public static /* enum */ SimLockState REQUIRE_PUK;
        public static /* enum */ SimLockState SIM_PERM_LOCKED;
        private static /* synthetic */ SimLockState[] $VALUES;

        private static final SimLockState[] $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimLockState$values() {
            return (SimLockState[])$VALUES.clone();
        }

        private static final SimLockState $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimLockState$valueOf(String name) {
            return Enum.valueOf(SimLockState.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimLockState$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            NONE = new SimLockState();
            REQUIRE_PIN = new SimLockState();
            REQUIRE_PUK = new SimLockState();
            SIM_PERM_LOCKED = new SimLockState();
            $VALUES = new SimLockState[]{NONE, REQUIRE_PIN, REQUIRE_PUK, SIM_PERM_LOCKED};
        }

        public static SimLockState[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimLockState$values(), 0);
        }

        public static SimLockState valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimLockState$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$com_android_internal_telephony_test_SimulatedCommands_SimLockState$__constructor__(string2, n);
        }

        private SimLockState() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_test_SimulatedCommands_SimLockState$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(SimLockState.class);
        }

        public /* synthetic */ SimLockState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimLockState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

