/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.os.AsyncResult;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.telephony.Rlog;
import com.android.internal.telephony.uicc.AdnRecord;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccUtils;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AdnRecordLoader
extends Handler
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String LOG_TAG = "AdnRecordLoader";
    static boolean VDBG = false;
    private IccFileHandler mFh;
    int mEf;
    int mExtensionEF;
    int mPendingExtLoads;
    Message mUserResponse;
    String mPin2;
    int mRecordNumber;
    ArrayList<AdnRecord> mAdns;
    Object mResult;
    static int EVENT_ADN_LOAD_DONE = 1;
    static int EVENT_EXT_RECORD_LOAD_DONE = 2;
    static int EVENT_ADN_LOAD_ALL_DONE = 3;
    static int EVENT_EF_LINEAR_RECORD_SIZE_DONE = 4;
    static int EVENT_UPDATE_RECORD_DONE = 5;

    private void $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$__constructor__(IccFileHandler fh) {
        this.mFh = fh;
    }

    private final String $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$getEFPath(int efid) {
        if (efid == 28474) {
            return "3F007F10";
        }
        return null;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$loadFromEF(int ef, int extensionEF, int recordNumber, Message response) {
        this.mEf = ef;
        this.mExtensionEF = extensionEF;
        this.mRecordNumber = recordNumber;
        this.mUserResponse = response;
        this.mFh.loadEFLinearFixed(ef, this.getEFPath(ef), recordNumber, this.obtainMessage(1));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$loadAllFromEF(int ef, int extensionEF, Message response) {
        this.mEf = ef;
        this.mExtensionEF = extensionEF;
        this.mUserResponse = response;
        this.mFh.loadEFLinearFixedAll(ef, this.getEFPath(ef), this.obtainMessage(3));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$updateEF(AdnRecord adn, int ef, int extensionEF, int recordNumber, String pin2, Message response) {
        this.mEf = ef;
        this.mExtensionEF = extensionEF;
        this.mRecordNumber = recordNumber;
        this.mUserResponse = response;
        this.mPin2 = pin2;
        this.mFh.getEFLinearRecordSize(ef, this.getEFPath(ef), this.obtainMessage(4, adn));
    }

    private final void $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$handleMessage(Message msg) {
        try {
            switch (msg.what) {
                case 4: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    AdnRecord adn = (AdnRecord)ar.userObj;
                    if (ar.exception != null) {
                        throw new RuntimeException("get EF record size failed", ar.exception);
                    }
                    int[] recordSize = (int[])ar.result;
                    if (recordSize.length != 3 || this.mRecordNumber > recordSize[2]) {
                        throw new RuntimeException("get wrong EF record size format", ar.exception);
                    }
                    byte[] data = adn.buildAdnString(recordSize[0]);
                    if (data == null) {
                        throw new RuntimeException("wrong ADN format", ar.exception);
                    }
                    this.mFh.updateEFLinearFixed(this.mEf, this.getEFPath(this.mEf), this.mRecordNumber, data, this.mPin2, this.obtainMessage(5));
                    this.mPendingExtLoads = 1;
                    break;
                }
                case 5: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    if (ar.exception != null) {
                        throw new RuntimeException("update EF adn record failed", ar.exception);
                    }
                    this.mPendingExtLoads = 0;
                    this.mResult = null;
                    break;
                }
                case 1: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    if (ar.exception != null) {
                        throw new RuntimeException("load failed", ar.exception);
                    }
                    AdnRecord adn = new AdnRecord(this.mEf, this.mRecordNumber, data);
                    this.mResult = adn;
                    if (!adn.hasExtendedRecord()) break;
                    this.mPendingExtLoads = 1;
                    this.mFh.loadEFLinearFixed(this.mExtensionEF, adn.mExtRecord, this.obtainMessage(2, adn));
                    break;
                }
                case 2: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    byte[] data = (byte[])ar.result;
                    AdnRecord adn = (AdnRecord)ar.userObj;
                    if (ar.exception == null) {
                        Rlog.d("AdnRecordLoader", "ADN extension EF: 0x" + Integer.toHexString(this.mExtensionEF) + ":" + adn.mExtRecord + "\n" + IccUtils.bytesToHexString(data));
                        adn.appendExtRecord(data);
                    } else {
                        Rlog.e("AdnRecordLoader", "Failed to read ext record. Clear the number now.");
                        adn.setNumber("");
                    }
                    --this.mPendingExtLoads;
                    break;
                }
                case 3: {
                    AsyncResult ar = (AsyncResult)msg.obj;
                    ArrayList datas = (ArrayList)ar.result;
                    if (ar.exception != null) {
                        throw new RuntimeException("load failed", ar.exception);
                    }
                    this.mResult = this.mAdns = new ArrayList(datas.size());
                    this.mPendingExtLoads = 0;
                    int s = datas.size();
                    for (int i = 0; i < s; ++i) {
                        AdnRecord adn = new AdnRecord(this.mEf, 1 + i, (byte[])datas.get(i));
                        this.mAdns.add(adn);
                        if (!adn.hasExtendedRecord()) continue;
                        ++this.mPendingExtLoads;
                        this.mFh.loadEFLinearFixed(this.mExtensionEF, adn.mExtRecord, this.obtainMessage(2, adn));
                    }
                    break;
                }
            }
        }
        catch (RuntimeException exc) {
            if (this.mUserResponse != null) {
                AsyncResult.forMessage((Message)this.mUserResponse).exception = exc;
                this.mUserResponse.sendToTarget();
                this.mUserResponse = null;
            }
            return;
        }
        if (this.mUserResponse != null && this.mPendingExtLoads == 0) {
            AsyncResult.forMessage((Message)this.mUserResponse).result = this.mResult;
            this.mUserResponse.sendToTarget();
            this.mUserResponse = null;
        }
    }

    private void __constructor__(IccFileHandler iccFileHandler) {
        this.$$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$__constructor__(iccFileHandler);
    }

    AdnRecordLoader(IccFileHandler iccFileHandler) {
        super(Looper.getMainLooper());
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$__constructor__(com.android.internal.telephony.uicc.IccFileHandler ), 0, this, iccFileHandler);
    }

    private String getEFPath(int n) {
        return InvokeDynamicSupport.bootstrap("getEFPath", $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$getEFPath(int ), 0, this, n);
    }

    public void loadFromEF(int n, int n2, int n3, Message message) {
        InvokeDynamicSupport.bootstrap("loadFromEF", $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$loadFromEF(int int int android.os.Message ), 0, this, n, n2, n3, message);
    }

    public void loadAllFromEF(int n, int n2, Message message) {
        InvokeDynamicSupport.bootstrap("loadAllFromEF", $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$loadAllFromEF(int int android.os.Message ), 0, this, n, n2, message);
    }

    public void updateEF(AdnRecord adnRecord, int n, int n2, int n3, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("updateEF", $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$updateEF(com.android.internal.telephony.uicc.AdnRecord int int int java.lang.String android.os.Message ), 0, this, adnRecord, n, n2, n3, string2, message);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_AdnRecordLoader$handleMessage(android.os.Message ), 0, this, message);
    }

    public /* synthetic */ AdnRecordLoader() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdnRecordLoader)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

