/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.uicc;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.AsyncResult;
import android.os.Handler;
import android.os.Message;
import android.os.Registrant;
import android.os.RegistrantList;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.IntentBroadcaster;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.uicc.IccCardApplicationStatus;
import com.android.internal.telephony.uicc.IccCardStatus;
import com.android.internal.telephony.uicc.IccFileHandler;
import com.android.internal.telephony.uicc.IccRecords;
import com.android.internal.telephony.uicc.UiccCard;
import com.android.internal.telephony.uicc.UiccCardApplication;
import com.android.internal.telephony.uicc.UiccController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IccCardProxy
extends Handler
implements IccCard,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DBG = true;
    private static String LOG_TAG = "IccCardProxy";
    private static int EVENT_RADIO_OFF_OR_UNAVAILABLE = 1;
    private static int EVENT_RADIO_ON = 2;
    private static int EVENT_ICC_CHANGED = 3;
    private static int EVENT_ICC_ABSENT = 4;
    private static int EVENT_ICC_LOCKED = 5;
    private static int EVENT_APP_READY = 6;
    private static int EVENT_RECORDS_LOADED = 7;
    private static int EVENT_IMSI_READY = 8;
    private static int EVENT_NETWORK_LOCKED = 9;
    private static int EVENT_CDMA_SUBSCRIPTION_SOURCE_CHANGED = 11;
    private static int EVENT_ICC_RECORD_EVENTS = 500;
    private static int EVENT_SUBSCRIPTION_ACTIVATED = 501;
    private static int EVENT_SUBSCRIPTION_DEACTIVATED = 502;
    private static int EVENT_CARRIER_PRIVILEGES_LOADED = 503;
    private Integer mPhoneId;
    private Object mLock;
    private Context mContext;
    private CommandsInterface mCi;
    private TelephonyManager mTelephonyManager;
    private RegistrantList mAbsentRegistrants;
    private RegistrantList mPinLockedRegistrants;
    private RegistrantList mNetworkLockedRegistrants;
    private int mCurrentAppType;
    private UiccController mUiccController;
    private UiccCard mUiccCard;
    private UiccCardApplication mUiccApplication;
    private IccRecords mIccRecords;
    private CdmaSubscriptionSourceManager mCdmaSSM;
    private CommandsInterface.RadioState mRadioState;
    private boolean mQuietMode;
    private boolean mInitialized;
    private IccCardConstants.State mExternalState;
    public static String ACTION_INTERNAL_SIM_STATE_CHANGED = "android.intent.action.internal_sim_state_changed";

    private void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$__constructor__(Context context, CommandsInterface ci, int phoneId) {
        this.mPhoneId = null;
        this.mLock = new Object();
        this.mAbsentRegistrants = new RegistrantList();
        this.mPinLockedRegistrants = new RegistrantList();
        this.mNetworkLockedRegistrants = new RegistrantList();
        this.mCurrentAppType = 1;
        this.mUiccController = null;
        this.mUiccCard = null;
        this.mUiccApplication = null;
        this.mIccRecords = null;
        this.mCdmaSSM = null;
        this.mRadioState = CommandsInterface.RadioState.RADIO_UNAVAILABLE;
        this.mQuietMode = false;
        this.mInitialized = false;
        this.mExternalState = IccCardConstants.State.UNKNOWN;
        this.log("ctor: ci=" + ci + " phoneId=" + phoneId);
        this.mContext = context;
        this.mCi = ci;
        this.mPhoneId = phoneId;
        this.mTelephonyManager = (TelephonyManager)this.mContext.getSystemService("phone");
        this.mCdmaSSM = CdmaSubscriptionSourceManager.getInstance(context, ci, this, 11, null);
        this.mUiccController = UiccController.getInstance();
        this.mUiccController.registerForIccChanged(this, 3, null);
        ci.registerForOn(this, 2, null);
        ci.registerForOffOrNotAvailable(this, 1, null);
        this.resetProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$dispose() {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Disposing");
            this.mUiccController.unregisterForIccChanged(this);
            this.mUiccController = null;
            this.mCi.unregisterForOn(this);
            this.mCi.unregisterForOffOrNotAvailable(this);
            this.mCdmaSSM.dispose(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setVoiceRadioTech(int radioTech) {
        Object object = this.mLock;
        synchronized (object) {
            this.log("Setting radio tech " + ServiceState.rilRadioTechnologyToString(radioTech));
            this.mCurrentAppType = ServiceState.isGsm(radioTech) ? 1 : 2;
            this.updateQuietMode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateQuietMode() {
        Object object = this.mLock;
        synchronized (object) {
            boolean newQuietMode;
            boolean isLteOnCdmaMode;
            boolean oldQuietMode = this.mQuietMode;
            int cdmaSource = -1;
            boolean bl = isLteOnCdmaMode = TelephonyManager.getLteOnCdmaModeStatic() == 1;
            if (this.mCurrentAppType == 1) {
                newQuietMode = false;
                this.log("updateQuietMode: 3GPP subscription -> newQuietMode=" + newQuietMode);
            } else {
                if (isLteOnCdmaMode) {
                    this.log("updateQuietMode: is cdma/lte device, force IccCardProxy into 3gpp mode");
                    this.mCurrentAppType = 1;
                }
                cdmaSource = this.mCdmaSSM != null ? this.mCdmaSSM.getCdmaSubscriptionSource() : -1;
                newQuietMode = cdmaSource == 1 && this.mCurrentAppType == 2 && !isLteOnCdmaMode;
                this.log("updateQuietMode: cdmaSource=" + cdmaSource + " mCurrentAppType=" + this.mCurrentAppType + " isLteOnCdmaMode=" + isLteOnCdmaMode + " newQuietMode=" + newQuietMode);
            }
            if (!this.mQuietMode && newQuietMode) {
                this.log("Switching to QuietMode.");
                this.setExternalState(IccCardConstants.State.READY);
                this.mQuietMode = newQuietMode;
            } else if (this.mQuietMode && !newQuietMode) {
                this.log("updateQuietMode: Switching out from QuietMode. Force broadcast of current state=" + (Object)((Object)this.mExternalState));
                this.mQuietMode = newQuietMode;
                this.setExternalState(this.mExternalState, true);
            } else {
                this.log("updateQuietMode: no changes don't setExternalState");
            }
            this.log("updateQuietMode: QuietMode is " + this.mQuietMode + " (app_type=" + this.mCurrentAppType + " isLteOnCdmaMode=" + isLteOnCdmaMode + " cdmaSource=" + cdmaSource + ")");
            this.mInitialized = true;
            this.sendMessage(this.obtainMessage(3));
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$handleMessage(Message msg) {
        switch (msg.what) {
            case 1: {
                this.mRadioState = this.mCi.getRadioState();
                this.updateExternalState();
                break;
            }
            case 2: {
                this.mRadioState = CommandsInterface.RadioState.RADIO_ON;
                if (!this.mInitialized) {
                    this.updateQuietMode();
                    break;
                }
                this.updateExternalState();
                break;
            }
            case 3: {
                if (!this.mInitialized) break;
                this.updateIccAvailability();
                break;
            }
            case 4: {
                this.mAbsentRegistrants.notifyRegistrants();
                this.setExternalState(IccCardConstants.State.ABSENT);
                break;
            }
            case 5: {
                this.processLockedState();
                break;
            }
            case 6: {
                this.setExternalState(IccCardConstants.State.READY);
                break;
            }
            case 7: {
                if (this.mIccRecords != null) {
                    String operator = this.mIccRecords.getOperatorNumeric();
                    this.log("operator=" + operator + " mPhoneId=" + this.mPhoneId);
                    if (!TextUtils.isEmpty(operator)) {
                        this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, operator);
                        String countryCode = operator.substring(0, 3);
                        if (countryCode != null) {
                            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, MccTable.countryCodeForMcc(Integer.parseInt(countryCode)));
                        } else {
                            this.loge("EVENT_RECORDS_LOADED Country code is null");
                        }
                    } else {
                        this.loge("EVENT_RECORDS_LOADED Operator name is null");
                    }
                }
                if (this.mUiccCard != null && !this.mUiccCard.areCarrierPriviligeRulesLoaded()) {
                    this.mUiccCard.registerForCarrierPrivilegeRulesLoaded(this, 503, null);
                    break;
                }
                this.onRecordsLoaded();
                break;
            }
            case 8: {
                this.broadcastIccStateChangedIntent("IMSI", null);
                break;
            }
            case 9: {
                this.mNetworkLockedRegistrants.notifyRegistrants();
                this.setExternalState(IccCardConstants.State.NETWORK_LOCKED);
                break;
            }
            case 11: {
                this.updateQuietMode();
                break;
            }
            case 501: {
                this.log("EVENT_SUBSCRIPTION_ACTIVATED");
                this.onSubscriptionActivated();
                break;
            }
            case 502: {
                this.log("EVENT_SUBSCRIPTION_DEACTIVATED");
                this.onSubscriptionDeactivated();
                break;
            }
            case 500: {
                if (this.mCurrentAppType != 1 || this.mIccRecords == null) break;
                AsyncResult ar = (AsyncResult)msg.obj;
                int eventCode = (Integer)ar.result;
                if (eventCode != 2) break;
                this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, this.mIccRecords.getServiceProviderName());
                break;
            }
            case 503: {
                this.log("EVENT_CARRIER_PRIVILEGES_LOADED");
                if (this.mUiccCard != null) {
                    this.mUiccCard.unregisterForCarrierPrivilegeRulesLoaded(this);
                }
                this.onRecordsLoaded();
                break;
            }
            default: {
                this.loge("Unhandled message with number: " + msg.what);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$onSubscriptionActivated() {
        this.updateIccAvailability();
        this.updateStateProperty();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$onSubscriptionDeactivated() {
        this.resetProperties();
        this.updateIccAvailability();
        this.updateStateProperty();
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$onRecordsLoaded() {
        this.broadcastInternalIccStateChangedIntent("LOADED", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateIccAvailability() {
        Object object = this.mLock;
        synchronized (object) {
            UiccCard newCard = this.mUiccController.getUiccCard(this.mPhoneId);
            UiccCardApplication newApp = null;
            IccRecords newRecords = null;
            if (newCard != null && (newApp = newCard.getApplication(this.mCurrentAppType)) != null) {
                newRecords = newApp.getIccRecords();
            }
            if (this.mIccRecords != newRecords || this.mUiccApplication != newApp || this.mUiccCard != newCard) {
                this.log("Icc changed. Reregistering.");
                this.unregisterUiccCardEvents();
                this.mUiccCard = newCard;
                this.mUiccApplication = newApp;
                this.mIccRecords = newRecords;
                this.registerUiccCardEvents();
            }
            this.updateExternalState();
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$resetProperties() {
        if (this.mCurrentAppType == 1) {
            this.log("update icc_operator_numeric=");
            this.mTelephonyManager.setSimOperatorNumericForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimCountryIsoForPhone(this.mPhoneId, "");
            this.mTelephonyManager.setSimOperatorNameForPhone(this.mPhoneId, "");
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$HandleDetectedState() {
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateExternalState() {
        if (this.mUiccCard == null) {
            this.setExternalState(IccCardConstants.State.UNKNOWN);
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ABSENT) {
            if (this.mRadioState == CommandsInterface.RadioState.RADIO_UNAVAILABLE) {
                this.setExternalState(IccCardConstants.State.UNKNOWN);
            } else {
                this.setExternalState(IccCardConstants.State.ABSENT);
            }
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_ERROR) {
            this.setExternalState(IccCardConstants.State.CARD_IO_ERROR);
            return;
        }
        if (this.mUiccCard.getCardState() == IccCardStatus.CardState.CARDSTATE_RESTRICTED) {
            this.setExternalState(IccCardConstants.State.CARD_RESTRICTED);
            return;
        }
        if (this.mUiccApplication == null) {
            this.setExternalState(IccCardConstants.State.NOT_READY);
            return;
        }
        switch (1.$SwitchMap$com$android$internal$telephony$uicc$IccCardApplicationStatus$AppState[this.mUiccApplication.getState().ordinal()]) {
            case 1: {
                this.setExternalState(IccCardConstants.State.NOT_READY);
                break;
            }
            case 2: {
                this.HandleDetectedState();
                break;
            }
            case 3: {
                this.setExternalState(IccCardConstants.State.PIN_REQUIRED);
                break;
            }
            case 4: {
                IccCardStatus.PinState pin1State = this.mUiccApplication.getPin1State();
                if (pin1State.isPermBlocked()) {
                    this.setExternalState(IccCardConstants.State.PERM_DISABLED);
                    return;
                }
                this.setExternalState(IccCardConstants.State.PUK_REQUIRED);
                break;
            }
            case 5: {
                if (this.mUiccApplication.getPersoSubState() != IccCardApplicationStatus.PersoSubState.PERSOSUBSTATE_SIM_NETWORK) break;
                this.setExternalState(IccCardConstants.State.NETWORK_LOCKED);
                break;
            }
            case 6: {
                this.setExternalState(IccCardConstants.State.READY);
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerUiccCardEvents() {
        if (this.mUiccCard != null) {
            this.mUiccCard.registerForAbsent(this, 4, null);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.registerForReady(this, 6, null);
            this.mUiccApplication.registerForLocked(this, 5, null);
            this.mUiccApplication.registerForNetworkLocked(this, 9, null);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.registerForImsiReady(this, 8, null);
            this.mIccRecords.registerForRecordsLoaded(this, 7, null);
            this.mIccRecords.registerForRecordsEvents(this, 500, null);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterUiccCardEvents() {
        if (this.mUiccCard != null) {
            this.mUiccCard.unregisterForAbsent(this);
        }
        if (this.mUiccCard != null) {
            this.mUiccCard.unregisterForCarrierPrivilegeRulesLoaded(this);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.unregisterForReady(this);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.unregisterForLocked(this);
        }
        if (this.mUiccApplication != null) {
            this.mUiccApplication.unregisterForNetworkLocked(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForImsiReady(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForRecordsLoaded(this);
        }
        if (this.mIccRecords != null) {
            this.mIccRecords.unregisterForRecordsEvents(this);
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateStateProperty() {
        this.mTelephonyManager.setSimStateForPhone(this.mPhoneId, this.getState().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$broadcastIccStateChangedIntent(String value, String reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPhoneId == null || !SubscriptionManager.isValidSlotIndex(this.mPhoneId)) {
                this.loge("broadcastIccStateChangedIntent: mPhoneId=" + this.mPhoneId + " is invalid; Return!!");
                return;
            }
            if (this.mQuietMode) {
                this.log("broadcastIccStateChangedIntent: QuietMode NOT Broadcasting intent ACTION_SIM_STATE_CHANGED  value=" + value + " reason=" + reason);
                return;
            }
            Intent intent = new Intent("android.intent.action.SIM_STATE_CHANGED");
            intent.addFlags(0x4000000);
            intent.putExtra("phoneName", "Phone");
            intent.putExtra("ss", value);
            intent.putExtra("reason", reason);
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhoneId);
            this.log("broadcastIccStateChangedIntent intent ACTION_SIM_STATE_CHANGED value=" + value + " reason=" + reason + " for mPhoneId=" + this.mPhoneId);
            IntentBroadcaster.getInstance().broadcastStickyIntent(intent, this.mPhoneId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$broadcastInternalIccStateChangedIntent(String value, String reason) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPhoneId == null) {
                this.loge("broadcastInternalIccStateChangedIntent: Card Index is not set; Return!!");
                return;
            }
            Intent intent = new Intent("android.intent.action.internal_sim_state_changed");
            intent.addFlags(0x24000000);
            intent.putExtra("phoneName", "Phone");
            intent.putExtra("ss", value);
            intent.putExtra("reason", reason);
            intent.putExtra("phone", this.mPhoneId);
            this.log("Sending intent ACTION_INTERNAL_SIM_STATE_CHANGED value=" + value + " for mPhoneId : " + this.mPhoneId);
            ActivityManager.broadcastStickyIntent(intent, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setExternalState(IccCardConstants.State newState, boolean override) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPhoneId == null || !SubscriptionManager.isValidSlotIndex(this.mPhoneId)) {
                this.loge("setExternalState: mPhoneId=" + this.mPhoneId + " is invalid; Return!!");
                return;
            }
            if (!override && newState == this.mExternalState) {
                this.log("setExternalState: !override and newstate unchanged from " + (Object)((Object)newState));
                return;
            }
            this.mExternalState = newState;
            this.log("setExternalState: set mPhoneId=" + this.mPhoneId + " mExternalState=" + (Object)((Object)this.mExternalState));
            this.mTelephonyManager.setSimStateForPhone(this.mPhoneId, this.getState().toString());
            if ("LOCKED".equals(this.getIccStateIntentString(this.mExternalState))) {
                this.broadcastInternalIccStateChangedIntent(this.getIccStateIntentString(this.mExternalState), this.getIccStateReason(this.mExternalState));
            } else {
                this.broadcastIccStateChangedIntent(this.getIccStateIntentString(this.mExternalState), this.getIccStateReason(this.mExternalState));
            }
            if (IccCardConstants.State.ABSENT == this.mExternalState) {
                this.mAbsentRegistrants.notifyRegistrants();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$processLockedState() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication == null) {
                return;
            }
            IccCardStatus.PinState pin1State = this.mUiccApplication.getPin1State();
            if (pin1State == IccCardStatus.PinState.PINSTATE_ENABLED_PERM_BLOCKED) {
                this.setExternalState(IccCardConstants.State.PERM_DISABLED);
                return;
            }
            IccCardApplicationStatus.AppState appState = this.mUiccApplication.getState();
            switch (1.$SwitchMap$com$android$internal$telephony$uicc$IccCardApplicationStatus$AppState[appState.ordinal()]) {
                case 3: {
                    this.mPinLockedRegistrants.notifyRegistrants();
                    this.setExternalState(IccCardConstants.State.PIN_REQUIRED);
                    break;
                }
                case 4: {
                    this.setExternalState(IccCardConstants.State.PUK_REQUIRED);
                    break;
                }
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setExternalState(IccCardConstants.State newState) {
        this.setExternalState(newState, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccRecordsLoaded() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getRecordsLoaded();
            }
            return false;
        }
    }

    private final String $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccStateIntentString(IccCardConstants.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$IccCardConstants$State[state.ordinal()]) {
            case 1: {
                return "ABSENT";
            }
            case 2: {
                return "LOCKED";
            }
            case 3: {
                return "LOCKED";
            }
            case 4: {
                return "LOCKED";
            }
            case 5: {
                return "READY";
            }
            case 6: {
                return "NOT_READY";
            }
            case 7: {
                return "LOCKED";
            }
            case 8: {
                return "CARD_IO_ERROR";
            }
            case 9: {
                return "CARD_RESTRICTED";
            }
        }
        return "UNKNOWN";
    }

    private final String $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccStateReason(IccCardConstants.State state) {
        switch (1.$SwitchMap$com$android$internal$telephony$IccCardConstants$State[state.ordinal()]) {
            case 2: {
                return "PIN";
            }
            case 3: {
                return "PUK";
            }
            case 4: {
                return "NETWORK";
            }
            case 7: {
                return "PERM_DISABLED";
            }
            case 8: {
                return "CARD_IO_ERROR";
            }
            case 9: {
                return "CARD_RESTRICTED";
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccCardConstants.State $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getState() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mExternalState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccRecords $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccRecords() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mIccRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IccFileHandler $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccFileHandler() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                return this.mUiccApplication.getIccFileHandler();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerForAbsent(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mAbsentRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.ABSENT) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterForAbsent(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAbsentRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerForNetworkLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mNetworkLockedRegistrants.add(r);
            if (this.getState() == IccCardConstants.State.NETWORK_LOCKED) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterForNetworkLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mNetworkLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerForLocked(Handler h, int what, Object obj) {
        Object object = this.mLock;
        synchronized (object) {
            Registrant r = new Registrant(h, what, obj);
            this.mPinLockedRegistrants.add(r);
            if (this.getState().isPinLocked()) {
                r.notifyRegistrant();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterForLocked(Handler h) {
        Object object = this.mLock;
        synchronized (object) {
            this.mPinLockedRegistrants.remove(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPin(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPuk(String puk, String newPin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk(puk, newPin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPin2(String pin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPin2(pin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPuk2(String puk2, String newPin2, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyPuk2(puk2, newPin2, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyNetworkDepersonalization(String pin, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.supplyNetworkDepersonalization(pin, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("CommandsInterface is not set.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccLockEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccLockEnabled() : false;
            return retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccFdnEnabled() {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccFdnEnabled() : false;
            return retValue;
        }
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccFdnAvailable() {
        boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccFdnAvailable() : false;
        return retValue;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccPin2Blocked() {
        Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccPin2Blocked() : false;
        return retValue;
    }

    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccPuk2Blocked() {
        Boolean retValue = this.mUiccApplication != null ? this.mUiccApplication.getIccPuk2Blocked() : false;
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setIccLockEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccLockEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setIccFdnEnabled(boolean enabled, String password, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.setIccFdnEnabled(enabled, password, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$changeIccLockPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccLockPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$changeIccFdnPassword(String oldPassword, String newPassword, Message onComplete) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mUiccApplication != null) {
                this.mUiccApplication.changeIccFdnPassword(oldPassword, newPassword, onComplete);
            } else if (onComplete != null) {
                RuntimeException e = new RuntimeException("ICC card is absent.");
                AsyncResult.forMessage((Message)onComplete).exception = e;
                onComplete.sendToTarget();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getServiceProviderName() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mIccRecords != null) {
                return this.mIccRecords.getServiceProviderName();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$isApplicationOnIcc(IccCardApplicationStatus.AppType type) {
        Object object = this.mLock;
        synchronized (object) {
            Boolean retValue = this.mUiccCard != null ? this.mUiccCard.isApplicationOnIcc(type) : false;
            return retValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$com_android_internal_telephony_uicc_IccCardProxy$hasIccCard() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mUiccCard != null && this.mUiccCard.getCardState() != IccCardStatus.CardState.CARDSTATE_ABSENT;
            {
            }
        }
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setSystemProperty(String property, String value) {
        TelephonyManager.setTelephonyProperty(this.mPhoneId, property, value);
    }

    private final IccRecords $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccRecord() {
        return this.mIccRecords;
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$log(String s) {
        Rlog.d("IccCardProxy", s);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$loge(String msg) {
        Rlog.e("IccCardProxy", msg);
    }

    private final void $$robo$$com_android_internal_telephony_uicc_IccCardProxy$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        int i;
        pw.println("IccCardProxy: " + this);
        pw.println(" mContext=" + this.mContext);
        pw.println(" mCi=" + this.mCi);
        pw.println(" mAbsentRegistrants: size=" + this.mAbsentRegistrants.size());
        for (i = 0; i < this.mAbsentRegistrants.size(); ++i) {
            pw.println("  mAbsentRegistrants[" + i + "]=" + ((Registrant)this.mAbsentRegistrants.get(i)).getHandler());
        }
        pw.println(" mPinLockedRegistrants: size=" + this.mPinLockedRegistrants.size());
        for (i = 0; i < this.mPinLockedRegistrants.size(); ++i) {
            pw.println("  mPinLockedRegistrants[" + i + "]=" + ((Registrant)this.mPinLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mNetworkLockedRegistrants: size=" + this.mNetworkLockedRegistrants.size());
        for (i = 0; i < this.mNetworkLockedRegistrants.size(); ++i) {
            pw.println("  mNetworkLockedRegistrants[" + i + "]=" + ((Registrant)this.mNetworkLockedRegistrants.get(i)).getHandler());
        }
        pw.println(" mCurrentAppType=" + this.mCurrentAppType);
        pw.println(" mUiccController=" + this.mUiccController);
        pw.println(" mUiccCard=" + this.mUiccCard);
        pw.println(" mUiccApplication=" + this.mUiccApplication);
        pw.println(" mIccRecords=" + this.mIccRecords);
        pw.println(" mCdmaSSM=" + this.mCdmaSSM);
        pw.println(" mRadioState=" + (Object)((Object)this.mRadioState));
        pw.println(" mQuietMode=" + this.mQuietMode);
        pw.println(" mInitialized=" + this.mInitialized);
        pw.println(" mExternalState=" + (Object)((Object)this.mExternalState));
        pw.flush();
    }

    private void __constructor__(Context context, CommandsInterface commandsInterface, int n) {
        this.$$robo$$com_android_internal_telephony_uicc_IccCardProxy$__constructor__(context, commandsInterface, n);
    }

    public IccCardProxy(Context context, CommandsInterface commandsInterface, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$__constructor__(android.content.Context com.android.internal.telephony.CommandsInterface int ), 0, this, context, commandsInterface, n);
    }

    public void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$dispose(), 0, this);
    }

    public void setVoiceRadioTech(int n) {
        InvokeDynamicSupport.bootstrap("setVoiceRadioTech", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setVoiceRadioTech(int ), 0, this, n);
    }

    private void updateQuietMode() {
        InvokeDynamicSupport.bootstrap("updateQuietMode", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateQuietMode(), 0, this);
    }

    @Override
    public void handleMessage(Message message) {
        InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$handleMessage(android.os.Message ), 0, this, message);
    }

    private void onSubscriptionActivated() {
        InvokeDynamicSupport.bootstrap("onSubscriptionActivated", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$onSubscriptionActivated(), 0, this);
    }

    private void onSubscriptionDeactivated() {
        InvokeDynamicSupport.bootstrap("onSubscriptionDeactivated", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$onSubscriptionDeactivated(), 0, this);
    }

    private void onRecordsLoaded() {
        InvokeDynamicSupport.bootstrap("onRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$onRecordsLoaded(), 0, this);
    }

    private void updateIccAvailability() {
        InvokeDynamicSupport.bootstrap("updateIccAvailability", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateIccAvailability(), 0, this);
    }

    void resetProperties() {
        InvokeDynamicSupport.bootstrap("resetProperties", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$resetProperties(), 0, this);
    }

    private void HandleDetectedState() {
        InvokeDynamicSupport.bootstrap("HandleDetectedState", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$HandleDetectedState(), 0, this);
    }

    private void updateExternalState() {
        InvokeDynamicSupport.bootstrap("updateExternalState", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateExternalState(), 0, this);
    }

    private void registerUiccCardEvents() {
        InvokeDynamicSupport.bootstrap("registerUiccCardEvents", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerUiccCardEvents(), 0, this);
    }

    private void unregisterUiccCardEvents() {
        InvokeDynamicSupport.bootstrap("unregisterUiccCardEvents", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterUiccCardEvents(), 0, this);
    }

    private void updateStateProperty() {
        InvokeDynamicSupport.bootstrap("updateStateProperty", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$updateStateProperty(), 0, this);
    }

    private void broadcastIccStateChangedIntent(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("broadcastIccStateChangedIntent", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$broadcastIccStateChangedIntent(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void broadcastInternalIccStateChangedIntent(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("broadcastInternalIccStateChangedIntent", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$broadcastInternalIccStateChangedIntent(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    private void setExternalState(IccCardConstants.State state, boolean bl) {
        InvokeDynamicSupport.bootstrap("setExternalState", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setExternalState(com.android.internal.telephony.IccCardConstants$State boolean ), 0, this, state, bl);
    }

    private void processLockedState() {
        InvokeDynamicSupport.bootstrap("processLockedState", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$processLockedState(), 0, this);
    }

    private void setExternalState(IccCardConstants.State state) {
        InvokeDynamicSupport.bootstrap("setExternalState", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setExternalState(com.android.internal.telephony.IccCardConstants$State ), 0, this, state);
    }

    public boolean getIccRecordsLoaded() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccRecordsLoaded", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccRecordsLoaded(), 0, this);
    }

    private String getIccStateIntentString(IccCardConstants.State state) {
        return InvokeDynamicSupport.bootstrap("getIccStateIntentString", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccStateIntentString(com.android.internal.telephony.IccCardConstants$State ), 0, this, state);
    }

    private String getIccStateReason(IccCardConstants.State state) {
        return InvokeDynamicSupport.bootstrap("getIccStateReason", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccStateReason(com.android.internal.telephony.IccCardConstants$State ), 0, this, state);
    }

    @Override
    public IccCardConstants.State getState() {
        return InvokeDynamicSupport.bootstrap("getState", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getState(), 0, this);
    }

    @Override
    public IccRecords getIccRecords() {
        return InvokeDynamicSupport.bootstrap("getIccRecords", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccRecords(), 0, this);
    }

    @Override
    public IccFileHandler getIccFileHandler() {
        return InvokeDynamicSupport.bootstrap("getIccFileHandler", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccFileHandler(), 0, this);
    }

    @Override
    public void registerForAbsent(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForAbsent", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerForAbsent(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForAbsent(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForAbsent", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterForAbsent(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForNetworkLocked(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForNetworkLocked", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerForNetworkLocked(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForNetworkLocked(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForNetworkLocked", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterForNetworkLocked(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void registerForLocked(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("registerForLocked", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$registerForLocked(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    @Override
    public void unregisterForLocked(Handler handler) {
        InvokeDynamicSupport.bootstrap("unregisterForLocked", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$unregisterForLocked(android.os.Handler ), 0, this, handler);
    }

    @Override
    public void supplyPin(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPin", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPin(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyPuk(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPuk", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPuk(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyPin2(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPin2", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPin2(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public void supplyPuk2(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("supplyPuk2", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyPuk2(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void supplyNetworkDepersonalization(String string2, Message message) {
        InvokeDynamicSupport.bootstrap("supplyNetworkDepersonalization", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$supplyNetworkDepersonalization(java.lang.String android.os.Message ), 0, this, string2, message);
    }

    @Override
    public boolean getIccLockEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccLockEnabled", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccLockEnabled(), 0, this);
    }

    @Override
    public boolean getIccFdnEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccFdnEnabled", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccFdnEnabled(), 0, this);
    }

    @Override
    public boolean getIccFdnAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccFdnAvailable", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccFdnAvailable(), 0, this);
    }

    @Override
    public boolean getIccPin2Blocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccPin2Blocked", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccPin2Blocked(), 0, this);
    }

    @Override
    public boolean getIccPuk2Blocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("getIccPuk2Blocked", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccPuk2Blocked(), 0, this);
    }

    @Override
    public void setIccLockEnabled(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setIccLockEnabled", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setIccLockEnabled(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    @Override
    public void setIccFdnEnabled(boolean bl, String string2, Message message) {
        InvokeDynamicSupport.bootstrap("setIccFdnEnabled", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setIccFdnEnabled(boolean java.lang.String android.os.Message ), 0, this, bl, string2, message);
    }

    @Override
    public void changeIccLockPassword(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccLockPassword", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$changeIccLockPassword(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public void changeIccFdnPassword(String string2, String string3, Message message) {
        InvokeDynamicSupport.bootstrap("changeIccFdnPassword", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$changeIccFdnPassword(java.lang.String java.lang.String android.os.Message ), 0, this, string2, string3, message);
    }

    @Override
    public String getServiceProviderName() {
        return InvokeDynamicSupport.bootstrap("getServiceProviderName", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getServiceProviderName(), 0, this);
    }

    @Override
    public boolean isApplicationOnIcc(IccCardApplicationStatus.AppType appType) {
        return (boolean)InvokeDynamicSupport.bootstrap("isApplicationOnIcc", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$isApplicationOnIcc(com.android.internal.telephony.uicc.IccCardApplicationStatus$AppType ), 0, this, appType);
    }

    @Override
    public boolean hasIccCard() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIccCard", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$hasIccCard(), 0, this);
    }

    private void setSystemProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("setSystemProperty", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$setSystemProperty(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public IccRecords getIccRecord() {
        return InvokeDynamicSupport.bootstrap("getIccRecord", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$getIccRecord(), 0, this);
    }

    private void log(String string2) {
        InvokeDynamicSupport.bootstrap("log", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$log(java.lang.String ), 0, this, string2);
    }

    private void loge(String string2) {
        InvokeDynamicSupport.bootstrap("loge", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$loge(java.lang.String ), 0, this, string2);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$com_android_internal_telephony_uicc_IccCardProxy$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public /* synthetic */ IccCardProxy() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IccCardProxy)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

