/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.ActionProvider;
import android.view.ContextMenu;
import android.view.KeyCharacterMap;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.SubMenu;
import android.view.View;
import com.android.internal.view.menu.MenuItemImpl;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.SubMenuBuilder;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MenuBuilder
implements Menu,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MenuBuilder";
    private static String PRESENTER_KEY = "android:menu:presenters";
    private static String ACTION_VIEW_STATES_KEY = "android:menu:actionviewstates";
    private static String EXPANDED_ACTION_VIEW_ID = "android:menu:expandedactionview";
    private static int[] sCategoryToOrder;
    private Context mContext;
    private Resources mResources;
    private boolean mQwertyMode;
    private boolean mShortcutsVisible;
    private Callback mCallback;
    private ArrayList<MenuItemImpl> mItems;
    private ArrayList<MenuItemImpl> mVisibleItems;
    private boolean mIsVisibleItemsStale;
    private ArrayList<MenuItemImpl> mActionItems;
    private ArrayList<MenuItemImpl> mNonActionItems;
    private boolean mIsActionItemsStale;
    private int mDefaultShowAsAction;
    private ContextMenu.ContextMenuInfo mCurrentMenuInfo;
    CharSequence mHeaderTitle;
    Drawable mHeaderIcon;
    View mHeaderView;
    private SparseArray<Parcelable> mFrozenViewStates;
    private boolean mPreventDispatchingItemsChanged;
    private boolean mItemsChangedWhileDispatchPrevented;
    private boolean mOptionalIconsVisible;
    private boolean mIsClosing;
    private ArrayList<MenuItemImpl> mTempShortcutItemList;
    private CopyOnWriteArrayList<WeakReference<MenuPresenter>> mPresenters;
    private MenuItemImpl mExpandedItem;

    private void $$robo$$com_android_internal_view_menu_MenuBuilder$__constructor__(Context context) {
        this.mDefaultShowAsAction = 0;
        this.mPreventDispatchingItemsChanged = false;
        this.mItemsChangedWhileDispatchPrevented = false;
        this.mOptionalIconsVisible = false;
        this.mIsClosing = false;
        this.mTempShortcutItemList = new ArrayList();
        this.mPresenters = new CopyOnWriteArrayList();
        this.mContext = context;
        this.mResources = context.getResources();
        this.mItems = new ArrayList();
        this.mVisibleItems = new ArrayList();
        this.mIsVisibleItemsStale = true;
        this.mActionItems = new ArrayList();
        this.mNonActionItems = new ArrayList();
        this.mIsActionItemsStale = true;
        this.setShortcutsVisibleInner(true);
    }

    private final MenuBuilder $$robo$$com_android_internal_view_menu_MenuBuilder$setDefaultShowAsAction(int defaultShowAsAction) {
        this.mDefaultShowAsAction = defaultShowAsAction;
        return this;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$addMenuPresenter(MenuPresenter presenter) {
        this.addMenuPresenter(presenter, this.mContext);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$addMenuPresenter(MenuPresenter presenter, Context menuContext) {
        this.mPresenters.add(new WeakReference<MenuPresenter>(presenter));
        presenter.initForMenu(menuContext, this);
        this.mIsActionItemsStale = true;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$removeMenuPresenter(MenuPresenter presenter) {
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter item = (MenuPresenter)ref.get();
            if (item != null && item != presenter) continue;
            this.mPresenters.remove(ref);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchPresenterUpdate(boolean cleared) {
        if (this.mPresenters.isEmpty()) {
            return;
        }
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            presenter.updateMenuView(cleared);
        }
        this.startDispatchingItemsChanged();
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchSubMenuSelected(SubMenuBuilder subMenu, MenuPresenter preferredPresenter) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean result = false;
        if (preferredPresenter != null) {
            result = preferredPresenter.onSubMenuSelected(subMenu);
        }
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            if (result) continue;
            result = presenter.onSubMenuSelected(subMenu);
        }
        return result;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchSaveInstanceState(Bundle outState) {
        if (this.mPresenters.isEmpty()) {
            return;
        }
        SparseArray<Parcelable> presenterStates = new SparseArray<Parcelable>();
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            Parcelable state;
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            int id2 = presenter.getId();
            if (id2 <= 0 || (state = presenter.onSaveInstanceState()) == null) continue;
            presenterStates.put(id2, state);
        }
        outState.putSparseParcelableArray("android:menu:presenters", presenterStates);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchRestoreInstanceState(Bundle state) {
        SparseArray presenterStates = state.getSparseParcelableArray("android:menu:presenters");
        if (presenterStates == null || this.mPresenters.isEmpty()) {
            return;
        }
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            Parcelable parcel;
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            int id2 = presenter.getId();
            if (id2 <= 0 || (parcel = (Parcelable)presenterStates.get(id2)) == null) continue;
            presenter.onRestoreInstanceState(parcel);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$savePresenterStates(Bundle outState) {
        this.dispatchSaveInstanceState(outState);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$restorePresenterStates(Bundle state) {
        this.dispatchRestoreInstanceState(state);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$saveActionViewStates(Bundle outStates) {
        SparseArray viewStates = null;
        int itemCount = this.size();
        for (int i = 0; i < itemCount; ++i) {
            MenuItem item = this.getItem(i);
            View v = item.getActionView();
            if (v != null && v.getId() != -1) {
                if (viewStates == null) {
                    viewStates = new SparseArray();
                }
                v.saveHierarchyState(viewStates);
                if (item.isActionViewExpanded()) {
                    outStates.putInt("android:menu:expandedactionview", item.getItemId());
                }
            }
            if (!item.hasSubMenu()) continue;
            SubMenuBuilder subMenu = (SubMenuBuilder)item.getSubMenu();
            subMenu.saveActionViewStates(outStates);
        }
        if (viewStates != null) {
            outStates.putSparseParcelableArray(this.getActionViewStatesKey(), viewStates);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$restoreActionViewStates(Bundle states) {
        MenuItem itemToExpand;
        if (states == null) {
            return;
        }
        SparseArray<Parcelable> viewStates = states.getSparseParcelableArray(this.getActionViewStatesKey());
        int itemCount = this.size();
        for (int i = 0; i < itemCount; ++i) {
            MenuItem item = this.getItem(i);
            View v = item.getActionView();
            if (v != null && v.getId() != -1) {
                v.restoreHierarchyState(viewStates);
            }
            if (!item.hasSubMenu()) continue;
            SubMenuBuilder subMenu = (SubMenuBuilder)item.getSubMenu();
            subMenu.restoreActionViewStates(states);
        }
        int expandedId = states.getInt("android:menu:expandedactionview");
        if (expandedId > 0 && (itemToExpand = this.findItem(expandedId)) != null) {
            itemToExpand.expandActionView();
        }
    }

    private final String $$robo$$com_android_internal_view_menu_MenuBuilder$getActionViewStatesKey() {
        return "android:menu:actionviewstates";
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setCallback(Callback cb) {
        this.mCallback = cb;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuBuilder$addInternal(int group, int id2, int categoryOrder, CharSequence title) {
        int ordering = MenuBuilder.getOrdering(categoryOrder);
        MenuItemImpl item = this.createNewMenuItem(group, id2, categoryOrder, ordering, title, this.mDefaultShowAsAction);
        if (this.mCurrentMenuInfo != null) {
            item.setMenuInfo(this.mCurrentMenuInfo);
        }
        this.mItems.add(MenuBuilder.findInsertIndex(this.mItems, ordering), item);
        this.onItemsChanged(true);
        return item;
    }

    private final MenuItemImpl $$robo$$com_android_internal_view_menu_MenuBuilder$createNewMenuItem(int group, int id2, int categoryOrder, int ordering, CharSequence title, int defaultShowAsAction) {
        return new MenuItemImpl(this, group, id2, categoryOrder, ordering, title, defaultShowAsAction);
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuBuilder$add(CharSequence title) {
        return this.addInternal(0, 0, 0, title);
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuBuilder$add(int titleRes) {
        return this.addInternal(0, 0, 0, this.mResources.getString(titleRes));
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuBuilder$add(int group, int id2, int categoryOrder, CharSequence title) {
        return this.addInternal(group, id2, categoryOrder, title);
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuBuilder$add(int group, int id2, int categoryOrder, int title) {
        return this.addInternal(group, id2, categoryOrder, this.mResources.getString(title));
    }

    private final SubMenu $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(CharSequence title) {
        return this.addSubMenu(0, 0, 0, title);
    }

    private final SubMenu $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(int titleRes) {
        return this.addSubMenu(0, 0, 0, this.mResources.getString(titleRes));
    }

    private final SubMenu $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(int group, int id2, int categoryOrder, CharSequence title) {
        MenuItemImpl item = (MenuItemImpl)this.addInternal(group, id2, categoryOrder, title);
        SubMenuBuilder subMenu = new SubMenuBuilder(this.mContext, this, item);
        item.setSubMenu(subMenu);
        return subMenu;
    }

    private final SubMenu $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(int group, int id2, int categoryOrder, int title) {
        return this.addSubMenu(group, id2, categoryOrder, this.mResources.getString(title));
    }

    private final int $$robo$$com_android_internal_view_menu_MenuBuilder$addIntentOptions(int group, int id2, int categoryOrder, ComponentName caller, Intent[] specifics, Intent intent, int flags, MenuItem[] outSpecificItems) {
        int N;
        PackageManager pm = this.mContext.getPackageManager();
        List<ResolveInfo> lri = pm.queryIntentActivityOptions(caller, specifics, intent, 0);
        int n = N = lri != null ? lri.size() : 0;
        if ((flags & 1) == 0) {
            this.removeGroup(group);
        }
        for (int i = 0; i < N; ++i) {
            ResolveInfo ri = lri.get(i);
            Intent rintent = new Intent(ri.specificIndex < 0 ? intent : specifics[ri.specificIndex]);
            rintent.setComponent(new ComponentName(ri.activityInfo.applicationInfo.packageName, ri.activityInfo.name));
            MenuItem item = this.add(group, id2, categoryOrder, ri.loadLabel(pm)).setIcon(ri.loadIcon(pm)).setIntent(rintent);
            if (outSpecificItems == null || ri.specificIndex < 0) continue;
            outSpecificItems[ri.specificIndex] = item;
        }
        return N;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$removeItem(int id2) {
        this.removeItemAtInt(this.findItemIndex(id2), true);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$removeGroup(int group) {
        int i = this.findGroupIndex(group);
        if (i >= 0) {
            int maxRemovable = this.mItems.size() - i;
            int numRemoved = 0;
            while (numRemoved++ < maxRemovable && this.mItems.get(i).getGroupId() == group) {
                this.removeItemAtInt(i, false);
            }
            this.onItemsChanged(true);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$removeItemAtInt(int index, boolean updateChildrenOnMenuViews) {
        if (index < 0 || index >= this.mItems.size()) {
            return;
        }
        this.mItems.remove(index);
        if (updateChildrenOnMenuViews) {
            this.onItemsChanged(true);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$removeItemAt(int index) {
        this.removeItemAtInt(index, true);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$clearAll() {
        this.mPreventDispatchingItemsChanged = true;
        this.clear();
        this.clearHeader();
        this.mPreventDispatchingItemsChanged = false;
        this.mItemsChangedWhileDispatchPrevented = false;
        this.onItemsChanged(true);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$clear() {
        if (this.mExpandedItem != null) {
            this.collapseItemActionView(this.mExpandedItem);
        }
        this.mItems.clear();
        this.onItemsChanged(true);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setExclusiveItemChecked(MenuItem item) {
        int group = item.getGroupId();
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl curItem = this.mItems.get(i);
            if (curItem.getGroupId() != group || !curItem.isExclusiveCheckable() || !curItem.isCheckable()) continue;
            curItem.setCheckedInt(curItem == item);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setGroupCheckable(int group, boolean checkable, boolean exclusive) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            item.setExclusiveCheckable(exclusive);
            item.setCheckable(checkable);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setGroupVisible(int group, boolean visible) {
        int N = this.mItems.size();
        boolean changedAtLeastOneItem = false;
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group || !item.setVisibleInt(visible)) continue;
            changedAtLeastOneItem = true;
        }
        if (changedAtLeastOneItem) {
            this.onItemsChanged(true);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setGroupEnabled(int group, boolean enabled) {
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            item.setEnabled(enabled);
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$hasVisibleItems() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (!item.isVisible()) continue;
            return true;
        }
        return false;
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuBuilder$findItem(int id2) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItem possibleItem;
            MenuItemImpl item = this.mItems.get(i);
            if (item.getItemId() == id2) {
                return item;
            }
            if (!item.hasSubMenu() || (possibleItem = item.getSubMenu().findItem(id2)) == null) continue;
            return possibleItem;
        }
        return null;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuBuilder$findItemIndex(int id2) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getItemId() != id2) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuBuilder$findGroupIndex(int group) {
        return this.findGroupIndex(group, 0);
    }

    private final int $$robo$$com_android_internal_view_menu_MenuBuilder$findGroupIndex(int group, int start) {
        int size = this.size();
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < size; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (item.getGroupId() != group) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuBuilder$size() {
        return this.mItems.size();
    }

    private final MenuItem $$robo$$com_android_internal_view_menu_MenuBuilder$getItem(int index) {
        return this.mItems.get(index);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$isShortcutKey(int keyCode, KeyEvent event) {
        return this.findItemWithShortcutForKey(keyCode, event) != null;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setQwertyMode(boolean isQwerty) {
        this.mQwertyMode = isQwerty;
        this.onItemsChanged(false);
    }

    private static final int $$robo$$com_android_internal_view_menu_MenuBuilder$getOrdering(int categoryOrder) {
        int index = (categoryOrder & 0xFFFF0000) >> 16;
        if (index < 0 || index >= sCategoryToOrder.length) {
            throw new IllegalArgumentException("order does not contain a valid category.");
        }
        return sCategoryToOrder[index] << 16 | categoryOrder & 0xFFFF;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$isQwertyMode() {
        return this.mQwertyMode;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setShortcutsVisible(boolean shortcutsVisible) {
        if (this.mShortcutsVisible == shortcutsVisible) {
            return;
        }
        this.setShortcutsVisibleInner(shortcutsVisible);
        this.onItemsChanged(false);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setShortcutsVisibleInner(boolean shortcutsVisible) {
        this.mShortcutsVisible = shortcutsVisible && this.mResources.getConfiguration().keyboard != 1 && this.mResources.getBoolean(17957008);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$isShortcutsVisible() {
        return this.mShortcutsVisible;
    }

    private final Resources $$robo$$com_android_internal_view_menu_MenuBuilder$getResources() {
        return this.mResources;
    }

    private final Context $$robo$$com_android_internal_view_menu_MenuBuilder$getContext() {
        return this.mContext;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchMenuItemSelected(MenuBuilder menu2, MenuItem item) {
        return this.mCallback != null && this.mCallback.onMenuItemSelected(menu2, item);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$changeMenuMode() {
        if (this.mCallback != null) {
            this.mCallback.onMenuModeChange(this);
        }
    }

    private static final int $$robo$$com_android_internal_view_menu_MenuBuilder$findInsertIndex(ArrayList<MenuItemImpl> items, int ordering) {
        for (int i = items.size() - 1; i >= 0; --i) {
            MenuItemImpl item = items.get(i);
            if (item.getOrdering() > ordering) continue;
            return i + 1;
        }
        return 0;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$performShortcut(int keyCode, KeyEvent event, int flags) {
        MenuItemImpl item = this.findItemWithShortcutForKey(keyCode, event);
        boolean handled = false;
        if (item != null) {
            handled = this.performItemAction(item, flags);
        }
        if ((flags & 2) != 0) {
            this.close(true);
        }
        return handled;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$findItemsWithShortcutForKey(List<MenuItemImpl> items, int keyCode, KeyEvent event) {
        boolean qwerty = this.isQwertyMode();
        int modifierState = event.getModifiers();
        KeyCharacterMap.KeyData possibleChars = new KeyCharacterMap.KeyData();
        boolean isKeyCodeMapped = event.getKeyData(possibleChars);
        if (!isKeyCodeMapped && keyCode != 67) {
            return;
        }
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            boolean isModifiersExactMatch;
            MenuItemImpl item = this.mItems.get(i);
            if (item.hasSubMenu()) {
                ((MenuBuilder)((Object)item.getSubMenu())).findItemsWithShortcutForKey(items, keyCode, event);
            }
            char shortcutChar = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            int shortcutModifiers = qwerty ? item.getAlphabeticModifiers() : item.getNumericModifiers();
            boolean bl = isModifiersExactMatch = (modifierState & 0x1100F) == (shortcutModifiers & 0x1100F);
            if (!isModifiersExactMatch || shortcutChar == '\u0000' || shortcutChar != possibleChars.meta[0] && shortcutChar != possibleChars.meta[2] && (!qwerty || shortcutChar != '\b' || keyCode != 67) || !item.isEnabled()) continue;
            items.add(item);
        }
    }

    private final MenuItemImpl $$robo$$com_android_internal_view_menu_MenuBuilder$findItemWithShortcutForKey(int keyCode, KeyEvent event) {
        ArrayList<MenuItemImpl> items = this.mTempShortcutItemList;
        items.clear();
        this.findItemsWithShortcutForKey(items, keyCode, event);
        if (items.isEmpty()) {
            return null;
        }
        int metaState = event.getMetaState();
        KeyCharacterMap.KeyData possibleChars = new KeyCharacterMap.KeyData();
        event.getKeyData(possibleChars);
        int size = items.size();
        if (size == 1) {
            return items.get(0);
        }
        boolean qwerty = this.isQwertyMode();
        for (int i = 0; i < size; ++i) {
            char shortcutChar;
            MenuItemImpl item = items.get(i);
            char c = shortcutChar = qwerty ? item.getAlphabeticShortcut() : item.getNumericShortcut();
            if (!(shortcutChar == possibleChars.meta[0] && (metaState & 2) == 0 || shortcutChar == possibleChars.meta[2] && (metaState & 2) != 0) && (!qwerty || shortcutChar != '\b' || keyCode != 67)) continue;
            return item;
        }
        return null;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$performIdentifierAction(int id2, int flags) {
        return this.performItemAction(this.findItem(id2), flags);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$performItemAction(MenuItem item, int flags) {
        return this.performItemAction(item, null, flags);
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$performItemAction(MenuItem item, MenuPresenter preferredPresenter, int flags) {
        boolean providerHasSubMenu;
        MenuItemImpl itemImpl = (MenuItemImpl)item;
        if (itemImpl == null || !itemImpl.isEnabled()) {
            return false;
        }
        boolean invoked = itemImpl.invoke();
        ActionProvider provider = item.getActionProvider();
        boolean bl = providerHasSubMenu = provider != null && provider.hasSubMenu();
        if (itemImpl.hasCollapsibleActionView()) {
            if (invoked |= itemImpl.expandActionView()) {
                this.close(true);
            }
        } else if (itemImpl.hasSubMenu() || providerHasSubMenu) {
            if (!itemImpl.hasSubMenu()) {
                itemImpl.setSubMenu(new SubMenuBuilder(this.getContext(), this, itemImpl));
            }
            SubMenuBuilder subMenu = (SubMenuBuilder)itemImpl.getSubMenu();
            if (providerHasSubMenu) {
                provider.onPrepareSubMenu(subMenu);
            }
            if (!(invoked |= this.dispatchSubMenuSelected(subMenu, preferredPresenter))) {
                this.close(true);
            }
        } else if ((flags & 1) == 0) {
            this.close(true);
        }
        return invoked;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$close(boolean closeAllMenus) {
        if (this.mIsClosing) {
            return;
        }
        this.mIsClosing = true;
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            presenter.onCloseMenu(this, closeAllMenus);
        }
        this.mIsClosing = false;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$close() {
        this.close(true);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$onItemsChanged(boolean structureChanged) {
        if (!this.mPreventDispatchingItemsChanged) {
            if (structureChanged) {
                this.mIsVisibleItemsStale = true;
                this.mIsActionItemsStale = true;
            }
            this.dispatchPresenterUpdate(structureChanged);
        } else {
            this.mItemsChangedWhileDispatchPrevented = true;
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$stopDispatchingItemsChanged() {
        if (!this.mPreventDispatchingItemsChanged) {
            this.mPreventDispatchingItemsChanged = true;
            this.mItemsChangedWhileDispatchPrevented = false;
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$startDispatchingItemsChanged() {
        this.mPreventDispatchingItemsChanged = false;
        if (this.mItemsChangedWhileDispatchPrevented) {
            this.mItemsChangedWhileDispatchPrevented = false;
            this.onItemsChanged(true);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$onItemVisibleChanged(MenuItemImpl item) {
        this.mIsVisibleItemsStale = true;
        this.onItemsChanged(true);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$onItemActionRequestChanged(MenuItemImpl item) {
        this.mIsActionItemsStale = true;
        this.onItemsChanged(true);
    }

    private final ArrayList<MenuItemImpl> $$robo$$com_android_internal_view_menu_MenuBuilder$getVisibleItems() {
        if (!this.mIsVisibleItemsStale) {
            return this.mVisibleItems;
        }
        this.mVisibleItems.clear();
        int itemsSize = this.mItems.size();
        for (int i = 0; i < itemsSize; ++i) {
            MenuItemImpl item = this.mItems.get(i);
            if (!item.isVisible()) continue;
            this.mVisibleItems.add(item);
        }
        this.mIsVisibleItemsStale = false;
        this.mIsActionItemsStale = true;
        return this.mVisibleItems;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$flagActionItems() {
        ArrayList<MenuItemImpl> visibleItems = this.getVisibleItems();
        if (!this.mIsActionItemsStale) {
            return;
        }
        boolean flagged = false;
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            flagged |= presenter.flagActionItems();
        }
        if (flagged) {
            this.mActionItems.clear();
            this.mNonActionItems.clear();
            int itemsSize = visibleItems.size();
            for (int i = 0; i < itemsSize; ++i) {
                MenuItemImpl item = visibleItems.get(i);
                if (item.isActionButton()) {
                    this.mActionItems.add(item);
                    continue;
                }
                this.mNonActionItems.add(item);
            }
        } else {
            this.mActionItems.clear();
            this.mNonActionItems.clear();
            this.mNonActionItems.addAll(this.getVisibleItems());
        }
        this.mIsActionItemsStale = false;
    }

    private final ArrayList<MenuItemImpl> $$robo$$com_android_internal_view_menu_MenuBuilder$getActionItems() {
        this.flagActionItems();
        return this.mActionItems;
    }

    private final ArrayList<MenuItemImpl> $$robo$$com_android_internal_view_menu_MenuBuilder$getNonActionItems() {
        this.flagActionItems();
        return this.mNonActionItems;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$clearHeader() {
        this.mHeaderIcon = null;
        this.mHeaderTitle = null;
        this.mHeaderView = null;
        this.onItemsChanged(false);
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderInternal(int titleRes, CharSequence title, int iconRes, Drawable icon, View view) {
        Resources r = this.getResources();
        if (view != null) {
            this.mHeaderView = view;
            this.mHeaderTitle = null;
            this.mHeaderIcon = null;
        } else {
            if (titleRes > 0) {
                this.mHeaderTitle = r.getText(titleRes);
            } else if (title != null) {
                this.mHeaderTitle = title;
            }
            if (iconRes > 0) {
                this.mHeaderIcon = this.getContext().getDrawable(iconRes);
            } else if (icon != null) {
                this.mHeaderIcon = icon;
            }
            this.mHeaderView = null;
        }
        this.onItemsChanged(false);
    }

    private final MenuBuilder $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderTitleInt(CharSequence title) {
        this.setHeaderInternal(0, title, 0, null, null);
        return this;
    }

    private final MenuBuilder $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderTitleInt(int titleRes) {
        this.setHeaderInternal(titleRes, null, 0, null, null);
        return this;
    }

    private final MenuBuilder $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderIconInt(Drawable icon) {
        this.setHeaderInternal(0, null, 0, icon, null);
        return this;
    }

    private final MenuBuilder $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderIconInt(int iconRes) {
        this.setHeaderInternal(0, null, iconRes, null, null);
        return this;
    }

    private final MenuBuilder $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderViewInt(View view) {
        this.setHeaderInternal(0, null, 0, null, view);
        return this;
    }

    private final CharSequence $$robo$$com_android_internal_view_menu_MenuBuilder$getHeaderTitle() {
        return this.mHeaderTitle;
    }

    private final Drawable $$robo$$com_android_internal_view_menu_MenuBuilder$getHeaderIcon() {
        return this.mHeaderIcon;
    }

    private final View $$robo$$com_android_internal_view_menu_MenuBuilder$getHeaderView() {
        return this.mHeaderView;
    }

    private final MenuBuilder $$robo$$com_android_internal_view_menu_MenuBuilder$getRootMenu() {
        return this;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setCurrentMenuInfo(ContextMenu.ContextMenuInfo menuInfo) {
        this.mCurrentMenuInfo = menuInfo;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuBuilder$setOptionalIconsVisible(boolean visible) {
        this.mOptionalIconsVisible = visible;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$getOptionalIconsVisible() {
        return this.mOptionalIconsVisible;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$expandItemActionView(MenuItemImpl item) {
        if (this.mPresenters.isEmpty()) {
            return false;
        }
        boolean expanded = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            expanded = presenter.expandItemActionView(this, item);
            if (!expanded) continue;
            break;
        }
        this.startDispatchingItemsChanged();
        if (expanded) {
            this.mExpandedItem = item;
        }
        return expanded;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuBuilder$collapseItemActionView(MenuItemImpl item) {
        if (this.mPresenters.isEmpty() || this.mExpandedItem != item) {
            return false;
        }
        boolean collapsed = false;
        this.stopDispatchingItemsChanged();
        for (WeakReference<MenuPresenter> ref : this.mPresenters) {
            MenuPresenter presenter = (MenuPresenter)ref.get();
            if (presenter == null) {
                this.mPresenters.remove(ref);
                continue;
            }
            collapsed = presenter.collapseItemActionView(this, item);
            if (!collapsed) continue;
            break;
        }
        this.startDispatchingItemsChanged();
        if (collapsed) {
            this.mExpandedItem = null;
        }
        return collapsed;
    }

    private final MenuItemImpl $$robo$$com_android_internal_view_menu_MenuBuilder$getExpandedItem() {
        return this.mExpandedItem;
    }

    static void __staticInitializer__() {
        sCategoryToOrder = new int[]{1, 4, 5, 3, 2, 0};
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_view_menu_MenuBuilder$__constructor__(context);
    }

    public MenuBuilder(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuBuilder$__constructor__(android.content.Context ), 0, this, context);
    }

    public MenuBuilder setDefaultShowAsAction(int n) {
        return InvokeDynamicSupport.bootstrap("setDefaultShowAsAction", $$robo$$com_android_internal_view_menu_MenuBuilder$setDefaultShowAsAction(int ), 0, this, n);
    }

    public void addMenuPresenter(MenuPresenter menuPresenter) {
        InvokeDynamicSupport.bootstrap("addMenuPresenter", $$robo$$com_android_internal_view_menu_MenuBuilder$addMenuPresenter(com.android.internal.view.menu.MenuPresenter ), 0, this, menuPresenter);
    }

    public void addMenuPresenter(MenuPresenter menuPresenter, Context context) {
        InvokeDynamicSupport.bootstrap("addMenuPresenter", $$robo$$com_android_internal_view_menu_MenuBuilder$addMenuPresenter(com.android.internal.view.menu.MenuPresenter android.content.Context ), 0, this, menuPresenter, context);
    }

    public void removeMenuPresenter(MenuPresenter menuPresenter) {
        InvokeDynamicSupport.bootstrap("removeMenuPresenter", $$robo$$com_android_internal_view_menu_MenuBuilder$removeMenuPresenter(com.android.internal.view.menu.MenuPresenter ), 0, this, menuPresenter);
    }

    private void dispatchPresenterUpdate(boolean bl) {
        InvokeDynamicSupport.bootstrap("dispatchPresenterUpdate", $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchPresenterUpdate(boolean ), 0, this, bl);
    }

    private boolean dispatchSubMenuSelected(SubMenuBuilder subMenuBuilder, MenuPresenter menuPresenter) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchSubMenuSelected", $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchSubMenuSelected(com.android.internal.view.menu.SubMenuBuilder com.android.internal.view.menu.MenuPresenter ), 0, this, subMenuBuilder, menuPresenter);
    }

    private void dispatchSaveInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchSaveInstanceState", $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchSaveInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    private void dispatchRestoreInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchRestoreInstanceState(android.os.Bundle ), 0, this, bundle);
    }

    public void savePresenterStates(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("savePresenterStates", $$robo$$com_android_internal_view_menu_MenuBuilder$savePresenterStates(android.os.Bundle ), 0, this, bundle);
    }

    public void restorePresenterStates(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("restorePresenterStates", $$robo$$com_android_internal_view_menu_MenuBuilder$restorePresenterStates(android.os.Bundle ), 0, this, bundle);
    }

    public void saveActionViewStates(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("saveActionViewStates", $$robo$$com_android_internal_view_menu_MenuBuilder$saveActionViewStates(android.os.Bundle ), 0, this, bundle);
    }

    public void restoreActionViewStates(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("restoreActionViewStates", $$robo$$com_android_internal_view_menu_MenuBuilder$restoreActionViewStates(android.os.Bundle ), 0, this, bundle);
    }

    protected String getActionViewStatesKey() {
        return InvokeDynamicSupport.bootstrap("getActionViewStatesKey", $$robo$$com_android_internal_view_menu_MenuBuilder$getActionViewStatesKey(), 0, this);
    }

    public void setCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("setCallback", $$robo$$com_android_internal_view_menu_MenuBuilder$setCallback(com.android.internal.view.menu.MenuBuilder$Callback ), 0, this, callback);
    }

    private MenuItem addInternal(int n, int n2, int n3, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("addInternal", $$robo$$com_android_internal_view_menu_MenuBuilder$addInternal(int int int java.lang.CharSequence ), 0, this, n, n2, n3, charSequence);
    }

    private MenuItemImpl createNewMenuItem(int n, int n2, int n3, int n4, CharSequence charSequence, int n5) {
        return InvokeDynamicSupport.bootstrap("createNewMenuItem", $$robo$$com_android_internal_view_menu_MenuBuilder$createNewMenuItem(int int int int java.lang.CharSequence int ), 0, this, n, n2, n3, n4, charSequence, n5);
    }

    @Override
    public MenuItem add(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_view_menu_MenuBuilder$add(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public MenuItem add(int n) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_view_menu_MenuBuilder$add(int ), 0, this, n);
    }

    @Override
    public MenuItem add(int n, int n2, int n3, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_view_menu_MenuBuilder$add(int int int java.lang.CharSequence ), 0, this, n, n2, n3, charSequence);
    }

    @Override
    public MenuItem add(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_view_menu_MenuBuilder$add(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public SubMenu addSubMenu(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("addSubMenu", $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(java.lang.CharSequence ), 0, this, charSequence);
    }

    @Override
    public SubMenu addSubMenu(int n) {
        return InvokeDynamicSupport.bootstrap("addSubMenu", $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(int ), 0, this, n);
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("addSubMenu", $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(int int int java.lang.CharSequence ), 0, this, n, n2, n3, charSequence);
    }

    @Override
    public SubMenu addSubMenu(int n, int n2, int n3, int n4) {
        return InvokeDynamicSupport.bootstrap("addSubMenu", $$robo$$com_android_internal_view_menu_MenuBuilder$addSubMenu(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public int addIntentOptions(int n, int n2, int n3, ComponentName componentName, Intent[] intentArray, Intent intent, int n4, MenuItem[] menuItemArray) {
        return (int)InvokeDynamicSupport.bootstrap("addIntentOptions", $$robo$$com_android_internal_view_menu_MenuBuilder$addIntentOptions(int int int android.content.ComponentName android.content.Intent[] android.content.Intent int android.view.MenuItem[] ), 0, this, n, n2, n3, componentName, intentArray, intent, n4, menuItemArray);
    }

    @Override
    public void removeItem(int n) {
        InvokeDynamicSupport.bootstrap("removeItem", $$robo$$com_android_internal_view_menu_MenuBuilder$removeItem(int ), 0, this, n);
    }

    @Override
    public void removeGroup(int n) {
        InvokeDynamicSupport.bootstrap("removeGroup", $$robo$$com_android_internal_view_menu_MenuBuilder$removeGroup(int ), 0, this, n);
    }

    private void removeItemAtInt(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("removeItemAtInt", $$robo$$com_android_internal_view_menu_MenuBuilder$removeItemAtInt(int boolean ), 0, this, n, bl);
    }

    public void removeItemAt(int n) {
        InvokeDynamicSupport.bootstrap("removeItemAt", $$robo$$com_android_internal_view_menu_MenuBuilder$removeItemAt(int ), 0, this, n);
    }

    public void clearAll() {
        InvokeDynamicSupport.bootstrap("clearAll", $$robo$$com_android_internal_view_menu_MenuBuilder$clearAll(), 0, this);
    }

    @Override
    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_view_menu_MenuBuilder$clear(), 0, this);
    }

    void setExclusiveItemChecked(MenuItem menuItem) {
        InvokeDynamicSupport.bootstrap("setExclusiveItemChecked", $$robo$$com_android_internal_view_menu_MenuBuilder$setExclusiveItemChecked(android.view.MenuItem ), 0, this, menuItem);
    }

    @Override
    public void setGroupCheckable(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setGroupCheckable", $$robo$$com_android_internal_view_menu_MenuBuilder$setGroupCheckable(int boolean boolean ), 0, this, n, bl, bl2);
    }

    @Override
    public void setGroupVisible(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setGroupVisible", $$robo$$com_android_internal_view_menu_MenuBuilder$setGroupVisible(int boolean ), 0, this, n, bl);
    }

    @Override
    public void setGroupEnabled(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setGroupEnabled", $$robo$$com_android_internal_view_menu_MenuBuilder$setGroupEnabled(int boolean ), 0, this, n, bl);
    }

    @Override
    public boolean hasVisibleItems() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasVisibleItems", $$robo$$com_android_internal_view_menu_MenuBuilder$hasVisibleItems(), 0, this);
    }

    @Override
    public MenuItem findItem(int n) {
        return InvokeDynamicSupport.bootstrap("findItem", $$robo$$com_android_internal_view_menu_MenuBuilder$findItem(int ), 0, this, n);
    }

    public int findItemIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findItemIndex", $$robo$$com_android_internal_view_menu_MenuBuilder$findItemIndex(int ), 0, this, n);
    }

    public int findGroupIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findGroupIndex", $$robo$$com_android_internal_view_menu_MenuBuilder$findGroupIndex(int ), 0, this, n);
    }

    public int findGroupIndex(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("findGroupIndex", $$robo$$com_android_internal_view_menu_MenuBuilder$findGroupIndex(int int ), 0, this, n, n2);
    }

    @Override
    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$com_android_internal_view_menu_MenuBuilder$size(), 0, this);
    }

    @Override
    public MenuItem getItem(int n) {
        return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_view_menu_MenuBuilder$getItem(int ), 0, this, n);
    }

    @Override
    public boolean isShortcutKey(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("isShortcutKey", $$robo$$com_android_internal_view_menu_MenuBuilder$isShortcutKey(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public void setQwertyMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setQwertyMode", $$robo$$com_android_internal_view_menu_MenuBuilder$setQwertyMode(boolean ), 0, this, bl);
    }

    private static int getOrdering(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getOrdering", $$robo$$com_android_internal_view_menu_MenuBuilder$getOrdering(int ), 0, (int)n);
    }

    boolean isQwertyMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isQwertyMode", $$robo$$com_android_internal_view_menu_MenuBuilder$isQwertyMode(), 0, this);
    }

    public void setShortcutsVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShortcutsVisible", $$robo$$com_android_internal_view_menu_MenuBuilder$setShortcutsVisible(boolean ), 0, this, bl);
    }

    private void setShortcutsVisibleInner(boolean bl) {
        InvokeDynamicSupport.bootstrap("setShortcutsVisibleInner", $$robo$$com_android_internal_view_menu_MenuBuilder$setShortcutsVisibleInner(boolean ), 0, this, bl);
    }

    public boolean isShortcutsVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShortcutsVisible", $$robo$$com_android_internal_view_menu_MenuBuilder$isShortcutsVisible(), 0, this);
    }

    Resources getResources() {
        return InvokeDynamicSupport.bootstrap("getResources", $$robo$$com_android_internal_view_menu_MenuBuilder$getResources(), 0, this);
    }

    public Context getContext() {
        return InvokeDynamicSupport.bootstrap("getContext", $$robo$$com_android_internal_view_menu_MenuBuilder$getContext(), 0, this);
    }

    boolean dispatchMenuItemSelected(MenuBuilder menuBuilder, MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchMenuItemSelected", $$robo$$com_android_internal_view_menu_MenuBuilder$dispatchMenuItemSelected(com.android.internal.view.menu.MenuBuilder android.view.MenuItem ), 0, this, menuBuilder, menuItem);
    }

    public void changeMenuMode() {
        InvokeDynamicSupport.bootstrap("changeMenuMode", $$robo$$com_android_internal_view_menu_MenuBuilder$changeMenuMode(), 0, this);
    }

    private static int findInsertIndex(ArrayList<MenuItemImpl> arrayList, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findInsertIndex", $$robo$$com_android_internal_view_menu_MenuBuilder$findInsertIndex(java.util.ArrayList<com.android.internal.view.menu.MenuItemImpl> int ), 0, arrayList, (int)n);
    }

    @Override
    public boolean performShortcut(int n, KeyEvent keyEvent, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("performShortcut", $$robo$$com_android_internal_view_menu_MenuBuilder$performShortcut(int android.view.KeyEvent int ), 0, this, n, keyEvent, n2);
    }

    void findItemsWithShortcutForKey(List<MenuItemImpl> list, int n, KeyEvent keyEvent) {
        InvokeDynamicSupport.bootstrap("findItemsWithShortcutForKey", $$robo$$com_android_internal_view_menu_MenuBuilder$findItemsWithShortcutForKey(java.util.List<com.android.internal.view.menu.MenuItemImpl> int android.view.KeyEvent ), 0, this, list, n, keyEvent);
    }

    MenuItemImpl findItemWithShortcutForKey(int n, KeyEvent keyEvent) {
        return InvokeDynamicSupport.bootstrap("findItemWithShortcutForKey", $$robo$$com_android_internal_view_menu_MenuBuilder$findItemWithShortcutForKey(int android.view.KeyEvent ), 0, this, n, keyEvent);
    }

    @Override
    public boolean performIdentifierAction(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("performIdentifierAction", $$robo$$com_android_internal_view_menu_MenuBuilder$performIdentifierAction(int int ), 0, this, n, n2);
    }

    public boolean performItemAction(MenuItem menuItem, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performItemAction", $$robo$$com_android_internal_view_menu_MenuBuilder$performItemAction(android.view.MenuItem int ), 0, this, menuItem, n);
    }

    public boolean performItemAction(MenuItem menuItem, MenuPresenter menuPresenter, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("performItemAction", $$robo$$com_android_internal_view_menu_MenuBuilder$performItemAction(android.view.MenuItem com.android.internal.view.menu.MenuPresenter int ), 0, this, menuItem, menuPresenter, n);
    }

    public void close(boolean bl) {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_view_menu_MenuBuilder$close(boolean ), 0, this, bl);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_view_menu_MenuBuilder$close(), 0, this);
    }

    public void onItemsChanged(boolean bl) {
        InvokeDynamicSupport.bootstrap("onItemsChanged", $$robo$$com_android_internal_view_menu_MenuBuilder$onItemsChanged(boolean ), 0, this, bl);
    }

    public void stopDispatchingItemsChanged() {
        InvokeDynamicSupport.bootstrap("stopDispatchingItemsChanged", $$robo$$com_android_internal_view_menu_MenuBuilder$stopDispatchingItemsChanged(), 0, this);
    }

    public void startDispatchingItemsChanged() {
        InvokeDynamicSupport.bootstrap("startDispatchingItemsChanged", $$robo$$com_android_internal_view_menu_MenuBuilder$startDispatchingItemsChanged(), 0, this);
    }

    void onItemVisibleChanged(MenuItemImpl menuItemImpl) {
        InvokeDynamicSupport.bootstrap("onItemVisibleChanged", $$robo$$com_android_internal_view_menu_MenuBuilder$onItemVisibleChanged(com.android.internal.view.menu.MenuItemImpl ), 0, this, menuItemImpl);
    }

    void onItemActionRequestChanged(MenuItemImpl menuItemImpl) {
        InvokeDynamicSupport.bootstrap("onItemActionRequestChanged", $$robo$$com_android_internal_view_menu_MenuBuilder$onItemActionRequestChanged(com.android.internal.view.menu.MenuItemImpl ), 0, this, menuItemImpl);
    }

    public ArrayList<MenuItemImpl> getVisibleItems() {
        return InvokeDynamicSupport.bootstrap("getVisibleItems", $$robo$$com_android_internal_view_menu_MenuBuilder$getVisibleItems(), 0, this);
    }

    public void flagActionItems() {
        InvokeDynamicSupport.bootstrap("flagActionItems", $$robo$$com_android_internal_view_menu_MenuBuilder$flagActionItems(), 0, this);
    }

    public ArrayList<MenuItemImpl> getActionItems() {
        return InvokeDynamicSupport.bootstrap("getActionItems", $$robo$$com_android_internal_view_menu_MenuBuilder$getActionItems(), 0, this);
    }

    public ArrayList<MenuItemImpl> getNonActionItems() {
        return InvokeDynamicSupport.bootstrap("getNonActionItems", $$robo$$com_android_internal_view_menu_MenuBuilder$getNonActionItems(), 0, this);
    }

    public void clearHeader() {
        InvokeDynamicSupport.bootstrap("clearHeader", $$robo$$com_android_internal_view_menu_MenuBuilder$clearHeader(), 0, this);
    }

    private void setHeaderInternal(int n, CharSequence charSequence, int n2, Drawable drawable2, View view) {
        InvokeDynamicSupport.bootstrap("setHeaderInternal", $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderInternal(int java.lang.CharSequence int android.graphics.drawable.Drawable android.view.View ), 0, this, n, charSequence, n2, drawable2, view);
    }

    protected MenuBuilder setHeaderTitleInt(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("setHeaderTitleInt", $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderTitleInt(java.lang.CharSequence ), 0, this, charSequence);
    }

    protected MenuBuilder setHeaderTitleInt(int n) {
        return InvokeDynamicSupport.bootstrap("setHeaderTitleInt", $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderTitleInt(int ), 0, this, n);
    }

    protected MenuBuilder setHeaderIconInt(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("setHeaderIconInt", $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderIconInt(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    protected MenuBuilder setHeaderIconInt(int n) {
        return InvokeDynamicSupport.bootstrap("setHeaderIconInt", $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderIconInt(int ), 0, this, n);
    }

    protected MenuBuilder setHeaderViewInt(View view) {
        return InvokeDynamicSupport.bootstrap("setHeaderViewInt", $$robo$$com_android_internal_view_menu_MenuBuilder$setHeaderViewInt(android.view.View ), 0, this, view);
    }

    public CharSequence getHeaderTitle() {
        return InvokeDynamicSupport.bootstrap("getHeaderTitle", $$robo$$com_android_internal_view_menu_MenuBuilder$getHeaderTitle(), 0, this);
    }

    public Drawable getHeaderIcon() {
        return InvokeDynamicSupport.bootstrap("getHeaderIcon", $$robo$$com_android_internal_view_menu_MenuBuilder$getHeaderIcon(), 0, this);
    }

    public View getHeaderView() {
        return InvokeDynamicSupport.bootstrap("getHeaderView", $$robo$$com_android_internal_view_menu_MenuBuilder$getHeaderView(), 0, this);
    }

    public MenuBuilder getRootMenu() {
        return InvokeDynamicSupport.bootstrap("getRootMenu", $$robo$$com_android_internal_view_menu_MenuBuilder$getRootMenu(), 0, this);
    }

    public void setCurrentMenuInfo(ContextMenu.ContextMenuInfo contextMenuInfo) {
        InvokeDynamicSupport.bootstrap("setCurrentMenuInfo", $$robo$$com_android_internal_view_menu_MenuBuilder$setCurrentMenuInfo(android.view.ContextMenu$ContextMenuInfo ), 0, this, contextMenuInfo);
    }

    void setOptionalIconsVisible(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOptionalIconsVisible", $$robo$$com_android_internal_view_menu_MenuBuilder$setOptionalIconsVisible(boolean ), 0, this, bl);
    }

    boolean getOptionalIconsVisible() {
        return (boolean)InvokeDynamicSupport.bootstrap("getOptionalIconsVisible", $$robo$$com_android_internal_view_menu_MenuBuilder$getOptionalIconsVisible(), 0, this);
    }

    public boolean expandItemActionView(MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("expandItemActionView", $$robo$$com_android_internal_view_menu_MenuBuilder$expandItemActionView(com.android.internal.view.menu.MenuItemImpl ), 0, this, menuItemImpl);
    }

    public boolean collapseItemActionView(MenuItemImpl menuItemImpl) {
        return (boolean)InvokeDynamicSupport.bootstrap("collapseItemActionView", $$robo$$com_android_internal_view_menu_MenuBuilder$collapseItemActionView(com.android.internal.view.menu.MenuItemImpl ), 0, this, menuItemImpl);
    }

    public MenuItemImpl getExpandedItem() {
        return InvokeDynamicSupport.bootstrap("getExpandedItem", $$robo$$com_android_internal_view_menu_MenuBuilder$getExpandedItem(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(MenuBuilder.class);
    }

    public /* synthetic */ MenuBuilder() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuBuilder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ItemInvoker
    extends InstrumentedInterface {
        public boolean invokeItem(MenuItemImpl var1);
    }

    public static interface Callback
    extends InstrumentedInterface {
        public boolean onMenuItemSelected(MenuBuilder var1, MenuItem var2);

        public void onMenuModeChange(MenuBuilder var1);
    }
}

