/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.view.menu;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.view.Display;
import android.view.Gravity;
import android.view.View;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.android.internal.view.menu.CascadingMenuPopup;
import com.android.internal.view.menu.MenuBuilder;
import com.android.internal.view.menu.MenuHelper;
import com.android.internal.view.menu.MenuPopup;
import com.android.internal.view.menu.MenuPresenter;
import com.android.internal.view.menu.StandardMenuPopup;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MenuPopupHelper
implements MenuHelper,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int TOUCH_EPICENTER_SIZE_DP = 48;
    private Context mContext;
    private MenuBuilder mMenu;
    private boolean mOverflowOnly;
    private int mPopupStyleAttr;
    private int mPopupStyleRes;
    private View mAnchorView;
    private int mDropDownGravity;
    private boolean mForceShowIcon;
    private MenuPresenter.Callback mPresenterCallback;
    private MenuPopup mPopup;
    private PopupWindow.OnDismissListener mOnDismissListener;
    private PopupWindow.OnDismissListener mInternalOnDismissListener;

    private void $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(Context context, MenuBuilder menu2) {
    }

    private void $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(Context context, MenuBuilder menu2, View anchorView) {
    }

    private void $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(Context context, MenuBuilder menu2, View anchorView, boolean overflowOnly, int popupStyleAttr) {
    }

    private void $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(Context context, MenuBuilder menu2, View anchorView, boolean overflowOnly, int popupStyleAttr, int popupStyleRes) {
        this.mDropDownGravity = 0x800003;
        this.mInternalOnDismissListener = new PopupWindow.OnDismissListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ MenuPopupHelper this$0;

            private void $$robo$$com_android_internal_view_menu_MenuPopupHelper_1$__constructor__(MenuPopupHelper this$0) {
            }

            private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper_1$onDismiss() {
                this.this$0.onDismiss();
            }

            private void __constructor__(MenuPopupHelper menuPopupHelper) {
                this.$$robo$$com_android_internal_view_menu_MenuPopupHelper_1$__constructor__(menuPopupHelper);
            }
            {
                this.this$0 = menuPopupHelper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper_1$__constructor__(com.android.internal.view.menu.MenuPopupHelper ), 0, this, menuPopupHelper);
            }

            @Override
            public void onDismiss() {
                InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$com_android_internal_view_menu_MenuPopupHelper_1$onDismiss(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mContext = context;
        this.mMenu = menu2;
        this.mAnchorView = anchorView;
        this.mOverflowOnly = overflowOnly;
        this.mPopupStyleAttr = popupStyleAttr;
        this.mPopupStyleRes = popupStyleRes;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mOnDismissListener = listener;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setAnchorView(View anchor) {
        this.mAnchorView = anchor;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setForceShowIcon(boolean forceShowIcon) {
        this.mForceShowIcon = forceShowIcon;
        if (this.mPopup != null) {
            this.mPopup.setForceShowIcon(forceShowIcon);
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setGravity(int gravity) {
        this.mDropDownGravity = gravity;
    }

    private final int $$robo$$com_android_internal_view_menu_MenuPopupHelper$getGravity() {
        return this.mDropDownGravity;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$show() {
        if (!this.tryShow()) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$show(int x, int y) {
        if (!this.tryShow(x, y)) {
            throw new IllegalStateException("MenuPopupHelper cannot be used without an anchor");
        }
    }

    private final MenuPopup $$robo$$com_android_internal_view_menu_MenuPopupHelper$getPopup() {
        if (this.mPopup == null) {
            this.mPopup = this.createPopup();
        }
        return this.mPopup;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$tryShow() {
        if (this.isShowing()) {
            return true;
        }
        if (this.mAnchorView == null) {
            return false;
        }
        this.showPopup(0, 0, false, false);
        return true;
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$tryShow(int x, int y) {
        if (this.isShowing()) {
            return true;
        }
        if (this.mAnchorView == null) {
            return false;
        }
        this.showPopup(x, y, true, true);
        return true;
    }

    private final MenuPopup $$robo$$com_android_internal_view_menu_MenuPopupHelper$createPopup() {
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        Point displaySize = new Point();
        display.getRealSize(displaySize);
        int smallestWidth = Math.min(displaySize.x, displaySize.y);
        int minSmallestWidthCascading = this.mContext.getResources().getDimensionPixelSize(17104944);
        boolean enableCascadingSubmenus = smallestWidth >= minSmallestWidthCascading;
        MenuPopup popup = enableCascadingSubmenus ? new CascadingMenuPopup(this.mContext, this.mAnchorView, this.mPopupStyleAttr, this.mPopupStyleRes, this.mOverflowOnly) : new StandardMenuPopup(this.mContext, this.mMenu, this.mAnchorView, this.mPopupStyleAttr, this.mPopupStyleRes, this.mOverflowOnly);
        popup.addMenu(this.mMenu);
        popup.setOnDismissListener(this.mInternalOnDismissListener);
        popup.setAnchorView(this.mAnchorView);
        popup.setCallback(this.mPresenterCallback);
        popup.setForceShowIcon(this.mForceShowIcon);
        popup.setGravity(this.mDropDownGravity);
        return popup;
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$showPopup(int xOffset, int yOffset, boolean useOffsets, boolean showTitle) {
        MenuPopup popup = this.getPopup();
        popup.setShowTitle(showTitle);
        if (useOffsets) {
            int hgrav = Gravity.getAbsoluteGravity(this.mDropDownGravity, this.mAnchorView.getLayoutDirection()) & 7;
            if (hgrav == 5) {
                xOffset += this.mAnchorView.getWidth();
            }
            popup.setHorizontalOffset(xOffset);
            popup.setVerticalOffset(yOffset);
            float density = this.mContext.getResources().getDisplayMetrics().density;
            int halfSize = (int)(48.0f * density / 2.0f);
            Rect epicenter = new Rect(xOffset - halfSize, yOffset - halfSize, xOffset + halfSize, yOffset + halfSize);
            popup.setEpicenterBounds(epicenter);
        }
        popup.show();
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$dismiss() {
        if (this.isShowing()) {
            this.mPopup.dismiss();
        }
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$onDismiss() {
        this.mPopup = null;
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    private final boolean $$robo$$com_android_internal_view_menu_MenuPopupHelper$isShowing() {
        return this.mPopup != null && this.mPopup.isShowing();
    }

    private final void $$robo$$com_android_internal_view_menu_MenuPopupHelper$setPresenterCallback(MenuPresenter.Callback cb) {
        this.mPresenterCallback = cb;
        if (this.mPopup != null) {
            this.mPopup.setCallback(cb);
        }
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder) {
        this.$$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(context, menuBuilder);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder) {
        this(context, menuBuilder, null, false, 0x1010300, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder ), 0, this, context, menuBuilder);
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder, View view) {
        this.$$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(context, menuBuilder, view);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder, View view) {
        this(context, menuBuilder, view, false, 0x1010300, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View ), 0, this, context, menuBuilder, view);
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder, View view, boolean bl, int n) {
        this.$$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(context, menuBuilder, view, bl, n);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder, View view, boolean bl, int n) {
        this(context, menuBuilder, view, bl, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View boolean int ), 0, this, context, menuBuilder, view, bl, n);
    }

    private void __constructor__(Context context, MenuBuilder menuBuilder, View view, boolean bl, int n, int n2) {
        this.$$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(context, menuBuilder, view, bl, n, n2);
    }

    public MenuPopupHelper(Context context, MenuBuilder menuBuilder, View view, boolean bl, int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_view_menu_MenuPopupHelper$__constructor__(android.content.Context com.android.internal.view.menu.MenuBuilder android.view.View boolean int int ), 0, this, context, menuBuilder, view, bl, n, n2);
    }

    public void setOnDismissListener(PopupWindow.OnDismissListener onDismissListener) {
        InvokeDynamicSupport.bootstrap("setOnDismissListener", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setOnDismissListener(android.widget.PopupWindow$OnDismissListener ), 0, this, onDismissListener);
    }

    public void setAnchorView(View view) {
        InvokeDynamicSupport.bootstrap("setAnchorView", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setAnchorView(android.view.View ), 0, this, view);
    }

    public void setForceShowIcon(boolean bl) {
        InvokeDynamicSupport.bootstrap("setForceShowIcon", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setForceShowIcon(boolean ), 0, this, bl);
    }

    public void setGravity(int n) {
        InvokeDynamicSupport.bootstrap("setGravity", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setGravity(int ), 0, this, n);
    }

    public int getGravity() {
        return (int)InvokeDynamicSupport.bootstrap("getGravity", $$robo$$com_android_internal_view_menu_MenuPopupHelper$getGravity(), 0, this);
    }

    public void show() {
        InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_view_menu_MenuPopupHelper$show(), 0, this);
    }

    public void show(int n, int n2) {
        InvokeDynamicSupport.bootstrap("show", $$robo$$com_android_internal_view_menu_MenuPopupHelper$show(int int ), 0, this, n, n2);
    }

    public MenuPopup getPopup() {
        return InvokeDynamicSupport.bootstrap("getPopup", $$robo$$com_android_internal_view_menu_MenuPopupHelper$getPopup(), 0, this);
    }

    public boolean tryShow() {
        return (boolean)InvokeDynamicSupport.bootstrap("tryShow", $$robo$$com_android_internal_view_menu_MenuPopupHelper$tryShow(), 0, this);
    }

    public boolean tryShow(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("tryShow", $$robo$$com_android_internal_view_menu_MenuPopupHelper$tryShow(int int ), 0, this, n, n2);
    }

    private MenuPopup createPopup() {
        return InvokeDynamicSupport.bootstrap("createPopup", $$robo$$com_android_internal_view_menu_MenuPopupHelper$createPopup(), 0, this);
    }

    private void showPopup(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("showPopup", $$robo$$com_android_internal_view_menu_MenuPopupHelper$showPopup(int int boolean boolean ), 0, this, n, n2, bl, bl2);
    }

    @Override
    public void dismiss() {
        InvokeDynamicSupport.bootstrap("dismiss", $$robo$$com_android_internal_view_menu_MenuPopupHelper$dismiss(), 0, this);
    }

    protected void onDismiss() {
        InvokeDynamicSupport.bootstrap("onDismiss", $$robo$$com_android_internal_view_menu_MenuPopupHelper$onDismiss(), 0, this);
    }

    public boolean isShowing() {
        return (boolean)InvokeDynamicSupport.bootstrap("isShowing", $$robo$$com_android_internal_view_menu_MenuPopupHelper$isShowing(), 0, this);
    }

    @Override
    public void setPresenterCallback(MenuPresenter.Callback callback) {
        InvokeDynamicSupport.bootstrap("setPresenterCallback", $$robo$$com_android_internal_view_menu_MenuPopupHelper$setPresenterCallback(com.android.internal.view.menu.MenuPresenter$Callback ), 0, this, callback);
    }

    public /* synthetic */ MenuPopupHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MenuPopupHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

