/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.view.View;
import android.view.ViewGroup;
import com.android.internal.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChildHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static boolean DEBUG = false;
    private static String TAG = "ChildrenHelper";
    Callback mCallback;
    Bucket mBucket;
    List<View> mHiddenViews;

    private void $$robo$$com_android_internal_widget_ChildHelper$__constructor__(Callback callback) {
        this.mCallback = callback;
        this.mBucket = new Bucket();
        this.mHiddenViews = new ArrayList<View>();
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$hideViewInternal(View child) {
        this.mHiddenViews.add(child);
        this.mCallback.onEnteredHiddenState(child);
    }

    private final boolean $$robo$$com_android_internal_widget_ChildHelper$unhideViewInternal(View child) {
        if (this.mHiddenViews.remove(child)) {
            this.mCallback.onLeftHiddenState(child);
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$addView(View child, boolean hidden) {
        this.addView(child, -1, hidden);
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$addView(View child, int index, boolean hidden) {
        int offset = index < 0 ? this.mCallback.getChildCount() : this.getOffset(index);
        this.mBucket.insert(offset, hidden);
        if (hidden) {
            this.hideViewInternal(child);
        }
        this.mCallback.addView(child, offset);
    }

    private final int $$robo$$com_android_internal_widget_ChildHelper$getOffset(int index) {
        int diff;
        if (index < 0) {
            return -1;
        }
        int limit = this.mCallback.getChildCount();
        for (int offset = index; offset < limit; offset += diff) {
            int removedBefore = this.mBucket.countOnesBefore(offset);
            diff = index - (offset - removedBefore);
            if (diff != 0) continue;
            while (this.mBucket.get(offset)) {
                ++offset;
            }
            return offset;
        }
        return -1;
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$removeView(View view) {
        int index = this.mCallback.indexOfChild(view);
        if (index < 0) {
            return;
        }
        if (this.mBucket.remove(index)) {
            this.unhideViewInternal(view);
        }
        this.mCallback.removeViewAt(index);
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$removeViewAt(int index) {
        int offset = this.getOffset(index);
        View view = this.mCallback.getChildAt(offset);
        if (view == null) {
            return;
        }
        if (this.mBucket.remove(offset)) {
            this.unhideViewInternal(view);
        }
        this.mCallback.removeViewAt(offset);
    }

    private final View $$robo$$com_android_internal_widget_ChildHelper$getChildAt(int index) {
        int offset = this.getOffset(index);
        return this.mCallback.getChildAt(offset);
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$removeAllViewsUnfiltered() {
        this.mBucket.reset();
        for (int i = this.mHiddenViews.size() - 1; i >= 0; --i) {
            this.mCallback.onLeftHiddenState(this.mHiddenViews.get(i));
            this.mHiddenViews.remove(i);
        }
        this.mCallback.removeAllViews();
    }

    private final View $$robo$$com_android_internal_widget_ChildHelper$findHiddenNonRemovedView(int position) {
        int count = this.mHiddenViews.size();
        for (int i = 0; i < count; ++i) {
            View view = this.mHiddenViews.get(i);
            RecyclerView.ViewHolder holder = this.mCallback.getChildViewHolder(view);
            if (holder.getLayoutPosition() != position || holder.isInvalid() || holder.isRemoved()) continue;
            return view;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$attachViewToParent(View child, int index, ViewGroup.LayoutParams layoutParams, boolean hidden) {
        int offset = index < 0 ? this.mCallback.getChildCount() : this.getOffset(index);
        this.mBucket.insert(offset, hidden);
        if (hidden) {
            this.hideViewInternal(child);
        }
        this.mCallback.attachViewToParent(child, offset, layoutParams);
    }

    private final int $$robo$$com_android_internal_widget_ChildHelper$getChildCount() {
        return this.mCallback.getChildCount() - this.mHiddenViews.size();
    }

    private final int $$robo$$com_android_internal_widget_ChildHelper$getUnfilteredChildCount() {
        return this.mCallback.getChildCount();
    }

    private final View $$robo$$com_android_internal_widget_ChildHelper$getUnfilteredChildAt(int index) {
        return this.mCallback.getChildAt(index);
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$detachViewFromParent(int index) {
        int offset = this.getOffset(index);
        this.mBucket.remove(offset);
        this.mCallback.detachViewFromParent(offset);
    }

    private final int $$robo$$com_android_internal_widget_ChildHelper$indexOfChild(View child) {
        int index = this.mCallback.indexOfChild(child);
        if (index == -1) {
            return -1;
        }
        if (this.mBucket.get(index)) {
            return -1;
        }
        return index - this.mBucket.countOnesBefore(index);
    }

    private final boolean $$robo$$com_android_internal_widget_ChildHelper$isHidden(View view) {
        return this.mHiddenViews.contains(view);
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$hide(View view) {
        int offset = this.mCallback.indexOfChild(view);
        if (offset < 0) {
            throw new IllegalArgumentException("view is not a child, cannot hide " + view);
        }
        this.mBucket.set(offset);
        this.hideViewInternal(view);
    }

    private final void $$robo$$com_android_internal_widget_ChildHelper$unhide(View view) {
        int offset = this.mCallback.indexOfChild(view);
        if (offset < 0) {
            throw new IllegalArgumentException("view is not a child, cannot hide " + view);
        }
        if (!this.mBucket.get(offset)) {
            throw new RuntimeException("trying to unhide a view that was not hidden" + view);
        }
        this.mBucket.clear(offset);
        this.unhideViewInternal(view);
    }

    private final String $$robo$$com_android_internal_widget_ChildHelper$toString() {
        return this.mBucket.toString() + ", hidden list:" + this.mHiddenViews.size();
    }

    private final boolean $$robo$$com_android_internal_widget_ChildHelper$removeViewIfHidden(View view) {
        int index = this.mCallback.indexOfChild(view);
        if (index == -1) {
            if (this.unhideViewInternal(view)) {
                // empty if block
            }
            return true;
        }
        if (this.mBucket.get(index)) {
            this.mBucket.remove(index);
            if (!this.unhideViewInternal(view)) {
                // empty if block
            }
            this.mCallback.removeViewAt(index);
            return true;
        }
        return false;
    }

    private void __constructor__(Callback callback) {
        this.$$robo$$com_android_internal_widget_ChildHelper$__constructor__(callback);
    }

    ChildHelper(Callback callback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ChildHelper$__constructor__(com.android.internal.widget.ChildHelper$Callback ), 0, this, callback);
    }

    private void hideViewInternal(View view) {
        InvokeDynamicSupport.bootstrap("hideViewInternal", $$robo$$com_android_internal_widget_ChildHelper$hideViewInternal(android.view.View ), 0, this, view);
    }

    private boolean unhideViewInternal(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("unhideViewInternal", $$robo$$com_android_internal_widget_ChildHelper$unhideViewInternal(android.view.View ), 0, this, view);
    }

    void addView(View view, boolean bl) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$com_android_internal_widget_ChildHelper$addView(android.view.View boolean ), 0, this, view, bl);
    }

    void addView(View view, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$com_android_internal_widget_ChildHelper$addView(android.view.View int boolean ), 0, this, view, n, bl);
    }

    private int getOffset(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$com_android_internal_widget_ChildHelper$getOffset(int ), 0, this, n);
    }

    void removeView(View view) {
        InvokeDynamicSupport.bootstrap("removeView", $$robo$$com_android_internal_widget_ChildHelper$removeView(android.view.View ), 0, this, view);
    }

    void removeViewAt(int n) {
        InvokeDynamicSupport.bootstrap("removeViewAt", $$robo$$com_android_internal_widget_ChildHelper$removeViewAt(int ), 0, this, n);
    }

    View getChildAt(int n) {
        return InvokeDynamicSupport.bootstrap("getChildAt", $$robo$$com_android_internal_widget_ChildHelper$getChildAt(int ), 0, this, n);
    }

    void removeAllViewsUnfiltered() {
        InvokeDynamicSupport.bootstrap("removeAllViewsUnfiltered", $$robo$$com_android_internal_widget_ChildHelper$removeAllViewsUnfiltered(), 0, this);
    }

    View findHiddenNonRemovedView(int n) {
        return InvokeDynamicSupport.bootstrap("findHiddenNonRemovedView", $$robo$$com_android_internal_widget_ChildHelper$findHiddenNonRemovedView(int ), 0, this, n);
    }

    void attachViewToParent(View view, int n, ViewGroup.LayoutParams layoutParams, boolean bl) {
        InvokeDynamicSupport.bootstrap("attachViewToParent", $$robo$$com_android_internal_widget_ChildHelper$attachViewToParent(android.view.View int android.view.ViewGroup$LayoutParams boolean ), 0, this, view, n, layoutParams, bl);
    }

    int getChildCount() {
        return (int)InvokeDynamicSupport.bootstrap("getChildCount", $$robo$$com_android_internal_widget_ChildHelper$getChildCount(), 0, this);
    }

    int getUnfilteredChildCount() {
        return (int)InvokeDynamicSupport.bootstrap("getUnfilteredChildCount", $$robo$$com_android_internal_widget_ChildHelper$getUnfilteredChildCount(), 0, this);
    }

    View getUnfilteredChildAt(int n) {
        return InvokeDynamicSupport.bootstrap("getUnfilteredChildAt", $$robo$$com_android_internal_widget_ChildHelper$getUnfilteredChildAt(int ), 0, this, n);
    }

    void detachViewFromParent(int n) {
        InvokeDynamicSupport.bootstrap("detachViewFromParent", $$robo$$com_android_internal_widget_ChildHelper$detachViewFromParent(int ), 0, this, n);
    }

    int indexOfChild(View view) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfChild", $$robo$$com_android_internal_widget_ChildHelper$indexOfChild(android.view.View ), 0, this, view);
    }

    boolean isHidden(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isHidden", $$robo$$com_android_internal_widget_ChildHelper$isHidden(android.view.View ), 0, this, view);
    }

    void hide(View view) {
        InvokeDynamicSupport.bootstrap("hide", $$robo$$com_android_internal_widget_ChildHelper$hide(android.view.View ), 0, this, view);
    }

    void unhide(View view) {
        InvokeDynamicSupport.bootstrap("unhide", $$robo$$com_android_internal_widget_ChildHelper$unhide(android.view.View ), 0, this, view);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_ChildHelper$toString(), 0, this);
    }

    boolean removeViewIfHidden(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeViewIfHidden", $$robo$$com_android_internal_widget_ChildHelper$removeViewIfHidden(android.view.View ), 0, this, view);
    }

    public /* synthetic */ ChildHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChildHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    static interface Callback
    extends InstrumentedInterface {
        public int getChildCount();

        public void addView(View var1, int var2);

        public int indexOfChild(View var1);

        public void removeViewAt(int var1);

        public View getChildAt(int var1);

        public void removeAllViews();

        public RecyclerView.ViewHolder getChildViewHolder(View var1);

        public void attachViewToParent(View var1, int var2, ViewGroup.LayoutParams var3);

        public void detachViewFromParent(int var1);

        public void onEnteredHiddenState(View var1);

        public void onLeftHiddenState(View var1);
    }

    public static class Bucket
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static int BITS_PER_WORD = 64;
        static long LAST_BIT = Long.MIN_VALUE;
        long mData;
        Bucket mNext;

        private void $$robo$$com_android_internal_widget_ChildHelper_Bucket$__constructor__() {
            this.mData = 0L;
        }

        private final void $$robo$$com_android_internal_widget_ChildHelper_Bucket$set(int index) {
            if (index >= 64) {
                this.ensureNext();
                this.mNext.set(index - 64);
            } else {
                this.mData |= 1L << index;
            }
        }

        private final void $$robo$$com_android_internal_widget_ChildHelper_Bucket$ensureNext() {
            if (this.mNext == null) {
                this.mNext = new Bucket();
            }
        }

        private final void $$robo$$com_android_internal_widget_ChildHelper_Bucket$clear(int index) {
            if (index >= 64) {
                if (this.mNext != null) {
                    this.mNext.clear(index - 64);
                }
            } else {
                this.mData &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        private final boolean $$robo$$com_android_internal_widget_ChildHelper_Bucket$get(int index) {
            if (index >= 64) {
                this.ensureNext();
                return this.mNext.get(index - 64);
            }
            return (this.mData & 1L << index) != 0L;
        }

        private final void $$robo$$com_android_internal_widget_ChildHelper_Bucket$reset() {
            this.mData = 0L;
            if (this.mNext != null) {
                this.mNext.reset();
            }
        }

        private final void $$robo$$com_android_internal_widget_ChildHelper_Bucket$insert(int index, boolean value) {
            if (index >= 64) {
                this.ensureNext();
                this.mNext.insert(index - 64, value);
            } else {
                boolean lastBit = (this.mData & Long.MIN_VALUE) != 0L;
                long mask = (1L << index) - 1L;
                long before = this.mData & mask;
                long after = (this.mData & (mask ^ 0xFFFFFFFFFFFFFFFFL)) << 1;
                this.mData = before | after;
                if (value) {
                    this.set(index);
                } else {
                    this.clear(index);
                }
                if (lastBit || this.mNext != null) {
                    this.ensureNext();
                    this.mNext.insert(0, lastBit);
                }
            }
        }

        private final boolean $$robo$$com_android_internal_widget_ChildHelper_Bucket$remove(int index) {
            if (index >= 64) {
                this.ensureNext();
                return this.mNext.remove(index - 64);
            }
            long mask = 1L << index;
            boolean value = (this.mData & mask) != 0L;
            this.mData &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            long before = this.mData & --mask;
            long after = Long.rotateRight(this.mData & (mask ^ 0xFFFFFFFFFFFFFFFFL), 1);
            this.mData = before | after;
            if (this.mNext != null) {
                if (this.mNext.get(0)) {
                    this.set(63);
                }
                this.mNext.remove(0);
            }
            return value;
        }

        private final int $$robo$$com_android_internal_widget_ChildHelper_Bucket$countOnesBefore(int index) {
            if (this.mNext == null) {
                if (index >= 64) {
                    return Long.bitCount(this.mData);
                }
                return Long.bitCount(this.mData & (1L << index) - 1L);
            }
            if (index < 64) {
                return Long.bitCount(this.mData & (1L << index) - 1L);
            }
            return this.mNext.countOnesBefore(index - 64) + Long.bitCount(this.mData);
        }

        private final String $$robo$$com_android_internal_widget_ChildHelper_Bucket$toString() {
            return this.mNext == null ? Long.toBinaryString(this.mData) : this.mNext.toString() + "xx" + Long.toBinaryString(this.mData);
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_ChildHelper_Bucket$__constructor__();
        }

        Bucket() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_ChildHelper_Bucket$__constructor__(), 0, this);
        }

        void set(int n) {
            InvokeDynamicSupport.bootstrap("set", $$robo$$com_android_internal_widget_ChildHelper_Bucket$set(int ), 0, this, n);
        }

        private void ensureNext() {
            InvokeDynamicSupport.bootstrap("ensureNext", $$robo$$com_android_internal_widget_ChildHelper_Bucket$ensureNext(), 0, this);
        }

        void clear(int n) {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_widget_ChildHelper_Bucket$clear(int ), 0, this, n);
        }

        boolean get(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_widget_ChildHelper_Bucket$get(int ), 0, this, n);
        }

        void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_widget_ChildHelper_Bucket$reset(), 0, this);
        }

        void insert(int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("insert", $$robo$$com_android_internal_widget_ChildHelper_Bucket$insert(int boolean ), 0, this, n, bl);
        }

        boolean remove(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("remove", $$robo$$com_android_internal_widget_ChildHelper_Bucket$remove(int ), 0, this, n);
        }

        int countOnesBefore(int n) {
            return (int)InvokeDynamicSupport.bootstrap("countOnesBefore", $$robo$$com_android_internal_widget_ChildHelper_Bucket$countOnesBefore(int ), 0, this, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_widget_ChildHelper_Bucket$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bucket)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

