/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.Trace;
import android.view.View;
import com.android.internal.widget.RecyclerView;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider either:\n1. Using the real class.\n2. If it's a pure data class, adding a Robolectric Builder for it.\n3. If it cannot function on the JVM, adding or enhancing a Robolectric Shadow for it")
public class GapWorker
implements Runnable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static ThreadLocal<GapWorker> sGapWorker;
    ArrayList<RecyclerView> mRecyclerViews;
    long mPostTimeNs;
    long mFrameIntervalNs;
    private ArrayList<Task> mTasks;
    static Comparator<Task> sTaskComparator;

    private void $$robo$$com_android_internal_widget_GapWorker$__constructor__() {
        this.mRecyclerViews = new ArrayList();
        this.mTasks = new ArrayList();
    }

    private final void $$robo$$com_android_internal_widget_GapWorker$add(RecyclerView recyclerView) {
        this.mRecyclerViews.add(recyclerView);
    }

    private final void $$robo$$com_android_internal_widget_GapWorker$remove(RecyclerView recyclerView) {
        boolean removeSuccess = this.mRecyclerViews.remove(recyclerView);
    }

    private final void $$robo$$com_android_internal_widget_GapWorker$postFromTraversal(RecyclerView recyclerView, int prefetchDx, int prefetchDy) {
        if (recyclerView.isAttachedToWindow() && this.mPostTimeNs == 0L) {
            this.mPostTimeNs = recyclerView.getNanoTime();
            recyclerView.post(this);
        }
        recyclerView.mPrefetchRegistry.setPrefetchVector(prefetchDx, prefetchDy);
    }

    private final void $$robo$$com_android_internal_widget_GapWorker$buildTaskList() {
        int viewCount = this.mRecyclerViews.size();
        int totalTaskCount = 0;
        for (int i = 0; i < viewCount; ++i) {
            RecyclerView view = this.mRecyclerViews.get(i);
            view.mPrefetchRegistry.collectPrefetchPositionsFromView(view, false);
            totalTaskCount += view.mPrefetchRegistry.mCount;
        }
        this.mTasks.ensureCapacity(totalTaskCount);
        int totalTaskIndex = 0;
        for (int i = 0; i < viewCount; ++i) {
            RecyclerView view = this.mRecyclerViews.get(i);
            LayoutPrefetchRegistryImpl prefetchRegistry = view.mPrefetchRegistry;
            int viewVelocity = Math.abs(prefetchRegistry.mPrefetchDx) + Math.abs(prefetchRegistry.mPrefetchDy);
            for (int j = 0; j < prefetchRegistry.mCount * 2; j += 2) {
                Task task;
                if (totalTaskIndex >= this.mTasks.size()) {
                    task = new Task();
                    this.mTasks.add(task);
                } else {
                    task = this.mTasks.get(totalTaskIndex);
                }
                int distanceToItem = prefetchRegistry.mPrefetchArray[j + 1];
                task.immediate = distanceToItem <= viewVelocity;
                task.viewVelocity = viewVelocity;
                task.distanceToItem = distanceToItem;
                task.view = view;
                task.position = prefetchRegistry.mPrefetchArray[j];
                ++totalTaskIndex;
            }
        }
        Collections.sort(this.mTasks, sTaskComparator);
    }

    private static final boolean $$robo$$com_android_internal_widget_GapWorker$isPrefetchPositionAttached(RecyclerView view, int position) {
        int childCount = view.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            View attachedView = view.mChildHelper.getUnfilteredChildAt(i);
            RecyclerView.ViewHolder holder = RecyclerView.getChildViewHolderInt(attachedView);
            if (holder.mPosition != position || holder.isInvalid()) continue;
            return true;
        }
        return false;
    }

    private final RecyclerView.ViewHolder $$robo$$com_android_internal_widget_GapWorker$prefetchPositionWithDeadline(RecyclerView view, int position, long deadlineNs) {
        if (GapWorker.isPrefetchPositionAttached(view, position)) {
            return null;
        }
        RecyclerView.Recycler recycler = view.mRecycler;
        RecyclerView.ViewHolder holder = recycler.tryGetViewHolderForPositionByDeadline(position, false, deadlineNs);
        if (holder != null) {
            if (holder.isBound()) {
                recycler.recycleView(holder.itemView);
            } else {
                recycler.addViewHolderToRecycledViewPool(holder, false);
            }
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_widget_GapWorker$prefetchInnerRecyclerViewWithDeadline(RecyclerView innerView, long deadlineNs) {
        if (innerView == null) {
            return;
        }
        if (innerView.mDataSetHasChangedAfterLayout && innerView.mChildHelper.getUnfilteredChildCount() != 0) {
            innerView.removeAndRecycleViews();
        }
        LayoutPrefetchRegistryImpl innerPrefetchRegistry = innerView.mPrefetchRegistry;
        innerPrefetchRegistry.collectPrefetchPositionsFromView(innerView, true);
        if (innerPrefetchRegistry.mCount != 0) {
            try {
                Trace.beginSection("RV Nested Prefetch");
                innerView.mState.prepareForNestedPrefetch(innerView.mAdapter);
                for (int i = 0; i < innerPrefetchRegistry.mCount * 2; i += 2) {
                    int innerPosition = innerPrefetchRegistry.mPrefetchArray[i];
                    this.prefetchPositionWithDeadline(innerView, innerPosition, deadlineNs);
                }
            }
            finally {
                Trace.endSection();
            }
        }
    }

    private final void $$robo$$com_android_internal_widget_GapWorker$flushTaskWithDeadline(Task task, long deadlineNs) {
        long taskDeadlineNs = task.immediate ? Long.MAX_VALUE : deadlineNs;
        RecyclerView.ViewHolder holder = this.prefetchPositionWithDeadline(task.view, task.position, taskDeadlineNs);
        if (holder != null && holder.mNestedRecyclerView != null) {
            this.prefetchInnerRecyclerViewWithDeadline((RecyclerView)holder.mNestedRecyclerView.get(), deadlineNs);
        }
    }

    private final void $$robo$$com_android_internal_widget_GapWorker$flushTasksWithDeadline(long deadlineNs) {
        for (int i = 0; i < this.mTasks.size(); ++i) {
            Task task = this.mTasks.get(i);
            if (task.view == null) break;
            this.flushTaskWithDeadline(task, deadlineNs);
            task.clear();
        }
    }

    private final void $$robo$$com_android_internal_widget_GapWorker$prefetch(long deadlineNs) {
        this.buildTaskList();
        this.flushTasksWithDeadline(deadlineNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_widget_GapWorker$run() {
        try {
            Trace.beginSection("RV Prefetch");
            if (this.mRecyclerViews.isEmpty()) {
                return;
            }
            long lastFrameVsyncNs = TimeUnit.MILLISECONDS.toNanos(this.mRecyclerViews.get(0).getDrawingTime());
            if (lastFrameVsyncNs == 0L) {
                return;
            }
            long nextFrameNs = lastFrameVsyncNs + this.mFrameIntervalNs;
            this.prefetch(nextFrameNs);
        }
        finally {
            this.mPostTimeNs = 0L;
            Trace.endSection();
        }
    }

    static void __staticInitializer__() {
        sGapWorker = new ThreadLocal();
        sTaskComparator = new Comparator<Task>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$com_android_internal_widget_GapWorker_1$__constructor__() {
            }

            private final int $$robo$$com_android_internal_widget_GapWorker_1$compare(Task lhs, Task rhs) {
                if (lhs.view == null != (rhs.view == null)) {
                    return lhs.view == null ? 1 : -1;
                }
                if (lhs.immediate != rhs.immediate) {
                    return lhs.immediate ? -1 : 1;
                }
                int deltaViewVelocity = rhs.viewVelocity - lhs.viewVelocity;
                if (deltaViewVelocity != 0) {
                    return deltaViewVelocity;
                }
                int deltaDistanceToItem = lhs.distanceToItem - rhs.distanceToItem;
                if (deltaDistanceToItem != 0) {
                    return deltaDistanceToItem;
                }
                return 0;
            }

            private void __constructor__() {
                this.$$robo$$com_android_internal_widget_GapWorker_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_GapWorker_1$__constructor__(), 0, this);
            }

            @Override
            public int compare(Task task, Task task2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_widget_GapWorker_1$compare(com.android.internal.widget.GapWorker$Task com.android.internal.widget.GapWorker$Task ), 0, this, task, task2);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_widget_GapWorker$__constructor__();
    }

    GapWorker() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_GapWorker$__constructor__(), 0, this);
    }

    public void add(RecyclerView recyclerView) {
        InvokeDynamicSupport.bootstrap("add", $$robo$$com_android_internal_widget_GapWorker$add(com.android.internal.widget.RecyclerView ), 0, this, recyclerView);
    }

    public void remove(RecyclerView recyclerView) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$com_android_internal_widget_GapWorker$remove(com.android.internal.widget.RecyclerView ), 0, this, recyclerView);
    }

    void postFromTraversal(RecyclerView recyclerView, int n, int n2) {
        InvokeDynamicSupport.bootstrap("postFromTraversal", $$robo$$com_android_internal_widget_GapWorker$postFromTraversal(com.android.internal.widget.RecyclerView int int ), 0, this, recyclerView, n, n2);
    }

    private void buildTaskList() {
        InvokeDynamicSupport.bootstrap("buildTaskList", $$robo$$com_android_internal_widget_GapWorker$buildTaskList(), 0, this);
    }

    static boolean isPrefetchPositionAttached(RecyclerView recyclerView, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPrefetchPositionAttached", $$robo$$com_android_internal_widget_GapWorker$isPrefetchPositionAttached(com.android.internal.widget.RecyclerView int ), 0, (RecyclerView)recyclerView, (int)n);
    }

    private RecyclerView.ViewHolder prefetchPositionWithDeadline(RecyclerView recyclerView, int n, long l) {
        return InvokeDynamicSupport.bootstrap("prefetchPositionWithDeadline", $$robo$$com_android_internal_widget_GapWorker$prefetchPositionWithDeadline(com.android.internal.widget.RecyclerView int long ), 0, this, recyclerView, n, l);
    }

    private void prefetchInnerRecyclerViewWithDeadline(RecyclerView recyclerView, long l) {
        InvokeDynamicSupport.bootstrap("prefetchInnerRecyclerViewWithDeadline", $$robo$$com_android_internal_widget_GapWorker$prefetchInnerRecyclerViewWithDeadline(com.android.internal.widget.RecyclerView long ), 0, this, recyclerView, l);
    }

    private void flushTaskWithDeadline(Task task, long l) {
        InvokeDynamicSupport.bootstrap("flushTaskWithDeadline", $$robo$$com_android_internal_widget_GapWorker$flushTaskWithDeadline(com.android.internal.widget.GapWorker$Task long ), 0, this, task, l);
    }

    private void flushTasksWithDeadline(long l) {
        InvokeDynamicSupport.bootstrap("flushTasksWithDeadline", $$robo$$com_android_internal_widget_GapWorker$flushTasksWithDeadline(long ), 0, this, l);
    }

    void prefetch(long l) {
        InvokeDynamicSupport.bootstrap("prefetch", $$robo$$com_android_internal_widget_GapWorker$prefetch(long ), 0, this, l);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_GapWorker$run(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(GapWorker.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (GapWorker)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class LayoutPrefetchRegistryImpl
    implements RecyclerView.LayoutManager.LayoutPrefetchRegistry,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int mPrefetchDx;
        int mPrefetchDy;
        int[] mPrefetchArray;
        int mCount;

        private void $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$__constructor__() {
        }

        private final void $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$setPrefetchVector(int dx, int dy) {
            this.mPrefetchDx = dx;
            this.mPrefetchDy = dy;
        }

        private final void $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$collectPrefetchPositionsFromView(RecyclerView view, boolean nested) {
            this.mCount = 0;
            if (this.mPrefetchArray != null) {
                Arrays.fill(this.mPrefetchArray, -1);
            }
            RecyclerView.LayoutManager layout2 = view.mLayout;
            if (view.mAdapter != null && layout2 != null && layout2.isItemPrefetchEnabled()) {
                if (nested) {
                    if (!view.mAdapterHelper.hasPendingUpdates()) {
                        layout2.collectInitialPrefetchPositions(view.mAdapter.getItemCount(), this);
                    }
                } else if (!view.hasPendingAdapterUpdates()) {
                    layout2.collectAdjacentPrefetchPositions(this.mPrefetchDx, this.mPrefetchDy, view.mState, this);
                }
                if (this.mCount > layout2.mPrefetchMaxCountObserved) {
                    layout2.mPrefetchMaxCountObserved = this.mCount;
                    layout2.mPrefetchMaxObservedInInitialPrefetch = nested;
                    view.mRecycler.updateViewCacheSize();
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$addPosition(int layoutPosition, int pixelDistance) {
            if (pixelDistance < 0) {
                throw new IllegalArgumentException("Pixel distance must be non-negative");
            }
            int storagePosition = this.mCount * 2;
            if (this.mPrefetchArray == null) {
                this.mPrefetchArray = new int[4];
                Arrays.fill(this.mPrefetchArray, -1);
            } else if (storagePosition >= this.mPrefetchArray.length) {
                int[] oldArray = this.mPrefetchArray;
                this.mPrefetchArray = new int[storagePosition * 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])oldArray, (int)0, (int[])this.mPrefetchArray, (int)0, (int)oldArray.length);
            }
            this.mPrefetchArray[storagePosition] = layoutPosition;
            this.mPrefetchArray[storagePosition + 1] = pixelDistance;
            ++this.mCount;
        }

        private final boolean $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$lastPrefetchIncludedPosition(int position) {
            if (this.mPrefetchArray != null) {
                int count = this.mCount * 2;
                for (int i = 0; i < count; i += 2) {
                    if (this.mPrefetchArray[i] != position) continue;
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$clearPrefetchPositions() {
            if (this.mPrefetchArray != null) {
                Arrays.fill(this.mPrefetchArray, -1);
            }
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$__constructor__();
        }

        LayoutPrefetchRegistryImpl() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$__constructor__(), 0, this);
        }

        void setPrefetchVector(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setPrefetchVector", $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$setPrefetchVector(int int ), 0, this, n, n2);
        }

        void collectPrefetchPositionsFromView(RecyclerView recyclerView, boolean bl) {
            InvokeDynamicSupport.bootstrap("collectPrefetchPositionsFromView", $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$collectPrefetchPositionsFromView(com.android.internal.widget.RecyclerView boolean ), 0, this, recyclerView, bl);
        }

        @Override
        public void addPosition(int n, int n2) {
            InvokeDynamicSupport.bootstrap("addPosition", $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$addPosition(int int ), 0, this, n, n2);
        }

        boolean lastPrefetchIncludedPosition(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("lastPrefetchIncludedPosition", $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$lastPrefetchIncludedPosition(int ), 0, this, n);
        }

        void clearPrefetchPositions() {
            InvokeDynamicSupport.bootstrap("clearPrefetchPositions", $$robo$$com_android_internal_widget_GapWorker_LayoutPrefetchRegistryImpl$clearPrefetchPositions(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LayoutPrefetchRegistryImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Task
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean immediate;
        public int viewVelocity;
        public int distanceToItem;
        public RecyclerView view;
        public int position;

        private void $$robo$$com_android_internal_widget_GapWorker_Task$__constructor__() {
        }

        private final void $$robo$$com_android_internal_widget_GapWorker_Task$clear() {
            this.immediate = false;
            this.viewVelocity = 0;
            this.distanceToItem = 0;
            this.view = null;
            this.position = 0;
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_GapWorker_Task$__constructor__();
        }

        Task() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_GapWorker_Task$__constructor__(), 0, this);
        }

        public void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$com_android_internal_widget_GapWorker_Task$clear(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Task)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

