/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget.helper;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import android.view.animation.Interpolator;
import com.android.internal.widget.RecyclerView;
import com.android.internal.widget.helper.ItemTouchUIUtil;
import com.android.internal.widget.helper.ItemTouchUIUtilImpl;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ItemTouchHelper
extends RecyclerView.ItemDecoration
implements RecyclerView.OnChildAttachStateChangeListener,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int UP = 1;
    public static int DOWN = 2;
    public static int LEFT = 4;
    public static int RIGHT = 8;
    public static int START = 16;
    public static int END = 32;
    public static int ACTION_STATE_IDLE = 0;
    public static int ACTION_STATE_SWIPE = 1;
    public static int ACTION_STATE_DRAG = 2;
    public static int ANIMATION_TYPE_SWIPE_SUCCESS = 2;
    public static int ANIMATION_TYPE_SWIPE_CANCEL = 4;
    public static int ANIMATION_TYPE_DRAG = 8;
    static String TAG = "ItemTouchHelper";
    static boolean DEBUG = false;
    static int ACTIVE_POINTER_ID_NONE = -1;
    static int DIRECTION_FLAG_COUNT = 8;
    private static int ACTION_MODE_IDLE_MASK = 255;
    static int ACTION_MODE_SWIPE_MASK = 65280;
    static int ACTION_MODE_DRAG_MASK = 0xFF0000;
    private static int PIXELS_PER_SECOND = 1000;
    List<View> mPendingCleanup;
    private float[] mTmpPosition;
    RecyclerView.ViewHolder mSelected;
    float mInitialTouchX;
    float mInitialTouchY;
    float mSwipeEscapeVelocity;
    float mMaxSwipeVelocity;
    float mDx;
    float mDy;
    float mSelectedStartX;
    float mSelectedStartY;
    int mActivePointerId;
    Callback mCallback;
    int mActionState;
    int mSelectedFlags;
    List<RecoverAnimation> mRecoverAnimations;
    private int mSlop;
    RecyclerView mRecyclerView;
    Runnable mScrollRunnable;
    VelocityTracker mVelocityTracker;
    private List<RecyclerView.ViewHolder> mSwapTargets;
    private List<Integer> mDistances;
    private RecyclerView.ChildDrawingOrderCallback mChildDrawingOrderCallback;
    View mOverdrawChild;
    int mOverdrawChildPosition;
    GestureDetector mGestureDetector;
    private RecyclerView.OnItemTouchListener mOnItemTouchListener;
    private Rect mTmpRect;
    private long mDragScrollStartTimeInMs;

    private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$__constructor__(Callback callback) {
        this.mPendingCleanup = new ArrayList<View>();
        this.mTmpPosition = new float[2];
        this.mSelected = null;
        this.mActivePointerId = -1;
        this.mActionState = 0;
        this.mRecoverAnimations = new ArrayList<RecoverAnimation>();
        this.mScrollRunnable = new Runnable(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ItemTouchHelper this$0;

            private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_1$__constructor__(ItemTouchHelper this$0) {
            }

            private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_1$run() {
                if (this.this$0.mSelected != null && this.this$0.scrollIfNecessary()) {
                    if (this.this$0.mSelected != null) {
                        this.this$0.moveIfNecessary(this.this$0.mSelected);
                    }
                    this.this$0.mRecyclerView.removeCallbacks(this.this$0.mScrollRunnable);
                    this.this$0.mRecyclerView.postOnAnimation(this);
                }
            }

            private void __constructor__(ItemTouchHelper itemTouchHelper) {
                this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_1$__constructor__(itemTouchHelper);
            }
            {
                this.this$0 = itemTouchHelper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_1$__constructor__(com.android.internal.widget.helper.ItemTouchHelper ), 0, this, itemTouchHelper);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_1$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mChildDrawingOrderCallback = null;
        this.mOverdrawChild = null;
        this.mOverdrawChildPosition = -1;
        this.mOnItemTouchListener = new RecyclerView.OnItemTouchListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ItemTouchHelper this$0;

            private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$__constructor__(ItemTouchHelper this$0) {
            }

            private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent event) {
                int index;
                this.this$0.mGestureDetector.onTouchEvent(event);
                int action = event.getActionMasked();
                if (action == 0) {
                    RecoverAnimation animation;
                    this.this$0.mActivePointerId = event.getPointerId(0);
                    this.this$0.mInitialTouchX = event.getX();
                    this.this$0.mInitialTouchY = event.getY();
                    this.this$0.obtainVelocityTracker();
                    if (this.this$0.mSelected == null && (animation = this.this$0.findAnimation(event)) != null) {
                        this.this$0.mInitialTouchX -= animation.mX;
                        this.this$0.mInitialTouchY -= animation.mY;
                        this.this$0.endRecoverAnimation(animation.mViewHolder, true);
                        if (this.this$0.mPendingCleanup.remove(animation.mViewHolder.itemView)) {
                            this.this$0.mCallback.clearView(this.this$0.mRecyclerView, animation.mViewHolder);
                        }
                        this.this$0.select(animation.mViewHolder, animation.mActionState);
                        this.this$0.updateDxDy(event, this.this$0.mSelectedFlags, 0);
                    }
                } else if (action == 3 || action == 1) {
                    this.this$0.mActivePointerId = -1;
                    this.this$0.select(null, 0);
                } else if (this.this$0.mActivePointerId != -1 && (index = event.findPointerIndex(this.this$0.mActivePointerId)) >= 0) {
                    this.this$0.checkSelectForSwipe(action, event, index);
                }
                if (this.this$0.mVelocityTracker != null) {
                    this.this$0.mVelocityTracker.addMovement(event);
                }
                return this.this$0.mSelected != null;
            }

            private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$onTouchEvent(RecyclerView recyclerView, MotionEvent event) {
                RecyclerView.ViewHolder viewHolder;
                this.this$0.mGestureDetector.onTouchEvent(event);
                if (this.this$0.mVelocityTracker != null) {
                    this.this$0.mVelocityTracker.addMovement(event);
                }
                if (this.this$0.mActivePointerId == -1) {
                    return;
                }
                int action = event.getActionMasked();
                int activePointerIndex = event.findPointerIndex(this.this$0.mActivePointerId);
                if (activePointerIndex >= 0) {
                    this.this$0.checkSelectForSwipe(action, event, activePointerIndex);
                }
                if ((viewHolder = this.this$0.mSelected) == null) {
                    return;
                }
                switch (action) {
                    case 2: {
                        if (activePointerIndex < 0) break;
                        this.this$0.updateDxDy(event, this.this$0.mSelectedFlags, activePointerIndex);
                        this.this$0.moveIfNecessary(viewHolder);
                        this.this$0.mRecyclerView.removeCallbacks(this.this$0.mScrollRunnable);
                        this.this$0.mScrollRunnable.run();
                        this.this$0.mRecyclerView.invalidate();
                        break;
                    }
                    case 3: {
                        if (this.this$0.mVelocityTracker != null) {
                            this.this$0.mVelocityTracker.clear();
                        }
                    }
                    case 1: {
                        this.this$0.select(null, 0);
                        this.this$0.mActivePointerId = -1;
                        break;
                    }
                    case 6: {
                        int pointerIndex = event.getActionIndex();
                        int pointerId = event.getPointerId(pointerIndex);
                        if (pointerId != this.this$0.mActivePointerId) break;
                        int newPointerIndex = pointerIndex == 0 ? 1 : 0;
                        this.this$0.mActivePointerId = event.getPointerId(newPointerIndex);
                        this.this$0.updateDxDy(event, this.this$0.mSelectedFlags, pointerIndex);
                        break;
                    }
                }
            }

            private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$onRequestDisallowInterceptTouchEvent(boolean disallowIntercept) {
                if (!disallowIntercept) {
                    return;
                }
                this.this$0.select(null, 0);
            }

            private void __constructor__(ItemTouchHelper itemTouchHelper) {
                this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$__constructor__(itemTouchHelper);
            }
            {
                this.this$0 = itemTouchHelper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$__constructor__(com.android.internal.widget.helper.ItemTouchHelper ), 0, this, itemTouchHelper);
            }

            @Override
            public boolean onInterceptTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
                return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$onInterceptTouchEvent(com.android.internal.widget.RecyclerView android.view.MotionEvent ), 0, this, recyclerView, motionEvent);
            }

            @Override
            public void onTouchEvent(RecyclerView recyclerView, MotionEvent motionEvent) {
                InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$onTouchEvent(com.android.internal.widget.RecyclerView android.view.MotionEvent ), 0, this, recyclerView, motionEvent);
            }

            @Override
            public void onRequestDisallowInterceptTouchEvent(boolean bl) {
                InvokeDynamicSupport.bootstrap("onRequestDisallowInterceptTouchEvent", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_2$onRequestDisallowInterceptTouchEvent(boolean ), 0, this, bl);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mCallback = callback;
    }

    private static final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper$hitTest(View child, float x, float y, float left, float top) {
        return x >= left && x <= left + (float)child.getWidth() && y >= top && y <= top + (float)child.getHeight();
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$attachToRecyclerView(RecyclerView recyclerView) {
        if (this.mRecyclerView == recyclerView) {
            return;
        }
        if (this.mRecyclerView != null) {
            this.destroyCallbacks();
        }
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView != null) {
            Resources resources = recyclerView.getResources();
            this.mSwipeEscapeVelocity = resources.getDimension(17105062);
            this.mMaxSwipeVelocity = resources.getDimension(17105061);
            this.setupCallbacks();
        }
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$setupCallbacks() {
        ViewConfiguration vc = ViewConfiguration.get(this.mRecyclerView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mRecyclerView.addItemDecoration(this);
        this.mRecyclerView.addOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.addOnChildAttachStateChangeListener(this);
        this.initGestureDetector();
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$destroyCallbacks() {
        this.mRecyclerView.removeItemDecoration(this);
        this.mRecyclerView.removeOnItemTouchListener(this.mOnItemTouchListener);
        this.mRecyclerView.removeOnChildAttachStateChangeListener(this);
        int recoverAnimSize = this.mRecoverAnimations.size();
        for (int i = recoverAnimSize - 1; i >= 0; --i) {
            RecoverAnimation recoverAnimation = this.mRecoverAnimations.get(0);
            this.mCallback.clearView(this.mRecyclerView, recoverAnimation.mViewHolder);
        }
        this.mRecoverAnimations.clear();
        this.mOverdrawChild = null;
        this.mOverdrawChildPosition = -1;
        this.releaseVelocityTracker();
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$initGestureDetector() {
        if (this.mGestureDetector != null) {
            return;
        }
        this.mGestureDetector = new GestureDetector(this.mRecyclerView.getContext(), new ItemTouchHelperGestureListener(this));
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$getSelectedDxDy(float[] outPosition) {
        outPosition[0] = (this.mSelectedFlags & 0xC) != 0 ? this.mSelectedStartX + this.mDx - (float)this.mSelected.itemView.getLeft() : this.mSelected.itemView.getTranslationX();
        outPosition[1] = (this.mSelectedFlags & 3) != 0 ? this.mSelectedStartY + this.mDy - (float)this.mSelected.itemView.getTop() : this.mSelected.itemView.getTranslationY();
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.mSelected != null) {
            this.getSelectedDxDy(this.mTmpPosition);
            dx = this.mTmpPosition[0];
            dy = this.mTmpPosition[1];
        }
        this.mCallback.onDrawOver(c, parent, this.mSelected, this.mRecoverAnimations, this.mActionState, dx, dy);
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        this.mOverdrawChildPosition = -1;
        float dx = 0.0f;
        float dy = 0.0f;
        if (this.mSelected != null) {
            this.getSelectedDxDy(this.mTmpPosition);
            dx = this.mTmpPosition[0];
            dy = this.mTmpPosition[1];
        }
        this.mCallback.onDraw(c, parent, this.mSelected, this.mRecoverAnimations, this.mActionState, dx, dy);
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$select(RecyclerView.ViewHolder selected, int actionState) {
        ViewParent rvParent;
        if (selected == this.mSelected && actionState == this.mActionState) {
            return;
        }
        this.mDragScrollStartTimeInMs = Long.MIN_VALUE;
        int prevActionState = this.mActionState;
        this.endRecoverAnimation(selected, true);
        this.mActionState = actionState;
        if (actionState == 2) {
            this.mOverdrawChild = selected.itemView;
            this.addChildDrawingOrderCallback();
        }
        int actionStateMask = (1 << 8 + 8 * actionState) - 1;
        boolean preventLayout = false;
        if (this.mSelected != null) {
            RecyclerView.ViewHolder prevSelected = this.mSelected;
            if (prevSelected.itemView.getParent() != null) {
                float targetTranslateX;
                float targetTranslateY;
                int swipeDir = prevActionState == 2 ? 0 : this.swipeIfNecessary(prevSelected);
                this.releaseVelocityTracker();
                switch (swipeDir) {
                    case 4: 
                    case 8: 
                    case 16: 
                    case 32: {
                        targetTranslateY = 0.0f;
                        targetTranslateX = Math.signum(this.mDx) * (float)this.mRecyclerView.getWidth();
                        break;
                    }
                    case 1: 
                    case 2: {
                        targetTranslateX = 0.0f;
                        targetTranslateY = Math.signum(this.mDy) * (float)this.mRecyclerView.getHeight();
                        break;
                    }
                    default: {
                        targetTranslateX = 0.0f;
                        targetTranslateY = 0.0f;
                    }
                }
                int animationType = prevActionState == 2 ? 8 : (swipeDir > 0 ? 2 : 4);
                this.getSelectedDxDy(this.mTmpPosition);
                float currentTranslateX = this.mTmpPosition[0];
                float currentTranslateY = this.mTmpPosition[1];
                ShadowedObject rv = new ShadowedObject(this, prevSelected, animationType, prevActionState, currentTranslateX, currentTranslateY, targetTranslateX, targetTranslateY, swipeDir, prevSelected){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ int val$swipeDir;
                    /* synthetic */ RecyclerView.ViewHolder val$prevSelected;
                    /* synthetic */ ItemTouchHelper this$0;

                    private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_3$__constructor__(ItemTouchHelper this$0, RecyclerView.ViewHolder viewHolder, int animationType, int actionState, float startDx, float startDy, float targetX, float targetY, int n, RecyclerView.ViewHolder viewHolder2) {
                    }

                    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_3$onAnimationEnd(Animator animation) {
                        super.onAnimationEnd(animation);
                        if (this.mOverridden) {
                            return;
                        }
                        if (this.val$swipeDir <= 0) {
                            this.this$0.mCallback.clearView(this.this$0.mRecyclerView, this.val$prevSelected);
                        } else {
                            this.this$0.mPendingCleanup.add(this.val$prevSelected.itemView);
                            this.mIsPendingCleanup = true;
                            if (this.val$swipeDir > 0) {
                                this.this$0.postDispatchSwipe(this, this.val$swipeDir);
                            }
                        }
                        if (this.this$0.mOverdrawChild == this.val$prevSelected.itemView) {
                            this.this$0.removeChildDrawingOrderCallbackIfNecessary(this.val$prevSelected.itemView);
                        }
                    }

                    private void __constructor__(ItemTouchHelper itemTouchHelper, RecyclerView.ViewHolder viewHolder, int n, int n2, float f, float f2, float f3, float f4, int n3, RecyclerView.ViewHolder viewHolder2) {
                        this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_3$__constructor__(itemTouchHelper, viewHolder, n, n2, f, f2, f3, f4, n3, viewHolder2);
                    }
                    {
                        this.this$0 = itemTouchHelper;
                        this.val$swipeDir = n3;
                        this.val$prevSelected = viewHolder2;
                        super(itemTouchHelper, viewHolder, n, n2, f, f2, f3, f4);
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_3$__constructor__(com.android.internal.widget.helper.ItemTouchHelper com.android.internal.widget.RecyclerView$ViewHolder int int float float float float int com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, itemTouchHelper, viewHolder, n, n2, f, f2, f3, f4, n3, viewHolder2);
                    }

                    @Override
                    public void onAnimationEnd(Animator animator2) {
                        InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_3$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
                long duration = this.mCallback.getAnimationDuration(this.mRecyclerView, animationType, targetTranslateX - currentTranslateX, targetTranslateY - currentTranslateY);
                rv.setDuration(duration);
                this.mRecoverAnimations.add((RecoverAnimation)rv);
                rv.start();
                preventLayout = true;
            } else {
                this.removeChildDrawingOrderCallbackIfNecessary(prevSelected.itemView);
                this.mCallback.clearView(this.mRecyclerView, prevSelected);
            }
            this.mSelected = null;
        }
        if (selected != null) {
            this.mSelectedFlags = (this.mCallback.getAbsoluteMovementFlags(this.mRecyclerView, selected) & actionStateMask) >> this.mActionState * 8;
            this.mSelectedStartX = selected.itemView.getLeft();
            this.mSelectedStartY = selected.itemView.getTop();
            this.mSelected = selected;
            if (actionState == 2) {
                this.mSelected.itemView.performHapticFeedback(0);
            }
        }
        if ((rvParent = this.mRecyclerView.getParent()) != null) {
            rvParent.requestDisallowInterceptTouchEvent(this.mSelected != null);
        }
        if (!preventLayout) {
            this.mRecyclerView.getLayoutManager().requestSimpleAnimationsInNextLayout();
        }
        this.mCallback.onSelectedChanged(this.mSelected, this.mActionState);
        this.mRecyclerView.invalidate();
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$postDispatchSwipe(RecoverAnimation anim2, int swipeDir) {
        this.mRecyclerView.post(new Runnable(this, anim2, swipeDir){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ RecoverAnimation val$anim;
            /* synthetic */ int val$swipeDir;
            /* synthetic */ ItemTouchHelper this$0;

            private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_4$__constructor__(ItemTouchHelper this$0, RecoverAnimation recoverAnimation, int n) {
            }

            private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_4$run() {
                if (this.this$0.mRecyclerView != null && this.this$0.mRecyclerView.isAttachedToWindow() && !this.val$anim.mOverridden && this.val$anim.mViewHolder.getAdapterPosition() != -1) {
                    RecyclerView.ItemAnimator animator2 = this.this$0.mRecyclerView.getItemAnimator();
                    if (!(animator2 != null && animator2.isRunning(null) || this.this$0.hasRunningRecoverAnim())) {
                        this.this$0.mCallback.onSwiped(this.val$anim.mViewHolder, this.val$swipeDir);
                    } else {
                        this.this$0.mRecyclerView.post(this);
                    }
                }
            }

            private void __constructor__(ItemTouchHelper itemTouchHelper, RecoverAnimation recoverAnimation, int n) {
                this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_4$__constructor__(itemTouchHelper, recoverAnimation, n);
            }
            {
                this.this$0 = itemTouchHelper;
                this.val$anim = recoverAnimation;
                this.val$swipeDir = n;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_4$__constructor__(com.android.internal.widget.helper.ItemTouchHelper com.android.internal.widget.helper.ItemTouchHelper$RecoverAnimation int ), 0, this, itemTouchHelper, recoverAnimation, n);
            }

            @Override
            public void run() {
                InvokeDynamicSupport.bootstrap("run", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_4$run(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper$hasRunningRecoverAnim() {
        int size = this.mRecoverAnimations.size();
        for (int i = 0; i < size; ++i) {
            if (this.mRecoverAnimations.get((int)i).mEnded) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper$scrollIfNecessary() {
        if (this.mSelected == null) {
            this.mDragScrollStartTimeInMs = Long.MIN_VALUE;
            return false;
        }
        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long scrollDuration = this.mDragScrollStartTimeInMs == Long.MIN_VALUE ? 0L : (long)(now - this.mDragScrollStartTimeInMs);
        RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
        if (this.mTmpRect == null) {
            this.mTmpRect = new Rect();
        }
        int scrollX = 0;
        int scrollY = 0;
        lm.calculateItemDecorationsForChild(this.mSelected.itemView, this.mTmpRect);
        if (lm.canScrollHorizontally()) {
            int rightDiff;
            int curX = (int)(this.mSelectedStartX + this.mDx);
            int leftDiff = curX - this.mTmpRect.left - this.mRecyclerView.getPaddingLeft();
            if (this.mDx < 0.0f && leftDiff < 0) {
                scrollX = leftDiff;
            } else if (this.mDx > 0.0f && (rightDiff = curX + this.mSelected.itemView.getWidth() + this.mTmpRect.right - (this.mRecyclerView.getWidth() - this.mRecyclerView.getPaddingRight())) > 0) {
                scrollX = rightDiff;
            }
        }
        if (lm.canScrollVertically()) {
            int bottomDiff;
            int curY = (int)(this.mSelectedStartY + this.mDy);
            int topDiff = curY - this.mTmpRect.top - this.mRecyclerView.getPaddingTop();
            if (this.mDy < 0.0f && topDiff < 0) {
                scrollY = topDiff;
            } else if (this.mDy > 0.0f && (bottomDiff = curY + this.mSelected.itemView.getHeight() + this.mTmpRect.bottom - (this.mRecyclerView.getHeight() - this.mRecyclerView.getPaddingBottom())) > 0) {
                scrollY = bottomDiff;
            }
        }
        if (scrollX != 0) {
            scrollX = this.mCallback.interpolateOutOfBoundsScroll(this.mRecyclerView, this.mSelected.itemView.getWidth(), scrollX, this.mRecyclerView.getWidth(), scrollDuration);
        }
        if (scrollY != 0) {
            scrollY = this.mCallback.interpolateOutOfBoundsScroll(this.mRecyclerView, this.mSelected.itemView.getHeight(), scrollY, this.mRecyclerView.getHeight(), scrollDuration);
        }
        if (scrollX != 0 || scrollY != 0) {
            if (this.mDragScrollStartTimeInMs == Long.MIN_VALUE) {
                this.mDragScrollStartTimeInMs = (long)now;
            }
            this.mRecyclerView.scrollBy(scrollX, scrollY);
            return true;
        }
        this.mDragScrollStartTimeInMs = Long.MIN_VALUE;
        return false;
    }

    private final List<RecyclerView.ViewHolder> $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findSwapTargets(RecyclerView.ViewHolder viewHolder) {
        if (this.mSwapTargets == null) {
            this.mSwapTargets = new ArrayList<RecyclerView.ViewHolder>();
            this.mDistances = new ArrayList<Integer>();
        } else {
            this.mSwapTargets.clear();
            this.mDistances.clear();
        }
        int margin = this.mCallback.getBoundingBoxMargin();
        int left = Math.round(this.mSelectedStartX + this.mDx) - margin;
        int top = Math.round(this.mSelectedStartY + this.mDy) - margin;
        int right = left + viewHolder.itemView.getWidth() + 2 * margin;
        int bottom = top + viewHolder.itemView.getHeight() + 2 * margin;
        int centerX = (left + right) / 2;
        int centerY = (top + bottom) / 2;
        RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
        int childCount = lm.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            RecyclerView.ViewHolder otherVh;
            View other = lm.getChildAt(i);
            if (other == viewHolder.itemView || other.getBottom() < top || other.getTop() > bottom || other.getRight() < left || other.getLeft() > right || !this.mCallback.canDropOver(this.mRecyclerView, this.mSelected, otherVh = this.mRecyclerView.getChildViewHolder(other))) continue;
            int dx = Math.abs(centerX - (other.getLeft() + other.getRight()) / 2);
            int dy = Math.abs(centerY - (other.getTop() + other.getBottom()) / 2);
            int dist = dx * dx + dy * dy;
            int pos = 0;
            int cnt = this.mSwapTargets.size();
            for (int j = 0; j < cnt && dist > this.mDistances.get(j); ++j) {
                ++pos;
            }
            this.mSwapTargets.add(pos, otherVh);
            this.mDistances.add(pos, dist);
        }
        return this.mSwapTargets;
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$moveIfNecessary(RecyclerView.ViewHolder viewHolder) {
        if (this.mRecyclerView.isLayoutRequested()) {
            return;
        }
        if (this.mActionState != 2) {
            return;
        }
        float threshold = this.mCallback.getMoveThreshold(viewHolder);
        int x = (int)(this.mSelectedStartX + this.mDx);
        int y = (int)(this.mSelectedStartY + this.mDy);
        if ((float)Math.abs(y - viewHolder.itemView.getTop()) < (float)viewHolder.itemView.getHeight() * threshold && (float)Math.abs(x - viewHolder.itemView.getLeft()) < (float)viewHolder.itemView.getWidth() * threshold) {
            return;
        }
        List<RecyclerView.ViewHolder> swapTargets = this.findSwapTargets(viewHolder);
        if (swapTargets.size() == 0) {
            return;
        }
        RecyclerView.ViewHolder target = this.mCallback.chooseDropTarget(viewHolder, swapTargets, x, y);
        if (target == null) {
            this.mSwapTargets.clear();
            this.mDistances.clear();
            return;
        }
        int toPosition = target.getAdapterPosition();
        int fromPosition = viewHolder.getAdapterPosition();
        if (this.mCallback.onMove(this.mRecyclerView, viewHolder, target)) {
            this.mCallback.onMoved(this.mRecyclerView, viewHolder, fromPosition, target, toPosition, x, y);
        }
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onChildViewAttachedToWindow(View view) {
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onChildViewDetachedFromWindow(View view) {
        this.removeChildDrawingOrderCallbackIfNecessary(view);
        RecyclerView.ViewHolder holder = this.mRecyclerView.getChildViewHolder(view);
        if (holder == null) {
            return;
        }
        if (this.mSelected != null && holder == this.mSelected) {
            this.select(null, 0);
        } else {
            this.endRecoverAnimation(holder, false);
            if (this.mPendingCleanup.remove(holder.itemView)) {
                this.mCallback.clearView(this.mRecyclerView, holder);
            }
        }
    }

    private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper$endRecoverAnimation(RecyclerView.ViewHolder viewHolder, boolean override) {
        int recoverAnimSize = this.mRecoverAnimations.size();
        for (int i = recoverAnimSize - 1; i >= 0; --i) {
            RecoverAnimation anim2 = this.mRecoverAnimations.get(i);
            if (anim2.mViewHolder != viewHolder) continue;
            anim2.mOverridden |= override;
            if (!anim2.mEnded) {
                anim2.cancel();
            }
            this.mRecoverAnimations.remove(i);
            return anim2.mAnimationType;
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        outRect.setEmpty();
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$obtainVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
        }
        this.mVelocityTracker = VelocityTracker.obtain();
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$releaseVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private final RecyclerView.ViewHolder $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findSwipedView(MotionEvent motionEvent) {
        RecyclerView.LayoutManager lm = this.mRecyclerView.getLayoutManager();
        if (this.mActivePointerId == -1) {
            return null;
        }
        int pointerIndex = motionEvent.findPointerIndex(this.mActivePointerId);
        float dx = motionEvent.getX(pointerIndex) - this.mInitialTouchX;
        float dy = motionEvent.getY(pointerIndex) - this.mInitialTouchY;
        float absDx = Math.abs(dx);
        float absDy = Math.abs(dy);
        if (absDx < (float)this.mSlop && absDy < (float)this.mSlop) {
            return null;
        }
        if (absDx > absDy && lm.canScrollHorizontally()) {
            return null;
        }
        if (absDy > absDx && lm.canScrollVertically()) {
            return null;
        }
        View child = this.findChildView(motionEvent);
        if (child == null) {
            return null;
        }
        return this.mRecyclerView.getChildViewHolder(child);
    }

    private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper$checkSelectForSwipe(int action, MotionEvent motionEvent, int pointerIndex) {
        if (this.mSelected != null || action != 2 || this.mActionState == 2 || !this.mCallback.isItemViewSwipeEnabled()) {
            return false;
        }
        if (this.mRecyclerView.getScrollState() == 1) {
            return false;
        }
        RecyclerView.ViewHolder vh = this.findSwipedView(motionEvent);
        if (vh == null) {
            return false;
        }
        int movementFlags = this.mCallback.getAbsoluteMovementFlags(this.mRecyclerView, vh);
        int swipeFlags = (movementFlags & 0xFF00) >> 8;
        if (swipeFlags == 0) {
            return false;
        }
        float x = motionEvent.getX(pointerIndex);
        float y = motionEvent.getY(pointerIndex);
        float dx = x - this.mInitialTouchX;
        float dy = y - this.mInitialTouchY;
        float absDx = Math.abs(dx);
        float absDy = Math.abs(dy);
        if (absDx < (float)this.mSlop && absDy < (float)this.mSlop) {
            return false;
        }
        if (absDx > absDy) {
            if (dx < 0.0f && (swipeFlags & 4) == 0) {
                return false;
            }
            if (dx > 0.0f && (swipeFlags & 8) == 0) {
                return false;
            }
        } else {
            if (dy < 0.0f && (swipeFlags & 1) == 0) {
                return false;
            }
            if (dy > 0.0f && (swipeFlags & 2) == 0) {
                return false;
            }
        }
        this.mDy = 0.0f;
        this.mDx = 0.0f;
        this.mActivePointerId = motionEvent.getPointerId(0);
        this.select(vh, 1);
        return true;
    }

    private final View $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findChildView(MotionEvent event) {
        View selectedView;
        float x = event.getX();
        float y = event.getY();
        if (this.mSelected != null && ItemTouchHelper.hitTest(selectedView = this.mSelected.itemView, x, y, this.mSelectedStartX + this.mDx, this.mSelectedStartY + this.mDy)) {
            return selectedView;
        }
        for (int i = this.mRecoverAnimations.size() - 1; i >= 0; --i) {
            RecoverAnimation anim2 = this.mRecoverAnimations.get(i);
            View view = anim2.mViewHolder.itemView;
            if (!ItemTouchHelper.hitTest(view, x, y, anim2.mX, anim2.mY)) continue;
            return view;
        }
        return this.mRecyclerView.findChildViewUnder(x, y);
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$startDrag(RecyclerView.ViewHolder viewHolder) {
        if (!this.mCallback.hasDragFlag(this.mRecyclerView, viewHolder)) {
            Log.e("ItemTouchHelper", "Start drag has been called but dragging is not enabled");
            return;
        }
        if (viewHolder.itemView.getParent() != this.mRecyclerView) {
            Log.e("ItemTouchHelper", "Start drag has been called with a view holder which is not a child of the RecyclerView which is controlled by this ItemTouchHelper.");
            return;
        }
        this.obtainVelocityTracker();
        this.mDy = 0.0f;
        this.mDx = 0.0f;
        this.select(viewHolder, 2);
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$startSwipe(RecyclerView.ViewHolder viewHolder) {
        if (!this.mCallback.hasSwipeFlag(this.mRecyclerView, viewHolder)) {
            Log.e("ItemTouchHelper", "Start swipe has been called but swiping is not enabled");
            return;
        }
        if (viewHolder.itemView.getParent() != this.mRecyclerView) {
            Log.e("ItemTouchHelper", "Start swipe has been called with a view holder which is not a child of the RecyclerView controlled by this ItemTouchHelper.");
            return;
        }
        this.obtainVelocityTracker();
        this.mDy = 0.0f;
        this.mDx = 0.0f;
        this.select(viewHolder, 1);
    }

    private final RecoverAnimation $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findAnimation(MotionEvent event) {
        if (this.mRecoverAnimations.isEmpty()) {
            return null;
        }
        View target = this.findChildView(event);
        for (int i = this.mRecoverAnimations.size() - 1; i >= 0; --i) {
            RecoverAnimation anim2 = this.mRecoverAnimations.get(i);
            if (anim2.mViewHolder.itemView != target) continue;
            return anim2;
        }
        return null;
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$updateDxDy(MotionEvent ev, int directionFlags, int pointerIndex) {
        float x = ev.getX(pointerIndex);
        float y = ev.getY(pointerIndex);
        this.mDx = x - this.mInitialTouchX;
        this.mDy = y - this.mInitialTouchY;
        if ((directionFlags & 4) == 0) {
            this.mDx = Math.max(0.0f, this.mDx);
        }
        if ((directionFlags & 8) == 0) {
            this.mDx = Math.min(0.0f, this.mDx);
        }
        if ((directionFlags & 1) == 0) {
            this.mDy = Math.max(0.0f, this.mDy);
        }
        if ((directionFlags & 2) == 0) {
            this.mDy = Math.min(0.0f, this.mDy);
        }
    }

    private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper$swipeIfNecessary(RecyclerView.ViewHolder viewHolder) {
        if (this.mActionState == 2) {
            return 0;
        }
        int originalMovementFlags = this.mCallback.getMovementFlags(this.mRecyclerView, viewHolder);
        int absoluteMovementFlags = this.mCallback.convertToAbsoluteDirection(originalMovementFlags, this.mRecyclerView.getLayoutDirection());
        int flags = (absoluteMovementFlags & 0xFF00) >> 8;
        if (flags == 0) {
            return 0;
        }
        int originalFlags = (originalMovementFlags & 0xFF00) >> 8;
        if (Math.abs(this.mDx) > Math.abs(this.mDy)) {
            int swipeDir = this.checkHorizontalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                if ((originalFlags & swipeDir) == 0) {
                    return Callback.convertToRelativeDirection(swipeDir, this.mRecyclerView.getLayoutDirection());
                }
                return swipeDir;
            }
            swipeDir = this.checkVerticalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                return swipeDir;
            }
        } else {
            int swipeDir = this.checkVerticalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                return swipeDir;
            }
            swipeDir = this.checkHorizontalSwipe(viewHolder, flags);
            if (swipeDir > 0) {
                if ((originalFlags & swipeDir) == 0) {
                    return Callback.convertToRelativeDirection(swipeDir, this.mRecyclerView.getLayoutDirection());
                }
                return swipeDir;
            }
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper$checkHorizontalSwipe(RecyclerView.ViewHolder viewHolder, int flags) {
        if ((flags & 0xC) != 0) {
            int dirFlag;
            int n = dirFlag = this.mDx > 0.0f ? 8 : 4;
            if (this.mVelocityTracker != null && this.mActivePointerId > -1) {
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mCallback.getSwipeVelocityThreshold(this.mMaxSwipeVelocity));
                float xVelocity = this.mVelocityTracker.getXVelocity(this.mActivePointerId);
                float yVelocity = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                int velDirFlag = xVelocity > 0.0f ? 8 : 4;
                float absXVelocity = Math.abs(xVelocity);
                if ((velDirFlag & flags) != 0 && dirFlag == velDirFlag && absXVelocity >= this.mCallback.getSwipeEscapeVelocity(this.mSwipeEscapeVelocity) && absXVelocity > Math.abs(yVelocity)) {
                    return velDirFlag;
                }
            }
            float threshold = (float)this.mRecyclerView.getWidth() * this.mCallback.getSwipeThreshold(viewHolder);
            if ((flags & dirFlag) != 0 && Math.abs(this.mDx) > threshold) {
                return dirFlag;
            }
        }
        return 0;
    }

    private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper$checkVerticalSwipe(RecyclerView.ViewHolder viewHolder, int flags) {
        if ((flags & 3) != 0) {
            int dirFlag;
            int n = dirFlag = this.mDy > 0.0f ? 2 : 1;
            if (this.mVelocityTracker != null && this.mActivePointerId > -1) {
                this.mVelocityTracker.computeCurrentVelocity(1000, this.mCallback.getSwipeVelocityThreshold(this.mMaxSwipeVelocity));
                float xVelocity = this.mVelocityTracker.getXVelocity(this.mActivePointerId);
                float yVelocity = this.mVelocityTracker.getYVelocity(this.mActivePointerId);
                int velDirFlag = yVelocity > 0.0f ? 2 : 1;
                float absYVelocity = Math.abs(yVelocity);
                if ((velDirFlag & flags) != 0 && velDirFlag == dirFlag && absYVelocity >= this.mCallback.getSwipeEscapeVelocity(this.mSwipeEscapeVelocity) && absYVelocity > Math.abs(xVelocity)) {
                    return velDirFlag;
                }
            }
            float threshold = (float)this.mRecyclerView.getHeight() * this.mCallback.getSwipeThreshold(viewHolder);
            if ((flags & dirFlag) != 0 && Math.abs(this.mDy) > threshold) {
                return dirFlag;
            }
        }
        return 0;
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$addChildDrawingOrderCallback() {
        if (Build.VERSION.SDK_INT >= 21) {
            return;
        }
        if (this.mChildDrawingOrderCallback == null) {
            this.mChildDrawingOrderCallback = new RecyclerView.ChildDrawingOrderCallback(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ItemTouchHelper this$0;

                private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_5$__constructor__(ItemTouchHelper this$0) {
                }

                private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_5$onGetChildDrawingOrder(int childCount, int i) {
                    if (this.this$0.mOverdrawChild == null) {
                        return i;
                    }
                    int childPosition = this.this$0.mOverdrawChildPosition;
                    if (childPosition == -1) {
                        this.this$0.mOverdrawChildPosition = childPosition = this.this$0.mRecyclerView.indexOfChild(this.this$0.mOverdrawChild);
                    }
                    if (i == childCount - 1) {
                        return childPosition;
                    }
                    return i < childPosition ? i : i + 1;
                }

                private void __constructor__(ItemTouchHelper itemTouchHelper) {
                    this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_5$__constructor__(itemTouchHelper);
                }
                {
                    this.this$0 = itemTouchHelper;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_5$__constructor__(com.android.internal.widget.helper.ItemTouchHelper ), 0, this, itemTouchHelper);
                }

                @Override
                public int onGetChildDrawingOrder(int n, int n2) {
                    return (int)InvokeDynamicSupport.bootstrap("onGetChildDrawingOrder", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_5$onGetChildDrawingOrder(int int ), 0, this, n, n2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        this.mRecyclerView.setChildDrawingOrderCallback(this.mChildDrawingOrderCallback);
    }

    private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper$removeChildDrawingOrderCallbackIfNecessary(View view) {
        if (view == this.mOverdrawChild) {
            this.mOverdrawChild = null;
            if (this.mChildDrawingOrderCallback != null) {
                this.mRecyclerView.setChildDrawingOrderCallback(null);
            }
        }
    }

    private void __constructor__(Callback callback) {
        this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper$__constructor__(callback);
    }

    public ItemTouchHelper(Callback callback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$__constructor__(com.android.internal.widget.helper.ItemTouchHelper$Callback ), 0, this, callback);
    }

    private static boolean hitTest(View view, float f, float f2, float f3, float f4) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hitTest", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$hitTest(android.view.View float float float float ), 0, (View)view, (float)f, (float)f2, (float)f3, (float)f4);
    }

    public void attachToRecyclerView(RecyclerView recyclerView) {
        InvokeDynamicSupport.bootstrap("attachToRecyclerView", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$attachToRecyclerView(com.android.internal.widget.RecyclerView ), 0, this, recyclerView);
    }

    private void setupCallbacks() {
        InvokeDynamicSupport.bootstrap("setupCallbacks", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$setupCallbacks(), 0, this);
    }

    private void destroyCallbacks() {
        InvokeDynamicSupport.bootstrap("destroyCallbacks", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$destroyCallbacks(), 0, this);
    }

    private void initGestureDetector() {
        InvokeDynamicSupport.bootstrap("initGestureDetector", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$initGestureDetector(), 0, this);
    }

    private void getSelectedDxDy(float[] fArray) {
        InvokeDynamicSupport.bootstrap("getSelectedDxDy", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$getSelectedDxDy(float[] ), 0, this, fArray);
    }

    @Override
    public void onDrawOver(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        InvokeDynamicSupport.bootstrap("onDrawOver", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onDrawOver(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State ), 0, this, canvas, recyclerView, state);
    }

    @Override
    public void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.State state) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onDraw(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State ), 0, this, canvas, recyclerView, state);
    }

    void select(RecyclerView.ViewHolder viewHolder, int n) {
        InvokeDynamicSupport.bootstrap("select", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$select(com.android.internal.widget.RecyclerView$ViewHolder int ), 0, this, viewHolder, n);
    }

    void postDispatchSwipe(RecoverAnimation recoverAnimation, int n) {
        InvokeDynamicSupport.bootstrap("postDispatchSwipe", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$postDispatchSwipe(com.android.internal.widget.helper.ItemTouchHelper$RecoverAnimation int ), 0, this, recoverAnimation, n);
    }

    boolean hasRunningRecoverAnim() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasRunningRecoverAnim", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$hasRunningRecoverAnim(), 0, this);
    }

    boolean scrollIfNecessary() {
        return (boolean)InvokeDynamicSupport.bootstrap("scrollIfNecessary", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$scrollIfNecessary(), 0, this);
    }

    private List<RecyclerView.ViewHolder> findSwapTargets(RecyclerView.ViewHolder viewHolder) {
        return InvokeDynamicSupport.bootstrap("findSwapTargets", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findSwapTargets(com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, viewHolder);
    }

    void moveIfNecessary(RecyclerView.ViewHolder viewHolder) {
        InvokeDynamicSupport.bootstrap("moveIfNecessary", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$moveIfNecessary(com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, viewHolder);
    }

    @Override
    public void onChildViewAttachedToWindow(View view) {
        InvokeDynamicSupport.bootstrap("onChildViewAttachedToWindow", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onChildViewAttachedToWindow(android.view.View ), 0, this, view);
    }

    @Override
    public void onChildViewDetachedFromWindow(View view) {
        InvokeDynamicSupport.bootstrap("onChildViewDetachedFromWindow", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$onChildViewDetachedFromWindow(android.view.View ), 0, this, view);
    }

    int endRecoverAnimation(RecyclerView.ViewHolder viewHolder, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("endRecoverAnimation", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$endRecoverAnimation(com.android.internal.widget.RecyclerView$ViewHolder boolean ), 0, this, viewHolder, bl);
    }

    @Override
    public void getItemOffsets(Rect rect, View view, RecyclerView recyclerView, RecyclerView.State state) {
        InvokeDynamicSupport.bootstrap("getItemOffsets", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$getItemOffsets(android.graphics.Rect android.view.View com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$State ), 0, this, rect, view, recyclerView, state);
    }

    void obtainVelocityTracker() {
        InvokeDynamicSupport.bootstrap("obtainVelocityTracker", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$obtainVelocityTracker(), 0, this);
    }

    private void releaseVelocityTracker() {
        InvokeDynamicSupport.bootstrap("releaseVelocityTracker", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$releaseVelocityTracker(), 0, this);
    }

    private RecyclerView.ViewHolder findSwipedView(MotionEvent motionEvent) {
        return InvokeDynamicSupport.bootstrap("findSwipedView", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findSwipedView(android.view.MotionEvent ), 0, this, motionEvent);
    }

    boolean checkSelectForSwipe(int n, MotionEvent motionEvent, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkSelectForSwipe", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$checkSelectForSwipe(int android.view.MotionEvent int ), 0, this, n, motionEvent, n2);
    }

    View findChildView(MotionEvent motionEvent) {
        return InvokeDynamicSupport.bootstrap("findChildView", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findChildView(android.view.MotionEvent ), 0, this, motionEvent);
    }

    public void startDrag(RecyclerView.ViewHolder viewHolder) {
        InvokeDynamicSupport.bootstrap("startDrag", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$startDrag(com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, viewHolder);
    }

    public void startSwipe(RecyclerView.ViewHolder viewHolder) {
        InvokeDynamicSupport.bootstrap("startSwipe", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$startSwipe(com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, viewHolder);
    }

    RecoverAnimation findAnimation(MotionEvent motionEvent) {
        return InvokeDynamicSupport.bootstrap("findAnimation", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$findAnimation(android.view.MotionEvent ), 0, this, motionEvent);
    }

    void updateDxDy(MotionEvent motionEvent, int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateDxDy", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$updateDxDy(android.view.MotionEvent int int ), 0, this, motionEvent, n, n2);
    }

    private int swipeIfNecessary(RecyclerView.ViewHolder viewHolder) {
        return (int)InvokeDynamicSupport.bootstrap("swipeIfNecessary", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$swipeIfNecessary(com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, viewHolder);
    }

    private int checkHorizontalSwipe(RecyclerView.ViewHolder viewHolder, int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkHorizontalSwipe", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$checkHorizontalSwipe(com.android.internal.widget.RecyclerView$ViewHolder int ), 0, this, viewHolder, n);
    }

    private int checkVerticalSwipe(RecyclerView.ViewHolder viewHolder, int n) {
        return (int)InvokeDynamicSupport.bootstrap("checkVerticalSwipe", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$checkVerticalSwipe(com.android.internal.widget.RecyclerView$ViewHolder int ), 0, this, viewHolder, n);
    }

    private void addChildDrawingOrderCallback() {
        InvokeDynamicSupport.bootstrap("addChildDrawingOrderCallback", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$addChildDrawingOrderCallback(), 0, this);
    }

    void removeChildDrawingOrderCallbackIfNecessary(View view) {
        InvokeDynamicSupport.bootstrap("removeChildDrawingOrderCallbackIfNecessary", $$robo$$com_android_internal_widget_helper_ItemTouchHelper$removeChildDrawingOrderCallbackIfNecessary(android.view.View ), 0, this, view);
    }

    public /* synthetic */ ItemTouchHelper() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemTouchHelper)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class RecoverAnimation
    implements Animator.AnimatorListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        float mStartDx;
        float mStartDy;
        float mTargetX;
        float mTargetY;
        RecyclerView.ViewHolder mViewHolder;
        int mActionState;
        private ValueAnimator mValueAnimator;
        int mAnimationType;
        public boolean mIsPendingCleanup;
        float mX;
        float mY;
        boolean mOverridden;
        boolean mEnded;
        private float mFraction;
        /* synthetic */ ItemTouchHelper this$0;

        private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$__constructor__(ItemTouchHelper itemTouchHelper, RecyclerView.ViewHolder viewHolder, int animationType, int actionState, float startDx, float startDy, float targetX, float targetY) {
            this.mOverridden = false;
            this.mEnded = false;
            this.mActionState = actionState;
            this.mAnimationType = animationType;
            this.mViewHolder = viewHolder;
            this.mStartDx = startDx;
            this.mStartDy = startDy;
            this.mTargetX = targetX;
            this.mTargetY = targetY;
            this.mValueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this, itemTouchHelper){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ItemTouchHelper val$this$0;
                /* synthetic */ RecoverAnimation this$1;

                private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation_1$__constructor__(RecoverAnimation this$1, ItemTouchHelper itemTouchHelper) {
                }

                private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation_1$onAnimationUpdate(ValueAnimator animation) {
                    this.this$1.setFraction(animation.getAnimatedFraction());
                }

                private void __constructor__(RecoverAnimation recoverAnimation, ItemTouchHelper itemTouchHelper) {
                    this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation_1$__constructor__(recoverAnimation, itemTouchHelper);
                }
                {
                    this.this$1 = recoverAnimation;
                    this.val$this$0 = itemTouchHelper;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation_1$__constructor__(com.android.internal.widget.helper.ItemTouchHelper$RecoverAnimation com.android.internal.widget.helper.ItemTouchHelper ), 0, this, recoverAnimation, itemTouchHelper);
                }

                @Override
                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    InvokeDynamicSupport.bootstrap("onAnimationUpdate", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation_1$onAnimationUpdate(android.animation.ValueAnimator ), 0, this, valueAnimator);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mValueAnimator.setTarget(viewHolder.itemView);
            this.mValueAnimator.addListener(this);
            this.setFraction(0.0f);
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$setDuration(long duration) {
            this.mValueAnimator.setDuration(duration);
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$start() {
            this.mViewHolder.setIsRecyclable(false);
            this.mValueAnimator.start();
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$cancel() {
            this.mValueAnimator.cancel();
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$setFraction(float fraction2) {
            this.mFraction = fraction2;
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$update() {
            this.mX = this.mStartDx == this.mTargetX ? this.mViewHolder.itemView.getTranslationX() : this.mStartDx + this.mFraction * (this.mTargetX - this.mStartDx);
            this.mY = this.mStartDy == this.mTargetY ? this.mViewHolder.itemView.getTranslationY() : this.mStartDy + this.mFraction * (this.mTargetY - this.mStartDy);
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationStart(Animator animation) {
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationEnd(Animator animation) {
            if (!this.mEnded) {
                this.mViewHolder.setIsRecyclable(true);
            }
            this.mEnded = true;
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationCancel(Animator animation) {
            this.setFraction(1.0f);
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationRepeat(Animator animation) {
        }

        private void __constructor__(ItemTouchHelper itemTouchHelper, RecyclerView.ViewHolder viewHolder, int n, int n2, float f, float f2, float f3, float f4) {
            this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$__constructor__(itemTouchHelper, viewHolder, n, n2, f, f2, f3, f4);
        }

        RecoverAnimation(ItemTouchHelper itemTouchHelper, RecyclerView.ViewHolder viewHolder, int n, int n2, float f, float f2, float f3, float f4) {
            this.this$0 = itemTouchHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$__constructor__(com.android.internal.widget.helper.ItemTouchHelper com.android.internal.widget.RecyclerView$ViewHolder int int float float float float ), 0, this, itemTouchHelper, viewHolder, n, n2, f, f2, f3, f4);
        }

        public void setDuration(long l) {
            InvokeDynamicSupport.bootstrap("setDuration", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$setDuration(long ), 0, this, l);
        }

        public void start() {
            InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$start(), 0, this);
        }

        public void cancel() {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$cancel(), 0, this);
        }

        public void setFraction(float f) {
            InvokeDynamicSupport.bootstrap("setFraction", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$setFraction(float ), 0, this, f);
        }

        public void update() {
            InvokeDynamicSupport.bootstrap("update", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$update(), 0, this);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationStart(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_RecoverAnimation$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
        }

        public /* synthetic */ RecoverAnimation() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecoverAnimation)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class ItemTouchHelperGestureListener
    extends GestureDetector.SimpleOnGestureListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ ItemTouchHelper this$0;

        private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_ItemTouchHelperGestureListener$__constructor__(ItemTouchHelper itemTouchHelper) {
        }

        private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper_ItemTouchHelperGestureListener$onDown(MotionEvent e) {
            return true;
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_ItemTouchHelperGestureListener$onLongPress(MotionEvent e) {
            RecyclerView.ViewHolder vh;
            View child = this.this$0.findChildView(e);
            if (child != null && (vh = this.this$0.mRecyclerView.getChildViewHolder(child)) != null) {
                if (!this.this$0.mCallback.hasDragFlag(this.this$0.mRecyclerView, vh)) {
                    return;
                }
                int pointerId = e.getPointerId(0);
                if (pointerId == this.this$0.mActivePointerId) {
                    int index = e.findPointerIndex(this.this$0.mActivePointerId);
                    float x = e.getX(index);
                    float y = e.getY(index);
                    this.this$0.mInitialTouchX = x;
                    this.this$0.mInitialTouchY = y;
                    this.this$0.mDy = 0.0f;
                    this.this$0.mDx = 0.0f;
                    if (this.this$0.mCallback.isLongPressDragEnabled()) {
                        this.this$0.select(vh, 2);
                    }
                }
            }
        }

        private void __constructor__(ItemTouchHelper itemTouchHelper) {
            this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_ItemTouchHelperGestureListener$__constructor__(itemTouchHelper);
        }

        ItemTouchHelperGestureListener(ItemTouchHelper itemTouchHelper) {
            this.this$0 = itemTouchHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_ItemTouchHelperGestureListener$__constructor__(com.android.internal.widget.helper.ItemTouchHelper ), 0, this, itemTouchHelper);
        }

        @Override
        public boolean onDown(MotionEvent motionEvent) {
            return (boolean)InvokeDynamicSupport.bootstrap("onDown", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_ItemTouchHelperGestureListener$onDown(android.view.MotionEvent ), 0, this, motionEvent);
        }

        @Override
        public void onLongPress(MotionEvent motionEvent) {
            InvokeDynamicSupport.bootstrap("onLongPress", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_ItemTouchHelperGestureListener$onLongPress(android.view.MotionEvent ), 0, this, motionEvent);
        }

        public /* synthetic */ ItemTouchHelperGestureListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ItemTouchHelperGestureListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class SimpleCallback
    extends Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mDefaultSwipeDirs;
        private int mDefaultDragDirs;

        private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$__constructor__(int dragDirs, int swipeDirs) {
            this.mDefaultSwipeDirs = swipeDirs;
            this.mDefaultDragDirs = dragDirs;
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$setDefaultSwipeDirs(int defaultSwipeDirs) {
            this.mDefaultSwipeDirs = defaultSwipeDirs;
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$setDefaultDragDirs(int defaultDragDirs) {
            this.mDefaultDragDirs = defaultDragDirs;
        }

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return this.mDefaultSwipeDirs;
        }

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$getDragDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return this.mDefaultDragDirs;
        }

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return SimpleCallback.makeMovementFlags(this.getDragDirs(recyclerView, viewHolder), this.getSwipeDirs(recyclerView, viewHolder));
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$__constructor__(n, n2);
        }

        public SimpleCallback(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$__constructor__(int int ), 0, this, n, n2);
        }

        public void setDefaultSwipeDirs(int n) {
            InvokeDynamicSupport.bootstrap("setDefaultSwipeDirs", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$setDefaultSwipeDirs(int ), 0, this, n);
        }

        public void setDefaultDragDirs(int n) {
            InvokeDynamicSupport.bootstrap("setDefaultDragDirs", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$setDefaultDragDirs(int ), 0, this, n);
        }

        public int getSwipeDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return (int)InvokeDynamicSupport.bootstrap("getSwipeDirs", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$getSwipeDirs(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder);
        }

        public int getDragDirs(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return (int)InvokeDynamicSupport.bootstrap("getDragDirs", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$getDragDirs(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder);
        }

        @Override
        public int getMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return (int)InvokeDynamicSupport.bootstrap("getMovementFlags", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_SimpleCallback$getMovementFlags(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder);
        }

        public /* synthetic */ SimpleCallback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SimpleCallback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int DEFAULT_DRAG_ANIMATION_DURATION = 200;
        public static int DEFAULT_SWIPE_ANIMATION_DURATION = 250;
        static int RELATIVE_DIR_FLAGS = 0x303030;
        private static ItemTouchUIUtil sUICallback;
        private static int ABS_HORIZONTAL_DIR_FLAGS = 789516;
        private static Interpolator sDragScrollInterpolator;
        private static Interpolator sDragViewScrollCapInterpolator;
        private static long DRAG_SCROLL_ACCELERATION_LIMIT_TIME_MS = 2000L;
        private int mCachedMaxScrollSpeed;

        private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$__constructor__() {
            this.mCachedMaxScrollSpeed = -1;
        }

        private static final ItemTouchUIUtil $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getDefaultUIUtil() {
            return sUICallback;
        }

        private static final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$convertToRelativeDirection(int flags, int layoutDirection) {
            int masked = flags & 0xC0C0C;
            if (masked == 0) {
                return flags;
            }
            flags &= ~masked;
            if (layoutDirection == 0) {
                return flags |= masked << 2;
            }
            flags |= masked << 1 & 0xFFF3F3F3;
            return flags |= (masked << 1 & 0xC0C0C) << 2;
        }

        private static final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$makeMovementFlags(int dragFlags, int swipeFlags) {
            return Callback.makeFlag(0, swipeFlags | dragFlags) | Callback.makeFlag(1, swipeFlags) | Callback.makeFlag(2, dragFlags);
        }

        private static final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$makeFlag(int actionState, int directions) {
            return directions << actionState * 8;
        }

        public abstract int getMovementFlags(RecyclerView var1, RecyclerView.ViewHolder var2);

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$convertToAbsoluteDirection(int flags, int layoutDirection) {
            int masked = flags & 0x303030;
            if (masked == 0) {
                return flags;
            }
            flags &= ~masked;
            if (layoutDirection == 0) {
                return flags |= masked >> 2;
            }
            flags |= masked >> 1 & 0xFFCFCFCF;
            return flags |= (masked >> 1 & 0x303030) >> 2;
        }

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getAbsoluteMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int flags = this.getMovementFlags(recyclerView, viewHolder);
            return this.convertToAbsoluteDirection(flags, recyclerView.getLayoutDirection());
        }

        private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$hasDragFlag(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int flags = this.getAbsoluteMovementFlags(recyclerView, viewHolder);
            return (flags & 0xFF0000) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$hasSwipeFlag(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            int flags = this.getAbsoluteMovementFlags(recyclerView, viewHolder);
            return (flags & 0xFF00) != 0;
        }

        private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder current, RecyclerView.ViewHolder target) {
            return true;
        }

        public abstract boolean onMove(RecyclerView var1, RecyclerView.ViewHolder var2, RecyclerView.ViewHolder var3);

        private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$isLongPressDragEnabled() {
            return true;
        }

        private final boolean $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$isItemViewSwipeEnabled() {
            return true;
        }

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getBoundingBoxMargin() {
            return 0;
        }

        private final float $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
            return 0.5f;
        }

        private final float $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
            return 0.5f;
        }

        private final float $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getSwipeEscapeVelocity(float defaultValue) {
            return defaultValue;
        }

        private final float $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getSwipeVelocityThreshold(float defaultValue) {
            return defaultValue;
        }

        private final RecyclerView.ViewHolder $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$chooseDropTarget(RecyclerView.ViewHolder selected, List<RecyclerView.ViewHolder> dropTargets, int curX, int curY) {
            int right = curX + selected.itemView.getWidth();
            int bottom = curY + selected.itemView.getHeight();
            RecyclerView.ViewHolder winner = null;
            int winnerScore = -1;
            int dx = curX - selected.itemView.getLeft();
            int dy = curY - selected.itemView.getTop();
            int targetsSize = dropTargets.size();
            for (int i = 0; i < targetsSize; ++i) {
                int score;
                int diff;
                RecyclerView.ViewHolder target = dropTargets.get(i);
                if (dx > 0 && (diff = target.itemView.getRight() - right) < 0 && target.itemView.getRight() > selected.itemView.getRight() && (score = Math.abs(diff)) > winnerScore) {
                    winnerScore = score;
                    winner = target;
                }
                if (dx < 0 && (diff = target.itemView.getLeft() - curX) > 0 && target.itemView.getLeft() < selected.itemView.getLeft() && (score = Math.abs(diff)) > winnerScore) {
                    winnerScore = score;
                    winner = target;
                }
                if (dy < 0 && (diff = target.itemView.getTop() - curY) > 0 && target.itemView.getTop() < selected.itemView.getTop() && (score = Math.abs(diff)) > winnerScore) {
                    winnerScore = score;
                    winner = target;
                }
                if (dy <= 0 || (diff = target.itemView.getBottom() - bottom) >= 0 || target.itemView.getBottom() <= selected.itemView.getBottom() || (score = Math.abs(diff)) <= winnerScore) continue;
                winnerScore = score;
                winner = target;
            }
            return winner;
        }

        public abstract void onSwiped(RecyclerView.ViewHolder var1, int var2);

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onSelectedChanged(RecyclerView.ViewHolder viewHolder, int actionState) {
            if (viewHolder != null) {
                sUICallback.onSelected(viewHolder.itemView);
            }
        }

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getMaxDragScroll(RecyclerView recyclerView) {
            if (this.mCachedMaxScrollSpeed == -1) {
                this.mCachedMaxScrollSpeed = recyclerView.getResources().getDimensionPixelSize(17105060);
            }
            return this.mCachedMaxScrollSpeed;
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onMoved(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, int fromPos, RecyclerView.ViewHolder target, int toPos, int x, int y) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof ViewDropHandler) {
                ((ViewDropHandler)((Object)layoutManager)).prepareForDrop(viewHolder.itemView, target.itemView, x, y);
                return;
            }
            if (layoutManager.canScrollHorizontally()) {
                int maxRight;
                int minLeft = layoutManager.getDecoratedLeft(target.itemView);
                if (minLeft <= recyclerView.getPaddingLeft()) {
                    recyclerView.scrollToPosition(toPos);
                }
                if ((maxRight = layoutManager.getDecoratedRight(target.itemView)) >= recyclerView.getWidth() - recyclerView.getPaddingRight()) {
                    recyclerView.scrollToPosition(toPos);
                }
            }
            if (layoutManager.canScrollVertically()) {
                int maxBottom;
                int minTop = layoutManager.getDecoratedTop(target.itemView);
                if (minTop <= recyclerView.getPaddingTop()) {
                    recyclerView.scrollToPosition(toPos);
                }
                if ((maxBottom = layoutManager.getDecoratedBottom(target.itemView)) >= recyclerView.getHeight() - recyclerView.getPaddingBottom()) {
                    recyclerView.scrollToPosition(toPos);
                }
            }
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onDraw(Canvas c, RecyclerView parent, RecyclerView.ViewHolder selected, List<RecoverAnimation> recoverAnimationList, int actionState, float dX, float dY) {
            int recoverAnimSize = recoverAnimationList.size();
            for (int i = 0; i < recoverAnimSize; ++i) {
                RecoverAnimation anim2 = recoverAnimationList.get(i);
                anim2.update();
                int count = c.save();
                this.onChildDraw(c, parent, anim2.mViewHolder, anim2.mX, anim2.mY, anim2.mActionState, false);
                c.restoreToCount(count);
            }
            if (selected != null) {
                int count = c.save();
                this.onChildDraw(c, parent, selected, dX, dY, actionState, true);
                c.restoreToCount(count);
            }
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onDrawOver(Canvas c, RecyclerView parent, RecyclerView.ViewHolder selected, List<RecoverAnimation> recoverAnimationList, int actionState, float dX, float dY) {
            int recoverAnimSize = recoverAnimationList.size();
            for (int i = 0; i < recoverAnimSize; ++i) {
                RecoverAnimation anim2 = recoverAnimationList.get(i);
                int count = c.save();
                this.onChildDrawOver(c, parent, anim2.mViewHolder, anim2.mX, anim2.mY, anim2.mActionState, false);
                c.restoreToCount(count);
            }
            if (selected != null) {
                int count = c.save();
                this.onChildDrawOver(c, parent, selected, dX, dY, actionState, true);
                c.restoreToCount(count);
            }
            boolean hasRunningAnimation = false;
            for (int i = recoverAnimSize - 1; i >= 0; --i) {
                RecoverAnimation anim3 = recoverAnimationList.get(i);
                if (anim3.mEnded && !anim3.mIsPendingCleanup) {
                    recoverAnimationList.remove(i);
                    continue;
                }
                if (anim3.mEnded) continue;
                hasRunningAnimation = true;
            }
            if (hasRunningAnimation) {
                parent.invalidate();
            }
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            sUICallback.clearView(viewHolder.itemView);
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            sUICallback.onDraw(c, recyclerView, viewHolder.itemView, dX, dY, actionState, isCurrentlyActive);
        }

        private final void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onChildDrawOver(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float dX, float dY, int actionState, boolean isCurrentlyActive) {
            sUICallback.onDrawOver(c, recyclerView, viewHolder.itemView, dX, dY, actionState, isCurrentlyActive);
        }

        private final long $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getAnimationDuration(RecyclerView recyclerView, int animationType, float animateDx, float animateDy) {
            RecyclerView.ItemAnimator itemAnimator = recyclerView.getItemAnimator();
            if (itemAnimator == null) {
                return animationType == 8 ? 200L : 250L;
            }
            return animationType == 8 ? itemAnimator.getMoveDuration() : itemAnimator.getRemoveDuration();
        }

        private final int $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$interpolateOutOfBoundsScroll(RecyclerView recyclerView, int viewSize, int viewSizeOutOfBounds, int totalSize, long msSinceStartScroll) {
            float timeRatio;
            float outOfBoundsRatio;
            int maxScroll = this.getMaxDragScroll(recyclerView);
            int absOutOfBounds = Math.abs(viewSizeOutOfBounds);
            int direction = (int)Math.signum(viewSizeOutOfBounds);
            int cappedScroll = (int)((float)(direction * maxScroll) * sDragViewScrollCapInterpolator.getInterpolation(outOfBoundsRatio = Math.min(1.0f, 1.0f * (float)absOutOfBounds / (float)viewSize)));
            int value = (int)((float)cappedScroll * sDragScrollInterpolator.getInterpolation(timeRatio = msSinceStartScroll > 2000L ? 1.0f : (float)msSinceStartScroll / 2000.0f));
            if (value == 0) {
                return viewSizeOutOfBounds > 0 ? 1 : -1;
            }
            return value;
        }

        static void __staticInitializer__() {
            sUICallback = new ItemTouchUIUtilImpl();
            sDragScrollInterpolator = new Interpolator(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_1$__constructor__() {
                }

                private final float $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_1$getInterpolation(float t) {
                    return t * t * t * t * t;
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_1$__constructor__(), 0, this);
                }

                @Override
                public float getInterpolation(float f) {
                    return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_1$getInterpolation(float ), 0, this, f);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            sDragViewScrollCapInterpolator = new Interpolator(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_2$__constructor__() {
                }

                private final float $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_2$getInterpolation(float t) {
                    return (t -= 1.0f) * t * t * t * t + 1.0f;
                }

                private void __constructor__() {
                    this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_2$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_2$__constructor__(), 0, this);
                }

                @Override
                public float getInterpolation(float f) {
                    return (float)InvokeDynamicSupport.bootstrap("getInterpolation", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback_2$getInterpolation(float ), 0, this, f);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$__constructor__(), 0, this);
        }

        public static ItemTouchUIUtil getDefaultUIUtil() {
            return InvokeDynamicSupport.bootstrapStatic("getDefaultUIUtil", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getDefaultUIUtil(), 0);
        }

        public static int convertToRelativeDirection(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("convertToRelativeDirection", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$convertToRelativeDirection(int int ), 0, (int)n, (int)n2);
        }

        public static int makeMovementFlags(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("makeMovementFlags", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$makeMovementFlags(int int ), 0, (int)n, (int)n2);
        }

        public static int makeFlag(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("makeFlag", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$makeFlag(int int ), 0, (int)n, (int)n2);
        }

        public int convertToAbsoluteDirection(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("convertToAbsoluteDirection", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$convertToAbsoluteDirection(int int ), 0, this, n, n2);
        }

        int getAbsoluteMovementFlags(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return (int)InvokeDynamicSupport.bootstrap("getAbsoluteMovementFlags", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getAbsoluteMovementFlags(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder);
        }

        boolean hasDragFlag(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasDragFlag", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$hasDragFlag(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder);
        }

        boolean hasSwipeFlag(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasSwipeFlag", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$hasSwipeFlag(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder);
        }

        public boolean canDropOver(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, RecyclerView.ViewHolder viewHolder2) {
            return (boolean)InvokeDynamicSupport.bootstrap("canDropOver", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$canDropOver(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder, viewHolder2);
        }

        public boolean isLongPressDragEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isLongPressDragEnabled", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$isLongPressDragEnabled(), 0, this);
        }

        public boolean isItemViewSwipeEnabled() {
            return (boolean)InvokeDynamicSupport.bootstrap("isItemViewSwipeEnabled", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$isItemViewSwipeEnabled(), 0, this);
        }

        public int getBoundingBoxMargin() {
            return (int)InvokeDynamicSupport.bootstrap("getBoundingBoxMargin", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getBoundingBoxMargin(), 0, this);
        }

        public float getSwipeThreshold(RecyclerView.ViewHolder viewHolder) {
            return (float)InvokeDynamicSupport.bootstrap("getSwipeThreshold", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getSwipeThreshold(com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, viewHolder);
        }

        public float getMoveThreshold(RecyclerView.ViewHolder viewHolder) {
            return (float)InvokeDynamicSupport.bootstrap("getMoveThreshold", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getMoveThreshold(com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, viewHolder);
        }

        public float getSwipeEscapeVelocity(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getSwipeEscapeVelocity", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getSwipeEscapeVelocity(float ), 0, this, f);
        }

        public float getSwipeVelocityThreshold(float f) {
            return (float)InvokeDynamicSupport.bootstrap("getSwipeVelocityThreshold", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getSwipeVelocityThreshold(float ), 0, this, f);
        }

        public RecyclerView.ViewHolder chooseDropTarget(RecyclerView.ViewHolder viewHolder, List<RecyclerView.ViewHolder> list, int n, int n2) {
            return InvokeDynamicSupport.bootstrap("chooseDropTarget", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$chooseDropTarget(com.android.internal.widget.RecyclerView$ViewHolder java.util.List<com.android.internal.widget.RecyclerView$ViewHolder> int int ), 0, this, viewHolder, list, n, n2);
        }

        public void onSelectedChanged(RecyclerView.ViewHolder viewHolder, int n) {
            InvokeDynamicSupport.bootstrap("onSelectedChanged", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onSelectedChanged(com.android.internal.widget.RecyclerView$ViewHolder int ), 0, this, viewHolder, n);
        }

        private int getMaxDragScroll(RecyclerView recyclerView) {
            return (int)InvokeDynamicSupport.bootstrap("getMaxDragScroll", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getMaxDragScroll(com.android.internal.widget.RecyclerView ), 0, this, recyclerView);
        }

        public void onMoved(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, int n, RecyclerView.ViewHolder viewHolder2, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("onMoved", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onMoved(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder int com.android.internal.widget.RecyclerView$ViewHolder int int int ), 0, this, recyclerView, viewHolder, n, viewHolder2, n2, n3, n4);
        }

        void onDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, List<RecoverAnimation> list, int n, float f, float f2) {
            InvokeDynamicSupport.bootstrap("onDraw", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onDraw(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder java.util.List<com.android.internal.widget.helper.ItemTouchHelper$RecoverAnimation> int float float ), 0, this, canvas, recyclerView, viewHolder, list, n, f, f2);
        }

        void onDrawOver(Canvas canvas, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, List<RecoverAnimation> list, int n, float f, float f2) {
            InvokeDynamicSupport.bootstrap("onDrawOver", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onDrawOver(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder java.util.List<com.android.internal.widget.helper.ItemTouchHelper$RecoverAnimation> int float float ), 0, this, canvas, recyclerView, viewHolder, list, n, f, f2);
        }

        public void clearView(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder) {
            InvokeDynamicSupport.bootstrap("clearView", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$clearView(com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder ), 0, this, recyclerView, viewHolder);
        }

        public void onChildDraw(Canvas canvas, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float f, float f2, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onChildDraw", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onChildDraw(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder float float int boolean ), 0, this, canvas, recyclerView, viewHolder, f, f2, n, bl);
        }

        public void onChildDrawOver(Canvas canvas, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder, float f, float f2, int n, boolean bl) {
            InvokeDynamicSupport.bootstrap("onChildDrawOver", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$onChildDrawOver(android.graphics.Canvas com.android.internal.widget.RecyclerView com.android.internal.widget.RecyclerView$ViewHolder float float int boolean ), 0, this, canvas, recyclerView, viewHolder, f, f2, n, bl);
        }

        public long getAnimationDuration(RecyclerView recyclerView, int n, float f, float f2) {
            return (long)InvokeDynamicSupport.bootstrap("getAnimationDuration", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$getAnimationDuration(com.android.internal.widget.RecyclerView int float float ), 0, this, recyclerView, n, f, f2);
        }

        public int interpolateOutOfBoundsScroll(RecyclerView recyclerView, int n, int n2, int n3, long l) {
            return (int)InvokeDynamicSupport.bootstrap("interpolateOutOfBoundsScroll", $$robo$$com_android_internal_widget_helper_ItemTouchHelper_Callback$interpolateOutOfBoundsScroll(com.android.internal.widget.RecyclerView int int int long ), 0, this, recyclerView, n, n2, n3, l);
        }

        static {
            RobolectricInternals.classInitializing(Callback.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface ViewDropHandler
    extends InstrumentedInterface {
        public void prepareForDrop(View var1, View var2, int var3, int var4);
    }
}

