/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.AbstractConscryptSocket;
import com.android.org.conscrypt.BufferAllocator;
import com.android.org.conscrypt.ClientSessionContext;
import com.android.org.conscrypt.ConscryptEngine;
import com.android.org.conscrypt.HandshakeListener;
import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLContextImpl;
import com.android.org.conscrypt.OpenSSLProvider;
import com.android.org.conscrypt.OpenSSLServerSocketFactoryImpl;
import com.android.org.conscrypt.OpenSSLSocketFactoryImpl;
import com.android.org.conscrypt.SSLClientSessionCache;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.SSLServerSessionCache;
import com.android.org.conscrypt.ServerSessionContext;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.PrivateKey;
import java.security.Provider;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public final class Conscrypt {
    private Conscrypt() {
    }

    public static boolean isAvailable() {
        try {
            Conscrypt.checkAvailability();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void checkAvailability() {
        try {
            NativeCrypto.checkAvailability();
        }
        catch (Throwable e) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(e);
        }
    }

    public static Provider newProvider() {
        return new OpenSSLProvider();
    }

    public static Provider newProvider(String providerName) {
        return new OpenSSLProvider(providerName);
    }

    public static SSLContextSpi newPreferredSSLContextSpi() {
        return OpenSSLContextImpl.getPreferred();
    }

    public static X509TrustManager getDefaultX509TrustManager() throws KeyManagementException {
        return SSLParametersImpl.getDefaultX509TrustManager();
    }

    private static String toProtocolString(byte[] bytes) {
        try {
            if (bytes == null) {
                return null;
            }
            return new String(bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static final class Engines {
        private Engines() {
        }

        public static boolean isConscrypt(SSLEngine engine) {
            return engine instanceof ConscryptEngine;
        }

        private static ConscryptEngine toConscrypt(SSLEngine engine) {
            if (!Engines.isConscrypt(engine)) {
                throw new IllegalArgumentException("Not a conscrypt engine: " + engine.getClass().getName());
            }
            return (ConscryptEngine)engine;
        }

        public static void setBufferAllocator(SSLEngine engine, BufferAllocator bufferAllocator) {
            Engines.toConscrypt(engine).setBufferAllocator(bufferAllocator);
        }

        public static void setHostname(SSLEngine engine, String hostname) {
            Engines.toConscrypt(engine).setHostname(hostname);
        }

        public static String getHostname(SSLEngine engine) {
            return Engines.toConscrypt(engine).getHostname();
        }

        public static int maxSealOverhead(SSLEngine engine) {
            return Engines.toConscrypt(engine).maxSealOverhead();
        }

        public static void setHandshakeListener(SSLEngine engine, HandshakeListener handshakeListener) {
            Engines.toConscrypt(engine).setHandshakeListener(handshakeListener);
        }

        public static void setChannelIdEnabled(SSLEngine engine, boolean enabled) {
            Engines.toConscrypt(engine).setChannelIdEnabled(enabled);
        }

        public static byte[] getChannelId(SSLEngine engine) throws SSLException {
            return Engines.toConscrypt(engine).getChannelId();
        }

        public static void setChannelIdPrivateKey(SSLEngine engine, PrivateKey privateKey) {
            Engines.toConscrypt(engine).setChannelIdPrivateKey(privateKey);
        }

        public static SSLEngineResult unwrap(SSLEngine engine, ByteBuffer[] srcs, ByteBuffer[] dsts) throws SSLException {
            return Engines.toConscrypt(engine).unwrap(srcs, dsts);
        }

        public static SSLEngineResult unwrap(SSLEngine engine, ByteBuffer[] srcs, int srcsOffset, int srcsLength, ByteBuffer[] dsts, int dstsOffset, int dstsLength) throws SSLException {
            return Engines.toConscrypt(engine).unwrap(srcs, srcsOffset, srcsLength, dsts, dstsOffset, dstsLength);
        }

        public static void setUseSessionTickets(SSLEngine engine, boolean useSessionTickets) {
            Engines.toConscrypt(engine).setUseSessionTickets(useSessionTickets);
        }

        public static void setAlpnProtocols(SSLEngine engine, String[] alpnProtocols) {
            Engines.toConscrypt(engine).setAlpnProtocols(alpnProtocols);
        }

        public static String getAlpnSelectedProtocol(SSLEngine engine) {
            return Conscrypt.toProtocolString(Engines.toConscrypt(engine).getAlpnSelectedProtocol());
        }
    }

    public static final class Sockets {
        private Sockets() {
        }

        public static boolean isConscrypt(SSLSocket socket) {
            return socket instanceof AbstractConscryptSocket;
        }

        private static AbstractConscryptSocket toConscrypt(SSLSocket socket) {
            if (!Sockets.isConscrypt(socket)) {
                throw new IllegalArgumentException("Not a conscrypt socket: " + socket.getClass().getName());
            }
            return (AbstractConscryptSocket)socket;
        }

        public static void setHostname(SSLSocket socket, String hostname) {
            Sockets.toConscrypt(socket).setHostname(hostname);
        }

        public static String getHostname(SSLSocket socket) {
            return Sockets.toConscrypt(socket).getHostname();
        }

        public static String getHostnameOrIP(SSLSocket socket) {
            return Sockets.toConscrypt(socket).getHostnameOrIP();
        }

        public static void setUseSessionTickets(SSLSocket socket, boolean useSessionTickets) {
            Sockets.toConscrypt(socket).setUseSessionTickets(useSessionTickets);
        }

        public static void setChannelIdEnabled(SSLSocket socket, boolean enabled) {
            Sockets.toConscrypt(socket).setChannelIdEnabled(enabled);
        }

        public static byte[] getChannelId(SSLSocket socket) throws SSLException {
            return Sockets.toConscrypt(socket).getChannelId();
        }

        public static void setChannelIdPrivateKey(SSLSocket socket, PrivateKey privateKey) {
            Sockets.toConscrypt(socket).setChannelIdPrivateKey(privateKey);
        }

        public static String getAlpnSelectedProtocol(SSLSocket socket) {
            return Conscrypt.toProtocolString(Sockets.toConscrypt(socket).getAlpnSelectedProtocol());
        }

        public static void setAlpnProtocols(SSLSocket socket, String[] alpnProtocols) {
            Sockets.toConscrypt(socket).setAlpnProtocols(alpnProtocols);
        }
    }

    public static final class ServerSocketFactories {
        private ServerSocketFactories() {
        }

        public static boolean isConscrypt(SSLServerSocketFactory factory) {
            return factory instanceof OpenSSLServerSocketFactoryImpl;
        }

        private static OpenSSLServerSocketFactoryImpl toConscrypt(SSLServerSocketFactory factory) {
            if (!ServerSocketFactories.isConscrypt(factory)) {
                throw new IllegalArgumentException("Not a conscrypt server socket factory: " + factory.getClass().getName());
            }
            return (OpenSSLServerSocketFactoryImpl)factory;
        }

        public static void setUseEngineSocketByDefault(boolean useEngineSocket) {
            OpenSSLServerSocketFactoryImpl.setUseEngineSocketByDefault(useEngineSocket);
        }

        public static void setUseEngineSocket(SSLServerSocketFactory factory, boolean useEngineSocket) {
            ServerSocketFactories.toConscrypt(factory).setUseEngineSocket(useEngineSocket);
        }
    }

    public static final class SocketFactories {
        private SocketFactories() {
        }

        public static boolean isConscrypt(SSLSocketFactory factory) {
            return factory instanceof OpenSSLSocketFactoryImpl;
        }

        private static OpenSSLSocketFactoryImpl toConscrypt(SSLSocketFactory factory) {
            if (!SocketFactories.isConscrypt(factory)) {
                throw new IllegalArgumentException("Not a conscrypt socket factory: " + factory.getClass().getName());
            }
            return (OpenSSLSocketFactoryImpl)factory;
        }

        public static void setUseEngineSocketByDefault(boolean useEngineSocket) {
            OpenSSLSocketFactoryImpl.setUseEngineSocketByDefault(useEngineSocket);
        }

        public static void setUseEngineSocket(SSLSocketFactory factory, boolean useEngineSocket) {
            SocketFactories.toConscrypt(factory).setUseEngineSocket(useEngineSocket);
        }
    }

    public static final class Contexts {
        private Contexts() {
        }

        public static boolean isConscrypt(SSLContext context) {
            return context.getProvider() instanceof OpenSSLProvider;
        }

        public static void setClientSessionCache(SSLContext context, SSLClientSessionCache cache) {
            SSLSessionContext clientContext = context.getClientSessionContext();
            if (!(clientContext instanceof ClientSessionContext)) {
                throw new IllegalArgumentException("Not a conscrypt client context: " + clientContext.getClass().getName());
            }
            ((ClientSessionContext)clientContext).setPersistentCache(cache);
        }

        public static void setServerSessionCache(SSLContext context, SSLServerSessionCache cache) {
            SSLSessionContext serverContext = context.getServerSessionContext();
            if (!(serverContext instanceof ServerSessionContext)) {
                throw new IllegalArgumentException("Not a conscrypt client context: " + serverContext.getClass().getName());
            }
            ((ServerSessionContext)serverContext).setPersistentCache(cache);
        }
    }

    public static final class Constants {
        private Constants() {
        }

        public static int maxEncryptedPacketLength() {
            return 16709;
        }
    }
}

