/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt.ct;

import com.android.org.conscrypt.InternalUtil;
import com.android.org.conscrypt.ct.CTLogInfo;
import com.android.org.conscrypt.ct.CTLogStore;
import com.android.org.conscrypt.ct.KnownLogs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;

public class CTLogStoreImpl
implements CTLogStore {
    private static final File defaultUserLogDir;
    private static final File defaultSystemLogDir;
    private static volatile CTLogInfo[] defaultFallbackLogs;
    private File userLogDir;
    private File systemLogDir;
    private CTLogInfo[] fallbackLogs;
    private HashMap<ByteBuffer, CTLogInfo> logCache = new HashMap();
    private Set<ByteBuffer> missingLogCache = Collections.synchronizedSet(new HashSet());
    private static final char[] HEX_DIGITS;

    public CTLogStoreImpl() {
        this(defaultUserLogDir, defaultSystemLogDir, CTLogStoreImpl.getDefaultFallbackLogs());
    }

    public CTLogStoreImpl(File userLogDir, File systemLogDir, CTLogInfo[] fallbackLogs) {
        this.userLogDir = userLogDir;
        this.systemLogDir = systemLogDir;
        this.fallbackLogs = fallbackLogs;
    }

    @Override
    public CTLogInfo getKnownLog(byte[] logId) {
        ByteBuffer buf = ByteBuffer.wrap(logId);
        CTLogInfo log = this.logCache.get(buf);
        if (log != null) {
            return log;
        }
        if (this.missingLogCache.contains(buf)) {
            return null;
        }
        log = this.findKnownLog(logId);
        if (log != null) {
            this.logCache.put(buf, log);
        } else {
            this.missingLogCache.add(buf);
        }
        return log;
    }

    private CTLogInfo findKnownLog(byte[] logId) {
        String filename = CTLogStoreImpl.hexEncode(logId);
        try {
            return CTLogStoreImpl.loadLog(new File(this.userLogDir, filename));
        }
        catch (InvalidLogFileException e) {
            return null;
        }
        catch (FileNotFoundException e) {
            try {
                return CTLogStoreImpl.loadLog(new File(this.systemLogDir, filename));
            }
            catch (InvalidLogFileException e2) {
                return null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!this.userLogDir.exists()) {
                    for (CTLogInfo log : this.fallbackLogs) {
                        if (!Arrays.equals(logId, log.getID())) continue;
                        return log;
                    }
                }
                return null;
            }
        }
    }

    public static CTLogInfo[] getDefaultFallbackLogs() {
        CTLogInfo[] result = defaultFallbackLogs;
        if (result == null) {
            result = CTLogStoreImpl.createDefaultFallbackLogs();
            defaultFallbackLogs = result;
        }
        return result;
    }

    private static CTLogInfo[] createDefaultFallbackLogs() {
        CTLogInfo[] logs = new CTLogInfo[8];
        for (int i = 0; i < 8; ++i) {
            try {
                PublicKey key = InternalUtil.logKeyToPublicKey(KnownLogs.LOG_KEYS[i]);
                logs[i] = new CTLogInfo(key, KnownLogs.LOG_DESCRIPTIONS[i], KnownLogs.LOG_URLS[i]);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        defaultFallbackLogs = logs;
        return logs;
    }

    public static CTLogInfo loadLog(File file) throws FileNotFoundException, InvalidLogFileException {
        return CTLogStoreImpl.loadLog(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CTLogInfo loadLog(InputStream input) throws InvalidLogFileException {
        PublicKey pubkey;
        Scanner scan = new Scanner(input, "UTF-8");
        scan.useDelimiter("\n");
        String description = null;
        String url = null;
        String key = null;
        try {
            if (!scan.hasNext()) {
                CTLogInfo cTLogInfo = null;
                return cTLogInfo;
            }
            while (scan.hasNext()) {
                String[] parts = scan.next().split(":", 2);
                if (parts.length < 2) continue;
                String name = parts[0];
                String value = parts[1];
                switch (name) {
                    case "description": {
                        description = value;
                        break;
                    }
                    case "url": {
                        url = value;
                        break;
                    }
                    case "key": {
                        key = value;
                    }
                }
            }
        }
        finally {
            scan.close();
        }
        if (description == null || url == null || key == null) {
            throw new InvalidLogFileException("Missing one of 'description', 'url' or 'key'");
        }
        try {
            pubkey = InternalUtil.readPublicKeyPem(new StringBufferInputStream("-----BEGIN PUBLIC KEY-----\n" + key + "\n" + "-----END PUBLIC KEY-----"));
        }
        catch (InvalidKeyException e) {
            throw new InvalidLogFileException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidLogFileException(e);
        }
        return new CTLogInfo(pubkey, description, url);
    }

    private static String hexEncode(byte[] data) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (byte b : data) {
            sb.append(HEX_DIGITS[b >> 4 & 0xF]);
            sb.append(HEX_DIGITS[b & 0xF]);
        }
        return sb.toString();
    }

    static {
        defaultFallbackLogs = null;
        String ANDROID_DATA = System.getenv("ANDROID_DATA");
        String ANDROID_ROOT = System.getenv("ANDROID_ROOT");
        defaultUserLogDir = new File(ANDROID_DATA + "/misc/keychain/trusted_ct_logs/current/");
        defaultSystemLogDir = new File(ANDROID_ROOT + "/etc/security/ct_known_logs/");
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }

    public static class InvalidLogFileException
    extends Exception {
        public InvalidLogFileException() {
        }

        public InvalidLogFileException(String message) {
            super(message);
        }

        public InvalidLogFileException(String message, Throwable cause) {
            super(message, cause);
        }

        public InvalidLogFileException(Throwable cause) {
            super(cause);
        }
    }
}

