/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.os.Binder;
import android.os.Environment;
import android.os.StatFs;
import android.os.SystemClock;
import android.os.storage.StorageManager;
import android.util.Log;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.util.DumpUtils;
import com.android.server.storage.DiskStatsLoggingService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import libcore.io.IoUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DiskStatsService
extends Binder {
    private static final String TAG = "DiskStatsService";
    private static final String DISKSTATS_DUMP_FILE = "/data/system/diskstats_cache.json";
    private final Context mContext;

    public DiskStatsService(Context context) {
        this.mContext = context;
        DiskStatsLoggingService.schedule(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        boolean blockBased;
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        byte[] junk = new byte[512];
        for (int i = 0; i < junk.length; ++i) {
            junk[i] = (byte)i;
        }
        File tmp = new File(Environment.getDataDirectory(), "system/perftest.tmp");
        FileOutputStream fos = null;
        IOException error = null;
        long before = SystemClock.uptimeMillis();
        try {
            fos = new FileOutputStream(tmp);
            fos.write(junk);
        }
        catch (IOException e) {
            error = e;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
        long after = SystemClock.uptimeMillis();
        if (tmp.exists()) {
            tmp.delete();
        }
        boolean protoFormat = this.hasOption(args, "--proto");
        ProtoOutputStream proto = null;
        if (protoFormat) {
            proto = new ProtoOutputStream(fd);
            pw = null;
            proto.write(0x10D00000001L, error != null);
            if (error != null) {
                proto.write(1159641169922L, error.toString());
            } else {
                proto.write(0x10300000003L, after - before);
            }
        } else if (error != null) {
            pw.print("Test-Error: ");
            pw.println(error.toString());
        } else {
            pw.print("Latency: ");
            pw.print(after - before);
            pw.println("ms [512B Data Write]");
        }
        this.reportFreeSpace(Environment.getDataDirectory(), "Data", pw, proto, 0);
        this.reportFreeSpace(Environment.getDownloadCacheDirectory(), "Cache", pw, proto, 1);
        this.reportFreeSpace(new File("/system"), "System", pw, proto, 2);
        boolean fileBased = StorageManager.isFileEncryptedNativeOnly();
        boolean bl = blockBased = fileBased ? false : StorageManager.isBlockEncrypted();
        if (protoFormat) {
            if (fileBased) {
                proto.write(0x11000000005L, 3);
            } else if (blockBased) {
                proto.write(0x11000000005L, 2);
            } else {
                proto.write(0x11000000005L, 1);
            }
        } else if (fileBased) {
            pw.println("File-based Encryption: true");
        }
        if (protoFormat) {
            this.reportCachedValuesProto(proto);
        } else {
            this.reportCachedValues(pw);
        }
        if (protoFormat) {
            proto.flush();
        }
    }

    private void reportFreeSpace(File path, String name, PrintWriter pw, ProtoOutputStream proto, int folderType) {
        try {
            StatFs statfs = new StatFs(path.getPath());
            long bsize = statfs.getBlockSize();
            long avail = statfs.getAvailableBlocks();
            long total = statfs.getBlockCount();
            if (bsize <= 0L || total <= 0L) {
                throw new IllegalArgumentException("Invalid stat: bsize=" + bsize + " avail=" + avail + " total=" + total);
            }
            if (proto != null) {
                long freeSpaceToken = proto.start(2272037699588L);
                proto.write(0x11000000001L, folderType);
                proto.write(1116691496962L, avail * bsize / 1024L);
                proto.write(1116691496963L, total * bsize / 1024L);
                proto.end(freeSpaceToken);
            } else {
                pw.print(name);
                pw.print("-Free: ");
                pw.print(avail * bsize / 1024L);
                pw.print("K / ");
                pw.print(total * bsize / 1024L);
                pw.print("K total = ");
                pw.print(avail * 100L / total);
                pw.println("% free");
            }
        }
        catch (IllegalArgumentException e) {
            if (proto == null) {
                pw.print(name);
                pw.print("-Error: ");
                pw.println(e.toString());
            }
            return;
        }
    }

    private boolean hasOption(String[] args, String arg) {
        for (String opt : args) {
            if (!arg.equals(opt)) continue;
            return true;
        }
        return false;
    }

    private void reportCachedValues(PrintWriter pw) {
        try {
            String jsonString = IoUtils.readFileAsString(DISKSTATS_DUMP_FILE);
            JSONObject json = new JSONObject(jsonString);
            pw.print("App Size: ");
            pw.println(json.getLong("appSize"));
            pw.print("App Data Size: ");
            pw.println(json.getLong("appDataSize"));
            pw.print("App Cache Size: ");
            pw.println(json.getLong("cacheSize"));
            pw.print("Photos Size: ");
            pw.println(json.getLong("photosSize"));
            pw.print("Videos Size: ");
            pw.println(json.getLong("videosSize"));
            pw.print("Audio Size: ");
            pw.println(json.getLong("audioSize"));
            pw.print("Downloads Size: ");
            pw.println(json.getLong("downloadsSize"));
            pw.print("System Size: ");
            pw.println(json.getLong("systemSize"));
            pw.print("Other Size: ");
            pw.println(json.getLong("otherSize"));
            pw.print("Package Names: ");
            pw.println(json.getJSONArray("packageNames"));
            pw.print("App Sizes: ");
            pw.println(json.getJSONArray("appSizes"));
            pw.print("App Data Sizes: ");
            pw.println(json.getJSONArray("appDataSizes"));
            pw.print("Cache Sizes: ");
            pw.println(json.getJSONArray("cacheSizes"));
        }
        catch (IOException | JSONException e) {
            Log.w(TAG, "exception reading diskstats cache file", e);
        }
    }

    private void reportCachedValuesProto(ProtoOutputStream proto) {
        try {
            String jsonString = IoUtils.readFileAsString(DISKSTATS_DUMP_FILE);
            JSONObject json = new JSONObject(jsonString);
            long cachedValuesToken = proto.start(0x11100000006L);
            proto.write(0x10400000001L, json.getLong("appSize"));
            proto.write(1116691496970L, json.getLong("appDataSize"));
            proto.write(1116691496962L, json.getLong("cacheSize"));
            proto.write(1116691496963L, json.getLong("photosSize"));
            proto.write(0x10400000004L, json.getLong("videosSize"));
            proto.write(1116691496965L, json.getLong("audioSize"));
            proto.write(1116691496966L, json.getLong("downloadsSize"));
            proto.write(1116691496967L, json.getLong("systemSize"));
            proto.write(1116691496968L, json.getLong("otherSize"));
            JSONArray packageNamesArray = json.getJSONArray("packageNames");
            JSONArray appSizesArray = json.getJSONArray("appSizes");
            JSONArray appDataSizesArray = json.getJSONArray("appDataSizes");
            JSONArray cacheSizesArray = json.getJSONArray("cacheSizes");
            int len = packageNamesArray.length();
            if (len == appSizesArray.length() && len == appDataSizesArray.length() && len == cacheSizesArray.length()) {
                for (int i = 0; i < len; ++i) {
                    long packageToken = proto.start(2272037699593L);
                    proto.write(0x10E00000001L, packageNamesArray.getString(i));
                    proto.write(1116691496962L, appSizesArray.getLong(i));
                    proto.write(0x10400000004L, appDataSizesArray.getLong(i));
                    proto.write(1116691496963L, cacheSizesArray.getLong(i));
                    proto.end(packageToken);
                }
            } else {
                Slog.wtf(TAG, "Sizes of packageNamesArray, appSizesArray, appDataSizesArray  and cacheSizesArray are not the same");
            }
            proto.end(cachedValuesToken);
        }
        catch (IOException | JSONException e) {
            Log.w(TAG, "exception reading diskstats cache file", e);
        }
    }
}

