/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.ApplicationErrorReport;
import android.app.Dialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.os.Binder;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.internal.app.ProcessMap;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.ProcessCpuTracker;
import com.android.server.RescueParty;
import com.android.server.Watchdog;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.AppErrorDialog;
import com.android.server.am.AppErrorResult;
import com.android.server.am.AppNotRespondingDialog;
import com.android.server.am.ProcessRecord;
import com.android.server.am.ServiceRecord;
import com.android.server.am.TaskRecord;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;

class AppErrors {
    private static final String TAG = "ActivityManager";
    private final ActivityManagerService mService;
    private final Context mContext;
    private ArraySet<String> mAppsNotReportingCrashes;
    private final ProcessMap<Long> mProcessCrashTimes = new ProcessMap();
    private final ProcessMap<Long> mProcessCrashTimesPersistent = new ProcessMap();
    private final ProcessMap<BadProcessInfo> mBadProcesses = new ProcessMap();

    AppErrors(Context context, ActivityManagerService service) {
        context.assertRuntimeOverlayThemable();
        this.mService = service;
        this.mContext = context;
    }

    boolean dumpLocked(FileDescriptor fd, PrintWriter pw, boolean needSep, String dumpPackage) {
        boolean printed;
        if (!this.mProcessCrashTimes.getMap().isEmpty()) {
            printed = false;
            long now = SystemClock.uptimeMillis();
            ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
            int processCount = pmap.size();
            for (int ip = 0; ip < processCount; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<Long> uids = pmap.valueAt(ip);
                int uidCount = uids.size();
                for (int i = 0; i < uidCount; ++i) {
                    int puid = uids.keyAt(i);
                    ProcessRecord r = this.mService.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Time since processes crashed:");
                        printed = true;
                    }
                    pw.print("    Process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": last crashed ");
                    TimeUtils.formatDuration(now - uids.valueAt(i), pw);
                    pw.println(" ago");
                }
            }
        }
        if (!this.mBadProcesses.getMap().isEmpty()) {
            printed = false;
            ArrayMap<String, SparseArray<BadProcessInfo>> pmap = this.mBadProcesses.getMap();
            int processCount = pmap.size();
            for (int ip = 0; ip < processCount; ++ip) {
                String pname = pmap.keyAt(ip);
                SparseArray<BadProcessInfo> uids = pmap.valueAt(ip);
                int uidCount = uids.size();
                for (int i = 0; i < uidCount; ++i) {
                    int puid = uids.keyAt(i);
                    ProcessRecord r = this.mService.mProcessNames.get(pname, puid);
                    if (dumpPackage != null && (r == null || !r.pkgList.containsKey(dumpPackage))) continue;
                    if (!printed) {
                        if (needSep) {
                            pw.println();
                        }
                        needSep = true;
                        pw.println("  Bad processes:");
                        printed = true;
                    }
                    BadProcessInfo info = uids.valueAt(i);
                    pw.print("    Bad process ");
                    pw.print(pname);
                    pw.print(" uid ");
                    pw.print(puid);
                    pw.print(": crashed at time ");
                    pw.println(info.time);
                    if (info.shortMsg != null) {
                        pw.print("      Short msg: ");
                        pw.println(info.shortMsg);
                    }
                    if (info.longMsg != null) {
                        pw.print("      Long msg: ");
                        pw.println(info.longMsg);
                    }
                    if (info.stack == null) continue;
                    pw.println("      Stack:");
                    int lastPos = 0;
                    for (int pos = 0; pos < info.stack.length(); ++pos) {
                        if (info.stack.charAt(pos) != '\n') continue;
                        pw.print("        ");
                        pw.write(info.stack, lastPos, pos - lastPos);
                        pw.println();
                        lastPos = pos + 1;
                    }
                    if (lastPos >= info.stack.length()) continue;
                    pw.print("        ");
                    pw.write(info.stack, lastPos, info.stack.length() - lastPos);
                    pw.println();
                }
            }
        }
        return needSep;
    }

    boolean isBadProcessLocked(ApplicationInfo info) {
        return this.mBadProcesses.get(info.processName, info.uid) != null;
    }

    void clearBadProcessLocked(ApplicationInfo info) {
        this.mBadProcesses.remove(info.processName, info.uid);
    }

    void resetProcessCrashTimeLocked(ApplicationInfo info) {
        this.mProcessCrashTimes.remove(info.processName, info.uid);
    }

    void resetProcessCrashTimeLocked(boolean resetEntireUser, int appId, int userId) {
        ArrayMap<String, SparseArray<Long>> pmap = this.mProcessCrashTimes.getMap();
        for (int ip = pmap.size() - 1; ip >= 0; --ip) {
            SparseArray<Long> ba = pmap.valueAt(ip);
            for (int i = ba.size() - 1; i >= 0; --i) {
                boolean remove = false;
                int entUid = ba.keyAt(i);
                if (!resetEntireUser) {
                    if (userId == -1) {
                        if (UserHandle.getAppId(entUid) == appId) {
                            remove = true;
                        }
                    } else if (entUid == UserHandle.getUid(userId, appId)) {
                        remove = true;
                    }
                } else if (UserHandle.getUserId(entUid) == userId) {
                    remove = true;
                }
                if (!remove) continue;
                ba.removeAt(i);
            }
            if (ba.size() != 0) continue;
            pmap.removeAt(ip);
        }
    }

    void loadAppsNotReportingCrashesFromConfigLocked(String appsNotReportingCrashesConfig) {
        String[] split;
        if (appsNotReportingCrashesConfig != null && (split = appsNotReportingCrashesConfig.split(",")).length > 0) {
            this.mAppsNotReportingCrashes = new ArraySet();
            Collections.addAll(this.mAppsNotReportingCrashes, split);
        }
    }

    void killAppAtUserRequestLocked(ProcessRecord app, Dialog fromDialog) {
        app.crashing = false;
        app.crashingReport = null;
        app.notResponding = false;
        app.notRespondingReport = null;
        if (app.anrDialog == fromDialog) {
            app.anrDialog = null;
        }
        if (app.waitDialog == fromDialog) {
            app.waitDialog = null;
        }
        if (app.pid > 0 && app.pid != ActivityManagerService.MY_PID) {
            this.handleAppCrashLocked(app, "user-terminated", null, null, null, null);
            app.kill("user request after error", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleAppCrashLocked(int uid, int initialPid, String packageName, int userId, String message) {
        ProcessRecord proc = null;
        SparseArray<ProcessRecord> sparseArray = this.mService.mPidsSelfLocked;
        synchronized (sparseArray) {
            for (int i = 0; i < this.mService.mPidsSelfLocked.size(); ++i) {
                ProcessRecord p = this.mService.mPidsSelfLocked.valueAt(i);
                if (uid >= 0 && p.uid != uid) continue;
                if (p.pid == initialPid) {
                    proc = p;
                    break;
                }
                if (!p.pkgList.containsKey(packageName) || userId >= 0 && p.userId != userId) continue;
                proc = p;
            }
        }
        if (proc == null) {
            Slog.w(TAG, "crashApplication: nothing for uid=" + uid + " initialPid=" + initialPid + " packageName=" + packageName + " userId=" + userId);
            return;
        }
        proc.scheduleCrash(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void crashApplication(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo) {
        int callingPid = Binder.getCallingPid();
        int callingUid = Binder.getCallingUid();
        long origId = Binder.clearCallingIdentity();
        try {
            this.crashApplicationInner(r, crashInfo, callingPid, callingUid);
        }
        finally {
            Binder.restoreCallingIdentity(origId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void crashApplicationInner(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo, int callingPid, int callingUid) {
        TaskRecord task;
        Object msg;
        long timeMillis = System.currentTimeMillis();
        String shortMsg = crashInfo.exceptionClassName;
        String longMsg = crashInfo.exceptionMessage;
        String stackTrace = crashInfo.stackTrace;
        if (shortMsg != null && longMsg != null) {
            longMsg = shortMsg + ": " + longMsg;
        } else if (shortMsg != null) {
            longMsg = shortMsg;
        }
        if (r != null && r.persistent) {
            RescueParty.notePersistentAppCrash(this.mContext, r.uid);
        }
        AppErrorResult result = new AppErrorResult();
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                if (this.handleAppCrashInActivityController(r, crashInfo, shortMsg, longMsg, stackTrace, timeMillis, callingPid, callingUid)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 21] lbl18 : MonitorExitStatement: MONITOREXIT : var11_10
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (r != null && r.instr != null) {
                    // MONITOREXIT @DISABLED, blocks:[0, 20, 5] lbl22 : MonitorExitStatement: MONITOREXIT : var11_10
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                if (r != null) {
                    this.mService.mBatteryStatsService.noteProcessCrash(r.processName, r.uid);
                }
                AppErrorDialog.Data data = new AppErrorDialog.Data();
                data.result = result;
                data.proc = r;
                if (r == null || !this.makeAppCrashingLocked(r, shortMsg, longMsg, stackTrace, data)) {
                    // MONITOREXIT @DISABLED, blocks:[0, 18, 5] lbl31 : MonitorExitStatement: MONITOREXIT : var11_10
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                msg = Message.obtain();
                msg.what = 1;
                task = data.task;
                msg.obj = data;
                this.mService.mUiHandler.sendMessage((Message)msg);
                // MONITOREXIT @DISABLED, blocks:[0, 5] lbl40 : MonitorExitStatement: MONITOREXIT : var11_10
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[5, 7] lbl44 : MonitorExitStatement: MONITOREXIT : var11_10
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        int res = result.get();
        Intent appErrorIntent = null;
        MetricsLogger.action(this.mContext, 316, res);
        if (res == 6 || res == 7) {
            res = 1;
        }
        msg = this.mService;
        synchronized (msg) {
            try {
                block30: {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (res == 5) {
                        this.stopReportingCrashesLocked(r);
                    }
                    if (res == 3) {
                        this.mService.removeProcessLocked(r, false, true, "crash");
                        if (task != null) {
                            try {
                                this.mService.startActivityFromRecents(task.taskId, ActivityOptions.makeBasic().toBundle());
                            }
                            catch (IllegalArgumentException e) {
                                Set<String> cats = task.intent.getCategories();
                                if (cats == null || !cats.contains("android.intent.category.LAUNCHER")) break block30;
                                this.mService.startActivityInPackage(task.mCallingUid, task.mCallingPackage, task.intent, null, null, null, 0, 0, ActivityOptions.makeBasic().toBundle(), task.userId, null, "AppErrors");
                            }
                        }
                    }
                }
                if (res == 1) {
                    long orig = Binder.clearCallingIdentity();
                    try {
                        this.mService.mStackSupervisor.handleAppCrashLocked(r);
                        if (!r.persistent) {
                            this.mService.removeProcessLocked(r, false, false, "crash");
                            this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                        }
                    }
                    finally {
                        Binder.restoreCallingIdentity(orig);
                    }
                }
                if (res == 2) {
                    appErrorIntent = this.createAppErrorIntentLocked(r, timeMillis, crashInfo);
                }
                if (r != null && !r.isolated && res != 3) {
                    this.mProcessCrashTimes.put(r.info.processName, r.uid, SystemClock.uptimeMillis());
                }
                // MONITOREXIT @DISABLED, blocks:[1, 6] lbl90 : MonitorExitStatement: MONITOREXIT : msg /* !! */ 
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[6, 10] lbl94 : MonitorExitStatement: MONITOREXIT : msg /* !! */ 
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        if (appErrorIntent != null) {
            try {
                this.mContext.startActivityAsUser(appErrorIntent, new UserHandle(r.userId));
            }
            catch (ActivityNotFoundException e) {
                Slog.w(TAG, "bug report receiver dissappeared", e);
            }
        }
    }

    private boolean handleAppCrashInActivityController(ProcessRecord r, ApplicationErrorReport.CrashInfo crashInfo, String shortMsg, String longMsg, String stackTrace, long timeMillis, int callingPid, int callingUid) {
        if (this.mService.mController == null) {
            return false;
        }
        try {
            int uid;
            String name = r != null ? r.processName : null;
            int pid = r != null ? r.pid : callingPid;
            int n = uid = r != null ? r.info.uid : callingUid;
            if (!this.mService.mController.appCrashed(name, pid, shortMsg, longMsg, timeMillis, crashInfo.stackTrace)) {
                if ("1".equals(SystemProperties.get("ro.debuggable", "0")) && "Native crash".equals(crashInfo.exceptionClassName)) {
                    Slog.w(TAG, "Skip killing native crashed app " + name + "(" + pid + ") during testing");
                } else {
                    Slog.w(TAG, "Force-killing crashed app " + name + " at watcher's request");
                    if (r != null) {
                        if (!this.makeAppCrashingLocked(r, shortMsg, longMsg, stackTrace, null)) {
                            r.kill("crash", true);
                        }
                    } else {
                        Process.killProcess(pid);
                        ActivityManagerService.killProcessGroup(uid, pid);
                    }
                }
                return true;
            }
        }
        catch (RemoteException e) {
            this.mService.mController = null;
            Watchdog.getInstance().setActivityController(null);
        }
        return false;
    }

    private boolean makeAppCrashingLocked(ProcessRecord app, String shortMsg, String longMsg, String stackTrace, AppErrorDialog.Data data) {
        app.crashing = true;
        app.crashingReport = this.generateProcessError(app, 1, null, shortMsg, longMsg, stackTrace);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
        return this.handleAppCrashLocked(app, "force-crash", shortMsg, longMsg, stackTrace, data);
    }

    void startAppProblemLocked(ProcessRecord app) {
        app.errorReportReceiver = null;
        for (int userId : this.mService.mUserController.getCurrentProfileIdsLocked()) {
            if (app.userId != userId) continue;
            app.errorReportReceiver = ApplicationErrorReport.getErrorReportReceiver(this.mContext, app.info.packageName, app.info.flags);
        }
        this.mService.skipCurrentReceiverLocked(app);
    }

    private ActivityManager.ProcessErrorStateInfo generateProcessError(ProcessRecord app, int condition, String activity, String shortMsg, String longMsg, String stackTrace) {
        ActivityManager.ProcessErrorStateInfo report = new ActivityManager.ProcessErrorStateInfo();
        report.condition = condition;
        report.processName = app.processName;
        report.pid = app.pid;
        report.uid = app.info.uid;
        report.tag = activity;
        report.shortMsg = shortMsg;
        report.longMsg = longMsg;
        report.stackTrace = stackTrace;
        return report;
    }

    Intent createAppErrorIntentLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        ApplicationErrorReport report = this.createAppErrorReportLocked(r, timeMillis, crashInfo);
        if (report == null) {
            return null;
        }
        Intent result = new Intent("android.intent.action.APP_ERROR");
        result.setComponent(r.errorReportReceiver);
        result.putExtra("android.intent.extra.BUG_REPORT", report);
        result.addFlags(0x10000000);
        return result;
    }

    private ApplicationErrorReport createAppErrorReportLocked(ProcessRecord r, long timeMillis, ApplicationErrorReport.CrashInfo crashInfo) {
        if (r.errorReportReceiver == null) {
            return null;
        }
        if (!(r.crashing || r.notResponding || r.forceCrashReport)) {
            return null;
        }
        ApplicationErrorReport report = new ApplicationErrorReport();
        report.packageName = r.info.packageName;
        report.installerPackageName = r.errorReportReceiver.getPackageName();
        report.processName = r.processName;
        report.time = timeMillis;
        boolean bl = report.systemApp = (r.info.flags & 1) != 0;
        if (r.crashing || r.forceCrashReport) {
            report.type = 1;
            report.crashInfo = crashInfo;
        } else if (r.notResponding) {
            report.type = 2;
            report.anrInfo = new ApplicationErrorReport.AnrInfo();
            report.anrInfo.activity = r.notRespondingReport.tag;
            report.anrInfo.cause = r.notRespondingReport.shortMsg;
            report.anrInfo.info = r.notRespondingReport.longMsg;
        }
        return report;
    }

    boolean handleAppCrashLocked(ProcessRecord app, String reason, String shortMsg, String longMsg, String stackTrace, AppErrorDialog.Data data) {
        Long crashTimePersistent;
        Long crashTime;
        long now = SystemClock.uptimeMillis();
        boolean showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
        boolean procIsBoundForeground = app.curProcState == 3;
        boolean tryAgain = false;
        if (!app.isolated) {
            crashTime = this.mProcessCrashTimes.get(app.info.processName, app.uid);
            crashTimePersistent = this.mProcessCrashTimesPersistent.get(app.info.processName, app.uid);
        } else {
            crashTimePersistent = null;
            crashTime = null;
        }
        for (int i = app.services.size() - 1; i >= 0; --i) {
            ServiceRecord sr = app.services.valueAt(i);
            sr.crashCount = now > sr.restartTime + 60000L ? 1 : ++sr.crashCount;
            if ((long)sr.crashCount >= this.mService.mConstants.BOUND_SERVICE_MAX_CRASH_RETRY || !sr.isForeground && !procIsBoundForeground) continue;
            tryAgain = true;
        }
        if (crashTime != null && now < crashTime + 60000L) {
            Slog.w(TAG, "Process " + app.info.processName + " has crashed too many times: killing!");
            EventLog.writeEvent(30032, app.userId, app.info.processName, app.uid);
            this.mService.mStackSupervisor.handleAppCrashLocked(app);
            if (!app.persistent) {
                EventLog.writeEvent(30015, app.userId, app.uid, app.info.processName);
                if (!app.isolated) {
                    this.mBadProcesses.put(app.info.processName, app.uid, new BadProcessInfo(now, shortMsg, longMsg, stackTrace));
                    this.mProcessCrashTimes.remove(app.info.processName, app.uid);
                }
                app.bad = true;
                app.removed = true;
                this.mService.removeProcessLocked(app, false, tryAgain, "crash");
                this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
                if (!showBackground) {
                    return false;
                }
            }
            this.mService.mStackSupervisor.resumeFocusedStackTopActivityLocked();
        } else {
            TaskRecord affectedTask = this.mService.mStackSupervisor.finishTopRunningActivityLocked(app, reason);
            if (data != null) {
                data.task = affectedTask;
            }
            if (data != null && crashTimePersistent != null && now < crashTimePersistent + 60000L) {
                data.repeating = true;
            }
        }
        if (data != null && tryAgain) {
            data.isRestartableForService = true;
        }
        ArrayList<ActivityRecord> activities = app.activities;
        if (app == this.mService.mHomeProcess && activities.size() > 0 && (this.mService.mHomeProcess.info.flags & 1) == 0) {
            for (int activityNdx = activities.size() - 1; activityNdx >= 0; --activityNdx) {
                ActivityRecord r = activities.get(activityNdx);
                if (!r.isHomeActivity()) continue;
                Log.i(TAG, "Clearing package preferred activities from " + r.packageName);
                try {
                    ActivityThread.getPackageManager().clearPackagePreferredActivities(r.packageName);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
        if (!app.isolated) {
            this.mProcessCrashTimes.put(app.info.processName, app.uid, now);
            this.mProcessCrashTimesPersistent.put(app.info.processName, app.uid, now);
        }
        if (app.crashHandler != null) {
            this.mService.mHandler.post(app.crashHandler);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleShowAppErrorUi(Message msg) {
        AppErrorDialog.Data data = (AppErrorDialog.Data)msg.obj;
        boolean showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                boolean crashSilenced;
                ActivityManagerService.boostPriorityForLockedSection();
                ProcessRecord proc = data.proc;
                AppErrorResult res = data.result;
                if (proc != null && proc.crashDialog != null) {
                    Slog.e(TAG, "App already has crash dialog: " + proc);
                    if (res != null) {
                        res.set(AppErrorDialog.ALREADY_SHOWING);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 11] lbl14 : MonitorExitStatement: MONITOREXIT : var4_4
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                boolean isBackground = UserHandle.getAppId(proc.uid) >= 10000 && proc.pid != ActivityManagerService.MY_PID;
                for (int userId : this.mService.mUserController.getCurrentProfileIdsLocked()) {
                    isBackground &= proc.userId != userId;
                }
                if (isBackground && !showBackground) {
                    Slog.w(TAG, "Skipping crash dialog of " + proc + ": background");
                    if (res != null) {
                        res.set(AppErrorDialog.BACKGROUND_USER);
                    }
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 9] lbl29 : MonitorExitStatement: MONITOREXIT : var4_4
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                boolean bl = crashSilenced = this.mAppsNotReportingCrashes != null && this.mAppsNotReportingCrashes.contains(proc.info.packageName);
                if ((this.mService.canShowErrorDialogs() || showBackground) && !crashSilenced) {
                    proc.crashDialog = new AppErrorDialog(this.mContext, this.mService, data);
                } else if (res != null) {
                    res.set(AppErrorDialog.CANT_SHOW);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl38 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl42 : MonitorExitStatement: MONITOREXIT : var4_4
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        if (data.proc.crashDialog != null) {
            Slog.i(TAG, "Showing crash dialog for package " + data.proc.info.packageName + " u" + data.proc.userId);
            data.proc.crashDialog.show();
        }
    }

    void stopReportingCrashesLocked(ProcessRecord proc) {
        if (this.mAppsNotReportingCrashes == null) {
            this.mAppsNotReportingCrashes = new ArraySet();
        }
        this.mAppsNotReportingCrashes.add(proc.info.packageName);
    }

    static boolean isInterestingForBackgroundTraces(ProcessRecord app) {
        if (app.pid == ActivityManagerService.MY_PID) {
            return true;
        }
        return app.isInterestingToUserLocked() || app.info != null && "com.android.systemui".equals(app.info.packageName) || app.hasTopUi || app.hasOverlayUi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void appNotResponding(ProcessRecord app, ActivityRecord activity, ActivityRecord parent, boolean aboveSystem, String annotation) {
        StringBuilder info;
        boolean isSilentANR;
        block45: {
            ArrayList<Integer> firstPids = new ArrayList<Integer>(5);
            SparseArray<Boolean> lastPids = new SparseArray<Boolean>(20);
            if (this.mService.mController != null) {
                try {
                    int res = this.mService.mController.appEarlyNotResponding(app.processName, app.pid, annotation);
                    if (res < 0 && app.pid != ActivityManagerService.MY_PID) {
                        app.kill("anr", true);
                    }
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
            long anrTime = SystemClock.uptimeMillis();
            this.mService.updateCpuStatsNow();
            boolean showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
            ActivityManagerService activityManagerService = this.mService;
            synchronized (activityManagerService) {
                try {
                    ActivityManagerService.boostPriorityForLockedSection();
                    if (this.mService.mShuttingDown) {
                        Slog.i(TAG, "During shutdown skipping ANR: " + app + " " + annotation);
                        // MONITOREXIT @DISABLED, blocks:[1, 36, 6] lbl23 : MonitorExitStatement: MONITOREXIT : var12_12
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    if (app.notResponding) {
                        Slog.i(TAG, "Skipping duplicate ANR: " + app + " " + annotation);
                        // MONITOREXIT @DISABLED, blocks:[1, 35, 6] lbl29 : MonitorExitStatement: MONITOREXIT : var12_12
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    if (app.crashing) {
                        Slog.i(TAG, "Crashing app skipping ANR: " + app + " " + annotation);
                        // MONITOREXIT @DISABLED, blocks:[1, 34, 6] lbl35 : MonitorExitStatement: MONITOREXIT : var12_12
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    if (app.killedByAm) {
                        Slog.i(TAG, "App already killed by AM skipping ANR: " + app + " " + annotation);
                        // MONITOREXIT @DISABLED, blocks:[1, 33, 6] lbl41 : MonitorExitStatement: MONITOREXIT : var12_12
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    if (app.killed) {
                        Slog.i(TAG, "Skipping died app ANR: " + app + " " + annotation);
                        // MONITOREXIT @DISABLED, blocks:[32, 1, 6] lbl47 : MonitorExitStatement: MONITOREXIT : var12_12
                        ActivityManagerService.resetPriorityAfterLockedSection();
                        return;
                    }
                    app.notResponding = true;
                    EventLog.writeEvent(30008, app.userId, app.pid, app.processName, app.info.flags, annotation);
                    firstPids.add(app.pid);
                    boolean bl = isSilentANR = !showBackground && !AppErrors.isInterestingForBackgroundTraces(app);
                    if (!isSilentANR) {
                        int parentPid = app.pid;
                        if (parent != null && parent.app != null && parent.app.pid > 0) {
                            parentPid = parent.app.pid;
                        }
                        if (parentPid != app.pid) {
                            firstPids.add(parentPid);
                        }
                        if (ActivityManagerService.MY_PID != app.pid && ActivityManagerService.MY_PID != parentPid) {
                            firstPids.add(ActivityManagerService.MY_PID);
                        }
                        for (int i = this.mService.mLruProcesses.size() - 1; i >= 0; --i) {
                            int pid;
                            ProcessRecord r = this.mService.mLruProcesses.get(i);
                            if (r == null || r.thread == null || (pid = r.pid) <= 0 || pid == app.pid || pid == parentPid || pid == ActivityManagerService.MY_PID) continue;
                            if (r.persistent) {
                                firstPids.add(pid);
                                continue;
                            }
                            if (r.treatLikeActivity) {
                                firstPids.add(pid);
                                continue;
                            }
                            lastPids.put(pid, Boolean.TRUE);
                        }
                    }
                    // MONITOREXIT @DISABLED, blocks:[1, 6] lbl79 : MonitorExitStatement: MONITOREXIT : var12_12
                    ActivityManagerService.resetPriorityAfterLockedSection();
                }
                catch (Throwable throwable) {
                    // MONITOREXIT @DISABLED, blocks:[6, 11] lbl83 : MonitorExitStatement: MONITOREXIT : var12_12
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    throw throwable;
                }
            }
            info = new StringBuilder();
            info.setLength(0);
            info.append("ANR in ").append(app.processName);
            if (activity != null && activity.shortComponentName != null) {
                info.append(" (").append(activity.shortComponentName).append(")");
            }
            info.append("\n");
            info.append("PID: ").append(app.pid).append("\n");
            if (annotation != null) {
                info.append("Reason: ").append(annotation).append("\n");
            }
            if (parent != null && parent != activity) {
                info.append("Parent: ").append(parent.shortComponentName).append("\n");
            }
            ProcessCpuTracker processCpuTracker = new ProcessCpuTracker(true);
            String[] nativeProcs = null;
            if (isSilentANR) {
                for (int i = 0; i < Watchdog.NATIVE_STACKS_OF_INTEREST.length; ++i) {
                    if (!Watchdog.NATIVE_STACKS_OF_INTEREST[i].equals(app.processName)) continue;
                    nativeProcs = new String[]{app.processName};
                    break;
                }
            } else {
                nativeProcs = Watchdog.NATIVE_STACKS_OF_INTEREST;
            }
            int[] pids = nativeProcs == null ? null : Process.getPidsForCommands(nativeProcs);
            ArrayList<Integer> nativePids = null;
            if (pids != null) {
                nativePids = new ArrayList<Integer>(pids.length);
                for (int i : pids) {
                    nativePids.add(i);
                }
            }
            File tracesFile = ActivityManagerService.dumpStackTraces(true, firstPids, isSilentANR ? null : processCpuTracker, isSilentANR ? null : lastPids, nativePids);
            String cpuInfo = null;
            this.mService.updateCpuStatsNow();
            ProcessCpuTracker processCpuTracker2 = this.mService.mProcessCpuTracker;
            synchronized (processCpuTracker2) {
                cpuInfo = this.mService.mProcessCpuTracker.printCurrentState(anrTime);
            }
            info.append(processCpuTracker.printCurrentLoad());
            info.append(cpuInfo);
            info.append(processCpuTracker.printCurrentState(anrTime));
            Slog.e(TAG, info.toString());
            if (tracesFile == null) {
                Process.sendSignal(app.pid, 3);
            }
            this.mService.addErrorToDropBox("anr", app, app.processName, activity, parent, annotation, cpuInfo, tracesFile, null);
            if (this.mService.mController != null) {
                try {
                    int res = this.mService.mController.appNotResponding(app.processName, app.pid, info.toString());
                    if (res == 0) break block45;
                    if (res < 0 && app.pid != ActivityManagerService.MY_PID) {
                        app.kill("anr", true);
                    } else {
                        ActivityManagerService i = this.mService;
                        synchronized (i) {
                            try {
                                ActivityManagerService.boostPriorityForLockedSection();
                                this.mService.mServices.scheduleServiceTimeoutLocked(app);
                                // MONITOREXIT @DISABLED, blocks:[3, 4, 39, 9, 41] lbl158 : MonitorExitStatement: MONITOREXIT : i
                                ActivityManagerService.resetPriorityAfterLockedSection();
                            }
                            catch (Throwable throwable) {
                                // MONITOREXIT @DISABLED, blocks:[3, 39, 9, 41, 13] lbl162 : MonitorExitStatement: MONITOREXIT : i
                                ActivityManagerService.resetPriorityAfterLockedSection();
                                throw throwable;
                            }
                        }
                    }
                    return;
                }
                catch (RemoteException e) {
                    this.mService.mController = null;
                    Watchdog.getInstance().setActivityController(null);
                }
            }
        }
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                ActivityManagerService.boostPriorityForLockedSection();
                this.mService.mBatteryStatsService.noteProcessAnr(app.processName, app.uid);
                if (isSilentANR) {
                    app.kill("bg anr", true);
                    // MONITOREXIT @DISABLED, blocks:[20, 5, 8] lbl176 : MonitorExitStatement: MONITOREXIT : var20_31
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                this.makeAppNotRespondingLocked(app, activity != null ? activity.shortComponentName : null, annotation != null ? "ANR " + annotation : "ANR", info.toString());
                Message msg = Message.obtain();
                HashMap<String, Object> map = new HashMap<String, Object>();
                msg.what = 2;
                msg.obj = map;
                msg.arg1 = aboveSystem ? 1 : 0;
                map.put("app", app);
                if (activity != null) {
                    map.put("activity", activity);
                }
                this.mService.mUiHandler.sendMessage(msg);
                // MONITOREXIT @DISABLED, blocks:[5, 8] lbl192 : MonitorExitStatement: MONITOREXIT : var20_31
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[8, 15] lbl196 : MonitorExitStatement: MONITOREXIT : var20_31
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
    }

    private void makeAppNotRespondingLocked(ProcessRecord app, String activity, String shortMsg, String longMsg) {
        app.notResponding = true;
        app.notRespondingReport = this.generateProcessError(app, 2, activity, shortMsg, longMsg, null);
        this.startAppProblemLocked(app);
        app.stopFreezingAllLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleShowAnrUi(Message msg) {
        AppNotRespondingDialog d = null;
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                boolean showBackground;
                ActivityManagerService.boostPriorityForLockedSection();
                HashMap data = (HashMap)msg.obj;
                ProcessRecord proc = (ProcessRecord)data.get("app");
                if (proc != null && proc.anrDialog != null) {
                    Slog.e(TAG, "App already has anr dialog: " + proc);
                    MetricsLogger.action(this.mContext, 317, -2);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 7] lbl12 : MonitorExitStatement: MONITOREXIT : var3_3
                    ActivityManagerService.resetPriorityAfterLockedSection();
                    return;
                }
                Intent intent = new Intent("android.intent.action.ANR");
                if (!this.mService.mProcessesReady) {
                    intent.addFlags(0x50000000);
                }
                this.mService.broadcastIntentLocked(null, null, intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, 0);
                boolean bl = showBackground = Settings.Secure.getInt(this.mContext.getContentResolver(), "anr_show_background", 0) != 0;
                if (this.mService.canShowErrorDialogs() || showBackground) {
                    d = new AppNotRespondingDialog(this.mService, this.mContext, proc, (ActivityRecord)data.get("activity"), msg.arg1 != 0);
                    proc.anrDialog = d;
                } else {
                    MetricsLogger.action(this.mContext, 317, -1);
                    this.mService.killAppAtUsersRequest(proc, null);
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl28 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
            }
            catch (Throwable throwable) {
                // MONITOREXIT @DISABLED, blocks:[1, 2] lbl32 : MonitorExitStatement: MONITOREXIT : var3_3
                ActivityManagerService.resetPriorityAfterLockedSection();
                throw throwable;
            }
        }
        if (d != null) {
            d.show();
        }
    }

    static final class BadProcessInfo {
        final long time;
        final String shortMsg;
        final String longMsg;
        final String stack;

        BadProcessInfo(long time, String shortMsg, String longMsg, String stack) {
            this.time = time;
            this.shortMsg = shortMsg;
            this.longMsg = longMsg;
            this.stack = stack;
        }
    }
}

