/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.Dialog;
import android.app.IApplicationThread;
import android.content.ComponentName;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.DebugUtils;
import android.util.EventLog;
import android.util.Slog;
import android.util.TimeUtils;
import com.android.internal.app.procstats.ProcessState;
import com.android.internal.app.procstats.ProcessStats;
import com.android.internal.os.BatteryStatsImpl;
import com.android.server.am.ActiveInstrumentation;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.ContentProviderConnection;
import com.android.server.am.ContentProviderRecord;
import com.android.server.am.ProcessStatsService;
import com.android.server.am.ReceiverList;
import com.android.server.am.ServiceRecord;
import com.android.server.am.UidRecord;
import java.io.PrintWriter;
import java.util.ArrayList;

final class ProcessRecord {
    private static final String TAG = "ActivityManager";
    private final BatteryStatsImpl mBatteryStats;
    final ApplicationInfo info;
    final boolean isolated;
    final int uid;
    final int userId;
    final String processName;
    final ArrayMap<String, ProcessStats.ProcessStateHolder> pkgList = new ArrayMap();
    UidRecord uidRecord;
    ArraySet<String> pkgDeps;
    IApplicationThread thread;
    ProcessState baseProcessTracker;
    BatteryStatsImpl.Uid.Proc curProcBatteryStats;
    int pid;
    String procStatFile;
    int[] gids;
    String requiredAbi;
    String instructionSet;
    boolean starting;
    long lastActivityTime;
    long lastPssTime;
    long nextPssTime;
    long lastStateTime;
    long initialIdlePss;
    long lastPss;
    long lastSwapPss;
    long lastCachedPss;
    long lastCachedSwapPss;
    int maxAdj;
    int curRawAdj;
    int setRawAdj;
    int curAdj;
    int setAdj;
    int verifiedAdj;
    int curSchedGroup;
    int setSchedGroup;
    int vrThreadTid;
    int trimMemoryLevel;
    int curProcState = 18;
    int repProcState = 18;
    int setProcState = 18;
    int pssProcState = 18;
    int savedPriority;
    int renderThreadTid;
    boolean serviceb;
    boolean serviceHighRam;
    boolean notCachedSinceIdle;
    boolean hasClientActivities;
    boolean hasStartedServices;
    boolean foregroundServices;
    boolean foregroundActivities;
    boolean repForegroundActivities;
    boolean systemNoUi;
    boolean hasShownUi;
    boolean hasTopUi;
    boolean hasOverlayUi;
    boolean pendingUiClean;
    boolean hasAboveClient;
    boolean treatLikeActivity;
    boolean bad;
    boolean killedByAm;
    boolean killed;
    boolean procStateChanged;
    boolean reportedInteraction;
    boolean unlocked;
    long interactionEventTime;
    long fgInteractionTime;
    String waitingToKill;
    Object forcingToImportant;
    int adjSeq;
    int lruSeq;
    CompatibilityInfo compat;
    IBinder.DeathRecipient deathRecipient;
    ActiveInstrumentation instr;
    boolean usingWrapper;
    final ArraySet<BroadcastRecord> curReceivers = new ArraySet();
    long whenUnimportant;
    long lastCpuTime;
    long curCpuTime;
    long lastRequestedGc;
    long lastLowMemory;
    long lastProviderTime;
    boolean reportLowMemory;
    boolean empty;
    boolean cached;
    String adjType;
    int adjTypeCode;
    Object adjSource;
    int adjSourceProcState;
    Object adjTarget;
    Runnable crashHandler;
    final ArrayList<ActivityRecord> activities = new ArrayList();
    final ArraySet<ServiceRecord> services = new ArraySet();
    final ArraySet<ServiceRecord> executingServices = new ArraySet();
    final ArraySet<ConnectionRecord> connections = new ArraySet();
    final ArraySet<ReceiverList> receivers = new ArraySet();
    final ArrayMap<String, ContentProviderRecord> pubProviders = new ArrayMap();
    final ArrayList<ContentProviderConnection> conProviders = new ArrayList();
    boolean execServicesFg;
    boolean persistent;
    boolean crashing;
    Dialog crashDialog;
    boolean forceCrashReport;
    boolean notResponding;
    Dialog anrDialog;
    boolean removed;
    boolean debugging;
    boolean waitedForDebugger;
    Dialog waitDialog;
    String shortStringName;
    String stringName;
    ActivityManager.ProcessErrorStateInfo crashingReport;
    ActivityManager.ProcessErrorStateInfo notRespondingReport;
    ComponentName errorReportReceiver;
    public boolean inFullBackup;
    boolean whitelistManager;

    void dump(PrintWriter pw, String prefix) {
        int i;
        long nowUptime = SystemClock.uptimeMillis();
        pw.print(prefix);
        pw.print("user #");
        pw.print(this.userId);
        pw.print(" uid=");
        pw.print(this.info.uid);
        if (this.uid != this.info.uid) {
            pw.print(" ISOLATED uid=");
            pw.print(this.uid);
        }
        pw.print(" gids={");
        if (this.gids != null) {
            for (int gi = 0; gi < this.gids.length; ++gi) {
                if (gi != 0) {
                    pw.print(", ");
                }
                pw.print(this.gids[gi]);
            }
        }
        pw.println("}");
        pw.print(prefix);
        pw.print("requiredAbi=");
        pw.print(this.requiredAbi);
        pw.print(" instructionSet=");
        pw.println(this.instructionSet);
        if (this.info.className != null) {
            pw.print(prefix);
            pw.print("class=");
            pw.println(this.info.className);
        }
        if (this.info.manageSpaceActivityName != null) {
            pw.print(prefix);
            pw.print("manageSpaceActivityName=");
            pw.println(this.info.manageSpaceActivityName);
        }
        pw.print(prefix);
        pw.print("dir=");
        pw.print(this.info.sourceDir);
        pw.print(" publicDir=");
        pw.print(this.info.publicSourceDir);
        pw.print(" data=");
        pw.println(this.info.dataDir);
        pw.print(prefix);
        pw.print("packageList={");
        for (i = 0; i < this.pkgList.size(); ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.pkgList.keyAt(i));
        }
        pw.println("}");
        if (this.pkgDeps != null) {
            pw.print(prefix);
            pw.print("packageDependencies={");
            for (i = 0; i < this.pkgDeps.size(); ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                pw.print(this.pkgDeps.valueAt(i));
            }
            pw.println("}");
        }
        pw.print(prefix);
        pw.print("compat=");
        pw.println(this.compat);
        if (this.instr != null) {
            pw.print(prefix);
            pw.print("instr=");
            pw.println(this.instr);
        }
        pw.print(prefix);
        pw.print("thread=");
        pw.println(this.thread);
        pw.print(prefix);
        pw.print("pid=");
        pw.print(this.pid);
        pw.print(" starting=");
        pw.println(this.starting);
        pw.print(prefix);
        pw.print("lastActivityTime=");
        TimeUtils.formatDuration(this.lastActivityTime, nowUptime, pw);
        pw.print(" lastPssTime=");
        TimeUtils.formatDuration(this.lastPssTime, nowUptime, pw);
        pw.print(" nextPssTime=");
        TimeUtils.formatDuration(this.nextPssTime, nowUptime, pw);
        pw.println();
        pw.print(prefix);
        pw.print("adjSeq=");
        pw.print(this.adjSeq);
        pw.print(" lruSeq=");
        pw.print(this.lruSeq);
        pw.print(" lastPss=");
        DebugUtils.printSizeValue(pw, this.lastPss * 1024L);
        pw.print(" lastSwapPss=");
        DebugUtils.printSizeValue(pw, this.lastSwapPss * 1024L);
        pw.print(" lastCachedPss=");
        DebugUtils.printSizeValue(pw, this.lastCachedPss * 1024L);
        pw.print(" lastCachedSwapPss=");
        DebugUtils.printSizeValue(pw, this.lastCachedSwapPss * 1024L);
        pw.println();
        pw.print(prefix);
        pw.print("cached=");
        pw.print(this.cached);
        pw.print(" empty=");
        pw.println(this.empty);
        if (this.serviceb) {
            pw.print(prefix);
            pw.print("serviceb=");
            pw.print(this.serviceb);
            pw.print(" serviceHighRam=");
            pw.println(this.serviceHighRam);
        }
        if (this.notCachedSinceIdle) {
            pw.print(prefix);
            pw.print("notCachedSinceIdle=");
            pw.print(this.notCachedSinceIdle);
            pw.print(" initialIdlePss=");
            pw.println(this.initialIdlePss);
        }
        pw.print(prefix);
        pw.print("oom: max=");
        pw.print(this.maxAdj);
        pw.print(" curRaw=");
        pw.print(this.curRawAdj);
        pw.print(" setRaw=");
        pw.print(this.setRawAdj);
        pw.print(" cur=");
        pw.print(this.curAdj);
        pw.print(" set=");
        pw.println(this.setAdj);
        pw.print(prefix);
        pw.print("curSchedGroup=");
        pw.print(this.curSchedGroup);
        pw.print(" setSchedGroup=");
        pw.print(this.setSchedGroup);
        pw.print(" systemNoUi=");
        pw.print(this.systemNoUi);
        pw.print(" trimMemoryLevel=");
        pw.println(this.trimMemoryLevel);
        if (this.vrThreadTid != 0) {
            pw.print(prefix);
            pw.print("vrThreadTid=");
            pw.println(this.vrThreadTid);
        }
        pw.print(prefix);
        pw.print("curProcState=");
        pw.print(this.curProcState);
        pw.print(" repProcState=");
        pw.print(this.repProcState);
        pw.print(" pssProcState=");
        pw.print(this.pssProcState);
        pw.print(" setProcState=");
        pw.print(this.setProcState);
        pw.print(" lastStateTime=");
        TimeUtils.formatDuration(this.lastStateTime, nowUptime, pw);
        pw.println();
        if (this.hasShownUi || this.pendingUiClean || this.hasAboveClient || this.treatLikeActivity) {
            pw.print(prefix);
            pw.print("hasShownUi=");
            pw.print(this.hasShownUi);
            pw.print(" pendingUiClean=");
            pw.print(this.pendingUiClean);
            pw.print(" hasAboveClient=");
            pw.print(this.hasAboveClient);
            pw.print(" treatLikeActivity=");
            pw.println(this.treatLikeActivity);
        }
        if (this.hasTopUi || this.hasOverlayUi) {
            pw.print(prefix);
            pw.print("hasTopUi=");
            pw.print(this.hasTopUi);
            pw.print(" hasOverlayUi=");
            pw.println(this.hasOverlayUi);
        }
        if (this.foregroundServices || this.forcingToImportant != null) {
            pw.print(prefix);
            pw.print("foregroundServices=");
            pw.print(this.foregroundServices);
            pw.print(" forcingToImportant=");
            pw.println(this.forcingToImportant);
        }
        if (this.reportedInteraction || this.fgInteractionTime != 0L) {
            pw.print(prefix);
            pw.print("reportedInteraction=");
            pw.print(this.reportedInteraction);
            if (this.interactionEventTime != 0L) {
                pw.print(" time=");
                TimeUtils.formatDuration(this.interactionEventTime, SystemClock.elapsedRealtime(), pw);
            }
            if (this.fgInteractionTime != 0L) {
                pw.print(" fgInteractionTime=");
                TimeUtils.formatDuration(this.fgInteractionTime, SystemClock.elapsedRealtime(), pw);
            }
            pw.println();
        }
        if (this.persistent || this.removed) {
            pw.print(prefix);
            pw.print("persistent=");
            pw.print(this.persistent);
            pw.print(" removed=");
            pw.println(this.removed);
        }
        if (this.hasClientActivities || this.foregroundActivities || this.repForegroundActivities) {
            pw.print(prefix);
            pw.print("hasClientActivities=");
            pw.print(this.hasClientActivities);
            pw.print(" foregroundActivities=");
            pw.print(this.foregroundActivities);
            pw.print(" (rep=");
            pw.print(this.repForegroundActivities);
            pw.println(")");
        }
        if (this.lastProviderTime > 0L) {
            pw.print(prefix);
            pw.print("lastProviderTime=");
            TimeUtils.formatDuration(this.lastProviderTime, nowUptime, pw);
            pw.println();
        }
        if (this.hasStartedServices) {
            pw.print(prefix);
            pw.print("hasStartedServices=");
            pw.println(this.hasStartedServices);
        }
        if (this.setProcState > 11) {
            pw.print(prefix);
            pw.print("lastCpuTime=");
            pw.print(this.lastCpuTime);
            if (this.lastCpuTime > 0L) {
                pw.print(" timeUsed=");
                TimeUtils.formatDuration(this.curCpuTime - this.lastCpuTime, pw);
            }
            pw.print(" whenUnimportant=");
            TimeUtils.formatDuration(this.whenUnimportant - nowUptime, pw);
            pw.println();
        }
        pw.print(prefix);
        pw.print("lastRequestedGc=");
        TimeUtils.formatDuration(this.lastRequestedGc, nowUptime, pw);
        pw.print(" lastLowMemory=");
        TimeUtils.formatDuration(this.lastLowMemory, nowUptime, pw);
        pw.print(" reportLowMemory=");
        pw.println(this.reportLowMemory);
        if (this.killed || this.killedByAm || this.waitingToKill != null) {
            pw.print(prefix);
            pw.print("killed=");
            pw.print(this.killed);
            pw.print(" killedByAm=");
            pw.print(this.killedByAm);
            pw.print(" waitingToKill=");
            pw.println(this.waitingToKill);
        }
        if (this.debugging || this.crashing || this.crashDialog != null || this.notResponding || this.anrDialog != null || this.bad) {
            pw.print(prefix);
            pw.print("debugging=");
            pw.print(this.debugging);
            pw.print(" crashing=");
            pw.print(this.crashing);
            pw.print(" ");
            pw.print(this.crashDialog);
            pw.print(" notResponding=");
            pw.print(this.notResponding);
            pw.print(" ");
            pw.print(this.anrDialog);
            pw.print(" bad=");
            pw.print(this.bad);
            if (this.errorReportReceiver != null) {
                pw.print(" errorReportReceiver=");
                pw.print(this.errorReportReceiver.flattenToShortString());
            }
            pw.println();
        }
        if (this.whitelistManager) {
            pw.print(prefix);
            pw.print("whitelistManager=");
            pw.println(this.whitelistManager);
        }
        if (this.activities.size() > 0) {
            pw.print(prefix);
            pw.println("Activities:");
            for (i = 0; i < this.activities.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.activities.get(i));
            }
        }
        if (this.services.size() > 0) {
            pw.print(prefix);
            pw.println("Services:");
            for (i = 0; i < this.services.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.services.valueAt(i));
            }
        }
        if (this.executingServices.size() > 0) {
            pw.print(prefix);
            pw.print("Executing Services (fg=");
            pw.print(this.execServicesFg);
            pw.println(")");
            for (i = 0; i < this.executingServices.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.executingServices.valueAt(i));
            }
        }
        if (this.connections.size() > 0) {
            pw.print(prefix);
            pw.println("Connections:");
            for (i = 0; i < this.connections.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.connections.valueAt(i));
            }
        }
        if (this.pubProviders.size() > 0) {
            pw.print(prefix);
            pw.println("Published Providers:");
            for (i = 0; i < this.pubProviders.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.pubProviders.keyAt(i));
                pw.print(prefix);
                pw.print("    -> ");
                pw.println(this.pubProviders.valueAt(i));
            }
        }
        if (this.conProviders.size() > 0) {
            pw.print(prefix);
            pw.println("Connected Providers:");
            for (i = 0; i < this.conProviders.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.conProviders.get(i).toShortString());
            }
        }
        if (!this.curReceivers.isEmpty()) {
            pw.print(prefix);
            pw.println("Current Receivers:");
            for (i = 0; i < this.curReceivers.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.curReceivers.valueAt(i));
            }
        }
        if (this.receivers.size() > 0) {
            pw.print(prefix);
            pw.println("Receivers:");
            for (i = 0; i < this.receivers.size(); ++i) {
                pw.print(prefix);
                pw.print("  - ");
                pw.println(this.receivers.valueAt(i));
            }
        }
    }

    ProcessRecord(BatteryStatsImpl _batteryStats, ApplicationInfo _info, String _processName, int _uid) {
        this.mBatteryStats = _batteryStats;
        this.info = _info;
        this.isolated = _info.uid != _uid;
        this.uid = _uid;
        this.userId = UserHandle.getUserId(_uid);
        this.processName = _processName;
        this.pkgList.put(_info.packageName, new ProcessStats.ProcessStateHolder(_info.versionCode));
        this.maxAdj = 1001;
        this.setRawAdj = -10000;
        this.curRawAdj = -10000;
        this.verifiedAdj = -10000;
        this.setAdj = -10000;
        this.curAdj = -10000;
        this.persistent = false;
        this.removed = false;
        this.lastPssTime = this.nextPssTime = SystemClock.uptimeMillis();
        this.lastStateTime = this.nextPssTime;
    }

    public void setPid(int _pid) {
        this.pid = _pid;
        this.procStatFile = null;
        this.shortStringName = null;
        this.stringName = null;
    }

    public void makeActive(IApplicationThread _thread, ProcessStatsService tracker) {
        if (this.thread == null) {
            ProcessState origBase = this.baseProcessTracker;
            if (origBase != null) {
                origBase.setState(-1, tracker.getMemFactorLocked(), SystemClock.uptimeMillis(), this.pkgList);
                origBase.makeInactive();
            }
            this.baseProcessTracker = tracker.getProcessStateLocked(this.info.packageName, this.uid, this.info.versionCode, this.processName);
            this.baseProcessTracker.makeActive();
            for (int i = 0; i < this.pkgList.size(); ++i) {
                ProcessStats.ProcessStateHolder holder = this.pkgList.valueAt(i);
                if (holder.state != null && holder.state != origBase) {
                    holder.state.makeInactive();
                }
                holder.state = tracker.getProcessStateLocked(this.pkgList.keyAt(i), this.uid, this.info.versionCode, this.processName);
                if (holder.state == this.baseProcessTracker) continue;
                holder.state.makeActive();
            }
        }
        this.thread = _thread;
    }

    public void makeInactive(ProcessStatsService tracker) {
        this.thread = null;
        ProcessState origBase = this.baseProcessTracker;
        if (origBase != null) {
            if (origBase != null) {
                origBase.setState(-1, tracker.getMemFactorLocked(), SystemClock.uptimeMillis(), this.pkgList);
                origBase.makeInactive();
            }
            this.baseProcessTracker = null;
            for (int i = 0; i < this.pkgList.size(); ++i) {
                ProcessStats.ProcessStateHolder holder = this.pkgList.valueAt(i);
                if (holder.state != null && holder.state != origBase) {
                    holder.state.makeInactive();
                }
                holder.state = null;
            }
        }
    }

    public boolean isInterestingToUserLocked() {
        int size = this.activities.size();
        for (int i = 0; i < size; ++i) {
            ActivityRecord r = this.activities.get(i);
            if (!r.isInterestingToUserLocked()) continue;
            return true;
        }
        int servicesSize = this.services.size();
        for (int i = 0; i < servicesSize; ++i) {
            ServiceRecord r = this.services.valueAt(i);
            if (!r.isForeground) continue;
            return true;
        }
        return false;
    }

    public void stopFreezingAllLocked() {
        int i = this.activities.size();
        while (i > 0) {
            this.activities.get(--i).stopFreezingScreenLocked(true);
        }
    }

    public void unlinkDeathRecipient() {
        if (this.deathRecipient != null && this.thread != null) {
            this.thread.asBinder().unlinkToDeath(this.deathRecipient, 0);
        }
        this.deathRecipient = null;
    }

    void updateHasAboveClientLocked() {
        this.hasAboveClient = false;
        for (int i = this.connections.size() - 1; i >= 0; --i) {
            ConnectionRecord cr = this.connections.valueAt(i);
            if ((cr.flags & 8) == 0) continue;
            this.hasAboveClient = true;
            break;
        }
    }

    int modifyRawOomAdj(int adj) {
        if (this.hasAboveClient && adj >= 0) {
            if (adj < 100) {
                adj = 100;
            } else if (adj < 200) {
                adj = 200;
            } else if (adj < 900) {
                adj = 900;
            } else if (adj < 906) {
                ++adj;
            }
        }
        return adj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCrash(String message) {
        if (!this.killedByAm && this.thread != null) {
            if (this.pid == Process.myPid()) {
                Slog.w(TAG, "scheduleCrash: trying to crash system process!");
                return;
            }
            long ident = Binder.clearCallingIdentity();
            try {
                this.thread.scheduleCrash(message);
            }
            catch (RemoteException e) {
                this.kill("scheduleCrash for '" + message + "' failed", true);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    void kill(String reason, boolean noisy) {
        if (!this.killedByAm) {
            Trace.traceBegin(64L, "kill");
            if (noisy) {
                Slog.i(TAG, "Killing " + this.toShortString() + " (adj " + this.setAdj + "): " + reason);
            }
            EventLog.writeEvent(30023, this.userId, this.pid, this.processName, this.setAdj, reason);
            Process.killProcessQuiet(this.pid);
            ActivityManagerService.killProcessGroup(this.uid, this.pid);
            if (!this.persistent) {
                this.killed = true;
                this.killedByAm = true;
            }
            Trace.traceEnd(64L);
        }
    }

    public String toShortString() {
        if (this.shortStringName != null) {
            return this.shortStringName;
        }
        StringBuilder sb = new StringBuilder(128);
        this.toShortString(sb);
        this.shortStringName = sb.toString();
        return this.shortStringName;
    }

    void toShortString(StringBuilder sb) {
        sb.append(this.pid);
        sb.append(':');
        sb.append(this.processName);
        sb.append('/');
        if (this.info.uid < 10000) {
            sb.append(this.uid);
        } else {
            sb.append('u');
            sb.append(this.userId);
            int appId = UserHandle.getAppId(this.info.uid);
            if (appId >= 10000) {
                sb.append('a');
                sb.append(appId - 10000);
            } else {
                sb.append('s');
                sb.append(appId);
            }
            if (this.uid != this.info.uid) {
                sb.append('i');
                sb.append(UserHandle.getAppId(this.uid) - 99000);
            }
        }
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName;
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ProcessRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        this.toShortString(sb);
        sb.append('}');
        this.stringName = sb.toString();
        return this.stringName;
    }

    public String makeAdjReason() {
        if (this.adjSource != null || this.adjTarget != null) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(' ');
            if (this.adjTarget instanceof ComponentName) {
                sb.append(((ComponentName)this.adjTarget).flattenToShortString());
            } else if (this.adjTarget != null) {
                sb.append(this.adjTarget.toString());
            } else {
                sb.append("{null}");
            }
            sb.append("<=");
            if (this.adjSource instanceof ProcessRecord) {
                sb.append("Proc{");
                sb.append(((ProcessRecord)this.adjSource).toShortString());
                sb.append("}");
            } else if (this.adjSource != null) {
                sb.append(this.adjSource.toString());
            } else {
                sb.append("{null}");
            }
            return sb.toString();
        }
        return null;
    }

    public boolean addPackage(String pkg, int versionCode, ProcessStatsService tracker) {
        if (!this.pkgList.containsKey(pkg)) {
            ProcessStats.ProcessStateHolder holder = new ProcessStats.ProcessStateHolder(versionCode);
            if (this.baseProcessTracker != null) {
                holder.state = tracker.getProcessStateLocked(pkg, this.uid, versionCode, this.processName);
                this.pkgList.put(pkg, holder);
                if (holder.state != this.baseProcessTracker) {
                    holder.state.makeActive();
                }
            } else {
                this.pkgList.put(pkg, holder);
            }
            return true;
        }
        return false;
    }

    public int getSetAdjWithServices() {
        if (this.setAdj >= 900 && this.hasStartedServices) {
            return 800;
        }
        return this.setAdj;
    }

    public void forceProcessStateUpTo(int newState) {
        if (this.repProcState > newState) {
            this.curProcState = this.repProcState = newState;
        }
    }

    public void resetPackageList(ProcessStatsService tracker) {
        int N = this.pkgList.size();
        if (this.baseProcessTracker != null) {
            long now = SystemClock.uptimeMillis();
            this.baseProcessTracker.setState(-1, tracker.getMemFactorLocked(), now, this.pkgList);
            if (N != 1) {
                ProcessStats.ProcessStateHolder holder;
                for (int i = 0; i < N; ++i) {
                    holder = this.pkgList.valueAt(i);
                    if (holder.state == null || holder.state == this.baseProcessTracker) continue;
                    holder.state.makeInactive();
                }
                this.pkgList.clear();
                ProcessState ps = tracker.getProcessStateLocked(this.info.packageName, this.uid, this.info.versionCode, this.processName);
                holder = new ProcessStats.ProcessStateHolder(this.info.versionCode);
                holder.state = ps;
                this.pkgList.put(this.info.packageName, holder);
                if (ps != this.baseProcessTracker) {
                    ps.makeActive();
                }
            }
        } else if (N != 1) {
            this.pkgList.clear();
            this.pkgList.put(this.info.packageName, new ProcessStats.ProcessStateHolder(this.info.versionCode));
        }
    }

    public String[] getPackageList() {
        int size = this.pkgList.size();
        if (size == 0) {
            return null;
        }
        String[] list = new String[size];
        for (int i = 0; i < this.pkgList.size(); ++i) {
            list[i] = this.pkgList.keyAt(i);
        }
        return list;
    }
}

