/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.AppGlobals;
import android.app.Dialog;
import android.app.IStopUserCallback;
import android.app.IUserSwitchObserver;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import android.os.Handler;
import android.os.IBinder;
import android.os.IProgressListener;
import android.os.IRemoteCallback;
import android.os.IUserManager;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.UserManagerInternal;
import android.os.storage.IStorageManager;
import android.os.storage.StorageManager;
import android.util.ArraySet;
import android.util.IntArray;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.Preconditions;
import com.android.internal.widget.LockPatternUtils;
import com.android.server.LocalServices;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.EventLogTags;
import com.android.server.am.PreBootBroadcaster;
import com.android.server.am.UserState;
import com.android.server.am.UserSwitchingDialog;
import com.android.server.pm.UserManagerService;
import com.android.server.wm.WindowManagerService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

final class UserController {
    private static final String TAG = "ActivityManager";
    static final int MAX_RUNNING_USERS = 3;
    static final int USER_SWITCH_TIMEOUT = 3000;
    private final Object mLock;
    private final Injector mInjector;
    private final Handler mHandler;
    @GuardedBy(value="mLock")
    private volatile int mCurrentUserId = 0;
    @GuardedBy(value="mLock")
    private volatile int mTargetUserId = -10000;
    @GuardedBy(value="mLock")
    private final SparseArray<UserState> mStartedUsers = new SparseArray();
    @GuardedBy(value="mLock")
    private final ArrayList<Integer> mUserLru = new ArrayList();
    @GuardedBy(value="mLock")
    private int[] mStartedUserArray = new int[]{0};
    @GuardedBy(value="mLock")
    private int[] mCurrentProfileIds = new int[0];
    private final SparseIntArray mUserProfileGroupIdsSelfLocked = new SparseIntArray();
    private final RemoteCallbackList<IUserSwitchObserver> mUserSwitchObservers = new RemoteCallbackList();
    boolean mUserSwitchUiEnabled = true;
    @GuardedBy(value="mLock")
    private volatile ArraySet<String> mCurWaitingUserSwitchCallbacks;
    private volatile UserManagerService mUserManager;
    private final LockPatternUtils mLockPatternUtils;

    UserController(ActivityManagerService service) {
        this(new Injector(service));
    }

    UserController(Injector injector) {
        this.mInjector = injector;
        this.mLock = injector.getLock();
        this.mHandler = injector.getHandler();
        UserState uss = new UserState(UserHandle.SYSTEM);
        this.mStartedUsers.put(0, uss);
        this.mUserLru.add(0);
        this.mLockPatternUtils = this.mInjector.getLockPatternUtils();
        this.updateStartedUserArrayLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserSwitch(UserState uss) {
        Object object = this.mLock;
        synchronized (object) {
            this.finishUserBoot(uss);
            this.startProfilesLocked();
            this.stopRunningUsersLocked(3);
        }
    }

    void stopRunningUsersLocked(int maxRunningUsers) {
        int num = this.mUserLru.size();
        int i = 0;
        while (num > maxRunningUsers && i < this.mUserLru.size()) {
            Integer oldUserId = this.mUserLru.get(i);
            UserState oldUss = this.mStartedUsers.get(oldUserId);
            if (oldUss == null) {
                this.mUserLru.remove(i);
                --num;
                continue;
            }
            if (oldUss.state == 4 || oldUss.state == 5) {
                --num;
                ++i;
                continue;
            }
            if (oldUserId == 0 || oldUserId == this.mCurrentUserId) {
                if (UserInfo.isSystemOnly(oldUserId)) {
                    --num;
                }
                ++i;
                continue;
            }
            if (this.stopUsersLocked(oldUserId, false, null) != 0) {
                --num;
            }
            --num;
            ++i;
        }
    }

    private void finishUserBoot(UserState uss) {
        this.finishUserBoot(uss, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserBoot(UserState uss, IIntentReceiver resultTo) {
        int userId = uss.mHandle.getIdentifier();
        Slog.d(TAG, "Finishing user boot " + userId);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(userId) != uss) {
                return;
            }
            if (uss.setState(0, 1)) {
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                if (userId == 0 && !this.mInjector.isRuntimeRestarted() && !this.mInjector.isFirstBootOrUpgrade()) {
                    int uptimeSeconds = (int)(SystemClock.elapsedRealtime() / 1000L);
                    MetricsLogger.histogram(this.mInjector.getContext(), "framework_locked_boot_completed", uptimeSeconds);
                    int MAX_UPTIME_SECONDS = 120;
                    if (uptimeSeconds > 120) {
                        Slog.wtf("SystemServerTiming", "finishUserBoot took too long. uptimeSeconds=" + uptimeSeconds);
                    }
                }
                this.mHandler.sendMessage(this.mHandler.obtainMessage(64, userId, 0));
                Intent intent = new Intent("android.intent.action.LOCKED_BOOT_COMPLETED", null);
                intent.putExtra("android.intent.extra.user_handle", userId);
                intent.addFlags(0x9000000);
                this.mInjector.broadcastIntentLocked(intent, null, resultTo, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
            }
            if (this.mInjector.getUserManager().isManagedProfile(userId)) {
                UserInfo parent = this.mInjector.getUserManager().getProfileParent(userId);
                if (parent != null && this.isUserRunningLocked(parent.id, 4)) {
                    Slog.d(TAG, "User " + userId + " (parent " + parent.id + "): attempting unlock because parent is unlocked");
                    this.maybeUnlockUser(userId);
                } else {
                    String parentId = parent == null ? "<null>" : String.valueOf(parent.id);
                    Slog.d(TAG, "User " + userId + " (parent " + parentId + "): delaying unlock because parent is locked");
                }
            } else {
                this.maybeUnlockUser(userId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserUnlocking(UserState uss) {
        int userId = uss.mHandle.getIdentifier();
        boolean proceedWithUnlock = false;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                return;
            }
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                return;
            }
            if (uss.setState(1, 2)) {
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                proceedWithUnlock = true;
            }
        }
        if (proceedWithUnlock) {
            uss.mUnlockProgress.start();
            uss.mUnlockProgress.setProgress(5, this.mInjector.getContext().getString(17039467));
            this.mInjector.getUserManager().onBeforeUnlockUser(userId);
            uss.mUnlockProgress.setProgress(20);
            this.mHandler.obtainMessage(59, userId, 0, uss).sendToTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserUnlocked(UserState uss) {
        int userId = uss.mHandle.getIdentifier();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                return;
            }
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                return;
            }
            if (uss.setState(2, 3)) {
                UserInfo parent;
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                uss.mUnlockProgress.finish();
                Intent unlockedIntent = new Intent("android.intent.action.USER_UNLOCKED");
                unlockedIntent.putExtra("android.intent.extra.user_handle", userId);
                unlockedIntent.addFlags(0x50000000);
                this.mInjector.broadcastIntentLocked(unlockedIntent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, userId);
                if (this.getUserInfo(userId).isManagedProfile() && (parent = this.mInjector.getUserManager().getProfileParent(userId)) != null) {
                    Intent profileUnlockedIntent = new Intent("android.intent.action.MANAGED_PROFILE_UNLOCKED");
                    profileUnlockedIntent.putExtra("android.intent.extra.USER", UserHandle.of(userId));
                    profileUnlockedIntent.addFlags(0x50000000);
                    this.mInjector.broadcastIntentLocked(profileUnlockedIntent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, parent.id);
                }
                UserInfo info = this.getUserInfo(userId);
                if (!Objects.equals(info.lastLoggedInFingerprint, Build.FINGERPRINT)) {
                    boolean quiet = info.isManagedProfile() ? !uss.tokenProvided || !this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId) : false;
                    this.mInjector.sendPreBootBroadcast(userId, quiet, () -> this.finishUserUnlockedCompleted(uss));
                } else {
                    this.finishUserUnlockedCompleted(uss);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishUserUnlockedCompleted(UserState uss) {
        final int userId = uss.mHandle.getIdentifier();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(uss.mHandle.getIdentifier()) != uss) {
                return;
            }
            final UserInfo userInfo = this.getUserInfo(userId);
            if (userInfo == null) {
                return;
            }
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                return;
            }
            this.mInjector.getUserManager().onUserLoggedIn(userId);
            if (!userInfo.isInitialized() && userId != 0) {
                Slog.d(TAG, "Initializing user #" + userId);
                Intent intent = new Intent("android.intent.action.USER_INITIALIZE");
                intent.addFlags(0x11000000);
                this.mInjector.broadcastIntentLocked(intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        UserController.this.mInjector.getUserManager().makeInitialized(userInfo.id);
                    }
                }, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
            }
            Slog.i(TAG, "Sending BOOT_COMPLETE user #" + userId);
            if (userId == 0 && !this.mInjector.isRuntimeRestarted() && !this.mInjector.isFirstBootOrUpgrade()) {
                int uptimeSeconds = (int)(SystemClock.elapsedRealtime() / 1000L);
                MetricsLogger.histogram(this.mInjector.getContext(), "framework_boot_completed", uptimeSeconds);
            }
            Intent bootIntent = new Intent("android.intent.action.BOOT_COMPLETED", null);
            bootIntent.putExtra("android.intent.extra.user_handle", userId);
            bootIntent.addFlags(0x9000000);
            this.mInjector.broadcastIntentLocked(bootIntent, null, new IIntentReceiver.Stub(){

                @Override
                public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    Slog.i(UserController.TAG, "Finished processing BOOT_COMPLETED for u" + userId);
                }
            }, 0, null, null, new String[]{"android.permission.RECEIVE_BOOT_COMPLETED"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
        }
    }

    int restartUser(int userId, final boolean foreground) {
        return this.stopUser(userId, true, new IStopUserCallback.Stub(){

            @Override
            public void userStopped(int userId) {
                UserController.this.mHandler.post(() -> UserController.this.startUser(userId, foreground));
            }

            @Override
            public void userStopAborted(int userId) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int stopUser(int userId, boolean force, IStopUserCallback callback) {
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        if (userId < 0 || userId == 0) {
            throw new IllegalArgumentException("Can't stop system user " + userId);
        }
        this.mInjector.enforceShellRestriction("no_debugging_features", userId);
        Object object = this.mLock;
        synchronized (object) {
            return this.stopUsersLocked(userId, force, callback);
        }
    }

    private int stopUsersLocked(int userId, boolean force, IStopUserCallback callback) {
        if (userId == 0) {
            return -3;
        }
        if (this.isCurrentUserLocked(userId)) {
            return -2;
        }
        int[] usersToStop = this.getUsersToStopLocked(userId);
        for (int i = 0; i < usersToStop.length; ++i) {
            int relatedUserId = usersToStop[i];
            if (0 != relatedUserId && !this.isCurrentUserLocked(relatedUserId)) continue;
            if (force) {
                Slog.i(TAG, "Force stop user " + userId + ". Related users will not be stopped");
                this.stopSingleUserLocked(userId, callback);
                return 0;
            }
            return -4;
        }
        for (int userIdToStop : usersToStop) {
            this.stopSingleUserLocked(userIdToStop, userIdToStop == userId ? callback : null);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopSingleUserLocked(final int userId, final IStopUserCallback callback) {
        final UserState uss = this.mStartedUsers.get(userId);
        if (uss == null) {
            if (callback != null) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            callback.userStopped(userId);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                });
            }
            return;
        }
        if (callback != null) {
            uss.mStopCallbacks.add(callback);
        }
        if (uss.state != 4 && uss.state != 5) {
            uss.setState(4);
            this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
            this.updateStartedUserArrayLocked();
            long ident = Binder.clearCallingIdentity();
            try {
                Intent stoppingIntent = new Intent("android.intent.action.USER_STOPPING");
                stoppingIntent.addFlags(0x40000000);
                stoppingIntent.putExtra("android.intent.extra.user_handle", userId);
                stoppingIntent.putExtra("android.intent.extra.SHUTDOWN_USERSPACE_ONLY", true);
                IIntentReceiver.Stub stoppingReceiver = new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                        UserController.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                UserController.this.finishUserStopping(userId, uss);
                            }
                        });
                    }
                };
                this.mInjector.clearBroadcastQueueForUserLocked(userId);
                this.mInjector.broadcastIntentLocked(stoppingIntent, null, stoppingReceiver, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, -1);
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStopping(int userId, final UserState uss) {
        Intent shutdownIntent = new Intent("android.intent.action.ACTION_SHUTDOWN");
        shutdownIntent.addFlags(0x1000000);
        IIntentReceiver.Stub shutdownReceiver = new IIntentReceiver.Stub(){

            @Override
            public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
                UserController.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        UserController.this.finishUserStopped(uss);
                    }
                });
            }
        };
        Object object = this.mLock;
        synchronized (object) {
            if (uss.state != 4) {
                return;
            }
            uss.setState(5);
        }
        this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
        this.mInjector.batteryStatsServiceNoteEvent(16391, Integer.toString(userId), userId);
        this.mInjector.systemServiceManagerStopUser(userId);
        object = this.mLock;
        synchronized (object) {
            this.mInjector.broadcastIntentLocked(shutdownIntent, null, shutdownReceiver, 0, null, null, null, -1, null, true, false, ActivityManagerService.MY_PID, 1000, userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishUserStopped(UserState uss) {
        boolean stopped;
        ArrayList<IStopUserCallback> callbacks;
        int userId = uss.mHandle.getIdentifier();
        Object object = this.mLock;
        synchronized (object) {
            callbacks = new ArrayList<IStopUserCallback>(uss.mStopCallbacks);
            if (this.mStartedUsers.get(userId) != uss) {
                stopped = false;
            } else if (uss.state != 5) {
                stopped = false;
            } else {
                stopped = true;
                this.mStartedUsers.remove(userId);
                this.mInjector.getUserManagerInternal().removeUserState(userId);
                this.mUserLru.remove((Object)userId);
                this.updateStartedUserArrayLocked();
                this.mInjector.activityManagerOnUserStopped(userId);
                this.forceStopUserLocked(userId, "finish user");
            }
        }
        for (int i = 0; i < callbacks.size(); ++i) {
            try {
                if (stopped) {
                    callbacks.get(i).userStopped(userId);
                    continue;
                }
                callbacks.get(i).userStopAborted(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (stopped) {
            this.mInjector.systemServiceManagerCleanupUser(userId);
            Object i = this.mLock;
            synchronized (i) {
                this.mInjector.getActivityStackSupervisor().removeUserLocked(userId);
            }
            if (this.getUserInfo(userId).isEphemeral()) {
                this.mInjector.getUserManager().removeUser(userId);
            }
            try {
                this.getStorageManager().lockUserKey(userId);
            }
            catch (RemoteException re) {
                throw re.rethrowAsRuntimeException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getUsersToStopLocked(int userId) {
        int startedUsersSize = this.mStartedUsers.size();
        IntArray userIds = new IntArray();
        userIds.add(userId);
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            int userGroupId = this.mUserProfileGroupIdsSelfLocked.get(userId, -10000);
            for (int i = 0; i < startedUsersSize; ++i) {
                boolean sameUserId;
                UserState uss = this.mStartedUsers.valueAt(i);
                int startedUserId = uss.mHandle.getIdentifier();
                int startedUserGroupId = this.mUserProfileGroupIdsSelfLocked.get(startedUserId, -10000);
                boolean sameGroup = userGroupId != -10000 && userGroupId == startedUserGroupId;
                boolean bl = sameUserId = startedUserId == userId;
                if (!sameGroup || sameUserId) continue;
                userIds.add(startedUserId);
            }
        }
        return userIds.toArray();
    }

    private void forceStopUserLocked(int userId, String reason) {
        this.mInjector.activityManagerForceStopPackageLocked(userId, reason);
        Intent intent = new Intent("android.intent.action.USER_STOPPED");
        intent.addFlags(0x50000000);
        intent.putExtra("android.intent.extra.user_handle", userId);
        this.mInjector.broadcastIntentLocked(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopGuestOrEphemeralUserIfBackground() {
        Object object = this.mLock;
        synchronized (object) {
            int num = this.mUserLru.size();
            for (int i = 0; i < num; ++i) {
                Integer oldUserId = this.mUserLru.get(i);
                UserState oldUss = this.mStartedUsers.get(oldUserId);
                if (oldUserId == 0 || oldUserId == this.mCurrentUserId || oldUss.state == 4 || oldUss.state == 5) continue;
                UserInfo userInfo = this.getUserInfo(oldUserId);
                if (userInfo.isEphemeral()) {
                    LocalServices.getService(UserManagerInternal.class).onEphemeralUserStop(oldUserId);
                }
                if (!userInfo.isGuest() && !userInfo.isEphemeral()) continue;
                this.stopUsersLocked(oldUserId, true, null);
                break;
            }
        }
    }

    void startProfilesLocked() {
        int i;
        List<UserInfo> profiles = this.mInjector.getUserManager().getProfiles(this.mCurrentUserId, false);
        ArrayList<UserInfo> profilesToStart = new ArrayList<UserInfo>(profiles.size());
        for (UserInfo user : profiles) {
            if ((user.flags & 0x10) != 16 || user.id == this.mCurrentUserId || user.isQuietModeEnabled()) continue;
            profilesToStart.add(user);
        }
        int profilesToStartSize = profilesToStart.size();
        for (i = 0; i < profilesToStartSize && i < 2; ++i) {
            this.startUser(((UserInfo)profilesToStart.get((int)i)).id, false);
        }
        if (i < profilesToStartSize) {
            Slog.w(TAG, "More profiles than MAX_RUNNING_USERS");
        }
    }

    private IStorageManager getStorageManager() {
        return IStorageManager.Stub.asInterface(ServiceManager.getService("mount"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    boolean startUser(int userId, boolean foreground) {
        UserInfo userInfo;
        int oldUserId;
        long ident;
        block27: {
            if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
                String msg = "Permission Denial: switchUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
                Slog.w(TAG, msg);
                throw new SecurityException(msg);
            }
            Slog.i(TAG, "Starting userid:" + userId + " fg:" + foreground);
            ident = Binder.clearCallingIdentity();
            Object object = this.mLock;
            // MONITORENTER : object
            oldUserId = this.mCurrentUserId;
            if (oldUserId != userId) break block27;
            boolean bl = true;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (foreground) {
            this.mInjector.getActivityStackSupervisor().setLockTaskModeLocked(null, 0, "startUser", false);
        }
        if ((userInfo = this.getUserInfo(userId)) == null) {
            Slog.w(TAG, "No user info for user #" + userId);
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        if (foreground && userInfo.isManagedProfile()) {
            Slog.w(TAG, "Cannot switch to User #" + userId + ": not a full user");
            boolean bl = false;
            // MONITOREXIT : object
            Binder.restoreCallingIdentity(ident);
            return bl;
        }
        try {
            Intent intent;
            if (foreground && this.mUserSwitchUiEnabled) {
                this.mInjector.getWindowManager().startFreezingScreen(17432706, 17432705);
            }
            boolean needStart = false;
            if (this.mStartedUsers.get(userId) == null) {
                UserState userState = new UserState(UserHandle.of(userId));
                this.mStartedUsers.put(userId, userState);
                this.mInjector.getUserManagerInternal().setUserState(userId, userState.state);
                this.updateStartedUserArrayLocked();
                needStart = true;
            }
            UserState uss = this.mStartedUsers.get(userId);
            Integer userIdInt = userId;
            this.mUserLru.remove(userIdInt);
            this.mUserLru.add(userIdInt);
            if (foreground) {
                this.mCurrentUserId = userId;
                this.mInjector.updateUserConfigurationLocked();
                this.mTargetUserId = -10000;
                this.updateCurrentProfileIdsLocked();
                this.mInjector.getWindowManager().setCurrentUser(userId, this.mCurrentProfileIds);
                if (this.mUserSwitchUiEnabled) {
                    this.mInjector.getWindowManager().setSwitchingUser(true);
                    this.mInjector.getWindowManager().lockNow(null);
                }
            } else {
                Integer currentUserIdInt = this.mCurrentUserId;
                this.updateCurrentProfileIdsLocked();
                this.mInjector.getWindowManager().setCurrentProfileIds(this.mCurrentProfileIds);
                this.mUserLru.remove(currentUserIdInt);
                this.mUserLru.add(currentUserIdInt);
            }
            if (uss.state == 4) {
                uss.setState(uss.lastState);
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                this.updateStartedUserArrayLocked();
                needStart = true;
            } else if (uss.state == 5) {
                uss.setState(0);
                this.mInjector.getUserManagerInternal().setUserState(userId, uss.state);
                this.updateStartedUserArrayLocked();
                needStart = true;
            }
            if (uss.state == 0) {
                this.mInjector.getUserManager().onBeforeStartUser(userId);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(42, userId, 0));
            }
            if (foreground) {
                this.mHandler.sendMessage(this.mHandler.obtainMessage(43, userId, oldUserId));
                this.mHandler.removeMessages(34);
                this.mHandler.removeMessages(36);
                this.mHandler.sendMessage(this.mHandler.obtainMessage(34, oldUserId, userId, uss));
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(36, oldUserId, userId, uss), 3000L);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.mInjector.broadcastIntentLocked(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, userId);
            }
            if (foreground) {
                this.moveUserToForegroundLocked(uss, oldUserId, userId);
            } else {
                this.finishUserBoot(uss);
            }
            if (needStart) {
                intent = new Intent("android.intent.action.USER_STARTING");
                intent.addFlags(0x40000000);
                intent.putExtra("android.intent.extra.user_handle", userId);
                this.mInjector.broadcastIntentLocked(intent, null, new IIntentReceiver.Stub(){

                    @Override
                    public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
                    }
                }, 0, null, null, new String[]{"android.permission.INTERACT_ACROSS_USERS"}, -1, null, true, false, ActivityManagerService.MY_PID, 1000, -1);
            }
            // MONITOREXIT : object
            return true;
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    void startUserInForeground(int targetUserId) {
        boolean success = this.startUser(targetUserId, true);
        if (!success) {
            this.mInjector.getWindowManager().setSwitchingUser(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlockUser(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: unlockUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        long binderToken = Binder.clearCallingIdentity();
        try {
            boolean bl = this.unlockUserCleared(userId, token, secret, listener);
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(binderToken);
        }
    }

    boolean maybeUnlockUser(int userId) {
        return this.unlockUserCleared(userId, null, null, null);
    }

    private static void notifyFinished(int userId, IProgressListener listener) {
        if (listener == null) {
            return;
        }
        try {
            listener.onFinished(userId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean unlockUserCleared(int userId, byte[] token, byte[] secret, IProgressListener listener) {
        int i;
        UserState uss;
        Object userInfo;
        Object object = this.mLock;
        synchronized (object) {
            if (!StorageManager.isUserKeyUnlocked(userId)) {
                userInfo = this.getUserInfo(userId);
                IStorageManager storageManager = this.getStorageManager();
                try {
                    storageManager.unlockUserKey(userId, ((UserInfo)userInfo).serialNumber, token, secret);
                }
                catch (RemoteException | RuntimeException e) {
                    Slog.w(TAG, "Failed to unlock: " + e.getMessage());
                }
            }
            if ((uss = this.mStartedUsers.get(userId)) == null) {
                UserController.notifyFinished(userId, listener);
                return false;
            }
            uss.mUnlockProgress.addListener(listener);
            uss.tokenProvided = token != null;
        }
        this.finishUserUnlocking(uss);
        ArraySet<Integer> childProfilesToUnlock = new ArraySet<Integer>();
        userInfo = this.mLock;
        synchronized (userInfo) {
            for (i = 0; i < this.mStartedUsers.size(); ++i) {
                int testUserId = this.mStartedUsers.keyAt(i);
                UserInfo parent = this.mInjector.getUserManager().getProfileParent(testUserId);
                if (parent == null || parent.id != userId || testUserId == userId) continue;
                Slog.d(TAG, "User " + testUserId + " (parent " + parent.id + "): attempting unlock because parent was just unlocked");
                childProfilesToUnlock.add(testUserId);
            }
        }
        int size = childProfilesToUnlock.size();
        for (i = 0; i < size; ++i) {
            this.maybeUnlockUser((Integer)childProfilesToUnlock.valueAt(i));
        }
        return true;
    }

    void showUserSwitchDialog(Pair<UserInfo, UserInfo> fromToUserPair) {
        this.mInjector.showUserSwitchingDialog((UserInfo)fromToUserPair.first, (UserInfo)fromToUserPair.second);
    }

    void dispatchForegroundProfileChanged(int userId) {
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onForegroundProfileSwitch(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    void dispatchUserSwitchComplete(int userId) {
        this.mInjector.getWindowManager().setSwitchingUser(false);
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitchComplete(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    void dispatchLockedBootComplete(int userId) {
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        for (int i = 0; i < observerCount; ++i) {
            try {
                this.mUserSwitchObservers.getBroadcastItem(i).onLockedBootComplete(userId);
                continue;
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundUsersIfEnforced(int oldUserId) {
        if (oldUserId == 0) {
            return;
        }
        boolean disallowRunInBg = this.hasUserRestriction("no_run_in_background", oldUserId);
        if (!disallowRunInBg) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.stopUsersLocked(oldUserId, false, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void timeoutUserSwitch(UserState uss, int oldUserId, int newUserId) {
        Object object = this.mLock;
        synchronized (object) {
            Slog.wtf(TAG, "User switch timeout: from " + oldUserId + " to " + newUserId);
            this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispatchUserSwitch(final UserState uss, final int oldUserId, final int newUserId) {
        Slog.d(TAG, "Dispatch onUserSwitching oldUser #" + oldUserId + " newUser #" + newUserId);
        int observerCount = this.mUserSwitchObservers.beginBroadcast();
        if (observerCount > 0) {
            final ArraySet<String> curWaitingUserSwitchCallbacks = new ArraySet<String>();
            Object object = this.mLock;
            synchronized (object) {
                uss.switching = true;
                this.mCurWaitingUserSwitchCallbacks = curWaitingUserSwitchCallbacks;
            }
            final AtomicInteger waitingCallbacksCount = new AtomicInteger(observerCount);
            final long dispatchStartedTime = SystemClock.elapsedRealtime();
            for (int i = 0; i < observerCount; ++i) {
                try {
                    final String name = "#" + i + " " + this.mUserSwitchObservers.getBroadcastCookie(i);
                    Object object2 = this.mLock;
                    synchronized (object2) {
                        curWaitingUserSwitchCallbacks.add(name);
                    }
                    IRemoteCallback.Stub callback = new IRemoteCallback.Stub(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void sendResult(Bundle data) throws RemoteException {
                            Object object = UserController.this.mLock;
                            synchronized (object) {
                                long delay = SystemClock.elapsedRealtime() - dispatchStartedTime;
                                if (delay > 3000L) {
                                    Slog.wtf(UserController.TAG, "User switch timeout: observer " + name + " sent result after " + delay + " ms");
                                }
                                if (curWaitingUserSwitchCallbacks != UserController.this.mCurWaitingUserSwitchCallbacks) {
                                    return;
                                }
                                curWaitingUserSwitchCallbacks.remove(name);
                                if (waitingCallbacksCount.decrementAndGet() == 0) {
                                    UserController.this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
                                }
                            }
                        }
                    };
                    this.mUserSwitchObservers.getBroadcastItem(i).onUserSwitching(newUserId, callback);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        } else {
            Object object = this.mLock;
            synchronized (object) {
                this.sendContinueUserSwitchLocked(uss, oldUserId, newUserId);
            }
        }
        this.mUserSwitchObservers.finishBroadcast();
    }

    void sendContinueUserSwitchLocked(UserState uss, int oldUserId, int newUserId) {
        this.mCurWaitingUserSwitchCallbacks = null;
        this.mHandler.removeMessages(36);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(35, oldUserId, newUserId, uss));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continueUserSwitch(UserState uss, int oldUserId, int newUserId) {
        Slog.d(TAG, "Continue user switch oldUser #" + oldUserId + ", newUser #" + newUserId);
        if (this.mUserSwitchUiEnabled) {
            Object object = this.mLock;
            synchronized (object) {
                this.mInjector.getWindowManager().stopFreezingScreen();
            }
        }
        uss.switching = false;
        this.mHandler.removeMessages(55);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(55, newUserId, 0));
        this.stopGuestOrEphemeralUserIfBackground();
        this.stopBackgroundUsersIfEnforced(oldUserId);
    }

    void moveUserToForegroundLocked(UserState uss, int oldUserId, int newUserId) {
        boolean homeInFront = this.mInjector.getActivityStackSupervisor().switchUserLocked(newUserId, uss);
        if (homeInFront) {
            this.mInjector.startHomeActivityLocked(newUserId, "moveUserToForeground");
        } else {
            this.mInjector.getActivityStackSupervisor().resumeFocusedStackTopActivityLocked();
        }
        EventLogTags.writeAmSwitchUser(newUserId);
        this.sendUserSwitchBroadcastsLocked(oldUserId, newUserId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUserSwitchBroadcastsLocked(int oldUserId, int newUserId) {
        long ident = Binder.clearCallingIdentity();
        try {
            Intent intent;
            int profileUserId;
            int i;
            int count;
            List<UserInfo> profiles;
            if (oldUserId >= 0) {
                profiles = this.mInjector.getUserManager().getProfiles(oldUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_BACKGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.mInjector.broadcastIntentLocked(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, profileUserId);
                }
            }
            if (newUserId >= 0) {
                profiles = this.mInjector.getUserManager().getProfiles(newUserId, false);
                count = profiles.size();
                for (i = 0; i < count; ++i) {
                    profileUserId = profiles.get((int)i).id;
                    intent = new Intent("android.intent.action.USER_FOREGROUND");
                    intent.addFlags(0x50000000);
                    intent.putExtra("android.intent.extra.user_handle", profileUserId);
                    this.mInjector.broadcastIntentLocked(intent, null, null, 0, null, null, null, -1, null, false, false, ActivityManagerService.MY_PID, 1000, profileUserId);
                }
                intent = new Intent("android.intent.action.USER_SWITCHED");
                intent.addFlags(0x50000000);
                intent.putExtra("android.intent.extra.user_handle", newUserId);
                this.mInjector.broadcastIntentLocked(intent, null, null, 0, null, null, new String[]{"android.permission.MANAGE_USERS"}, -1, null, false, false, ActivityManagerService.MY_PID, 1000, -1);
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
    }

    int handleIncomingUser(int callingPid, int callingUid, int userId, boolean allowAll, int allowMode, String name, String callerPackage) {
        int callingUserId = UserHandle.getUserId(callingUid);
        if (callingUserId == userId) {
            return userId;
        }
        int targetUserId = this.unsafeConvertIncomingUserLocked(userId);
        if (callingUid != 0 && callingUid != 1000) {
            boolean allow;
            if (this.mInjector.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS_FULL", callingPid, callingUid, -1, true) == 0) {
                allow = true;
            } else if (allowMode == 2) {
                allow = false;
            } else if (this.mInjector.checkComponentPermission("android.permission.INTERACT_ACROSS_USERS", callingPid, callingUid, -1, true) != 0) {
                allow = false;
            } else if (allowMode == 0) {
                allow = true;
            } else if (allowMode == 1) {
                allow = this.isSameProfileGroup(callingUserId, targetUserId);
            } else {
                throw new IllegalArgumentException("Unknown mode: " + allowMode);
            }
            if (!allow) {
                if (userId == -3) {
                    targetUserId = callingUserId;
                } else {
                    StringBuilder builder = new StringBuilder(128);
                    builder.append("Permission Denial: ");
                    builder.append(name);
                    if (callerPackage != null) {
                        builder.append(" from ");
                        builder.append(callerPackage);
                    }
                    builder.append(" asks to run as user ");
                    builder.append(userId);
                    builder.append(" but is calling from user ");
                    builder.append(UserHandle.getUserId(callingUid));
                    builder.append("; this requires ");
                    builder.append("android.permission.INTERACT_ACROSS_USERS_FULL");
                    if (allowMode != 2) {
                        builder.append(" or ");
                        builder.append("android.permission.INTERACT_ACROSS_USERS");
                    }
                    String msg = builder.toString();
                    Slog.w(TAG, msg);
                    throw new SecurityException(msg);
                }
            }
        }
        if (!allowAll && targetUserId < 0) {
            throw new IllegalArgumentException("Call does not support special user #" + targetUserId);
        }
        if (callingUid == 2000 && targetUserId >= 0 && this.hasUserRestriction("no_debugging_features", targetUserId)) {
            throw new SecurityException("Shell does not have permission to access user " + targetUserId + "\n " + Debug.getCallers(3));
        }
        return targetUserId;
    }

    int unsafeConvertIncomingUserLocked(int userId) {
        return userId == -2 || userId == -3 ? this.getCurrentUserIdLocked() : userId;
    }

    void registerUserSwitchObserver(IUserSwitchObserver observer, String name) {
        Preconditions.checkNotNull(name, "Observer name cannot be null");
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: registerUserSwitchObserver() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS_FULL";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        this.mUserSwitchObservers.register(observer, name);
    }

    void unregisterUserSwitchObserver(IUserSwitchObserver observer) {
        this.mUserSwitchObservers.unregister(observer);
    }

    UserState getStartedUserStateLocked(int userId) {
        return this.mStartedUsers.get(userId);
    }

    boolean hasStartedUserState(int userId) {
        return this.mStartedUsers.get(userId) != null;
    }

    private void updateStartedUserArrayLocked() {
        UserState uss;
        int i;
        int num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.state == 4 || uss.state == 5) continue;
            ++num;
        }
        this.mStartedUserArray = new int[num];
        num = 0;
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            uss = this.mStartedUsers.valueAt(i);
            if (uss.state == 4 || uss.state == 5) continue;
            this.mStartedUserArray[num++] = this.mStartedUsers.keyAt(i);
        }
    }

    void sendBootCompletedLocked(IIntentReceiver resultTo) {
        for (int i = 0; i < this.mStartedUsers.size(); ++i) {
            UserState uss = this.mStartedUsers.valueAt(i);
            this.finishUserBoot(uss, resultTo);
        }
    }

    void onSystemReady() {
        this.updateCurrentProfileIdsLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentProfileIdsLocked() {
        List<UserInfo> profiles = this.mInjector.getUserManager().getProfiles(this.mCurrentUserId, false);
        int[] currentProfileIds = new int[profiles.size()];
        for (int i = 0; i < currentProfileIds.length; ++i) {
            currentProfileIds[i] = profiles.get((int)i).id;
        }
        this.mCurrentProfileIds = currentProfileIds;
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            this.mUserProfileGroupIdsSelfLocked.clear();
            List<UserInfo> users = this.mInjector.getUserManager().getUsers(false);
            for (int i = 0; i < users.size(); ++i) {
                UserInfo user = users.get(i);
                if (user.profileGroupId == -10000) continue;
                this.mUserProfileGroupIdsSelfLocked.put(user.id, user.profileGroupId);
            }
        }
    }

    int[] getStartedUserArrayLocked() {
        return this.mStartedUserArray;
    }

    boolean isUserRunningLocked(int userId, int flags) {
        UserState state = this.getStartedUserStateLocked(userId);
        if (state == null) {
            return false;
        }
        if ((flags & 1) != 0) {
            return true;
        }
        if ((flags & 2) != 0) {
            switch (state.state) {
                case 0: 
                case 1: {
                    return true;
                }
            }
            return false;
        }
        if ((flags & 8) != 0) {
            switch (state.state) {
                case 2: 
                case 3: {
                    return true;
                }
                case 4: 
                case 5: {
                    return StorageManager.isUserKeyUnlocked(userId);
                }
            }
            return false;
        }
        if ((flags & 4) != 0) {
            switch (state.state) {
                case 3: {
                    return true;
                }
                case 4: 
                case 5: {
                    return StorageManager.isUserKeyUnlocked(userId);
                }
            }
            return false;
        }
        return state.state != 4 && state.state != 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UserInfo getCurrentUser() {
        if (this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS") != 0 && this.mInjector.checkCallingPermission("android.permission.INTERACT_ACROSS_USERS_FULL") != 0) {
            String msg = "Permission Denial: getCurrentUser() from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid() + " requires " + "android.permission.INTERACT_ACROSS_USERS";
            Slog.w(TAG, msg);
            throw new SecurityException(msg);
        }
        if (this.mTargetUserId == -10000) {
            return this.getUserInfo(this.mCurrentUserId);
        }
        Object object = this.mLock;
        synchronized (object) {
            return this.getCurrentUserLocked();
        }
    }

    UserInfo getCurrentUserLocked() {
        int userId = this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
        return this.getUserInfo(userId);
    }

    int getCurrentOrTargetUserIdLocked() {
        return this.mTargetUserId != -10000 ? this.mTargetUserId : this.mCurrentUserId;
    }

    int getCurrentUserIdLocked() {
        return this.mCurrentUserId;
    }

    private boolean isCurrentUserLocked(int userId) {
        return userId == this.getCurrentOrTargetUserIdLocked();
    }

    int setTargetUserIdLocked(int targetUserId) {
        this.mTargetUserId = targetUserId;
        return this.mTargetUserId;
    }

    int[] getUsers() {
        int[] nArray;
        UserManagerService ums = this.mInjector.getUserManager();
        if (ums != null) {
            nArray = ums.getUserIds();
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        return nArray;
    }

    UserInfo getUserInfo(int userId) {
        return this.mInjector.getUserManager().getUserInfo(userId);
    }

    int[] getUserIds() {
        return this.mInjector.getUserManager().getUserIds();
    }

    boolean exists(int userId) {
        return this.mInjector.getUserManager().exists(userId);
    }

    boolean hasUserRestriction(String restriction, int userId) {
        return this.mInjector.getUserManager().hasUserRestriction(restriction, userId);
    }

    Set<Integer> getProfileIds(int userId) {
        HashSet<Integer> userIds = new HashSet<Integer>();
        List<UserInfo> profiles = this.mInjector.getUserManager().getProfiles(userId, false);
        for (UserInfo user : profiles) {
            userIds.add(user.id);
        }
        return userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSameProfileGroup(int callingUserId, int targetUserId) {
        if (callingUserId == targetUserId) {
            return true;
        }
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            int callingProfile = this.mUserProfileGroupIdsSelfLocked.get(callingUserId, -10000);
            int targetProfile = this.mUserProfileGroupIdsSelfLocked.get(targetUserId, -10000);
            return callingProfile != -10000 && callingProfile == targetProfile;
        }
    }

    boolean isCurrentProfileLocked(int userId) {
        return ArrayUtils.contains(this.mCurrentProfileIds, userId);
    }

    int[] getCurrentProfileIdsLocked() {
        return this.mCurrentProfileIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean shouldConfirmCredentials(int userId) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStartedUsers.get(userId) == null) {
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1, 2] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
            if (!this.mLockPatternUtils.isSeparateProfileChallengeEnabled(userId)) {
                return false;
            }
            KeyguardManager km = this.mInjector.getKeyguardManager();
            return km.isDeviceLocked(userId) && km.isDeviceSecure(userId);
        }
    }

    boolean isLockScreenDisabled(int userId) {
        return this.mLockPatternUtils.isLockScreenDisabled(userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(PrintWriter pw, boolean dumpAll) {
        int i;
        pw.println("  mStartedUsers:");
        for (i = 0; i < this.mStartedUsers.size(); ++i) {
            UserState uss = this.mStartedUsers.valueAt(i);
            pw.print("    User #");
            pw.print(uss.mHandle.getIdentifier());
            pw.print(": ");
            uss.dump("", pw);
        }
        pw.print("  mStartedUserArray: [");
        for (i = 0; i < this.mStartedUserArray.length; ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.mStartedUserArray[i]);
        }
        pw.println("]");
        pw.print("  mUserLru: [");
        for (i = 0; i < this.mUserLru.size(); ++i) {
            if (i > 0) {
                pw.print(", ");
            }
            pw.print(this.mUserLru.get(i));
        }
        pw.println("]");
        if (dumpAll) {
            pw.print("  mStartedUserArray: ");
            pw.println(Arrays.toString(this.mStartedUserArray));
        }
        SparseIntArray sparseIntArray = this.mUserProfileGroupIdsSelfLocked;
        synchronized (sparseIntArray) {
            if (this.mUserProfileGroupIdsSelfLocked.size() > 0) {
                pw.println("  mUserProfileGroupIds:");
                for (int i2 = 0; i2 < this.mUserProfileGroupIdsSelfLocked.size(); ++i2) {
                    pw.print("    User #");
                    pw.print(this.mUserProfileGroupIdsSelfLocked.keyAt(i2));
                    pw.print(" -> profile #");
                    pw.println(this.mUserProfileGroupIdsSelfLocked.valueAt(i2));
                }
            }
        }
    }

    static class Injector {
        private final ActivityManagerService mService;
        private UserManagerService mUserManager;
        private UserManagerInternal mUserManagerInternal;

        Injector(ActivityManagerService service) {
            this.mService = service;
        }

        protected Object getLock() {
            return this.mService;
        }

        protected Handler getHandler() {
            return this.mService.mHandler;
        }

        protected Context getContext() {
            return this.mService.mContext;
        }

        protected LockPatternUtils getLockPatternUtils() {
            return new LockPatternUtils(this.getContext());
        }

        protected int broadcastIntentLocked(Intent intent, String resolvedType, IIntentReceiver resultTo, int resultCode, String resultData, Bundle resultExtras, String[] requiredPermissions, int appOp, Bundle bOptions, boolean ordered, boolean sticky, int callingPid, int callingUid, int userId) {
            return this.mService.broadcastIntentLocked(null, null, intent, resolvedType, resultTo, resultCode, resultData, resultExtras, requiredPermissions, appOp, bOptions, ordered, sticky, callingPid, callingUid, userId);
        }

        int checkCallingPermission(String permission2) {
            return this.mService.checkCallingPermission(permission2);
        }

        WindowManagerService getWindowManager() {
            return this.mService.mWindowManager;
        }

        void activityManagerOnUserStopped(int userId) {
            this.mService.onUserStoppedLocked(userId);
        }

        void systemServiceManagerCleanupUser(int userId) {
            this.mService.mSystemServiceManager.cleanupUser(userId);
        }

        protected UserManagerService getUserManager() {
            if (this.mUserManager == null) {
                IBinder b = ServiceManager.getService("user");
                this.mUserManager = (UserManagerService)IUserManager.Stub.asInterface(b);
            }
            return this.mUserManager;
        }

        UserManagerInternal getUserManagerInternal() {
            if (this.mUserManagerInternal == null) {
                this.mUserManagerInternal = LocalServices.getService(UserManagerInternal.class);
            }
            return this.mUserManagerInternal;
        }

        KeyguardManager getKeyguardManager() {
            return this.mService.mContext.getSystemService(KeyguardManager.class);
        }

        void batteryStatsServiceNoteEvent(int code, String name, int uid) {
            this.mService.mBatteryStatsService.noteEvent(code, name, uid);
        }

        void systemServiceManagerStopUser(int userId) {
            this.mService.mSystemServiceManager.stopUser(userId);
        }

        boolean isRuntimeRestarted() {
            return this.mService.mSystemServiceManager.isRuntimeRestarted();
        }

        boolean isFirstBootOrUpgrade() {
            IPackageManager pm = AppGlobals.getPackageManager();
            try {
                return pm.isFirstBoot() || pm.isUpgrade();
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }

        void sendPreBootBroadcast(int userId, boolean quiet, final Runnable onFinish) {
            new PreBootBroadcaster(this.mService, userId, null, quiet){

                @Override
                public void onFinished() {
                    onFinish.run();
                }
            }.sendNext();
        }

        void activityManagerForceStopPackageLocked(int userId, String reason) {
            this.mService.forceStopPackageLocked(null, -1, false, false, true, false, false, userId, reason);
        }

        int checkComponentPermission(String permission2, int pid, int uid, int owningUid, boolean exported) {
            return this.mService.checkComponentPermission(permission2, pid, uid, owningUid, exported);
        }

        void startHomeActivityLocked(int userId, String reason) {
            this.mService.startHomeActivityLocked(userId, reason);
        }

        void updateUserConfigurationLocked() {
            this.mService.updateUserConfigurationLocked();
        }

        void clearBroadcastQueueForUserLocked(int userId) {
            this.mService.clearBroadcastQueueForUserLocked(userId);
        }

        void enforceShellRestriction(String restriction, int userId) {
            this.mService.enforceShellRestriction(restriction, userId);
        }

        void showUserSwitchingDialog(UserInfo fromUser, UserInfo toUser) {
            UserSwitchingDialog d = new UserSwitchingDialog(this.mService, this.mService.mContext, fromUser, toUser, true);
            ((Dialog)d).show();
        }

        ActivityStackSupervisor getActivityStackSupervisor() {
            return this.mService.mStackSupervisor;
        }
    }
}

