/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.content.Context;
import android.content.pm.PackageManager;
import android.media.AudioFormat;
import android.media.AudioRecordingConfiguration;
import android.media.AudioSystem;
import android.media.IRecordingConfigDispatcher;
import android.media.MediaRecorder;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class RecordingActivityMonitor
implements AudioSystem.AudioRecordingCallback {
    public static final String TAG = "AudioService.RecordingActivityMonitor";
    private ArrayList<RecMonitorClient> mClients = new ArrayList();
    private boolean mHasPublicClients = false;
    private HashMap<Integer, AudioRecordingConfiguration> mRecordConfigs = new HashMap();
    private final PackageManager mPackMan;

    RecordingActivityMonitor(Context ctxt) {
        RecMonitorClient.sMonitor = this;
        this.mPackMan = ctxt.getPackageManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onRecordingConfigurationChanged(int event, int uid, int session, int source, int[] recordingInfo, String packName) {
        if (MediaRecorder.isSystemOnlyAudioSource(source)) {
            return;
        }
        List<AudioRecordingConfiguration> configsSystem = this.updateSnapshot(event, uid, session, source, recordingInfo);
        if (configsSystem != null) {
            ArrayList<RecMonitorClient> arrayList = this.mClients;
            synchronized (arrayList) {
                ArrayList<AudioRecordingConfiguration> configsPublic = this.mHasPublicClients ? this.anonymizeForPublicConsumption(configsSystem) : new ArrayList<AudioRecordingConfiguration>();
                for (RecMonitorClient rmc : this.mClients) {
                    try {
                        if (rmc.mIsPrivileged) {
                            rmc.mDispatcherCb.dispatchRecordingConfigChange(configsSystem);
                            continue;
                        }
                        rmc.mDispatcherCb.dispatchRecordingConfigChange(configsPublic);
                    }
                    catch (RemoteException e) {
                        Log.w(TAG, "Could not call dispatchRecordingConfigChange() on client", e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dump(PrintWriter pw) {
        pw.println("\nRecordActivityMonitor dump time: " + DateFormat.getTimeInstance().format(new Date()));
        HashMap<Integer, AudioRecordingConfiguration> hashMap = this.mRecordConfigs;
        synchronized (hashMap) {
            for (AudioRecordingConfiguration conf : this.mRecordConfigs.values()) {
                conf.dump(pw);
            }
        }
    }

    private ArrayList<AudioRecordingConfiguration> anonymizeForPublicConsumption(List<AudioRecordingConfiguration> sysConfigs) {
        ArrayList<AudioRecordingConfiguration> publicConfigs = new ArrayList<AudioRecordingConfiguration>();
        for (AudioRecordingConfiguration config : sysConfigs) {
            publicConfigs.add(AudioRecordingConfiguration.anonymizedCopy(config));
        }
        return publicConfigs;
    }

    void initMonitor() {
        AudioSystem.setRecordingCallback(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerRecordingCallback(IRecordingConfigDispatcher rcdb, boolean isPrivileged) {
        if (rcdb == null) {
            return;
        }
        ArrayList<RecMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            RecMonitorClient rmc = new RecMonitorClient(rcdb, isPrivileged);
            if (rmc.init()) {
                if (!isPrivileged) {
                    this.mHasPublicClients = true;
                }
                this.mClients.add(rmc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterRecordingCallback(IRecordingConfigDispatcher rcdb) {
        if (rcdb == null) {
            return;
        }
        ArrayList<RecMonitorClient> arrayList = this.mClients;
        synchronized (arrayList) {
            Iterator<RecMonitorClient> clientIterator = this.mClients.iterator();
            boolean hasPublicClients = false;
            while (clientIterator.hasNext()) {
                RecMonitorClient rmc = clientIterator.next();
                if (rcdb.equals(rmc.mDispatcherCb)) {
                    rmc.release();
                    clientIterator.remove();
                    continue;
                }
                if (rmc.mIsPrivileged) continue;
                hasPublicClients = true;
            }
            this.mHasPublicClients = hasPublicClients;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<AudioRecordingConfiguration> getActiveRecordingConfigurations(boolean isPrivileged) {
        HashMap<Integer, AudioRecordingConfiguration> hashMap = this.mRecordConfigs;
        synchronized (hashMap) {
            if (isPrivileged) {
                return new ArrayList<AudioRecordingConfiguration>(this.mRecordConfigs.values());
            }
            ArrayList<AudioRecordingConfiguration> configsPublic = this.anonymizeForPublicConsumption(new ArrayList<AudioRecordingConfiguration>(this.mRecordConfigs.values()));
            return configsPublic;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AudioRecordingConfiguration> updateSnapshot(int event, int uid, int session, int source, int[] recordingInfo) {
        ArrayList<AudioRecordingConfiguration> configs;
        HashMap<Integer, AudioRecordingConfiguration> hashMap = this.mRecordConfigs;
        synchronized (hashMap) {
            boolean configChanged;
            switch (event) {
                case 0: {
                    configChanged = this.mRecordConfigs.remove(new Integer(session)) != null;
                    break;
                }
                case 1: {
                    AudioFormat clientFormat = new AudioFormat.Builder().setEncoding(recordingInfo[0]).setChannelMask(recordingInfo[1]).setSampleRate(recordingInfo[2]).build();
                    AudioFormat deviceFormat = new AudioFormat.Builder().setEncoding(recordingInfo[3]).setChannelMask(recordingInfo[4]).setSampleRate(recordingInfo[5]).build();
                    int patchHandle = recordingInfo[6];
                    Integer sessionKey = new Integer(session);
                    String[] packages = this.mPackMan.getPackagesForUid(uid);
                    String packageName = packages != null && packages.length > 0 ? packages[0] : "";
                    AudioRecordingConfiguration updatedConfig = new AudioRecordingConfiguration(uid, session, source, clientFormat, deviceFormat, patchHandle, packageName);
                    if (this.mRecordConfigs.containsKey(sessionKey)) {
                        if (updatedConfig.equals(this.mRecordConfigs.get(sessionKey))) {
                            configChanged = false;
                            break;
                        }
                        this.mRecordConfigs.remove(sessionKey);
                        this.mRecordConfigs.put(sessionKey, updatedConfig);
                        configChanged = true;
                        break;
                    }
                    this.mRecordConfigs.put(sessionKey, updatedConfig);
                    configChanged = true;
                    break;
                }
                default: {
                    Log.e(TAG, String.format("Unknown event %d for session %d, source %d", event, session, source));
                    configChanged = false;
                }
            }
            configs = configChanged ? new ArrayList<AudioRecordingConfiguration>(this.mRecordConfigs.values()) : null;
        }
        return configs;
    }

    private static final class RecMonitorClient
    implements IBinder.DeathRecipient {
        static RecordingActivityMonitor sMonitor;
        final IRecordingConfigDispatcher mDispatcherCb;
        final boolean mIsPrivileged;

        RecMonitorClient(IRecordingConfigDispatcher rcdb, boolean isPrivileged) {
            this.mDispatcherCb = rcdb;
            this.mIsPrivileged = isPrivileged;
        }

        @Override
        public void binderDied() {
            Log.w(RecordingActivityMonitor.TAG, "client died");
            sMonitor.unregisterRecordingCallback(this.mDispatcherCb);
        }

        boolean init() {
            try {
                this.mDispatcherCb.asBinder().linkToDeath(this, 0);
                return true;
            }
            catch (RemoteException e) {
                Log.w(RecordingActivityMonitor.TAG, "Could not link to client death", e);
                return false;
            }
        }

        void release() {
            this.mDispatcherCb.asBinder().unlinkToDeath(this, 0);
        }
    }
}

