/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.autofill.ui;

import android.app.Dialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.metrics.LogMaker;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.autofill.CustomDescription;
import android.service.autofill.SaveInfo;
import android.service.autofill.ValueFinder;
import android.text.Html;
import android.util.ArraySet;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.RemoteViews;
import android.widget.ScrollView;
import android.widget.TextView;
import com.android.internal.logging.MetricsLogger;
import com.android.server.UiThread;
import com.android.server.autofill.Helper;
import com.android.server.autofill.ui.OverlayControl;
import com.android.server.autofill.ui.PendingUi;
import java.io.PrintWriter;

final class SaveUi {
    private static final String TAG = "AutofillSaveUi";
    private final Handler mHandler = UiThread.getHandler();
    private final MetricsLogger mMetricsLogger = new MetricsLogger();
    private final Dialog mDialog;
    private final OneTimeListener mListener;
    private final OverlayControl mOverlayControl;
    private final CharSequence mTitle;
    private final CharSequence mSubTitle;
    private final PendingUi mPendingUi;
    private final String mServicePackageName;
    private final String mPackageName;
    private boolean mDestroyed;

    SaveUi(Context context, final PendingUi pendingUi, CharSequence serviceLabel, Drawable serviceIcon, String servicePackageName, String packageName, SaveInfo info, ValueFinder valueFinder, OverlayControl overlayControl, OnSaveListener listener) {
        this.mPendingUi = pendingUi;
        this.mListener = new OneTimeListener(listener);
        this.mOverlayControl = overlayControl;
        this.mServicePackageName = servicePackageName;
        this.mPackageName = packageName;
        LayoutInflater inflater = LayoutInflater.from(context);
        View view = inflater.inflate(17367101, null);
        TextView titleView = (TextView)view.findViewById(16908731);
        ArraySet<String> types = new ArraySet<String>(3);
        final int type = info.getType();
        if ((type & 1) != 0) {
            types.add(context.getString(17039556));
        }
        if ((type & 2) != 0) {
            types.add(context.getString(17039553));
        }
        if ((type & 4) != 0) {
            types.add(context.getString(17039554));
        }
        if ((type & 8) != 0) {
            types.add(context.getString(17039557));
        }
        if ((type & 0x10) != 0) {
            types.add(context.getString(17039555));
        }
        switch (types.size()) {
            case 1: {
                this.mTitle = Html.fromHtml(context.getString(17039552, types.valueAt(0), serviceLabel), 0);
                break;
            }
            case 2: {
                this.mTitle = Html.fromHtml(context.getString(17039550, types.valueAt(0), types.valueAt(1), serviceLabel), 0);
                break;
            }
            case 3: {
                this.mTitle = Html.fromHtml(context.getString(17039551, types.valueAt(0), types.valueAt(1), types.valueAt(2), serviceLabel), 0);
                break;
            }
            default: {
                this.mTitle = Html.fromHtml(context.getString(17039549, serviceLabel), 0);
            }
        }
        titleView.setText(this.mTitle);
        this.setServiceIcon(context, view, serviceIcon);
        ScrollView subtitleContainer = null;
        CustomDescription customDescription = info.getCustomDescription();
        if (customDescription != null) {
            RemoteViews presentation;
            this.writeLog(1129, type);
            this.mSubTitle = null;
            if (Helper.sDebug) {
                Slog.d(TAG, "Using custom description");
            }
            if ((presentation = customDescription.getPresentation(valueFinder)) != null) {
                RemoteViews.OnClickHandler handler = new RemoteViews.OnClickHandler(){

                    @Override
                    public boolean onClickHandler(View view, PendingIntent pendingIntent, Intent intent) {
                        LogMaker log = SaveUi.this.newLogMaker(1132, type);
                        boolean isValid = SaveUi.isValidLink(pendingIntent, intent);
                        if (!isValid) {
                            log.setType(0);
                            SaveUi.this.mMetricsLogger.write(log);
                            return false;
                        }
                        if (Helper.sVerbose) {
                            Slog.v(SaveUi.TAG, "Intercepting custom description intent");
                        }
                        IBinder token = SaveUi.this.mPendingUi.getToken();
                        intent.putExtra("android.view.autofill.extra.RESTORE_SESSION_TOKEN", token);
                        try {
                            pendingUi.client.startIntentSender(pendingIntent.getIntentSender(), intent);
                            SaveUi.this.mPendingUi.setState(2);
                            if (Helper.sDebug) {
                                Slog.d(SaveUi.TAG, "hiding UI until restored with token " + token);
                            }
                            SaveUi.this.hide();
                            log.setType(1);
                            SaveUi.this.mMetricsLogger.write(log);
                            return true;
                        }
                        catch (RemoteException e) {
                            Slog.w(SaveUi.TAG, "error triggering pending intent: " + intent);
                            log.setType(11);
                            SaveUi.this.mMetricsLogger.write(log);
                            return false;
                        }
                    }
                };
                try {
                    View customSubtitleView = presentation.apply(context, null, handler);
                    subtitleContainer = (ScrollView)view.findViewById(16908728);
                    subtitleContainer.addView(customSubtitleView);
                    subtitleContainer.setVisibility(0);
                }
                catch (Exception e) {
                    Slog.e(TAG, "Could not inflate custom description. ", e);
                }
            } else {
                Slog.w(TAG, "could not create remote presentation for custom title");
            }
        } else {
            this.mSubTitle = info.getDescription();
            if (this.mSubTitle != null) {
                this.writeLog(1131, type);
                subtitleContainer = (ScrollView)view.findViewById(16908728);
                TextView subtitleView = new TextView(context);
                subtitleView.setText(this.mSubTitle);
                subtitleContainer.addView((View)subtitleView, new ViewGroup.LayoutParams(-1, -2));
                subtitleContainer.setVisibility(0);
            }
            if (Helper.sDebug) {
                Slog.d(TAG, "on constructor: title=" + this.mTitle + ", subTitle=" + this.mSubTitle);
            }
        }
        TextView noButton = (TextView)view.findViewById(16908730);
        if (info.getNegativeActionStyle() == 1) {
            noButton.setText(17040716);
        } else {
            noButton.setText(17039548);
        }
        noButton.setOnClickListener(v -> this.mListener.onCancel(info.getNegativeActionListener()));
        Object yesButton = view.findViewById(16908732);
        ((View)yesButton).setOnClickListener(v -> this.mListener.onSave());
        this.mDialog = new Dialog(context, 16974139);
        this.mDialog.setContentView(view);
        this.mDialog.setOnDismissListener(d -> this.mListener.onCancel(null));
        Window window = this.mDialog.getWindow();
        window.setType(2038);
        window.addFlags(393256);
        window.addPrivateFlags(16);
        window.setSoftInputMode(32);
        window.setGravity(81);
        window.setCloseOnTouchOutside(true);
        WindowManager.LayoutParams params = window.getAttributes();
        params.width = -1;
        params.accessibilityTitle = context.getString(17039547);
        params.windowAnimations = 16974601;
        this.show();
    }

    private void setServiceIcon(Context context, View view, Drawable serviceIcon) {
        int maxWidth;
        ImageView iconView = (ImageView)view.findViewById(16908729);
        Resources res = context.getResources();
        int maxHeight = maxWidth = res.getDimensionPixelSize(17104937);
        int actualWidth = serviceIcon.getMinimumWidth();
        int actualHeight = serviceIcon.getMinimumHeight();
        if (actualWidth <= maxWidth && actualHeight <= maxHeight) {
            if (Helper.sDebug) {
                Slog.d(TAG, "Adding service icon (" + actualWidth + "x" + actualHeight + ") as it's less than maximum " + "(" + maxWidth + "x" + maxHeight + ").");
            }
            iconView.setImageDrawable(serviceIcon);
        } else {
            Slog.w(TAG, "Not adding service icon of size (" + actualWidth + "x" + actualHeight + ") because maximum is " + "(" + maxWidth + "x" + maxHeight + ").");
            ((ViewGroup)iconView.getParent()).removeView(iconView);
        }
    }

    private static boolean isValidLink(PendingIntent pendingIntent, Intent intent) {
        if (pendingIntent == null) {
            Slog.w(TAG, "isValidLink(): custom description without pending intent");
            return false;
        }
        if (!pendingIntent.isActivity()) {
            Slog.w(TAG, "isValidLink(): pending intent not for activity");
            return false;
        }
        if (intent == null) {
            Slog.w(TAG, "isValidLink(): no intent");
            return false;
        }
        return true;
    }

    private LogMaker newLogMaker(int category, int saveType) {
        return this.newLogMaker(category).addTaggedData(1130, saveType);
    }

    private LogMaker newLogMaker(int category) {
        return new LogMaker(category).setPackageName(this.mPackageName).addTaggedData(908, this.mServicePackageName);
    }

    private void writeLog(int category, int saveType) {
        this.mMetricsLogger.write(this.newLogMaker(category, saveType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void onPendingUi(int operation, IBinder token) {
        if (!this.mPendingUi.matches(token)) {
            Slog.w("AutofillSaveUi", "restore(" + operation + "): got token " + token + " instead of " + this.mPendingUi.getToken());
            return;
        }
        log = this.newLogMaker(1134);
        try {
            switch (operation) {
                case 2: {
                    if (Helper.sDebug) {
                        Slog.d("AutofillSaveUi", "Restoring save dialog for " + token);
                    }
                    log.setType(1);
                    this.show();
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                case 1: {
                    log.setType(5);
                    if (Helper.sDebug) {
                        Slog.d("AutofillSaveUi", "Cancelling pending save dialog for " + token);
                    }
                    this.hide();
                    ** break;
lbl26:
                    // 1 sources

                    break;
                }
                default: {
                    log.setType(11);
                    Slog.w("AutofillSaveUi", "restore(): invalid operation " + operation);
                    break;
                }
            }
        }
        finally {
            this.mMetricsLogger.write(log);
        }
        this.mPendingUi.setState(4);
    }

    private void show() {
        Slog.i(TAG, "Showing save dialog: " + this.mTitle);
        this.mDialog.show();
        this.mOverlayControl.hideOverlays();
    }

    PendingUi hide() {
        if (Helper.sVerbose) {
            Slog.v(TAG, "Hiding save dialog.");
        }
        try {
            this.mDialog.hide();
        }
        finally {
            this.mOverlayControl.showOverlays();
        }
        return this.mPendingUi;
    }

    void destroy() {
        try {
            if (Helper.sDebug) {
                Slog.d(TAG, "destroy()");
            }
            this.throwIfDestroyed();
            this.mListener.onDestroy();
            this.mHandler.removeCallbacksAndMessages(this.mListener);
            this.mDialog.dismiss();
            this.mDestroyed = true;
        }
        finally {
            this.mOverlayControl.showOverlays();
        }
    }

    private void throwIfDestroyed() {
        if (this.mDestroyed) {
            throw new IllegalStateException("cannot interact with a destroyed instance");
        }
    }

    public String toString() {
        return this.mTitle == null ? "NO TITLE" : this.mTitle.toString();
    }

    void dump(PrintWriter pw, String prefix) {
        pw.print(prefix);
        pw.print("title: ");
        pw.println(this.mTitle);
        pw.print(prefix);
        pw.print("subtitle: ");
        pw.println(this.mSubTitle);
        pw.print(prefix);
        pw.print("pendingUi: ");
        pw.println(this.mPendingUi);
        pw.print(prefix);
        pw.print("service: ");
        pw.println(this.mServicePackageName);
        pw.print(prefix);
        pw.print("app: ");
        pw.println(this.mPackageName);
        View view = this.mDialog.getWindow().getDecorView();
        int[] loc = view.getLocationOnScreen();
        pw.print(prefix);
        pw.print("coordinates: ");
        pw.print('(');
        pw.print(loc[0]);
        pw.print(',');
        pw.print(loc[1]);
        pw.print(')');
        pw.print('(');
        pw.print(loc[0] + view.getWidth());
        pw.print(',');
        pw.print(loc[1] + view.getHeight());
        pw.println(')');
        pw.print(prefix);
        pw.print("destroyed: ");
        pw.println(this.mDestroyed);
    }

    private class OneTimeListener
    implements OnSaveListener {
        private final OnSaveListener mRealListener;
        private boolean mDone;

        OneTimeListener(OnSaveListener realListener) {
            this.mRealListener = realListener;
        }

        @Override
        public void onSave() {
            if (Helper.sDebug) {
                Slog.d(SaveUi.TAG, "OneTimeListener.onSave(): " + this.mDone);
            }
            if (this.mDone) {
                return;
            }
            this.mDone = true;
            this.mRealListener.onSave();
        }

        @Override
        public void onCancel(IntentSender listener) {
            if (Helper.sDebug) {
                Slog.d(SaveUi.TAG, "OneTimeListener.onCancel(): " + this.mDone);
            }
            if (this.mDone) {
                return;
            }
            this.mDone = true;
            this.mRealListener.onCancel(listener);
        }

        @Override
        public void onDestroy() {
            if (Helper.sDebug) {
                Slog.d(SaveUi.TAG, "OneTimeListener.onDestroy(): " + this.mDone);
            }
            if (this.mDone) {
                return;
            }
            this.mDone = true;
            this.mRealListener.onDestroy();
        }
    }

    public static interface OnSaveListener {
        public void onSave();

        public void onCancel(IntentSender var1);

        public void onDestroy();
    }
}

