/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public final class DataChangedJournal {
    private static final String FILE_NAME_PREFIX = "journal";
    private static final int BUFFER_SIZE_BYTES = 8192;
    private final File mFile;

    DataChangedJournal(File file) {
        this.mFile = file;
    }

    public void addPackage(String packageName) throws IOException {
        try (RandomAccessFile out = new RandomAccessFile(this.mFile, "rws");){
            out.seek(out.length());
            out.writeUTF(packageName);
        }
    }

    public void forEach(Consumer consumer) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.mFile), 8192);
             DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);){
            while (dataInputStream.available() > 0) {
                String packageName = dataInputStream.readUTF();
                consumer.accept(packageName);
            }
        }
    }

    public boolean delete() {
        return this.mFile.delete();
    }

    public boolean equals(Object object) {
        if (object instanceof DataChangedJournal) {
            DataChangedJournal that = (DataChangedJournal)object;
            try {
                return this.mFile.getCanonicalPath().equals(that.mFile.getCanonicalPath());
            }
            catch (IOException exception) {
                return false;
            }
        }
        return false;
    }

    public String toString() {
        return this.mFile.toString();
    }

    static DataChangedJournal newJournal(File journalDirectory) throws IOException {
        return new DataChangedJournal(File.createTempFile(FILE_NAME_PREFIX, null, journalDirectory));
    }

    static ArrayList<DataChangedJournal> listJournals(File journalDirectory) {
        ArrayList<DataChangedJournal> journals = new ArrayList<DataChangedJournal>();
        for (File file : journalDirectory.listFiles()) {
            journals.add(new DataChangedJournal(file));
        }
        return journals;
    }

    @FunctionalInterface
    public static interface Consumer {
        public void accept(String var1);
    }
}

