/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AppGlobals;
import android.app.IActivityManager;
import android.app.IBackupAgent;
import android.app.PendingIntent;
import android.app.backup.IBackupManager;
import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IBackupObserver;
import android.app.backup.IFullBackupRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.ISelectBackupTransportCallback;
import android.app.backup.SelectBackupTransportCallback;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.Environment;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.PowerManager;
import android.os.PowerSaveState;
import android.os.RemoteException;
import android.os.SELinux;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.os.storage.IStorageManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.AtomicFile;
import android.util.EventLog;
import android.util.Pair;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.backup.IBackupTransport;
import com.android.internal.util.DumpUtils;
import com.android.server.AppWidgetBackupBridge;
import com.android.server.SystemConfig;
import com.android.server.SystemService;
import com.android.server.backup.BackupManagerServiceInterface;
import com.android.server.backup.BackupPasswordManager;
import com.android.server.backup.BackupRestoreTask;
import com.android.server.backup.DataChangedJournal;
import com.android.server.backup.FullBackupJob;
import com.android.server.backup.KeyValueBackupJob;
import com.android.server.backup.PackageManagerBackupAgent;
import com.android.server.backup.Trampoline;
import com.android.server.backup.TransportManager;
import com.android.server.backup.fullbackup.FullBackupEntry;
import com.android.server.backup.fullbackup.PerformFullTransportBackupTask;
import com.android.server.backup.internal.BackupHandler;
import com.android.server.backup.internal.BackupRequest;
import com.android.server.backup.internal.ClearDataObserver;
import com.android.server.backup.internal.Operation;
import com.android.server.backup.internal.PerformInitializeTask;
import com.android.server.backup.internal.ProvisionedObserver;
import com.android.server.backup.internal.RunBackupReceiver;
import com.android.server.backup.internal.RunInitializeReceiver;
import com.android.server.backup.params.AdbBackupParams;
import com.android.server.backup.params.AdbParams;
import com.android.server.backup.params.AdbRestoreParams;
import com.android.server.backup.params.BackupParams;
import com.android.server.backup.params.ClearParams;
import com.android.server.backup.params.ClearRetryParams;
import com.android.server.backup.params.RestoreParams;
import com.android.server.backup.restore.ActiveRestoreSession;
import com.android.server.backup.restore.PerformUnifiedRestoreTask;
import com.android.server.backup.utils.AppBackupUtils;
import com.android.server.backup.utils.BackupManagerMonitorUtils;
import com.android.server.backup.utils.BackupObserverUtils;
import com.android.server.backup.utils.SparseArrayUtils;
import com.google.android.collect.Sets;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class RefactoredBackupManagerService
implements BackupManagerServiceInterface {
    public static final String TAG = "BackupManagerService";
    public static final boolean DEBUG = true;
    public static final boolean MORE_DEBUG = false;
    public static final boolean DEBUG_SCHEDULING = true;
    private static final String BACKUP_ENABLE_FILE = "backup_enabled";
    public static final String KEY_WIDGET_STATE = "\uffed\uffedwidget";
    public static final String BACKUP_MANIFEST_FILENAME = "_manifest";
    public static final int BACKUP_MANIFEST_VERSION = 1;
    public static final int BACKUP_FILE_VERSION = 5;
    public static final String BACKUP_FILE_HEADER_MAGIC = "ANDROID BACKUP\n";
    public static final String BACKUP_METADATA_FILENAME = "_meta";
    public static final int BACKUP_METADATA_VERSION = 1;
    public static final int BACKUP_WIDGET_METADATA_TOKEN = 33549569;
    private static final boolean COMPRESS_FULL_BACKUPS = true;
    public static final String SETTINGS_PACKAGE = "com.android.providers.settings";
    public static final String SHARED_BACKUP_AGENT_PACKAGE = "com.android.sharedstoragebackup";
    private static final String SERVICE_ACTION_TRANSPORT_HOST = "android.backup.TRANSPORT_HOST";
    private static final long TRANSPORT_RETRY_INTERVAL = 3600000L;
    public static final String RUN_BACKUP_ACTION = "android.app.backup.intent.RUN";
    public static final String RUN_INITIALIZE_ACTION = "android.app.backup.intent.INIT";
    private static final long TIMEOUT_INTERVAL = 10000L;
    public static final long TIMEOUT_BACKUP_INTERVAL = 30000L;
    public static final long TIMEOUT_FULL_BACKUP_INTERVAL = 300000L;
    public static final long TIMEOUT_SHARED_BACKUP_INTERVAL = 1800000L;
    public static final long TIMEOUT_RESTORE_INTERVAL = 60000L;
    public static final long TIMEOUT_RESTORE_FINISHED_INTERVAL = 30000L;
    private static final long TIMEOUT_FULL_CONFIRMATION = 60000L;
    private static final long MIN_FULL_BACKUP_INTERVAL = 86400000L;
    private static final long BUSY_BACKOFF_MIN_MILLIS = 3600000L;
    private static final int BUSY_BACKOFF_FUZZ = 0x6DDD00;
    private Context mContext;
    private PackageManager mPackageManager;
    private IPackageManager mPackageManagerBinder;
    private IActivityManager mActivityManager;
    private PowerManager mPowerManager;
    private AlarmManager mAlarmManager;
    private IStorageManager mStorageManager;
    private IBackupManager mBackupManagerBinder;
    private final TransportManager mTransportManager;
    private boolean mEnabled;
    private boolean mProvisioned;
    private boolean mAutoRestore;
    private PowerManager.WakeLock mWakelock;
    private HandlerThread mHandlerThread;
    private BackupHandler mBackupHandler;
    private PendingIntent mRunBackupIntent;
    private PendingIntent mRunInitIntent;
    private BroadcastReceiver mRunBackupReceiver;
    private BroadcastReceiver mRunInitReceiver;
    private final SparseArray<HashSet<String>> mBackupParticipants = new SparseArray();
    private HashMap<String, BackupRequest> mPendingBackups = new HashMap();
    public static final String PACKAGE_MANAGER_SENTINEL = "@pm@";
    private final Object mQueueLock = new Object();
    private final Object mAgentConnectLock = new Object();
    private IBackupAgent mConnectedAgent;
    private volatile boolean mBackupRunning;
    private volatile boolean mConnecting;
    private volatile long mLastBackupPass;
    public static final boolean DEBUG_BACKUP_TRACE = true;
    private final List<String> mBackupTrace = new ArrayList<String>();
    private final Object mClearDataLock = new Object();
    private volatile boolean mClearingData;
    private final BackupPasswordManager mBackupPasswordManager;
    @GuardedBy(value="mPendingRestores")
    private boolean mIsRestoreInProgress;
    @GuardedBy(value="mPendingRestores")
    private final Queue<PerformUnifiedRestoreTask> mPendingRestores = new ArrayDeque<PerformUnifiedRestoreTask>();
    private ActiveRestoreSession mActiveRestoreSession;
    private ContentObserver mProvisionedObserver;
    static Trampoline sInstance;
    public static final int OP_PENDING = 0;
    private static final int OP_ACKNOWLEDGED = 1;
    private static final int OP_TIMEOUT = -1;
    public static final int OP_TYPE_BACKUP_WAIT = 0;
    public static final int OP_TYPE_RESTORE_WAIT = 1;
    public static final int OP_TYPE_BACKUP = 2;
    @GuardedBy(value="mCurrentOpLock")
    private final SparseArray<Operation> mCurrentOperations = new SparseArray();
    private final Object mCurrentOpLock = new Object();
    private final Random mTokenGenerator = new Random();
    private final SparseArray<AdbParams> mAdbBackupRestoreConfirmations = new SparseArray();
    private File mBaseStateDir;
    private File mDataDir;
    private File mJournalDir;
    private DataChangedJournal mJournal;
    private final SecureRandom mRng = new SecureRandom();
    private File mEverStored;
    private HashSet<String> mEverStoredApps = new HashSet();
    private static final int CURRENT_ANCESTRAL_RECORD_VERSION = 1;
    private File mTokenFile;
    private Set<String> mAncestralPackages = null;
    private long mAncestralToken = 0L;
    private long mCurrentToken = 0L;
    private static final String INIT_SENTINEL_FILE_NAME = "_need_init_";
    private ArraySet<String> mPendingInits = new ArraySet();
    private static final int SCHEDULE_FILE_VERSION = 1;
    private File mFullBackupScheduleFile;
    @GuardedBy(value="mQueueLock")
    private PerformFullTransportBackupTask mRunningFullBackupTask;
    @GuardedBy(value="mQueueLock")
    private ArrayList<FullBackupEntry> mFullBackupQueue;
    private Runnable mFullBackupScheduleWriter = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = RefactoredBackupManagerService.this.mQueueLock;
            synchronized (object) {
                try {
                    ByteArrayOutputStream bufStream = new ByteArrayOutputStream(4096);
                    DataOutputStream bufOut = new DataOutputStream(bufStream);
                    bufOut.writeInt(1);
                    int N = RefactoredBackupManagerService.this.mFullBackupQueue.size();
                    bufOut.writeInt(N);
                    for (int i = 0; i < N; ++i) {
                        FullBackupEntry entry = (FullBackupEntry)RefactoredBackupManagerService.this.mFullBackupQueue.get(i);
                        bufOut.writeUTF(entry.packageName);
                        bufOut.writeLong(entry.lastBackup);
                    }
                    bufOut.flush();
                    AtomicFile af = new AtomicFile(RefactoredBackupManagerService.this.mFullBackupScheduleFile);
                    FileOutputStream out = af.startWrite();
                    out.write(bufStream.toByteArray());
                    af.finishWrite(out);
                }
                catch (Exception e) {
                    Slog.e(RefactoredBackupManagerService.TAG, "Unable to write backup schedule!", e);
                }
            }
        }
    };
    private TransportManager.TransportBoundListener mTransportBoundListener = new TransportManager.TransportBoundListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean onTransportBound(IBackupTransport transport) {
            String name = null;
            try {
                name = transport.name();
                String transportDirName = transport.transportDirName();
                File stateDir = new File(RefactoredBackupManagerService.this.mBaseStateDir, transportDirName);
                stateDir.mkdirs();
                File initSentinel = new File(stateDir, RefactoredBackupManagerService.INIT_SENTINEL_FILE_NAME);
                if (initSentinel.exists()) {
                    Object object = RefactoredBackupManagerService.this.mQueueLock;
                    synchronized (object) {
                        RefactoredBackupManagerService.this.mPendingInits.add(name);
                        long delay = 60000L;
                        RefactoredBackupManagerService.this.mAlarmManager.set(0, System.currentTimeMillis() + delay, RefactoredBackupManagerService.this.mRunInitIntent);
                    }
                }
                return true;
            }
            catch (Exception e) {
                Slog.w(RefactoredBackupManagerService.TAG, "Failed to regiser transport: " + name);
                return false;
            }
        }
    };
    private BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            boolean replacing = false;
            boolean added = false;
            boolean changed = false;
            Bundle extras = intent.getExtras();
            String[] pkgList = null;
            if ("android.intent.action.PACKAGE_ADDED".equals(action) || "android.intent.action.PACKAGE_REMOVED".equals(action) || "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                Uri uri = intent.getData();
                if (uri == null) {
                    return;
                }
                String object = uri.getSchemeSpecificPart();
                if (object != null) {
                    pkgList = new String[]{object};
                }
                if (changed = "android.intent.action.PACKAGE_CHANGED".equals(action)) {
                    String[] components = intent.getStringArrayExtra("android.intent.extra.changed_component_name_list");
                    RefactoredBackupManagerService.this.mBackupHandler.post(() -> RefactoredBackupManagerService.this.mTransportManager.onPackageChanged(pkgName, components));
                    return;
                }
                added = "android.intent.action.PACKAGE_ADDED".equals(action);
                replacing = extras.getBoolean("android.intent.extra.REPLACING", false);
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE".equals(action)) {
                added = true;
                pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            } else if ("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE".equals(action)) {
                added = false;
                pkgList = intent.getStringArrayExtra("android.intent.extra.changed_package_list");
            }
            if (pkgList == null || pkgList.length == 0) {
                return;
            }
            int uid = extras.getInt("android.intent.extra.UID");
            if (added) {
                SparseArray sparseArray = RefactoredBackupManagerService.this.mBackupParticipants;
                synchronized (sparseArray) {
                    if (replacing) {
                        RefactoredBackupManagerService.this.removePackageParticipantsLocked(pkgList, uid);
                    }
                    RefactoredBackupManagerService.this.addPackageParticipantsLocked(pkgList);
                }
                long now = System.currentTimeMillis();
                for (String packageName : pkgList) {
                    try {
                        PackageInfo app = RefactoredBackupManagerService.this.mPackageManager.getPackageInfo(packageName, 0);
                        if (AppBackupUtils.appGetsFullBackup(app) && AppBackupUtils.appIsEligibleForBackup(app.applicationInfo)) {
                            RefactoredBackupManagerService.this.enqueueFullBackup(packageName, now);
                            RefactoredBackupManagerService.this.scheduleNextFullBackupJob(0L);
                        } else {
                            Object object = RefactoredBackupManagerService.this.mQueueLock;
                            synchronized (object) {
                                RefactoredBackupManagerService.this.dequeueFullBackupLocked(packageName);
                            }
                            RefactoredBackupManagerService.this.writeFullBackupScheduleAsync();
                        }
                        RefactoredBackupManagerService.this.mBackupHandler.post(() -> RefactoredBackupManagerService.this.mTransportManager.onPackageAdded(packageName));
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.w(RefactoredBackupManagerService.TAG, "Can't resolve new app " + packageName);
                    }
                }
                RefactoredBackupManagerService.this.dataChangedImpl(RefactoredBackupManagerService.PACKAGE_MANAGER_SENTINEL);
            } else {
                if (!replacing) {
                    SparseArray sparseArray = RefactoredBackupManagerService.this.mBackupParticipants;
                    synchronized (sparseArray) {
                        RefactoredBackupManagerService.this.removePackageParticipantsLocked(pkgList, uid);
                    }
                }
                for (String pkgName : pkgList) {
                    RefactoredBackupManagerService.this.mBackupHandler.post(() -> RefactoredBackupManagerService.this.mTransportManager.onPackageRemoved(pkgName));
                }
            }
        }
    };

    static Trampoline getInstance() {
        return sInstance;
    }

    public Context getContext() {
        return this.mContext;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public PackageManager getPackageManager() {
        return this.mPackageManager;
    }

    public void setPackageManager(PackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    public IPackageManager getPackageManagerBinder() {
        return this.mPackageManagerBinder;
    }

    public void setPackageManagerBinder(IPackageManager packageManagerBinder) {
        this.mPackageManagerBinder = packageManagerBinder;
    }

    public IActivityManager getActivityManager() {
        return this.mActivityManager;
    }

    public void setActivityManager(IActivityManager activityManager) {
        this.mActivityManager = activityManager;
    }

    public AlarmManager getAlarmManager() {
        return this.mAlarmManager;
    }

    public void setAlarmManager(AlarmManager alarmManager) {
        this.mAlarmManager = alarmManager;
    }

    public void setBackupManagerBinder(IBackupManager backupManagerBinder) {
        this.mBackupManagerBinder = backupManagerBinder;
    }

    public TransportManager getTransportManager() {
        return this.mTransportManager;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    public boolean isProvisioned() {
        return this.mProvisioned;
    }

    public void setProvisioned(boolean provisioned) {
        this.mProvisioned = provisioned;
    }

    public PowerManager.WakeLock getWakelock() {
        return this.mWakelock;
    }

    public void setWakelock(PowerManager.WakeLock wakelock) {
        this.mWakelock = wakelock;
    }

    public BackupHandler getBackupHandler() {
        return this.mBackupHandler;
    }

    public void setBackupHandler(BackupHandler backupHandler) {
        this.mBackupHandler = backupHandler;
    }

    public PendingIntent getRunInitIntent() {
        return this.mRunInitIntent;
    }

    public void setRunInitIntent(PendingIntent runInitIntent) {
        this.mRunInitIntent = runInitIntent;
    }

    public HashMap<String, BackupRequest> getPendingBackups() {
        return this.mPendingBackups;
    }

    public void setPendingBackups(HashMap<String, BackupRequest> pendingBackups) {
        this.mPendingBackups = pendingBackups;
    }

    public Object getQueueLock() {
        return this.mQueueLock;
    }

    public boolean isBackupRunning() {
        return this.mBackupRunning;
    }

    public void setBackupRunning(boolean backupRunning) {
        this.mBackupRunning = backupRunning;
    }

    public long getLastBackupPass() {
        return this.mLastBackupPass;
    }

    public void setLastBackupPass(long lastBackupPass) {
        this.mLastBackupPass = lastBackupPass;
    }

    public Object getClearDataLock() {
        return this.mClearDataLock;
    }

    public boolean isClearingData() {
        return this.mClearingData;
    }

    public void setClearingData(boolean clearingData) {
        this.mClearingData = clearingData;
    }

    public boolean isRestoreInProgress() {
        return this.mIsRestoreInProgress;
    }

    public void setRestoreInProgress(boolean restoreInProgress) {
        this.mIsRestoreInProgress = restoreInProgress;
    }

    public Queue<PerformUnifiedRestoreTask> getPendingRestores() {
        return this.mPendingRestores;
    }

    public ActiveRestoreSession getActiveRestoreSession() {
        return this.mActiveRestoreSession;
    }

    public void setActiveRestoreSession(ActiveRestoreSession activeRestoreSession) {
        this.mActiveRestoreSession = activeRestoreSession;
    }

    public SparseArray<Operation> getCurrentOperations() {
        return this.mCurrentOperations;
    }

    public Object getCurrentOpLock() {
        return this.mCurrentOpLock;
    }

    public SparseArray<AdbParams> getAdbBackupRestoreConfirmations() {
        return this.mAdbBackupRestoreConfirmations;
    }

    public File getBaseStateDir() {
        return this.mBaseStateDir;
    }

    public void setBaseStateDir(File baseStateDir) {
        this.mBaseStateDir = baseStateDir;
    }

    public File getDataDir() {
        return this.mDataDir;
    }

    public void setDataDir(File dataDir) {
        this.mDataDir = dataDir;
    }

    public DataChangedJournal getJournal() {
        return this.mJournal;
    }

    public void setJournal(DataChangedJournal journal) {
        this.mJournal = journal;
    }

    public SecureRandom getRng() {
        return this.mRng;
    }

    public Set<String> getAncestralPackages() {
        return this.mAncestralPackages;
    }

    public void setAncestralPackages(Set<String> ancestralPackages) {
        this.mAncestralPackages = ancestralPackages;
    }

    public long getAncestralToken() {
        return this.mAncestralToken;
    }

    public void setAncestralToken(long ancestralToken) {
        this.mAncestralToken = ancestralToken;
    }

    public long getCurrentToken() {
        return this.mCurrentToken;
    }

    public void setCurrentToken(long currentToken) {
        this.mCurrentToken = currentToken;
    }

    public ArraySet<String> getPendingInits() {
        return this.mPendingInits;
    }

    public void clearPendingInits() {
        this.mPendingInits.clear();
    }

    public PerformFullTransportBackupTask getRunningFullBackupTask() {
        return this.mRunningFullBackupTask;
    }

    public void setRunningFullBackupTask(PerformFullTransportBackupTask runningFullBackupTask) {
        this.mRunningFullBackupTask = runningFullBackupTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generateRandomIntegerToken() {
        int token;
        do {
            Random random = this.mTokenGenerator;
            synchronized (random) {
                token = this.mTokenGenerator.nextInt();
            }
        } while (token < 0);
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBackupTrace(String s) {
        List<String> list = this.mBackupTrace;
        synchronized (list) {
            this.mBackupTrace.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBackupTrace() {
        List<String> list = this.mBackupTrace;
        synchronized (list) {
            this.mBackupTrace.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoredBackupManagerService(Context context, Trampoline parent) {
        this.mContext = context;
        this.mPackageManager = context.getPackageManager();
        this.mPackageManagerBinder = AppGlobals.getPackageManager();
        this.mActivityManager = ActivityManager.getService();
        this.mAlarmManager = (AlarmManager)context.getSystemService("alarm");
        this.mPowerManager = (PowerManager)context.getSystemService("power");
        this.mStorageManager = IStorageManager.Stub.asInterface(ServiceManager.getService("mount"));
        this.mBackupManagerBinder = Trampoline.asInterface(parent.asBinder());
        this.mHandlerThread = new HandlerThread("backup", 10);
        this.mHandlerThread.start();
        this.mBackupHandler = new BackupHandler(this, this.mHandlerThread.getLooper());
        ContentResolver resolver = context.getContentResolver();
        this.mProvisioned = Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
        this.mAutoRestore = Settings.Secure.getInt(resolver, "backup_auto_restore", 1) != 0;
        this.mProvisionedObserver = new ProvisionedObserver(this, this.mBackupHandler);
        resolver.registerContentObserver(Settings.Global.getUriFor("device_provisioned"), false, this.mProvisionedObserver);
        this.mBaseStateDir = new File(Environment.getDataDirectory(), "backup");
        this.mBaseStateDir.mkdirs();
        if (!SELinux.restorecon(this.mBaseStateDir)) {
            Slog.e(TAG, "SELinux restorecon failed on " + this.mBaseStateDir);
        }
        this.mDataDir = new File(Environment.getDownloadCacheDirectory(), "backup_stage");
        this.mBackupPasswordManager = new BackupPasswordManager(this.mContext, this.mBaseStateDir, this.mRng);
        this.mRunBackupReceiver = new RunBackupReceiver(this);
        IntentFilter filter = new IntentFilter();
        filter.addAction(RUN_BACKUP_ACTION);
        context.registerReceiver(this.mRunBackupReceiver, filter, "android.permission.BACKUP", null);
        this.mRunInitReceiver = new RunInitializeReceiver(this);
        filter = new IntentFilter();
        filter.addAction(RUN_INITIALIZE_ACTION);
        context.registerReceiver(this.mRunInitReceiver, filter, "android.permission.BACKUP", null);
        Intent backupIntent = new Intent(RUN_BACKUP_ACTION);
        backupIntent.addFlags(0x40000000);
        this.mRunBackupIntent = PendingIntent.getBroadcast(context, 0, backupIntent, 0);
        Intent initIntent = new Intent(RUN_INITIALIZE_ACTION);
        initIntent.addFlags(0x40000000);
        this.mRunInitIntent = PendingIntent.getBroadcast(context, 0, initIntent, 0);
        this.mJournalDir = new File(this.mBaseStateDir, "pending");
        this.mJournalDir.mkdirs();
        this.mJournal = null;
        this.mFullBackupScheduleFile = new File(this.mBaseStateDir, "fb-schedule");
        this.initPackageTracking();
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            this.addPackageParticipantsLocked(null);
        }
        SystemConfig systemConfig = SystemConfig.getInstance();
        ArraySet<ComponentName> transportWhitelist = systemConfig.getBackupTransportWhitelist();
        String transport = Settings.Secure.getString(context.getContentResolver(), "backup_transport");
        if (TextUtils.isEmpty(transport)) {
            transport = null;
        }
        String currentTransport = transport;
        Slog.v(TAG, "Starting with transport " + currentTransport);
        this.mTransportManager = new TransportManager(context, transportWhitelist, currentTransport, this.mTransportBoundListener, this.mHandlerThread.getLooper());
        this.mTransportManager.registerAllTransports();
        this.mBackupHandler.post(() -> this.parseLeftoverJournals());
        this.mWakelock = this.mPowerManager.newWakeLock(1, "*backup*");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void initPackageTracking() {
        this.mTokenFile = new File(this.mBaseStateDir, "ancestral");
        try {
            tf = new RandomAccessFile(this.mTokenFile, "r");
            var2_4 = null;
            try {
                version = tf.readInt();
                if (version == 1) {
                    this.mAncestralToken = tf.readLong();
                    this.mCurrentToken = tf.readLong();
                    numPackages = tf.readInt();
                    if (numPackages >= 0) {
                        this.mAncestralPackages = new HashSet<String>();
                        for (i = 0; i < numPackages; ++i) {
                            pkgName = tf.readUTF();
                            this.mAncestralPackages.add(pkgName);
                        }
                    }
                }
            }
            catch (Throwable version) {
                var2_4 = version;
                throw version;
            }
            finally {
                if (tf != null) {
                    if (var2_4 != null) {
                        try {
                            tf.close();
                        }
                        catch (Throwable version) {
                            var2_4.addSuppressed(version);
                        }
                    } else {
                        tf.close();
                    }
                }
            }
        }
        catch (FileNotFoundException fnf) {
            Slog.v("BackupManagerService", "No ancestral data");
        }
        catch (IOException e) {
            Slog.w("BackupManagerService", "Unable to read token file", e);
        }
        this.mEverStored = new File(this.mBaseStateDir, "processed");
        tempProcessedFile = new File(this.mBaseStateDir, "processed.new");
        if (tempProcessedFile.exists()) {
            tempProcessedFile.delete();
        }
        if (this.mEverStored.exists()) {
            try {
                temp = new RandomAccessFile(tempProcessedFile, "rws");
                version = null;
                try {
                    try {
                        in = new RandomAccessFile(this.mEverStored, "r");
                        var5_16 = null;
                        block33: while (true) lbl-1000:
                        // 2 sources

                        {
                            try {
                                try {
                                    while (true) {
                                        pkg = in.readUTF();
                                        try {
                                            this.mPackageManager.getPackageInfo(pkg, 0);
                                            this.mEverStoredApps.add(pkg);
                                            temp.writeUTF(pkg);
                                            continue block33;
                                        }
                                        catch (PackageManager.NameNotFoundException var7_20) {
                                            continue;
                                        }
                                        break;
                                    }
                                }
                                catch (Throwable var6_18) {
                                    var5_16 = var6_18;
                                    throw var6_18;
                                }
                            }
                            catch (Throwable var9_22) {
                                if (in != null) {
                                    if (var5_16 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable var10_23) {
                                            var5_16.addSuppressed(var10_23);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                throw var9_22;
                            }
                            break;
                        }
                    }
                    catch (Throwable var4_14) {
                        version = var4_14;
                        throw var4_14;
                    }
                    {
                        ** while (true)
                    }
                }
                catch (Throwable var11_24) {
                    if (temp != null) {
                        if (version != null) {
                            try {
                                temp.close();
                            }
                            catch (Throwable var12_25) {
                                version.addSuppressed(var12_25);
                            }
                        } else {
                            temp.close();
                        }
                    }
                    throw var11_24;
                }
            }
            catch (EOFException e) {
                if (!tempProcessedFile.renameTo(this.mEverStored)) {
                    Slog.e("BackupManagerService", "Error renaming " + tempProcessedFile + " to " + this.mEverStored);
                }
            }
            catch (IOException e) {
                Slog.e("BackupManagerService", "Error in processed file", e);
            }
        }
        e = this.mQueueLock;
        synchronized (e) {
            this.mFullBackupQueue = this.readFullBackupSchedule();
        }
        filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_ADDED");
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addAction("android.intent.action.PACKAGE_CHANGED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(this.mBroadcastReceiver, filter);
        sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(this.mBroadcastReceiver, sdFilter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList<FullBackupEntry> readFullBackupSchedule() {
        boolean changed = false;
        ArrayList<FullBackupEntry> schedule = null;
        List<PackageInfo> apps = PackageManagerBackupAgent.getStorableApplications(this.mPackageManager);
        if (this.mFullBackupScheduleFile.exists()) {
            try (FileInputStream fstream = new FileInputStream(this.mFullBackupScheduleFile);
                 BufferedInputStream bufStream = new BufferedInputStream(fstream);
                 DataInputStream in = new DataInputStream(bufStream);){
                int version = in.readInt();
                if (version != 1) {
                    Slog.e(TAG, "Unknown backup schedule version " + version);
                    ArrayList<FullBackupEntry> arrayList = null;
                    return arrayList;
                }
                int N = in.readInt();
                schedule = new ArrayList(N);
                HashSet<String> foundApps = new HashSet<String>(N);
                for (int i = 0; i < N; ++i) {
                    String pkgName = in.readUTF();
                    long lastBackup = in.readLong();
                    foundApps.add(pkgName);
                    try {
                        PackageInfo pkg = this.mPackageManager.getPackageInfo(pkgName, 0);
                        if (AppBackupUtils.appGetsFullBackup(pkg) && AppBackupUtils.appIsEligibleForBackup(pkg.applicationInfo)) {
                            schedule.add(new FullBackupEntry(pkgName, lastBackup));
                            continue;
                        }
                        Slog.i(TAG, "Package " + pkgName + " no longer eligible for full backup");
                        continue;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Slog.i(TAG, "Package " + pkgName + " not installed; dropping from full backup");
                    }
                }
                for (PackageInfo app : apps) {
                    if (!AppBackupUtils.appGetsFullBackup(app) || !AppBackupUtils.appIsEligibleForBackup(app.applicationInfo) || foundApps.contains(app.packageName)) continue;
                    schedule.add(new FullBackupEntry(app.packageName, 0L));
                    changed = true;
                }
                Collections.sort(schedule);
            }
            catch (Exception e) {
                Slog.e(TAG, "Unable to read backup schedule", e);
                this.mFullBackupScheduleFile.delete();
                schedule = null;
            }
        }
        if (schedule == null) {
            changed = true;
            schedule = new ArrayList<FullBackupEntry>(apps.size());
            for (PackageInfo info : apps) {
                if (!AppBackupUtils.appGetsFullBackup(info) || !AppBackupUtils.appIsEligibleForBackup(info.applicationInfo)) continue;
                schedule.add(new FullBackupEntry(info.packageName, 0L));
            }
        }
        if (!changed) return schedule;
        this.writeFullBackupScheduleAsync();
        return schedule;
    }

    private void writeFullBackupScheduleAsync() {
        this.mBackupHandler.removeCallbacks(this.mFullBackupScheduleWriter);
        this.mBackupHandler.post(this.mFullBackupScheduleWriter);
    }

    private void parseLeftoverJournals() {
        ArrayList<DataChangedJournal> journals = DataChangedJournal.listJournals(this.mJournalDir);
        for (DataChangedJournal journal : journals) {
            if (journal.equals(this.mJournal)) continue;
            try {
                journal.forEach(packageName -> {
                    Slog.i(TAG, "Found stale backup journal, scheduling");
                    this.dataChangedImpl(packageName);
                });
            }
            catch (IOException e) {
                Slog.e(TAG, "Can't read " + journal, e);
            }
        }
    }

    public byte[] randomBytes(int bits) {
        byte[] array2 = new byte[bits / 8];
        this.mRng.nextBytes(array2);
        return array2;
    }

    @Override
    public boolean setBackupPassword(String currentPw, String newPw) {
        return this.mBackupPasswordManager.setBackupPassword(currentPw, newPw);
    }

    @Override
    public boolean hasBackupPassword() {
        return this.mBackupPasswordManager.hasBackupPassword();
    }

    public boolean backupPasswordMatches(String currentPw) {
        return this.mBackupPasswordManager.backupPasswordMatches(currentPw);
    }

    public void recordInitPendingLocked(boolean isPending, String transportName) {
        this.mBackupHandler.removeMessages(11);
        try {
            IBackupTransport transport = this.mTransportManager.getTransportBinder(transportName);
            if (transport != null) {
                String transportDirName = transport.transportDirName();
                File stateDir = new File(this.mBaseStateDir, transportDirName);
                File initPendingFile = new File(stateDir, INIT_SENTINEL_FILE_NAME);
                if (isPending) {
                    this.mPendingInits.add(transportName);
                    try {
                        new FileOutputStream(initPendingFile).close();
                    }
                    catch (IOException iOException) {}
                } else {
                    initPendingFile.delete();
                    this.mPendingInits.remove(transportName);
                }
                return;
            }
        }
        catch (Exception e) {
            Slog.e(TAG, "Transport " + transportName + " failed to report name: " + e.getMessage());
        }
        if (isPending) {
            this.mPendingInits.add(transportName);
            this.mBackupHandler.sendMessageDelayed(this.mBackupHandler.obtainMessage(11, isPending ? 1 : 0, 0, transportName), 3600000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBackupState(File stateFileDir) {
        SparseArray<HashSet<String>> sparseArray = this.mQueueLock;
        synchronized (sparseArray) {
            this.mEverStoredApps.clear();
            this.mEverStored.delete();
            this.mCurrentToken = 0L;
            this.writeRestoreTokens();
            for (File sf : stateFileDir.listFiles()) {
                if (sf.getName().equals(INIT_SENTINEL_FILE_NAME)) continue;
                sf.delete();
            }
        }
        sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            int N = this.mBackupParticipants.size();
            for (int i = 0; i < N; ++i) {
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                if (participants == null) continue;
                for (String packageName : participants) {
                    this.dataChangedImpl(packageName);
                }
            }
        }
    }

    private void addPackageParticipantsLocked(String[] packageNames) {
        List<PackageInfo> targetApps = this.allAgentPackages();
        if (packageNames != null) {
            for (String packageName : packageNames) {
                this.addPackageParticipantsLockedInner(packageName, targetApps);
            }
        } else {
            this.addPackageParticipantsLockedInner(null, targetApps);
        }
    }

    private void addPackageParticipantsLockedInner(String packageName, List<PackageInfo> targetPkgs) {
        for (PackageInfo pkg : targetPkgs) {
            if (packageName != null && !pkg.packageName.equals(packageName)) continue;
            int uid = pkg.applicationInfo.uid;
            HashSet<String> set = this.mBackupParticipants.get(uid);
            if (set == null) {
                set = new HashSet();
                this.mBackupParticipants.put(uid, set);
            }
            set.add(pkg.packageName);
            Message msg = this.mBackupHandler.obtainMessage(16, pkg.packageName);
            this.mBackupHandler.sendMessage(msg);
        }
    }

    private void removePackageParticipantsLocked(String[] packageNames, int oldUid) {
        if (packageNames == null) {
            Slog.w(TAG, "removePackageParticipants with null list");
            return;
        }
        for (String pkg : packageNames) {
            HashSet<String> set = this.mBackupParticipants.get(oldUid);
            if (set == null || !set.contains(pkg)) continue;
            this.removePackageFromSetLocked(set, pkg);
            if (!set.isEmpty()) continue;
            this.mBackupParticipants.remove(oldUid);
        }
    }

    private void removePackageFromSetLocked(HashSet<String> set, String packageName) {
        if (set.contains(packageName)) {
            set.remove(packageName);
            this.mPendingBackups.remove(packageName);
        }
    }

    private List<PackageInfo> allAgentPackages() {
        int flags = 64;
        List<PackageInfo> packages = this.mPackageManager.getInstalledPackages(flags);
        int N = packages.size();
        for (int a = N - 1; a >= 0; --a) {
            PackageInfo pkg = packages.get(a);
            try {
                ApplicationInfo app = pkg.applicationInfo;
                if ((app.flags & 0x8000) == 0 || app.backupAgentName == null || (app.flags & 0x4000000) != 0) {
                    packages.remove(a);
                    continue;
                }
                app = this.mPackageManager.getApplicationInfo(pkg.packageName, 1024);
                pkg.applicationInfo.sharedLibraryFiles = app.sharedLibraryFiles;
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                packages.remove(a);
            }
        }
        return packages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logBackupComplete(String packageName) {
        if (packageName.equals(PACKAGE_MANAGER_SENTINEL)) {
            return;
        }
        HashSet<String> hashSet = this.mEverStoredApps;
        synchronized (hashSet) {
            if (!this.mEverStoredApps.add(packageName)) {
                return;
            }
            try (RandomAccessFile out = new RandomAccessFile(this.mEverStored, "rws");){
                out.seek(out.length());
                out.writeUTF(packageName);
            }
            catch (IOException e) {
                Slog.e(TAG, "Can't log backup of " + packageName + " to " + this.mEverStored);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEverBackedUp(String packageName) {
        Slog.v(TAG, "Removing backed-up knowledge of " + packageName);
        HashSet<String> hashSet = this.mEverStoredApps;
        synchronized (hashSet) {
            File tempKnownFile = new File(this.mBaseStateDir, "processed.new");
            try (RandomAccessFile known = new RandomAccessFile(tempKnownFile, "rws");){
                this.mEverStoredApps.remove(packageName);
                for (String s : this.mEverStoredApps) {
                    known.writeUTF(s);
                }
                known.close();
                if (!tempKnownFile.renameTo(this.mEverStored)) {
                    throw new IOException("Can't rename " + tempKnownFile + " to " + this.mEverStored);
                }
            }
            catch (IOException e) {
                Slog.w(TAG, "Error rewriting " + this.mEverStored, e);
                this.mEverStoredApps.clear();
                tempKnownFile.delete();
                this.mEverStored.delete();
            }
        }
    }

    public void writeRestoreTokens() {
        try (RandomAccessFile af = new RandomAccessFile(this.mTokenFile, "rwd");){
            af.writeInt(1);
            af.writeLong(this.mAncestralToken);
            af.writeLong(this.mCurrentToken);
            if (this.mAncestralPackages == null) {
                af.writeInt(-1);
            } else {
                af.writeInt(this.mAncestralPackages.size());
                Slog.v(TAG, "Ancestral packages:  " + this.mAncestralPackages.size());
                for (String pkgName : this.mAncestralPackages) {
                    af.writeUTF(pkgName);
                }
            }
        }
        catch (IOException e) {
            Slog.w(TAG, "Unable to write token file:", e);
        }
    }

    private String getTransportName(IBackupTransport transport) {
        return this.mTransportManager.getTransportName(transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBackupAgent bindToAgentSynchronous(ApplicationInfo app, int mode) {
        IBackupAgent agent = null;
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            this.mConnecting = true;
            this.mConnectedAgent = null;
            try {
                if (this.mActivityManager.bindBackupAgent(app.packageName, mode, 0)) {
                    Slog.d(TAG, "awaiting agent for " + app);
                    long timeoutMark = System.currentTimeMillis() + 10000L;
                    while (this.mConnecting && this.mConnectedAgent == null && System.currentTimeMillis() < timeoutMark) {
                        try {
                            this.mAgentConnectLock.wait(5000L);
                        }
                        catch (InterruptedException e) {
                            Slog.w(TAG, "Interrupted: " + e);
                            this.mConnecting = false;
                            this.mConnectedAgent = null;
                        }
                    }
                    if (this.mConnecting) {
                        Slog.w(TAG, "Timeout waiting for agent " + app);
                        this.mConnectedAgent = null;
                    }
                    Slog.i(TAG, "got agent " + this.mConnectedAgent);
                    agent = this.mConnectedAgent;
                }
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        if (agent == null) {
            try {
                this.mActivityManager.clearPendingBackup();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return agent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearApplicationDataSynchronous(String packageName) {
        try {
            PackageInfo info = this.mPackageManager.getPackageInfo(packageName, 0);
            if ((info.applicationInfo.flags & 0x40) == 0) {
                return;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.w(TAG, "Tried to clear data for " + packageName + " but not found");
            return;
        }
        ClearDataObserver observer = new ClearDataObserver(this);
        Object object = this.mClearDataLock;
        synchronized (object) {
            this.mClearingData = true;
            try {
                this.mActivityManager.clearApplicationUserData(packageName, observer, 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            long timeoutMark = System.currentTimeMillis() + 10000L;
            while (this.mClearingData && System.currentTimeMillis() < timeoutMark) {
                try {
                    this.mClearDataLock.wait(5000L);
                }
                catch (InterruptedException e) {
                    this.mClearingData = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailableRestoreToken(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getAvailableRestoreToken");
        long token = this.mAncestralToken;
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mEverStoredApps.contains(packageName)) {
                token = this.mCurrentToken;
            }
        }
        return token;
    }

    @Override
    public int requestBackup(String[] packages, IBackupObserver observer, int flags) {
        return this.requestBackup(packages, observer, null, flags);
    }

    @Override
    public int requestBackup(String[] packages, IBackupObserver observer, IBackupManagerMonitor monitor, int flags) {
        String dirName;
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "requestBackup");
        if (packages == null || packages.length < 1) {
            Slog.e(TAG, "No packages named for backup request");
            BackupObserverUtils.sendBackupFinished(observer, -1000);
            monitor = BackupManagerMonitorUtils.monitorEvent(monitor, 49, null, 1, null);
            throw new IllegalArgumentException("No packages are provided for backup");
        }
        if (!this.mEnabled || !this.mProvisioned) {
            Slog.i(TAG, "Backup requested but e=" + this.mEnabled + " p=" + this.mProvisioned);
            BackupObserverUtils.sendBackupFinished(observer, -2001);
            int logTag = this.mProvisioned ? 13 : 14;
            monitor = BackupManagerMonitorUtils.monitorEvent(monitor, logTag, null, 3, null);
            return -2001;
        }
        IBackupTransport transport = this.mTransportManager.getCurrentTransportBinder();
        if (transport == null) {
            BackupObserverUtils.sendBackupFinished(observer, -1000);
            monitor = BackupManagerMonitorUtils.monitorEvent(monitor, 50, null, 1, null);
            return -1000;
        }
        ArrayList<String> fullBackupList = new ArrayList<String>();
        ArrayList<String> kvBackupList = new ArrayList<String>();
        for (String packageName : packages) {
            if (PACKAGE_MANAGER_SENTINEL.equals(packageName)) {
                kvBackupList.add(packageName);
                continue;
            }
            try {
                PackageInfo packageInfo = this.mPackageManager.getPackageInfo(packageName, 64);
                if (!AppBackupUtils.appIsEligibleForBackup(packageInfo.applicationInfo)) {
                    BackupObserverUtils.sendBackupOnPackageResult(observer, packageName, -2001);
                    continue;
                }
                if (AppBackupUtils.appGetsFullBackup(packageInfo)) {
                    fullBackupList.add(packageInfo.packageName);
                    continue;
                }
                kvBackupList.add(packageInfo.packageName);
            }
            catch (PackageManager.NameNotFoundException e) {
                BackupObserverUtils.sendBackupOnPackageResult(observer, packageName, -2002);
            }
        }
        EventLog.writeEvent(2828, packages.length, kvBackupList.size(), fullBackupList.size());
        try {
            dirName = transport.transportDirName();
        }
        catch (Exception e) {
            Slog.e(TAG, "Transport unavailable while attempting backup: " + e.getMessage());
            BackupObserverUtils.sendBackupFinished(observer, -1000);
            return -1000;
        }
        boolean nonIncrementalBackup = (flags & 1) != 0;
        Message msg = this.mBackupHandler.obtainMessage(15);
        msg.obj = new BackupParams(transport, dirName, kvBackupList, fullBackupList, observer, monitor, true, nonIncrementalBackup);
        this.mBackupHandler.sendMessage(msg);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelBackups() {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "cancelBackups");
        long oldToken = Binder.clearCallingIdentity();
        try {
            ArrayList<Integer> operationsToCancel = new ArrayList<Integer>();
            Iterator iterator = this.mCurrentOpLock;
            synchronized (iterator) {
                for (int i = 0; i < this.mCurrentOperations.size(); ++i) {
                    Operation op = this.mCurrentOperations.valueAt(i);
                    int token = this.mCurrentOperations.keyAt(i);
                    if (op.type != 2) continue;
                    operationsToCancel.add(token);
                }
            }
            for (Integer token : operationsToCancel) {
                this.handleCancel(token, true);
            }
            KeyValueBackupJob.schedule(this.mContext, 3600000L);
            FullBackupJob.schedule(this.mContext, 0x6DDD00L);
        }
        finally {
            Binder.restoreCallingIdentity(oldToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepareOperationTimeout(int token, long interval, BackupRestoreTask callback, int operationType) {
        if (operationType != 0 && operationType != 1) {
            Slog.wtf(TAG, "prepareOperationTimeout() doesn't support operation " + Integer.toHexString(token) + " of type " + operationType);
            return;
        }
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            this.mCurrentOperations.put(token, new Operation(0, callback, operationType));
            Message msg = this.mBackupHandler.obtainMessage(this.getMessageIdForOperationType(operationType), token, 0, callback);
            this.mBackupHandler.sendMessageDelayed(msg, interval);
        }
    }

    private int getMessageIdForOperationType(int operationType) {
        switch (operationType) {
            case 0: {
                return 17;
            }
            case 1: {
                return 18;
            }
        }
        Slog.wtf(TAG, "getMessageIdForOperationType called on invalid operation type: " + operationType);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOperation(int token) {
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            if (this.mCurrentOperations.get(token) == null) {
                Slog.w(TAG, "Duplicate remove for operation. token=" + Integer.toHexString(token));
            }
            this.mCurrentOperations.remove(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitUntilOperationComplete(int token) {
        int finalState = 0;
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            while ((op = this.mCurrentOperations.get(token)) != null) {
                if (op.state == 0) {
                    try {
                        this.mCurrentOpLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                finalState = op.state;
                break;
            }
        }
        this.removeOperation(token);
        if (op != null) {
            this.mBackupHandler.removeMessages(this.getMessageIdForOperationType(op.type));
        }
        return finalState == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCancel(int token, boolean cancelAll) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            int state;
            op = this.mCurrentOperations.get(token);
            int n = state = op != null ? op.state : -1;
            if (state == 1) {
                Slog.w(TAG, "Operation already got an ack.Should have been removed from mCurrentOperations.");
                op = null;
                this.mCurrentOperations.delete(token);
            } else if (state == 0) {
                Slog.v(TAG, "Cancel: token=" + Integer.toHexString(token));
                op.state = -1;
                this.mBackupHandler.removeMessages(this.getMessageIdForOperationType(op.type));
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            op.callback.handleCancel(cancelAll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBackupOperationInProgress() {
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            for (int i = 0; i < this.mCurrentOperations.size(); ++i) {
                Operation op = this.mCurrentOperations.valueAt(i);
                if (op.type != 2 || op.state != 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void tearDownAgentAndKill(ApplicationInfo app) {
        if (app == null) {
            return;
        }
        try {
            this.mActivityManager.unbindBackupAgent(app);
            if (app.uid >= 10000 && !app.packageName.equals("com.android.backupconfirm")) {
                this.mActivityManager.killApplicationProcess(app.processName, app.uid);
            }
        }
        catch (RemoteException e) {
            Slog.d(TAG, "Lost app trying to shut down");
        }
    }

    public boolean deviceIsEncrypted() {
        try {
            return this.mStorageManager.getEncryptionState() != 1 && this.mStorageManager.getPasswordType() != 1;
        }
        catch (Exception e) {
            Slog.e(TAG, "Unable to communicate with storagemanager service: " + e.getMessage());
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleNextFullBackupJob(long transportMinLatency) {
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mFullBackupQueue.size() > 0) {
                long upcomingLastBackup = this.mFullBackupQueue.get((int)0).lastBackup;
                long timeSinceLast = System.currentTimeMillis() - upcomingLastBackup;
                long appLatency = timeSinceLast < 86400000L ? 86400000L - timeSinceLast : 0L;
                final long latency = Math.max(transportMinLatency, appLatency);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        FullBackupJob.schedule(RefactoredBackupManagerService.this.mContext, latency);
                    }
                };
                this.mBackupHandler.postDelayed(r, 2500L);
            } else {
                Slog.i(TAG, "Full backup queue empty; not scheduling");
            }
        }
    }

    private void dequeueFullBackupLocked(String packageName) {
        int N = this.mFullBackupQueue.size();
        for (int i = N - 1; i >= 0; --i) {
            FullBackupEntry e = this.mFullBackupQueue.get(i);
            if (!packageName.equals(e.packageName)) continue;
            this.mFullBackupQueue.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueFullBackup(String packageName, long lastBackedUp) {
        FullBackupEntry newEntry = new FullBackupEntry(packageName, lastBackedUp);
        Object object = this.mQueueLock;
        synchronized (object) {
            this.dequeueFullBackupLocked(packageName);
            int which = -1;
            if (lastBackedUp > 0L) {
                for (which = this.mFullBackupQueue.size() - 1; which >= 0; --which) {
                    FullBackupEntry entry = this.mFullBackupQueue.get(which);
                    if (entry.lastBackup > lastBackedUp) continue;
                    this.mFullBackupQueue.add(which + 1, newEntry);
                    break;
                }
            }
            if (which < 0) {
                this.mFullBackupQueue.add(0, newEntry);
            }
        }
        this.writeFullBackupScheduleAsync();
    }

    private boolean fullBackupAllowable(IBackupTransport transport) {
        if (transport == null) {
            Slog.w(TAG, "Transport not present; full data backup not performed");
            return false;
        }
        try {
            File stateDir = new File(this.mBaseStateDir, transport.transportDirName());
            File pmState = new File(stateDir, PACKAGE_MANAGER_SENTINEL);
            if (pmState.length() <= 0L) {
                Slog.i(TAG, "Full backup requested but dataset not yet initialized");
                return false;
            }
        }
        catch (Exception e) {
            Slog.w(TAG, "Unable to get transport name: " + e.getMessage());
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean beginFullBackup(FullBackupJob scheduledJob) {
        long now = System.currentTimeMillis();
        FullBackupEntry entry = null;
        long latency = 86400000L;
        if (!this.mEnabled || !this.mProvisioned) {
            return false;
        }
        PowerSaveState result = this.mPowerManager.getPowerSaveState(4);
        if (result.batterySaverEnabled) {
            Slog.i(TAG, "Deferring scheduled full backups in battery saver mode");
            FullBackupJob.schedule(this.mContext, 14400000L);
            return false;
        }
        Slog.i(TAG, "Beginning scheduled full backup operation");
        Object object = this.mQueueLock;
        synchronized (object) {
            boolean headBusy;
            if (this.mRunningFullBackupTask != null) {
                Slog.e(TAG, "Backup triggered but one already/still running!");
                return false;
            }
            boolean runBackup = true;
            do {
                if (this.mFullBackupQueue.size() == 0) {
                    Slog.i(TAG, "Backup queue empty; doing nothing");
                    runBackup = false;
                    break;
                }
                headBusy = false;
                if (!this.fullBackupAllowable(this.mTransportManager.getCurrentTransportBinder())) {
                    runBackup = false;
                    latency = 14400000L;
                }
                if (!runBackup) continue;
                entry = this.mFullBackupQueue.get(0);
                long timeSinceRun = now - entry.lastBackup;
                boolean bl = runBackup = timeSinceRun >= 86400000L;
                if (!runBackup) {
                    latency = 86400000L - timeSinceRun;
                    break;
                }
                try {
                    PackageInfo appInfo = this.mPackageManager.getPackageInfo(entry.packageName, 0);
                    if (!AppBackupUtils.appGetsFullBackup(appInfo)) {
                        this.mFullBackupQueue.remove(0);
                        headBusy = true;
                        continue;
                    }
                    int privFlags = appInfo.applicationInfo.privateFlags;
                    boolean bl2 = headBusy = (privFlags & 0x2000) == 0 && this.mActivityManager.isAppForeground(appInfo.applicationInfo.uid);
                    if (!headBusy) continue;
                    long nextEligible = System.currentTimeMillis() + 3600000L + (long)this.mTokenGenerator.nextInt(0x6DDD00);
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Slog.i(TAG, "Full backup time but " + entry.packageName + " is busy; deferring to " + sdf.format(new Date(nextEligible)));
                    this.enqueueFullBackup(entry.packageName, nextEligible - 86400000L);
                }
                catch (PackageManager.NameNotFoundException nnf) {
                    runBackup = this.mFullBackupQueue.size() > 1;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            } while (headBusy);
            if (!runBackup) {
                Slog.i(TAG, "Nothing pending full backup; rescheduling +" + latency);
                final long deferTime = latency;
                this.mBackupHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        FullBackupJob.schedule(RefactoredBackupManagerService.this.mContext, deferTime);
                    }
                });
                return false;
            }
            this.mFullBackupQueue.remove(0);
            CountDownLatch latch = new CountDownLatch(1);
            String[] pkg = new String[]{entry.packageName};
            this.mRunningFullBackupTask = new PerformFullTransportBackupTask(this, null, pkg, true, scheduledJob, latch, null, null, false);
            this.mWakelock.acquire();
            new Thread(this.mRunningFullBackupTask).start();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endFullBackup() {
        Object object = this.mQueueLock;
        synchronized (object) {
            if (this.mRunningFullBackupTask != null) {
                Slog.i(TAG, "Telling running backup to stop");
                this.mRunningFullBackupTask.handleCancel(true);
            }
        }
    }

    public void restoreWidgetData(String packageName, byte[] widgetData) {
        AppWidgetBackupBridge.restoreWidgetState(packageName, widgetData, 0);
    }

    public void dataChangedImpl(String packageName) {
        HashSet<String> targets = this.dataChangedTargets(packageName);
        this.dataChangedImpl(packageName, targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataChangedImpl(String packageName, HashSet<String> targets) {
        if (targets == null) {
            Slog.w(TAG, "dataChanged but no participant pkg='" + packageName + "'" + " uid=" + Binder.getCallingUid());
            return;
        }
        Object object = this.mQueueLock;
        synchronized (object) {
            BackupRequest req;
            if (targets.contains(packageName) && this.mPendingBackups.put(packageName, req = new BackupRequest(packageName)) == null) {
                this.writeToJournalLocked(packageName);
            }
        }
        KeyValueBackupJob.schedule(this.mContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashSet<String> dataChangedTargets(String packageName) {
        if (this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1) {
            SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
            synchronized (sparseArray) {
                return this.mBackupParticipants.get(Binder.getCallingUid());
            }
        }
        if (PACKAGE_MANAGER_SENTINEL.equals(packageName)) {
            return Sets.newHashSet(PACKAGE_MANAGER_SENTINEL);
        }
        SparseArray<HashSet<String>> sparseArray = this.mBackupParticipants;
        synchronized (sparseArray) {
            return SparseArrayUtils.union(this.mBackupParticipants);
        }
    }

    private void writeToJournalLocked(String str) {
        try {
            if (this.mJournal == null) {
                this.mJournal = DataChangedJournal.newJournal(this.mJournalDir);
            }
            this.mJournal.addPackage(str);
        }
        catch (IOException e) {
            Slog.e(TAG, "Can't write " + str + " to backup journal", e);
            this.mJournal = null;
        }
    }

    @Override
    public void dataChanged(final String packageName) {
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            return;
        }
        final HashSet<String> targets = this.dataChangedTargets(packageName);
        if (targets == null) {
            Slog.w(TAG, "dataChanged but no participant pkg='" + packageName + "'" + " uid=" + Binder.getCallingUid());
            return;
        }
        this.mBackupHandler.post(new Runnable(){

            @Override
            public void run() {
                RefactoredBackupManagerService.this.dataChangedImpl(packageName, targets);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initializeTransports(String[] transportNames, IBackupObserver observer) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "initializeTransport");
        Slog.v(TAG, "initializeTransport(): " + Arrays.asList(transportNames));
        long oldId = Binder.clearCallingIdentity();
        try {
            this.mWakelock.acquire();
            this.mBackupHandler.post(new PerformInitializeTask(this, transportNames, observer));
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackupData(String transportName, String packageName) {
        PackageInfo info;
        Slog.v(TAG, "clearBackupData() of " + packageName + " on " + transportName);
        try {
            info = this.mPackageManager.getPackageInfo(packageName, 64);
        }
        catch (PackageManager.NameNotFoundException e) {
            Slog.d(TAG, "No such package '" + packageName + "' - not clearing backup data");
            return;
        }
        HashSet<Object> apps = this.mContext.checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid()) == -1 ? this.mBackupParticipants.get(Binder.getCallingUid()) : SparseArrayUtils.union(this.mBackupParticipants);
        if (apps.contains(packageName)) {
            this.mBackupHandler.removeMessages(12);
            Object object = this.mQueueLock;
            synchronized (object) {
                IBackupTransport transport = this.mTransportManager.getTransportBinder(transportName);
                if (transport == null) {
                    Message msg = this.mBackupHandler.obtainMessage(12, new ClearRetryParams(transportName, packageName));
                    this.mBackupHandler.sendMessageDelayed(msg, 3600000L);
                    return;
                }
                long oldId = Binder.clearCallingIdentity();
                this.mWakelock.acquire();
                Message msg = this.mBackupHandler.obtainMessage(4, new ClearParams(transport, info));
                this.mBackupHandler.sendMessage(msg);
                Binder.restoreCallingIdentity(oldId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backupNow() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "backupNow");
        PowerSaveState result = this.mPowerManager.getPowerSaveState(5);
        if (result.batterySaverEnabled) {
            Slog.v(TAG, "Not running backup while in battery save mode");
            KeyValueBackupJob.schedule(this.mContext);
        } else {
            Slog.v(TAG, "Scheduling immediate backup pass");
            Object object = this.mQueueLock;
            synchronized (object) {
                try {
                    this.mRunBackupIntent.send();
                }
                catch (PendingIntent.CanceledException e) {
                    Slog.e(TAG, "run-backup intent cancelled!");
                }
                KeyValueBackupJob.cancel(this.mContext);
            }
        }
    }

    public boolean deviceIsProvisioned() {
        ContentResolver resolver = this.mContext.getContentResolver();
        return Settings.Global.getInt(resolver, "device_provisioned", 0) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adbBackup(ParcelFileDescriptor fd, boolean includeApks, boolean includeObbs, boolean includeShared, boolean doWidgets, boolean doAllApps, boolean includeSystem, boolean compress, boolean doKeyValue, String[] pkgList) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "adbBackup");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Backup supported only for the device owner");
        }
        if (!(doAllApps || includeShared || pkgList != null && pkgList.length != 0)) {
            throw new IllegalArgumentException("Backup requested but neither shared nor any apps named");
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            if (!this.deviceIsProvisioned()) {
                Slog.i(TAG, "Backup not supported before setup");
                return;
            }
            Slog.v(TAG, "Requesting backup: apks=" + includeApks + " obb=" + includeObbs + " shared=" + includeShared + " all=" + doAllApps + " system=" + includeSystem + " includekeyvalue=" + doKeyValue + " pkgs=" + pkgList);
            Slog.i(TAG, "Beginning adb backup...");
            AdbBackupParams params = new AdbBackupParams(fd, includeApks, includeObbs, includeShared, doWidgets, doAllApps, includeSystem, compress, doKeyValue, pkgList);
            int token = this.generateRandomIntegerToken();
            SparseArray<AdbParams> sparseArray = this.mAdbBackupRestoreConfirmations;
            synchronized (sparseArray) {
                this.mAdbBackupRestoreConfirmations.put(token, params);
            }
            Slog.d(TAG, "Starting backup confirmation UI, token=" + token);
            if (!this.startConfirmationUi(token, "fullback")) {
                Slog.e(TAG, "Unable to launch backup confirmation UI");
                this.mAdbBackupRestoreConfirmations.delete(token);
                return;
            }
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), 0, 0);
            this.startConfirmationTimeout(token, params);
            Slog.d(TAG, "Waiting for backup completion...");
            this.waitForCompletion(params);
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException e) {
                Slog.e(TAG, "IO error closing output for adb backup: " + e.getMessage());
            }
            Binder.restoreCallingIdentity(oldId);
            Slog.d(TAG, "Adb backup processing complete.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fullTransportBackup(String[] pkgNames) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "fullTransportBackup");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Restore supported only for the device owner");
        }
        if (!this.fullBackupAllowable(this.mTransportManager.getCurrentTransportBinder())) {
            Slog.i(TAG, "Full backup not currently possible -- key/value backup not yet run?");
        } else {
            Slog.d(TAG, "fullTransportBackup()");
            long oldId = Binder.clearCallingIdentity();
            try {
                CountDownLatch latch = new CountDownLatch(1);
                PerformFullTransportBackupTask task = new PerformFullTransportBackupTask(this, null, pkgNames, false, null, latch, null, null, false);
                this.mWakelock.acquire();
                new Thread((Runnable)task, "full-transport-master").start();
                while (true) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                long now = System.currentTimeMillis();
                for (String pkg : pkgNames) {
                    this.enqueueFullBackup(pkg, now);
                }
            }
            finally {
                Binder.restoreCallingIdentity(oldId);
            }
        }
        Slog.d(TAG, "Done with full transport backup.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void adbRestore(ParcelFileDescriptor fd) {
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "adbRestore");
        int callingUserHandle = UserHandle.getCallingUserId();
        if (callingUserHandle != 0) {
            throw new IllegalStateException("Restore supported only for the device owner");
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            if (!this.deviceIsProvisioned()) {
                Slog.i(TAG, "Full restore not permitted before setup");
                return;
            }
            Slog.i(TAG, "Beginning restore...");
            AdbRestoreParams params = new AdbRestoreParams(fd);
            int token = this.generateRandomIntegerToken();
            SparseArray<AdbParams> sparseArray = this.mAdbBackupRestoreConfirmations;
            synchronized (sparseArray) {
                this.mAdbBackupRestoreConfirmations.put(token, params);
            }
            Slog.d(TAG, "Starting restore confirmation UI, token=" + token);
            if (!this.startConfirmationUi(token, "fullrest")) {
                Slog.e(TAG, "Unable to launch restore confirmation");
                this.mAdbBackupRestoreConfirmations.delete(token);
                return;
            }
            this.mPowerManager.userActivity(SystemClock.uptimeMillis(), 0, 0);
            this.startConfirmationTimeout(token, params);
            Slog.d(TAG, "Waiting for restore completion...");
            this.waitForCompletion(params);
        }
        finally {
            try {
                fd.close();
            }
            catch (IOException e) {
                Slog.w(TAG, "Error trying to close fd after adb restore: " + e);
            }
            Binder.restoreCallingIdentity(oldId);
            Slog.i(TAG, "adb restore processing complete.");
        }
    }

    private boolean startConfirmationUi(int token, String action) {
        try {
            Intent confIntent = new Intent(action);
            confIntent.setClassName("com.android.backupconfirm", "com.android.backupconfirm.BackupRestoreConfirmation");
            confIntent.putExtra("conftoken", token);
            confIntent.addFlags(0x10000000);
            this.mContext.startActivityAsUser(confIntent, UserHandle.SYSTEM);
        }
        catch (ActivityNotFoundException e) {
            return false;
        }
        return true;
    }

    private void startConfirmationTimeout(int token, AdbParams params) {
        Message msg = this.mBackupHandler.obtainMessage(9, token, 0, params);
        this.mBackupHandler.sendMessageDelayed(msg, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForCompletion(AdbParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            while (!params.latch.get()) {
                try {
                    params.latch.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void signalAdbBackupRestoreCompletion(AdbParams params) {
        AtomicBoolean atomicBoolean = params.latch;
        synchronized (atomicBoolean) {
            params.latch.set(true);
            params.latch.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acknowledgeAdbBackupOrRestore(int token, boolean allow, String curPassword, String encPpassword, IFullBackupRestoreObserver observer) {
        Slog.d(TAG, "acknowledgeAdbBackupOrRestore : token=" + token + " allow=" + allow);
        this.mContext.enforceCallingPermission("android.permission.BACKUP", "acknowledgeAdbBackupOrRestore");
        long oldId = Binder.clearCallingIdentity();
        try {
            SparseArray<AdbParams> sparseArray = this.mAdbBackupRestoreConfirmations;
            synchronized (sparseArray) {
                AdbParams params = this.mAdbBackupRestoreConfirmations.get(token);
                if (params != null) {
                    this.mBackupHandler.removeMessages(9, params);
                    this.mAdbBackupRestoreConfirmations.delete(token);
                    if (allow) {
                        int verb = params instanceof AdbBackupParams ? 2 : 10;
                        params.observer = observer;
                        params.curPassword = curPassword;
                        params.encryptPassword = encPpassword;
                        this.mWakelock.acquire();
                        Message msg = this.mBackupHandler.obtainMessage(verb, params);
                        this.mBackupHandler.sendMessage(msg);
                    } else {
                        Slog.w(TAG, "User rejected full backup/restore operation");
                        this.signalAdbBackupRestoreCompletion(params);
                    }
                } else {
                    Slog.w(TAG, "Attempted to ack full backup/restore with invalid token");
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    private static boolean backupSettingMigrated(int userId) {
        File base = new File(Environment.getDataDirectory(), "backup");
        File enableFile = new File(base, BACKUP_ENABLE_FILE);
        return enableFile.exists();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean readBackupEnableState(int userId) {
        File base = new File(Environment.getDataDirectory(), "backup");
        File enableFile = new File(base, BACKUP_ENABLE_FILE);
        if (!enableFile.exists()) {
            Slog.i(TAG, "isBackupEnabled() => false due to absent settings file");
            return false;
        }
        try (FileInputStream fin = new FileInputStream(enableFile);){
            int state = fin.read();
            boolean bl = state != 0;
            return bl;
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot read enable state; assuming disabled");
            return false;
        }
    }

    private static void writeBackupEnableState(boolean enable, int userId) {
        File base = new File(Environment.getDataDirectory(), "backup");
        File enableFile = new File(base, BACKUP_ENABLE_FILE);
        File stage = new File(base, "backup_enabled-stage");
        try (FileOutputStream fout = new FileOutputStream(stage);){
            fout.write(enable ? 1 : 0);
            fout.close();
            stage.renameTo(enableFile);
        }
        catch (IOException | RuntimeException e) {
            Slog.e(TAG, "Unable to record backup enable state; reverting to disabled: " + e.getMessage());
            ContentResolver r = RefactoredBackupManagerService.sInstance.mContext.getContentResolver();
            Settings.Secure.putStringForUser(r, BACKUP_ENABLE_FILE, null, userId);
            enableFile.delete();
            stage.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackupEnabled(boolean enable) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupEnabled");
        Slog.i(TAG, "Backup enabled => " + enable);
        long oldId = Binder.clearCallingIdentity();
        try {
            boolean wasEnabled = this.mEnabled;
            Object object = this;
            synchronized (object) {
                RefactoredBackupManagerService.writeBackupEnableState(enable, 0);
                this.mEnabled = enable;
            }
            object = this.mQueueLock;
            synchronized (object) {
                if (enable && !wasEnabled && this.mProvisioned) {
                    KeyValueBackupJob.schedule(this.mContext);
                    this.scheduleNextFullBackupJob(0L);
                } else if (!enable) {
                    KeyValueBackupJob.cancel(this.mContext);
                    if (wasEnabled && this.mProvisioned) {
                        String[] allTransports;
                        for (String transport : allTransports = this.mTransportManager.getBoundTransportNames()) {
                            this.recordInitPendingLocked(true, transport);
                        }
                        this.mAlarmManager.set(0, System.currentTimeMillis(), this.mRunInitIntent);
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAutoRestore(boolean doAutoRestore) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setAutoRestore");
        Slog.i(TAG, "Auto restore => " + doAutoRestore);
        long oldId = Binder.clearCallingIdentity();
        try {
            RefactoredBackupManagerService refactoredBackupManagerService = this;
            synchronized (refactoredBackupManagerService) {
                Settings.Secure.putInt(this.mContext.getContentResolver(), "backup_auto_restore", doAutoRestore ? 1 : 0);
                this.mAutoRestore = doAutoRestore;
            }
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    @Override
    public void setBackupProvisioned(boolean available) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "setBackupProvisioned");
    }

    @Override
    public boolean isBackupEnabled() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "isBackupEnabled");
        return this.mEnabled;
    }

    @Override
    public String getCurrentTransport() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getCurrentTransport");
        String currentTransport = this.mTransportManager.getCurrentTransportName();
        return currentTransport;
    }

    @Override
    public String[] listAllTransports() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "listAllTransports");
        return this.mTransportManager.getBoundTransportNames();
    }

    @Override
    public ComponentName[] listAllTransportComponents() {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "listAllTransportComponents");
        return this.mTransportManager.getAllTransportCompenents();
    }

    @Override
    public String[] getTransportWhitelist() {
        Set<ComponentName> whitelistedComponents = this.mTransportManager.getTransportWhitelist();
        String[] whitelistedTransports = new String[whitelistedComponents.size()];
        int i = 0;
        for (ComponentName component : whitelistedComponents) {
            whitelistedTransports[i] = component.flattenToShortString();
            ++i;
        }
        return whitelistedTransports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String selectBackupTransport(String transport) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "selectBackupTransport");
        long oldId = Binder.clearCallingIdentity();
        try {
            String prevTransport = this.mTransportManager.selectTransport(transport);
            Settings.Secure.putString(this.mContext.getContentResolver(), "backup_transport", transport);
            Slog.v(TAG, "selectBackupTransport() set " + this.mTransportManager.getCurrentTransportName() + " returning " + prevTransport);
            String string2 = prevTransport;
            return string2;
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    @Override
    public void selectBackupTransportAsync(final ComponentName transport, final ISelectBackupTransportCallback listener) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "selectBackupTransportAsync");
        long oldId = Binder.clearCallingIdentity();
        Slog.v(TAG, "selectBackupTransportAsync() called with transport " + transport.flattenToShortString());
        this.mTransportManager.ensureTransportReady(transport, new SelectBackupTransportCallback(){

            @Override
            public void onSuccess(String transportName) {
                RefactoredBackupManagerService.this.mTransportManager.selectTransport(transportName);
                Settings.Secure.putString(RefactoredBackupManagerService.this.mContext.getContentResolver(), "backup_transport", RefactoredBackupManagerService.this.mTransportManager.getCurrentTransportName());
                Slog.v(RefactoredBackupManagerService.TAG, "Transport successfully selected: " + transport.flattenToShortString());
                try {
                    listener.onSuccess(transportName);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }

            @Override
            public void onFailure(int reason) {
                Slog.v(RefactoredBackupManagerService.TAG, "Failed to select transport: " + transport.flattenToShortString());
                try {
                    listener.onFailure(reason);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        });
        Binder.restoreCallingIdentity(oldId);
    }

    @Override
    public Intent getConfigurationIntent(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getConfigurationIntent");
        IBackupTransport transport = this.mTransportManager.getTransportBinder(transportName);
        if (transport != null) {
            try {
                Intent intent = transport.configurationIntent();
                return intent;
            }
            catch (Exception e) {
                Slog.e(TAG, "Unable to get configuration intent from transport: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public String getDestinationString(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDestinationString");
        IBackupTransport transport = this.mTransportManager.getTransportBinder(transportName);
        if (transport != null) {
            try {
                String text = transport.currentDestinationString();
                return text;
            }
            catch (Exception e) {
                Slog.e(TAG, "Unable to get string from transport: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public Intent getDataManagementIntent(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDataManagementIntent");
        IBackupTransport transport = this.mTransportManager.getTransportBinder(transportName);
        if (transport != null) {
            try {
                Intent intent = transport.dataManagementIntent();
                return intent;
            }
            catch (Exception e) {
                Slog.e(TAG, "Unable to get management intent from transport: " + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public String getDataManagementLabel(String transportName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "getDataManagementLabel");
        IBackupTransport transport = this.mTransportManager.getTransportBinder(transportName);
        if (transport != null) {
            try {
                String text = transport.dataManagementLabel();
                return text;
            }
            catch (Exception e) {
                Slog.e(TAG, "Unable to get management label from transport: " + e.getMessage());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentConnected(String packageName, IBinder agentBinder) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                IBackupAgent agent;
                Slog.d(TAG, "agentConnected pkg=" + packageName + " agent=" + agentBinder);
                this.mConnectedAgent = agent = IBackupAgent.Stub.asInterface(agentBinder);
                this.mConnecting = false;
            } else {
                Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " claiming agent connected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void agentDisconnected(String packageName) {
        Object object = this.mAgentConnectLock;
        synchronized (object) {
            if (Binder.getCallingUid() == 1000) {
                this.mConnectedAgent = null;
                this.mConnecting = false;
            } else {
                Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " claiming agent disconnected");
            }
            this.mAgentConnectLock.notifyAll();
        }
    }

    @Override
    public void restoreAtInstall(String packageName, int token) {
        IBackupTransport transport;
        if (Binder.getCallingUid() != 1000) {
            Slog.w(TAG, "Non-system process uid=" + Binder.getCallingUid() + " attemping install-time restore");
            return;
        }
        boolean skip = false;
        long restoreSet = this.getAvailableRestoreToken(packageName);
        Slog.v(TAG, "restoreAtInstall pkg=" + packageName + " token=" + Integer.toHexString(token) + " restoreSet=" + Long.toHexString(restoreSet));
        if (restoreSet == 0L) {
            skip = true;
        }
        if ((transport = this.mTransportManager.getCurrentTransportBinder()) == null) {
            Slog.w(TAG, "No transport");
            skip = true;
        }
        if (!this.mAutoRestore) {
            Slog.w(TAG, "Non-restorable state: auto=" + this.mAutoRestore);
            skip = true;
        }
        if (!skip) {
            try {
                String dirName = transport.transportDirName();
                this.mWakelock.acquire();
                Message msg = this.mBackupHandler.obtainMessage(3);
                msg.obj = new RestoreParams(transport, dirName, null, null, restoreSet, packageName, token);
                this.mBackupHandler.sendMessage(msg);
            }
            catch (Exception e) {
                Slog.e(TAG, "Unable to contact transport: " + e.getMessage());
                skip = true;
            }
        }
        if (skip) {
            Slog.v(TAG, "Finishing install immediately");
            try {
                this.mPackageManagerBinder.finishPackageInstall(token, false);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRestoreSession beginRestoreSession(String packageName, String transport) {
        Slog.v(TAG, "beginRestoreSession: pkg=" + packageName + " transport=" + transport);
        boolean needPermission = true;
        if (transport == null) {
            transport = this.mTransportManager.getCurrentTransportName();
            if (packageName != null) {
                PackageInfo app = null;
                try {
                    app = this.mPackageManager.getPackageInfo(packageName, 0);
                }
                catch (PackageManager.NameNotFoundException nnf) {
                    Slog.w(TAG, "Asked to restore nonexistent pkg " + packageName);
                    throw new IllegalArgumentException("Package " + packageName + " not found");
                }
                if (app.applicationInfo.uid == Binder.getCallingUid()) {
                    needPermission = false;
                }
            }
        }
        if (needPermission) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "beginRestoreSession");
        } else {
            Slog.d(TAG, "restoring self on current transport; no permission needed");
        }
        RefactoredBackupManagerService refactoredBackupManagerService = this;
        synchronized (refactoredBackupManagerService) {
            if (this.mActiveRestoreSession != null) {
                Slog.i(TAG, "Restore session requested but one already active");
                return null;
            }
            if (this.mBackupRunning) {
                Slog.i(TAG, "Restore session requested but currently running backups");
                return null;
            }
            this.mActiveRestoreSession = new ActiveRestoreSession(this, packageName, transport);
            this.mBackupHandler.sendEmptyMessageDelayed(8, 60000L);
        }
        return this.mActiveRestoreSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRestoreSession(ActiveRestoreSession currentSession) {
        RefactoredBackupManagerService refactoredBackupManagerService = this;
        synchronized (refactoredBackupManagerService) {
            if (currentSession != this.mActiveRestoreSession) {
                Slog.e(TAG, "ending non-current restore session");
            } else {
                Slog.v(TAG, "Clearing restore session and halting timeout");
                this.mActiveRestoreSession = null;
                this.mBackupHandler.removeMessages(8);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void opComplete(int token, long result) {
        Operation op = null;
        Object object = this.mCurrentOpLock;
        synchronized (object) {
            op = this.mCurrentOperations.get(token);
            if (op != null) {
                if (op.state == -1) {
                    op = null;
                    this.mCurrentOperations.delete(token);
                } else if (op.state == 1) {
                    Slog.w(TAG, "Received duplicate ack for token=" + Integer.toHexString(token));
                    op = null;
                    this.mCurrentOperations.remove(token);
                } else if (op.state == 0) {
                    op.state = 1;
                }
            }
            this.mCurrentOpLock.notifyAll();
        }
        if (op != null && op.callback != null) {
            Pair<BackupRestoreTask, Long> callbackAndResult = Pair.create(op.callback, result);
            Message msg = this.mBackupHandler.obtainMessage(21, callbackAndResult);
            this.mBackupHandler.sendMessage(msg);
        }
    }

    private static boolean appIsDisabled(ApplicationInfo app, PackageManager pm) {
        switch (pm.getApplicationEnabledSetting(app.packageName)) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAppEligibleForBackup(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.BACKUP", "isAppEligibleForBackup");
        try {
            PackageInfo packageInfo = this.mPackageManager.getPackageInfo(packageName, 64);
            if (!AppBackupUtils.appIsEligibleForBackup(packageInfo.applicationInfo) || AppBackupUtils.appIsStopped(packageInfo.applicationInfo) || RefactoredBackupManagerService.appIsDisabled(packageInfo.applicationInfo, this.mPackageManager)) {
                return false;
            }
            IBackupTransport transport = this.mTransportManager.getCurrentTransportBinder();
            if (transport != null) {
                try {
                    return transport.isAppEligibleForBackup(packageInfo, AppBackupUtils.appGetsFullBackup(packageInfo));
                }
                catch (Exception e) {
                    Slog.e(TAG, "Unable to ask about eligibility: " + e.getMessage());
                }
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw)) {
            return;
        }
        long identityToken = Binder.clearCallingIdentity();
        try {
            if (args != null) {
                for (String arg : args) {
                    if ("-h".equals(arg)) {
                        pw.println("'dumpsys backup' optional arguments:");
                        pw.println("  -h       : this help text");
                        pw.println("  a[gents] : dump information about defined backup agents");
                        return;
                    }
                    if (!"agents".startsWith(arg)) continue;
                    this.dumpAgents(pw);
                    return;
                }
            }
            this.dumpInternal(pw);
        }
        finally {
            Binder.restoreCallingIdentity(identityToken);
        }
    }

    private void dumpAgents(PrintWriter pw) {
        List<PackageInfo> agentPackages = this.allAgentPackages();
        pw.println("Defined backup agents:");
        for (PackageInfo pkg : agentPackages) {
            pw.print("  ");
            pw.print(pkg.packageName);
            pw.println(':');
            pw.print("      ");
            pw.println(pkg.applicationInfo.backupAgentName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInternal(PrintWriter pw) {
        Object object = this.mQueueLock;
        synchronized (object) {
            pw.println("Backup Manager is " + (this.mEnabled ? "enabled" : "disabled") + " / " + (!this.mProvisioned ? "not " : "") + "provisioned / " + (this.mPendingInits.size() == 0 ? "not " : "") + "pending init");
            pw.println("Auto-restore is " + (this.mAutoRestore ? "enabled" : "disabled"));
            if (this.mBackupRunning) {
                pw.println("Backup currently running");
            }
            pw.println("Last backup pass started: " + this.mLastBackupPass + " (now = " + System.currentTimeMillis() + ')');
            pw.println("  next scheduled: " + KeyValueBackupJob.nextScheduled());
            pw.println("Transport whitelist:");
            for (ComponentName componentName : this.mTransportManager.getTransportWhitelist()) {
                pw.print("    ");
                pw.println(componentName.flattenToShortString());
            }
            pw.println("Available transports:");
            String[] transports = this.listAllTransports();
            if (transports != null) {
                for (String t : this.listAllTransports()) {
                    pw.println((t.equals(this.mTransportManager.getCurrentTransportName()) ? "  * " : "    ") + t);
                    try {
                        IBackupTransport transport3 = this.mTransportManager.getTransportBinder(t);
                        File dir = new File(this.mBaseStateDir, transport3.transportDirName());
                        pw.println("       destination: " + transport3.currentDestinationString());
                        pw.println("       intent: " + transport3.configurationIntent());
                        for (File f : dir.listFiles()) {
                            pw.println("       " + f.getName() + " - " + f.length() + " state bytes");
                        }
                    }
                    catch (Exception e) {
                        Slog.e(TAG, "Error in transport", e);
                        pw.println("        Error: " + e);
                    }
                }
            }
            pw.println("Pending init: " + this.mPendingInits.size());
            for (String s : this.mPendingInits) {
                pw.println("    " + s);
            }
            List<String> list = this.mBackupTrace;
            synchronized (list) {
                if (!this.mBackupTrace.isEmpty()) {
                    pw.println("Most recent backup trace:");
                    for (String s : this.mBackupTrace) {
                        pw.println("   " + s);
                    }
                }
            }
            pw.print("Ancestral: ");
            pw.println(Long.toHexString(this.mAncestralToken));
            pw.print("Current:   ");
            pw.println(Long.toHexString(this.mCurrentToken));
            int n = this.mBackupParticipants.size();
            pw.println("Participants:");
            for (int i = 0; i < n; ++i) {
                int uid = this.mBackupParticipants.keyAt(i);
                pw.print("  uid: ");
                pw.println(uid);
                HashSet<String> participants = this.mBackupParticipants.valueAt(i);
                for (String app : participants) {
                    pw.println("    " + app);
                }
            }
            pw.println("Ancestral packages: " + (this.mAncestralPackages == null ? "none" : Integer.valueOf(this.mAncestralPackages.size())));
            if (this.mAncestralPackages != null) {
                for (String pkg : this.mAncestralPackages) {
                    pw.println("    " + pkg);
                }
            }
            pw.println("Ever backed up: " + this.mEverStoredApps.size());
            for (String pkg : this.mEverStoredApps) {
                pw.println("    " + pkg);
            }
            pw.println("Pending key/value backup: " + this.mPendingBackups.size());
            for (BackupRequest req : this.mPendingBackups.values()) {
                pw.println("    " + req);
            }
            pw.println("Full backup queue:" + this.mFullBackupQueue.size());
            for (FullBackupEntry entry : this.mFullBackupQueue) {
                pw.print("    ");
                pw.print(entry.lastBackup);
                pw.print(" : ");
                pw.println(entry.packageName);
            }
        }
    }

    @Override
    public IBackupManager getBackupManagerBinder() {
        return this.mBackupManagerBinder;
    }

    public static final class Lifecycle
    extends SystemService {
        public Lifecycle(Context context) {
            super(context);
            sInstance = new Trampoline(context);
        }

        @Override
        public void onStart() {
            this.publishBinderService("backup", sInstance);
        }

        @Override
        public void onUnlockUser(int userId) {
            if (userId == 0) {
                sInstance.initialize(userId);
                if (!RefactoredBackupManagerService.backupSettingMigrated(userId)) {
                    Slog.i(RefactoredBackupManagerService.TAG, "Backup enable apparently not migrated");
                    ContentResolver r = RefactoredBackupManagerService.sInstance.mContext.getContentResolver();
                    int enableState = Settings.Secure.getIntForUser(r, RefactoredBackupManagerService.BACKUP_ENABLE_FILE, -1, userId);
                    if (enableState >= 0) {
                        Slog.i(RefactoredBackupManagerService.TAG, "Migrating enable state " + (enableState != 0));
                        RefactoredBackupManagerService.writeBackupEnableState(enableState != 0, userId);
                        Settings.Secure.putStringForUser(r, RefactoredBackupManagerService.BACKUP_ENABLE_FILE, null, userId);
                    } else {
                        Slog.i(RefactoredBackupManagerService.TAG, "Backup not yet configured; retaining null enable state");
                    }
                }
                try {
                    sInstance.setBackupEnabled(RefactoredBackupManagerService.readBackupEnableState(userId));
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }
}

