/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup;

import android.app.backup.BlobBackupHelper;
import android.content.pm.IShortcutService;
import android.os.ServiceManager;
import android.util.Slog;

public class ShortcutBackupHelper
extends BlobBackupHelper {
    private static final String TAG = "ShortcutBackupAgent";
    private static final int BLOB_VERSION = 1;
    private static final String KEY_USER_FILE = "shortcutuser.xml";

    public ShortcutBackupHelper() {
        super(1, KEY_USER_FILE);
    }

    private IShortcutService getShortcutService() {
        return IShortcutService.Stub.asInterface(ServiceManager.getService("shortcut"));
    }

    @Override
    protected byte[] getBackupPayload(String key) {
        switch (key) {
            case "shortcutuser.xml": {
                try {
                    return this.getShortcutService().getBackupPayload(0);
                }
                catch (Exception e) {
                    Slog.wtf(TAG, "Backup failed", e);
                    break;
                }
            }
            default: {
                Slog.w(TAG, "Unknown key: " + key);
            }
        }
        return null;
    }

    @Override
    protected void applyRestoredPayload(String key, byte[] payload) {
        switch (key) {
            case "shortcutuser.xml": {
                try {
                    this.getShortcutService().applyRestore(payload, 0);
                }
                catch (Exception e) {
                    Slog.wtf(TAG, "Restore failed", e);
                }
                break;
            }
            default: {
                Slog.w(TAG, "Unknown key: " + key);
            }
        }
    }
}

