/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.internal;

import android.app.backup.IBackupObserver;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.EventLog;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.server.backup.RefactoredBackupManagerService;
import java.io.File;

public class PerformInitializeTask
implements Runnable {
    private RefactoredBackupManagerService backupManagerService;
    String[] mQueue;
    IBackupObserver mObserver;

    public PerformInitializeTask(RefactoredBackupManagerService backupManagerService, String[] transportNames, IBackupObserver observer) {
        this.backupManagerService = backupManagerService;
        this.mQueue = transportNames;
        this.mObserver = observer;
    }

    private void notifyResult(String target, int status) {
        try {
            if (this.mObserver != null) {
                this.mObserver.onResult(target, status);
            }
        }
        catch (RemoteException ignored) {
            this.mObserver = null;
        }
    }

    private void notifyFinished(int status) {
        try {
            if (this.mObserver != null) {
                this.mObserver.backupFinished(status);
            }
        }
        catch (RemoteException ignored) {
            this.mObserver = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int result = 0;
        try {
            for (String transportName : this.mQueue) {
                IBackupTransport transport = this.backupManagerService.getTransportManager().getTransportBinder(transportName);
                if (transport == null) {
                    Slog.e("BackupManagerService", "Requested init for " + transportName + " but not found");
                    continue;
                }
                Slog.i("BackupManagerService", "Initializing (wiping) backup transport storage: " + transportName);
                EventLog.writeEvent(2821, transport.transportDirName());
                long startRealtime = SystemClock.elapsedRealtime();
                int status = transport.initializeDevice();
                if (status == 0) {
                    status = transport.finishBackup();
                }
                if (status == 0) {
                    Slog.i("BackupManagerService", "Device init successful");
                    int millis = (int)(SystemClock.elapsedRealtime() - startRealtime);
                    EventLog.writeEvent(2827, new Object[0]);
                    this.backupManagerService.resetBackupState(new File(this.backupManagerService.getBaseStateDir(), transport.transportDirName()));
                    EventLog.writeEvent(2825, 0, millis);
                    Object object = this.backupManagerService.getQueueLock();
                    synchronized (object) {
                        this.backupManagerService.recordInitPendingLocked(false, transportName);
                    }
                    this.notifyResult(transportName, 0);
                    continue;
                }
                Slog.e("BackupManagerService", "Transport error in initializeDevice()");
                EventLog.writeEvent(2822, "(initialize)");
                Object object = this.backupManagerService.getQueueLock();
                synchronized (object) {
                    this.backupManagerService.recordInitPendingLocked(true, transportName);
                }
                this.notifyResult(transportName, status);
                result = status;
                long delay = transport.requestBackupTime();
                Slog.w("BackupManagerService", "Init failed on " + transportName + " resched in " + delay);
                this.backupManagerService.getAlarmManager().set(0, System.currentTimeMillis() + delay, this.backupManagerService.getRunInitIntent());
            }
        }
        catch (Exception e) {
            Slog.e("BackupManagerService", "Unexpected error performing init", e);
            result = -1000;
        }
        finally {
            this.notifyFinished(result);
            this.backupManagerService.getWakelock().release();
        }
    }
}

