/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.backup.restore;

import android.app.backup.IBackupManagerMonitor;
import android.app.backup.IRestoreObserver;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreSet;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Message;
import android.util.Slog;
import com.android.internal.backup.IBackupTransport;
import com.android.server.backup.RefactoredBackupManagerService;
import com.android.server.backup.params.RestoreGetSetsParams;
import com.android.server.backup.params.RestoreParams;

public class ActiveRestoreSession
extends IRestoreSession.Stub {
    private static final String TAG = "RestoreSession";
    private RefactoredBackupManagerService backupManagerService;
    private String mPackageName;
    private IBackupTransport mRestoreTransport = null;
    public RestoreSet[] mRestoreSets = null;
    boolean mEnded = false;
    boolean mTimedOut = false;

    public ActiveRestoreSession(RefactoredBackupManagerService backupManagerService, String packageName, String transport) {
        this.backupManagerService = backupManagerService;
        this.mPackageName = packageName;
        this.mRestoreTransport = backupManagerService.getTransportManager().getTransportBinder(transport);
    }

    public void markTimedOut() {
        this.mTimedOut = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int getAvailableRestoreSets(IRestoreObserver observer, IBackupManagerMonitor monitor) {
        this.backupManagerService.getContext().enforceCallingOrSelfPermission("android.permission.BACKUP", "getAvailableRestoreSets");
        if (observer == null) {
            throw new IllegalArgumentException("Observer must not be null");
        }
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            if (this.mRestoreTransport == null) {
                Slog.w(TAG, "Null transport getting restore sets");
                int n = -1;
                return n;
            }
            this.backupManagerService.getBackupHandler().removeMessages(8);
            this.backupManagerService.getWakelock().acquire();
            Message msg = this.backupManagerService.getBackupHandler().obtainMessage(6, new RestoreGetSetsParams(this.mRestoreTransport, this, observer, monitor));
            this.backupManagerService.getBackupHandler().sendMessage(msg);
            int n = 0;
            return n;
        }
        catch (Exception e) {
            Slog.e(TAG, "Error in getAvailableRestoreSets", e);
            int n = -1;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int restoreAll(long token, IRestoreObserver observer, IBackupManagerMonitor monitor) {
        String dirName;
        this.backupManagerService.getContext().enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
        Slog.d(TAG, "restoreAll token=" + Long.toHexString(token) + " observer=" + observer);
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        if (this.mRestoreTransport == null || this.mRestoreSets == null) {
            Slog.e(TAG, "Ignoring restoreAll() with no restore set");
            return -1;
        }
        if (this.mPackageName != null) {
            Slog.e(TAG, "Ignoring restoreAll() on single-package session");
            return -1;
        }
        try {
            dirName = this.mRestoreTransport.transportDirName();
        }
        catch (Exception e) {
            Slog.e(TAG, "Unable to get transport dir for restore: " + e.getMessage());
            return -1;
        }
        Object object = this.backupManagerService.getQueueLock();
        synchronized (object) {
            for (int i = 0; i < this.mRestoreSets.length; ++i) {
                if (token != this.mRestoreSets[i].token) continue;
                this.backupManagerService.getBackupHandler().removeMessages(8);
                long oldId = Binder.clearCallingIdentity();
                this.backupManagerService.getWakelock().acquire();
                Message msg = this.backupManagerService.getBackupHandler().obtainMessage(3);
                msg.obj = new RestoreParams(this.mRestoreTransport, dirName, observer, monitor, token);
                this.backupManagerService.getBackupHandler().sendMessage(msg);
                Binder.restoreCallingIdentity(oldId);
                return 0;
            }
        }
        Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int restoreSome(long token, IRestoreObserver observer, IBackupManagerMonitor monitor, String[] packages) {
        String dirName;
        this.backupManagerService.getContext().enforceCallingOrSelfPermission("android.permission.BACKUP", "performRestore");
        StringBuilder b = new StringBuilder(128);
        b.append("restoreSome token=");
        b.append(Long.toHexString(token));
        b.append(" observer=");
        b.append(observer.toString());
        b.append(" monitor=");
        if (monitor == null) {
            b.append("null");
        } else {
            b.append(monitor.toString());
        }
        b.append(" packages=");
        if (packages == null) {
            b.append("null");
        } else {
            b.append('{');
            boolean first = true;
            for (String s : packages) {
                if (!first) {
                    b.append(", ");
                } else {
                    first = false;
                }
                b.append(s);
            }
            b.append('}');
        }
        Slog.d(TAG, b.toString());
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        if (this.mRestoreTransport == null || this.mRestoreSets == null) {
            Slog.e(TAG, "Ignoring restoreAll() with no restore set");
            return -1;
        }
        if (this.mPackageName != null) {
            Slog.e(TAG, "Ignoring restoreAll() on single-package session");
            return -1;
        }
        try {
            dirName = this.mRestoreTransport.transportDirName();
        }
        catch (Exception e) {
            Slog.e(TAG, "Unable to get transport name for restoreSome: " + e.getMessage());
            return -1;
        }
        Object object = this.backupManagerService.getQueueLock();
        synchronized (object) {
            for (int i = 0; i < this.mRestoreSets.length; ++i) {
                if (token != this.mRestoreSets[i].token) continue;
                this.backupManagerService.getBackupHandler().removeMessages(8);
                long oldId = Binder.clearCallingIdentity();
                this.backupManagerService.getWakelock().acquire();
                Message msg = this.backupManagerService.getBackupHandler().obtainMessage(3);
                msg.obj = new RestoreParams(this.mRestoreTransport, dirName, observer, monitor, token, packages, packages.length > 1);
                this.backupManagerService.getBackupHandler().sendMessage(msg);
                Binder.restoreCallingIdentity(oldId);
                return 0;
            }
        }
        Slog.w(TAG, "Restore token " + Long.toHexString(token) + " not found");
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int restorePackage(String packageName, IRestoreObserver observer, IBackupManagerMonitor monitor) {
        Slog.v(TAG, "restorePackage pkg=" + packageName + " obs=" + observer + "monitor=" + monitor);
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return -1;
        }
        if (this.mPackageName != null && !this.mPackageName.equals(packageName)) {
            Slog.e(TAG, "Ignoring attempt to restore pkg=" + packageName + " on session for package " + this.mPackageName);
            return -1;
        }
        PackageInfo app = null;
        try {
            app = this.backupManagerService.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException nnf) {
            Slog.w(TAG, "Asked to restore nonexistent pkg " + packageName);
            return -1;
        }
        int perm = this.backupManagerService.getContext().checkPermission("android.permission.BACKUP", Binder.getCallingPid(), Binder.getCallingUid());
        if (perm == -1 && app.applicationInfo.uid != Binder.getCallingUid()) {
            Slog.w(TAG, "restorePackage: bad packageName=" + packageName + " or calling uid=" + Binder.getCallingUid());
            throw new SecurityException("No permission to restore other packages");
        }
        long oldId = Binder.clearCallingIdentity();
        try {
            String dirName;
            long token = this.backupManagerService.getAvailableRestoreToken(packageName);
            Slog.v(TAG, "restorePackage pkg=" + packageName + " token=" + Long.toHexString(token));
            if (token == 0L) {
                Slog.w(TAG, "No data available for this package; not restoring");
                int n = -1;
                return n;
            }
            try {
                dirName = this.mRestoreTransport.transportDirName();
            }
            catch (Exception e) {
                Slog.e(TAG, "Unable to get transport dir for restorePackage: " + e.getMessage());
                int n = -1;
                Binder.restoreCallingIdentity(oldId);
                return n;
            }
            this.backupManagerService.getBackupHandler().removeMessages(8);
            this.backupManagerService.getWakelock().acquire();
            Message msg = this.backupManagerService.getBackupHandler().obtainMessage(3);
            msg.obj = new RestoreParams(this.mRestoreTransport, dirName, observer, monitor, token, app);
            this.backupManagerService.getBackupHandler().sendMessage(msg);
        }
        finally {
            Binder.restoreCallingIdentity(oldId);
        }
        return 0;
    }

    @Override
    public synchronized void endRestoreSession() {
        Slog.d(TAG, "endRestoreSession");
        if (this.mTimedOut) {
            Slog.i(TAG, "Session already timed out");
            return;
        }
        if (this.mEnded) {
            throw new IllegalStateException("Restore session already ended");
        }
        this.backupManagerService.getBackupHandler().post(new EndRestoreRunnable(this.backupManagerService, this));
    }

    public class EndRestoreRunnable
    implements Runnable {
        RefactoredBackupManagerService mBackupManager;
        ActiveRestoreSession mSession;

        public EndRestoreRunnable(RefactoredBackupManagerService manager, ActiveRestoreSession session) {
            this.mBackupManager = manager;
            this.mSession = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ActiveRestoreSession activeRestoreSession = this.mSession;
            synchronized (activeRestoreSession) {
                this.mSession.mRestoreTransport = null;
                this.mSession.mEnded = true;
            }
            this.mBackupManager.clearRestoreSession(this.mSession);
        }
    }
}

