/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.broadcastradio;

import android.content.Context;
import android.hardware.radio.IRadioService;
import android.hardware.radio.ITuner;
import android.hardware.radio.ITunerCallback;
import android.hardware.radio.RadioManager;
import android.os.ParcelableException;
import com.android.server.SystemService;
import com.android.server.broadcastradio.Tuner;
import java.util.List;

public class BroadcastRadioService
extends SystemService {
    private final ServiceImpl mServiceImpl = new ServiceImpl();
    private final long mNativeContext = this.nativeInit();
    private final Object mLock = new Object();
    private List<RadioManager.ModuleProperties> mModules = null;

    public BroadcastRadioService(Context context) {
        super(context);
    }

    protected void finalize() throws Throwable {
        this.nativeFinalize(this.mNativeContext);
        super.finalize();
    }

    private native long nativeInit();

    private native void nativeFinalize(long var1);

    private native List<RadioManager.ModuleProperties> nativeLoadModules(long var1);

    private native Tuner nativeOpenTuner(long var1, int var3, RadioManager.BandConfig var4, boolean var5, ITunerCallback var6);

    @Override
    public void onStart() {
        this.publishBinderService("broadcastradio", this.mServiceImpl);
    }

    private class ServiceImpl
    extends IRadioService.Stub {
        private ServiceImpl() {
        }

        private void enforcePolicyAccess() {
            if (0 != BroadcastRadioService.this.getContext().checkCallingPermission("android.permission.ACCESS_BROADCAST_RADIO")) {
                throw new SecurityException("ACCESS_BROADCAST_RADIO permission not granted");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<RadioManager.ModuleProperties> listModules() {
            this.enforcePolicyAccess();
            Object object = BroadcastRadioService.this.mLock;
            synchronized (object) {
                if (BroadcastRadioService.this.mModules != null) {
                    return BroadcastRadioService.this.mModules;
                }
                BroadcastRadioService.this.mModules = BroadcastRadioService.this.nativeLoadModules(BroadcastRadioService.this.mNativeContext);
                if (BroadcastRadioService.this.mModules == null) {
                    throw new ParcelableException(new NullPointerException("couldn't load radio modules"));
                }
                return BroadcastRadioService.this.mModules;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ITuner openTuner(int moduleId, RadioManager.BandConfig bandConfig, boolean withAudio, ITunerCallback callback) {
            this.enforcePolicyAccess();
            if (callback == null) {
                throw new IllegalArgumentException("Callback must not be empty");
            }
            Object object = BroadcastRadioService.this.mLock;
            synchronized (object) {
                return BroadcastRadioService.this.nativeOpenTuner(BroadcastRadioService.this.mNativeContext, moduleId, bandConfig, withAudio, callback);
            }
        }
    }
}

