/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.metrics.nano;

import com.android.framework.protobuf.nano.CodedInputByteBufferNano;
import com.android.framework.protobuf.nano.CodedOutputByteBufferNano;
import com.android.framework.protobuf.nano.InternalNano;
import com.android.framework.protobuf.nano.InvalidProtocolBufferNanoException;
import com.android.framework.protobuf.nano.MessageNano;
import com.android.framework.protobuf.nano.WireFormatNano;
import java.io.IOException;

public interface IpConnectivityLogClass {
    public static final int UNKNOWN = 0;
    public static final int BLUETOOTH = 1;
    public static final int CELLULAR = 2;
    public static final int ETHERNET = 3;
    public static final int WIFI = 4;
    public static final int WIFI_P2P = 7;
    public static final int WIFI_NAN = 8;
    public static final int LOWPAN = 9;
    public static final int NONE = 5;
    public static final int MULTIPLE = 6;

    public static final class IpConnectivityLog
    extends MessageNano {
        private static volatile IpConnectivityLog[] _emptyArray;
        public IpConnectivityEvent[] events;
        public int droppedEvents;
        public int version;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IpConnectivityLog[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new IpConnectivityLog[0];
                    }
                }
            }
            return _emptyArray;
        }

        public IpConnectivityLog() {
            this.clear();
        }

        public IpConnectivityLog clear() {
            this.events = IpConnectivityEvent.emptyArray();
            this.droppedEvents = 0;
            this.version = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.events != null && this.events.length > 0) {
                for (int i = 0; i < this.events.length; ++i) {
                    IpConnectivityEvent element = this.events[i];
                    if (element == null) continue;
                    output.writeMessage(1, element);
                }
            }
            if (this.droppedEvents != 0) {
                output.writeInt32(2, this.droppedEvents);
            }
            if (this.version != 0) {
                output.writeInt32(3, this.version);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.events != null && this.events.length > 0) {
                for (int i = 0; i < this.events.length; ++i) {
                    IpConnectivityEvent element = this.events[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(1, element);
                }
            }
            if (this.droppedEvents != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.droppedEvents);
            }
            if (this.version != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.version);
            }
            return size;
        }

        @Override
        public IpConnectivityLog mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 10: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 10);
                        int i = this.events == null ? 0 : this.events.length;
                        IpConnectivityEvent[] newArray = new IpConnectivityEvent[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.events, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new IpConnectivityEvent();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new IpConnectivityEvent();
                        input.readMessage(newArray[i]);
                        this.events = newArray;
                        continue block6;
                    }
                    case 16: {
                        this.droppedEvents = input.readInt32();
                        continue block6;
                    }
                    case 24: 
                }
                this.version = input.readInt32();
            }
        }

        public static IpConnectivityLog parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new IpConnectivityLog(), data);
        }

        public static IpConnectivityLog parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new IpConnectivityLog().mergeFrom(input);
        }
    }

    public static final class IpConnectivityEvent
    extends MessageNano {
        public static final int DEFAULT_NETWORK_EVENT_FIELD_NUMBER = 2;
        public static final int IP_REACHABILITY_EVENT_FIELD_NUMBER = 3;
        public static final int NETWORK_EVENT_FIELD_NUMBER = 4;
        public static final int DNS_LOOKUP_BATCH_FIELD_NUMBER = 5;
        public static final int DNS_LATENCIES_FIELD_NUMBER = 13;
        public static final int CONNECT_STATISTICS_FIELD_NUMBER = 14;
        public static final int DHCP_EVENT_FIELD_NUMBER = 6;
        public static final int IP_PROVISIONING_EVENT_FIELD_NUMBER = 7;
        public static final int VALIDATION_PROBE_EVENT_FIELD_NUMBER = 8;
        public static final int APF_PROGRAM_EVENT_FIELD_NUMBER = 9;
        public static final int APF_STATISTICS_FIELD_NUMBER = 10;
        public static final int RA_EVENT_FIELD_NUMBER = 11;
        public static final int NETWORK_STATS_FIELD_NUMBER = 19;
        public static final int WAKEUP_STATS_FIELD_NUMBER = 20;
        private int eventCase_ = 0;
        private Object event_;
        private static volatile IpConnectivityEvent[] _emptyArray;
        public long timeMs;
        public int linkLayer;
        public int networkId;
        public String ifName;
        public long transports;

        public int getEventCase() {
            return this.eventCase_;
        }

        public IpConnectivityEvent clearEvent() {
            this.eventCase_ = 0;
            this.event_ = null;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IpConnectivityEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new IpConnectivityEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public boolean hasDefaultNetworkEvent() {
            return this.eventCase_ == 2;
        }

        public DefaultNetworkEvent getDefaultNetworkEvent() {
            if (this.eventCase_ == 2) {
                return (DefaultNetworkEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setDefaultNetworkEvent(DefaultNetworkEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 2;
            this.event_ = value;
            return this;
        }

        public boolean hasIpReachabilityEvent() {
            return this.eventCase_ == 3;
        }

        public IpReachabilityEvent getIpReachabilityEvent() {
            if (this.eventCase_ == 3) {
                return (IpReachabilityEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setIpReachabilityEvent(IpReachabilityEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 3;
            this.event_ = value;
            return this;
        }

        public boolean hasNetworkEvent() {
            return this.eventCase_ == 4;
        }

        public NetworkEvent getNetworkEvent() {
            if (this.eventCase_ == 4) {
                return (NetworkEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setNetworkEvent(NetworkEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 4;
            this.event_ = value;
            return this;
        }

        public boolean hasDnsLookupBatch() {
            return this.eventCase_ == 5;
        }

        public DNSLookupBatch getDnsLookupBatch() {
            if (this.eventCase_ == 5) {
                return (DNSLookupBatch)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setDnsLookupBatch(DNSLookupBatch value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 5;
            this.event_ = value;
            return this;
        }

        public boolean hasDnsLatencies() {
            return this.eventCase_ == 13;
        }

        public DNSLatencies getDnsLatencies() {
            if (this.eventCase_ == 13) {
                return (DNSLatencies)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setDnsLatencies(DNSLatencies value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 13;
            this.event_ = value;
            return this;
        }

        public boolean hasConnectStatistics() {
            return this.eventCase_ == 14;
        }

        public ConnectStatistics getConnectStatistics() {
            if (this.eventCase_ == 14) {
                return (ConnectStatistics)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setConnectStatistics(ConnectStatistics value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 14;
            this.event_ = value;
            return this;
        }

        public boolean hasDhcpEvent() {
            return this.eventCase_ == 6;
        }

        public DHCPEvent getDhcpEvent() {
            if (this.eventCase_ == 6) {
                return (DHCPEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setDhcpEvent(DHCPEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 6;
            this.event_ = value;
            return this;
        }

        public boolean hasIpProvisioningEvent() {
            return this.eventCase_ == 7;
        }

        public IpProvisioningEvent getIpProvisioningEvent() {
            if (this.eventCase_ == 7) {
                return (IpProvisioningEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setIpProvisioningEvent(IpProvisioningEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 7;
            this.event_ = value;
            return this;
        }

        public boolean hasValidationProbeEvent() {
            return this.eventCase_ == 8;
        }

        public ValidationProbeEvent getValidationProbeEvent() {
            if (this.eventCase_ == 8) {
                return (ValidationProbeEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setValidationProbeEvent(ValidationProbeEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 8;
            this.event_ = value;
            return this;
        }

        public boolean hasApfProgramEvent() {
            return this.eventCase_ == 9;
        }

        public ApfProgramEvent getApfProgramEvent() {
            if (this.eventCase_ == 9) {
                return (ApfProgramEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setApfProgramEvent(ApfProgramEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 9;
            this.event_ = value;
            return this;
        }

        public boolean hasApfStatistics() {
            return this.eventCase_ == 10;
        }

        public ApfStatistics getApfStatistics() {
            if (this.eventCase_ == 10) {
                return (ApfStatistics)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setApfStatistics(ApfStatistics value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 10;
            this.event_ = value;
            return this;
        }

        public boolean hasRaEvent() {
            return this.eventCase_ == 11;
        }

        public RaEvent getRaEvent() {
            if (this.eventCase_ == 11) {
                return (RaEvent)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setRaEvent(RaEvent value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 11;
            this.event_ = value;
            return this;
        }

        public boolean hasNetworkStats() {
            return this.eventCase_ == 19;
        }

        public NetworkStats getNetworkStats() {
            if (this.eventCase_ == 19) {
                return (NetworkStats)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setNetworkStats(NetworkStats value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 19;
            this.event_ = value;
            return this;
        }

        public boolean hasWakeupStats() {
            return this.eventCase_ == 20;
        }

        public WakeupStats getWakeupStats() {
            if (this.eventCase_ == 20) {
                return (WakeupStats)this.event_;
            }
            return null;
        }

        public IpConnectivityEvent setWakeupStats(WakeupStats value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.eventCase_ = 20;
            this.event_ = value;
            return this;
        }

        public IpConnectivityEvent() {
            this.clear();
        }

        public IpConnectivityEvent clear() {
            this.timeMs = 0L;
            this.linkLayer = 0;
            this.networkId = 0;
            this.ifName = "";
            this.transports = 0L;
            this.clearEvent();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.timeMs != 0L) {
                output.writeInt64(1, this.timeMs);
            }
            if (this.eventCase_ == 2) {
                output.writeMessage(2, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 3) {
                output.writeMessage(3, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 4) {
                output.writeMessage(4, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 5) {
                output.writeMessage(5, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 6) {
                output.writeMessage(6, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 7) {
                output.writeMessage(7, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 8) {
                output.writeMessage(8, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 9) {
                output.writeMessage(9, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 10) {
                output.writeMessage(10, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 11) {
                output.writeMessage(11, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 13) {
                output.writeMessage(13, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 14) {
                output.writeMessage(14, (MessageNano)this.event_);
            }
            if (this.linkLayer != 0) {
                output.writeInt32(15, this.linkLayer);
            }
            if (this.networkId != 0) {
                output.writeInt32(16, this.networkId);
            }
            if (!this.ifName.equals("")) {
                output.writeString(17, this.ifName);
            }
            if (this.transports != 0L) {
                output.writeInt64(18, this.transports);
            }
            if (this.eventCase_ == 19) {
                output.writeMessage(19, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 20) {
                output.writeMessage(20, (MessageNano)this.event_);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.timeMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.timeMs);
            }
            if (this.eventCase_ == 2) {
                size += CodedOutputByteBufferNano.computeMessageSize(2, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 3) {
                size += CodedOutputByteBufferNano.computeMessageSize(3, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 4) {
                size += CodedOutputByteBufferNano.computeMessageSize(4, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 5) {
                size += CodedOutputByteBufferNano.computeMessageSize(5, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 6) {
                size += CodedOutputByteBufferNano.computeMessageSize(6, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 7) {
                size += CodedOutputByteBufferNano.computeMessageSize(7, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 8) {
                size += CodedOutputByteBufferNano.computeMessageSize(8, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 9) {
                size += CodedOutputByteBufferNano.computeMessageSize(9, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 10) {
                size += CodedOutputByteBufferNano.computeMessageSize(10, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 11) {
                size += CodedOutputByteBufferNano.computeMessageSize(11, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 13) {
                size += CodedOutputByteBufferNano.computeMessageSize(13, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 14) {
                size += CodedOutputByteBufferNano.computeMessageSize(14, (MessageNano)this.event_);
            }
            if (this.linkLayer != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(15, this.linkLayer);
            }
            if (this.networkId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(16, this.networkId);
            }
            if (!this.ifName.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(17, this.ifName);
            }
            if (this.transports != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(18, this.transports);
            }
            if (this.eventCase_ == 19) {
                size += CodedOutputByteBufferNano.computeMessageSize(19, (MessageNano)this.event_);
            }
            if (this.eventCase_ == 20) {
                size += CodedOutputByteBufferNano.computeMessageSize(20, (MessageNano)this.event_);
            }
            return size;
        }

        @Override
        public IpConnectivityEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block25: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block25;
                        return this;
                    }
                    case 8: {
                        this.timeMs = input.readInt64();
                        continue block25;
                    }
                    case 18: {
                        if (this.eventCase_ != 2) {
                            this.event_ = new DefaultNetworkEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 2;
                        continue block25;
                    }
                    case 26: {
                        if (this.eventCase_ != 3) {
                            this.event_ = new IpReachabilityEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 3;
                        continue block25;
                    }
                    case 34: {
                        if (this.eventCase_ != 4) {
                            this.event_ = new NetworkEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 4;
                        continue block25;
                    }
                    case 42: {
                        if (this.eventCase_ != 5) {
                            this.event_ = new DNSLookupBatch();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 5;
                        continue block25;
                    }
                    case 50: {
                        if (this.eventCase_ != 6) {
                            this.event_ = new DHCPEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 6;
                        continue block25;
                    }
                    case 58: {
                        if (this.eventCase_ != 7) {
                            this.event_ = new IpProvisioningEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 7;
                        continue block25;
                    }
                    case 66: {
                        if (this.eventCase_ != 8) {
                            this.event_ = new ValidationProbeEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 8;
                        continue block25;
                    }
                    case 74: {
                        if (this.eventCase_ != 9) {
                            this.event_ = new ApfProgramEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 9;
                        continue block25;
                    }
                    case 82: {
                        if (this.eventCase_ != 10) {
                            this.event_ = new ApfStatistics();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 10;
                        continue block25;
                    }
                    case 90: {
                        if (this.eventCase_ != 11) {
                            this.event_ = new RaEvent();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 11;
                        continue block25;
                    }
                    case 106: {
                        if (this.eventCase_ != 13) {
                            this.event_ = new DNSLatencies();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 13;
                        continue block25;
                    }
                    case 114: {
                        if (this.eventCase_ != 14) {
                            this.event_ = new ConnectStatistics();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 14;
                        continue block25;
                    }
                    case 120: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                this.linkLayer = value;
                            }
                        }
                        continue block25;
                    }
                    case 128: {
                        this.networkId = input.readInt32();
                        continue block25;
                    }
                    case 138: {
                        this.ifName = input.readString();
                        continue block25;
                    }
                    case 144: {
                        this.transports = input.readInt64();
                        continue block25;
                    }
                    case 154: {
                        if (this.eventCase_ != 19) {
                            this.event_ = new NetworkStats();
                        }
                        input.readMessage((MessageNano)this.event_);
                        this.eventCase_ = 19;
                        continue block25;
                    }
                    case 162: 
                }
                if (this.eventCase_ != 20) {
                    this.event_ = new WakeupStats();
                }
                input.readMessage((MessageNano)this.event_);
                this.eventCase_ = 20;
            }
        }

        public static IpConnectivityEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new IpConnectivityEvent(), data);
        }

        public static IpConnectivityEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new IpConnectivityEvent().mergeFrom(input);
        }
    }

    public static final class WakeupStats
    extends MessageNano {
        private static volatile WakeupStats[] _emptyArray;
        public long durationSec;
        public long totalWakeups;
        public long rootWakeups;
        public long systemWakeups;
        public long applicationWakeups;
        public long nonApplicationWakeups;
        public long noUidWakeups;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static WakeupStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new WakeupStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public WakeupStats() {
            this.clear();
        }

        public WakeupStats clear() {
            this.durationSec = 0L;
            this.totalWakeups = 0L;
            this.rootWakeups = 0L;
            this.systemWakeups = 0L;
            this.applicationWakeups = 0L;
            this.nonApplicationWakeups = 0L;
            this.noUidWakeups = 0L;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.durationSec != 0L) {
                output.writeInt64(1, this.durationSec);
            }
            if (this.totalWakeups != 0L) {
                output.writeInt64(2, this.totalWakeups);
            }
            if (this.rootWakeups != 0L) {
                output.writeInt64(3, this.rootWakeups);
            }
            if (this.systemWakeups != 0L) {
                output.writeInt64(4, this.systemWakeups);
            }
            if (this.applicationWakeups != 0L) {
                output.writeInt64(5, this.applicationWakeups);
            }
            if (this.nonApplicationWakeups != 0L) {
                output.writeInt64(6, this.nonApplicationWakeups);
            }
            if (this.noUidWakeups != 0L) {
                output.writeInt64(7, this.noUidWakeups);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.durationSec != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.durationSec);
            }
            if (this.totalWakeups != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.totalWakeups);
            }
            if (this.rootWakeups != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(3, this.rootWakeups);
            }
            if (this.systemWakeups != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.systemWakeups);
            }
            if (this.applicationWakeups != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.applicationWakeups);
            }
            if (this.nonApplicationWakeups != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.nonApplicationWakeups);
            }
            if (this.noUidWakeups != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.noUidWakeups);
            }
            return size;
        }

        @Override
        public WakeupStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block10: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block10;
                        return this;
                    }
                    case 8: {
                        this.durationSec = input.readInt64();
                        continue block10;
                    }
                    case 16: {
                        this.totalWakeups = input.readInt64();
                        continue block10;
                    }
                    case 24: {
                        this.rootWakeups = input.readInt64();
                        continue block10;
                    }
                    case 32: {
                        this.systemWakeups = input.readInt64();
                        continue block10;
                    }
                    case 40: {
                        this.applicationWakeups = input.readInt64();
                        continue block10;
                    }
                    case 48: {
                        this.nonApplicationWakeups = input.readInt64();
                        continue block10;
                    }
                    case 56: 
                }
                this.noUidWakeups = input.readInt64();
            }
        }

        public static WakeupStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new WakeupStats(), data);
        }

        public static WakeupStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new WakeupStats().mergeFrom(input);
        }
    }

    public static final class NetworkStats
    extends MessageNano {
        private static volatile NetworkStats[] _emptyArray;
        public long durationMs;
        public int ipSupport;
        public boolean everValidated;
        public boolean portalFound;
        public int noConnectivityReports;
        public int validationAttempts;
        public Pair[] validationEvents;
        public Pair[] validationStates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NetworkStats[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new NetworkStats[0];
                    }
                }
            }
            return _emptyArray;
        }

        public NetworkStats() {
            this.clear();
        }

        public NetworkStats clear() {
            this.durationMs = 0L;
            this.ipSupport = 0;
            this.everValidated = false;
            this.portalFound = false;
            this.noConnectivityReports = 0;
            this.validationAttempts = 0;
            this.validationEvents = Pair.emptyArray();
            this.validationStates = Pair.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            Pair element;
            int i;
            if (this.durationMs != 0L) {
                output.writeInt64(1, this.durationMs);
            }
            if (this.ipSupport != 0) {
                output.writeInt32(2, this.ipSupport);
            }
            if (this.everValidated) {
                output.writeBool(3, this.everValidated);
            }
            if (this.portalFound) {
                output.writeBool(4, this.portalFound);
            }
            if (this.noConnectivityReports != 0) {
                output.writeInt32(5, this.noConnectivityReports);
            }
            if (this.validationAttempts != 0) {
                output.writeInt32(6, this.validationAttempts);
            }
            if (this.validationEvents != null && this.validationEvents.length > 0) {
                for (i = 0; i < this.validationEvents.length; ++i) {
                    element = this.validationEvents[i];
                    if (element == null) continue;
                    output.writeMessage(7, element);
                }
            }
            if (this.validationStates != null && this.validationStates.length > 0) {
                for (i = 0; i < this.validationStates.length; ++i) {
                    element = this.validationStates[i];
                    if (element == null) continue;
                    output.writeMessage(8, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            Pair element;
            int i;
            int size = super.computeSerializedSize();
            if (this.durationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.durationMs);
            }
            if (this.ipSupport != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.ipSupport);
            }
            if (this.everValidated) {
                size += CodedOutputByteBufferNano.computeBoolSize(3, this.everValidated);
            }
            if (this.portalFound) {
                size += CodedOutputByteBufferNano.computeBoolSize(4, this.portalFound);
            }
            if (this.noConnectivityReports != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.noConnectivityReports);
            }
            if (this.validationAttempts != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.validationAttempts);
            }
            if (this.validationEvents != null && this.validationEvents.length > 0) {
                for (i = 0; i < this.validationEvents.length; ++i) {
                    element = this.validationEvents[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(7, element);
                }
            }
            if (this.validationStates != null && this.validationStates.length > 0) {
                for (i = 0; i < this.validationStates.length; ++i) {
                    element = this.validationStates[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(8, element);
                }
            }
            return size;
        }

        @Override
        public NetworkStats mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block14: while (true) {
                Pair[] newArray;
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block14;
                        return this;
                    }
                    case 8: {
                        this.durationMs = input.readInt64();
                        continue block14;
                    }
                    case 16: {
                        int value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.ipSupport = value;
                            }
                        }
                        continue block14;
                    }
                    case 24: {
                        this.everValidated = input.readBool();
                        continue block14;
                    }
                    case 32: {
                        this.portalFound = input.readBool();
                        continue block14;
                    }
                    case 40: {
                        this.noConnectivityReports = input.readInt32();
                        continue block14;
                    }
                    case 48: {
                        this.validationAttempts = input.readInt32();
                        continue block14;
                    }
                    case 58: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 58);
                        i = this.validationEvents == null ? 0 : this.validationEvents.length;
                        newArray = new Pair[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.validationEvents, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Pair();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Pair();
                        input.readMessage(newArray[i]);
                        this.validationEvents = newArray;
                        continue block14;
                    }
                    case 66: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 66);
                i = this.validationStates == null ? 0 : this.validationStates.length;
                newArray = new Pair[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.validationStates, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new Pair();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new Pair();
                input.readMessage(newArray[i]);
                this.validationStates = newArray;
            }
        }

        public static NetworkStats parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new NetworkStats(), data);
        }

        public static NetworkStats parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new NetworkStats().mergeFrom(input);
        }
    }

    public static final class IpProvisioningEvent
    extends MessageNano {
        private static volatile IpProvisioningEvent[] _emptyArray;
        public String ifName;
        public int eventType;
        public int latencyMs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IpProvisioningEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new IpProvisioningEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public IpProvisioningEvent() {
            this.clear();
        }

        public IpProvisioningEvent clear() {
            this.ifName = "";
            this.eventType = 0;
            this.latencyMs = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (!this.ifName.equals("")) {
                output.writeString(1, this.ifName);
            }
            if (this.eventType != 0) {
                output.writeInt32(2, this.eventType);
            }
            if (this.latencyMs != 0) {
                output.writeInt32(3, this.latencyMs);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (!this.ifName.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(1, this.ifName);
            }
            if (this.eventType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.eventType);
            }
            if (this.latencyMs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.latencyMs);
            }
            return size;
        }

        @Override
        public IpProvisioningEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 10: {
                        this.ifName = input.readString();
                        continue block6;
                    }
                    case 16: {
                        this.eventType = input.readInt32();
                        continue block6;
                    }
                    case 24: 
                }
                this.latencyMs = input.readInt32();
            }
        }

        public static IpProvisioningEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new IpProvisioningEvent(), data);
        }

        public static IpProvisioningEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new IpProvisioningEvent().mergeFrom(input);
        }
    }

    public static final class RaEvent
    extends MessageNano {
        private static volatile RaEvent[] _emptyArray;
        public long routerLifetime;
        public long prefixValidLifetime;
        public long prefixPreferredLifetime;
        public long routeInfoLifetime;
        public long rdnssLifetime;
        public long dnsslLifetime;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RaEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new RaEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public RaEvent() {
            this.clear();
        }

        public RaEvent clear() {
            this.routerLifetime = 0L;
            this.prefixValidLifetime = 0L;
            this.prefixPreferredLifetime = 0L;
            this.routeInfoLifetime = 0L;
            this.rdnssLifetime = 0L;
            this.dnsslLifetime = 0L;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.routerLifetime != 0L) {
                output.writeInt64(1, this.routerLifetime);
            }
            if (this.prefixValidLifetime != 0L) {
                output.writeInt64(2, this.prefixValidLifetime);
            }
            if (this.prefixPreferredLifetime != 0L) {
                output.writeInt64(3, this.prefixPreferredLifetime);
            }
            if (this.routeInfoLifetime != 0L) {
                output.writeInt64(4, this.routeInfoLifetime);
            }
            if (this.rdnssLifetime != 0L) {
                output.writeInt64(5, this.rdnssLifetime);
            }
            if (this.dnsslLifetime != 0L) {
                output.writeInt64(6, this.dnsslLifetime);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.routerLifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.routerLifetime);
            }
            if (this.prefixValidLifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(2, this.prefixValidLifetime);
            }
            if (this.prefixPreferredLifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(3, this.prefixPreferredLifetime);
            }
            if (this.routeInfoLifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(4, this.routeInfoLifetime);
            }
            if (this.rdnssLifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.rdnssLifetime);
            }
            if (this.dnsslLifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.dnsslLifetime);
            }
            return size;
        }

        @Override
        public RaEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block9: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block9;
                        return this;
                    }
                    case 8: {
                        this.routerLifetime = input.readInt64();
                        continue block9;
                    }
                    case 16: {
                        this.prefixValidLifetime = input.readInt64();
                        continue block9;
                    }
                    case 24: {
                        this.prefixPreferredLifetime = input.readInt64();
                        continue block9;
                    }
                    case 32: {
                        this.routeInfoLifetime = input.readInt64();
                        continue block9;
                    }
                    case 40: {
                        this.rdnssLifetime = input.readInt64();
                        continue block9;
                    }
                    case 48: 
                }
                this.dnsslLifetime = input.readInt64();
            }
        }

        public static RaEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new RaEvent(), data);
        }

        public static RaEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new RaEvent().mergeFrom(input);
        }
    }

    public static final class ApfStatistics
    extends MessageNano {
        private static volatile ApfStatistics[] _emptyArray;
        public long durationMs;
        public int receivedRas;
        public int matchingRas;
        public int droppedRas;
        public int zeroLifetimeRas;
        public int parseErrors;
        public int programUpdates;
        public int maxProgramSize;
        public int programUpdatesAll;
        public int programUpdatesAllowingMulticast;
        public int totalPacketProcessed;
        public int totalPacketDropped;
        public Pair[] hardwareCounters;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ApfStatistics[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ApfStatistics[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ApfStatistics() {
            this.clear();
        }

        public ApfStatistics clear() {
            this.durationMs = 0L;
            this.receivedRas = 0;
            this.matchingRas = 0;
            this.droppedRas = 0;
            this.zeroLifetimeRas = 0;
            this.parseErrors = 0;
            this.programUpdates = 0;
            this.maxProgramSize = 0;
            this.programUpdatesAll = 0;
            this.programUpdatesAllowingMulticast = 0;
            this.totalPacketProcessed = 0;
            this.totalPacketDropped = 0;
            this.hardwareCounters = Pair.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.durationMs != 0L) {
                output.writeInt64(1, this.durationMs);
            }
            if (this.receivedRas != 0) {
                output.writeInt32(2, this.receivedRas);
            }
            if (this.matchingRas != 0) {
                output.writeInt32(3, this.matchingRas);
            }
            if (this.droppedRas != 0) {
                output.writeInt32(5, this.droppedRas);
            }
            if (this.zeroLifetimeRas != 0) {
                output.writeInt32(6, this.zeroLifetimeRas);
            }
            if (this.parseErrors != 0) {
                output.writeInt32(7, this.parseErrors);
            }
            if (this.programUpdates != 0) {
                output.writeInt32(8, this.programUpdates);
            }
            if (this.maxProgramSize != 0) {
                output.writeInt32(9, this.maxProgramSize);
            }
            if (this.programUpdatesAll != 0) {
                output.writeInt32(10, this.programUpdatesAll);
            }
            if (this.programUpdatesAllowingMulticast != 0) {
                output.writeInt32(11, this.programUpdatesAllowingMulticast);
            }
            if (this.totalPacketProcessed != 0) {
                output.writeInt32(12, this.totalPacketProcessed);
            }
            if (this.totalPacketDropped != 0) {
                output.writeInt32(13, this.totalPacketDropped);
            }
            if (this.hardwareCounters != null && this.hardwareCounters.length > 0) {
                for (int i = 0; i < this.hardwareCounters.length; ++i) {
                    Pair element = this.hardwareCounters[i];
                    if (element == null) continue;
                    output.writeMessage(14, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.durationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.durationMs);
            }
            if (this.receivedRas != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.receivedRas);
            }
            if (this.matchingRas != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.matchingRas);
            }
            if (this.droppedRas != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.droppedRas);
            }
            if (this.zeroLifetimeRas != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(6, this.zeroLifetimeRas);
            }
            if (this.parseErrors != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(7, this.parseErrors);
            }
            if (this.programUpdates != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(8, this.programUpdates);
            }
            if (this.maxProgramSize != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(9, this.maxProgramSize);
            }
            if (this.programUpdatesAll != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(10, this.programUpdatesAll);
            }
            if (this.programUpdatesAllowingMulticast != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(11, this.programUpdatesAllowingMulticast);
            }
            if (this.totalPacketProcessed != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(12, this.totalPacketProcessed);
            }
            if (this.totalPacketDropped != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(13, this.totalPacketDropped);
            }
            if (this.hardwareCounters != null && this.hardwareCounters.length > 0) {
                for (int i = 0; i < this.hardwareCounters.length; ++i) {
                    Pair element = this.hardwareCounters[i];
                    if (element == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(14, element);
                }
            }
            return size;
        }

        @Override
        public ApfStatistics mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block16: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block16;
                        return this;
                    }
                    case 8: {
                        this.durationMs = input.readInt64();
                        continue block16;
                    }
                    case 16: {
                        this.receivedRas = input.readInt32();
                        continue block16;
                    }
                    case 24: {
                        this.matchingRas = input.readInt32();
                        continue block16;
                    }
                    case 40: {
                        this.droppedRas = input.readInt32();
                        continue block16;
                    }
                    case 48: {
                        this.zeroLifetimeRas = input.readInt32();
                        continue block16;
                    }
                    case 56: {
                        this.parseErrors = input.readInt32();
                        continue block16;
                    }
                    case 64: {
                        this.programUpdates = input.readInt32();
                        continue block16;
                    }
                    case 72: {
                        this.maxProgramSize = input.readInt32();
                        continue block16;
                    }
                    case 80: {
                        this.programUpdatesAll = input.readInt32();
                        continue block16;
                    }
                    case 88: {
                        this.programUpdatesAllowingMulticast = input.readInt32();
                        continue block16;
                    }
                    case 96: {
                        this.totalPacketProcessed = input.readInt32();
                        continue block16;
                    }
                    case 104: {
                        this.totalPacketDropped = input.readInt32();
                        continue block16;
                    }
                    case 114: 
                }
                int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 114);
                int i = this.hardwareCounters == null ? 0 : this.hardwareCounters.length;
                Pair[] newArray = new Pair[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.hardwareCounters, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new Pair();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new Pair();
                input.readMessage(newArray[i]);
                this.hardwareCounters = newArray;
            }
        }

        public static ApfStatistics parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ApfStatistics(), data);
        }

        public static ApfStatistics parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ApfStatistics().mergeFrom(input);
        }
    }

    public static final class ApfProgramEvent
    extends MessageNano {
        private static volatile ApfProgramEvent[] _emptyArray;
        public long lifetime;
        public long effectiveLifetime;
        public int filteredRas;
        public int currentRas;
        public int programLength;
        public boolean dropMulticast;
        public boolean hasIpv4Addr;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ApfProgramEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ApfProgramEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ApfProgramEvent() {
            this.clear();
        }

        public ApfProgramEvent clear() {
            this.lifetime = 0L;
            this.effectiveLifetime = 0L;
            this.filteredRas = 0;
            this.currentRas = 0;
            this.programLength = 0;
            this.dropMulticast = false;
            this.hasIpv4Addr = false;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.lifetime != 0L) {
                output.writeInt64(1, this.lifetime);
            }
            if (this.filteredRas != 0) {
                output.writeInt32(2, this.filteredRas);
            }
            if (this.currentRas != 0) {
                output.writeInt32(3, this.currentRas);
            }
            if (this.programLength != 0) {
                output.writeInt32(4, this.programLength);
            }
            if (this.dropMulticast) {
                output.writeBool(5, this.dropMulticast);
            }
            if (this.hasIpv4Addr) {
                output.writeBool(6, this.hasIpv4Addr);
            }
            if (this.effectiveLifetime != 0L) {
                output.writeInt64(7, this.effectiveLifetime);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.lifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(1, this.lifetime);
            }
            if (this.filteredRas != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.filteredRas);
            }
            if (this.currentRas != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.currentRas);
            }
            if (this.programLength != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.programLength);
            }
            if (this.dropMulticast) {
                size += CodedOutputByteBufferNano.computeBoolSize(5, this.dropMulticast);
            }
            if (this.hasIpv4Addr) {
                size += CodedOutputByteBufferNano.computeBoolSize(6, this.hasIpv4Addr);
            }
            if (this.effectiveLifetime != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.effectiveLifetime);
            }
            return size;
        }

        @Override
        public ApfProgramEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block10: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block10;
                        return this;
                    }
                    case 8: {
                        this.lifetime = input.readInt64();
                        continue block10;
                    }
                    case 16: {
                        this.filteredRas = input.readInt32();
                        continue block10;
                    }
                    case 24: {
                        this.currentRas = input.readInt32();
                        continue block10;
                    }
                    case 32: {
                        this.programLength = input.readInt32();
                        continue block10;
                    }
                    case 40: {
                        this.dropMulticast = input.readBool();
                        continue block10;
                    }
                    case 48: {
                        this.hasIpv4Addr = input.readBool();
                        continue block10;
                    }
                    case 56: 
                }
                this.effectiveLifetime = input.readInt64();
            }
        }

        public static ApfProgramEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ApfProgramEvent(), data);
        }

        public static ApfProgramEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ApfProgramEvent().mergeFrom(input);
        }
    }

    public static final class DHCPEvent
    extends MessageNano {
        public static final int STATE_TRANSITION_FIELD_NUMBER = 2;
        public static final int ERROR_CODE_FIELD_NUMBER = 3;
        private int valueCase_ = 0;
        private Object value_;
        private static volatile DHCPEvent[] _emptyArray;
        public String ifName;
        public int durationMs;

        public int getValueCase() {
            return this.valueCase_;
        }

        public DHCPEvent clearValue() {
            this.valueCase_ = 0;
            this.value_ = null;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DHCPEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DHCPEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public boolean hasStateTransition() {
            return this.valueCase_ == 2;
        }

        public String getStateTransition() {
            if (this.valueCase_ == 2) {
                return (String)this.value_;
            }
            return "";
        }

        public DHCPEvent setStateTransition(String value) {
            this.valueCase_ = 2;
            this.value_ = value;
            return this;
        }

        public boolean hasErrorCode() {
            return this.valueCase_ == 3;
        }

        public int getErrorCode() {
            if (this.valueCase_ == 3) {
                return (Integer)this.value_;
            }
            return 0;
        }

        public DHCPEvent setErrorCode(int value) {
            this.valueCase_ = 3;
            this.value_ = value;
            return this;
        }

        public DHCPEvent() {
            this.clear();
        }

        public DHCPEvent clear() {
            this.ifName = "";
            this.durationMs = 0;
            this.clearValue();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (!this.ifName.equals("")) {
                output.writeString(1, this.ifName);
            }
            if (this.valueCase_ == 2) {
                output.writeString(2, (String)this.value_);
            }
            if (this.valueCase_ == 3) {
                output.writeInt32(3, (Integer)this.value_);
            }
            if (this.durationMs != 0) {
                output.writeInt32(4, this.durationMs);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (!this.ifName.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(1, this.ifName);
            }
            if (this.valueCase_ == 2) {
                size += CodedOutputByteBufferNano.computeStringSize(2, (String)this.value_);
            }
            if (this.valueCase_ == 3) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, (Integer)this.value_);
            }
            if (this.durationMs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.durationMs);
            }
            return size;
        }

        @Override
        public DHCPEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 10: {
                        this.ifName = input.readString();
                        continue block7;
                    }
                    case 18: {
                        this.value_ = input.readString();
                        this.valueCase_ = 2;
                        continue block7;
                    }
                    case 24: {
                        this.value_ = input.readInt32();
                        this.valueCase_ = 3;
                        continue block7;
                    }
                    case 32: 
                }
                this.durationMs = input.readInt32();
            }
        }

        public static DHCPEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new DHCPEvent(), data);
        }

        public static DHCPEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new DHCPEvent().mergeFrom(input);
        }
    }

    public static final class ConnectStatistics
    extends MessageNano {
        private static volatile ConnectStatistics[] _emptyArray;
        public int connectCount;
        public int connectBlockingCount;
        public int ipv6AddrCount;
        public int[] latenciesMs;
        public int[] nonBlockingLatenciesMs;
        public Pair[] errnosCounters;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ConnectStatistics[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ConnectStatistics[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ConnectStatistics() {
            this.clear();
        }

        public ConnectStatistics clear() {
            this.connectCount = 0;
            this.connectBlockingCount = 0;
            this.ipv6AddrCount = 0;
            this.latenciesMs = WireFormatNano.EMPTY_INT_ARRAY;
            this.nonBlockingLatenciesMs = WireFormatNano.EMPTY_INT_ARRAY;
            this.errnosCounters = Pair.emptyArray();
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            int i;
            if (this.connectCount != 0) {
                output.writeInt32(1, this.connectCount);
            }
            if (this.ipv6AddrCount != 0) {
                output.writeInt32(2, this.ipv6AddrCount);
            }
            if (this.latenciesMs != null && this.latenciesMs.length > 0) {
                for (i = 0; i < this.latenciesMs.length; ++i) {
                    output.writeInt32(3, this.latenciesMs[i]);
                }
            }
            if (this.errnosCounters != null && this.errnosCounters.length > 0) {
                for (i = 0; i < this.errnosCounters.length; ++i) {
                    Pair element = this.errnosCounters[i];
                    if (element == null) continue;
                    output.writeMessage(4, element);
                }
            }
            if (this.connectBlockingCount != 0) {
                output.writeInt32(5, this.connectBlockingCount);
            }
            if (this.nonBlockingLatenciesMs != null && this.nonBlockingLatenciesMs.length > 0) {
                for (i = 0; i < this.nonBlockingLatenciesMs.length; ++i) {
                    output.writeInt32(6, this.nonBlockingLatenciesMs[i]);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int element;
            int i;
            int dataSize;
            int size = super.computeSerializedSize();
            if (this.connectCount != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.connectCount);
            }
            if (this.ipv6AddrCount != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.ipv6AddrCount);
            }
            if (this.latenciesMs != null && this.latenciesMs.length > 0) {
                dataSize = 0;
                for (i = 0; i < this.latenciesMs.length; ++i) {
                    element = this.latenciesMs[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.latenciesMs.length;
            }
            if (this.errnosCounters != null && this.errnosCounters.length > 0) {
                for (int i2 = 0; i2 < this.errnosCounters.length; ++i2) {
                    Pair element2 = this.errnosCounters[i2];
                    if (element2 == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(4, element2);
                }
            }
            if (this.connectBlockingCount != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.connectBlockingCount);
            }
            if (this.nonBlockingLatenciesMs != null && this.nonBlockingLatenciesMs.length > 0) {
                dataSize = 0;
                for (i = 0; i < this.nonBlockingLatenciesMs.length; ++i) {
                    element = this.nonBlockingLatenciesMs[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.nonBlockingLatenciesMs.length;
            }
            return size;
        }

        @Override
        public ConnectStatistics mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block11: while (true) {
                int[] newArray;
                int i;
                int startPos;
                int limit;
                int length;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block11;
                        return this;
                    }
                    case 8: {
                        this.connectCount = input.readInt32();
                        continue block11;
                    }
                    case 16: {
                        this.ipv6AddrCount = input.readInt32();
                        continue block11;
                    }
                    case 24: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 24);
                        int i2 = this.latenciesMs == null ? 0 : this.latenciesMs.length;
                        int[] newArray2 = new int[i2 + arrayLength];
                        if (i2 != 0) {
                            System.arraycopy((int[])this.latenciesMs, (int)0, (int[])newArray2, (int)0, (int)i2);
                        }
                        while (i2 < newArray2.length - 1) {
                            newArray2[i2] = input.readInt32();
                            input.readTag();
                            ++i2;
                        }
                        newArray2[i2] = input.readInt32();
                        this.latenciesMs = newArray2;
                        continue block11;
                    }
                    case 26: {
                        length = input.readRawVarint32();
                        limit = input.pushLimit(length);
                        int arrayLength = 0;
                        startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        i = this.latenciesMs == null ? 0 : this.latenciesMs.length;
                        newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy((int[])this.latenciesMs, (int)0, (int[])newArray, (int)0, (int)i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt32();
                            ++i;
                        }
                        this.latenciesMs = newArray;
                        input.popLimit(limit);
                        continue block11;
                    }
                    case 34: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 34);
                        int i2 = this.errnosCounters == null ? 0 : this.errnosCounters.length;
                        Pair[] newArray3 = new Pair[i2 + arrayLength];
                        if (i2 != 0) {
                            System.arraycopy(this.errnosCounters, 0, newArray3, 0, i2);
                        }
                        while (i2 < newArray3.length - 1) {
                            newArray3[i2] = new Pair();
                            input.readMessage(newArray3[i2]);
                            input.readTag();
                            ++i2;
                        }
                        newArray3[i2] = new Pair();
                        input.readMessage(newArray3[i2]);
                        this.errnosCounters = newArray3;
                        continue block11;
                    }
                    case 40: {
                        this.connectBlockingCount = input.readInt32();
                        continue block11;
                    }
                    case 48: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 48);
                        int i2 = this.nonBlockingLatenciesMs == null ? 0 : this.nonBlockingLatenciesMs.length;
                        int[] newArray4 = new int[i2 + arrayLength];
                        if (i2 != 0) {
                            System.arraycopy((int[])this.nonBlockingLatenciesMs, (int)0, (int[])newArray4, (int)0, (int)i2);
                        }
                        while (i2 < newArray4.length - 1) {
                            newArray4[i2] = input.readInt32();
                            input.readTag();
                            ++i2;
                        }
                        newArray4[i2] = input.readInt32();
                        this.nonBlockingLatenciesMs = newArray4;
                        continue block11;
                    }
                    case 50: 
                }
                length = input.readRawVarint32();
                limit = input.pushLimit(length);
                int arrayLength = 0;
                startPos = input.getPosition();
                while (input.getBytesUntilLimit() > 0) {
                    input.readInt32();
                    ++arrayLength;
                }
                input.rewindToPosition(startPos);
                i = this.nonBlockingLatenciesMs == null ? 0 : this.nonBlockingLatenciesMs.length;
                newArray = new int[i + arrayLength];
                if (i != 0) {
                    System.arraycopy((int[])this.nonBlockingLatenciesMs, (int)0, (int[])newArray, (int)0, (int)i);
                }
                while (i < newArray.length) {
                    newArray[i] = input.readInt32();
                    ++i;
                }
                this.nonBlockingLatenciesMs = newArray;
                input.popLimit(limit);
            }
        }

        public static ConnectStatistics parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ConnectStatistics(), data);
        }

        public static ConnectStatistics parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ConnectStatistics().mergeFrom(input);
        }
    }

    public static final class DNSLatencies
    extends MessageNano {
        private static volatile DNSLatencies[] _emptyArray;
        public int type;
        public int returnCode;
        public int queryCount;
        public int aCount;
        public int aaaaCount;
        public int[] latenciesMs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DNSLatencies[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DNSLatencies[0];
                    }
                }
            }
            return _emptyArray;
        }

        public DNSLatencies() {
            this.clear();
        }

        public DNSLatencies clear() {
            this.type = 0;
            this.returnCode = 0;
            this.queryCount = 0;
            this.aCount = 0;
            this.aaaaCount = 0;
            this.latenciesMs = WireFormatNano.EMPTY_INT_ARRAY;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.type != 0) {
                output.writeInt32(1, this.type);
            }
            if (this.returnCode != 0) {
                output.writeInt32(2, this.returnCode);
            }
            if (this.queryCount != 0) {
                output.writeInt32(3, this.queryCount);
            }
            if (this.aCount != 0) {
                output.writeInt32(4, this.aCount);
            }
            if (this.aaaaCount != 0) {
                output.writeInt32(5, this.aaaaCount);
            }
            if (this.latenciesMs != null && this.latenciesMs.length > 0) {
                for (int i = 0; i < this.latenciesMs.length; ++i) {
                    output.writeInt32(6, this.latenciesMs[i]);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.type != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.type);
            }
            if (this.returnCode != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.returnCode);
            }
            if (this.queryCount != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.queryCount);
            }
            if (this.aCount != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.aCount);
            }
            if (this.aaaaCount != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(5, this.aaaaCount);
            }
            if (this.latenciesMs != null && this.latenciesMs.length > 0) {
                int dataSize = 0;
                for (int i = 0; i < this.latenciesMs.length; ++i) {
                    int element = this.latenciesMs[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.latenciesMs.length;
            }
            return size;
        }

        @Override
        public DNSLatencies mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block10: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block10;
                        return this;
                    }
                    case 8: {
                        this.type = input.readInt32();
                        continue block10;
                    }
                    case 16: {
                        this.returnCode = input.readInt32();
                        continue block10;
                    }
                    case 24: {
                        this.queryCount = input.readInt32();
                        continue block10;
                    }
                    case 32: {
                        this.aCount = input.readInt32();
                        continue block10;
                    }
                    case 40: {
                        this.aaaaCount = input.readInt32();
                        continue block10;
                    }
                    case 48: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 48);
                        int i = this.latenciesMs == null ? 0 : this.latenciesMs.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy((int[])this.latenciesMs, (int)0, (int[])newArray, (int)0, (int)i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.latenciesMs = newArray;
                        continue block10;
                    }
                    case 50: 
                }
                int length = input.readRawVarint32();
                int limit = input.pushLimit(length);
                int arrayLength = 0;
                int startPos = input.getPosition();
                while (input.getBytesUntilLimit() > 0) {
                    input.readInt32();
                    ++arrayLength;
                }
                input.rewindToPosition(startPos);
                int i = this.latenciesMs == null ? 0 : this.latenciesMs.length;
                int[] newArray = new int[i + arrayLength];
                if (i != 0) {
                    System.arraycopy((int[])this.latenciesMs, (int)0, (int[])newArray, (int)0, (int)i);
                }
                while (i < newArray.length) {
                    newArray[i] = input.readInt32();
                    ++i;
                }
                this.latenciesMs = newArray;
                input.popLimit(limit);
            }
        }

        public static DNSLatencies parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new DNSLatencies(), data);
        }

        public static DNSLatencies parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new DNSLatencies().mergeFrom(input);
        }
    }

    public static final class DNSLookupBatch
    extends MessageNano {
        private static volatile DNSLookupBatch[] _emptyArray;
        public int[] latenciesMs;
        public long getaddrinfoQueryCount;
        public long gethostbynameQueryCount;
        public long getaddrinfoErrorCount;
        public long gethostbynameErrorCount;
        public Pair[] getaddrinfoErrors;
        public Pair[] gethostbynameErrors;
        public NetworkId networkId;
        public int[] eventTypes;
        public int[] returnCodes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DNSLookupBatch[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DNSLookupBatch[0];
                    }
                }
            }
            return _emptyArray;
        }

        public DNSLookupBatch() {
            this.clear();
        }

        public DNSLookupBatch clear() {
            this.latenciesMs = WireFormatNano.EMPTY_INT_ARRAY;
            this.getaddrinfoQueryCount = 0L;
            this.gethostbynameQueryCount = 0L;
            this.getaddrinfoErrorCount = 0L;
            this.gethostbynameErrorCount = 0L;
            this.getaddrinfoErrors = Pair.emptyArray();
            this.gethostbynameErrors = Pair.emptyArray();
            this.networkId = null;
            this.eventTypes = WireFormatNano.EMPTY_INT_ARRAY;
            this.returnCodes = WireFormatNano.EMPTY_INT_ARRAY;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            Pair element;
            int i;
            if (this.networkId != null) {
                output.writeMessage(1, this.networkId);
            }
            if (this.eventTypes != null && this.eventTypes.length > 0) {
                for (i = 0; i < this.eventTypes.length; ++i) {
                    output.writeInt32(2, this.eventTypes[i]);
                }
            }
            if (this.returnCodes != null && this.returnCodes.length > 0) {
                for (i = 0; i < this.returnCodes.length; ++i) {
                    output.writeInt32(3, this.returnCodes[i]);
                }
            }
            if (this.latenciesMs != null && this.latenciesMs.length > 0) {
                for (i = 0; i < this.latenciesMs.length; ++i) {
                    output.writeInt32(4, this.latenciesMs[i]);
                }
            }
            if (this.getaddrinfoQueryCount != 0L) {
                output.writeInt64(5, this.getaddrinfoQueryCount);
            }
            if (this.gethostbynameQueryCount != 0L) {
                output.writeInt64(6, this.gethostbynameQueryCount);
            }
            if (this.getaddrinfoErrorCount != 0L) {
                output.writeInt64(7, this.getaddrinfoErrorCount);
            }
            if (this.gethostbynameErrorCount != 0L) {
                output.writeInt64(8, this.gethostbynameErrorCount);
            }
            if (this.getaddrinfoErrors != null && this.getaddrinfoErrors.length > 0) {
                for (i = 0; i < this.getaddrinfoErrors.length; ++i) {
                    element = this.getaddrinfoErrors[i];
                    if (element == null) continue;
                    output.writeMessage(9, element);
                }
            }
            if (this.gethostbynameErrors != null && this.gethostbynameErrors.length > 0) {
                for (i = 0; i < this.gethostbynameErrors.length; ++i) {
                    element = this.gethostbynameErrors[i];
                    if (element == null) continue;
                    output.writeMessage(10, element);
                }
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int i;
            int element;
            int i2;
            int dataSize;
            int size = super.computeSerializedSize();
            if (this.networkId != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(1, this.networkId);
            }
            if (this.eventTypes != null && this.eventTypes.length > 0) {
                dataSize = 0;
                for (i2 = 0; i2 < this.eventTypes.length; ++i2) {
                    element = this.eventTypes[i2];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.eventTypes.length;
            }
            if (this.returnCodes != null && this.returnCodes.length > 0) {
                dataSize = 0;
                for (i2 = 0; i2 < this.returnCodes.length; ++i2) {
                    element = this.returnCodes[i2];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.returnCodes.length;
            }
            if (this.latenciesMs != null && this.latenciesMs.length > 0) {
                dataSize = 0;
                for (i2 = 0; i2 < this.latenciesMs.length; ++i2) {
                    element = this.latenciesMs[i2];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.latenciesMs.length;
            }
            if (this.getaddrinfoQueryCount != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.getaddrinfoQueryCount);
            }
            if (this.gethostbynameQueryCount != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.gethostbynameQueryCount);
            }
            if (this.getaddrinfoErrorCount != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.getaddrinfoErrorCount);
            }
            if (this.gethostbynameErrorCount != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(8, this.gethostbynameErrorCount);
            }
            if (this.getaddrinfoErrors != null && this.getaddrinfoErrors.length > 0) {
                for (i = 0; i < this.getaddrinfoErrors.length; ++i) {
                    Pair element2 = this.getaddrinfoErrors[i];
                    if (element2 == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(9, element2);
                }
            }
            if (this.gethostbynameErrors != null && this.gethostbynameErrors.length > 0) {
                for (i = 0; i < this.gethostbynameErrors.length; ++i) {
                    Pair element3 = this.gethostbynameErrors[i];
                    if (element3 == null) continue;
                    size += CodedOutputByteBufferNano.computeMessageSize(10, element3);
                }
            }
            return size;
        }

        @Override
        public DNSLookupBatch mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block16: while (true) {
                int i;
                int arrayLength;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block16;
                        return this;
                    }
                    case 10: {
                        if (this.networkId == null) {
                            this.networkId = new NetworkId();
                        }
                        input.readMessage(this.networkId);
                        continue block16;
                    }
                    case 16: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 16);
                        i = this.eventTypes == null ? 0 : this.eventTypes.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy((int[])this.eventTypes, (int)0, (int[])newArray, (int)0, (int)i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.eventTypes = newArray;
                        continue block16;
                    }
                    case 18: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength2 = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength2;
                        }
                        input.rewindToPosition(startPos);
                        int i2 = this.eventTypes == null ? 0 : this.eventTypes.length;
                        int[] newArray = new int[i2 + arrayLength2];
                        if (i2 != 0) {
                            System.arraycopy((int[])this.eventTypes, (int)0, (int[])newArray, (int)0, (int)i2);
                        }
                        while (i2 < newArray.length) {
                            newArray[i2] = input.readInt32();
                            ++i2;
                        }
                        this.eventTypes = newArray;
                        input.popLimit(limit);
                        continue block16;
                    }
                    case 24: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 24);
                        i = this.returnCodes == null ? 0 : this.returnCodes.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy((int[])this.returnCodes, (int)0, (int[])newArray, (int)0, (int)i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.returnCodes = newArray;
                        continue block16;
                    }
                    case 26: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength3 = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength3;
                        }
                        input.rewindToPosition(startPos);
                        int i2 = this.returnCodes == null ? 0 : this.returnCodes.length;
                        int[] newArray = new int[i2 + arrayLength3];
                        if (i2 != 0) {
                            System.arraycopy((int[])this.returnCodes, (int)0, (int[])newArray, (int)0, (int)i2);
                        }
                        while (i2 < newArray.length) {
                            newArray[i2] = input.readInt32();
                            ++i2;
                        }
                        this.returnCodes = newArray;
                        input.popLimit(limit);
                        continue block16;
                    }
                    case 32: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 32);
                        i = this.latenciesMs == null ? 0 : this.latenciesMs.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy((int[])this.latenciesMs, (int)0, (int[])newArray, (int)0, (int)i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.latenciesMs = newArray;
                        continue block16;
                    }
                    case 34: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength4 = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength4;
                        }
                        input.rewindToPosition(startPos);
                        int i2 = this.latenciesMs == null ? 0 : this.latenciesMs.length;
                        int[] newArray = new int[i2 + arrayLength4];
                        if (i2 != 0) {
                            System.arraycopy((int[])this.latenciesMs, (int)0, (int[])newArray, (int)0, (int)i2);
                        }
                        while (i2 < newArray.length) {
                            newArray[i2] = input.readInt32();
                            ++i2;
                        }
                        this.latenciesMs = newArray;
                        input.popLimit(limit);
                        continue block16;
                    }
                    case 40: {
                        this.getaddrinfoQueryCount = input.readInt64();
                        continue block16;
                    }
                    case 48: {
                        this.gethostbynameQueryCount = input.readInt64();
                        continue block16;
                    }
                    case 56: {
                        this.getaddrinfoErrorCount = input.readInt64();
                        continue block16;
                    }
                    case 64: {
                        this.gethostbynameErrorCount = input.readInt64();
                        continue block16;
                    }
                    case 74: {
                        arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 74);
                        i = this.getaddrinfoErrors == null ? 0 : this.getaddrinfoErrors.length;
                        Pair[] newArray = new Pair[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy(this.getaddrinfoErrors, 0, newArray, 0, i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = new Pair();
                            input.readMessage(newArray[i]);
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = new Pair();
                        input.readMessage(newArray[i]);
                        this.getaddrinfoErrors = newArray;
                        continue block16;
                    }
                    case 82: 
                }
                arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 82);
                i = this.gethostbynameErrors == null ? 0 : this.gethostbynameErrors.length;
                Pair[] newArray = new Pair[i + arrayLength];
                if (i != 0) {
                    System.arraycopy(this.gethostbynameErrors, 0, newArray, 0, i);
                }
                while (i < newArray.length - 1) {
                    newArray[i] = new Pair();
                    input.readMessage(newArray[i]);
                    input.readTag();
                    ++i;
                }
                newArray[i] = new Pair();
                input.readMessage(newArray[i]);
                this.gethostbynameErrors = newArray;
            }
        }

        public static DNSLookupBatch parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new DNSLookupBatch(), data);
        }

        public static DNSLookupBatch parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new DNSLookupBatch().mergeFrom(input);
        }
    }

    public static final class ValidationProbeEvent
    extends MessageNano {
        private static volatile ValidationProbeEvent[] _emptyArray;
        public NetworkId networkId;
        public int latencyMs;
        public int probeType;
        public int probeResult;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ValidationProbeEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new ValidationProbeEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public ValidationProbeEvent() {
            this.clear();
        }

        public ValidationProbeEvent clear() {
            this.networkId = null;
            this.latencyMs = 0;
            this.probeType = 0;
            this.probeResult = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.networkId != null) {
                output.writeMessage(1, this.networkId);
            }
            if (this.latencyMs != 0) {
                output.writeInt32(2, this.latencyMs);
            }
            if (this.probeType != 0) {
                output.writeInt32(3, this.probeType);
            }
            if (this.probeResult != 0) {
                output.writeInt32(4, this.probeResult);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.networkId != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(1, this.networkId);
            }
            if (this.latencyMs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.latencyMs);
            }
            if (this.probeType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.probeType);
            }
            if (this.probeResult != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(4, this.probeResult);
            }
            return size;
        }

        @Override
        public ValidationProbeEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block7: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block7;
                        return this;
                    }
                    case 10: {
                        if (this.networkId == null) {
                            this.networkId = new NetworkId();
                        }
                        input.readMessage(this.networkId);
                        continue block7;
                    }
                    case 16: {
                        this.latencyMs = input.readInt32();
                        continue block7;
                    }
                    case 24: {
                        this.probeType = input.readInt32();
                        continue block7;
                    }
                    case 32: 
                }
                this.probeResult = input.readInt32();
            }
        }

        public static ValidationProbeEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new ValidationProbeEvent(), data);
        }

        public static ValidationProbeEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new ValidationProbeEvent().mergeFrom(input);
        }
    }

    public static final class NetworkEvent
    extends MessageNano {
        private static volatile NetworkEvent[] _emptyArray;
        public NetworkId networkId;
        public int eventType;
        public int latencyMs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NetworkEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new NetworkEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public NetworkEvent() {
            this.clear();
        }

        public NetworkEvent clear() {
            this.networkId = null;
            this.eventType = 0;
            this.latencyMs = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.networkId != null) {
                output.writeMessage(1, this.networkId);
            }
            if (this.eventType != 0) {
                output.writeInt32(2, this.eventType);
            }
            if (this.latencyMs != 0) {
                output.writeInt32(3, this.latencyMs);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.networkId != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(1, this.networkId);
            }
            if (this.eventType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.eventType);
            }
            if (this.latencyMs != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.latencyMs);
            }
            return size;
        }

        @Override
        public NetworkEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block6: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block6;
                        return this;
                    }
                    case 10: {
                        if (this.networkId == null) {
                            this.networkId = new NetworkId();
                        }
                        input.readMessage(this.networkId);
                        continue block6;
                    }
                    case 16: {
                        this.eventType = input.readInt32();
                        continue block6;
                    }
                    case 24: 
                }
                this.latencyMs = input.readInt32();
            }
        }

        public static NetworkEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new NetworkEvent(), data);
        }

        public static NetworkEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new NetworkEvent().mergeFrom(input);
        }
    }

    public static final class IpReachabilityEvent
    extends MessageNano {
        private static volatile IpReachabilityEvent[] _emptyArray;
        public String ifName;
        public int eventType;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static IpReachabilityEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new IpReachabilityEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public IpReachabilityEvent() {
            this.clear();
        }

        public IpReachabilityEvent clear() {
            this.ifName = "";
            this.eventType = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (!this.ifName.equals("")) {
                output.writeString(1, this.ifName);
            }
            if (this.eventType != 0) {
                output.writeInt32(2, this.eventType);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (!this.ifName.equals("")) {
                size += CodedOutputByteBufferNano.computeStringSize(1, this.ifName);
            }
            if (this.eventType != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.eventType);
            }
            return size;
        }

        @Override
        public IpReachabilityEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 10: {
                        this.ifName = input.readString();
                        continue block5;
                    }
                    case 16: 
                }
                this.eventType = input.readInt32();
            }
        }

        public static IpReachabilityEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new IpReachabilityEvent(), data);
        }

        public static IpReachabilityEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new IpReachabilityEvent().mergeFrom(input);
        }
    }

    public static final class DefaultNetworkEvent
    extends MessageNano {
        public static final int UNKNOWN = 0;
        public static final int OUTSCORED = 1;
        public static final int INVALIDATION = 2;
        public static final int DISCONNECT = 3;
        public static final int NONE = 0;
        public static final int IPV4 = 1;
        public static final int IPV6 = 2;
        public static final int DUAL = 3;
        private static volatile DefaultNetworkEvent[] _emptyArray;
        public long defaultNetworkDurationMs;
        public long noDefaultNetworkDurationMs;
        public long initialScore;
        public long finalScore;
        public int ipSupport;
        public NetworkId networkId;
        public NetworkId previousNetworkId;
        public int previousNetworkIpSupport;
        public int[] transportTypes;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static DefaultNetworkEvent[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new DefaultNetworkEvent[0];
                    }
                }
            }
            return _emptyArray;
        }

        public DefaultNetworkEvent() {
            this.clear();
        }

        public DefaultNetworkEvent clear() {
            this.defaultNetworkDurationMs = 0L;
            this.noDefaultNetworkDurationMs = 0L;
            this.initialScore = 0L;
            this.finalScore = 0L;
            this.ipSupport = 0;
            this.networkId = null;
            this.previousNetworkId = null;
            this.previousNetworkIpSupport = 0;
            this.transportTypes = WireFormatNano.EMPTY_INT_ARRAY;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.networkId != null) {
                output.writeMessage(1, this.networkId);
            }
            if (this.previousNetworkId != null) {
                output.writeMessage(2, this.previousNetworkId);
            }
            if (this.previousNetworkIpSupport != 0) {
                output.writeInt32(3, this.previousNetworkIpSupport);
            }
            if (this.transportTypes != null && this.transportTypes.length > 0) {
                for (int i = 0; i < this.transportTypes.length; ++i) {
                    output.writeInt32(4, this.transportTypes[i]);
                }
            }
            if (this.defaultNetworkDurationMs != 0L) {
                output.writeInt64(5, this.defaultNetworkDurationMs);
            }
            if (this.noDefaultNetworkDurationMs != 0L) {
                output.writeInt64(6, this.noDefaultNetworkDurationMs);
            }
            if (this.initialScore != 0L) {
                output.writeInt64(7, this.initialScore);
            }
            if (this.finalScore != 0L) {
                output.writeInt64(8, this.finalScore);
            }
            if (this.ipSupport != 0) {
                output.writeInt32(9, this.ipSupport);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.networkId != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(1, this.networkId);
            }
            if (this.previousNetworkId != null) {
                size += CodedOutputByteBufferNano.computeMessageSize(2, this.previousNetworkId);
            }
            if (this.previousNetworkIpSupport != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(3, this.previousNetworkIpSupport);
            }
            if (this.transportTypes != null && this.transportTypes.length > 0) {
                int dataSize = 0;
                for (int i = 0; i < this.transportTypes.length; ++i) {
                    int element = this.transportTypes[i];
                    dataSize += CodedOutputByteBufferNano.computeInt32SizeNoTag(element);
                }
                size += dataSize;
                size += 1 * this.transportTypes.length;
            }
            if (this.defaultNetworkDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(5, this.defaultNetworkDurationMs);
            }
            if (this.noDefaultNetworkDurationMs != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(6, this.noDefaultNetworkDurationMs);
            }
            if (this.initialScore != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(7, this.initialScore);
            }
            if (this.finalScore != 0L) {
                size += CodedOutputByteBufferNano.computeInt64Size(8, this.finalScore);
            }
            if (this.ipSupport != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(9, this.ipSupport);
            }
            return size;
        }

        @Override
        public DefaultNetworkEvent mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block19: while (true) {
                int value;
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block19;
                        return this;
                    }
                    case 10: {
                        if (this.networkId == null) {
                            this.networkId = new NetworkId();
                        }
                        input.readMessage(this.networkId);
                        continue block19;
                    }
                    case 18: {
                        if (this.previousNetworkId == null) {
                            this.previousNetworkId = new NetworkId();
                        }
                        input.readMessage(this.previousNetworkId);
                        continue block19;
                    }
                    case 24: {
                        value = input.readInt32();
                        switch (value) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: {
                                this.previousNetworkIpSupport = value;
                            }
                        }
                        continue block19;
                    }
                    case 32: {
                        int arrayLength = WireFormatNano.getRepeatedFieldArrayLength(input, 32);
                        int i = this.transportTypes == null ? 0 : this.transportTypes.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy((int[])this.transportTypes, (int)0, (int[])newArray, (int)0, (int)i);
                        }
                        while (i < newArray.length - 1) {
                            newArray[i] = input.readInt32();
                            input.readTag();
                            ++i;
                        }
                        newArray[i] = input.readInt32();
                        this.transportTypes = newArray;
                        continue block19;
                    }
                    case 34: {
                        int length = input.readRawVarint32();
                        int limit = input.pushLimit(length);
                        int arrayLength = 0;
                        int startPos = input.getPosition();
                        while (input.getBytesUntilLimit() > 0) {
                            input.readInt32();
                            ++arrayLength;
                        }
                        input.rewindToPosition(startPos);
                        int i = this.transportTypes == null ? 0 : this.transportTypes.length;
                        int[] newArray = new int[i + arrayLength];
                        if (i != 0) {
                            System.arraycopy((int[])this.transportTypes, (int)0, (int[])newArray, (int)0, (int)i);
                        }
                        while (i < newArray.length) {
                            newArray[i] = input.readInt32();
                            ++i;
                        }
                        this.transportTypes = newArray;
                        input.popLimit(limit);
                        continue block19;
                    }
                    case 40: {
                        this.defaultNetworkDurationMs = input.readInt64();
                        continue block19;
                    }
                    case 48: {
                        this.noDefaultNetworkDurationMs = input.readInt64();
                        continue block19;
                    }
                    case 56: {
                        this.initialScore = input.readInt64();
                        continue block19;
                    }
                    case 64: {
                        this.finalScore = input.readInt64();
                        continue block19;
                    }
                    case 72: 
                }
                value = input.readInt32();
                switch (value) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        this.ipSupport = value;
                    }
                }
            }
        }

        public static DefaultNetworkEvent parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new DefaultNetworkEvent(), data);
        }

        public static DefaultNetworkEvent parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new DefaultNetworkEvent().mergeFrom(input);
        }
    }

    public static final class Pair
    extends MessageNano {
        private static volatile Pair[] _emptyArray;
        public int key;
        public int value;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Pair[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new Pair[0];
                    }
                }
            }
            return _emptyArray;
        }

        public Pair() {
            this.clear();
        }

        public Pair clear() {
            this.key = 0;
            this.value = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.key != 0) {
                output.writeInt32(1, this.key);
            }
            if (this.value != 0) {
                output.writeInt32(2, this.value);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.key != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.key);
            }
            if (this.value != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(2, this.value);
            }
            return size;
        }

        @Override
        public Pair mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block5: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block5;
                        return this;
                    }
                    case 8: {
                        this.key = input.readInt32();
                        continue block5;
                    }
                    case 16: 
                }
                this.value = input.readInt32();
            }
        }

        public static Pair parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new Pair(), data);
        }

        public static Pair parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new Pair().mergeFrom(input);
        }
    }

    public static final class NetworkId
    extends MessageNano {
        private static volatile NetworkId[] _emptyArray;
        public int networkId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static NetworkId[] emptyArray() {
            if (_emptyArray == null) {
                Object object = InternalNano.LAZY_INIT_LOCK;
                synchronized (object) {
                    if (_emptyArray == null) {
                        _emptyArray = new NetworkId[0];
                    }
                }
            }
            return _emptyArray;
        }

        public NetworkId() {
            this.clear();
        }

        public NetworkId clear() {
            this.networkId = 0;
            this.cachedSize = -1;
            return this;
        }

        @Override
        public void writeTo(CodedOutputByteBufferNano output) throws IOException {
            if (this.networkId != 0) {
                output.writeInt32(1, this.networkId);
            }
            super.writeTo(output);
        }

        @Override
        protected int computeSerializedSize() {
            int size = super.computeSerializedSize();
            if (this.networkId != 0) {
                size += CodedOutputByteBufferNano.computeInt32Size(1, this.networkId);
            }
            return size;
        }

        @Override
        public NetworkId mergeFrom(CodedInputByteBufferNano input) throws IOException {
            block4: while (true) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        return this;
                    }
                    default: {
                        if (WireFormatNano.parseUnknownField(input, tag)) continue block4;
                        return this;
                    }
                    case 8: 
                }
                this.networkId = input.readInt32();
            }
        }

        public static NetworkId parseFrom(byte[] data) throws InvalidProtocolBufferNanoException {
            return MessageNano.mergeFrom(new NetworkId(), data);
        }

        public static NetworkId parseFrom(CodedInputByteBufferNano input) throws IOException {
            return new NetworkId().mergeFrom(input);
        }
    }
}

