/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.connectivity.tethering;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.LinkProperties;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkState;
import android.net.RouteInfo;
import android.net.util.SharedLog;
import android.util.Log;
import com.android.server.connectivity.tethering.TetherInterfaceStateMachine;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;

public class IPv6TetheringCoordinator {
    private static final String TAG = IPv6TetheringCoordinator.class.getSimpleName();
    private static final boolean DBG = false;
    private static final boolean VDBG = false;
    private final ArrayList<TetherInterfaceStateMachine> mNotifyList;
    private final SharedLog mLog;
    private final LinkedList<Downstream> mActiveDownstreams;
    private final byte[] mUniqueLocalPrefix;
    private short mNextSubnetId;
    private NetworkState mUpstreamNetworkState;

    public IPv6TetheringCoordinator(ArrayList<TetherInterfaceStateMachine> notifyList, SharedLog log) {
        this.mNotifyList = notifyList;
        this.mLog = log.forSubComponent(TAG);
        this.mActiveDownstreams = new LinkedList();
        this.mUniqueLocalPrefix = IPv6TetheringCoordinator.generateUniqueLocalPrefix();
        this.mNextSubnetId = 0;
    }

    public void addActiveDownstream(TetherInterfaceStateMachine downstream, int mode) {
        if (this.findDownstream(downstream) == null) {
            if (this.mActiveDownstreams.offer(new Downstream(downstream, mode, this.mNextSubnetId))) {
                this.mNextSubnetId = (short)Math.max(0, this.mNextSubnetId + 1);
            }
            this.updateIPv6TetheringInterfaces();
        }
    }

    public void removeActiveDownstream(TetherInterfaceStateMachine downstream) {
        IPv6TetheringCoordinator.stopIPv6TetheringOn(downstream);
        if (this.mActiveDownstreams.remove(this.findDownstream(downstream))) {
            this.updateIPv6TetheringInterfaces();
        }
        if (this.mNotifyList.isEmpty()) {
            if (!this.mActiveDownstreams.isEmpty()) {
                Log.wtf(TAG, "Tethering notify list empty, IPv6 downstreams non-empty.");
            }
            this.mNextSubnetId = 0;
        }
    }

    public void updateUpstreamNetworkState(NetworkState ns) {
        if (!IPv6TetheringCoordinator.canTetherIPv6(ns, this.mLog)) {
            this.stopIPv6TetheringOnAllInterfaces();
            this.setUpstreamNetworkState(null);
            return;
        }
        if (this.mUpstreamNetworkState != null && !ns.network.equals(this.mUpstreamNetworkState.network)) {
            this.stopIPv6TetheringOnAllInterfaces();
        }
        this.setUpstreamNetworkState(ns);
        this.updateIPv6TetheringInterfaces();
    }

    private void stopIPv6TetheringOnAllInterfaces() {
        for (TetherInterfaceStateMachine sm : this.mNotifyList) {
            IPv6TetheringCoordinator.stopIPv6TetheringOn(sm);
        }
    }

    private void setUpstreamNetworkState(NetworkState ns) {
        this.mUpstreamNetworkState = ns == null ? null : new NetworkState(null, new LinkProperties(ns.linkProperties), new NetworkCapabilities(ns.networkCapabilities), new Network(ns.network), null, null);
        this.mLog.log("setUpstreamNetworkState: " + IPv6TetheringCoordinator.toDebugString(this.mUpstreamNetworkState));
    }

    private void updateIPv6TetheringInterfaces() {
        block0: {
            Iterator<TetherInterfaceStateMachine> iterator = this.mNotifyList.iterator();
            if (!iterator.hasNext()) break block0;
            TetherInterfaceStateMachine sm = iterator.next();
            LinkProperties lp = this.getInterfaceIPv6LinkProperties(sm);
            sm.sendMessage(327793, 0, 0, lp);
        }
    }

    private LinkProperties getInterfaceIPv6LinkProperties(TetherInterfaceStateMachine sm) {
        LinkProperties lp;
        if (sm.interfaceType() == 2) {
            return null;
        }
        Downstream ds = this.findDownstream(sm);
        if (ds == null) {
            return null;
        }
        if (ds.mode == 3) {
            return IPv6TetheringCoordinator.getUniqueLocalConfig(this.mUniqueLocalPrefix, ds.subnetId);
        }
        if (this.mUpstreamNetworkState == null || this.mUpstreamNetworkState.linkProperties == null) {
            return null;
        }
        Downstream currentActive = this.mActiveDownstreams.peek();
        if (currentActive != null && currentActive.tism == sm && (lp = IPv6TetheringCoordinator.getIPv6OnlyLinkProperties(this.mUpstreamNetworkState.linkProperties)).hasIPv6DefaultRoute() && lp.hasGlobalIPv6Address()) {
            return lp;
        }
        return null;
    }

    Downstream findDownstream(TetherInterfaceStateMachine tism) {
        for (Downstream ds : this.mActiveDownstreams) {
            if (ds.tism != tism) continue;
            return ds;
        }
        return null;
    }

    private static boolean canTetherIPv6(NetworkState ns, SharedLog sharedLog) {
        boolean outcome;
        boolean canTether = ns != null && ns.network != null && ns.linkProperties != null && ns.networkCapabilities != null && ns.linkProperties.isProvisioned() && ns.linkProperties.hasIPv6DefaultRoute() && ns.linkProperties.hasGlobalIPv6Address() && ns.networkCapabilities.hasTransport(0);
        RouteInfo v4default = null;
        RouteInfo v6default = null;
        if (canTether) {
            for (RouteInfo r : ns.linkProperties.getAllRoutes()) {
                if (r.isIPv4Default()) {
                    v4default = r;
                } else if (r.isIPv6Default()) {
                    v6default = r;
                }
                if (v4default == null || v6default == null) continue;
                break;
            }
        }
        boolean supportedConfiguration = v4default != null && v6default != null && v4default.getInterface() != null && v4default.getInterface().equals(v6default.getInterface());
        boolean bl = outcome = canTether && supportedConfiguration;
        if (ns == null) {
            sharedLog.log("No available upstream.");
        } else {
            sharedLog.log(String.format("IPv6 tethering is %s for upstream: %s", outcome ? "available" : "not available", IPv6TetheringCoordinator.toDebugString(ns)));
        }
        return outcome;
    }

    private static LinkProperties getIPv6OnlyLinkProperties(LinkProperties lp) {
        LinkProperties v6only = new LinkProperties();
        if (lp == null) {
            return v6only;
        }
        v6only.setInterfaceName(lp.getInterfaceName());
        v6only.setMtu(lp.getMtu());
        for (LinkAddress linkAddr : lp.getLinkAddresses()) {
            if (!linkAddr.isGlobalPreferred() || linkAddr.getPrefixLength() != 64) continue;
            v6only.addLinkAddress(linkAddr);
        }
        for (RouteInfo routeInfo : lp.getRoutes()) {
            IpPrefix destination = routeInfo.getDestination();
            if (!(destination.getAddress() instanceof Inet6Address) || destination.getPrefixLength() > 64) continue;
            v6only.addRoute(routeInfo);
        }
        for (InetAddress dnsServer : lp.getDnsServers()) {
            if (!IPv6TetheringCoordinator.isIPv6GlobalAddress(dnsServer)) continue;
            v6only.addDnsServer(dnsServer);
        }
        v6only.setDomains(lp.getDomains());
        return v6only;
    }

    private static boolean isIPv6GlobalAddress(InetAddress ip) {
        return ip instanceof Inet6Address && !ip.isAnyLocalAddress() && !ip.isLoopbackAddress() && !ip.isLinkLocalAddress() && !ip.isSiteLocalAddress() && !ip.isMulticastAddress();
    }

    private static LinkProperties getUniqueLocalConfig(byte[] ulp, short subnetId) {
        LinkProperties lp = new LinkProperties();
        IpPrefix local48 = IPv6TetheringCoordinator.makeUniqueLocalPrefix(ulp, (short)0, 48);
        lp.addRoute(new RouteInfo(local48, null, null));
        IpPrefix local64 = IPv6TetheringCoordinator.makeUniqueLocalPrefix(ulp, subnetId, 64);
        lp.addLinkAddress(new LinkAddress(local64.getAddress(), 64));
        lp.setMtu(1500);
        return lp;
    }

    private static IpPrefix makeUniqueLocalPrefix(byte[] in6addr, short subnetId, int prefixlen) {
        byte[] bytes = Arrays.copyOf(in6addr, in6addr.length);
        bytes[7] = (byte)(subnetId >> 8);
        bytes[8] = (byte)subnetId;
        return new IpPrefix(bytes, prefixlen);
    }

    private static byte[] generateUniqueLocalPrefix() {
        byte[] ulp = new byte[6];
        new Random().nextBytes(ulp);
        byte[] in6addr = Arrays.copyOf(ulp, 16);
        in6addr[0] = -3;
        return in6addr;
    }

    private static String toDebugString(NetworkState ns) {
        if (ns == null) {
            return "NetworkState{null}";
        }
        return String.format("NetworkState{%s, %s, %s}", ns.network, ns.networkCapabilities, ns.linkProperties);
    }

    private static void stopIPv6TetheringOn(TetherInterfaceStateMachine sm) {
        sm.sendMessage(327793, 0, 0, null);
    }

    private static class Downstream {
        public final TetherInterfaceStateMachine tism;
        public final int mode;
        public final short subnetId;

        Downstream(TetherInterfaceStateMachine tism, int mode, short subnetId) {
            this.tism = tism;
            this.mode = mode;
            this.subnetId = subnetId;
        }
    }
}

