/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.display;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.display.WifiDisplay;
import android.hardware.display.WifiDisplaySessionInfo;
import android.hardware.display.WifiDisplayStatus;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.UserHandle;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceControl;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.display.DisplayAdapter;
import com.android.server.display.DisplayDevice;
import com.android.server.display.DisplayDeviceInfo;
import com.android.server.display.DisplayManagerService;
import com.android.server.display.PersistentDataStore;
import com.android.server.display.WifiDisplayController;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import libcore.util.Objects;

final class WifiDisplayAdapter
extends DisplayAdapter {
    private static final String TAG = "WifiDisplayAdapter";
    private static final boolean DEBUG = false;
    private static final int MSG_SEND_STATUS_CHANGE_BROADCAST = 1;
    private static final String ACTION_DISCONNECT = "android.server.display.wfd.DISCONNECT";
    private static final String DISPLAY_NAME_PREFIX = "wifi:";
    private final WifiDisplayHandler mHandler;
    private final PersistentDataStore mPersistentDataStore;
    private final boolean mSupportsProtectedBuffers;
    private WifiDisplayController mDisplayController;
    private WifiDisplayDevice mDisplayDevice;
    private WifiDisplayStatus mCurrentStatus;
    private int mFeatureState;
    private int mScanState;
    private int mActiveDisplayState;
    private WifiDisplay mActiveDisplay;
    private WifiDisplay[] mDisplays = WifiDisplay.EMPTY_ARRAY;
    private WifiDisplay[] mAvailableDisplays = WifiDisplay.EMPTY_ARRAY;
    private WifiDisplay[] mRememberedDisplays = WifiDisplay.EMPTY_ARRAY;
    private WifiDisplaySessionInfo mSessionInfo;
    private boolean mPendingStatusChangeBroadcast;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals(WifiDisplayAdapter.ACTION_DISCONNECT)) {
                DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
                synchronized (syncRoot) {
                    WifiDisplayAdapter.this.requestDisconnectLocked();
                }
            }
        }
    };
    private final WifiDisplayController.Listener mWifiDisplayListener = new WifiDisplayController.Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFeatureStateChanged(int featureState) {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (WifiDisplayAdapter.this.mFeatureState != featureState) {
                    WifiDisplayAdapter.this.mFeatureState = featureState;
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScanStarted() {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (WifiDisplayAdapter.this.mScanState != 1) {
                    WifiDisplayAdapter.this.mScanState = 1;
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScanResults(WifiDisplay[] availableDisplays) {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                availableDisplays = WifiDisplayAdapter.this.mPersistentDataStore.applyWifiDisplayAliases(availableDisplays);
                boolean changed = !Arrays.equals(WifiDisplayAdapter.this.mAvailableDisplays, availableDisplays);
                for (int i = 0; !changed && i < availableDisplays.length; ++i) {
                    changed = availableDisplays[i].canConnect() != WifiDisplayAdapter.this.mAvailableDisplays[i].canConnect();
                }
                if (changed) {
                    WifiDisplayAdapter.access$802(WifiDisplayAdapter.this, availableDisplays);
                    WifiDisplayAdapter.this.fixRememberedDisplayNamesFromAvailableDisplaysLocked();
                    WifiDisplayAdapter.this.updateDisplaysLocked();
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onScanFinished() {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (WifiDisplayAdapter.this.mScanState != 0) {
                    WifiDisplayAdapter.this.mScanState = 0;
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayConnecting(WifiDisplay display) {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                display = WifiDisplayAdapter.this.mPersistentDataStore.applyWifiDisplayAlias(display);
                if (WifiDisplayAdapter.this.mActiveDisplayState != 1 || WifiDisplayAdapter.this.mActiveDisplay == null || !WifiDisplayAdapter.this.mActiveDisplay.equals(display)) {
                    WifiDisplayAdapter.this.mActiveDisplayState = 1;
                    WifiDisplayAdapter.this.mActiveDisplay = display;
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayConnectionFailed() {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                if (WifiDisplayAdapter.this.mActiveDisplayState != 0 || WifiDisplayAdapter.this.mActiveDisplay != null) {
                    WifiDisplayAdapter.this.mActiveDisplayState = 0;
                    WifiDisplayAdapter.this.mActiveDisplay = null;
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayConnected(WifiDisplay display, Surface surface, int width, int height, int flags) {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                display = WifiDisplayAdapter.this.mPersistentDataStore.applyWifiDisplayAlias(display);
                WifiDisplayAdapter.this.addDisplayDeviceLocked(display, surface, width, height, flags);
                if (WifiDisplayAdapter.this.mActiveDisplayState != 2 || WifiDisplayAdapter.this.mActiveDisplay == null || !WifiDisplayAdapter.this.mActiveDisplay.equals(display)) {
                    WifiDisplayAdapter.this.mActiveDisplayState = 2;
                    WifiDisplayAdapter.this.mActiveDisplay = display;
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplaySessionInfo(WifiDisplaySessionInfo sessionInfo) {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                WifiDisplayAdapter.this.mSessionInfo = sessionInfo;
                WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayChanged(WifiDisplay display) {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                display = WifiDisplayAdapter.this.mPersistentDataStore.applyWifiDisplayAlias(display);
                if (WifiDisplayAdapter.this.mActiveDisplay != null && WifiDisplayAdapter.this.mActiveDisplay.hasSameAddress(display) && !WifiDisplayAdapter.this.mActiveDisplay.equals(display)) {
                    WifiDisplayAdapter.this.mActiveDisplay = display;
                    WifiDisplayAdapter.this.renameDisplayDeviceLocked(display.getFriendlyDisplayName());
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDisplayDisconnected() {
            DisplayManagerService.SyncRoot syncRoot = WifiDisplayAdapter.this.getSyncRoot();
            synchronized (syncRoot) {
                WifiDisplayAdapter.this.removeDisplayDeviceLocked();
                if (WifiDisplayAdapter.this.mActiveDisplayState != 0 || WifiDisplayAdapter.this.mActiveDisplay != null) {
                    WifiDisplayAdapter.this.mActiveDisplayState = 0;
                    WifiDisplayAdapter.this.mActiveDisplay = null;
                    WifiDisplayAdapter.this.scheduleStatusChangedBroadcastLocked();
                }
            }
        }
    };

    public WifiDisplayAdapter(DisplayManagerService.SyncRoot syncRoot, Context context, Handler handler, DisplayAdapter.Listener listener, PersistentDataStore persistentDataStore) {
        super(syncRoot, context, handler, listener, TAG);
        this.mHandler = new WifiDisplayHandler(handler.getLooper());
        this.mPersistentDataStore = persistentDataStore;
        this.mSupportsProtectedBuffers = context.getResources().getBoolean(17957055);
    }

    @Override
    public void dumpLocked(PrintWriter pw) {
        super.dumpLocked(pw);
        pw.println("mCurrentStatus=" + this.getWifiDisplayStatusLocked());
        pw.println("mFeatureState=" + this.mFeatureState);
        pw.println("mScanState=" + this.mScanState);
        pw.println("mActiveDisplayState=" + this.mActiveDisplayState);
        pw.println("mActiveDisplay=" + this.mActiveDisplay);
        pw.println("mDisplays=" + Arrays.toString(this.mDisplays));
        pw.println("mAvailableDisplays=" + Arrays.toString(this.mAvailableDisplays));
        pw.println("mRememberedDisplays=" + Arrays.toString(this.mRememberedDisplays));
        pw.println("mPendingStatusChangeBroadcast=" + this.mPendingStatusChangeBroadcast);
        pw.println("mSupportsProtectedBuffers=" + this.mSupportsProtectedBuffers);
        if (this.mDisplayController == null) {
            pw.println("mDisplayController=null");
        } else {
            pw.println("mDisplayController:");
            IndentingPrintWriter ipw = new IndentingPrintWriter((Writer)pw, "  ");
            ipw.increaseIndent();
            DumpUtils.dumpAsync(this.getHandler(), this.mDisplayController, ipw, "", 200L);
        }
    }

    @Override
    public void registerLocked() {
        super.registerLocked();
        this.updateRememberedDisplaysLocked();
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                WifiDisplayAdapter.this.mDisplayController = new WifiDisplayController(WifiDisplayAdapter.this.getContext(), WifiDisplayAdapter.this.getHandler(), WifiDisplayAdapter.this.mWifiDisplayListener);
                WifiDisplayAdapter.this.getContext().registerReceiverAsUser(WifiDisplayAdapter.this.mBroadcastReceiver, UserHandle.ALL, new IntentFilter(WifiDisplayAdapter.ACTION_DISCONNECT), null, WifiDisplayAdapter.this.mHandler);
            }
        });
    }

    public void requestStartScanLocked() {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (WifiDisplayAdapter.this.mDisplayController != null) {
                    WifiDisplayAdapter.this.mDisplayController.requestStartScan();
                }
            }
        });
    }

    public void requestStopScanLocked() {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (WifiDisplayAdapter.this.mDisplayController != null) {
                    WifiDisplayAdapter.this.mDisplayController.requestStopScan();
                }
            }
        });
    }

    public void requestConnectLocked(final String address) {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (WifiDisplayAdapter.this.mDisplayController != null) {
                    WifiDisplayAdapter.this.mDisplayController.requestConnect(address);
                }
            }
        });
    }

    public void requestPauseLocked() {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (WifiDisplayAdapter.this.mDisplayController != null) {
                    WifiDisplayAdapter.this.mDisplayController.requestPause();
                }
            }
        });
    }

    public void requestResumeLocked() {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (WifiDisplayAdapter.this.mDisplayController != null) {
                    WifiDisplayAdapter.this.mDisplayController.requestResume();
                }
            }
        });
    }

    public void requestDisconnectLocked() {
        this.getHandler().post(new Runnable(){

            @Override
            public void run() {
                if (WifiDisplayAdapter.this.mDisplayController != null) {
                    WifiDisplayAdapter.this.mDisplayController.requestDisconnect();
                }
            }
        });
    }

    public void requestRenameLocked(String address, String alias) {
        WifiDisplay display;
        if (alias != null && ((alias = alias.trim()).isEmpty() || alias.equals(address))) {
            alias = null;
        }
        if ((display = this.mPersistentDataStore.getRememberedWifiDisplay(address)) != null && !Objects.equal(display.getDeviceAlias(), alias) && this.mPersistentDataStore.rememberWifiDisplay(display = new WifiDisplay(address, display.getDeviceName(), alias, false, false, false))) {
            this.mPersistentDataStore.saveIfNeeded();
            this.updateRememberedDisplaysLocked();
            this.scheduleStatusChangedBroadcastLocked();
        }
        if (this.mActiveDisplay != null && this.mActiveDisplay.getDeviceAddress().equals(address)) {
            this.renameDisplayDeviceLocked(this.mActiveDisplay.getFriendlyDisplayName());
        }
    }

    public void requestForgetLocked(String address) {
        if (this.mPersistentDataStore.forgetWifiDisplay(address)) {
            this.mPersistentDataStore.saveIfNeeded();
            this.updateRememberedDisplaysLocked();
            this.scheduleStatusChangedBroadcastLocked();
        }
        if (this.mActiveDisplay != null && this.mActiveDisplay.getDeviceAddress().equals(address)) {
            this.requestDisconnectLocked();
        }
    }

    public WifiDisplayStatus getWifiDisplayStatusLocked() {
        if (this.mCurrentStatus == null) {
            this.mCurrentStatus = new WifiDisplayStatus(this.mFeatureState, this.mScanState, this.mActiveDisplayState, this.mActiveDisplay, this.mDisplays, this.mSessionInfo);
        }
        return this.mCurrentStatus;
    }

    private void updateDisplaysLocked() {
        ArrayList<WifiDisplay> displays = new ArrayList<WifiDisplay>(this.mAvailableDisplays.length + this.mRememberedDisplays.length);
        boolean[] remembered = new boolean[this.mAvailableDisplays.length];
        for (WifiDisplay d : this.mRememberedDisplays) {
            boolean available = false;
            for (int i = 0; i < this.mAvailableDisplays.length; ++i) {
                if (!d.equals(this.mAvailableDisplays[i])) continue;
                available = true;
                remembered[i] = true;
                break;
            }
            if (available) continue;
            displays.add(new WifiDisplay(d.getDeviceAddress(), d.getDeviceName(), d.getDeviceAlias(), false, false, true));
        }
        for (int i = 0; i < this.mAvailableDisplays.length; ++i) {
            WifiDisplay d = this.mAvailableDisplays[i];
            displays.add(new WifiDisplay(d.getDeviceAddress(), d.getDeviceName(), d.getDeviceAlias(), true, d.canConnect(), remembered[i]));
        }
        this.mDisplays = displays.toArray(WifiDisplay.EMPTY_ARRAY);
    }

    private void updateRememberedDisplaysLocked() {
        this.mRememberedDisplays = this.mPersistentDataStore.getRememberedWifiDisplays();
        this.mActiveDisplay = this.mPersistentDataStore.applyWifiDisplayAlias(this.mActiveDisplay);
        this.mAvailableDisplays = this.mPersistentDataStore.applyWifiDisplayAliases(this.mAvailableDisplays);
        this.updateDisplaysLocked();
    }

    private void fixRememberedDisplayNamesFromAvailableDisplaysLocked() {
        boolean changed = false;
        for (int i = 0; i < this.mRememberedDisplays.length; ++i) {
            WifiDisplay rememberedDisplay = this.mRememberedDisplays[i];
            WifiDisplay availableDisplay = this.findAvailableDisplayLocked(rememberedDisplay.getDeviceAddress());
            if (availableDisplay == null || rememberedDisplay.equals(availableDisplay)) continue;
            this.mRememberedDisplays[i] = availableDisplay;
            changed |= this.mPersistentDataStore.rememberWifiDisplay(availableDisplay);
        }
        if (changed) {
            this.mPersistentDataStore.saveIfNeeded();
        }
    }

    private WifiDisplay findAvailableDisplayLocked(String address) {
        for (WifiDisplay display : this.mAvailableDisplays) {
            if (!display.getDeviceAddress().equals(address)) continue;
            return display;
        }
        return null;
    }

    private void addDisplayDeviceLocked(WifiDisplay display, Surface surface, int width, int height, int flags) {
        this.removeDisplayDeviceLocked();
        if (this.mPersistentDataStore.rememberWifiDisplay(display)) {
            this.mPersistentDataStore.saveIfNeeded();
            this.updateRememberedDisplaysLocked();
            this.scheduleStatusChangedBroadcastLocked();
        }
        boolean secure = (flags & 1) != 0;
        int deviceFlags = 64;
        if (secure) {
            deviceFlags |= 4;
            if (this.mSupportsProtectedBuffers) {
                deviceFlags |= 8;
            }
        }
        float refreshRate = 60.0f;
        String name = display.getFriendlyDisplayName();
        String address = display.getDeviceAddress();
        IBinder displayToken = SurfaceControl.createDisplay(name, secure);
        this.mDisplayDevice = new WifiDisplayDevice(displayToken, name, width, height, refreshRate, deviceFlags, address, surface);
        this.sendDisplayDeviceEventLocked(this.mDisplayDevice, 1);
    }

    private void removeDisplayDeviceLocked() {
        if (this.mDisplayDevice != null) {
            this.mDisplayDevice.destroyLocked();
            this.sendDisplayDeviceEventLocked(this.mDisplayDevice, 3);
            this.mDisplayDevice = null;
        }
    }

    private void renameDisplayDeviceLocked(String name) {
        if (this.mDisplayDevice != null && !this.mDisplayDevice.getNameLocked().equals(name)) {
            this.mDisplayDevice.setNameLocked(name);
            this.sendDisplayDeviceEventLocked(this.mDisplayDevice, 2);
        }
    }

    private void scheduleStatusChangedBroadcastLocked() {
        this.mCurrentStatus = null;
        if (!this.mPendingStatusChangeBroadcast) {
            this.mPendingStatusChangeBroadcast = true;
            this.mHandler.sendEmptyMessage(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSendStatusChangeBroadcast() {
        Intent intent;
        DisplayManagerService.SyncRoot syncRoot = this.getSyncRoot();
        synchronized (syncRoot) {
            if (!this.mPendingStatusChangeBroadcast) {
                return;
            }
            this.mPendingStatusChangeBroadcast = false;
            intent = new Intent("android.hardware.display.action.WIFI_DISPLAY_STATUS_CHANGED");
            intent.addFlags(0x40000000);
            intent.putExtra("android.hardware.display.extra.WIFI_DISPLAY_STATUS", this.getWifiDisplayStatusLocked());
        }
        this.getContext().sendBroadcastAsUser(intent, UserHandle.ALL);
    }

    static /* synthetic */ WifiDisplay[] access$802(WifiDisplayAdapter x0, WifiDisplay[] x1) {
        x0.mAvailableDisplays = x1;
        return x1;
    }

    private final class WifiDisplayHandler
    extends Handler {
        public WifiDisplayHandler(Looper looper) {
            super(looper, null, true);
        }

        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    WifiDisplayAdapter.this.handleSendStatusChangeBroadcast();
                }
            }
        }
    }

    private final class WifiDisplayDevice
    extends DisplayDevice {
        private String mName;
        private final int mWidth;
        private final int mHeight;
        private final float mRefreshRate;
        private final int mFlags;
        private final String mAddress;
        private final Display.Mode mMode;
        private Surface mSurface;
        private DisplayDeviceInfo mInfo;

        public WifiDisplayDevice(IBinder displayToken, String name, int width, int height, float refreshRate, int flags, String address, Surface surface) {
            super(WifiDisplayAdapter.this, displayToken, WifiDisplayAdapter.DISPLAY_NAME_PREFIX + address);
            this.mName = name;
            this.mWidth = width;
            this.mHeight = height;
            this.mRefreshRate = refreshRate;
            this.mFlags = flags;
            this.mAddress = address;
            this.mSurface = surface;
            this.mMode = DisplayAdapter.createMode(width, height, refreshRate);
        }

        @Override
        public boolean hasStableUniqueId() {
            return true;
        }

        public void destroyLocked() {
            if (this.mSurface != null) {
                this.mSurface.release();
                this.mSurface = null;
            }
            SurfaceControl.destroyDisplay(this.getDisplayTokenLocked());
        }

        public void setNameLocked(String name) {
            this.mName = name;
            this.mInfo = null;
        }

        @Override
        public void performTraversalInTransactionLocked() {
            if (this.mSurface != null) {
                this.setSurfaceInTransactionLocked(this.mSurface);
            }
        }

        @Override
        public DisplayDeviceInfo getDisplayDeviceInfoLocked() {
            if (this.mInfo == null) {
                this.mInfo = new DisplayDeviceInfo();
                this.mInfo.name = this.mName;
                this.mInfo.uniqueId = this.getUniqueId();
                this.mInfo.width = this.mWidth;
                this.mInfo.height = this.mHeight;
                this.mInfo.modeId = this.mMode.getModeId();
                this.mInfo.defaultModeId = this.mMode.getModeId();
                this.mInfo.supportedModes = new Display.Mode[]{this.mMode};
                this.mInfo.presentationDeadlineNanos = 1000000000L / (long)((int)this.mRefreshRate);
                this.mInfo.flags = this.mFlags;
                this.mInfo.type = 3;
                this.mInfo.address = this.mAddress;
                this.mInfo.touch = 2;
                this.mInfo.setAssumedDensityForExternalDisplay(this.mWidth, this.mHeight);
            }
            return this.mInfo;
        }
    }
}

