/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.HdmiPortInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.MessageQueue;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.hdmi.HdmiAnnotations;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessage;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiControlService;
import com.android.server.hdmi.HdmiLogger;
import com.android.server.hdmi.HdmiUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Predicate;
import libcore.util.EmptyArray;
import sun.util.locale.LanguageTag;

final class HdmiCecController {
    private static final String TAG = "HdmiCecController";
    private static final byte[] EMPTY_BODY = EmptyArray.BYTE;
    private static final int NUM_LOGICAL_ADDRESS = 16;
    private static final int MAX_CEC_MESSAGE_HISTORY = 20;
    private final Predicate<Integer> mRemoteDeviceAddressPredicate = new Predicate<Integer>(){

        @Override
        public boolean test(Integer address) {
            return !HdmiCecController.this.isAllocatedLocalDeviceAddress(address);
        }
    };
    private final Predicate<Integer> mSystemAudioAddressPredicate = new Predicate<Integer>(){

        @Override
        public boolean test(Integer address) {
            return HdmiUtils.getTypeFromAddress(address) == 5;
        }
    };
    private Handler mIoHandler;
    private Handler mControlHandler;
    private volatile long mNativePtr;
    private final HdmiControlService mService;
    private final SparseArray<HdmiCecLocalDevice> mLocalDevices = new SparseArray();
    private final ArrayBlockingQueue<MessageHistoryRecord> mMessageHistory = new ArrayBlockingQueue(20);

    private HdmiCecController(HdmiControlService service) {
        this.mService = service;
    }

    static HdmiCecController create(HdmiControlService service) {
        HdmiCecController controller = new HdmiCecController(service);
        long nativePtr = HdmiCecController.nativeInit(controller, service.getServiceLooper().getQueue());
        if (nativePtr == 0L) {
            controller = null;
            return null;
        }
        controller.init(nativePtr);
        return controller;
    }

    private void init(long nativePtr) {
        this.mIoHandler = new Handler(this.mService.getIoLooper());
        this.mControlHandler = new Handler(this.mService.getServiceLooper());
        this.mNativePtr = nativePtr;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void addLocalDevice(int deviceType, HdmiCecLocalDevice device) {
        this.assertRunOnServiceThread();
        this.mLocalDevices.put(deviceType, device);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void allocateLogicalAddress(final int deviceType, final int preferredAddress, final AllocateAddressCallback callback) {
        this.assertRunOnServiceThread();
        this.runOnIoThread(new Runnable(){

            @Override
            public void run() {
                HdmiCecController.this.handleAllocateLogicalAddress(deviceType, preferredAddress, callback);
            }
        });
    }

    @HdmiAnnotations.IoThreadOnly
    private void handleAllocateLogicalAddress(final int deviceType, int preferredAddress, final AllocateAddressCallback callback) {
        this.assertRunOnIoThread();
        int startAddress = preferredAddress;
        if (preferredAddress == 15) {
            for (int i = 0; i < 16; ++i) {
                if (deviceType != HdmiUtils.getTypeFromAddress(i)) continue;
                startAddress = i;
                break;
            }
        }
        int logicalAddress = 15;
        for (int i = 0; i < 16; ++i) {
            int curAddress = (startAddress + i) % 16;
            if (curAddress == 15 || deviceType != HdmiUtils.getTypeFromAddress(curAddress)) continue;
            boolean acked = false;
            for (int j = 0; j < 3; ++j) {
                if (!this.sendPollMessage(curAddress, curAddress, 1)) continue;
                acked = true;
                break;
            }
            if (acked) continue;
            logicalAddress = curAddress;
            break;
        }
        final int assignedAddress = logicalAddress;
        HdmiLogger.debug("New logical address for device [%d]: [preferred:%d, assigned:%d]", deviceType, preferredAddress, assignedAddress);
        if (callback != null) {
            this.runOnServiceThread(new Runnable(){

                @Override
                public void run() {
                    callback.onAllocated(deviceType, assignedAddress);
                }
            });
        }
    }

    private static byte[] buildBody(int opcode, byte[] params) {
        byte[] body = new byte[params.length + 1];
        body[0] = (byte)opcode;
        System.arraycopy((byte[])params, (int)0, (byte[])body, (int)1, (int)params.length);
        return body;
    }

    HdmiPortInfo[] getPortInfos() {
        return HdmiCecController.nativeGetPortInfos(this.mNativePtr);
    }

    HdmiCecLocalDevice getLocalDevice(int deviceType) {
        return this.mLocalDevices.get(deviceType);
    }

    @HdmiAnnotations.ServiceThreadOnly
    int addLogicalAddress(int newLogicalAddress) {
        this.assertRunOnServiceThread();
        if (HdmiUtils.isValidAddress(newLogicalAddress)) {
            return HdmiCecController.nativeAddLogicalAddress(this.mNativePtr, newLogicalAddress);
        }
        return 2;
    }

    @HdmiAnnotations.ServiceThreadOnly
    void clearLogicalAddress() {
        this.assertRunOnServiceThread();
        for (int i = 0; i < this.mLocalDevices.size(); ++i) {
            this.mLocalDevices.valueAt(i).clearAddress();
        }
        HdmiCecController.nativeClearLogicalAddress(this.mNativePtr);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void clearLocalDevices() {
        this.assertRunOnServiceThread();
        this.mLocalDevices.clear();
    }

    @HdmiAnnotations.ServiceThreadOnly
    int getPhysicalAddress() {
        this.assertRunOnServiceThread();
        return HdmiCecController.nativeGetPhysicalAddress(this.mNativePtr);
    }

    @HdmiAnnotations.ServiceThreadOnly
    int getVersion() {
        this.assertRunOnServiceThread();
        return HdmiCecController.nativeGetVersion(this.mNativePtr);
    }

    @HdmiAnnotations.ServiceThreadOnly
    int getVendorId() {
        this.assertRunOnServiceThread();
        return HdmiCecController.nativeGetVendorId(this.mNativePtr);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setOption(int flag, boolean enabled) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("setOption: [flag:%d, enabled:%b]", flag, enabled);
        HdmiCecController.nativeSetOption(this.mNativePtr, flag, enabled);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void setLanguage(String language) {
        this.assertRunOnServiceThread();
        if (!LanguageTag.isLanguage(language)) {
            return;
        }
        HdmiCecController.nativeSetLanguage(this.mNativePtr, language);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void enableAudioReturnChannel(int port, boolean enabled) {
        this.assertRunOnServiceThread();
        HdmiCecController.nativeEnableAudioReturnChannel(this.mNativePtr, port, enabled);
    }

    @HdmiAnnotations.ServiceThreadOnly
    boolean isConnected(int port) {
        this.assertRunOnServiceThread();
        return HdmiCecController.nativeIsConnected(this.mNativePtr, port);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void pollDevices(HdmiControlService.DevicePollingCallback callback, int sourceAddress, int pickStrategy, int retryCount) {
        this.assertRunOnServiceThread();
        List<Integer> pollingCandidates = this.pickPollCandidates(pickStrategy);
        ArrayList<Integer> allocated = new ArrayList<Integer>();
        this.runDevicePolling(sourceAddress, pollingCandidates, retryCount, callback, allocated);
    }

    @HdmiAnnotations.ServiceThreadOnly
    List<HdmiCecLocalDevice> getLocalDeviceList() {
        this.assertRunOnServiceThread();
        return HdmiUtils.sparseArrayToList(this.mLocalDevices);
    }

    private List<Integer> pickPollCandidates(int pickStrategy) {
        int strategy = pickStrategy & 3;
        Predicate<Integer> pickPredicate = null;
        switch (strategy) {
            case 2: {
                pickPredicate = this.mSystemAudioAddressPredicate;
                break;
            }
            default: {
                pickPredicate = this.mRemoteDeviceAddressPredicate;
            }
        }
        int iterationStrategy = pickStrategy & 0x30000;
        LinkedList<Integer> pollingCandidates = new LinkedList<Integer>();
        switch (iterationStrategy) {
            case 65536: {
                for (int i = 0; i <= 14; ++i) {
                    if (!pickPredicate.test(i)) continue;
                    pollingCandidates.add(i);
                }
                break;
            }
            default: {
                for (int i = 14; i >= 0; --i) {
                    if (!pickPredicate.test(i)) continue;
                    pollingCandidates.add(i);
                }
            }
        }
        return pollingCandidates;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private boolean isAllocatedLocalDeviceAddress(int address) {
        this.assertRunOnServiceThread();
        for (int i = 0; i < this.mLocalDevices.size(); ++i) {
            if (!this.mLocalDevices.valueAt(i).isAddressOf(address)) continue;
            return true;
        }
        return false;
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void runDevicePolling(final int sourceAddress, final List<Integer> candidates, final int retryCount, final HdmiControlService.DevicePollingCallback callback, final List<Integer> allocated) {
        this.assertRunOnServiceThread();
        if (candidates.isEmpty()) {
            if (callback != null) {
                HdmiLogger.debug("[P]:AllocatedAddress=%s", allocated.toString());
                callback.onPollingFinished(allocated);
            }
            return;
        }
        final Integer candidate = candidates.remove(0);
        this.runOnIoThread(new Runnable(){

            @Override
            public void run() {
                if (HdmiCecController.this.sendPollMessage(sourceAddress, candidate, retryCount)) {
                    allocated.add(candidate);
                }
                HdmiCecController.this.runOnServiceThread(new Runnable(){

                    @Override
                    public void run() {
                        HdmiCecController.this.runDevicePolling(sourceAddress, candidates, retryCount, callback, allocated);
                    }
                });
            }
        });
    }

    @HdmiAnnotations.IoThreadOnly
    private boolean sendPollMessage(int sourceAddress, int destinationAddress, int retryCount) {
        this.assertRunOnIoThread();
        for (int i = 0; i < retryCount; ++i) {
            int ret = HdmiCecController.nativeSendCecCommand(this.mNativePtr, sourceAddress, destinationAddress, EMPTY_BODY);
            if (ret == 0) {
                return true;
            }
            if (ret == 1) continue;
            HdmiLogger.warning("Failed to send a polling message(%d->%d) with return code %d", sourceAddress, destinationAddress, ret);
        }
        return false;
    }

    private void assertRunOnIoThread() {
        if (Looper.myLooper() != this.mIoHandler.getLooper()) {
            throw new IllegalStateException("Should run on io thread.");
        }
    }

    private void assertRunOnServiceThread() {
        if (Looper.myLooper() != this.mControlHandler.getLooper()) {
            throw new IllegalStateException("Should run on service thread.");
        }
    }

    private void runOnIoThread(Runnable runnable) {
        this.mIoHandler.post(runnable);
    }

    private void runOnServiceThread(Runnable runnable) {
        this.mControlHandler.post(runnable);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void flush(final Runnable runnable) {
        this.assertRunOnServiceThread();
        this.runOnIoThread(new Runnable(){

            @Override
            public void run() {
                HdmiCecController.this.runOnServiceThread(runnable);
            }
        });
    }

    private boolean isAcceptableAddress(int address) {
        if (address == 15) {
            return true;
        }
        return this.isAllocatedLocalDeviceAddress(address);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void onReceiveCommand(HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        if (this.isAcceptableAddress(message.getDestination()) && this.mService.handleCecCommand(message)) {
            return;
        }
        this.maySendFeatureAbortCommand(message, 0);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void maySendFeatureAbortCommand(HdmiCecMessage message, int reason) {
        this.assertRunOnServiceThread();
        int src = message.getDestination();
        int dest = message.getSource();
        if (src == 15 || dest == 15) {
            return;
        }
        int originalOpcode = message.getOpcode();
        if (originalOpcode == 0) {
            return;
        }
        this.sendCommand(HdmiCecMessageBuilder.buildFeatureAbortCommand(src, dest, originalOpcode, reason));
    }

    @HdmiAnnotations.ServiceThreadOnly
    void sendCommand(HdmiCecMessage cecMessage) {
        this.assertRunOnServiceThread();
        this.sendCommand(cecMessage, null);
    }

    @HdmiAnnotations.ServiceThreadOnly
    void sendCommand(final HdmiCecMessage cecMessage, final HdmiControlService.SendMessageCallback callback) {
        this.assertRunOnServiceThread();
        this.addMessageToHistory(false, cecMessage);
        this.runOnIoThread(new Runnable(){

            @Override
            public void run() {
                HdmiLogger.debug("[S]:" + cecMessage, new Object[0]);
                byte[] body = HdmiCecController.buildBody(cecMessage.getOpcode(), cecMessage.getParams());
                int i = 0;
                int errorCode = 0;
                while ((errorCode = HdmiCecController.nativeSendCecCommand(HdmiCecController.this.mNativePtr, cecMessage.getSource(), cecMessage.getDestination(), body)) != 0 && i++ < 1) {
                }
                final int finalError = errorCode;
                if (finalError != 0) {
                    Slog.w(HdmiCecController.TAG, "Failed to send " + cecMessage + " with errorCode=" + finalError);
                }
                if (callback != null) {
                    HdmiCecController.this.runOnServiceThread(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSendCompleted(finalError);
                        }
                    });
                }
            }
        });
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void handleIncomingCecCommand(int srcAddress, int dstAddress, byte[] body) {
        this.assertRunOnServiceThread();
        HdmiCecMessage command = HdmiCecMessageBuilder.of(srcAddress, dstAddress, body);
        HdmiLogger.debug("[R]:" + command, new Object[0]);
        this.addMessageToHistory(true, command);
        this.onReceiveCommand(command);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void handleHotplug(int port, boolean connected) {
        this.assertRunOnServiceThread();
        HdmiLogger.debug("Hotplug event:[port:%d, connected:%b]", port, connected);
        this.mService.onHotplug(port, connected);
    }

    @HdmiAnnotations.ServiceThreadOnly
    private void addMessageToHistory(boolean isReceived, HdmiCecMessage message) {
        this.assertRunOnServiceThread();
        MessageHistoryRecord record = new MessageHistoryRecord(isReceived, message);
        if (!this.mMessageHistory.offer(record)) {
            this.mMessageHistory.poll();
            this.mMessageHistory.offer(record);
        }
    }

    void dump(IndentingPrintWriter pw) {
        for (int i = 0; i < this.mLocalDevices.size(); ++i) {
            pw.println("HdmiCecLocalDevice #" + i + ":");
            pw.increaseIndent();
            this.mLocalDevices.valueAt(i).dump(pw);
            pw.decreaseIndent();
        }
        pw.println("CEC message history:");
        pw.increaseIndent();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (MessageHistoryRecord record : this.mMessageHistory) {
            record.dump(pw, sdf);
        }
        pw.decreaseIndent();
    }

    private static native long nativeInit(HdmiCecController var0, MessageQueue var1);

    private static native int nativeSendCecCommand(long var0, int var2, int var3, byte[] var4);

    private static native int nativeAddLogicalAddress(long var0, int var2);

    private static native void nativeClearLogicalAddress(long var0);

    private static native int nativeGetPhysicalAddress(long var0);

    private static native int nativeGetVersion(long var0);

    private static native int nativeGetVendorId(long var0);

    private static native HdmiPortInfo[] nativeGetPortInfos(long var0);

    private static native void nativeSetOption(long var0, int var2, boolean var3);

    private static native void nativeSetLanguage(long var0, String var2);

    private static native void nativeEnableAudioReturnChannel(long var0, int var2, boolean var3);

    private static native boolean nativeIsConnected(long var0, int var2);

    private final class MessageHistoryRecord {
        private final long mTime = System.currentTimeMillis();
        private final boolean mIsReceived;
        private final HdmiCecMessage mMessage;

        public MessageHistoryRecord(boolean isReceived, HdmiCecMessage message) {
            this.mIsReceived = isReceived;
            this.mMessage = message;
        }

        void dump(IndentingPrintWriter pw, SimpleDateFormat sdf) {
            pw.print(this.mIsReceived ? "[R]" : "[S]");
            pw.print(" time=");
            pw.print(sdf.format(new Date(this.mTime)));
            pw.print(" message=");
            pw.println(this.mMessage);
        }
    }

    static interface AllocateAddressCallback {
        public void onAllocated(int var1, int var2);
    }
}

