/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.hdmi;

import android.hardware.hdmi.IHdmiControlCallback;
import com.android.server.hdmi.HdmiCecLocalDevice;
import com.android.server.hdmi.HdmiCecMessageBuilder;
import com.android.server.hdmi.HdmiUtils;
import com.android.server.hdmi.SystemAudioAction;
import com.android.server.hdmi.SystemAudioAutoInitiationAction;

final class SystemAudioActionFromAvr
extends SystemAudioAction {
    SystemAudioActionFromAvr(HdmiCecLocalDevice source, int avrAddress, boolean targetStatus, IHdmiControlCallback callback) {
        super(source, avrAddress, targetStatus, callback);
        HdmiUtils.verifyAddressType(this.getSourceAddress(), 0);
    }

    @Override
    boolean start() {
        this.removeSystemAudioActionInProgress();
        this.handleSystemAudioActionFromAvr();
        return true;
    }

    private void handleSystemAudioActionFromAvr() {
        if (this.mTargetAudioStatus == this.tv().isSystemAudioActivated()) {
            this.finishWithCallback(0);
            return;
        }
        if (this.tv().isProhibitMode()) {
            this.sendCommand(HdmiCecMessageBuilder.buildFeatureAbortCommand(this.getSourceAddress(), this.mAvrLogicalAddress, 114, 4));
            this.mTargetAudioStatus = false;
            this.sendSystemAudioModeRequest();
            return;
        }
        this.removeAction(SystemAudioAutoInitiationAction.class);
        if (this.mTargetAudioStatus) {
            this.setSystemAudioMode(true);
            this.startAudioStatusAction();
        } else {
            this.setSystemAudioMode(false);
            this.finishWithCallback(0);
        }
    }
}

