/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media;

import android.content.Context;
import android.media.AudioPlaybackConfiguration;
import android.media.IAudioService;
import android.media.IPlaybackConfigDispatcher;
import android.os.Binder;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.IntArray;
import android.util.Log;
import com.android.server.media.MediaSessionService;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AudioPlaybackMonitor
extends IPlaybackConfigDispatcher.Stub {
    private static boolean DEBUG = MediaSessionService.DEBUG;
    private static String TAG = "AudioPlaybackMonitor";
    private static AudioPlaybackMonitor sInstance;
    private final Object mLock = new Object();
    private final Context mContext;
    private final List<OnAudioPlaybackStartedListener> mAudioPlaybackStartedListeners = new ArrayList<OnAudioPlaybackStartedListener>();
    private final List<OnAudioPlayerActiveStateChangedListener> mAudioPlayerActiveStateChangedListeners = new ArrayList<OnAudioPlayerActiveStateChangedListener>();
    private final Map<Integer, Integer> mAudioPlaybackStates = new HashMap<Integer, Integer>();
    private final Set<Integer> mActiveAudioPlaybackClientUids = new HashSet<Integer>();
    private final IntArray mSortedAudioPlaybackClientUids = new IntArray();

    static AudioPlaybackMonitor getInstance(Context context, IAudioService audioService) {
        if (sInstance == null) {
            sInstance = new AudioPlaybackMonitor(context, audioService);
        }
        return sInstance;
    }

    private AudioPlaybackMonitor(Context context, IAudioService audioService) {
        this.mContext = context;
        try {
            audioService.registerPlaybackCallback(this);
        }
        catch (RemoteException e) {
            Log.wtf(TAG, "Failed to register playback callback", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> configs, boolean flush) {
        if (flush) {
            Binder.flushPendingCommands();
        }
        long token = Binder.clearCallingIdentity();
        try {
            ArrayList<OnAudioPlaybackStartedListener> audioPlaybackStartedListeners;
            ArrayList<OnAudioPlayerActiveStateChangedListener> audioPlayerActiveStateChangedListeners;
            ArrayList<Integer> newActiveAudioPlaybackClientUids = new ArrayList<Integer>();
            Iterator<AudioPlaybackConfiguration> iterator = this.mLock;
            synchronized (iterator) {
                this.mActiveAudioPlaybackClientUids.clear();
                for (AudioPlaybackConfiguration config : configs) {
                    if (!config.isActive() || config.getPlayerType() == 3) continue;
                    this.mActiveAudioPlaybackClientUids.add(config.getClientUid());
                    Integer oldState = this.mAudioPlaybackStates.get(config.getPlayerInterfaceId());
                    if (this.isActiveState(oldState)) continue;
                    if (DEBUG) {
                        Log.d(TAG, "Found a new active media playback. " + AudioPlaybackConfiguration.toLogFriendlyString(config));
                    }
                    newActiveAudioPlaybackClientUids.add(config.getClientUid());
                    int index = this.mSortedAudioPlaybackClientUids.indexOf(config.getClientUid());
                    if (index == 0) continue;
                    if (index > 0) {
                        this.mSortedAudioPlaybackClientUids.remove(index);
                    }
                    this.mSortedAudioPlaybackClientUids.add(0, config.getClientUid());
                }
                audioPlayerActiveStateChangedListeners = new ArrayList<OnAudioPlayerActiveStateChangedListener>(this.mAudioPlayerActiveStateChangedListeners);
                audioPlaybackStartedListeners = new ArrayList<OnAudioPlaybackStartedListener>(this.mAudioPlaybackStartedListeners);
            }
            for (AudioPlaybackConfiguration config : configs) {
                boolean isActive;
                boolean wasActive = this.isActiveState(this.mAudioPlaybackStates.get(config.getPlayerInterfaceId()));
                if (wasActive == (isActive = config.isActive())) continue;
                for (OnAudioPlayerActiveStateChangedListener listener : audioPlayerActiveStateChangedListeners) {
                    listener.onAudioPlayerActiveStateChanged(config.getClientUid(), isActive);
                }
            }
            iterator = newActiveAudioPlaybackClientUids.iterator();
            while (iterator.hasNext()) {
                int uid = (Integer)((Object)iterator.next());
                for (OnAudioPlaybackStartedListener listener : audioPlaybackStartedListeners) {
                    listener.onAudioPlaybackStarted(uid);
                }
            }
            this.mAudioPlaybackStates.clear();
            for (AudioPlaybackConfiguration config : configs) {
                this.mAudioPlaybackStates.put(config.getPlayerInterfaceId(), config.getPlayerState());
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnAudioPlaybackStartedListener(OnAudioPlaybackStartedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAudioPlaybackStartedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnAudioPlaybackStartedListener(OnAudioPlaybackStartedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAudioPlaybackStartedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOnAudioPlayerActiveStateChangedListener(OnAudioPlayerActiveStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAudioPlayerActiveStateChangedListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterOnAudioPlayerActiveStateChangedListener(OnAudioPlayerActiveStateChangedListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mAudioPlayerActiveStateChangedListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntArray getSortedAudioPlaybackClientUids() {
        IntArray sortedAudioPlaybackClientUids = new IntArray();
        Object object = this.mLock;
        synchronized (object) {
            sortedAudioPlaybackClientUids.addAll(this.mSortedAudioPlaybackClientUids);
        }
        return sortedAudioPlaybackClientUids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPlaybackActive(int uid) {
        Object object = this.mLock;
        synchronized (object) {
            return this.mActiveAudioPlaybackClientUids.contains(uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpAudioPlaybackUids(int mediaButtonSessionUid) {
        Object object = this.mLock;
        synchronized (object) {
            int userId = UserHandle.getUserId(mediaButtonSessionUid);
            for (int i = this.mSortedAudioPlaybackClientUids.size() - 1; i >= 0 && this.mSortedAudioPlaybackClientUids.get(i) != mediaButtonSessionUid; --i) {
                int uid = this.mSortedAudioPlaybackClientUids.get(i);
                if (userId != UserHandle.getUserId(uid) || this.isPlaybackActive(uid)) continue;
                this.mSortedAudioPlaybackClientUids.remove(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw, String prefix) {
        Object object = this.mLock;
        synchronized (object) {
            pw.println(prefix + "Audio playback (lastly played comes first)");
            String indent = prefix + "  ";
            for (int i = 0; i < this.mSortedAudioPlaybackClientUids.size(); ++i) {
                int uid = this.mSortedAudioPlaybackClientUids.get(i);
                pw.print(indent + "uid=" + uid + " packages=");
                String[] packages = this.mContext.getPackageManager().getPackagesForUid(uid);
                if (packages != null && packages.length > 0) {
                    for (int j = 0; j < packages.length; ++j) {
                        pw.print(packages[j] + " ");
                    }
                }
                pw.println();
            }
        }
    }

    private boolean isActiveState(Integer state) {
        return state != null && state.equals(2);
    }

    static interface OnAudioPlayerActiveStateChangedListener {
        public void onAudioPlayerActiveStateChanged(int var1, boolean var2);
    }

    static interface OnAudioPlaybackStartedListener {
        public void onAudioPlaybackStarted(int var1);
    }
}

