/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.media.projection;

import android.app.AppOpsManager;
import android.content.Context;
import android.media.MediaRouter;
import android.media.projection.IMediaProjection;
import android.media.projection.IMediaProjectionCallback;
import android.media.projection.IMediaProjectionManager;
import android.media.projection.IMediaProjectionWatcherCallback;
import android.media.projection.MediaProjectionInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.util.DumpUtils;
import com.android.server.SystemService;
import com.android.server.Watchdog;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Map;

public final class MediaProjectionManagerService
extends SystemService
implements Watchdog.Monitor {
    private static final String TAG = "MediaProjectionManagerService";
    private final Object mLock = new Object();
    private final Map<IBinder, IBinder.DeathRecipient> mDeathEaters;
    private final CallbackDelegate mCallbackDelegate;
    private final Context mContext;
    private final AppOpsManager mAppOps;
    private final MediaRouter mMediaRouter;
    private final MediaRouterCallback mMediaRouterCallback;
    private MediaRouter.RouteInfo mMediaRouteInfo;
    private IBinder mProjectionToken;
    private MediaProjection mProjectionGrant;

    public MediaProjectionManagerService(Context context) {
        super(context);
        this.mContext = context;
        this.mDeathEaters = new ArrayMap<IBinder, IBinder.DeathRecipient>();
        this.mCallbackDelegate = new CallbackDelegate();
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        this.mMediaRouter = (MediaRouter)this.mContext.getSystemService("media_router");
        this.mMediaRouterCallback = new MediaRouterCallback();
        Watchdog.getInstance().addMonitor(this);
    }

    @Override
    public void onStart() {
        this.publishBinderService("media_projection", new BinderService(), false);
        this.mMediaRouter.addCallback(4, this.mMediaRouterCallback, 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSwitchUser(int userId) {
        this.mMediaRouter.rebindAsUser(userId);
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProjectionGrant != null) {
                this.mProjectionGrant.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void monitor() {
        Object object = this.mLock;
        synchronized (object) {
        }
    }

    private void startProjectionLocked(MediaProjection projection) {
        if (this.mProjectionGrant != null) {
            this.mProjectionGrant.stop();
        }
        if (this.mMediaRouteInfo != null) {
            this.mMediaRouter.getFallbackRoute().select();
        }
        this.mProjectionToken = projection.asBinder();
        this.mProjectionGrant = projection;
        this.dispatchStart(projection);
    }

    private void stopProjectionLocked(MediaProjection projection) {
        this.mProjectionToken = null;
        this.mProjectionGrant = null;
        this.dispatchStop(projection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCallback(final IMediaProjectionWatcherCallback callback) {
        IBinder.DeathRecipient deathRecipient = new IBinder.DeathRecipient(){

            @Override
            public void binderDied() {
                MediaProjectionManagerService.this.removeCallback(callback);
            }
        };
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbackDelegate.add(callback);
            this.linkDeathRecipientLocked(callback, deathRecipient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCallback(IMediaProjectionWatcherCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            this.unlinkDeathRecipientLocked(callback);
            this.mCallbackDelegate.remove(callback);
        }
    }

    private void linkDeathRecipientLocked(IMediaProjectionWatcherCallback callback, IBinder.DeathRecipient deathRecipient) {
        try {
            IBinder token = callback.asBinder();
            token.linkToDeath(deathRecipient, 0);
            this.mDeathEaters.put(token, deathRecipient);
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Unable to link to death for media projection monitoring callback", e);
        }
    }

    private void unlinkDeathRecipientLocked(IMediaProjectionWatcherCallback callback) {
        IBinder token = callback.asBinder();
        IBinder.DeathRecipient deathRecipient = this.mDeathEaters.remove(token);
        if (deathRecipient != null) {
            token.unlinkToDeath(deathRecipient, 0);
        }
    }

    private void dispatchStart(MediaProjection projection) {
        this.mCallbackDelegate.dispatchStart(projection);
    }

    private void dispatchStop(MediaProjection projection) {
        this.mCallbackDelegate.dispatchStop(projection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidMediaProjection(IBinder token) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProjectionToken != null) {
                return this.mProjectionToken.equals(token);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MediaProjectionInfo getActiveProjectionInfo() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mProjectionGrant == null) {
                return null;
            }
            return this.mProjectionGrant.getProjectionInfo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dump(PrintWriter pw) {
        pw.println("MEDIA PROJECTION MANAGER (dumpsys media_projection)");
        Object object = this.mLock;
        synchronized (object) {
            pw.println("Media Projection: ");
            if (this.mProjectionGrant != null) {
                this.mProjectionGrant.dump(pw);
            } else {
                pw.println("null");
            }
        }
    }

    private static String typeToString(int type) {
        switch (type) {
            case 0: {
                return "TYPE_SCREEN_CAPTURE";
            }
            case 1: {
                return "TYPE_MIRRORING";
            }
            case 2: {
                return "TYPE_PRESENTATION";
            }
        }
        return Integer.toString(type);
    }

    private static final class ClientStopCallback
    implements Runnable {
        private IMediaProjectionCallback mCallback;

        public ClientStopCallback(IMediaProjectionCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void run() {
            try {
                this.mCallback.onStop();
            }
            catch (RemoteException e) {
                Slog.w(MediaProjectionManagerService.TAG, "Failed to notify media projection has stopped", e);
            }
        }
    }

    private static final class WatcherStopCallback
    implements Runnable {
        private IMediaProjectionWatcherCallback mCallback;
        private MediaProjectionInfo mInfo;

        public WatcherStopCallback(MediaProjectionInfo info, IMediaProjectionWatcherCallback callback) {
            this.mInfo = info;
            this.mCallback = callback;
        }

        @Override
        public void run() {
            try {
                this.mCallback.onStop(this.mInfo);
            }
            catch (RemoteException e) {
                Slog.w(MediaProjectionManagerService.TAG, "Failed to notify media projection has stopped", e);
            }
        }
    }

    private static final class WatcherStartCallback
    implements Runnable {
        private IMediaProjectionWatcherCallback mCallback;
        private MediaProjectionInfo mInfo;

        public WatcherStartCallback(MediaProjectionInfo info, IMediaProjectionWatcherCallback callback) {
            this.mInfo = info;
            this.mCallback = callback;
        }

        @Override
        public void run() {
            try {
                this.mCallback.onStart(this.mInfo);
            }
            catch (RemoteException e) {
                Slog.w(MediaProjectionManagerService.TAG, "Failed to notify media projection has stopped", e);
            }
        }
    }

    private static class CallbackDelegate {
        private Map<IBinder, IMediaProjectionCallback> mClientCallbacks;
        private Map<IBinder, IMediaProjectionWatcherCallback> mWatcherCallbacks;
        private Handler mHandler;
        private Object mLock = new Object();

        public CallbackDelegate() {
            this.mHandler = new Handler(Looper.getMainLooper(), null, true);
            this.mClientCallbacks = new ArrayMap<IBinder, IMediaProjectionCallback>();
            this.mWatcherCallbacks = new ArrayMap<IBinder, IMediaProjectionWatcherCallback>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(IMediaProjectionCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mClientCallbacks.put(callback.asBinder(), callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(IMediaProjectionWatcherCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mWatcherCallbacks.put(callback.asBinder(), callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(IMediaProjectionCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mClientCallbacks.remove(callback.asBinder());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(IMediaProjectionWatcherCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mWatcherCallbacks.remove(callback.asBinder());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchStart(MediaProjection projection) {
            if (projection == null) {
                Slog.e(MediaProjectionManagerService.TAG, "Tried to dispatch start notification for a null media projection. Ignoring!");
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                for (IMediaProjectionWatcherCallback callback : this.mWatcherCallbacks.values()) {
                    MediaProjectionInfo info = projection.getProjectionInfo();
                    this.mHandler.post(new WatcherStartCallback(info, callback));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispatchStop(MediaProjection projection) {
            if (projection == null) {
                Slog.e(MediaProjectionManagerService.TAG, "Tried to dispatch stop notification for a null media projection. Ignoring!");
                return;
            }
            Object object = this.mLock;
            synchronized (object) {
                for (IMediaProjectionCallback iMediaProjectionCallback : this.mClientCallbacks.values()) {
                    this.mHandler.post(new ClientStopCallback(iMediaProjectionCallback));
                }
                for (IMediaProjectionWatcherCallback iMediaProjectionWatcherCallback : this.mWatcherCallbacks.values()) {
                    MediaProjectionInfo info = projection.getProjectionInfo();
                    this.mHandler.post(new WatcherStopCallback(info, iMediaProjectionWatcherCallback));
                }
            }
        }
    }

    private class MediaRouterCallback
    extends MediaRouter.SimpleCallback {
        private MediaRouterCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onRouteSelected(MediaRouter router, int type, MediaRouter.RouteInfo info) {
            Object object = MediaProjectionManagerService.this.mLock;
            synchronized (object) {
                if ((type & 4) != 0) {
                    MediaProjectionManagerService.this.mMediaRouteInfo = info;
                    if (MediaProjectionManagerService.this.mProjectionGrant != null) {
                        MediaProjectionManagerService.this.mProjectionGrant.stop();
                    }
                }
            }
        }

        @Override
        public void onRouteUnselected(MediaRouter route, int type, MediaRouter.RouteInfo info) {
            if (MediaProjectionManagerService.this.mMediaRouteInfo == info) {
                MediaProjectionManagerService.this.mMediaRouteInfo = null;
            }
        }
    }

    private final class MediaProjection
    extends IMediaProjection.Stub {
        public final int uid;
        public final String packageName;
        public final UserHandle userHandle;
        private IMediaProjectionCallback mCallback;
        private IBinder mToken;
        private IBinder.DeathRecipient mDeathEater;
        private int mType;

        public MediaProjection(int type, int uid, String packageName) {
            this.mType = type;
            this.uid = uid;
            this.packageName = packageName;
            this.userHandle = new UserHandle(UserHandle.getUserId(uid));
        }

        @Override
        public boolean canProjectVideo() {
            return this.mType == 1 || this.mType == 0;
        }

        @Override
        public boolean canProjectSecureVideo() {
            return false;
        }

        @Override
        public boolean canProjectAudio() {
            return this.mType == 1 || this.mType == 2;
        }

        @Override
        public int applyVirtualDisplayFlags(int flags) {
            if (this.mType == 0) {
                flags &= 0xFFFFFFF7;
                return flags |= 0x12;
            }
            if (this.mType == 1) {
                flags &= 0xFFFFFFEE;
                return flags |= 0xA;
            }
            if (this.mType == 2) {
                flags &= 0xFFFFFFF7;
                return flags |= 0x13;
            }
            throw new RuntimeException("Unknown MediaProjection type");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void start(final IMediaProjectionCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback must not be null");
            }
            Object object = MediaProjectionManagerService.this.mLock;
            synchronized (object) {
                if (MediaProjectionManagerService.this.isValidMediaProjection(this.asBinder())) {
                    throw new IllegalStateException("Cannot start already started MediaProjection");
                }
                this.mCallback = callback;
                this.registerCallback(this.mCallback);
                try {
                    this.mToken = callback.asBinder();
                    this.mDeathEater = new IBinder.DeathRecipient(){

                        @Override
                        public void binderDied() {
                            MediaProjectionManagerService.this.mCallbackDelegate.remove(callback);
                            MediaProjection.this.stop();
                        }
                    };
                    this.mToken.linkToDeath(this.mDeathEater, 0);
                }
                catch (RemoteException e) {
                    Slog.w(MediaProjectionManagerService.TAG, "MediaProjectionCallbacks must be valid, aborting MediaProjection", e);
                    return;
                }
                MediaProjectionManagerService.this.startProjectionLocked(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            Object object = MediaProjectionManagerService.this.mLock;
            synchronized (object) {
                if (!MediaProjectionManagerService.this.isValidMediaProjection(this.asBinder())) {
                    Slog.w(MediaProjectionManagerService.TAG, "Attempted to stop inactive MediaProjection (uid=" + Binder.getCallingUid() + ", " + "pid=" + Binder.getCallingPid() + ")");
                    return;
                }
                MediaProjectionManagerService.this.stopProjectionLocked(this);
                this.mToken.unlinkToDeath(this.mDeathEater, 0);
                this.mToken = null;
                this.unregisterCallback(this.mCallback);
                this.mCallback = null;
            }
        }

        @Override
        public void registerCallback(IMediaProjectionCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback must not be null");
            }
            MediaProjectionManagerService.this.mCallbackDelegate.add(callback);
        }

        @Override
        public void unregisterCallback(IMediaProjectionCallback callback) {
            if (callback == null) {
                throw new IllegalArgumentException("callback must not be null");
            }
            MediaProjectionManagerService.this.mCallbackDelegate.remove(callback);
        }

        public MediaProjectionInfo getProjectionInfo() {
            return new MediaProjectionInfo(this.packageName, this.userHandle);
        }

        public void dump(PrintWriter pw) {
            pw.println("(" + this.packageName + ", uid=" + this.uid + "): " + MediaProjectionManagerService.typeToString(this.mType));
        }
    }

    private final class BinderService
    extends IMediaProjectionManager.Stub {
        private BinderService() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasProjectionPermission(int uid, String packageName) {
            boolean bl;
            long token = Binder.clearCallingIdentity();
            boolean hasPermission = false;
            try {
                bl = this.checkPermission(packageName, "android.permission.CAPTURE_VIDEO_OUTPUT") || MediaProjectionManagerService.this.mAppOps.noteOpNoThrow(46, uid, packageName) == 0;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
            return hasPermission |= bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IMediaProjection createProjection(int uid, String packageName, int type, boolean isPermanentGrant) {
            MediaProjection projection;
            if (MediaProjectionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_MEDIA_PROJECTION") != 0) {
                throw new SecurityException("Requires MANAGE_MEDIA_PROJECTION in order to grant projection permission");
            }
            if (packageName == null || packageName.isEmpty()) {
                throw new IllegalArgumentException("package name must not be empty");
            }
            long callingToken = Binder.clearCallingIdentity();
            try {
                projection = new MediaProjection(type, uid, packageName);
                if (isPermanentGrant) {
                    MediaProjectionManagerService.this.mAppOps.setMode(46, projection.uid, projection.packageName, 0);
                }
            }
            finally {
                Binder.restoreCallingIdentity(callingToken);
            }
            return projection;
        }

        @Override
        public boolean isValidMediaProjection(IMediaProjection projection) {
            return MediaProjectionManagerService.this.isValidMediaProjection(projection.asBinder());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MediaProjectionInfo getActiveProjectionInfo() {
            if (MediaProjectionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_MEDIA_PROJECTION") != 0) {
                throw new SecurityException("Requires MANAGE_MEDIA_PROJECTION in order to add projection callbacks");
            }
            long token = Binder.clearCallingIdentity();
            try {
                MediaProjectionInfo mediaProjectionInfo = MediaProjectionManagerService.this.getActiveProjectionInfo();
                return mediaProjectionInfo;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        @Override
        public void stopActiveProjection() {
            if (MediaProjectionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_MEDIA_PROJECTION") != 0) {
                throw new SecurityException("Requires MANAGE_MEDIA_PROJECTION in order to add projection callbacks");
            }
            long token = Binder.clearCallingIdentity();
            try {
                if (MediaProjectionManagerService.this.mProjectionGrant != null) {
                    MediaProjectionManagerService.this.mProjectionGrant.stop();
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCallback(IMediaProjectionWatcherCallback callback) {
            if (MediaProjectionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_MEDIA_PROJECTION") != 0) {
                throw new SecurityException("Requires MANAGE_MEDIA_PROJECTION in order to add projection callbacks");
            }
            long token = Binder.clearCallingIdentity();
            try {
                MediaProjectionManagerService.this.addCallback(callback);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCallback(IMediaProjectionWatcherCallback callback) {
            if (MediaProjectionManagerService.this.mContext.checkCallingPermission("android.permission.MANAGE_MEDIA_PROJECTION") != 0) {
                throw new SecurityException("Requires MANAGE_MEDIA_PROJECTION in order to remove projection callbacks");
            }
            long token = Binder.clearCallingIdentity();
            try {
                MediaProjectionManagerService.this.removeCallback(callback);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(MediaProjectionManagerService.this.mContext, MediaProjectionManagerService.TAG, pw)) {
                return;
            }
            long token = Binder.clearCallingIdentity();
            try {
                MediaProjectionManagerService.this.dump(pw);
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        private boolean checkPermission(String packageName, String permission2) {
            return MediaProjectionManagerService.this.mContext.getPackageManager().checkPermission(permission2, packageName) == 0;
        }
    }
}

