/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.app.ActivityManager;
import android.app.PendingIntent;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.UserInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.util.XmlUtils;
import com.android.server.notification.NotificationManagerService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public abstract class ManagedServices {
    protected final String TAG = this.getClass().getSimpleName();
    protected final boolean DEBUG = Log.isLoggable(this.TAG, 3);
    private static final int ON_BINDING_DIED_REBIND_DELAY_MS = 10000;
    protected static final String ENABLED_SERVICES_SEPARATOR = ":";
    static final String TAG_MANAGED_SERVICES = "service_listing";
    static final String ATT_APPROVED_LIST = "approved";
    static final String ATT_USER_ID = "user";
    static final String ATT_IS_PRIMARY = "primary";
    static final int APPROVAL_BY_PACKAGE = 0;
    static final int APPROVAL_BY_COMPONENT = 1;
    protected final Context mContext;
    protected final Object mMutex;
    private final UserProfiles mUserProfiles;
    private final IPackageManager mPm;
    private final UserManager mUm;
    private final Config mConfig;
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final ArrayList<ManagedServiceInfo> mServices = new ArrayList();
    private final ArrayList<String> mServicesBinding = new ArrayList();
    private final ArraySet<String> mServicesRebinding = new ArraySet();
    private ArraySet<ComponentName> mEnabledServicesForCurrentProfiles = new ArraySet();
    private ArraySet<String> mEnabledServicesPackageNames = new ArraySet();
    private ArraySet<ComponentName> mSnoozingForCurrentProfiles = new ArraySet();
    private ArrayMap<Integer, ArrayMap<Boolean, ArraySet<String>>> mApproved = new ArrayMap();
    private int[] mLastSeenProfileIds;
    private boolean mUseXml;
    protected int mApprovalLevel;

    public ManagedServices(Context context, Object mutex, UserProfiles userProfiles, IPackageManager pm) {
        this.mContext = context;
        this.mMutex = mutex;
        this.mUserProfiles = userProfiles;
        this.mPm = pm;
        this.mConfig = this.getConfig();
        this.mApprovalLevel = 1;
        this.mUm = (UserManager)this.mContext.getSystemService(ATT_USER_ID);
    }

    protected abstract Config getConfig();

    private String getCaption() {
        return this.mConfig.caption;
    }

    protected abstract IInterface asInterface(IBinder var1);

    protected abstract boolean checkType(IInterface var1);

    protected abstract void onServiceAdded(ManagedServiceInfo var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ManagedServiceInfo> getServices() {
        Object object = this.mMutex;
        synchronized (object) {
            ArrayList<ManagedServiceInfo> services = new ArrayList<ManagedServiceInfo>(this.mServices);
            return services;
        }
    }

    protected void onServiceRemovedLocked(ManagedServiceInfo removed) {
    }

    private ManagedServiceInfo newServiceInfo(IInterface service, ComponentName component, int userId, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
        return new ManagedServiceInfo(service, component, userId, isSystem, connection, targetSdkVersion);
    }

    public void onBootPhaseAppsCanStart() {
    }

    public void dump(PrintWriter pw, NotificationManagerService.DumpFilter filter) {
        pw.println("    Allowed " + this.getCaption() + "s:");
        int N = this.mApproved.size();
        for (int i = 0; i < N; ++i) {
            int userId = this.mApproved.keyAt(i);
            ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.valueAt(i);
            if (approvedByType == null) continue;
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                boolean isPrimary = approvedByType.keyAt(j);
                ArraySet<String> approved = approvedByType.valueAt(j);
                if (approvedByType == null || approvedByType.size() <= 0) continue;
                pw.println("      " + String.join((CharSequence)ENABLED_SERVICES_SEPARATOR, approved) + " (user: " + userId + " isPrimary: " + isPrimary + ")");
            }
        }
        pw.println("    All " + this.getCaption() + "s (" + this.mEnabledServicesForCurrentProfiles.size() + ") enabled for current profiles:");
        for (ComponentName cmpt : this.mEnabledServicesForCurrentProfiles) {
            if (filter != null && !filter.matches(cmpt)) continue;
            pw.println("      " + cmpt);
        }
        pw.println("    Live " + this.getCaption() + "s (" + this.mServices.size() + "):");
        for (ManagedServiceInfo info : this.mServices) {
            if (filter != null && !filter.matches(info.component)) continue;
            pw.println("      " + info.component + " (user " + info.userid + "): " + info.service + (info.isSystem ? " SYSTEM" : "") + (info.isGuest(this) ? " GUEST" : ""));
        }
        pw.println("    Snoozed " + this.getCaption() + "s (" + this.mSnoozingForCurrentProfiles.size() + "):");
        for (ComponentName name : this.mSnoozingForCurrentProfiles) {
            pw.println("      " + name.flattenToShortString());
        }
    }

    protected void onSettingRestored(String element, String value, int backupSdkInt, int userId) {
        if (!this.mUseXml) {
            Slog.d(this.TAG, "Restored managed service setting: " + element);
            if (this.mConfig.secureSettingName.equals(element) || this.mConfig.secondarySettingName != null && this.mConfig.secondarySettingName.equals(element)) {
                String currentSetting;
                if (backupSdkInt < 26 && !TextUtils.isEmpty(currentSetting = this.getApproved(userId, this.mConfig.secureSettingName.equals(element)))) {
                    value = !TextUtils.isEmpty(value) ? value + ENABLED_SERVICES_SEPARATOR + currentSetting : currentSetting;
                }
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), element, value, userId);
                this.loadAllowedComponentsFromSettings();
                this.rebindServices(false);
            }
        }
    }

    public void writeXml(XmlSerializer out, boolean forBackup) throws IOException {
        out.startTag(null, this.getConfig().xmlTag);
        if (forBackup) {
            this.trimApprovedListsAccordingToInstalledServices();
        }
        int N = this.mApproved.size();
        for (int i = 0; i < N; ++i) {
            int userId = this.mApproved.keyAt(i);
            ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.valueAt(i);
            if (approvedByType == null) continue;
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                boolean isPrimary = approvedByType.keyAt(j);
                Set approved = approvedByType.valueAt(j);
                if (approved == null) continue;
                String allowedItems = String.join((CharSequence)ENABLED_SERVICES_SEPARATOR, approved);
                out.startTag(null, TAG_MANAGED_SERVICES);
                out.attribute(null, ATT_APPROVED_LIST, allowedItems);
                out.attribute(null, ATT_USER_ID, Integer.toString(userId));
                out.attribute(null, ATT_IS_PRIMARY, Boolean.toString(isPrimary));
                out.endTag(null, TAG_MANAGED_SERVICES);
                if (forBackup || !isPrimary) continue;
                Settings.Secure.putStringForUser(this.mContext.getContentResolver(), this.getConfig().secureSettingName, allowedItems, userId);
            }
        }
        out.endTag(null, this.getConfig().xmlTag);
    }

    protected void migrateToXml() {
        this.loadAllowedComponentsFromSettings();
    }

    public void readXml(XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 1) {
            String tag = parser.getName();
            if (type == 3 && this.getConfig().xmlTag.equals(tag)) break;
            if (type != 2 || !TAG_MANAGED_SERVICES.equals(tag)) continue;
            Slog.i(this.TAG, "Read " + this.mConfig.caption + " permissions from xml");
            String approved = XmlUtils.readStringAttribute(parser, ATT_APPROVED_LIST);
            int userId = XmlUtils.readIntAttribute(parser, ATT_USER_ID, 0);
            boolean isPrimary = XmlUtils.readBooleanAttribute(parser, ATT_IS_PRIMARY, true);
            if (this.mUm.getUserInfo(userId) != null) {
                this.addApprovedList(approved, userId, isPrimary);
            }
            this.mUseXml = true;
        }
        this.rebindServices(false);
    }

    private void loadAllowedComponentsFromSettings() {
        UserManager userManager = (UserManager)this.mContext.getSystemService(ATT_USER_ID);
        for (UserInfo user : userManager.getUsers()) {
            ContentResolver cr = this.mContext.getContentResolver();
            this.addApprovedList(Settings.Secure.getStringForUser(cr, this.getConfig().secureSettingName, user.id), user.id, true);
            if (TextUtils.isEmpty(this.getConfig().secondarySettingName)) continue;
            this.addApprovedList(Settings.Secure.getStringForUser(cr, this.getConfig().secondarySettingName, user.id), user.id, false);
        }
        Slog.d(this.TAG, "Done loading approved values from settings");
    }

    private void addApprovedList(String approved, int userId, boolean isPrimary) {
        ArrayMap<Boolean, ArraySet<String>> approvedByType;
        if (TextUtils.isEmpty(approved)) {
            approved = "";
        }
        if ((approvedByType = this.mApproved.get(userId)) == null) {
            approvedByType = new ArrayMap();
            this.mApproved.put(userId, approvedByType);
        }
        String[] approvedArray = approved.split(ENABLED_SERVICES_SEPARATOR);
        ArraySet<String> approvedList = new ArraySet<String>();
        for (String pkgOrComponent : approvedArray) {
            String approvedItem = this.getApprovedValue(pkgOrComponent);
            if (approvedItem == null) continue;
            approvedList.add(approvedItem);
        }
        approvedByType.put(isPrimary, approvedList);
    }

    protected boolean isComponentEnabledForPackage(String pkg) {
        return this.mEnabledServicesPackageNames.contains(pkg);
    }

    protected void setPackageOrComponentEnabled(String pkgOrComponent, int userId, boolean isPrimary, boolean enabled) {
        String approvedItem;
        ArraySet<String> approved;
        Slog.i(this.TAG, (enabled ? " Allowing " : "Disallowing ") + this.mConfig.caption + " " + pkgOrComponent);
        ArrayMap<Boolean, ArraySet<String>> allowedByType = this.mApproved.get(userId);
        if (allowedByType == null) {
            allowedByType = new ArrayMap();
            this.mApproved.put(userId, allowedByType);
        }
        if ((approved = allowedByType.get(isPrimary)) == null) {
            approved = new ArraySet();
            allowedByType.put(isPrimary, approved);
        }
        if ((approvedItem = this.getApprovedValue(pkgOrComponent)) != null) {
            if (enabled) {
                approved.add(approvedItem);
            } else {
                approved.remove(approvedItem);
            }
        }
        this.rebindServices(false);
    }

    private String getApprovedValue(String pkgOrComponent) {
        if (this.mApprovalLevel == 1) {
            if (ComponentName.unflattenFromString(pkgOrComponent) != null) {
                return pkgOrComponent;
            }
            return null;
        }
        return this.getPackageName(pkgOrComponent);
    }

    protected String getApproved(int userId, boolean primary) {
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        ArraySet approved = allowedByType.getOrDefault(primary, new ArraySet());
        return String.join((CharSequence)ENABLED_SERVICES_SEPARATOR, approved);
    }

    protected List<ComponentName> getAllowedComponents(int userId) {
        ArrayList<ComponentName> allowedComponents = new ArrayList<ComponentName>();
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        for (int i = 0; i < allowedByType.size(); ++i) {
            ArraySet allowed = (ArraySet)allowedByType.valueAt(i);
            allowedComponents.addAll(allowed.stream().map(ComponentName::unflattenFromString).filter(out -> out != null).collect(Collectors.toList()));
        }
        return allowedComponents;
    }

    protected List<String> getAllowedPackages(int userId) {
        ArrayList<String> allowedPackages = new ArrayList<String>();
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        for (int i = 0; i < allowedByType.size(); ++i) {
            ArraySet allowed = (ArraySet)allowedByType.valueAt(i);
            allowedPackages.addAll(allowed.stream().map(this::getPackageName).collect(Collectors.toList()));
        }
        return allowedPackages;
    }

    protected boolean isPackageOrComponentAllowed(String pkgOrComponent, int userId) {
        ArrayMap allowedByType = this.mApproved.getOrDefault(userId, new ArrayMap());
        for (int i = 0; i < allowedByType.size(); ++i) {
            ArraySet allowed = (ArraySet)allowedByType.valueAt(i);
            if (!allowed.contains(pkgOrComponent)) continue;
            return true;
        }
        return false;
    }

    public void onPackagesChanged(boolean removingPackage, String[] pkgList, int[] uidList) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onPackagesChanged removingPackage=" + removingPackage + " pkgList=" + (pkgList == null ? null : Arrays.asList(pkgList)) + " mEnabledServicesPackageNames=" + this.mEnabledServicesPackageNames);
        }
        if (pkgList != null && pkgList.length > 0) {
            boolean anyServicesInvolved = false;
            if (removingPackage) {
                int size = Math.min(pkgList.length, uidList.length);
                for (int i = 0; i < size; ++i) {
                    String pkg = pkgList[i];
                    int userId = UserHandle.getUserId(uidList[i]);
                    anyServicesInvolved = this.removeUninstalledItemsFromApprovedLists(userId, pkg);
                }
            }
            for (String pkgName : pkgList) {
                if (!this.mEnabledServicesPackageNames.contains(pkgName)) continue;
                anyServicesInvolved = true;
            }
            if (anyServicesInvolved) {
                this.rebindServices(false);
            }
        }
    }

    public void onUserRemoved(int user) {
        Slog.i(this.TAG, "Removing approved services for removed user " + user);
        this.mApproved.remove(user);
        this.rebindServices(true);
    }

    public void onUserSwitched(int user) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onUserSwitched u=" + user);
        }
        if (Arrays.equals(this.mLastSeenProfileIds, this.mUserProfiles.getCurrentProfileIds())) {
            if (this.DEBUG) {
                Slog.d(this.TAG, "Current profile IDs didn't change, skipping rebindServices().");
            }
            return;
        }
        this.rebindServices(true);
    }

    public void onUserUnlocked(int user) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "onUserUnlocked u=" + user);
        }
        this.rebindServices(false);
    }

    private ManagedServiceInfo getServiceFromTokenLocked(IInterface service) {
        if (service == null) {
            return null;
        }
        IBinder token = service.asBinder();
        int N = this.mServices.size();
        for (int i = 0; i < N; ++i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (info.service.asBinder() != token) continue;
            return info;
        }
        return null;
    }

    protected ManagedServiceInfo checkServiceTokenLocked(IInterface service) {
        this.checkNotNull(service);
        ManagedServiceInfo info = this.getServiceFromTokenLocked(service);
        if (info != null) {
            return info;
        }
        throw new SecurityException("Disallowed call from unknown " + this.getCaption() + ": " + service + " " + service.getClass());
    }

    public void unregisterService(IInterface service, int userid) {
        this.checkNotNull(service);
        this.unregisterServiceImpl(service, userid);
    }

    public void registerService(IInterface service, ComponentName component, int userid) {
        this.checkNotNull(service);
        ManagedServiceInfo info = this.registerServiceImpl(service, component, userid);
        if (info != null) {
            this.onServiceAdded(info);
        }
    }

    protected void registerGuestService(ManagedServiceInfo guest) {
        this.checkNotNull(guest.service);
        if (!this.checkType(guest.service)) {
            throw new IllegalArgumentException();
        }
        if (this.registerServiceImpl(guest) != null) {
            this.onServiceAdded(guest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setComponentState(ComponentName component, boolean enabled) {
        boolean previous;
        boolean bl = previous = !this.mSnoozingForCurrentProfiles.contains(component);
        if (previous == enabled) {
            return;
        }
        if (enabled) {
            this.mSnoozingForCurrentProfiles.remove(component);
        } else {
            this.mSnoozingForCurrentProfiles.add(component);
        }
        Slog.d(this.TAG, (enabled ? "Enabling " : "Disabling ") + "component " + component.flattenToShortString());
        Object object = this.mMutex;
        synchronized (object) {
            int[] userIds;
            for (int userId : userIds = this.mUserProfiles.getCurrentProfileIds()) {
                if (enabled) {
                    this.registerServiceLocked(component, userId);
                    continue;
                }
                this.unregisterServiceLocked(component, userId);
            }
        }
    }

    private ArraySet<ComponentName> loadComponentNamesFromValues(ArraySet<String> approved, int userId) {
        if (approved == null || approved.size() == 0) {
            return new ArraySet<ComponentName>();
        }
        ArraySet<ComponentName> result = new ArraySet<ComponentName>(approved.size());
        for (int i = 0; i < approved.size(); ++i) {
            String packageOrComponent = approved.valueAt(i);
            if (TextUtils.isEmpty(packageOrComponent)) continue;
            ComponentName component = ComponentName.unflattenFromString(packageOrComponent);
            if (component != null) {
                result.add(component);
                continue;
            }
            result.addAll(this.queryPackageForServices(packageOrComponent, userId));
        }
        return result;
    }

    protected Set<ComponentName> queryPackageForServices(String packageName, int userId) {
        return this.queryPackageForServices(packageName, 0, userId);
    }

    protected Set<ComponentName> queryPackageForServices(String packageName, int extraFlags, int userId) {
        ArraySet<ComponentName> installed = new ArraySet<ComponentName>();
        PackageManager pm = this.mContext.getPackageManager();
        Intent queryIntent = new Intent(this.mConfig.serviceInterface);
        if (!TextUtils.isEmpty(packageName)) {
            queryIntent.setPackage(packageName);
        }
        List<ResolveInfo> installedServices = pm.queryIntentServicesAsUser(queryIntent, 0x84 | extraFlags, userId);
        if (this.DEBUG) {
            Slog.v(this.TAG, this.mConfig.serviceInterface + " services: " + installedServices);
        }
        if (installedServices != null) {
            int count = installedServices.size();
            for (int i = 0; i < count; ++i) {
                ResolveInfo resolveInfo = installedServices.get(i);
                ServiceInfo info = resolveInfo.serviceInfo;
                ComponentName component = new ComponentName(info.packageName, info.name);
                if (!this.mConfig.bindPermission.equals(info.permission)) {
                    Slog.w(this.TAG, "Skipping " + this.getCaption() + " service " + info.packageName + "/" + info.name + ": it does not require the permission " + this.mConfig.bindPermission);
                    continue;
                }
                installed.add(component);
            }
        }
        return installed;
    }

    private void trimApprovedListsAccordingToInstalledServices() {
        int N = this.mApproved.size();
        for (int i = 0; i < N; ++i) {
            int userId = this.mApproved.keyAt(i);
            ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.valueAt(i);
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                ArraySet<String> approved = approvedByType.valueAt(j);
                int P = approved.size();
                for (int k = P - 1; k >= 0; --k) {
                    String approvedPackageOrComponent = approved.valueAt(k);
                    if (!this.isValidEntry(approvedPackageOrComponent, userId)) {
                        approved.removeAt(k);
                        Slog.v(this.TAG, "Removing " + approvedPackageOrComponent + " from approved list; no matching services found");
                        continue;
                    }
                    if (!this.DEBUG) continue;
                    Slog.v(this.TAG, "Keeping " + approvedPackageOrComponent + " on approved list; matching services found");
                }
            }
        }
    }

    private boolean removeUninstalledItemsFromApprovedLists(int uninstalledUserId, String pkg) {
        boolean removed = false;
        ArrayMap<Boolean, ArraySet<String>> approvedByType = this.mApproved.get(uninstalledUserId);
        if (approvedByType != null) {
            int M = approvedByType.size();
            for (int j = 0; j < M; ++j) {
                ArraySet<String> approved = approvedByType.valueAt(j);
                int O = approved.size();
                for (int k = O - 1; k >= 0; --k) {
                    String packageOrComponent = approved.valueAt(k);
                    String packageName = this.getPackageName(packageOrComponent);
                    if (!TextUtils.equals(pkg, packageName)) continue;
                    approved.removeAt(k);
                    if (!this.DEBUG) continue;
                    Slog.v(this.TAG, "Removing " + packageOrComponent + " from approved list; uninstalled");
                }
            }
        }
        return removed;
    }

    protected String getPackageName(String packageOrComponent) {
        ComponentName component = ComponentName.unflattenFromString(packageOrComponent);
        if (component != null) {
            return component.getPackageName();
        }
        return packageOrComponent;
    }

    protected boolean isValidEntry(String packageOrComponent, int userId) {
        return this.hasMatchingServices(packageOrComponent, userId);
    }

    private boolean hasMatchingServices(String packageOrComponent, int userId) {
        if (!TextUtils.isEmpty(packageOrComponent)) {
            String packageName = this.getPackageName(packageOrComponent);
            return this.queryPackageForServices(packageName, userId).size() > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebindServices(boolean forceRebind) {
        ArrayMap<Boolean, ArraySet<String>> approvedLists;
        if (this.DEBUG) {
            Slog.d(this.TAG, "rebindServices");
        }
        int[] userIds = this.mUserProfiles.getCurrentProfileIds();
        int nUserIds = userIds.length;
        SparseArray<ArraySet<ComponentName>> componentsByUser = new SparseArray<ArraySet<ComponentName>>();
        for (int i = 0; i < nUserIds; ++i) {
            int userId = userIds[i];
            approvedLists = this.mApproved.get(userIds[i]);
            if (approvedLists == null) continue;
            int N = approvedLists.size();
            for (int j = 0; j < N; ++j) {
                ArraySet<ComponentName> approvedByUser = (ArraySet<ComponentName>)componentsByUser.get(userId);
                if (approvedByUser == null) {
                    approvedByUser = new ArraySet<ComponentName>();
                    componentsByUser.put(userId, approvedByUser);
                }
                approvedByUser.addAll(this.loadComponentNamesFromValues(approvedLists.valueAt(j), userId));
            }
        }
        ArrayList<ManagedServiceInfo> removableBoundServices = new ArrayList<ManagedServiceInfo>();
        SparseArray toAdd = new SparseArray();
        approvedLists = this.mMutex;
        synchronized (approvedLists) {
            for (ManagedServiceInfo service : this.mServices) {
                if (service.isSystem || service.isGuest(this)) continue;
                removableBoundServices.add(service);
            }
            this.mEnabledServicesForCurrentProfiles.clear();
            this.mEnabledServicesPackageNames.clear();
            for (int i = 0; i < nUserIds; ++i) {
                ArraySet userComponents = (ArraySet)componentsByUser.get(userIds[i]);
                if (null == userComponents) {
                    toAdd.put(userIds[i], new ArraySet());
                    continue;
                }
                HashSet add = new HashSet(userComponents);
                add.removeAll(this.mSnoozingForCurrentProfiles);
                toAdd.put(userIds[i], add);
                this.mEnabledServicesForCurrentProfiles.addAll(userComponents);
                for (int j = 0; j < userComponents.size(); ++j) {
                    ComponentName component = (ComponentName)userComponents.valueAt(j);
                    this.mEnabledServicesPackageNames.add(component.getPackageName());
                }
            }
        }
        for (ManagedServiceInfo info : removableBoundServices) {
            ComponentName component = info.component;
            int oldUser = info.userid;
            Set allowedComponents = (Set)toAdd.get(info.userid);
            if (allowedComponents == null) continue;
            if (allowedComponents.contains(component) && !forceRebind) {
                allowedComponents.remove(component);
                continue;
            }
            Slog.v(this.TAG, "disabling " + this.getCaption() + " for user " + oldUser + ": " + component);
            this.unregisterService(component, oldUser);
        }
        for (int i = 0; i < nUserIds; ++i) {
            Set add = (Set)toAdd.get(userIds[i]);
            for (ComponentName component : add) {
                try {
                    ServiceInfo info = this.mPm.getServiceInfo(component, 786432, userIds[i]);
                    if (info == null || !this.mConfig.bindPermission.equals(info.permission)) {
                        Slog.w(this.TAG, "Not binding " + this.getCaption() + " service " + component + ": it does not require the permission " + this.mConfig.bindPermission);
                        continue;
                    }
                    Slog.v(this.TAG, "enabling " + this.getCaption() + " for " + userIds[i] + ": " + component);
                    this.registerService(component, userIds[i]);
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
        }
        this.mLastSeenProfileIds = userIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.registerServiceLocked(name, userid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSystemService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.registerServiceLocked(name, userid, true);
        }
    }

    private void registerServiceLocked(ComponentName name, int userid) {
        this.registerServiceLocked(name, userid, false);
    }

    private void registerServiceLocked(ComponentName name, final int userid, final boolean isSystem) {
        String servicesBindingTag;
        if (this.DEBUG) {
            Slog.v(this.TAG, "registerService: " + name + " u=" + userid);
        }
        if (this.mServicesBinding.contains(servicesBindingTag = name.toString() + "/" + userid)) {
            Slog.v(this.TAG, "Not registering " + name + " as bind is already in progress");
            return;
        }
        this.mServicesBinding.add(servicesBindingTag);
        int N = this.mServices.size();
        for (int i = N - 1; i >= 0; --i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (!name.equals(info.component) || info.userid != userid) continue;
            Slog.v(this.TAG, "    disconnecting old " + this.getCaption() + ": " + info.service);
            this.removeServiceLocked(i);
            if (info.connection == null) continue;
            this.mContext.unbindService(info.connection);
        }
        Intent intent = new Intent(this.mConfig.serviceInterface);
        intent.setComponent(name);
        intent.putExtra("android.intent.extra.client_label", this.mConfig.clientLabel);
        PendingIntent pendingIntent = PendingIntent.getActivity(this.mContext, 0, new Intent(this.mConfig.settingsAction), 0);
        intent.putExtra("android.intent.extra.client_intent", pendingIntent);
        ApplicationInfo appInfo = null;
        try {
            appInfo = this.mContext.getPackageManager().getApplicationInfo(name.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        final int targetSdkVersion = appInfo != null ? appInfo.targetSdkVersion : 1;
        try {
            Slog.v(this.TAG, "binding: " + intent);
            ServiceConnection serviceConnection = new ServiceConnection(){
                IInterface mService;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onServiceConnected(ComponentName name, IBinder binder) {
                    boolean added = false;
                    ManagedServiceInfo info = null;
                    Object object = ManagedServices.this.mMutex;
                    synchronized (object) {
                        ManagedServices.this.mServicesRebinding.remove(servicesBindingTag);
                        ManagedServices.this.mServicesBinding.remove(servicesBindingTag);
                        try {
                            this.mService = ManagedServices.this.asInterface(binder);
                            info = ManagedServices.this.newServiceInfo(this.mService, name, userid, isSystem, this, targetSdkVersion);
                            binder.linkToDeath(info, 0);
                            added = ManagedServices.this.mServices.add(info);
                        }
                        catch (RemoteException remoteException) {
                            // empty catch block
                        }
                    }
                    if (added) {
                        ManagedServices.this.onServiceAdded(info);
                    }
                }

                @Override
                public void onServiceDisconnected(ComponentName name) {
                    ManagedServices.this.mServicesBinding.remove(servicesBindingTag);
                    Slog.v(ManagedServices.this.TAG, ManagedServices.this.getCaption() + " connection lost: " + name);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBindingDied(final ComponentName name) {
                    Slog.w(ManagedServices.this.TAG, ManagedServices.this.getCaption() + " binding died: " + name);
                    Object object = ManagedServices.this.mMutex;
                    synchronized (object) {
                        ManagedServices.this.mServicesBinding.remove(servicesBindingTag);
                        ManagedServices.this.mContext.unbindService(this);
                        if (!ManagedServices.this.mServicesRebinding.contains(servicesBindingTag)) {
                            ManagedServices.this.mServicesRebinding.add(servicesBindingTag);
                            ManagedServices.this.mHandler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    ManagedServices.this.registerService(name, userid);
                                }
                            }, 10000L);
                        } else {
                            Slog.v(ManagedServices.this.TAG, ManagedServices.this.getCaption() + " not rebinding as " + "a previous rebind attempt was made: " + name);
                        }
                    }
                }
            };
            if (!this.mContext.bindServiceAsUser(intent, serviceConnection, 0x5000001, new UserHandle(userid))) {
                this.mServicesBinding.remove(servicesBindingTag);
                Slog.w(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent);
                return;
            }
        }
        catch (SecurityException ex) {
            this.mServicesBinding.remove(servicesBindingTag);
            Slog.e(this.TAG, "Unable to bind " + this.getCaption() + " service: " + intent, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterService(ComponentName name, int userid) {
        Object object = this.mMutex;
        synchronized (object) {
            this.unregisterServiceLocked(name, userid);
        }
    }

    private void unregisterServiceLocked(ComponentName name, int userid) {
        int N = this.mServices.size();
        for (int i = N - 1; i >= 0; --i) {
            ManagedServiceInfo info = this.mServices.get(i);
            if (!name.equals(info.component) || info.userid != userid) continue;
            this.removeServiceLocked(i);
            if (info.connection == null) continue;
            try {
                this.mContext.unbindService(info.connection);
                continue;
            }
            catch (IllegalArgumentException ex) {
                Slog.e(this.TAG, this.getCaption() + " " + name + " could not be unbound: " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo removeServiceImpl(IInterface service, int userid) {
        if (this.DEBUG) {
            Slog.d(this.TAG, "removeServiceImpl service=" + service + " u=" + userid);
        }
        ManagedServiceInfo serviceInfo = null;
        Object object = this.mMutex;
        synchronized (object) {
            int N = this.mServices.size();
            for (int i = N - 1; i >= 0; --i) {
                ManagedServiceInfo info = this.mServices.get(i);
                if (info.service.asBinder() != service.asBinder() || info.userid != userid) continue;
                Slog.d(this.TAG, "Removing active service " + info.component);
                serviceInfo = this.removeServiceLocked(i);
            }
        }
        return serviceInfo;
    }

    private ManagedServiceInfo removeServiceLocked(int i) {
        ManagedServiceInfo info = this.mServices.remove(i);
        this.onServiceRemovedLocked(info);
        return info;
    }

    private void checkNotNull(IInterface service) {
        if (service == null) {
            throw new IllegalArgumentException(this.getCaption() + " must not be null");
        }
    }

    private ManagedServiceInfo registerServiceImpl(IInterface service, ComponentName component, int userid) {
        ManagedServiceInfo info = this.newServiceInfo(service, component, userid, true, null, 21);
        return this.registerServiceImpl(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ManagedServiceInfo registerServiceImpl(ManagedServiceInfo info) {
        Object object = this.mMutex;
        synchronized (object) {
            try {
                info.service.asBinder().linkToDeath(info, 0);
                this.mServices.add(info);
                return info;
            }
            catch (RemoteException remoteException) {
            }
        }
        return null;
    }

    private void unregisterServiceImpl(IInterface service, int userid) {
        ManagedServiceInfo info = this.removeServiceImpl(service, userid);
        if (info != null && info.connection != null && !info.isGuest(this)) {
            this.mContext.unbindService(info.connection);
        }
    }

    public boolean isComponentEnabledForCurrentProfiles(ComponentName component) {
        return this.mEnabledServicesForCurrentProfiles.contains(component);
    }

    public static class Config {
        public String caption;
        public String serviceInterface;
        public String secureSettingName;
        public String secondarySettingName;
        public String xmlTag;
        public String bindPermission;
        public String settingsAction;
        public int clientLabel;
    }

    public static class UserProfiles {
        private final SparseArray<UserInfo> mCurrentProfiles = new SparseArray();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateCache(Context context) {
            UserManager userManager = (UserManager)context.getSystemService(ManagedServices.ATT_USER_ID);
            if (userManager != null) {
                int currentUserId = ActivityManager.getCurrentUser();
                List<UserInfo> profiles = userManager.getProfiles(currentUserId);
                SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
                synchronized (sparseArray) {
                    this.mCurrentProfiles.clear();
                    for (UserInfo user : profiles) {
                        this.mCurrentProfiles.put(user.id, user);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int[] getCurrentProfileIds() {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                int[] users = new int[this.mCurrentProfiles.size()];
                int N = this.mCurrentProfiles.size();
                for (int i = 0; i < N; ++i) {
                    users[i] = this.mCurrentProfiles.keyAt(i);
                }
                return users;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isCurrentProfile(int userId) {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                return this.mCurrentProfiles.get(userId) != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isManagedProfile(int userId) {
            SparseArray<UserInfo> sparseArray = this.mCurrentProfiles;
            synchronized (sparseArray) {
                UserInfo user = this.mCurrentProfiles.get(userId);
                return user != null && user.isManagedProfile();
            }
        }
    }

    public class ManagedServiceInfo
    implements IBinder.DeathRecipient {
        public IInterface service;
        public ComponentName component;
        public int userid;
        public boolean isSystem;
        public ServiceConnection connection;
        public int targetSdkVersion;

        public ManagedServiceInfo(IInterface service, ComponentName component, int userid, boolean isSystem, ServiceConnection connection, int targetSdkVersion) {
            this.service = service;
            this.component = component;
            this.userid = userid;
            this.isSystem = isSystem;
            this.connection = connection;
            this.targetSdkVersion = targetSdkVersion;
        }

        public boolean isGuest(ManagedServices host) {
            return ManagedServices.this != host;
        }

        public ManagedServices getOwner() {
            return ManagedServices.this;
        }

        public String toString() {
            return "ManagedServiceInfo[" + "component=" + this.component + ",userid=" + this.userid + ",isSystem=" + this.isSystem + ",targetSdkVersion=" + this.targetSdkVersion + ",connection=" + (this.connection == null ? null : "<connection>") + ",service=" + this.service + ']';
        }

        public boolean enabledAndUserMatches(int nid) {
            if (!this.isEnabledForCurrentProfiles()) {
                return false;
            }
            if (this.userid == -1) {
                return true;
            }
            if (this.isSystem) {
                return true;
            }
            if (nid == -1 || nid == this.userid) {
                return true;
            }
            return this.supportsProfiles() && ManagedServices.this.mUserProfiles.isCurrentProfile(nid) && this.isPermittedForProfile(nid);
        }

        public boolean supportsProfiles() {
            return this.targetSdkVersion >= 21;
        }

        @Override
        public void binderDied() {
            if (ManagedServices.this.DEBUG) {
                Slog.d(ManagedServices.this.TAG, "binderDied");
            }
            ManagedServices.this.removeServiceImpl(this.service, this.userid);
        }

        public boolean isEnabledForCurrentProfiles() {
            if (this.isSystem) {
                return true;
            }
            if (this.connection == null) {
                return false;
            }
            return ManagedServices.this.mEnabledServicesForCurrentProfiles.contains(this.component);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPermittedForProfile(int userId) {
            if (!ManagedServices.this.mUserProfiles.isManagedProfile(userId)) {
                return true;
            }
            DevicePolicyManager dpm = (DevicePolicyManager)ManagedServices.this.mContext.getSystemService("device_policy");
            long identity = Binder.clearCallingIdentity();
            try {
                boolean bl = dpm.isNotificationListenerServicePermitted(this.component.getPackageName(), userId);
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
    }
}

