/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.notification;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telecom.TelecomManager;
import com.android.internal.util.NotificationMessagingUtil;
import com.android.server.notification.NotificationRecord;
import java.util.Comparator;
import java.util.Objects;

public class NotificationComparator
implements Comparator<NotificationRecord> {
    private final Context mContext;
    private final NotificationMessagingUtil mMessagingUtil;
    private String mDefaultPhoneApp;
    private final BroadcastReceiver mPhoneAppBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            NotificationComparator.this.mDefaultPhoneApp = intent.getStringExtra("android.telecom.extra.CHANGE_DEFAULT_DIALER_PACKAGE_NAME");
        }
    };

    public NotificationComparator(Context context) {
        this.mContext = context;
        this.mContext.registerReceiver(this.mPhoneAppBroadcastReceiver, new IntentFilter("android.telecom.action.DEFAULT_DIALER_CHANGED"));
        this.mMessagingUtil = new NotificationMessagingUtil(this.mContext);
    }

    @Override
    public int compare(NotificationRecord left, NotificationRecord right) {
        int rightPackagePriority;
        int rightImportance;
        int leftImportance;
        boolean rightMessaging;
        boolean rightImportantOngoing;
        boolean rightImportantColorized;
        boolean leftImportantColorized = this.isImportantColorized(left);
        if (leftImportantColorized != (rightImportantColorized = this.isImportantColorized(right))) {
            return -1 * Boolean.compare(leftImportantColorized, rightImportantColorized);
        }
        boolean leftImportantOngoing = this.isImportantOngoing(left);
        if (leftImportantOngoing != (rightImportantOngoing = this.isImportantOngoing(right))) {
            return -1 * Boolean.compare(leftImportantOngoing, rightImportantOngoing);
        }
        boolean leftMessaging = this.isImportantMessaging(left);
        if (leftMessaging != (rightMessaging = this.isImportantMessaging(right))) {
            return -1 * Boolean.compare(leftMessaging, rightMessaging);
        }
        boolean leftPeople = this.isImportantPeople(left);
        boolean rightPeople = this.isImportantPeople(right);
        int contactAffinityComparison = Float.compare(left.getContactAffinity(), right.getContactAffinity());
        if (leftPeople && rightPeople) {
            if (contactAffinityComparison != 0) {
                return -1 * contactAffinityComparison;
            }
        } else if (leftPeople != rightPeople) {
            return -1 * Boolean.compare(leftPeople, rightPeople);
        }
        if ((leftImportance = left.getImportance()) != (rightImportance = right.getImportance())) {
            return -1 * Integer.compare(leftImportance, rightImportance);
        }
        if (contactAffinityComparison != 0) {
            return -1 * contactAffinityComparison;
        }
        int leftPackagePriority = left.getPackagePriority();
        if (leftPackagePriority != (rightPackagePriority = right.getPackagePriority())) {
            return -1 * Integer.compare(leftPackagePriority, rightPackagePriority);
        }
        int leftPriority = left.sbn.getNotification().priority;
        int rightPriority = right.sbn.getNotification().priority;
        if (leftPriority != rightPriority) {
            return -1 * Integer.compare(leftPriority, rightPriority);
        }
        return -1 * Long.compare(left.getRankingTimeMs(), right.getRankingTimeMs());
    }

    private boolean isImportantColorized(NotificationRecord record) {
        if (record.getImportance() < 2) {
            return false;
        }
        return record.getNotification().isColorized();
    }

    private boolean isImportantOngoing(NotificationRecord record) {
        if (!this.isOngoing(record)) {
            return false;
        }
        if (record.getImportance() < 2) {
            return false;
        }
        return this.isCall(record) || this.isMediaNotification(record);
    }

    protected boolean isImportantPeople(NotificationRecord record) {
        if (record.getImportance() < 2) {
            return false;
        }
        return record.getContactAffinity() > 0.0f;
    }

    protected boolean isImportantMessaging(NotificationRecord record) {
        return this.mMessagingUtil.isImportantMessaging(record.sbn, record.getImportance());
    }

    private boolean isOngoing(NotificationRecord record) {
        int ongoingFlags = 64;
        return (record.getNotification().flags & 0x40) != 0;
    }

    private boolean isMediaNotification(NotificationRecord record) {
        return record.getNotification().hasMediaSession();
    }

    private boolean isCall(NotificationRecord record) {
        return record.getNotification().category == "call" && this.isDefaultPhoneApp(record.sbn.getPackageName());
    }

    private boolean isDefaultPhoneApp(String pkg) {
        if (this.mDefaultPhoneApp == null) {
            TelecomManager telecomm = (TelecomManager)this.mContext.getSystemService("telecom");
            this.mDefaultPhoneApp = telecomm != null ? telecomm.getDefaultDialerPackage() : null;
        }
        return Objects.equals(pkg, this.mDefaultPhoneApp);
    }
}

