/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.oemlock;

import android.content.Context;
import android.hardware.oemlock.V1_0.IOemLock;
import android.os.RemoteException;
import android.util.Slog;
import com.android.server.oemlock.OemLock;
import java.util.ArrayList;
import java.util.NoSuchElementException;

class VendorLock
extends OemLock {
    private static final String TAG = "OemLock";
    private Context mContext;
    private IOemLock mOemLock;

    static IOemLock getOemLockHalService() {
        try {
            return IOemLock.getService();
        }
        catch (NoSuchElementException e) {
            Slog.i(TAG, "OemLock HAL not present on device");
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    VendorLock(Context context, IOemLock oemLock) {
        this.mContext = context;
        this.mOemLock = oemLock;
    }

    @Override
    void setOemUnlockAllowedByCarrier(boolean allowed, byte[] signature) {
        try {
            switch (this.mOemLock.setOemUnlockAllowedByCarrier(allowed, this.toByteArrayList(signature))) {
                case 0: {
                    Slog.i(TAG, "Updated carrier allows OEM lock state to: " + allowed);
                    return;
                }
                case 2: {
                    throw new SecurityException("Invalid signature used in attempt to carrier unlock");
                }
                default: {
                    Slog.e(TAG, "Unknown return value indicates code is out of sync with HAL");
                }
                case 1: 
            }
            throw new RuntimeException("Failed to set carrier OEM unlock state");
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to set carrier state with HAL", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    boolean isOemUnlockAllowedByCarrier() {
        Integer[] requestStatus = new Integer[1];
        Boolean[] allowedByCarrier = new Boolean[1];
        try {
            this.mOemLock.isOemUnlockAllowedByCarrier((status, allowed) -> {
                integerArray[0] = status;
                booleanArray[0] = allowed;
            });
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to get carrier state from HAL");
            throw e.rethrowFromSystemServer();
        }
        switch (requestStatus[0]) {
            case 0: {
                return allowedByCarrier[0];
            }
            default: {
                Slog.e(TAG, "Unknown return value indicates code is out of sync with HAL");
            }
            case 1: 
        }
        throw new RuntimeException("Failed to get carrier OEM unlock state");
    }

    @Override
    void setOemUnlockAllowedByDevice(boolean allowedByDevice) {
        try {
            switch (this.mOemLock.setOemUnlockAllowedByDevice(allowedByDevice)) {
                case 0: {
                    Slog.i(TAG, "Updated device allows OEM lock state to: " + allowedByDevice);
                    return;
                }
                default: {
                    Slog.e(TAG, "Unknown return value indicates code is out of sync with HAL");
                }
                case 1: 
            }
            throw new RuntimeException("Failed to set device OEM unlock state");
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to set device state with HAL", e);
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    boolean isOemUnlockAllowedByDevice() {
        Integer[] requestStatus = new Integer[1];
        Boolean[] allowedByDevice = new Boolean[1];
        try {
            this.mOemLock.isOemUnlockAllowedByDevice((status, allowed) -> {
                integerArray[0] = status;
                booleanArray[0] = allowed;
            });
        }
        catch (RemoteException e) {
            Slog.e(TAG, "Failed to get devie state from HAL");
            throw e.rethrowFromSystemServer();
        }
        switch (requestStatus[0]) {
            case 0: {
                return allowedByDevice[0];
            }
            default: {
                Slog.e(TAG, "Unknown return value indicates code is out of sync with HAL");
            }
            case 1: 
        }
        throw new RuntimeException("Failed to get device OEM unlock state");
    }

    private ArrayList toByteArrayList(byte[] data) {
        if (data == null) {
            return null;
        }
        ArrayList<Byte> result = new ArrayList<Byte>(data.length);
        for (byte b : data) {
            result.add(b);
        }
        return result;
    }
}

