/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.storage.StorageManager;
import android.util.ArraySet;
import android.util.Log;
import com.android.server.LocalServices;
import com.android.server.PinnerService;
import com.android.server.pm.PackageManagerService;
import com.android.server.pm.dex.DexManager;
import com.android.server.pm.dex.DexoptOptions;
import java.io.File;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundDexOptService
extends JobService {
    private static final String TAG = "BackgroundDexOptService";
    private static final boolean DEBUG = false;
    private static final int JOB_IDLE_OPTIMIZE = 800;
    private static final int JOB_POST_BOOT_UPDATE = 801;
    private static final long IDLE_OPTIMIZATION_PERIOD = TimeUnit.DAYS.toMillis(1L);
    private static ComponentName sDexoptServiceName = new ComponentName("android", BackgroundDexOptService.class.getName());
    private static final int OPTIMIZE_PROCESSED = 0;
    private static final int OPTIMIZE_CONTINUE = 1;
    private static final int OPTIMIZE_ABORT_BY_JOB_SCHEDULER = 2;
    private static final int OPTIMIZE_ABORT_NO_SPACE_LEFT = 3;
    private static final int LOW_THRESHOLD_MULTIPLIER_FOR_DOWNGRADE = 2;
    static final ArraySet<String> sFailedPackageNamesPrimary = new ArraySet();
    static final ArraySet<String> sFailedPackageNamesSecondary = new ArraySet();
    private final AtomicBoolean mAbortPostBootUpdate = new AtomicBoolean(false);
    private final AtomicBoolean mAbortIdleOptimization = new AtomicBoolean(false);
    private final AtomicBoolean mExitPostBootUpdate = new AtomicBoolean(false);
    private final File mDataDir = Environment.getDataDirectory();
    private static final long mDowngradeUnusedAppsThresholdInMillis = BackgroundDexOptService.getDowngradeUnusedAppsThresholdInMillis();

    public static void schedule(Context context) {
        if (BackgroundDexOptService.isBackgroundDexoptDisabled()) {
            return;
        }
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        js.schedule(new JobInfo.Builder(801, sDexoptServiceName).setMinimumLatency(TimeUnit.MINUTES.toMillis(1L)).setOverrideDeadline(TimeUnit.MINUTES.toMillis(1L)).build());
        js.schedule(new JobInfo.Builder(800, sDexoptServiceName).setRequiresDeviceIdle(true).setRequiresCharging(true).setPeriodic(IDLE_OPTIMIZATION_PERIOD).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPackageChanged(String packageName) {
        ArraySet<String> arraySet = sFailedPackageNamesPrimary;
        synchronized (arraySet) {
            sFailedPackageNamesPrimary.remove(packageName);
        }
        arraySet = sFailedPackageNamesSecondary;
        synchronized (arraySet) {
            sFailedPackageNamesSecondary.remove(packageName);
        }
    }

    private int getBatteryLevel() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.registerReceiver(null, filter);
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", -1);
        if (level < 0 || scale <= 0) {
            return 0;
        }
        return 100 * level / scale;
    }

    private long getLowStorageThreshold(Context context) {
        long lowThreshold = StorageManager.from(context).getStorageLowBytes(this.mDataDir);
        if (lowThreshold == 0L) {
            Log.e(TAG, "Invalid low storage threshold");
        }
        return lowThreshold;
    }

    private boolean runPostBootUpdate(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        if (this.mExitPostBootUpdate.get()) {
            return false;
        }
        new Thread("BackgroundDexOptService_PostBootUpdate"){

            @Override
            public void run() {
                BackgroundDexOptService.this.postBootUpdate(jobParams, pm, pkgs);
            }
        }.start();
        return true;
    }

    private void postBootUpdate(JobParameters jobParams, PackageManagerService pm, ArraySet<String> pkgs) {
        int lowBatteryThreshold = this.getResources().getInteger(17694801);
        long lowThreshold = this.getLowStorageThreshold(this);
        this.mAbortPostBootUpdate.set(false);
        ArraySet<String> updatedPackages = new ArraySet<String>();
        for (String pkg : pkgs) {
            if (this.mAbortPostBootUpdate.get()) {
                return;
            }
            if (this.mExitPostBootUpdate.get() || this.getBatteryLevel() < lowBatteryThreshold) break;
            long usableSpace = this.mDataDir.getUsableSpace();
            if (usableSpace < lowThreshold) {
                Log.w(TAG, "Aborting background dex opt job due to low storage: " + usableSpace);
                break;
            }
            int result = pm.performDexOptWithStatus(new DexoptOptions(pkg, 1, 4));
            if (result != 1) continue;
            updatedPackages.add(pkg);
        }
        this.notifyPinService(updatedPackages);
        this.jobFinished(jobParams, false);
    }

    private boolean runIdleOptimization(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        new Thread("BackgroundDexOptService_IdleOptimization"){

            @Override
            public void run() {
                int result = BackgroundDexOptService.this.idleOptimization(pm, pkgs, BackgroundDexOptService.this);
                if (result != 2) {
                    Log.w(BackgroundDexOptService.TAG, "Idle optimizations aborted because of space constraints.");
                    BackgroundDexOptService.this.jobFinished(jobParams, false);
                }
            }
        }.start();
        return true;
    }

    private int idleOptimization(PackageManagerService pm, ArraySet<String> pkgs, Context context) {
        Log.i(TAG, "Performing idle optimizations");
        this.mExitPostBootUpdate.set(true);
        this.mAbortIdleOptimization.set(false);
        long lowStorageThreshold = this.getLowStorageThreshold(context);
        int result = this.optimizePackages(pm, pkgs, lowStorageThreshold, true, sFailedPackageNamesPrimary);
        if (result == 2) {
            return result;
        }
        if (SystemProperties.getBoolean("dalvik.vm.dexopt.secondary", false)) {
            result = this.reconcileSecondaryDexFiles(pm.getDexManager());
            if (result == 2) {
                return result;
            }
            result = this.optimizePackages(pm, pkgs, lowStorageThreshold, false, sFailedPackageNamesSecondary);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private int optimizePackages(PackageManagerService pm, ArraySet<String> pkgs, long lowStorageThreshold, boolean is_for_primary_dex, ArraySet<String> failedPackageNames) {
        ArraySet<String> updatedPackages = new ArraySet<String>();
        Set<String> unusedPackages = pm.getUnusedPackages(mDowngradeUnusedAppsThresholdInMillis);
        long lowStorageThresholdForDowngrade = 2L * lowStorageThreshold;
        boolean shouldDowngrade = this.shouldDowngrade(lowStorageThresholdForDowngrade);
        for (String pkg : pkgs) {
            boolean success;
            void var15_14;
            void var16_15;
            ArraySet<String> arraySet;
            int abort_code = this.abortIdleOptimizations(lowStorageThreshold);
            if (abort_code == 2) {
                return abort_code;
            }
            ArraySet<String> arraySet2 = failedPackageNames;
            synchronized (arraySet2) {
                boolean downgrade;
                int reason;
                if (failedPackageNames.contains(pkg)) {
                    continue;
                }
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 10] lbl18 : MonitorExitStatement: MONITOREXIT : var15_13
                if (unusedPackages.contains(pkg) && shouldDowngrade) {
                    if (is_for_primary_dex && !pm.canHaveOatDir(pkg)) {
                        pm.deleteOatArtifactsOfPackage(pkg);
                        continue;
                    }
                    reason = 5;
                    downgrade = true;
                } else {
                    if (abort_code == 3) continue;
                    reason = 3;
                    downgrade = false;
                }
                arraySet = failedPackageNames;
            }
            synchronized (arraySet) {
                failedPackageNames.add(pkg);
            }
            int dexoptFlags = 5 | (var16_15 != false ? 32 : 0);
            if (is_for_primary_dex) {
                int result = pm.performDexOptWithStatus(new DexoptOptions(pkg, (int)var15_14, dexoptFlags));
                boolean bl = success = result != -1;
                if (result == 1) {
                    updatedPackages.add(pkg);
                }
            } else {
                success = pm.performDexOpt(new DexoptOptions(pkg, (int)var15_14, dexoptFlags | 8));
            }
            if (!success) continue;
            ArraySet<String> arraySet3 = failedPackageNames;
            synchronized (arraySet3) {
                failedPackageNames.remove(pkg);
            }
        }
        this.notifyPinService(updatedPackages);
        return 0;
    }

    private int reconcileSecondaryDexFiles(DexManager dm) {
        for (String p : dm.getAllPackagesWithSecondaryDexFiles()) {
            if (this.mAbortIdleOptimization.get()) {
                return 2;
            }
            dm.reconcileSecondaryDexFiles(p);
        }
        return 0;
    }

    private int abortIdleOptimizations(long lowStorageThreshold) {
        if (this.mAbortIdleOptimization.get()) {
            return 2;
        }
        long usableSpace = this.mDataDir.getUsableSpace();
        if (usableSpace < lowStorageThreshold) {
            Log.w(TAG, "Aborting background dex opt job due to low storage: " + usableSpace);
            return 3;
        }
        return 1;
    }

    private boolean shouldDowngrade(long lowStorageThresholdForDowngrade) {
        long usableSpace = this.mDataDir.getUsableSpace();
        return usableSpace < lowStorageThresholdForDowngrade;
    }

    public static boolean runIdleOptimizationsNow(PackageManagerService pm, Context context) {
        BackgroundDexOptService bdos = new BackgroundDexOptService();
        int result = bdos.idleOptimization(pm, pm.getOptimizablePackages(), context);
        return result == 0;
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm.isStorageLow()) {
            return false;
        }
        ArraySet<String> pkgs = pm.getOptimizablePackages();
        if (pkgs.isEmpty()) {
            return false;
        }
        boolean result = params.getJobId() == 801 ? this.runPostBootUpdate(params, pm, pkgs) : this.runIdleOptimization(params, pm, pkgs);
        return result;
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        if (params.getJobId() == 801) {
            this.mAbortPostBootUpdate.set(true);
        } else {
            this.mAbortIdleOptimization.set(true);
        }
        return false;
    }

    private void notifyPinService(ArraySet<String> updatedPackages) {
        PinnerService pinnerService = LocalServices.getService(PinnerService.class);
        if (pinnerService != null) {
            Log.i(TAG, "Pinning optimized code " + updatedPackages);
            pinnerService.update(updatedPackages);
        }
    }

    private static long getDowngradeUnusedAppsThresholdInMillis() {
        String sysPropKey = "pm.dexopt.downgrade_after_inactive_days";
        String sysPropValue = SystemProperties.get("pm.dexopt.downgrade_after_inactive_days");
        if (sysPropValue == null || sysPropValue.isEmpty()) {
            Log.w(TAG, "SysProp pm.dexopt.downgrade_after_inactive_days not set");
            return Long.MAX_VALUE;
        }
        return TimeUnit.DAYS.toMillis(Long.parseLong(sysPropValue));
    }

    private static boolean isBackgroundDexoptDisabled() {
        return SystemProperties.getBoolean("pm.dexopt.disable_bg_dexopt", false);
    }
}

