/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.pm;

import android.app.admin.DevicePolicyManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageInstallObserver2;
import android.content.pm.IPackageInstallerSession;
import android.content.pm.PackageInfo;
import android.content.pm.PackageInstaller;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.Signature;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Binder;
import android.os.Bundle;
import android.os.FileBridge;
import android.os.FileUtils;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.os.RevocableFileDescriptor;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructStat;
import android.text.TextUtils;
import android.util.ArraySet;
import android.util.ExceptionUtils;
import android.util.MathUtils;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.NativeLibraryHelper;
import com.android.internal.content.PackageHelper;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.internal.util.Preconditions;
import com.android.internal.util.XmlUtils;
import com.android.server.pm.Installer;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.PackageInstallerService;
import com.android.server.pm.PackageManagerException;
import com.android.server.pm.PackageManagerService;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class PackageInstallerSession
extends IPackageInstallerSession.Stub {
    private static final String TAG = "PackageInstaller";
    private static final boolean LOGD = true;
    private static final String REMOVE_SPLIT_MARKER_EXTENSION = ".removed";
    private static final int MSG_COMMIT = 0;
    private static final int MSG_SESSION_FINISHED_WITH_EXCEPTION = 1;
    static final String TAG_SESSION = "session";
    private static final String TAG_GRANTED_RUNTIME_PERMISSION = "granted-runtime-permission";
    private static final String ATTR_SESSION_ID = "sessionId";
    private static final String ATTR_USER_ID = "userId";
    private static final String ATTR_INSTALLER_PACKAGE_NAME = "installerPackageName";
    private static final String ATTR_INSTALLER_UID = "installerUid";
    private static final String ATTR_CREATED_MILLIS = "createdMillis";
    private static final String ATTR_SESSION_STAGE_DIR = "sessionStageDir";
    private static final String ATTR_SESSION_STAGE_CID = "sessionStageCid";
    private static final String ATTR_PREPARED = "prepared";
    private static final String ATTR_SEALED = "sealed";
    private static final String ATTR_MODE = "mode";
    private static final String ATTR_INSTALL_FLAGS = "installFlags";
    private static final String ATTR_INSTALL_LOCATION = "installLocation";
    private static final String ATTR_SIZE_BYTES = "sizeBytes";
    private static final String ATTR_APP_PACKAGE_NAME = "appPackageName";
    @Deprecated
    private static final String ATTR_APP_ICON = "appIcon";
    private static final String ATTR_APP_LABEL = "appLabel";
    private static final String ATTR_ORIGINATING_URI = "originatingUri";
    private static final String ATTR_ORIGINATING_UID = "originatingUid";
    private static final String ATTR_REFERRER_URI = "referrerUri";
    private static final String ATTR_ABI_OVERRIDE = "abiOverride";
    private static final String ATTR_VOLUME_UUID = "volumeUuid";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_INSTALL_REASON = "installRason";
    private final PackageInstallerService.InternalCallback mCallback;
    private final Context mContext;
    private final PackageManagerService mPm;
    private final Handler mHandler;
    final int sessionId;
    final int userId;
    final PackageInstaller.SessionParams params;
    final long createdMillis;
    final int defaultContainerGid;
    final File stageDir;
    final String stageCid;
    private final AtomicInteger mActiveCount = new AtomicInteger();
    private final Object mLock = new Object();
    private final int mOriginalInstallerUid;
    @GuardedBy(value="mLock")
    private String mInstallerPackageName;
    @GuardedBy(value="mLock")
    private int mInstallerUid;
    @GuardedBy(value="mLock")
    private float mClientProgress = 0.0f;
    @GuardedBy(value="mLock")
    private float mInternalProgress = 0.0f;
    @GuardedBy(value="mLock")
    private float mProgress = 0.0f;
    @GuardedBy(value="mLock")
    private float mReportedProgress = -1.0f;
    @GuardedBy(value="mLock")
    private boolean mPrepared = false;
    @GuardedBy(value="mLock")
    private boolean mSealed = false;
    @GuardedBy(value="mLock")
    private boolean mCommitted = false;
    @GuardedBy(value="mLock")
    private boolean mRelinquished = false;
    @GuardedBy(value="mLock")
    private boolean mDestroyed = false;
    @GuardedBy(value="mLock")
    private boolean mPermissionsManuallyAccepted = false;
    @GuardedBy(value="mLock")
    private int mFinalStatus;
    @GuardedBy(value="mLock")
    private String mFinalMessage;
    @GuardedBy(value="mLock")
    private final ArrayList<RevocableFileDescriptor> mFds = new ArrayList();
    @GuardedBy(value="mLock")
    private final ArrayList<FileBridge> mBridges = new ArrayList();
    @GuardedBy(value="mLock")
    private IPackageInstallObserver2 mRemoteObserver;
    @GuardedBy(value="mLock")
    private String mPackageName;
    @GuardedBy(value="mLock")
    private int mVersionCode;
    @GuardedBy(value="mLock")
    private Signature[] mSignatures;
    @GuardedBy(value="mLock")
    private Certificate[][] mCertificates;
    @GuardedBy(value="mLock")
    private File mResolvedBaseFile;
    @GuardedBy(value="mLock")
    private File mResolvedStageDir;
    @GuardedBy(value="mLock")
    private final List<File> mResolvedStagedFiles = new ArrayList<File>();
    @GuardedBy(value="mLock")
    private final List<File> mResolvedInheritedFiles = new ArrayList<File>();
    @GuardedBy(value="mLock")
    private final List<String> mResolvedInstructionSets = new ArrayList<String>();
    @GuardedBy(value="mLock")
    private File mInheritedFilesBase;
    private static final FileFilter sAddedFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            return !file.getName().endsWith(PackageInstallerSession.REMOVE_SPLIT_MARKER_EXTENSION);
        }
    };
    private static final FileFilter sRemovedFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return false;
            }
            return file.getName().endsWith(PackageInstallerSession.REMOVE_SPLIT_MARKER_EXTENSION);
        }
    };
    private final Handler.Callback mHandlerCallback = new Handler.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 0: {
                    Object object = PackageInstallerSession.this.mLock;
                    synchronized (object) {
                        try {
                            PackageInstallerSession.this.commitLocked();
                        }
                        catch (PackageManagerException e) {
                            String completeMsg = ExceptionUtils.getCompleteMessage(e);
                            Slog.e(PackageInstallerSession.TAG, "Commit of session " + PackageInstallerSession.this.sessionId + " failed: " + completeMsg);
                            PackageInstallerSession.this.destroyInternal();
                            PackageInstallerSession.this.dispatchSessionFinished(e.error, completeMsg, null);
                        }
                        break;
                    }
                }
                case 1: {
                    PackageManagerException e = (PackageManagerException)msg.obj;
                    PackageInstallerSession.this.dispatchSessionFinished(e.error, ExceptionUtils.getCompleteMessage(e), null);
                }
            }
            return true;
        }
    };

    private boolean isInstallerDeviceOwnerLocked() {
        DevicePolicyManager dpm = (DevicePolicyManager)this.mContext.getSystemService("device_policy");
        return dpm != null && dpm.isDeviceOwnerAppOnCallingUser(this.mInstallerPackageName);
    }

    private boolean needToAskForPermissionsLocked() {
        if (this.mPermissionsManuallyAccepted) {
            return false;
        }
        boolean isPermissionGranted = this.mPm.checkUidPermission("android.permission.INSTALL_PACKAGES", this.mInstallerUid) == 0;
        boolean isInstallerRoot = this.mInstallerUid == 0;
        boolean forcePermissionPrompt = (this.params.installFlags & 0x400) != 0;
        return forcePermissionPrompt || !isPermissionGranted && !isInstallerRoot && !this.isInstallerDeviceOwnerLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInstallerSession(PackageInstallerService.InternalCallback callback, Context context, PackageManagerService pm, Looper looper, int sessionId, int userId, String installerPackageName, int installerUid, PackageInstaller.SessionParams params, long createdMillis, File stageDir, String stageCid, boolean prepared, boolean sealed) {
        this.mCallback = callback;
        this.mContext = context;
        this.mPm = pm;
        this.mHandler = new Handler(looper, this.mHandlerCallback);
        this.sessionId = sessionId;
        this.userId = userId;
        this.mOriginalInstallerUid = installerUid;
        this.mInstallerPackageName = installerPackageName;
        this.mInstallerUid = installerUid;
        this.params = params;
        this.createdMillis = createdMillis;
        this.stageDir = stageDir;
        this.stageCid = stageCid;
        if (stageDir == null == (stageCid == null)) {
            throw new IllegalArgumentException("Exactly one of stageDir or stageCid stage must be set");
        }
        this.mPrepared = prepared;
        if (sealed) {
            Object object = this.mLock;
            synchronized (object) {
                try {
                    this.sealAndValidateLocked();
                }
                catch (PackageManagerException | IOException e) {
                    this.destroyInternal();
                    throw new IllegalArgumentException(e);
                }
            }
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int uid = this.mPm.getPackageUid("com.android.defcontainer", 0x100000, 0);
            this.defaultContainerGid = UserHandle.getSharedAppGid(uid);
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public PackageInstaller.SessionInfo generateInfo() {
        return this.generateInfo(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInstaller.SessionInfo generateInfo(boolean includeIcon) {
        PackageInstaller.SessionInfo info = new PackageInstaller.SessionInfo();
        Object object = this.mLock;
        synchronized (object) {
            info.sessionId = this.sessionId;
            info.installerPackageName = this.mInstallerPackageName;
            info.resolvedBaseCodePath = this.mResolvedBaseFile != null ? this.mResolvedBaseFile.getAbsolutePath() : null;
            info.progress = this.mProgress;
            info.sealed = this.mSealed;
            info.active = this.mActiveCount.get() > 0;
            info.mode = this.params.mode;
            info.installReason = this.params.installReason;
            info.sizeBytes = this.params.sizeBytes;
            info.appPackageName = this.params.appPackageName;
            if (includeIcon) {
                info.appIcon = this.params.appIcon;
            }
            info.appLabel = this.params.appLabel;
            info.installLocation = this.params.installLocation;
            info.originatingUri = this.params.originatingUri;
            info.originatingUid = this.params.originatingUid;
            info.referrerUri = this.params.referrerUri;
            info.grantedRuntimePermissions = this.params.grantedRuntimePermissions;
            info.installFlags = this.params.installFlags;
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrepared() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPrepared;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSealed() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mSealed;
        }
    }

    private void assertPreparedAndNotSealedLocked(String cookie) {
        this.assertPreparedAndNotCommittedOrDestroyedLocked(cookie);
        if (this.mSealed) {
            throw new SecurityException(cookie + " not allowed after sealing");
        }
    }

    private void assertPreparedAndNotCommittedOrDestroyedLocked(String cookie) {
        this.assertPreparedAndNotDestroyedLocked(cookie);
        if (this.mCommitted) {
            throw new SecurityException(cookie + " not allowed after commit");
        }
    }

    private void assertPreparedAndNotDestroyedLocked(String cookie) {
        if (!this.mPrepared) {
            throw new IllegalStateException(cookie + " before prepared");
        }
        if (this.mDestroyed) {
            throw new SecurityException(cookie + " not allowed after destruction");
        }
    }

    private File resolveStageDirLocked() throws IOException {
        if (this.mResolvedStageDir == null) {
            if (this.stageDir != null) {
                this.mResolvedStageDir = this.stageDir;
            } else {
                String path = PackageHelper.getSdDir(this.stageCid);
                if (path != null) {
                    this.mResolvedStageDir = new File(path);
                } else {
                    throw new IOException("Failed to resolve path to container " + this.stageCid);
                }
            }
        }
        return this.mResolvedStageDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClientProgress(float progress) {
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            boolean forcePublish = this.mClientProgress == 0.0f;
            this.mClientProgress = progress;
            this.computeProgressLocked(forcePublish);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addClientProgress(float progress) {
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            this.setClientProgress(this.mClientProgress + progress);
        }
    }

    private void computeProgressLocked(boolean forcePublish) {
        this.mProgress = MathUtils.constrain(this.mClientProgress * 0.8f, 0.0f, 0.8f) + MathUtils.constrain(this.mInternalProgress * 0.2f, 0.0f, 0.2f);
        if (forcePublish || (double)Math.abs(this.mProgress - this.mReportedProgress) >= 0.01) {
            this.mReportedProgress = this.mProgress;
            this.mCallback.onSessionProgressChanged(this, this.mProgress);
        }
    }

    @Override
    public String[] getNames() {
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            this.assertPreparedAndNotCommittedOrDestroyedLocked("getNames");
            try {
                return this.resolveStageDirLocked().list();
            }
            catch (IOException e) {
                throw ExceptionUtils.wrap(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSplit(String splitName) {
        if (TextUtils.isEmpty(this.params.appPackageName)) {
            throw new IllegalStateException("Must specify package name to remove a split");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            this.assertPreparedAndNotCommittedOrDestroyedLocked("removeSplit");
            try {
                this.createRemoveSplitMarkerLocked(splitName);
            }
            catch (IOException e) {
                throw ExceptionUtils.wrap(e);
            }
        }
    }

    private void createRemoveSplitMarkerLocked(String splitName) throws IOException {
        try {
            String markerName = splitName + REMOVE_SPLIT_MARKER_EXTENSION;
            if (!FileUtils.isValidExtFilename(markerName)) {
                throw new IllegalArgumentException("Invalid marker: " + markerName);
            }
            File target = new File(this.resolveStageDirLocked(), markerName);
            target.createNewFile();
            Os.chmod(target.getAbsolutePath(), 0);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    @Override
    public ParcelFileDescriptor openWrite(String name, long offsetBytes, long lengthBytes) {
        try {
            return this.openWriteInternal(name, offsetBytes, lengthBytes);
        }
        catch (IOException e) {
            throw ExceptionUtils.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParcelFileDescriptor openWriteInternal(String name, long offsetBytes, long lengthBytes) throws IOException {
        File stageDir;
        FileBridge bridge;
        RevocableFileDescriptor fd;
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            this.assertPreparedAndNotSealedLocked("openWrite");
            if (PackageInstaller.ENABLE_REVOCABLE_FD) {
                fd = new RevocableFileDescriptor();
                bridge = null;
                this.mFds.add(fd);
            } else {
                fd = null;
                bridge = new FileBridge();
                this.mBridges.add(bridge);
            }
            stageDir = this.resolveStageDirLocked();
        }
        try {
            File target;
            if (!FileUtils.isValidExtFilename(name)) {
                throw new IllegalArgumentException("Invalid name: " + name);
            }
            long identity = Binder.clearCallingIdentity();
            try {
                target = new File(stageDir, name);
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
            FileDescriptor targetFd = Libcore.os.open(target.getAbsolutePath(), OsConstants.O_CREAT | OsConstants.O_WRONLY, 420);
            Os.chmod(target.getAbsolutePath(), 420);
            if (stageDir != null && lengthBytes > 0L) {
                this.mContext.getSystemService(StorageManager.class).allocateBytes(targetFd, lengthBytes, PackageHelper.translateAllocateFlags(this.params.installFlags));
            }
            if (offsetBytes > 0L) {
                Libcore.os.lseek(targetFd, offsetBytes, OsConstants.SEEK_SET);
            }
            if (PackageInstaller.ENABLE_REVOCABLE_FD) {
                fd.init(this.mContext, targetFd);
                return fd.getRevocableFileDescriptor();
            }
            bridge.setTargetFile(targetFd);
            bridge.start();
            return new ParcelFileDescriptor(bridge.getClientSocket());
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    @Override
    public ParcelFileDescriptor openRead(String name) {
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            this.assertPreparedAndNotCommittedOrDestroyedLocked("openRead");
            try {
                return this.openReadInternalLocked(name);
            }
            catch (IOException e) {
                throw ExceptionUtils.wrap(e);
            }
        }
    }

    private ParcelFileDescriptor openReadInternalLocked(String name) throws IOException {
        try {
            if (!FileUtils.isValidExtFilename(name)) {
                throw new IllegalArgumentException("Invalid name: " + name);
            }
            File target = new File(this.resolveStageDirLocked(), name);
            FileDescriptor targetFd = Libcore.os.open(target.getAbsolutePath(), OsConstants.O_RDONLY, 0);
            return new ParcelFileDescriptor(targetFd);
        }
        catch (ErrnoException e) {
            throw e.rethrowAsIOException();
        }
    }

    private void assertCallerIsOwnerOrRootLocked() {
        int callingUid = Binder.getCallingUid();
        if (callingUid != 0 && callingUid != this.mInstallerUid) {
            throw new SecurityException("Session does not belong to uid " + callingUid);
        }
    }

    private void assertNoWriteFileTransfersOpenLocked() {
        for (RevocableFileDescriptor fd : this.mFds) {
            if (fd.isRevoked()) continue;
            throw new SecurityException("Files still open");
        }
        for (FileBridge bridge : this.mBridges) {
            if (bridge.isClosed()) continue;
            throw new SecurityException("Files still open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(IntentSender statusReceiver, boolean forTransfer) {
        boolean wasSealed;
        Preconditions.checkNotNull(statusReceiver);
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            this.assertPreparedAndNotDestroyedLocked("commit");
            PackageInstallerService.PackageInstallObserverAdapter adapter = new PackageInstallerService.PackageInstallObserverAdapter(this.mContext, statusReceiver, this.sessionId, this.isInstallerDeviceOwnerLocked(), this.userId);
            this.mRemoteObserver = adapter.getBinder();
            if (forTransfer) {
                this.mContext.enforceCallingOrSelfPermission("android.permission.INSTALL_PACKAGES", null);
                if (this.mInstallerUid == this.mOriginalInstallerUid) {
                    throw new IllegalArgumentException("Session has not been transferred");
                }
            } else if (this.mInstallerUid != this.mOriginalInstallerUid) {
                throw new IllegalArgumentException("Session has been transferred");
            }
            wasSealed = this.mSealed;
            if (!this.mSealed) {
                try {
                    this.sealAndValidateLocked();
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
                catch (PackageManagerException e) {
                    this.destroyInternal();
                    this.mHandler.obtainMessage(1, e).sendToTarget();
                    return;
                }
            }
            this.mClientProgress = 1.0f;
            this.computeProgressLocked(true);
            this.mActiveCount.incrementAndGet();
            this.mCommitted = true;
            this.mHandler.obtainMessage(0).sendToTarget();
        }
        if (!wasSealed) {
            this.mCallback.onSessionSealedBlocking(this);
        }
    }

    private void sealAndValidateLocked() throws PackageManagerException, IOException {
        this.assertNoWriteFileTransfersOpenLocked();
        this.assertPreparedAndNotDestroyedLocked("sealing of session");
        PackageInfo pkgInfo = this.mPm.getPackageInfo(this.params.appPackageName, 0x4000040, this.userId);
        this.resolveStageDirLocked();
        this.mSealed = true;
        try {
            this.validateInstallLocked(pkgInfo);
        }
        catch (PackageManagerException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new PackageManagerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transfer(String packageName) {
        Preconditions.checkNotNull(packageName);
        ApplicationInfo newOwnerAppInfo = this.mPm.getApplicationInfo(packageName, 0, this.userId);
        if (newOwnerAppInfo == null) {
            throw new ParcelableException(new PackageManager.NameNotFoundException(packageName));
        }
        if (0 != this.mPm.checkUidPermission("android.permission.INSTALL_PACKAGES", newOwnerAppInfo.uid)) {
            throw new SecurityException("Destination package " + packageName + " does not have " + "the " + "android.permission.INSTALL_PACKAGES" + " permission");
        }
        if (!this.params.areHiddenOptionsSet()) {
            throw new SecurityException("Can only transfer sessions that use public options");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            this.assertPreparedAndNotSealedLocked("transfer");
            try {
                this.sealAndValidateLocked();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            catch (PackageManagerException e) {
                this.destroyInternal();
                this.dispatchSessionFinished(e.error, ExceptionUtils.getCompleteMessage(e), null);
                throw new IllegalArgumentException("Package is not valid", e);
            }
            if (!this.mPackageName.equals(this.mInstallerPackageName)) {
                throw new SecurityException("Can only transfer sessions that update the original installer");
            }
            this.mInstallerPackageName = packageName;
            this.mInstallerUid = newOwnerAppInfo.uid;
        }
        this.mCallback.onSessionSealedBlocking(this);
    }

    private void commitLocked() throws PackageManagerException {
        if (this.mDestroyed) {
            throw new PackageManagerException(-110, "Session destroyed");
        }
        if (!this.mSealed) {
            throw new PackageManagerException(-110, "Session not sealed");
        }
        Preconditions.checkNotNull(this.mPackageName);
        Preconditions.checkNotNull(this.mSignatures);
        Preconditions.checkNotNull(this.mResolvedBaseFile);
        if (this.needToAskForPermissionsLocked()) {
            Intent intent = new Intent("android.content.pm.action.CONFIRM_PERMISSIONS");
            intent.setPackage(this.mContext.getPackageManager().getPermissionControllerPackageName());
            intent.putExtra("android.content.pm.extra.SESSION_ID", this.sessionId);
            try {
                this.mRemoteObserver.onUserActionRequired(intent);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            this.closeInternal(false);
            return;
        }
        if (this.stageCid != null) {
            long finalSize = this.calculateInstalledSize();
            PackageInstallerSession.resizeContainer(this.stageCid, finalSize);
        }
        if (this.params.mode == 2) {
            try {
                List<File> fromFiles = this.mResolvedInheritedFiles;
                File toDir = this.resolveStageDirLocked();
                Slog.d(TAG, "Inherited files: " + this.mResolvedInheritedFiles);
                if (!this.mResolvedInheritedFiles.isEmpty() && this.mInheritedFilesBase == null) {
                    throw new IllegalStateException("mInheritedFilesBase == null");
                }
                if (this.isLinkPossible(fromFiles, toDir)) {
                    if (!this.mResolvedInstructionSets.isEmpty()) {
                        File oatDir = new File(toDir, "oat");
                        this.createOatDirs(this.mResolvedInstructionSets, oatDir);
                    }
                    this.linkFiles(fromFiles, toDir, this.mInheritedFilesBase);
                } else {
                    PackageInstallerSession.copyFiles(fromFiles, toDir);
                }
            }
            catch (IOException e) {
                throw new PackageManagerException(-4, "Failed to inherit existing install", e);
            }
        }
        this.mInternalProgress = 0.5f;
        this.computeProgressLocked(true);
        PackageInstallerSession.extractNativeLibraries(this.mResolvedStageDir, this.params.abiOverride);
        if (this.stageCid != null) {
            this.finalizeAndFixContainer(this.stageCid);
        }
        IPackageInstallObserver2.Stub localObserver = new IPackageInstallObserver2.Stub(){

            @Override
            public void onUserActionRequired(Intent intent) {
                throw new IllegalStateException();
            }

            @Override
            public void onPackageInstalled(String basePackageName, int returnCode, String msg, Bundle extras) {
                PackageInstallerSession.this.destroyInternal();
                PackageInstallerSession.this.dispatchSessionFinished(returnCode, msg, extras);
            }
        };
        UserHandle user = (this.params.installFlags & 0x40) != 0 ? UserHandle.ALL : new UserHandle(this.userId);
        this.mRelinquished = true;
        this.mPm.installStage(this.mPackageName, this.stageDir, this.stageCid, localObserver, this.params, this.mInstallerPackageName, this.mInstallerUid, user, this.mCertificates);
    }

    private void validateInstallLocked(PackageInfo pkgInfo) throws PackageManagerException {
        File[] addedFiles;
        this.mPackageName = null;
        this.mVersionCode = -1;
        this.mSignatures = null;
        this.mResolvedBaseFile = null;
        this.mResolvedStagedFiles.clear();
        this.mResolvedInheritedFiles.clear();
        try {
            this.resolveStageDirLocked();
        }
        catch (IOException e) {
            throw new PackageManagerException(-18, "Failed to resolve stage location", e);
        }
        File[] removedFiles = this.mResolvedStageDir.listFiles(sRemovedFilter);
        ArrayList<String> removeSplitList = new ArrayList<String>();
        if (!ArrayUtils.isEmpty(removedFiles)) {
            for (File removedFile : removedFiles) {
                String fileName = removedFile.getName();
                String splitName = fileName.substring(0, fileName.length() - REMOVE_SPLIT_MARKER_EXTENSION.length());
                removeSplitList.add(splitName);
            }
        }
        if (ArrayUtils.isEmpty(addedFiles = this.mResolvedStageDir.listFiles(sAddedFilter)) && removeSplitList.size() == 0) {
            throw new PackageManagerException(-2, "No packages staged");
        }
        ArraySet<String> stagedSplits = new ArraySet<String>();
        for (File addedFile : addedFiles) {
            PackageParser.ApkLite apk;
            try {
                int flags = 256;
                if ((this.params.installFlags & 0x800) != 0) {
                    flags |= 0x800;
                }
                apk = PackageParser.parseApkLite(addedFile, flags);
            }
            catch (PackageParser.PackageParserException e) {
                throw PackageManagerException.from(e);
            }
            if (!stagedSplits.add(apk.splitName)) {
                throw new PackageManagerException(-2, "Split " + apk.splitName + " was defined multiple times");
            }
            if (this.mPackageName == null) {
                this.mPackageName = apk.packageName;
                this.mVersionCode = apk.versionCode;
            }
            if (this.mSignatures == null) {
                this.mSignatures = apk.signatures;
                this.mCertificates = apk.certificates;
            }
            this.assertApkConsistentLocked(String.valueOf(addedFile), apk);
            String targetName = apk.splitName == null ? "base.apk" : "split_" + apk.splitName + ".apk";
            if (!FileUtils.isValidExtFilename(targetName)) {
                throw new PackageManagerException(-2, "Invalid filename: " + targetName);
            }
            File targetFile = new File(this.mResolvedStageDir, targetName);
            if (!addedFile.equals(targetFile)) {
                addedFile.renameTo(targetFile);
            }
            if (apk.splitName == null) {
                this.mResolvedBaseFile = targetFile;
            }
            this.mResolvedStagedFiles.add(targetFile);
        }
        if (removeSplitList.size() > 0) {
            if (pkgInfo == null) {
                throw new PackageManagerException(-2, "Missing existing base package for " + this.mPackageName);
            }
            for (String splitName : removeSplitList) {
                if (ArrayUtils.contains(pkgInfo.splitNames, splitName)) continue;
                throw new PackageManagerException(-2, "Split not found: " + splitName);
            }
            if (this.mPackageName == null) {
                this.mPackageName = pkgInfo.packageName;
                this.mVersionCode = pkgInfo.versionCode;
            }
            if (this.mSignatures == null) {
                this.mSignatures = pkgInfo.signatures;
            }
        }
        if (this.params.mode == 1) {
            if (!stagedSplits.contains(null)) {
                throw new PackageManagerException(-2, "Full install must include a base package");
            }
        } else {
            File[] archSubdirs;
            File packageInstallDir;
            PackageParser.ApkLite existingBase;
            PackageParser.PackageLite existing;
            if (pkgInfo == null || pkgInfo.applicationInfo == null) {
                throw new PackageManagerException(-2, "Missing existing base package for " + this.mPackageName);
            }
            ApplicationInfo appInfo = pkgInfo.applicationInfo;
            try {
                existing = PackageParser.parsePackageLite(new File(appInfo.getCodePath()), 0);
                existingBase = PackageParser.parseApkLite(new File(appInfo.getBaseCodePath()), 256);
            }
            catch (PackageParser.PackageParserException e) {
                throw PackageManagerException.from(e);
            }
            this.assertApkConsistentLocked("Existing base", existingBase);
            if (this.mResolvedBaseFile == null) {
                this.mResolvedBaseFile = new File(appInfo.getBaseCodePath());
                this.mResolvedInheritedFiles.add(this.mResolvedBaseFile);
            }
            if (!ArrayUtils.isEmpty(existing.splitNames)) {
                for (int i = 0; i < existing.splitNames.length; ++i) {
                    String splitName = existing.splitNames[i];
                    File splitFile = new File(existing.splitCodePaths[i]);
                    boolean splitRemoved = removeSplitList.contains(splitName);
                    if (stagedSplits.contains(splitName) || splitRemoved) continue;
                    this.mResolvedInheritedFiles.add(splitFile);
                }
            }
            this.mInheritedFilesBase = packageInstallDir = new File(appInfo.getBaseCodePath()).getParentFile();
            File oatDir = new File(packageInstallDir, "oat");
            if (oatDir.exists() && (archSubdirs = oatDir.listFiles()) != null && archSubdirs.length > 0) {
                String[] instructionSets = InstructionSets.getAllDexCodeInstructionSets();
                for (File archSubDir : archSubdirs) {
                    if (!ArrayUtils.contains(instructionSets, archSubDir.getName())) continue;
                    this.mResolvedInstructionSets.add(archSubDir.getName());
                    List<File> oatFiles = Arrays.asList(archSubDir.listFiles());
                    for (File oatFile : oatFiles) {
                        if (!oatFile.getName().equals("base.art") && !oatFile.getName().equals("base.odex") && !oatFile.getName().equals("base.vdex")) continue;
                        this.mResolvedInheritedFiles.add(oatFile);
                    }
                }
            }
        }
    }

    private void assertApkConsistentLocked(String tag, PackageParser.ApkLite apk) throws PackageManagerException {
        if (!this.mPackageName.equals(apk.packageName)) {
            throw new PackageManagerException(-2, tag + " package " + apk.packageName + " inconsistent with " + this.mPackageName);
        }
        if (this.params.appPackageName != null && !this.params.appPackageName.equals(apk.packageName)) {
            throw new PackageManagerException(-2, tag + " specified package " + this.params.appPackageName + " inconsistent with " + apk.packageName);
        }
        if (this.mVersionCode != apk.versionCode) {
            throw new PackageManagerException(-2, tag + " version code " + apk.versionCode + " inconsistent with " + this.mVersionCode);
        }
        if (!Signature.areExactMatch(this.mSignatures, apk.signatures)) {
            throw new PackageManagerException(-2, tag + " signatures are inconsistent");
        }
    }

    private long calculateInstalledSize() throws PackageManagerException {
        PackageParser.ApkLite baseApk;
        Preconditions.checkNotNull(this.mResolvedBaseFile);
        try {
            baseApk = PackageParser.parseApkLite(this.mResolvedBaseFile, 0);
        }
        catch (PackageParser.PackageParserException e) {
            throw PackageManagerException.from(e);
        }
        ArrayList<String> splitPaths = new ArrayList<String>();
        for (File file : this.mResolvedStagedFiles) {
            if (this.mResolvedBaseFile.equals(file)) continue;
            splitPaths.add(file.getAbsolutePath());
        }
        for (File file : this.mResolvedInheritedFiles) {
            if (this.mResolvedBaseFile.equals(file)) continue;
            splitPaths.add(file.getAbsolutePath());
        }
        PackageParser.PackageLite pkg = new PackageParser.PackageLite(null, baseApk, null, null, null, null, splitPaths.toArray(new String[splitPaths.size()]), null);
        boolean isForwardLocked = (this.params.installFlags & 1) != 0;
        try {
            return PackageHelper.calculateInstalledSize(pkg, isForwardLocked, this.params.abiOverride);
        }
        catch (IOException e) {
            throw new PackageManagerException(-2, "Failed to calculate install size", e);
        }
    }

    private boolean isLinkPossible(List<File> fromFiles, File toDir) {
        StructStat toStat = Os.stat(toDir.getAbsolutePath());
        for (File fromFile : fromFiles) {
            StructStat fromStat = Os.stat(fromFile.getAbsolutePath());
            if (fromStat.st_dev != toStat.st_dev) {
                return false;
            }
            try {
            }
            catch (ErrnoException e) {
                Slog.w(TAG, "Failed to detect if linking possible: " + e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInstallerUid() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mInstallerUid;
        }
    }

    private static String getRelativePath(File file, File base) throws IOException {
        String pathStr = file.getAbsolutePath();
        String baseStr = base.getAbsolutePath();
        if (pathStr.contains("/.")) {
            throw new IOException("Invalid path (was relative) : " + pathStr);
        }
        if (pathStr.startsWith(baseStr)) {
            return pathStr.substring(baseStr.length());
        }
        throw new IOException("File: " + pathStr + " outside base: " + baseStr);
    }

    private void createOatDirs(List<String> instructionSets, File fromDir) throws PackageManagerException {
        for (String instructionSet : instructionSets) {
            try {
                this.mPm.mInstaller.createOatDir(fromDir.getAbsolutePath(), instructionSet);
            }
            catch (Installer.InstallerException e) {
                throw PackageManagerException.from(e);
            }
        }
    }

    private void linkFiles(List<File> fromFiles, File toDir, File fromDir) throws IOException {
        for (File fromFile : fromFiles) {
            String relativePath = PackageInstallerSession.getRelativePath(fromFile, fromDir);
            try {
                this.mPm.mInstaller.linkFile(relativePath, fromDir.getAbsolutePath(), toDir.getAbsolutePath());
            }
            catch (Installer.InstallerException e) {
                throw new IOException("failed linkOrCreateDir(" + relativePath + ", " + fromDir + ", " + toDir + ")", e);
            }
        }
        Slog.d(TAG, "Linked " + fromFiles.size() + " files into " + toDir);
    }

    private static void copyFiles(List<File> fromFiles, File toDir) throws IOException {
        for (File file : toDir.listFiles()) {
            if (!file.getName().endsWith(".tmp")) continue;
            file.delete();
        }
        for (File fromFile : fromFiles) {
            File tmpFile = File.createTempFile("inherit", ".tmp", toDir);
            Slog.d(TAG, "Copying " + fromFile + " to " + tmpFile);
            if (!FileUtils.copyFile(fromFile, tmpFile)) {
                throw new IOException("Failed to copy " + fromFile + " to " + tmpFile);
            }
            try {
                Os.chmod(tmpFile.getAbsolutePath(), 420);
            }
            catch (ErrnoException e) {
                throw new IOException("Failed to chmod " + tmpFile);
            }
            File toFile = new File(toDir, fromFile.getName());
            Slog.d(TAG, "Renaming " + tmpFile + " to " + toFile);
            if (tmpFile.renameTo(toFile)) continue;
            throw new IOException("Failed to rename " + tmpFile + " to " + toFile);
        }
        Slog.d(TAG, "Copied " + fromFiles.size() + " files into " + toDir);
    }

    private static void extractNativeLibraries(File packageDir, String abiOverride) throws PackageManagerException {
        File libDir = new File(packageDir, "lib");
        NativeLibraryHelper.removeNativeBinariesFromDirLI(libDir, true);
        NativeLibraryHelper.Handle handle = null;
        try {
            handle = NativeLibraryHelper.Handle.create(packageDir);
            int res = NativeLibraryHelper.copyNativeBinariesWithOverride(handle, libDir, abiOverride);
            if (res != 1) {
                throw new PackageManagerException(res, "Failed to extract native libraries, res=" + res);
            }
        }
        catch (IOException e) {
            throw new PackageManagerException(-110, "Failed to extract native libraries", e);
        }
        finally {
            IoUtils.closeQuietly(handle);
        }
    }

    private static void resizeContainer(String cid, long targetSize) throws PackageManagerException {
        String path = PackageHelper.getSdDir(cid);
        if (path == null) {
            throw new PackageManagerException(-18, "Failed to find mounted " + cid);
        }
        long currentSize = new File(path).getTotalSpace();
        if (currentSize > targetSize) {
            Slog.w(TAG, "Current size " + currentSize + " is larger than target size " + targetSize + "; skipping resize");
            return;
        }
        if (!PackageHelper.unMountSdDir(cid)) {
            throw new PackageManagerException(-18, "Failed to unmount " + cid + " before resize");
        }
        if (!PackageHelper.resizeSdDir(targetSize, cid, PackageManagerService.getEncryptKey())) {
            throw new PackageManagerException(-18, "Failed to resize " + cid + " to " + targetSize + " bytes");
        }
        path = PackageHelper.mountSdDir(cid, PackageManagerService.getEncryptKey(), 1000, false);
        if (path == null) {
            throw new PackageManagerException(-18, "Failed to mount " + cid + " after resize");
        }
    }

    private void finalizeAndFixContainer(String cid) throws PackageManagerException {
        if (!PackageHelper.finalizeSdDir(cid)) {
            throw new PackageManagerException(-18, "Failed to finalize container " + cid);
        }
        if (!PackageHelper.fixSdPermissions(cid, this.defaultContainerGid, null)) {
            throw new PackageManagerException(-18, "Failed to fix permissions on container " + cid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPermissionsResult(boolean accepted) {
        if (!this.mSealed) {
            throw new SecurityException("Must be sealed to accept permissions");
        }
        if (accepted) {
            Object object = this.mLock;
            synchronized (object) {
                this.mPermissionsManuallyAccepted = true;
                this.mHandler.obtainMessage(0).sendToTarget();
            }
        } else {
            this.destroyInternal();
            this.dispatchSessionFinished(-115, "User rejected permissions", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws IOException {
        boolean wasPrepared;
        if (this.mActiveCount.getAndIncrement() == 0) {
            this.mCallback.onSessionActiveChanged(this, true);
        }
        Object object = this.mLock;
        synchronized (object) {
            wasPrepared = this.mPrepared;
            if (!this.mPrepared) {
                if (this.stageDir != null) {
                    PackageInstallerService.prepareStageDir(this.stageDir);
                } else if (this.stageCid != null) {
                    long identity = Binder.clearCallingIdentity();
                    try {
                        PackageInstallerService.prepareExternalStageCid(this.stageCid, this.params.sizeBytes);
                    }
                    finally {
                        Binder.restoreCallingIdentity(identity);
                    }
                    this.mInternalProgress = 0.25f;
                    this.computeProgressLocked(true);
                } else {
                    throw new IllegalArgumentException("Exactly one of stageDir or stageCid stage must be set");
                }
                this.mPrepared = true;
            }
        }
        if (!wasPrepared) {
            this.mCallback.onSessionPrepared(this);
        }
    }

    @Override
    public void close() {
        this.closeInternal(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean checkCaller) {
        int activeCount;
        Object object = this.mLock;
        synchronized (object) {
            if (checkCaller) {
                this.assertCallerIsOwnerOrRootLocked();
            }
            activeCount = this.mActiveCount.decrementAndGet();
        }
        if (activeCount == 0) {
            this.mCallback.onSessionActiveChanged(this, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abandon() {
        Object object = this.mLock;
        synchronized (object) {
            this.assertCallerIsOwnerOrRootLocked();
            if (this.mRelinquished) {
                Slog.d(TAG, "Ignoring abandon after commit relinquished control");
                return;
            }
            this.destroyInternal();
        }
        this.dispatchSessionFinished(-115, "Session was abandoned", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchSessionFinished(int returnCode, String msg, Bundle extras) {
        boolean isNewInstall;
        String packageName;
        IPackageInstallObserver2 observer;
        Object object = this.mLock;
        synchronized (object) {
            this.mFinalStatus = returnCode;
            this.mFinalMessage = msg;
            observer = this.mRemoteObserver;
            packageName = this.mPackageName;
        }
        if (observer != null) {
            try {
                observer.onPackageInstalled(packageName, returnCode, msg, extras);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        boolean success = returnCode == 1;
        boolean bl = isNewInstall = extras == null || !extras.getBoolean("android.intent.extra.REPLACING");
        if (success && isNewInstall) {
            this.mPm.sendSessionCommitBroadcast(this.generateInfo(), this.userId);
        }
        this.mCallback.onSessionFinished(this, success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyInternal() {
        Object object = this.mLock;
        synchronized (object) {
            this.mSealed = true;
            this.mDestroyed = true;
            for (RevocableFileDescriptor fd : this.mFds) {
                fd.revoke();
            }
            for (FileBridge bridge : this.mBridges) {
                bridge.forceClose();
            }
        }
        if (this.stageDir != null) {
            try {
                this.mPm.mInstaller.rmPackageDir(this.stageDir.getAbsolutePath());
            }
            catch (Installer.InstallerException installerException) {
                // empty catch block
            }
        }
        if (this.stageCid != null) {
            PackageHelper.destroySdDir(this.stageCid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dump(IndentingPrintWriter pw) {
        Object object = this.mLock;
        synchronized (object) {
            this.dumpLocked(pw);
        }
    }

    private void dumpLocked(IndentingPrintWriter pw) {
        pw.println("Session " + this.sessionId + ":");
        pw.increaseIndent();
        pw.printPair(ATTR_USER_ID, this.userId);
        pw.printPair("mOriginalInstallerUid", this.mOriginalInstallerUid);
        pw.printPair("mInstallerPackageName", this.mInstallerPackageName);
        pw.printPair("mInstallerUid", this.mInstallerUid);
        pw.printPair(ATTR_CREATED_MILLIS, this.createdMillis);
        pw.printPair("stageDir", this.stageDir);
        pw.printPair("stageCid", this.stageCid);
        pw.println();
        this.params.dump(pw);
        pw.printPair("mClientProgress", Float.valueOf(this.mClientProgress));
        pw.printPair("mProgress", Float.valueOf(this.mProgress));
        pw.printPair("mSealed", this.mSealed);
        pw.printPair("mPermissionsManuallyAccepted", this.mPermissionsManuallyAccepted);
        pw.printPair("mRelinquished", this.mRelinquished);
        pw.printPair("mDestroyed", this.mDestroyed);
        pw.printPair("mFds", this.mFds.size());
        pw.printPair("mBridges", this.mBridges.size());
        pw.printPair("mFinalStatus", this.mFinalStatus);
        pw.printPair("mFinalMessage", this.mFinalMessage);
        pw.println();
        pw.decreaseIndent();
    }

    private static void writeGrantedRuntimePermissionsLocked(XmlSerializer out, String[] grantedRuntimePermissions) throws IOException {
        if (grantedRuntimePermissions != null) {
            for (String permission2 : grantedRuntimePermissions) {
                out.startTag(null, TAG_GRANTED_RUNTIME_PERMISSION);
                XmlUtils.writeStringAttribute(out, ATTR_NAME, permission2);
                out.endTag(null, TAG_GRANTED_RUNTIME_PERMISSION);
            }
        }
    }

    private static File buildAppIconFile(int sessionId, File sessionsDir) {
        return new File(sessionsDir, "app_icon." + sessionId + ".png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(XmlSerializer out, File sessionsDir) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            block11: {
                File appIconFile;
                block10: {
                    if (this.mDestroyed) {
                        return;
                    }
                    out.startTag(null, TAG_SESSION);
                    XmlUtils.writeIntAttribute(out, ATTR_SESSION_ID, this.sessionId);
                    XmlUtils.writeIntAttribute(out, ATTR_USER_ID, this.userId);
                    XmlUtils.writeStringAttribute(out, ATTR_INSTALLER_PACKAGE_NAME, this.mInstallerPackageName);
                    XmlUtils.writeIntAttribute(out, ATTR_INSTALLER_UID, this.mInstallerUid);
                    XmlUtils.writeLongAttribute(out, ATTR_CREATED_MILLIS, this.createdMillis);
                    if (this.stageDir != null) {
                        XmlUtils.writeStringAttribute(out, ATTR_SESSION_STAGE_DIR, this.stageDir.getAbsolutePath());
                    }
                    if (this.stageCid != null) {
                        XmlUtils.writeStringAttribute(out, ATTR_SESSION_STAGE_CID, this.stageCid);
                    }
                    XmlUtils.writeBooleanAttribute(out, ATTR_PREPARED, this.isPrepared());
                    XmlUtils.writeBooleanAttribute(out, ATTR_SEALED, this.isSealed());
                    XmlUtils.writeIntAttribute(out, ATTR_MODE, this.params.mode);
                    XmlUtils.writeIntAttribute(out, ATTR_INSTALL_FLAGS, this.params.installFlags);
                    XmlUtils.writeIntAttribute(out, ATTR_INSTALL_LOCATION, this.params.installLocation);
                    XmlUtils.writeLongAttribute(out, ATTR_SIZE_BYTES, this.params.sizeBytes);
                    XmlUtils.writeStringAttribute(out, ATTR_APP_PACKAGE_NAME, this.params.appPackageName);
                    XmlUtils.writeStringAttribute(out, ATTR_APP_LABEL, this.params.appLabel);
                    XmlUtils.writeUriAttribute(out, ATTR_ORIGINATING_URI, this.params.originatingUri);
                    XmlUtils.writeIntAttribute(out, ATTR_ORIGINATING_UID, this.params.originatingUid);
                    XmlUtils.writeUriAttribute(out, ATTR_REFERRER_URI, this.params.referrerUri);
                    XmlUtils.writeStringAttribute(out, ATTR_ABI_OVERRIDE, this.params.abiOverride);
                    XmlUtils.writeStringAttribute(out, ATTR_VOLUME_UUID, this.params.volumeUuid);
                    XmlUtils.writeIntAttribute(out, ATTR_INSTALL_REASON, this.params.installReason);
                    appIconFile = PackageInstallerSession.buildAppIconFile(this.sessionId, sessionsDir);
                    if (this.params.appIcon != null || !appIconFile.exists()) break block10;
                    appIconFile.delete();
                    break block11;
                }
                if (this.params.appIcon == null || appIconFile.lastModified() == this.params.appIconLastModified) break block11;
                Slog.w(TAG, "Writing changed icon " + appIconFile);
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(appIconFile);
                    this.params.appIcon.compress(Bitmap.CompressFormat.PNG, 90, os);
                }
                catch (IOException e) {
                    try {
                        Slog.w(TAG, "Failed to write icon " + appIconFile + ": " + e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IoUtils.closeQuietly(os);
                        throw throwable;
                    }
                    IoUtils.closeQuietly(os);
                }
                IoUtils.closeQuietly(os);
                this.params.appIconLastModified = appIconFile.lastModified();
            }
            PackageInstallerSession.writeGrantedRuntimePermissionsLocked(out, this.params.grantedRuntimePermissions);
        }
        out.endTag(null, TAG_SESSION);
    }

    private static String[] readGrantedRuntimePermissions(XmlPullParser in) throws IOException, XmlPullParserException {
        int type;
        ArrayList<String> permissions = null;
        int outerDepth = in.getDepth();
        while ((type = in.next()) != 1 && (type != 3 || in.getDepth() > outerDepth)) {
            if (type == 3 || type == 4 || !TAG_GRANTED_RUNTIME_PERMISSION.equals(in.getName())) continue;
            String permission2 = XmlUtils.readStringAttribute(in, ATTR_NAME);
            if (permissions == null) {
                permissions = new ArrayList<String>();
            }
            permissions.add(permission2);
        }
        if (permissions == null) {
            return null;
        }
        String[] permissionsArray = new String[permissions.size()];
        permissions.toArray(permissionsArray);
        return permissionsArray;
    }

    public static PackageInstallerSession readFromXml(XmlPullParser in, PackageInstallerService.InternalCallback callback, Context context, PackageManagerService pm, Looper installerThread, File sessionsDir) throws IOException, XmlPullParserException {
        int sessionId = XmlUtils.readIntAttribute(in, ATTR_SESSION_ID);
        int userId = XmlUtils.readIntAttribute(in, ATTR_USER_ID);
        String installerPackageName = XmlUtils.readStringAttribute(in, ATTR_INSTALLER_PACKAGE_NAME);
        int installerUid = XmlUtils.readIntAttribute(in, ATTR_INSTALLER_UID, pm.getPackageUid(installerPackageName, 8192, userId));
        long createdMillis = XmlUtils.readLongAttribute(in, ATTR_CREATED_MILLIS);
        String stageDirRaw = XmlUtils.readStringAttribute(in, ATTR_SESSION_STAGE_DIR);
        File stageDir = stageDirRaw != null ? new File(stageDirRaw) : null;
        String stageCid = XmlUtils.readStringAttribute(in, ATTR_SESSION_STAGE_CID);
        boolean prepared = XmlUtils.readBooleanAttribute(in, ATTR_PREPARED, true);
        boolean sealed = XmlUtils.readBooleanAttribute(in, ATTR_SEALED);
        PackageInstaller.SessionParams params = new PackageInstaller.SessionParams(-1);
        params.mode = XmlUtils.readIntAttribute(in, ATTR_MODE);
        params.installFlags = XmlUtils.readIntAttribute(in, ATTR_INSTALL_FLAGS);
        params.installLocation = XmlUtils.readIntAttribute(in, ATTR_INSTALL_LOCATION);
        params.sizeBytes = XmlUtils.readLongAttribute(in, ATTR_SIZE_BYTES);
        params.appPackageName = XmlUtils.readStringAttribute(in, ATTR_APP_PACKAGE_NAME);
        params.appIcon = XmlUtils.readBitmapAttribute(in, ATTR_APP_ICON);
        params.appLabel = XmlUtils.readStringAttribute(in, ATTR_APP_LABEL);
        params.originatingUri = XmlUtils.readUriAttribute(in, ATTR_ORIGINATING_URI);
        params.originatingUid = XmlUtils.readIntAttribute(in, ATTR_ORIGINATING_UID, -1);
        params.referrerUri = XmlUtils.readUriAttribute(in, ATTR_REFERRER_URI);
        params.abiOverride = XmlUtils.readStringAttribute(in, ATTR_ABI_OVERRIDE);
        params.volumeUuid = XmlUtils.readStringAttribute(in, ATTR_VOLUME_UUID);
        params.grantedRuntimePermissions = PackageInstallerSession.readGrantedRuntimePermissions(in);
        params.installReason = XmlUtils.readIntAttribute(in, ATTR_INSTALL_REASON);
        File appIconFile = PackageInstallerSession.buildAppIconFile(sessionId, sessionsDir);
        if (appIconFile.exists()) {
            params.appIcon = BitmapFactory.decodeFile(appIconFile.getAbsolutePath());
            params.appIconLastModified = appIconFile.lastModified();
        }
        return new PackageInstallerSession(callback, context, pm, installerThread, sessionId, userId, installerPackageName, installerUid, params, createdMillis, stageDir, stageCid, prepared, sealed);
    }
}

