/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.policy;

import android.content.Context;
import android.os.Handler;
import android.view.WindowManagerPolicy;
import com.android.server.LocalServices;
import com.android.server.policy.LegacyGlobalActions;
import com.android.server.statusbar.StatusBarManagerInternal;

class GlobalActions
implements StatusBarManagerInternal.GlobalActionsListener {
    private static final String TAG = "GlobalActions";
    private static final boolean DEBUG = false;
    private final Context mContext;
    private final StatusBarManagerInternal mStatusBarInternal;
    private final Handler mHandler;
    private final WindowManagerPolicy.WindowManagerFuncs mWindowManagerFuncs;
    private LegacyGlobalActions mLegacyGlobalActions;
    private boolean mKeyguardShowing;
    private boolean mDeviceProvisioned;
    private boolean mStatusBarConnected;
    private boolean mShowing;
    private final Runnable mShowTimeout = new Runnable(){

        @Override
        public void run() {
            GlobalActions.this.ensureLegacyCreated();
            GlobalActions.this.mLegacyGlobalActions.showDialog(GlobalActions.this.mKeyguardShowing, GlobalActions.this.mDeviceProvisioned);
        }
    };

    public GlobalActions(Context context, WindowManagerPolicy.WindowManagerFuncs windowManagerFuncs) {
        this.mContext = context;
        this.mHandler = new Handler();
        this.mWindowManagerFuncs = windowManagerFuncs;
        this.mStatusBarInternal = LocalServices.getService(StatusBarManagerInternal.class);
        if (this.mStatusBarInternal != null) {
            this.mStatusBarInternal.setGlobalActionsListener(this);
        }
    }

    private void ensureLegacyCreated() {
        if (this.mLegacyGlobalActions != null) {
            return;
        }
        this.mLegacyGlobalActions = new LegacyGlobalActions(this.mContext, this.mWindowManagerFuncs, this::onGlobalActionsDismissed);
    }

    public void showDialog(boolean keyguardShowing, boolean deviceProvisioned) {
        this.mKeyguardShowing = keyguardShowing;
        this.mDeviceProvisioned = deviceProvisioned;
        this.mShowing = true;
        if (this.mStatusBarConnected) {
            this.mStatusBarInternal.showGlobalActions();
            this.mHandler.postDelayed(this.mShowTimeout, 5000L);
        } else {
            this.ensureLegacyCreated();
            this.mLegacyGlobalActions.showDialog(this.mKeyguardShowing, this.mDeviceProvisioned);
        }
    }

    @Override
    public void onGlobalActionsShown() {
        this.mHandler.removeCallbacks(this.mShowTimeout);
    }

    @Override
    public void onGlobalActionsDismissed() {
        this.mShowing = false;
    }

    @Override
    public void onStatusBarConnectedChanged(boolean connected) {
        this.mStatusBarConnected = connected;
        if (this.mShowing && !this.mStatusBarConnected) {
            this.ensureLegacyCreated();
            this.mLegacyGlobalActions.showDialog(this.mKeyguardShowing, this.mDeviceProvisioned);
        }
    }
}

