/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.print;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.print.IPrintDocumentAdapter;
import android.print.IPrintJobStateChangeListener;
import android.print.IPrintServicesChangeListener;
import android.print.IPrinterDiscoveryObserver;
import android.print.PrintAttributes;
import android.print.PrintJobId;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.print.PrinterInfo;
import android.printservice.PrintServiceInfo;
import android.printservice.recommendation.IRecommendationsChangeListener;
import android.printservice.recommendation.RecommendationInfo;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.os.BackgroundThread;
import com.android.internal.os.SomeArgs;
import com.android.server.print.RemotePrintService;
import com.android.server.print.RemotePrintServiceRecommendationService;
import com.android.server.print.RemotePrintSpooler;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class UserState
implements RemotePrintSpooler.PrintSpoolerCallbacks,
RemotePrintService.PrintServiceCallbacks,
RemotePrintServiceRecommendationService.RemotePrintServiceRecommendationServiceCallbacks {
    private static final String LOG_TAG = "UserState";
    private static final boolean DEBUG = false;
    private static final char COMPONENT_NAME_SEPARATOR = ':';
    private static final int SERVICE_RESTART_DELAY_MILLIS = 500;
    private final TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private final Intent mQueryIntent = new Intent("android.printservice.PrintService");
    private final ArrayMap<ComponentName, RemotePrintService> mActiveServices = new ArrayMap();
    private final List<PrintServiceInfo> mInstalledServices = new ArrayList<PrintServiceInfo>();
    private final Set<ComponentName> mDisabledServices = new ArraySet<ComponentName>();
    private final PrintJobForAppCache mPrintJobForAppCache = new PrintJobForAppCache();
    private final Object mLock;
    private final Context mContext;
    private final int mUserId;
    private final RemotePrintSpooler mSpooler;
    private final Handler mHandler;
    private PrinterDiscoverySessionMediator mPrinterDiscoverySession;
    private List<PrintJobStateChangeListenerRecord> mPrintJobStateChangeListenerRecords;
    private List<ListenerRecord<IPrintServicesChangeListener>> mPrintServicesChangeListenerRecords;
    private List<ListenerRecord<IRecommendationsChangeListener>> mPrintServiceRecommendationsChangeListenerRecords;
    private boolean mDestroyed;
    private List<RecommendationInfo> mPrintServiceRecommendations;
    private RemotePrintServiceRecommendationService mPrintServiceRecommendationsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserState(Context context, int userId, Object lock, boolean lowPriority) {
        this.mContext = context;
        this.mUserId = userId;
        this.mLock = lock;
        this.mSpooler = new RemotePrintSpooler(context, userId, lowPriority, this);
        this.mHandler = new UserStateHandler(context.getMainLooper());
        Object object = this.mLock;
        synchronized (object) {
            this.readInstalledPrintServicesLocked();
            this.upgradePersistentStateIfNeeded();
            this.readDisabledPrintServicesLocked();
        }
        this.prunePrintServices();
        object = this.mLock;
        synchronized (object) {
            this.onConfigurationChangedLocked();
        }
    }

    public void increasePriority() {
        this.mSpooler.increasePriority();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPrintJobQueued(PrintJobInfo printJob) {
        RemotePrintService service;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            ComponentName printServiceName = printJob.getPrinterId().getServiceName();
            service = this.mActiveServices.get(printServiceName);
        }
        if (service != null) {
            service.onPrintJobQueued(printJob);
        } else {
            this.mSpooler.setPrintJobState(printJob.getId(), 6, this.mContext.getString(17040646));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAllPrintJobsForServiceHandled(ComponentName printService) {
        RemotePrintService service;
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            service = this.mActiveServices.get(printService);
        }
        if (service != null) {
            service.onAllPrintJobsHandled();
        }
    }

    public void removeObsoletePrintJobs() {
        this.mSpooler.removeObsoletePrintJobs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle print(String printJobName, IPrintDocumentAdapter adapter, PrintAttributes attributes, String packageName, int appId) {
        final PrintJobInfo printJob = new PrintJobInfo();
        printJob.setId(new PrintJobId());
        printJob.setAppId(appId);
        printJob.setLabel(printJobName);
        printJob.setAttributes(attributes);
        printJob.setState(1);
        printJob.setCopies(1);
        printJob.setCreationTime(System.currentTimeMillis());
        if (!this.mPrintJobForAppCache.onPrintJobCreated(adapter.asBinder(), appId, printJob)) {
            return null;
        }
        new AsyncTask<Void, Void, Void>(){

            protected Void doInBackground(Void ... params) {
                UserState.this.mSpooler.createPrintJob(printJob);
                return null;
            }
        }.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, null);
        long identity = Binder.clearCallingIdentity();
        try {
            Intent intent = new Intent("android.print.PRINT_DIALOG");
            intent.setData(Uri.fromParts("printjob", printJob.getId().flattenToString(), null));
            intent.putExtra("android.print.intent.extra.EXTRA_PRINT_DOCUMENT_ADAPTER", adapter.asBinder());
            intent.putExtra("android.print.intent.extra.EXTRA_PRINT_JOB", printJob);
            intent.putExtra("android.content.extra.PACKAGE_NAME", packageName);
            IntentSender intentSender = PendingIntent.getActivityAsUser(this.mContext, 0, intent, 0x54000000, null, new UserHandle(this.mUserId)).getIntentSender();
            Bundle result = new Bundle();
            result.putParcelable("android.print.intent.extra.EXTRA_PRINT_JOB", printJob);
            result.putParcelable("android.print.intent.extra.EXTRA_PRINT_DIALOG_INTENT", intentSender);
            Bundle bundle = result;
            return bundle;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public List<PrintJobInfo> getPrintJobInfos(int appId) {
        List<PrintJobInfo> cachedPrintJobs = this.mPrintJobForAppCache.getPrintJobs(appId);
        ArrayMap<PrintJobId, PrintJobInfo> result = new ArrayMap<PrintJobId, PrintJobInfo>();
        int cachedPrintJobCount = cachedPrintJobs.size();
        for (int i = 0; i < cachedPrintJobCount; ++i) {
            PrintJobInfo cachedPrintJob = cachedPrintJobs.get(i);
            result.put(cachedPrintJob.getId(), cachedPrintJob);
            cachedPrintJob.setTag(null);
            cachedPrintJob.setAdvancedOptions(null);
        }
        List<PrintJobInfo> printJobs = this.mSpooler.getPrintJobInfos(null, -1, appId);
        if (printJobs != null) {
            int printJobCount = printJobs.size();
            for (int i = 0; i < printJobCount; ++i) {
                PrintJobInfo printJob = printJobs.get(i);
                result.put(printJob.getId(), printJob);
                printJob.setTag(null);
                printJob.setAdvancedOptions(null);
            }
        }
        return new ArrayList<PrintJobInfo>(result.values());
    }

    public PrintJobInfo getPrintJobInfo(PrintJobId printJobId, int appId) {
        PrintJobInfo printJob = this.mPrintJobForAppCache.getPrintJob(printJobId, appId);
        if (printJob == null) {
            printJob = this.mSpooler.getPrintJobInfo(printJobId, appId);
        }
        if (printJob != null) {
            printJob.setTag(null);
            printJob.setAdvancedOptions(null);
        }
        return printJob;
    }

    public Icon getCustomPrinterIcon(PrinterId printerId) {
        RemotePrintService service;
        Icon icon = this.mSpooler.getCustomPrinterIcon(printerId);
        if (icon == null && (service = this.mActiveServices.get(printerId.getServiceName())) != null) {
            service.requestCustomPrinterIcon(printerId);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelPrintJob(PrintJobId printJobId, int appId) {
        PrintJobInfo printJobInfo = this.mSpooler.getPrintJobInfo(printJobId, appId);
        if (printJobInfo == null) {
            return;
        }
        this.mSpooler.setPrintJobCancelling(printJobId, true);
        if (printJobInfo.getState() != 6) {
            PrinterId printerId = printJobInfo.getPrinterId();
            if (printerId != null) {
                ComponentName printServiceName = printerId.getServiceName();
                RemotePrintService printService = null;
                Object object = this.mLock;
                synchronized (object) {
                    printService = this.mActiveServices.get(printServiceName);
                }
                if (printService == null) {
                    return;
                }
                printService.onRequestCancelPrintJob(printJobInfo);
            }
        } else {
            this.mSpooler.setPrintJobState(printJobId, 7, null);
        }
    }

    public void restartPrintJob(PrintJobId printJobId, int appId) {
        PrintJobInfo printJobInfo = this.getPrintJobInfo(printJobId, appId);
        if (printJobInfo == null || printJobInfo.getState() != 6) {
            return;
        }
        this.mSpooler.setPrintJobState(printJobId, 2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PrintServiceInfo> getPrintServices(int selectionFlags) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<PrintServiceInfo> selectedServices = null;
            int installedServiceCount = this.mInstalledServices.size();
            for (int i = 0; i < installedServiceCount; ++i) {
                PrintServiceInfo installedService = this.mInstalledServices.get(i);
                ComponentName componentName = new ComponentName(installedService.getResolveInfo().serviceInfo.packageName, installedService.getResolveInfo().serviceInfo.name);
                installedService.setIsEnabled(this.mActiveServices.containsKey(componentName));
                if (!installedService.isEnabled() ? (selectionFlags & 2) == 0 : (selectionFlags & 1) == 0) continue;
                if (selectedServices == null) {
                    selectedServices = new ArrayList<PrintServiceInfo>();
                }
                selectedServices.add(installedService);
            }
            return selectedServices;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrintServiceEnabled(ComponentName serviceName, boolean isEnabled) {
        Object object = this.mLock;
        synchronized (object) {
            boolean isChanged = false;
            if (isEnabled) {
                isChanged = this.mDisabledServices.remove(serviceName);
            } else {
                int numServices = this.mInstalledServices.size();
                for (int i = 0; i < numServices; ++i) {
                    PrintServiceInfo service = this.mInstalledServices.get(i);
                    if (!service.getComponentName().equals(serviceName)) continue;
                    this.mDisabledServices.add(serviceName);
                    isChanged = true;
                    break;
                }
            }
            if (isChanged) {
                this.writeDisabledPrintServicesLocked(this.mDisabledServices);
                MetricsLogger.action(this.mContext, 511, isEnabled ? 0 : 1);
                this.onConfigurationChangedLocked();
            }
        }
    }

    public List<RecommendationInfo> getPrintServiceRecommendations() {
        return this.mPrintServiceRecommendations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPrinterDiscoverySession(IPrinterDiscoveryObserver observer) {
        this.mSpooler.clearCustomPrinterIconCache();
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrinterDiscoverySession == null) {
                this.mPrinterDiscoverySession = new PrinterDiscoverySessionMediator(this.mContext){

                    @Override
                    public void onDestroyed() {
                        UserState.this.mPrinterDiscoverySession = null;
                    }
                };
                this.mPrinterDiscoverySession.addObserverLocked(observer);
            } else {
                this.mPrinterDiscoverySession.addObserverLocked(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPrinterDiscoverySession(IPrinterDiscoveryObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.removeObserverLocked(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPrinterDiscovery(IPrinterDiscoveryObserver observer, List<PrinterId> printerIds) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.startPrinterDiscoveryLocked(observer, printerIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPrinterDiscovery(IPrinterDiscoveryObserver observer) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.stopPrinterDiscoveryLocked(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validatePrinters(List<PrinterId> printerIds) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mActiveServices.isEmpty()) {
                return;
            }
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.validatePrintersLocked(printerIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPrinterStateTracking(PrinterId printerId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mActiveServices.isEmpty()) {
                return;
            }
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.startPrinterStateTrackingLocked(printerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPrinterStateTracking(PrinterId printerId) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mActiveServices.isEmpty()) {
                return;
            }
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.stopPrinterStateTrackingLocked(printerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintJobStateChangeListener(IPrintJobStateChangeListener listener, int appId) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrintJobStateChangeListenerRecords == null) {
                this.mPrintJobStateChangeListenerRecords = new ArrayList<PrintJobStateChangeListenerRecord>();
            }
            this.mPrintJobStateChangeListenerRecords.add(new PrintJobStateChangeListenerRecord(listener, appId){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBinderDied() {
                    Object object = UserState.this.mLock;
                    synchronized (object) {
                        if (UserState.this.mPrintJobStateChangeListenerRecords != null) {
                            UserState.this.mPrintJobStateChangeListenerRecords.remove(this);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintJobStateChangeListener(IPrintJobStateChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrintJobStateChangeListenerRecords == null) {
                return;
            }
            int recordCount = this.mPrintJobStateChangeListenerRecords.size();
            for (int i = 0; i < recordCount; ++i) {
                PrintJobStateChangeListenerRecord record = this.mPrintJobStateChangeListenerRecords.get(i);
                if (!record.listener.asBinder().equals(listener.asBinder())) continue;
                this.mPrintJobStateChangeListenerRecords.remove(i);
                break;
            }
            if (this.mPrintJobStateChangeListenerRecords.isEmpty()) {
                this.mPrintJobStateChangeListenerRecords = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintServicesChangeListener(IPrintServicesChangeListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrintServicesChangeListenerRecords == null) {
                this.mPrintServicesChangeListenerRecords = new ArrayList<ListenerRecord<IPrintServicesChangeListener>>();
            }
            this.mPrintServicesChangeListenerRecords.add(new ListenerRecord<IPrintServicesChangeListener>(listener){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBinderDied() {
                    Object object = UserState.this.mLock;
                    synchronized (object) {
                        if (UserState.this.mPrintServicesChangeListenerRecords != null) {
                            UserState.this.mPrintServicesChangeListenerRecords.remove(this);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintServicesChangeListener(IPrintServicesChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrintServicesChangeListenerRecords == null) {
                return;
            }
            int recordCount = this.mPrintServicesChangeListenerRecords.size();
            for (int i = 0; i < recordCount; ++i) {
                ListenerRecord<IPrintServicesChangeListener> record = this.mPrintServicesChangeListenerRecords.get(i);
                if (!((IPrintServicesChangeListener)record.listener).asBinder().equals(listener.asBinder())) continue;
                this.mPrintServicesChangeListenerRecords.remove(i);
                break;
            }
            if (this.mPrintServicesChangeListenerRecords.isEmpty()) {
                this.mPrintServicesChangeListenerRecords = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener) throws RemoteException {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrintServiceRecommendationsChangeListenerRecords == null) {
                this.mPrintServiceRecommendationsChangeListenerRecords = new ArrayList<ListenerRecord<IRecommendationsChangeListener>>();
                this.mPrintServiceRecommendationsService = new RemotePrintServiceRecommendationService(this.mContext, UserHandle.getUserHandleForUid(this.mUserId), this);
            }
            this.mPrintServiceRecommendationsChangeListenerRecords.add(new ListenerRecord<IRecommendationsChangeListener>(listener){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onBinderDied() {
                    Object object = UserState.this.mLock;
                    synchronized (object) {
                        if (UserState.this.mPrintServiceRecommendationsChangeListenerRecords != null) {
                            UserState.this.mPrintServiceRecommendationsChangeListenerRecords.remove(this);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePrintServiceRecommendationsChangeListener(IRecommendationsChangeListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrintServiceRecommendationsChangeListenerRecords == null) {
                return;
            }
            int recordCount = this.mPrintServiceRecommendationsChangeListenerRecords.size();
            for (int i = 0; i < recordCount; ++i) {
                ListenerRecord<IRecommendationsChangeListener> record = this.mPrintServiceRecommendationsChangeListenerRecords.get(i);
                if (!((IRecommendationsChangeListener)record.listener).asBinder().equals(listener.asBinder())) continue;
                this.mPrintServiceRecommendationsChangeListenerRecords.remove(i);
                break;
            }
            if (this.mPrintServiceRecommendationsChangeListenerRecords.isEmpty()) {
                this.mPrintServiceRecommendationsChangeListenerRecords = null;
                this.mPrintServiceRecommendations = null;
                this.mPrintServiceRecommendationsService.close();
                this.mPrintServiceRecommendationsService = null;
            }
        }
    }

    @Override
    public void onPrintJobStateChanged(PrintJobInfo printJob) {
        this.mPrintJobForAppCache.onPrintJobStateChanged(printJob);
        this.mHandler.obtainMessage(1, printJob.getAppId(), 0, printJob.getId()).sendToTarget();
    }

    public void onPrintServicesChanged() {
        this.mHandler.obtainMessage(2).sendToTarget();
    }

    @Override
    public void onPrintServiceRecommendationsUpdated(List<RecommendationInfo> recommendations) {
        this.mHandler.obtainMessage(3, 0, 0, recommendations).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPrintersAdded(List<PrinterInfo> printers) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mActiveServices.isEmpty()) {
                return;
            }
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.onPrintersAddedLocked(printers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPrintersRemoved(List<PrinterId> printerIds) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mActiveServices.isEmpty()) {
                return;
            }
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.onPrintersRemovedLocked(printerIds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCustomPrinterIconLoaded(PrinterId printerId, Icon icon) {
        this.mSpooler.onCustomPrinterIconLoaded(printerId, icon);
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.onCustomPrinterIconLoadedLocked(printerId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onServiceDied(RemotePrintService service) {
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfDestroyedLocked();
            if (this.mActiveServices.isEmpty()) {
                return;
            }
            this.failActivePrintJobsForService(service.getComponentName());
            service.onAllPrintJobsHandled();
            this.mActiveServices.remove(service.getComponentName());
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(4), 500L);
            if (this.mPrinterDiscoverySession == null) {
                return;
            }
            this.mPrinterDiscoverySession.onServiceDiedLocked(service);
        }
    }

    public void updateIfNeededLocked() {
        this.throwIfDestroyedLocked();
        this.readConfigurationLocked();
        this.onConfigurationChangedLocked();
    }

    public void destroyLocked() {
        this.throwIfDestroyedLocked();
        this.mSpooler.destroy();
        for (RemotePrintService service : this.mActiveServices.values()) {
            service.destroy();
        }
        this.mActiveServices.clear();
        this.mInstalledServices.clear();
        this.mDisabledServices.clear();
        if (this.mPrinterDiscoverySession != null) {
            this.mPrinterDiscoverySession.destroyLocked();
            this.mPrinterDiscoverySession = null;
        }
        this.mDestroyed = true;
    }

    public void dump(FileDescriptor fd, PrintWriter pw, String prefix) {
        pw.append(prefix).append("user state ").append(String.valueOf(this.mUserId)).append(":");
        pw.println();
        String tab = "  ";
        pw.append(prefix).append(tab).append("installed services:").println();
        int installedServiceCount = this.mInstalledServices.size();
        for (int i = 0; i < installedServiceCount; ++i) {
            PrintServiceInfo installedService = this.mInstalledServices.get(i);
            String installedServicePrefix = prefix + tab + tab;
            pw.append(installedServicePrefix).append("service:").println();
            ResolveInfo resolveInfo = installedService.getResolveInfo();
            ComponentName componentName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
            pw.append(installedServicePrefix).append(tab).append("componentName=").append(componentName.flattenToString()).println();
            pw.append(installedServicePrefix).append(tab).append("settingsActivity=").append(installedService.getSettingsActivityName()).println();
            pw.append(installedServicePrefix).append(tab).append("addPrintersActivity=").append(installedService.getAddPrintersActivityName()).println();
            pw.append(installedServicePrefix).append(tab).append("avancedOptionsActivity=").append(installedService.getAdvancedOptionsActivityName()).println();
        }
        pw.append(prefix).append(tab).append("disabled services:").println();
        for (ComponentName disabledService : this.mDisabledServices) {
            String disabledServicePrefix = prefix + tab + tab;
            pw.append(disabledServicePrefix).append("service:").println();
            pw.append(disabledServicePrefix).append(tab).append("componentName=").append(disabledService.flattenToString());
            pw.println();
        }
        pw.append(prefix).append(tab).append("active services:").println();
        int activeServiceCount = this.mActiveServices.size();
        for (int i = 0; i < activeServiceCount; ++i) {
            RemotePrintService activeService = this.mActiveServices.valueAt(i);
            activeService.dump(pw, prefix + tab + tab);
            pw.println();
        }
        pw.append(prefix).append(tab).append("cached print jobs:").println();
        this.mPrintJobForAppCache.dump(pw, prefix + tab + tab);
        pw.append(prefix).append(tab).append("discovery mediator:").println();
        if (this.mPrinterDiscoverySession != null) {
            this.mPrinterDiscoverySession.dump(pw, prefix + tab + tab);
        }
        pw.append(prefix).append(tab).append("print spooler:").println();
        this.mSpooler.dump(fd, pw, prefix + tab + tab);
        pw.println();
    }

    private void readConfigurationLocked() {
        this.readInstalledPrintServicesLocked();
        this.readDisabledPrintServicesLocked();
    }

    private void readInstalledPrintServicesLocked() {
        HashSet<PrintServiceInfo> tempPrintServices = new HashSet<PrintServiceInfo>();
        List<ResolveInfo> installedServices = this.mContext.getPackageManager().queryIntentServicesAsUser(this.mQueryIntent, 268435588, this.mUserId);
        int installedCount = installedServices.size();
        int count = installedCount;
        for (int i = 0; i < count; ++i) {
            ResolveInfo installedService = installedServices.get(i);
            if (!"android.permission.BIND_PRINT_SERVICE".equals(installedService.serviceInfo.permission)) {
                ComponentName serviceName = new ComponentName(installedService.serviceInfo.packageName, installedService.serviceInfo.name);
                Slog.w(LOG_TAG, "Skipping print service " + serviceName.flattenToShortString() + " since it does not require permission " + "android.permission.BIND_PRINT_SERVICE");
                continue;
            }
            tempPrintServices.add(PrintServiceInfo.create(this.mContext, installedService));
        }
        this.mInstalledServices.clear();
        this.mInstalledServices.addAll(tempPrintServices);
    }

    private void upgradePersistentStateIfNeeded() {
        String enabledSettingValue = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "enabled_print_services", this.mUserId);
        if (enabledSettingValue != null) {
            HashSet<ComponentName> enabledServiceNameSet = new HashSet<ComponentName>();
            this.readPrintServicesFromSettingLocked("enabled_print_services", enabledServiceNameSet);
            ArraySet<ComponentName> disabledServices = new ArraySet<ComponentName>();
            int numInstalledServices = this.mInstalledServices.size();
            for (int i = 0; i < numInstalledServices; ++i) {
                ComponentName serviceName = this.mInstalledServices.get(i).getComponentName();
                if (enabledServiceNameSet.contains(serviceName)) continue;
                disabledServices.add(serviceName);
            }
            this.writeDisabledPrintServicesLocked(disabledServices);
            Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "enabled_print_services", null, this.mUserId);
        }
    }

    private void readDisabledPrintServicesLocked() {
        HashSet<ComponentName> tempDisabledServiceNameSet = new HashSet<ComponentName>();
        this.readPrintServicesFromSettingLocked("disabled_print_services", tempDisabledServiceNameSet);
        if (!tempDisabledServiceNameSet.equals(this.mDisabledServices)) {
            this.mDisabledServices.clear();
            this.mDisabledServices.addAll(tempDisabledServiceNameSet);
        }
    }

    private void readPrintServicesFromSettingLocked(String setting, Set<ComponentName> outServiceNames) {
        String settingValue = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), setting, this.mUserId);
        if (!TextUtils.isEmpty(settingValue)) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(settingValue);
            while (splitter.hasNext()) {
                ComponentName componentName;
                Object string2 = splitter.next();
                if (TextUtils.isEmpty((CharSequence)string2) || (componentName = ComponentName.unflattenFromString((String)string2)) == null) continue;
                outServiceNames.add(componentName);
            }
        }
    }

    private void writeDisabledPrintServicesLocked(Set<ComponentName> disabledServices) {
        StringBuilder builder = new StringBuilder();
        for (ComponentName componentName : disabledServices) {
            if (builder.length() > 0) {
                builder.append(':');
            }
            builder.append(componentName.flattenToShortString());
        }
        Settings.Secure.putStringForUser(this.mContext.getContentResolver(), "disabled_print_services", builder.toString(), this.mUserId);
    }

    private ArrayList<ComponentName> getInstalledComponents() {
        ArrayList<ComponentName> installedComponents = new ArrayList<ComponentName>();
        int installedCount = this.mInstalledServices.size();
        for (int i = 0; i < installedCount; ++i) {
            ResolveInfo resolveInfo = this.mInstalledServices.get(i).getResolveInfo();
            ComponentName serviceName = new ComponentName(resolveInfo.serviceInfo.packageName, resolveInfo.serviceInfo.name);
            installedComponents.add(serviceName);
        }
        return installedComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prunePrintServices() {
        ArrayList<ComponentName> installedComponents;
        Object object = this.mLock;
        synchronized (object) {
            installedComponents = this.getInstalledComponents();
            boolean disabledServicesUninstalled = this.mDisabledServices.retainAll(installedComponents);
            if (disabledServicesUninstalled) {
                this.writeDisabledPrintServicesLocked(this.mDisabledServices);
            }
        }
        this.mSpooler.pruneApprovedPrintServices(installedComponents);
    }

    private void onConfigurationChangedLocked() {
        ArrayList<ComponentName> installedComponents = this.getInstalledComponents();
        int installedCount = installedComponents.size();
        for (int i = 0; i < installedCount; ++i) {
            RemotePrintService service;
            ComponentName serviceName = installedComponents.get(i);
            if (!this.mDisabledServices.contains(serviceName)) {
                if (this.mActiveServices.containsKey(serviceName)) continue;
                service = new RemotePrintService(this.mContext, serviceName, this.mUserId, this.mSpooler, this);
                this.addServiceLocked(service);
                continue;
            }
            service = this.mActiveServices.remove(serviceName);
            if (service == null) continue;
            this.removeServiceLocked(service);
        }
        Iterator<Map.Entry<ComponentName, RemotePrintService>> iterator = this.mActiveServices.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ComponentName, RemotePrintService> entry = iterator.next();
            ComponentName serviceName = entry.getKey();
            RemotePrintService service = entry.getValue();
            if (installedComponents.contains(serviceName)) continue;
            this.removeServiceLocked(service);
            iterator.remove();
        }
        this.onPrintServicesChanged();
    }

    private void addServiceLocked(RemotePrintService service) {
        this.mActiveServices.put(service.getComponentName(), service);
        if (this.mPrinterDiscoverySession != null) {
            this.mPrinterDiscoverySession.onServiceAddedLocked(service);
        }
    }

    private void removeServiceLocked(RemotePrintService service) {
        this.failActivePrintJobsForService(service.getComponentName());
        if (this.mPrinterDiscoverySession != null) {
            this.mPrinterDiscoverySession.onServiceRemovedLocked(service);
        } else {
            service.destroy();
        }
    }

    private void failActivePrintJobsForService(final ComponentName serviceName) {
        if (Looper.getMainLooper().isCurrentThread()) {
            BackgroundThread.getHandler().post(new Runnable(){

                @Override
                public void run() {
                    UserState.this.failScheduledPrintJobsForServiceInternal(serviceName);
                }
            });
        } else {
            this.failScheduledPrintJobsForServiceInternal(serviceName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failScheduledPrintJobsForServiceInternal(ComponentName serviceName) {
        List<PrintJobInfo> printJobs = this.mSpooler.getPrintJobInfos(serviceName, -4, -2);
        if (printJobs == null) {
            return;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            int printJobCount = printJobs.size();
            for (int i = 0; i < printJobCount; ++i) {
                PrintJobInfo printJob = printJobs.get(i);
                this.mSpooler.setPrintJobState(printJob.getId(), 6, this.mContext.getString(17040646));
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void throwIfDestroyedLocked() {
        if (this.mDestroyed) {
            throw new IllegalStateException("Cannot interact with a destroyed instance.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDispatchPrintJobStateChanged(PrintJobId printJobId, int appId) {
        ArrayList<PrintJobStateChangeListenerRecord> records;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPrintJobStateChangeListenerRecords == null) {
                return;
            }
            records = new ArrayList<PrintJobStateChangeListenerRecord>(this.mPrintJobStateChangeListenerRecords);
        }
        int recordCount = records.size();
        for (int i = 0; i < recordCount; ++i) {
            PrintJobStateChangeListenerRecord record = (PrintJobStateChangeListenerRecord)records.get(i);
            if (record.appId != -2 && record.appId != appId) continue;
            try {
                record.listener.onPrintJobStateChanged(printJobId);
                continue;
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error notifying for print job state change", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDispatchPrintServicesChanged() {
        ArrayList<ListenerRecord<IPrintServicesChangeListener>> records;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPrintServicesChangeListenerRecords == null) {
                return;
            }
            records = new ArrayList<ListenerRecord<IPrintServicesChangeListener>>(this.mPrintServicesChangeListenerRecords);
        }
        int recordCount = records.size();
        for (int i = 0; i < recordCount; ++i) {
            ListenerRecord record = (ListenerRecord)records.get(i);
            try {
                ((IPrintServicesChangeListener)record.listener).onPrintServicesChanged();
                continue;
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error notifying for print services change", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDispatchPrintServiceRecommendationsUpdated(List<RecommendationInfo> recommendations) {
        ArrayList<ListenerRecord<IRecommendationsChangeListener>> records;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPrintServiceRecommendationsChangeListenerRecords == null) {
                return;
            }
            records = new ArrayList<ListenerRecord<IRecommendationsChangeListener>>(this.mPrintServiceRecommendationsChangeListenerRecords);
            this.mPrintServiceRecommendations = recommendations;
        }
        int recordCount = records.size();
        for (int i = 0; i < recordCount; ++i) {
            ListenerRecord record = (ListenerRecord)records.get(i);
            try {
                ((IRecommendationsChangeListener)record.listener).onRecommendationsChanged();
                continue;
            }
            catch (RemoteException re) {
                Log.e(LOG_TAG, "Error notifying for print service recommendations change", re);
            }
        }
    }

    private final class PrintJobForAppCache {
        private final SparseArray<List<PrintJobInfo>> mPrintJobsForRunningApp = new SparseArray();

        private PrintJobForAppCache() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onPrintJobCreated(final IBinder creator, final int appId, PrintJobInfo printJob) {
            try {
                creator.linkToDeath(new IBinder.DeathRecipient(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void binderDied() {
                        creator.unlinkToDeath(this, 0);
                        Object object = UserState.this.mLock;
                        synchronized (object) {
                            PrintJobForAppCache.this.mPrintJobsForRunningApp.remove(appId);
                        }
                    }
                }, 0);
            }
            catch (RemoteException re) {
                return false;
            }
            Object object = UserState.this.mLock;
            synchronized (object) {
                List<PrintJobInfo> printJobsForApp = this.mPrintJobsForRunningApp.get(appId);
                if (printJobsForApp == null) {
                    printJobsForApp = new ArrayList<PrintJobInfo>();
                    this.mPrintJobsForRunningApp.put(appId, printJobsForApp);
                }
                printJobsForApp.add(printJob);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onPrintJobStateChanged(PrintJobInfo printJob) {
            Object object = UserState.this.mLock;
            synchronized (object) {
                List<PrintJobInfo> printJobsForApp = this.mPrintJobsForRunningApp.get(printJob.getAppId());
                if (printJobsForApp == null) {
                    return;
                }
                int printJobCount = printJobsForApp.size();
                for (int i = 0; i < printJobCount; ++i) {
                    PrintJobInfo oldPrintJob = printJobsForApp.get(i);
                    if (!oldPrintJob.getId().equals(printJob.getId())) continue;
                    printJobsForApp.set(i, printJob);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public PrintJobInfo getPrintJob(PrintJobId printJobId, int appId) {
            Object object = UserState.this.mLock;
            synchronized (object) {
                List<PrintJobInfo> printJobsForApp = this.mPrintJobsForRunningApp.get(appId);
                if (printJobsForApp == null) {
                    return null;
                }
                int printJobCount = printJobsForApp.size();
                for (int i = 0; i < printJobCount; ++i) {
                    PrintJobInfo printJob = printJobsForApp.get(i);
                    if (!printJob.getId().equals(printJobId)) continue;
                    return printJob;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<PrintJobInfo> getPrintJobs(int appId) {
            Object object = UserState.this.mLock;
            synchronized (object) {
                ArrayList<PrintJobInfo> printJobs = null;
                if (appId == -2) {
                    int bucketCount = this.mPrintJobsForRunningApp.size();
                    for (int i = 0; i < bucketCount; ++i) {
                        List<PrintJobInfo> bucket = this.mPrintJobsForRunningApp.valueAt(i);
                        if (printJobs == null) {
                            printJobs = new ArrayList();
                        }
                        printJobs.addAll(bucket);
                    }
                } else {
                    List<PrintJobInfo> bucket = this.mPrintJobsForRunningApp.get(appId);
                    if (bucket != null) {
                        if (printJobs == null) {
                            printJobs = new ArrayList<PrintJobInfo>();
                        }
                        printJobs.addAll(bucket);
                    }
                }
                if (printJobs != null) {
                    return printJobs;
                }
                return Collections.emptyList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dump(PrintWriter pw, String prefix) {
            Object object = UserState.this.mLock;
            synchronized (object) {
                String tab = "  ";
                int bucketCount = this.mPrintJobsForRunningApp.size();
                for (int i = 0; i < bucketCount; ++i) {
                    int appId = this.mPrintJobsForRunningApp.keyAt(i);
                    pw.append(prefix).append("appId=" + appId).append(':').println();
                    List<PrintJobInfo> bucket = this.mPrintJobsForRunningApp.valueAt(i);
                    int printJobCount = bucket.size();
                    for (int j = 0; j < printJobCount; ++j) {
                        PrintJobInfo printJob = bucket.get(j);
                        pw.append(prefix).append(tab).append(printJob.toString()).println();
                    }
                }
            }
        }
    }

    private class PrinterDiscoverySessionMediator {
        private final ArrayMap<PrinterId, PrinterInfo> mPrinters = new ArrayMap();
        private final RemoteCallbackList<IPrinterDiscoveryObserver> mDiscoveryObservers = new RemoteCallbackList<IPrinterDiscoveryObserver>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCallbackDied(IPrinterDiscoveryObserver observer) {
                Object object = UserState.this.mLock;
                synchronized (object) {
                    PrinterDiscoverySessionMediator.this.stopPrinterDiscoveryLocked(observer);
                    PrinterDiscoverySessionMediator.this.removeObserverLocked(observer);
                }
            }
        };
        private final List<IBinder> mStartedPrinterDiscoveryTokens = new ArrayList<IBinder>();
        private final List<PrinterId> mStateTrackedPrinters = new ArrayList<PrinterId>();
        private final Handler mSessionHandler;
        private boolean mIsDestroyed;

        public PrinterDiscoverySessionMediator(Context context) {
            this.mSessionHandler = new SessionHandler(context.getMainLooper());
            ArrayList services = new ArrayList(UserState.this.mActiveServices.values());
            this.mSessionHandler.obtainMessage(9, services).sendToTarget();
        }

        public void addObserverLocked(IPrinterDiscoveryObserver observer) {
            this.mDiscoveryObservers.register(observer);
            if (!this.mPrinters.isEmpty()) {
                ArrayList<PrinterInfo> printers = new ArrayList<PrinterInfo>(this.mPrinters.values());
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = observer;
                args.arg2 = printers;
                this.mSessionHandler.obtainMessage(1, args).sendToTarget();
            }
        }

        public void removeObserverLocked(IPrinterDiscoveryObserver observer) {
            this.mDiscoveryObservers.unregister(observer);
            if (this.mDiscoveryObservers.getRegisteredCallbackCount() == 0) {
                this.destroyLocked();
            }
        }

        public final void startPrinterDiscoveryLocked(IPrinterDiscoveryObserver observer, List<PrinterId> priorityList) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not starting dicovery - session destroyed");
                return;
            }
            boolean discoveryStarted = !this.mStartedPrinterDiscoveryTokens.isEmpty();
            this.mStartedPrinterDiscoveryTokens.add(observer.asBinder());
            if (discoveryStarted && priorityList != null && !priorityList.isEmpty()) {
                UserState.this.validatePrinters(priorityList);
                return;
            }
            if (this.mStartedPrinterDiscoveryTokens.size() > 1) {
                return;
            }
            ArrayList services = new ArrayList(UserState.this.mActiveServices.values());
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = services;
            args.arg2 = priorityList;
            this.mSessionHandler.obtainMessage(11, args).sendToTarget();
        }

        public final void stopPrinterDiscoveryLocked(IPrinterDiscoveryObserver observer) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not stopping dicovery - session destroyed");
                return;
            }
            if (!this.mStartedPrinterDiscoveryTokens.remove(observer.asBinder())) {
                return;
            }
            if (!this.mStartedPrinterDiscoveryTokens.isEmpty()) {
                return;
            }
            ArrayList services = new ArrayList(UserState.this.mActiveServices.values());
            this.mSessionHandler.obtainMessage(12, services).sendToTarget();
        }

        public void validatePrintersLocked(List<PrinterId> printerIds) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not validating pritners - session destroyed");
                return;
            }
            ArrayList<PrinterId> remainingList = new ArrayList<PrinterId>(printerIds);
            while (!remainingList.isEmpty()) {
                Iterator iterator = remainingList.iterator();
                ArrayList<PrinterId> updateList = new ArrayList<PrinterId>();
                ComponentName serviceName = null;
                while (iterator.hasNext()) {
                    PrinterId printerId = (PrinterId)iterator.next();
                    if (printerId == null) continue;
                    if (updateList.isEmpty()) {
                        updateList.add(printerId);
                        serviceName = printerId.getServiceName();
                        iterator.remove();
                        continue;
                    }
                    if (!printerId.getServiceName().equals(serviceName)) continue;
                    updateList.add(printerId);
                    iterator.remove();
                }
                RemotePrintService service = (RemotePrintService)UserState.this.mActiveServices.get(serviceName);
                if (service == null) continue;
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = service;
                args.arg2 = updateList;
                this.mSessionHandler.obtainMessage(13, args).sendToTarget();
            }
        }

        public final void startPrinterStateTrackingLocked(PrinterId printerId) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not starting printer state tracking - session destroyed");
                return;
            }
            if (this.mStartedPrinterDiscoveryTokens.isEmpty()) {
                return;
            }
            boolean containedPrinterId = this.mStateTrackedPrinters.contains(printerId);
            this.mStateTrackedPrinters.add(printerId);
            if (containedPrinterId) {
                return;
            }
            RemotePrintService service = (RemotePrintService)UserState.this.mActiveServices.get(printerId.getServiceName());
            if (service == null) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = service;
            args.arg2 = printerId;
            this.mSessionHandler.obtainMessage(14, args).sendToTarget();
        }

        public final void stopPrinterStateTrackingLocked(PrinterId printerId) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not stopping printer state tracking - session destroyed");
                return;
            }
            if (this.mStartedPrinterDiscoveryTokens.isEmpty()) {
                return;
            }
            if (!this.mStateTrackedPrinters.remove(printerId)) {
                return;
            }
            RemotePrintService service = (RemotePrintService)UserState.this.mActiveServices.get(printerId.getServiceName());
            if (service == null) {
                return;
            }
            SomeArgs args = SomeArgs.obtain();
            args.arg1 = service;
            args.arg2 = printerId;
            this.mSessionHandler.obtainMessage(15, args).sendToTarget();
        }

        public void onDestroyed() {
        }

        public void destroyLocked() {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not destroying - session destroyed");
                return;
            }
            this.mIsDestroyed = true;
            int printerCount = this.mStateTrackedPrinters.size();
            for (int i = 0; i < printerCount; ++i) {
                PrinterId printerId = this.mStateTrackedPrinters.get(i);
                UserState.this.stopPrinterStateTracking(printerId);
            }
            int observerCount = this.mStartedPrinterDiscoveryTokens.size();
            for (int i = 0; i < observerCount; ++i) {
                IBinder token = this.mStartedPrinterDiscoveryTokens.get(i);
                this.stopPrinterDiscoveryLocked(IPrinterDiscoveryObserver.Stub.asInterface(token));
            }
            ArrayList services = new ArrayList(UserState.this.mActiveServices.values());
            this.mSessionHandler.obtainMessage(10, services).sendToTarget();
        }

        public void onPrintersAddedLocked(List<PrinterInfo> printers) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not adding printers - session destroyed");
                return;
            }
            ArrayList<PrinterInfo> addedPrinters = null;
            int addedPrinterCount = printers.size();
            for (int i = 0; i < addedPrinterCount; ++i) {
                PrinterInfo printer = printers.get(i);
                PrinterInfo oldPrinter = this.mPrinters.put(printer.getId(), printer);
                if (oldPrinter != null && oldPrinter.equals(printer)) continue;
                if (addedPrinters == null) {
                    addedPrinters = new ArrayList<PrinterInfo>();
                }
                addedPrinters.add(printer);
            }
            if (addedPrinters != null) {
                this.mSessionHandler.obtainMessage(3, addedPrinters).sendToTarget();
            }
        }

        public void onPrintersRemovedLocked(List<PrinterId> printerIds) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not removing printers - session destroyed");
                return;
            }
            ArrayList<PrinterId> removedPrinterIds = null;
            int removedPrinterCount = printerIds.size();
            for (int i = 0; i < removedPrinterCount; ++i) {
                PrinterId removedPrinterId = printerIds.get(i);
                if (this.mPrinters.remove(removedPrinterId) == null) continue;
                if (removedPrinterIds == null) {
                    removedPrinterIds = new ArrayList<PrinterId>();
                }
                removedPrinterIds.add(removedPrinterId);
            }
            if (removedPrinterIds != null) {
                this.mSessionHandler.obtainMessage(4, removedPrinterIds).sendToTarget();
            }
        }

        public void onServiceRemovedLocked(RemotePrintService service) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not updating removed service - session destroyed");
                return;
            }
            ComponentName serviceName = service.getComponentName();
            this.removePrintersForServiceLocked(serviceName);
            service.destroy();
        }

        public void onCustomPrinterIconLoadedLocked(PrinterId printerId) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not updating printer - session destroyed");
                return;
            }
            PrinterInfo printer = this.mPrinters.get(printerId);
            if (printer != null) {
                PrinterInfo newPrinter = new PrinterInfo.Builder(printer).incCustomPrinterIconGen().build();
                this.mPrinters.put(printerId, newPrinter);
                ArrayList<PrinterInfo> addedPrinters = new ArrayList<PrinterInfo>(1);
                addedPrinters.add(newPrinter);
                this.mSessionHandler.obtainMessage(3, addedPrinters).sendToTarget();
            }
        }

        public void onServiceDiedLocked(RemotePrintService service) {
            UserState.this.removeServiceLocked(service);
        }

        public void onServiceAddedLocked(RemotePrintService service) {
            if (this.mIsDestroyed) {
                Log.w(UserState.LOG_TAG, "Not updating added service - session destroyed");
                return;
            }
            this.mSessionHandler.obtainMessage(5, service).sendToTarget();
            if (!this.mStartedPrinterDiscoveryTokens.isEmpty()) {
                this.mSessionHandler.obtainMessage(7, service).sendToTarget();
            }
            int trackedPrinterCount = this.mStateTrackedPrinters.size();
            for (int i = 0; i < trackedPrinterCount; ++i) {
                PrinterId printerId = this.mStateTrackedPrinters.get(i);
                if (!printerId.getServiceName().equals(service.getComponentName())) continue;
                SomeArgs args = SomeArgs.obtain();
                args.arg1 = service;
                args.arg2 = printerId;
                this.mSessionHandler.obtainMessage(14, args).sendToTarget();
            }
        }

        public void dump(PrintWriter pw, String prefix) {
            pw.append(prefix).append("destroyed=").append(String.valueOf(UserState.this.mDestroyed)).println();
            pw.append(prefix).append("printDiscoveryInProgress=").append(String.valueOf(!this.mStartedPrinterDiscoveryTokens.isEmpty())).println();
            String tab = "  ";
            pw.append(prefix).append(tab).append("printer discovery observers:").println();
            int observerCount = this.mDiscoveryObservers.beginBroadcast();
            for (int i = 0; i < observerCount; ++i) {
                IPrinterDiscoveryObserver observer = this.mDiscoveryObservers.getBroadcastItem(i);
                pw.append(prefix).append(prefix).append(observer.toString());
                pw.println();
            }
            this.mDiscoveryObservers.finishBroadcast();
            pw.append(prefix).append(tab).append("start discovery requests:").println();
            int tokenCount = this.mStartedPrinterDiscoveryTokens.size();
            for (int i = 0; i < tokenCount; ++i) {
                IBinder token = this.mStartedPrinterDiscoveryTokens.get(i);
                pw.append(prefix).append(tab).append(tab).append(token.toString()).println();
            }
            pw.append(prefix).append(tab).append("tracked printer requests:").println();
            int trackedPrinters = this.mStateTrackedPrinters.size();
            for (int i = 0; i < trackedPrinters; ++i) {
                PrinterId printer = this.mStateTrackedPrinters.get(i);
                pw.append(prefix).append(tab).append(tab).append(printer.toString()).println();
            }
            pw.append(prefix).append(tab).append("printers:").println();
            int pritnerCount = this.mPrinters.size();
            for (int i = 0; i < pritnerCount; ++i) {
                PrinterInfo printer = this.mPrinters.valueAt(i);
                pw.append(prefix).append(tab).append(tab).append(printer.toString()).println();
            }
        }

        private void removePrintersForServiceLocked(ComponentName serviceName) {
            if (this.mPrinters.isEmpty()) {
                return;
            }
            ArrayList<PrinterId> removedPrinterIds = null;
            int printerCount = this.mPrinters.size();
            for (int i = 0; i < printerCount; ++i) {
                PrinterId printerId = this.mPrinters.keyAt(i);
                if (!printerId.getServiceName().equals(serviceName)) continue;
                if (removedPrinterIds == null) {
                    removedPrinterIds = new ArrayList<PrinterId>();
                }
                removedPrinterIds.add(printerId);
            }
            if (removedPrinterIds != null) {
                int removedPrinterCount = removedPrinterIds.size();
                for (int i = 0; i < removedPrinterCount; ++i) {
                    this.mPrinters.remove(removedPrinterIds.get(i));
                }
                this.mSessionHandler.obtainMessage(4, removedPrinterIds).sendToTarget();
            }
        }

        private void handleDispatchPrintersAdded(List<PrinterInfo> addedPrinters) {
            int observerCount = this.mDiscoveryObservers.beginBroadcast();
            for (int i = 0; i < observerCount; ++i) {
                IPrinterDiscoveryObserver observer = this.mDiscoveryObservers.getBroadcastItem(i);
                this.handlePrintersAdded(observer, addedPrinters);
            }
            this.mDiscoveryObservers.finishBroadcast();
        }

        private void handleDispatchPrintersRemoved(List<PrinterId> removedPrinterIds) {
            int observerCount = this.mDiscoveryObservers.beginBroadcast();
            for (int i = 0; i < observerCount; ++i) {
                IPrinterDiscoveryObserver observer = this.mDiscoveryObservers.getBroadcastItem(i);
                this.handlePrintersRemoved(observer, removedPrinterIds);
            }
            this.mDiscoveryObservers.finishBroadcast();
        }

        private void handleDispatchCreatePrinterDiscoverySession(List<RemotePrintService> services) {
            int serviceCount = services.size();
            for (int i = 0; i < serviceCount; ++i) {
                RemotePrintService service = services.get(i);
                service.createPrinterDiscoverySession();
            }
        }

        private void handleDispatchDestroyPrinterDiscoverySession(List<RemotePrintService> services) {
            int serviceCount = services.size();
            for (int i = 0; i < serviceCount; ++i) {
                RemotePrintService service = services.get(i);
                service.destroyPrinterDiscoverySession();
            }
            this.onDestroyed();
        }

        private void handleDispatchStartPrinterDiscovery(List<RemotePrintService> services, List<PrinterId> printerIds) {
            int serviceCount = services.size();
            for (int i = 0; i < serviceCount; ++i) {
                RemotePrintService service = services.get(i);
                service.startPrinterDiscovery(printerIds);
            }
        }

        private void handleDispatchStopPrinterDiscovery(List<RemotePrintService> services) {
            int serviceCount = services.size();
            for (int i = 0; i < serviceCount; ++i) {
                RemotePrintService service = services.get(i);
                service.stopPrinterDiscovery();
            }
        }

        private void handleValidatePrinters(RemotePrintService service, List<PrinterId> printerIds) {
            service.validatePrinters(printerIds);
        }

        private void handleStartPrinterStateTracking(RemotePrintService service, PrinterId printerId) {
            service.startPrinterStateTracking(printerId);
        }

        private void handleStopPrinterStateTracking(RemotePrintService service, PrinterId printerId) {
            service.stopPrinterStateTracking(printerId);
        }

        private void handlePrintersAdded(IPrinterDiscoveryObserver observer, List<PrinterInfo> printers) {
            try {
                observer.onPrintersAdded(new ParceledListSlice<PrinterInfo>(printers));
            }
            catch (RemoteException re) {
                Log.e(UserState.LOG_TAG, "Error sending added printers", re);
            }
        }

        private void handlePrintersRemoved(IPrinterDiscoveryObserver observer, List<PrinterId> printerIds) {
            try {
                observer.onPrintersRemoved(new ParceledListSlice<PrinterId>(printerIds));
            }
            catch (RemoteException re) {
                Log.e(UserState.LOG_TAG, "Error sending removed printers", re);
            }
        }

        private final class SessionHandler
        extends Handler {
            public static final int MSG_PRINTERS_ADDED = 1;
            public static final int MSG_PRINTERS_REMOVED = 2;
            public static final int MSG_DISPATCH_PRINTERS_ADDED = 3;
            public static final int MSG_DISPATCH_PRINTERS_REMOVED = 4;
            public static final int MSG_CREATE_PRINTER_DISCOVERY_SESSION = 5;
            public static final int MSG_DESTROY_PRINTER_DISCOVERY_SESSION = 6;
            public static final int MSG_START_PRINTER_DISCOVERY = 7;
            public static final int MSG_STOP_PRINTER_DISCOVERY = 8;
            public static final int MSG_DISPATCH_CREATE_PRINTER_DISCOVERY_SESSION = 9;
            public static final int MSG_DISPATCH_DESTROY_PRINTER_DISCOVERY_SESSION = 10;
            public static final int MSG_DISPATCH_START_PRINTER_DISCOVERY = 11;
            public static final int MSG_DISPATCH_STOP_PRINTER_DISCOVERY = 12;
            public static final int MSG_VALIDATE_PRINTERS = 13;
            public static final int MSG_START_PRINTER_STATE_TRACKING = 14;
            public static final int MSG_STOP_PRINTER_STATE_TRACKING = 15;
            public static final int MSG_DESTROY_SERVICE = 16;

            SessionHandler(Looper looper) {
                super(looper, null, false);
            }

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    case 1: {
                        SomeArgs args = (SomeArgs)message.obj;
                        IPrinterDiscoveryObserver observer = (IPrinterDiscoveryObserver)args.arg1;
                        List addedPrinters = (List)args.arg2;
                        args.recycle();
                        PrinterDiscoverySessionMediator.this.handlePrintersAdded(observer, addedPrinters);
                        break;
                    }
                    case 2: {
                        SomeArgs args = (SomeArgs)message.obj;
                        IPrinterDiscoveryObserver observer = (IPrinterDiscoveryObserver)args.arg1;
                        List removedPrinterIds = (List)args.arg2;
                        args.recycle();
                        PrinterDiscoverySessionMediator.this.handlePrintersRemoved(observer, removedPrinterIds);
                    }
                    case 3: {
                        List addedPrinters = (List)message.obj;
                        PrinterDiscoverySessionMediator.this.handleDispatchPrintersAdded(addedPrinters);
                        break;
                    }
                    case 4: {
                        List removedPrinterIds = (List)message.obj;
                        PrinterDiscoverySessionMediator.this.handleDispatchPrintersRemoved(removedPrinterIds);
                        break;
                    }
                    case 5: {
                        RemotePrintService service = (RemotePrintService)message.obj;
                        service.createPrinterDiscoverySession();
                        break;
                    }
                    case 6: {
                        RemotePrintService service = (RemotePrintService)message.obj;
                        service.destroyPrinterDiscoverySession();
                        break;
                    }
                    case 7: {
                        RemotePrintService service = (RemotePrintService)message.obj;
                        service.startPrinterDiscovery(null);
                        break;
                    }
                    case 8: {
                        RemotePrintService service = (RemotePrintService)message.obj;
                        service.stopPrinterDiscovery();
                        break;
                    }
                    case 9: {
                        List services = (List)message.obj;
                        PrinterDiscoverySessionMediator.this.handleDispatchCreatePrinterDiscoverySession(services);
                        break;
                    }
                    case 10: {
                        List services = (List)message.obj;
                        PrinterDiscoverySessionMediator.this.handleDispatchDestroyPrinterDiscoverySession(services);
                        break;
                    }
                    case 11: {
                        SomeArgs args = (SomeArgs)message.obj;
                        List services = (List)args.arg1;
                        List printerIds = (List)args.arg2;
                        args.recycle();
                        PrinterDiscoverySessionMediator.this.handleDispatchStartPrinterDiscovery(services, printerIds);
                        break;
                    }
                    case 12: {
                        List services = (List)message.obj;
                        PrinterDiscoverySessionMediator.this.handleDispatchStopPrinterDiscovery(services);
                        break;
                    }
                    case 13: {
                        SomeArgs args = (SomeArgs)message.obj;
                        RemotePrintService service = (RemotePrintService)args.arg1;
                        List printerIds = (List)args.arg2;
                        args.recycle();
                        PrinterDiscoverySessionMediator.this.handleValidatePrinters(service, printerIds);
                        break;
                    }
                    case 14: {
                        SomeArgs args = (SomeArgs)message.obj;
                        RemotePrintService service = (RemotePrintService)args.arg1;
                        PrinterId printerId = (PrinterId)args.arg2;
                        args.recycle();
                        PrinterDiscoverySessionMediator.this.handleStartPrinterStateTracking(service, printerId);
                        break;
                    }
                    case 15: {
                        SomeArgs args = (SomeArgs)message.obj;
                        RemotePrintService service = (RemotePrintService)args.arg1;
                        PrinterId printerId = (PrinterId)args.arg2;
                        args.recycle();
                        PrinterDiscoverySessionMediator.this.handleStopPrinterStateTracking(service, printerId);
                        break;
                    }
                    case 16: {
                        RemotePrintService service = (RemotePrintService)message.obj;
                        service.destroy();
                    }
                }
            }
        }
    }

    private static abstract class ListenerRecord<T extends IInterface>
    implements IBinder.DeathRecipient {
        final T listener;
        final /* synthetic */ UserState this$0;

        public ListenerRecord(T listener) throws RemoteException {
            this.this$0 = var1_1;
            this.listener = listener;
            listener.asBinder().linkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            this.listener.asBinder().unlinkToDeath(this, 0);
            this.onBinderDied();
        }

        public abstract void onBinderDied();
    }

    private abstract class PrintJobStateChangeListenerRecord
    implements IBinder.DeathRecipient {
        final IPrintJobStateChangeListener listener;
        final int appId;

        public PrintJobStateChangeListenerRecord(IPrintJobStateChangeListener listener, int appId) throws RemoteException {
            this.listener = listener;
            this.appId = appId;
            listener.asBinder().linkToDeath(this, 0);
        }

        @Override
        public void binderDied() {
            this.listener.asBinder().unlinkToDeath(this, 0);
            this.onBinderDied();
        }

        public abstract void onBinderDied();
    }

    private final class UserStateHandler
    extends Handler {
        public static final int MSG_DISPATCH_PRINT_JOB_STATE_CHANGED = 1;
        public static final int MSG_DISPATCH_PRINT_SERVICES_CHANGED = 2;
        public static final int MSG_DISPATCH_PRINT_SERVICES_RECOMMENDATIONS_UPDATED = 3;
        public static final int MSG_CHECK_CONFIG_CHANGED = 4;

        public UserStateHandler(Looper looper) {
            super(looper, null, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    PrintJobId printJobId = (PrintJobId)message.obj;
                    int appId = message.arg1;
                    UserState.this.handleDispatchPrintJobStateChanged(printJobId, appId);
                    break;
                }
                case 2: {
                    UserState.this.handleDispatchPrintServicesChanged();
                    break;
                }
                case 3: {
                    UserState.this.handleDispatchPrintServiceRecommendationsUpdated((List)message.obj);
                    break;
                }
                case 4: {
                    Object object = UserState.this.mLock;
                    synchronized (object) {
                        UserState.this.onConfigurationChangedLocked();
                        break;
                    }
                }
            }
        }
    }
}

