/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.storage;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Environment;
import android.os.FileObserver;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.ShellCallback;
import android.os.ShellCommand;
import android.os.UserHandle;
import android.os.storage.StorageManager;
import android.os.storage.VolumeInfo;
import android.util.ArrayMap;
import android.util.Slog;
import com.android.internal.notification.SystemNotificationChannels;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.IndentingPrintWriter;
import com.android.server.EventLogTags;
import com.android.server.SystemService;
import com.android.server.pm.InstructionSets;
import com.android.server.pm.PackageManagerService;
import com.android.server.storage.DeviceStorageMonitorInternal;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class DeviceStorageMonitorService
extends SystemService {
    private static final String TAG = "DeviceStorageMonitorService";
    public static final String EXTRA_SEQUENCE = "seq";
    private static final int MSG_CHECK = 1;
    private static final long DEFAULT_LOG_DELTA_BYTES = 0x4000000L;
    private static final long DEFAULT_CHECK_INTERVAL = 60000L;
    private static final long BOOT_IMAGE_STORAGE_REQUIREMENT = 0xFA00000L;
    private NotificationManager mNotifManager;
    private final AtomicInteger mSeq = new AtomicInteger(1);
    private volatile int mForceLevel = -1;
    private final ArrayMap<UUID, State> mStates = new ArrayMap();
    private CacheFileDeletedObserver mCacheFileDeletedObserver;
    static final String SERVICE = "devicestoragemonitor";
    private static final String TV_NOTIFICATION_CHANNEL_ID = "devicestoragemonitor.tv";
    private final HandlerThread mHandlerThread;
    private final Handler mHandler;
    private final DeviceStorageMonitorInternal mLocalService = new DeviceStorageMonitorInternal(){

        @Override
        public void checkMemory() {
            DeviceStorageMonitorService.this.mHandler.removeMessages(1);
            DeviceStorageMonitorService.this.mHandler.obtainMessage(1).sendToTarget();
        }

        @Override
        public boolean isMemoryLow() {
            return Environment.getDataDirectory().getUsableSpace() < this.getMemoryLowThreshold();
        }

        @Override
        public long getMemoryLowThreshold() {
            return DeviceStorageMonitorService.this.getContext().getSystemService(StorageManager.class).getStorageLowBytes(Environment.getDataDirectory());
        }
    };
    private final Binder mRemoteService = new Binder(){

        @Override
        protected void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            if (!DumpUtils.checkDumpPermission(DeviceStorageMonitorService.this.getContext(), DeviceStorageMonitorService.TAG, pw)) {
                return;
            }
            DeviceStorageMonitorService.this.dumpImpl(fd, pw, args);
        }

        @Override
        public void onShellCommand(FileDescriptor in, FileDescriptor out, FileDescriptor err, String[] args, ShellCallback callback, ResultReceiver resultReceiver) {
            new Shell().exec(this, in, out, err, args, callback, resultReceiver);
        }
    };
    static final int OPTION_FORCE_UPDATE = 1;

    private State findOrCreateState(UUID uuid) {
        State state = this.mStates.get(uuid);
        if (state == null) {
            state = new State();
            this.mStates.put(uuid, state);
        }
        return state;
    }

    private void check() {
        StorageManager storage = this.getContext().getSystemService(StorageManager.class);
        int seq = this.mSeq.get();
        for (VolumeInfo vol : storage.getWritablePrivateVolumes()) {
            int newLevel;
            File file = vol.getPath();
            long fullBytes = storage.getStorageFullBytes(file);
            long lowBytes = storage.getStorageLowBytes(file);
            if (file.getUsableSpace() < lowBytes * 3L / 2L) {
                PackageManagerService pms = (PackageManagerService)ServiceManager.getService("package");
                try {
                    pms.freeStorage(vol.getFsUuid(), lowBytes * 2L, 0);
                }
                catch (IOException e) {
                    Slog.w(TAG, e);
                }
            }
            UUID uuid = StorageManager.convert(vol.getFsUuid());
            State state = this.findOrCreateState(uuid);
            long totalBytes = file.getTotalSpace();
            long usableBytes = file.getUsableSpace();
            int oldLevel = state.level;
            if (this.mForceLevel != -1) {
                oldLevel = -1;
                newLevel = this.mForceLevel;
            } else {
                newLevel = usableBytes <= fullBytes ? 2 : (usableBytes <= lowBytes ? 1 : (StorageManager.UUID_DEFAULT.equals(uuid) && !DeviceStorageMonitorService.isBootImageOnDisk() && usableBytes < 0xFA00000L ? 1 : 0));
            }
            if (Math.abs(state.lastUsableBytes - usableBytes) > 0x4000000L || oldLevel != newLevel) {
                EventLogTags.writeStorageState(uuid.toString(), oldLevel, newLevel, usableBytes, totalBytes);
                state.lastUsableBytes = usableBytes;
            }
            this.updateNotifications(vol, oldLevel, newLevel);
            this.updateBroadcasts(vol, oldLevel, newLevel, seq);
            state.level = newLevel;
        }
        if (!this.mHandler.hasMessages(1)) {
            this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), 60000L);
        }
    }

    public DeviceStorageMonitorService(Context context) {
        super(context);
        this.mHandlerThread = new HandlerThread(TAG, 10);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper()){

            @Override
            public void handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        DeviceStorageMonitorService.this.check();
                        return;
                    }
                }
            }
        };
    }

    private static boolean isBootImageOnDisk() {
        for (String instructionSet : InstructionSets.getAllDexCodeInstructionSets()) {
            if (VMRuntime.isBootClassPathOnDisk(instructionSet)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onStart() {
        Context context = this.getContext();
        this.mNotifManager = context.getSystemService(NotificationManager.class);
        this.mCacheFileDeletedObserver = new CacheFileDeletedObserver();
        this.mCacheFileDeletedObserver.startWatching();
        PackageManager packageManager = context.getPackageManager();
        boolean isTv = packageManager.hasSystemFeature("android.software.leanback");
        if (isTv) {
            this.mNotifManager.createNotificationChannel(new NotificationChannel(TV_NOTIFICATION_CHANNEL_ID, context.getString(17039764), 4));
        }
        this.publishBinderService(SERVICE, this.mRemoteService);
        this.publishLocalService(DeviceStorageMonitorInternal.class, this.mLocalService);
        this.mHandler.removeMessages(1);
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    int parseOptions(Shell shell) {
        String opt;
        int opts = 0;
        while ((opt = shell.getNextOption()) != null) {
            if (!"-f".equals(opt)) continue;
            opts |= 1;
        }
        return opts;
    }

    int onShellCommand(Shell shell, String cmd) {
        if (cmd == null) {
            return shell.handleDefaultCommands(cmd);
        }
        PrintWriter pw = shell.getOutPrintWriter();
        switch (cmd) {
            case "force-low": {
                int opts = this.parseOptions(shell);
                this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                this.mForceLevel = 1;
                int seq = this.mSeq.incrementAndGet();
                if ((opts & 1) == 0) break;
                this.mHandler.removeMessages(1);
                this.mHandler.obtainMessage(1).sendToTarget();
                pw.println(seq);
                break;
            }
            case "force-not-low": {
                int opts = this.parseOptions(shell);
                this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                this.mForceLevel = 0;
                int seq = this.mSeq.incrementAndGet();
                if ((opts & 1) == 0) break;
                this.mHandler.removeMessages(1);
                this.mHandler.obtainMessage(1).sendToTarget();
                pw.println(seq);
                break;
            }
            case "reset": {
                int opts = this.parseOptions(shell);
                this.getContext().enforceCallingOrSelfPermission("android.permission.DEVICE_POWER", null);
                this.mForceLevel = -1;
                int seq = this.mSeq.incrementAndGet();
                if ((opts & 1) == 0) break;
                this.mHandler.removeMessages(1);
                this.mHandler.obtainMessage(1).sendToTarget();
                pw.println(seq);
                break;
            }
            default: {
                return shell.handleDefaultCommands(cmd);
            }
        }
        return 0;
    }

    static void dumpHelp(PrintWriter pw) {
        pw.println("Device storage monitor service (devicestoragemonitor) commands:");
        pw.println("  help");
        pw.println("    Print this help text.");
        pw.println("  force-low [-f]");
        pw.println("    Force storage to be low, freezing storage state.");
        pw.println("    -f: force a storage change broadcast be sent, prints new sequence.");
        pw.println("  force-not-low [-f]");
        pw.println("    Force storage to not be low, freezing storage state.");
        pw.println("    -f: force a storage change broadcast be sent, prints new sequence.");
        pw.println("  reset [-f]");
        pw.println("    Unfreeze storage state, returning to current real values.");
        pw.println("    -f: force a storage change broadcast be sent, prints new sequence.");
    }

    void dumpImpl(FileDescriptor fd, PrintWriter _pw, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)_pw, "  ");
        if (args == null || args.length == 0 || "-a".equals(args[0])) {
            pw.println("Known volumes:");
            pw.increaseIndent();
            for (int i = 0; i < this.mStates.size(); ++i) {
                UUID uuid = this.mStates.keyAt(i);
                State state = this.mStates.valueAt(i);
                if (StorageManager.UUID_DEFAULT.equals(uuid)) {
                    pw.println("Default:");
                } else {
                    pw.println(uuid + ":");
                }
                pw.increaseIndent();
                pw.printPair("level", State.levelToString(state.level));
                pw.printPair("lastUsableBytes", state.lastUsableBytes);
                pw.println();
                pw.decreaseIndent();
            }
            pw.decreaseIndent();
            pw.println();
            pw.printPair("mSeq", this.mSeq.get());
            pw.printPair("mForceState", State.levelToString(this.mForceLevel));
            pw.println();
            pw.println();
        } else {
            Shell shell = new Shell();
            shell.exec(this.mRemoteService, null, fd, null, args, null, new ResultReceiver(null));
        }
    }

    private void updateNotifications(VolumeInfo vol, int oldLevel, int newLevel) {
        Context context = this.getContext();
        UUID uuid = StorageManager.convert(vol.getFsUuid());
        if (State.isEntering(1, oldLevel, newLevel)) {
            Intent lowMemIntent = new Intent("android.os.storage.action.MANAGE_STORAGE");
            lowMemIntent.putExtra("android.os.storage.extra.UUID", uuid);
            lowMemIntent.addFlags(0x10000000);
            CharSequence title = context.getText(17040139);
            CharSequence details = StorageManager.UUID_DEFAULT.equals(uuid) ? context.getText(DeviceStorageMonitorService.isBootImageOnDisk() ? 17040137 : 17040138) : context.getText(17040137);
            PendingIntent intent = PendingIntent.getActivityAsUser(context, 0, lowMemIntent, 0, null, UserHandle.CURRENT);
            Notification notification = new Notification.Builder(context, SystemNotificationChannels.ALERTS).setSmallIcon(17303419).setTicker(title).setColor(context.getColor(17170763)).setContentTitle(title).setContentText(details).setContentIntent(intent).setStyle(new Notification.BigTextStyle().bigText(details)).setVisibility(1).setCategory("sys").extend(new Notification.TvExtender().setChannelId(TV_NOTIFICATION_CHANNEL_ID)).build();
            notification.flags |= 0x20;
            this.mNotifManager.notifyAsUser(uuid.toString(), 23, notification, UserHandle.ALL);
        } else if (State.isLeaving(1, oldLevel, newLevel)) {
            this.mNotifManager.cancelAsUser(uuid.toString(), 23, UserHandle.ALL);
        }
    }

    private void updateBroadcasts(VolumeInfo vol, int oldLevel, int newLevel, int seq) {
        if (!Objects.equals(StorageManager.UUID_PRIVATE_INTERNAL, vol.getFsUuid())) {
            return;
        }
        Intent lowIntent = new Intent("android.intent.action.DEVICE_STORAGE_LOW").addFlags(0x5200000).putExtra(EXTRA_SEQUENCE, seq);
        Intent notLowIntent = new Intent("android.intent.action.DEVICE_STORAGE_OK").addFlags(0x5200000).putExtra(EXTRA_SEQUENCE, seq);
        if (State.isEntering(1, oldLevel, newLevel)) {
            this.getContext().sendStickyBroadcastAsUser(lowIntent, UserHandle.ALL);
        } else if (State.isLeaving(1, oldLevel, newLevel)) {
            this.getContext().removeStickyBroadcastAsUser(lowIntent, UserHandle.ALL);
            this.getContext().sendBroadcastAsUser(notLowIntent, UserHandle.ALL);
        }
        Intent fullIntent = new Intent("android.intent.action.DEVICE_STORAGE_FULL").addFlags(0x4000000).putExtra(EXTRA_SEQUENCE, seq);
        Intent notFullIntent = new Intent("android.intent.action.DEVICE_STORAGE_NOT_FULL").addFlags(0x4000000).putExtra(EXTRA_SEQUENCE, seq);
        if (State.isEntering(2, oldLevel, newLevel)) {
            this.getContext().sendStickyBroadcastAsUser(fullIntent, UserHandle.ALL);
        } else if (State.isLeaving(2, oldLevel, newLevel)) {
            this.getContext().removeStickyBroadcastAsUser(fullIntent, UserHandle.ALL);
            this.getContext().sendBroadcastAsUser(notFullIntent, UserHandle.ALL);
        }
    }

    private static class CacheFileDeletedObserver
    extends FileObserver {
        public CacheFileDeletedObserver() {
            super(Environment.getDownloadCacheDirectory().getAbsolutePath(), 512);
        }

        @Override
        public void onEvent(int event, String path) {
            EventLogTags.writeCacheFileDeleted(path);
        }
    }

    class Shell
    extends ShellCommand {
        Shell() {
        }

        @Override
        public int onCommand(String cmd) {
            return DeviceStorageMonitorService.this.onShellCommand(this, cmd);
        }

        @Override
        public void onHelp() {
            PrintWriter pw = this.getOutPrintWriter();
            DeviceStorageMonitorService.dumpHelp(pw);
        }
    }

    private static class State {
        private static final int LEVEL_UNKNOWN = -1;
        private static final int LEVEL_NORMAL = 0;
        private static final int LEVEL_LOW = 1;
        private static final int LEVEL_FULL = 2;
        public int level = 0;
        public long lastUsableBytes = Long.MAX_VALUE;

        private State() {
        }

        private static boolean isEntering(int level, int oldLevel, int newLevel) {
            return newLevel >= level && (oldLevel < level || oldLevel == -1);
        }

        private static boolean isLeaving(int level, int oldLevel, int newLevel) {
            return newLevel < level && (oldLevel >= level || oldLevel == -1);
        }

        private static String levelToString(int level) {
            switch (level) {
                case -1: {
                    return "UNKNOWN";
                }
                case 0: {
                    return "NORMAL";
                }
                case 1: {
                    return "LOW";
                }
                case 2: {
                    return "FULL";
                }
            }
            return Integer.toString(level);
        }
    }
}

