/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.usb.descriptors;

import com.android.server.usb.descriptors.ByteStream;
import com.android.server.usb.descriptors.UsbASFormat;
import com.android.server.usb.descriptors.report.ReportCanvas;

public final class Usb10ASFormatII
extends UsbASFormat {
    private static final String TAG = "Usb10ASFormatII";
    private int mMaxBitRate;
    private int mSamplesPerFrame;
    private byte mSamFreqType;
    private int[] mSampleRates;

    public Usb10ASFormatII(int length, byte type, byte subtype, byte formatType, byte subclass) {
        super(length, type, subtype, formatType, subclass);
    }

    public int getMaxBitRate() {
        return this.mMaxBitRate;
    }

    public int getSamplesPerFrame() {
        return this.mSamplesPerFrame;
    }

    public byte getSamFreqType() {
        return this.mSamFreqType;
    }

    @Override
    public int[] getSampleRates() {
        return this.mSampleRates;
    }

    @Override
    public int parseRawDescriptors(ByteStream stream) {
        this.mMaxBitRate = stream.unpackUsbShort();
        this.mSamplesPerFrame = stream.unpackUsbShort();
        this.mSamFreqType = stream.getByte();
        int numFreqs = this.mSamFreqType == 0 ? 2 : (int)this.mSamFreqType;
        this.mSampleRates = new int[numFreqs];
        for (int index = 0; index < numFreqs; ++index) {
            this.mSampleRates[index] = stream.unpackUsbTriple();
        }
        return this.mLength;
    }

    @Override
    public void report(ReportCanvas canvas) {
        super.report(canvas);
        canvas.openList();
        canvas.writeListItem("Max Bit Rate: " + this.getMaxBitRate());
        canvas.writeListItem("Samples Per Frame: " + this.getMaxBitRate());
        int sampleFreqType = this.getSamFreqType();
        int[] sampleRates = this.getSampleRates();
        canvas.writeListItem("Sample Freq Type: " + sampleFreqType);
        canvas.openList();
        if (sampleFreqType == 0) {
            canvas.writeListItem("min: " + sampleRates[0]);
            canvas.writeListItem("max: " + sampleRates[1]);
        } else {
            for (int index = 0; index < sampleFreqType; ++index) {
                canvas.writeListItem("" + sampleRates[index]);
            }
        }
        canvas.closeList();
        canvas.closeList();
    }
}

